/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"jwt-refresh-hint1", "jwt-refresh-hint2", "jwt-refresh-hint3", "jwt-refresh-hint4"})
public class JWTRefreshEndpoint
implements AssignmentEndpoint {
    public static final String PASSWORD = "bm5nhSkxCXZkKRy4";
    private static final String JWT_PASSWORD = "bm5n3SkxCX4kKRy4";
    private static final List<String> validRefreshTokens = new ArrayList();

    @PostMapping(value={"/JWT/refresh/login"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity follow(@RequestBody(required=false) Map<String, Object> json) {
        if (json == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        String user = (String)json.get("user");
        String password = (String)json.get("password");
        if ("Jerry".equalsIgnoreCase(user) && PASSWORD.equals(password)) {
            return ResponseEntity.ok((Object)this.createNewTokens(user));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
    }

    private Map<String, Object> createNewTokens(String user) {
        Map<String, String> claims = Map.of("admin", "false", "user", user);
        String token = Jwts.builder().setIssuedAt(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toDays(10L))).setClaims(claims).signWith(SignatureAlgorithm.HS512, JWT_PASSWORD).compact();
        HashMap<String, Object> tokenJson = new HashMap<String, Object>();
        String refreshToken = RandomStringUtils.randomAlphabetic((int)20);
        validRefreshTokens.add(refreshToken);
        tokenJson.put("access_token", token);
        tokenJson.put("refresh_token", refreshToken);
        return tokenJson;
    }

    @PostMapping(value={"/JWT/refresh/checkout"})
    @ResponseBody
    public ResponseEntity<AttackResult> checkout(@RequestHeader(value="Authorization", required=false) String token) {
        if (token == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        try {
            Jwt jwt = Jwts.parser().setSigningKey(JWT_PASSWORD).parse(token.replace("Bearer ", ""));
            Claims claims = (Claims)jwt.getBody();
            String user = (String)claims.get((Object)"user");
            if ("Tom".equals(user)) {
                if ("none".equals(jwt.getHeader().get((Object)"alg"))) {
                    return ResponseEntity.ok((Object)AttackResultBuilder.success((AssignmentEndpoint)this).feedback("jwt-refresh-alg-none").build());
                }
                return ResponseEntity.ok((Object)AttackResultBuilder.success((AssignmentEndpoint)this).build());
            }
            return ResponseEntity.ok((Object)AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-refresh-not-tom").feedbackArgs(new Object[]{user}).build());
        }
        catch (ExpiredJwtException e) {
            return ResponseEntity.ok((Object)AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build());
        }
        catch (JwtException e) {
            return ResponseEntity.ok((Object)AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").build());
        }
    }

    @PostMapping(value={"/JWT/refresh/newToken"})
    @ResponseBody
    public ResponseEntity newToken(@RequestHeader(value="Authorization", required=false) String token, @RequestBody(required=false) Map<String, Object> json) {
        String refreshToken;
        String user;
        if (token == null || json == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        try {
            Jwt jwt = Jwts.parser().setSigningKey(JWT_PASSWORD).parse(token.replace("Bearer ", ""));
            user = (String)((Claims)jwt.getBody()).get((Object)"user");
            refreshToken = (String)json.get("refresh_token");
        }
        catch (ExpiredJwtException e) {
            user = (String)e.getClaims().get((Object)"user");
            refreshToken = (String)json.get("refresh_token");
        }
        if (user == null || refreshToken == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        if (validRefreshTokens.contains(refreshToken)) {
            validRefreshTokens.remove(refreshToken);
            return ResponseEntity.ok((Object)this.createNewTokens(user));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
    }
}

