/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.idor;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.owasp.webgoat.lessons.idor.UserProfile;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"idor.hints.otherProfile1", "idor.hints.otherProfile2", "idor.hints.otherProfile3", "idor.hints.otherProfile4", "idor.hints.otherProfile5", "idor.hints.otherProfile6", "idor.hints.otherProfile7", "idor.hints.otherProfile8", "idor.hints.otherProfile9"})
public class IDOREditOtherProfile
implements AssignmentEndpoint {
    private final LessonSession userSessionData;

    public IDOREditOtherProfile(LessonSession lessonSession) {
        this.userSessionData = lessonSession;
    }

    @PutMapping(path={"/IDOR/profile/{userId}"}, consumes={"application/json"})
    @ResponseBody
    public AttackResult completed(@PathVariable(value="userId") String userId, @RequestBody UserProfile userSubmittedProfile) {
        String authUserId = (String)this.userSessionData.getValue("idor-authenticated-user-id");
        UserProfile currentUserProfile = new UserProfile(userId);
        if (userSubmittedProfile.getUserId() != null && !userSubmittedProfile.getUserId().equals(authUserId)) {
            currentUserProfile.setColor(userSubmittedProfile.getColor());
            currentUserProfile.setRole(userSubmittedProfile.getRole());
            this.userSessionData.setValue("idor-updated-other-profile", (Object)currentUserProfile);
            if (currentUserProfile.getRole() <= 1 && currentUserProfile.getColor().equalsIgnoreCase("red")) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("idor.edit.profile.success1").output(currentUserProfile.profileToMap().toString()).build();
            }
            if (currentUserProfile.getRole() > 1 && currentUserProfile.getColor().equalsIgnoreCase("red")) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.edit.profile.failure1").output(currentUserProfile.profileToMap().toString()).build();
            }
            if (currentUserProfile.getRole() <= 1 && !currentUserProfile.getColor().equalsIgnoreCase("red")) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.edit.profile.failure2").output(currentUserProfile.profileToMap().toString()).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.edit.profile.failure3").output(currentUserProfile.profileToMap().toString()).build();
        }
        if (userSubmittedProfile.getUserId() != null && userSubmittedProfile.getUserId().equals(authUserId)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.edit.profile.failure4").build();
        }
        if (currentUserProfile.getColor().equals("black") && currentUserProfile.getRole() <= 1) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("idor.edit.profile.success2").output(this.userSessionData.getValue("idor-updated-own-profile").toString()).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.edit.profile.failure3").build();
    }
}

