/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.csrf;

import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"csrf-login-hint1", "csrf-login-hint2", "csrf-login-hint3"})
public class CSRFLogin
implements AssignmentEndpoint {
    @PostMapping(path={"/csrf/login"}, produces={"application/json"})
    @ResponseBody
    public AttackResult completed(@CurrentUsername String username) {
        if (username.startsWith("csrf")) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("csrf-login-success").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("csrf-login-failed").feedbackArgs(new Object[]{username}).build();
    }
}

