/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.csrf;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"csrf-feedback-hint1", "csrf-feedback-hint2", "csrf-feedback-hint3"})
public class CSRFFeedback
implements AssignmentEndpoint {
    private final LessonSession userSessionData;
    private final ObjectMapper objectMapper;

    public CSRFFeedback(LessonSession userSessionData, ObjectMapper objectMapper) {
        this.userSessionData = userSessionData;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/csrf/feedback/message"}, produces={"application/json"})
    @ResponseBody
    public AttackResult completed(HttpServletRequest request, @RequestBody String feedback) {
        boolean correctCSRF;
        try {
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES);
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
            this.objectMapper.readValue(feedback.getBytes(), Map.class);
        }
        catch (IOException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback(ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        boolean bl = correctCSRF = this.requestContainsWebGoatCookie(request.getCookies()) && request.getContentType().contains("text/plain");
        if (correctCSRF &= this.hostOrRefererDifferentHost(request)) {
            String flag = UUID.randomUUID().toString();
            this.userSessionData.setValue("csrf-feedback", (Object)flag);
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("csrf-feedback-success").feedbackArgs(new Object[]{flag}).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    @PostMapping(path={"/csrf/feedback"}, produces={"application/json"})
    @ResponseBody
    public AttackResult flag(@RequestParam(value="confirmFlagVal") String flag) {
        if (flag.equals(this.userSessionData.getValue("csrf-feedback"))) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    private boolean hostOrRefererDifferentHost(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        String host = request.getHeader("Host");
        if (referer != null) {
            return !referer.contains(host);
        }
        return true;
    }

    private boolean requestContainsWebGoatCookie(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals("JSESSIONID")) continue;
                return true;
            }
        }
        return false;
    }
}

