/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.csrf;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"csrf-get.hint1", "csrf-get.hint2", "csrf-get.hint3", "csrf-get.hint4"})
public class CSRFConfirmFlag1
implements AssignmentEndpoint {
    private final LessonSession userSessionData;

    public CSRFConfirmFlag1(LessonSession userSessionData) {
        this.userSessionData = userSessionData;
    }

    @PostMapping(path={"/csrf/confirm-flag-1"}, produces={"application/json"})
    @ResponseBody
    public AttackResult completed(String confirmFlagVal) {
        Object userSessionDataStr = this.userSessionData.getValue("csrf-get-success");
        if (userSessionDataStr != null && confirmFlagVal.equals(userSessionDataStr.toString())) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("csrf-get-null-referer.success").output("Correct, the flag was " + String.valueOf(this.userSessionData.getValue("csrf-get-success"))).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }
}

