/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.cryptography;

import java.security.NoSuchAlgorithmException;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.cryptography.HashingAssignment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"crypto-secure-defaults.hints.1", "crypto-secure-defaults.hints.2", "crypto-secure-defaults.hints.3"})
public class SecureDefaultsAssignment
implements AssignmentEndpoint {
    @PostMapping(value={"/crypto/secure/defaults"})
    @ResponseBody
    public AttackResult completed(@RequestParam String secretFileName, @RequestParam String secretText) throws NoSuchAlgorithmException {
        if (secretFileName != null && secretFileName.equals("default_secret")) {
            if (secretText != null && HashingAssignment.getHash((String)secretText, (String)"SHA-256").equalsIgnoreCase("34de66e5caf2cb69ff2bebdc1f3091ecf6296852446c718e38ebfa60e4aa75d2")) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("crypto-secure-defaults.success").build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-secure-defaults.messagenotok").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-secure-defaults.notok").build();
    }
}

