/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.cryptography;

import jakarta.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@AssignmentHints(value={"crypto-hashing.hints.1", "crypto-hashing.hints.2"})
public class HashingAssignment
implements AssignmentEndpoint {
    public static final String[] SECRETS = new String[]{"secret", "admin", "password", "123456", "passw0rd"};

    @RequestMapping(path={"/crypto/hashing/md5"}, produces={"text/html"})
    @ResponseBody
    public String getMd5(HttpServletRequest request) throws NoSuchAlgorithmException {
        String md5Hash = (String)request.getSession().getAttribute("md5Hash");
        if (md5Hash == null) {
            String secret = SECRETS[new Random().nextInt(SECRETS.length)];
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(secret.getBytes());
            byte[] digest = md.digest();
            md5Hash = DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
            request.getSession().setAttribute("md5Hash", (Object)md5Hash);
            request.getSession().setAttribute("md5Secret", (Object)secret);
        }
        return md5Hash;
    }

    @RequestMapping(path={"/crypto/hashing/sha256"}, produces={"text/html"})
    @ResponseBody
    public String getSha256(HttpServletRequest request) throws NoSuchAlgorithmException {
        String sha256 = (String)request.getSession().getAttribute("sha256");
        if (sha256 == null) {
            String secret = SECRETS[new Random().nextInt(SECRETS.length)];
            sha256 = HashingAssignment.getHash((String)secret, (String)"SHA-256");
            request.getSession().setAttribute("sha256Hash", (Object)sha256);
            request.getSession().setAttribute("sha256Secret", (Object)secret);
        }
        return sha256;
    }

    @PostMapping(value={"/crypto/hashing"})
    @ResponseBody
    public AttackResult completed(HttpServletRequest request, @RequestParam String answer_pwd1, @RequestParam String answer_pwd2) {
        String md5Secret = (String)request.getSession().getAttribute("md5Secret");
        String sha256Secret = (String)request.getSession().getAttribute("sha256Secret");
        if (answer_pwd1 != null && answer_pwd2 != null) {
            if (answer_pwd1.equals(md5Secret) && answer_pwd2.equals(sha256Secret)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("crypto-hashing.success").build();
            }
            if (answer_pwd1.equals(md5Secret) || answer_pwd2.equals(sha256Secret)) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-hashing.oneok").build();
            }
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-hashing.empty").build();
    }

    public static String getHash(String secret, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(secret.getBytes());
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
    }
}

