/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.cryptography;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CryptoUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    private static final BigInteger[] FERMAT_PRIMES = new BigInteger[]{BigInteger.valueOf(3L), BigInteger.valueOf(5L), BigInteger.valueOf(17L), BigInteger.valueOf(257L), BigInteger.valueOf(65537L)};

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        RSAKeyGenParameterSpec kpgSpec = new RSAKeyGenParameterSpec(2048, FERMAT_PRIMES[new SecureRandom().nextInt(FERMAT_PRIMES.length)]);
        keyPairGenerator.initialize(kpgSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static String getPrivateKeyInPEM(KeyPair keyPair) {
        Object encodedString = "-----BEGIN PRIVATE KEY-----\n";
        encodedString = (String)encodedString + new String(Base64.getEncoder().encode(keyPair.getPrivate().getEncoded()), Charset.forName("UTF-8")) + "\n";
        encodedString = (String)encodedString + "-----END PRIVATE KEY-----\n";
        return encodedString;
    }

    public static String signMessage(String message, PrivateKey privateKey) {
        log.debug("start signMessage");
        String signature = null;
        try {
            Signature instance = Signature.getInstance("SHA256withRSA");
            instance.initSign(privateKey);
            instance.update(message.getBytes("UTF-8"));
            signature = new String(Base64.getEncoder().encode(instance.sign()), Charset.forName("UTF-8"));
            log.info("signe the signature with result: {}", (Object)signature);
        }
        catch (Exception e) {
            log.error("Signature signing failed", (Throwable)e);
        }
        log.debug("end signMessage");
        return signature;
    }

    public static boolean verifyMessage(String message, String base64EncSignature, PublicKey publicKey) {
        log.debug("start verifyMessage");
        boolean result = false;
        try {
            base64EncSignature = base64EncSignature.replace("\r", "").replace("\n", "").replace(" ", "");
            byte[] decodedSignature = Base64.getDecoder().decode(base64EncSignature);
            Signature instance = Signature.getInstance("SHA256withRSA");
            instance.initVerify(publicKey);
            instance.update(message.getBytes("UTF-8"));
            result = instance.verify(decodedSignature);
            log.info("Verified the signature with result: {}", (Object)result);
        }
        catch (Exception e) {
            log.error("Signature verification failed", (Throwable)e);
        }
        log.debug("end verifyMessage");
        return result;
    }

    public static boolean verifyAssignment(String modulus, String signature, PublicKey publicKey) {
        boolean result = false;
        if (modulus != null && signature != null) {
            result = CryptoUtil.verifyMessage((String)modulus, (String)signature, (PublicKey)publicKey);
            RSAPublicKey rsaPubKey = (RSAPublicKey)publicKey;
            if (modulus.length() == 512) {
                modulus = "00".concat(modulus);
            }
            result = result && DatatypeConverter.printHexBinary((byte[])rsaPubKey.getModulus().toByteArray()).equals(modulus.toUpperCase());
        }
        return result;
    }

    public static PrivateKey getPrivateKeyFromPEM(String privateKeyPem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        privateKeyPem = privateKeyPem.replace("-----BEGIN PRIVATE KEY-----", "");
        privateKeyPem = privateKeyPem.replace("-----END PRIVATE KEY-----", "");
        privateKeyPem = privateKeyPem.replace("\n", "").replace("\r", "");
        byte[] decoded = Base64.getDecoder().decode(privateKeyPem);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }
}

