/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.clientsidefiltering;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.owasp.webgoat.lessons.clientsidefiltering.ShopEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clientSideFiltering/challenge-store"})
public class ShopEndpoint {
    private CheckoutCodes checkoutCodes;

    public ShopEndpoint() {
        ArrayList codes = Lists.newArrayList();
        codes.add(new CheckoutCode(this, "webgoat", 25));
        codes.add(new CheckoutCode(this, "owasp", 25));
        codes.add(new CheckoutCode(this, "owasp-webgoat", 50));
        this.checkoutCodes = new CheckoutCodes(this, (List)codes);
    }

    @GetMapping(value={"/coupons/{code}"}, produces={"application/json"})
    public CheckoutCode getDiscountCode(@PathVariable String code) {
        if ("get_it_for_free".equals(code)) {
            return new CheckoutCode(this, "get_it_for_free", 100);
        }
        return this.checkoutCodes.get(code).orElse(new CheckoutCode(this, "no", 0));
    }

    @GetMapping(value={"/coupons"}, produces={"application/json"})
    public CheckoutCodes all() {
        ArrayList all = Lists.newArrayList();
        all.addAll(this.checkoutCodes.getCodes());
        all.add(new CheckoutCode(this, "get_it_for_free", 100));
        return new CheckoutCodes(this, (List)all);
    }
}

