/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.cia;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CIAQuiz
implements AssignmentEndpoint {
    private final String[] solutions = new String[]{"Solution 3", "Solution 1", "Solution 4", "Solution 2"};
    boolean[] guesses = new boolean[this.solutions.length];

    @PostMapping(value={"/cia/quiz"})
    @ResponseBody
    public AttackResult completed(@RequestParam String[] question_0_solution, @RequestParam String[] question_1_solution, @RequestParam String[] question_2_solution, @RequestParam String[] question_3_solution) {
        int correctAnswers = 0;
        String[] givenAnswers = new String[]{question_0_solution[0], question_1_solution[0], question_2_solution[0], question_3_solution[0]};
        for (int i = 0; i < this.solutions.length; ++i) {
            if (givenAnswers[i].contains(this.solutions[i])) {
                ++correctAnswers;
                this.guesses[i] = true;
                continue;
            }
            this.guesses[i] = false;
        }
        if (correctAnswers == this.solutions.length) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    @GetMapping(value={"/cia/quiz"})
    @ResponseBody
    public boolean[] getResults() {
        return this.guesses;
    }
}

