/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.challenges.challenge7;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import lombok.Generated;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.challenges.Email;
import org.owasp.webgoat.lessons.challenges.Flags;
import org.owasp.webgoat.lessons.challenges.challenge7.PasswordResetLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class Assignment7
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Assignment7.class);
    public static final String ADMIN_PASSWORD_LINK = "375afe1104f4a487a73823c50a9292a2";
    private static final String TEMPLATE = "Hi, you requested a password reset link, please use this <a target='_blank' href='%s:8080/WebGoat/challenge/7/reset-password/%s'>link</a> to reset your password.\n \n\nIf you did not request this password change you can ignore this message.\nIf you have any comments or questions, please do not hesitate to reach us at support@webgoat-cloud.org\n\nKind regards, \nTeam WebGoat";
    private final Flags flags;
    private final RestTemplate restTemplate;
    private final String webWolfMailURL;

    public Assignment7(Flags flags, RestTemplate restTemplate, @Value(value="${webwolf.mail.url}") String webWolfMailURL) {
        this.flags = flags;
        this.restTemplate = restTemplate;
        this.webWolfMailURL = webWolfMailURL;
    }

    @GetMapping(value={"/challenge/7/reset-password/{link}"})
    public ResponseEntity<String> resetPassword(@PathVariable(value="link") String link) {
        if (link.equals(ADMIN_PASSWORD_LINK)) {
            return ResponseEntity.accepted().body((Object)("<h1>Success!!</h1><img src='/WebGoat/images/hi-five-cat.jpg'><br/><br/>Here is your flag: " + String.valueOf(this.flags.getFlag(7))));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.I_AM_A_TEAPOT).body((Object)"That is not the reset link for admin");
    }

    @PostMapping(value={"/challenge/7"})
    @ResponseBody
    public AttackResult sendPasswordResetLink(@RequestParam String email, HttpServletRequest request) throws URISyntaxException {
        String username;
        if (StringUtils.hasText((String)email) && StringUtils.hasText((String)(username = email.substring(0, email.indexOf("@"))))) {
            URI uri = new URI(request.getRequestURL().toString());
            Email mail = Email.builder().title("Your password reset link for challenge 7").contents(String.format(TEMPLATE, uri.getScheme() + "://" + uri.getHost(), new PasswordResetLink().createPasswordReset(username, "webgoat"))).sender("password-reset@webgoat-cloud.net").recipient(username).time(LocalDateTime.now()).build();
            this.restTemplate.postForEntity(this.webWolfMailURL, (Object)mail, Object.class, new Object[0]);
        }
        return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("email.send").feedbackArgs(new Object[]{email}).build();
    }

    @GetMapping(value={"/challenge/7/.git"}, produces={"application/octet-stream"})
    @ResponseBody
    public ClassPathResource git() {
        return new ClassPathResource("lessons/challenges/challenge7/git.zip");
    }
}

