/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.challenges;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.challenges.Flag;
import org.owasp.webgoat.lessons.challenges.Flags;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FlagController
implements AssignmentEndpoint {
    private final Flags flags;

    public FlagController(Flags flags) {
        this.flags = flags;
    }

    @PostMapping(path={"/challenge/flag/{flagNumber}"})
    @ResponseBody
    public AttackResult postFlag(@PathVariable int flagNumber, @RequestParam String flag) {
        Flag expectedFlag = this.flags.getFlag(flagNumber);
        if (expectedFlag.isCorrect(flag)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("challenge.flag.correct").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("challenge.flag.incorrect").build();
    }
}

