/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.authbypass;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.owasp.webgoat.lessons.authbypass.AccountVerificationHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"auth-bypass.hints.verify.1", "auth-bypass.hints.verify.2", "auth-bypass.hints.verify.3", "auth-bypass.hints.verify.4"})
public class VerifyAccount
implements AssignmentEndpoint {
    private final LessonSession userSessionData;

    public VerifyAccount(LessonSession userSessionData) {
        this.userSessionData = userSessionData;
    }

    @PostMapping(path={"/auth-bypass/verify-account"}, produces={"application/json"})
    @ResponseBody
    public AttackResult completed(@RequestParam String userId, @RequestParam String verifyMethod, HttpServletRequest req) throws ServletException, IOException {
        AccountVerificationHelper verificationHelper = new AccountVerificationHelper();
        HashMap submittedAnswers = this.parseSecQuestions(req);
        if (verificationHelper.didUserLikelylCheat(submittedAnswers)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("verify-account.cheated").output("Yes, you guessed correctly, but see the feedback message").build();
        }
        if (verificationHelper.verifyAccount(Integer.valueOf(userId), submittedAnswers)) {
            this.userSessionData.setValue("account-verified-id", (Object)userId);
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("verify-account.success").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("verify-account.failed").build();
    }

    private HashMap<String, String> parseSecQuestions(HttpServletRequest req) {
        HashMap<String, String> userAnswers = new HashMap<String, String>();
        ArrayList<String> paramNames = Collections.list(req.getParameterNames());
        for (String paramName : paramNames) {
            if (!paramName.contains("secQuestion")) continue;
            userAnswers.put(paramName, req.getParameter(paramName));
        }
        return userAnswers;
    }
}

