/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
public class WebGoatUser
implements UserDetails {
    public static final String ROLE_USER = "WEBGOAT_USER";
    public static final String ROLE_ADMIN = "WEBGOAT_ADMIN";
    @Id
    private String username;
    private String password;
    private String role = "WEBGOAT_USER";
    @Transient
    private User user;

    protected WebGoatUser() {
    }

    public WebGoatUser(String username, String password) {
        this(username, password, ROLE_USER);
    }

    public WebGoatUser(String username, String password, String role) {
        this.username = username;
        this.password = password;
        this.role = role;
        this.createUser();
    }

    public void createUser() {
        this.user = new User(this.username, this.password, this.getAuthorities());
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singleton(new SimpleGrantedAuthority(this.getRole()));
    }

    public String getRole() {
        return this.role;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAccountNonExpired() {
        return this.user.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.user.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.user.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof WebGoatUser)) return false;
        WebGoatUser webGoatUser = (WebGoatUser)obj;
        if (!this.user.equals((Object)webGoatUser.user)) return false;
        return true;
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    @Generated
    public User getUser() {
        return this.user;
    }
}

