/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import lombok.Generated;
import org.owasp.webgoat.container.users.UserForm;
import org.owasp.webgoat.container.users.UserRepository;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class UserValidator
implements Validator {
    private final UserRepository userRepository;

    public boolean supports(Class<?> clazz) {
        return UserForm.class.equals(clazz);
    }

    public void validate(Object o, Errors errors) {
        UserForm userForm = (UserForm)o;
        if (this.userRepository.findByUsername(userForm.getUsername()) != null) {
            errors.rejectValue("username", "username.duplicate");
        }
        if (!userForm.getMatchingPassword().equals(userForm.getPassword())) {
            errors.rejectValue("matchingPassword", "password.diff");
        }
    }

    @Generated
    public UserValidator(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

