/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.UUID;
import lombok.Generated;
import org.owasp.webgoat.container.users.UserForm;
import org.owasp.webgoat.container.users.UserService;
import org.owasp.webgoat.container.users.UserValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class RegistrationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistrationController.class);
    private final UserValidator userValidator;
    private final UserService userService;

    @GetMapping(value={"/registration"})
    public String showForm(UserForm userForm) {
        return "registration";
    }

    @PostMapping(value={"/register.mvc"})
    public String registration(@ModelAttribute(value="userForm") @Valid UserForm userForm, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.userValidator.validate((Object)userForm, (Errors)bindingResult);
        if (bindingResult.hasErrors()) {
            return "registration";
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        this.userService.addUser(userForm.getUsername(), userForm.getPassword());
        request.login(userForm.getUsername(), userForm.getPassword());
        return "redirect:/attack";
    }

    @GetMapping(value={"/login-oauth.mvc"})
    public String registrationOAUTH(Authentication authentication, HttpServletRequest request) throws ServletException {
        log.info("register oauth user in database");
        this.userService.addUser(authentication.getName(), UUID.randomUUID().toString());
        return "redirect:/welcome.mvc";
    }

    @Generated
    public RegistrationController(UserValidator userValidator, UserService userService) {
        this.userValidator = userValidator;
        this.userService = userService;
    }
}

