/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.users.AssignmentProgress;

@Entity
public class LessonProgress {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String lessonName;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private final Set<AssignmentProgress> assignments = new HashSet();
    private int numberOfAttempts = 0;
    @Version
    private Integer version;

    protected LessonProgress() {
    }

    public LessonProgress(Lesson lesson) {
        this.lessonName = lesson.getId();
        this.assignments.addAll(lesson.getAssignments().stream().map(AssignmentProgress::new).toList());
    }

    private Optional<AssignmentProgress> getAssignment(String name) {
        return this.assignments.stream().filter(a -> a.hasSameName(name)).findFirst();
    }

    public void assignmentSolved(String solvedAssignment) {
        this.getAssignment(solvedAssignment).ifPresent(AssignmentProgress::solved);
    }

    public boolean isLessonSolved() {
        return this.assignments.stream().allMatch(AssignmentProgress::isSolved);
    }

    public void incrementAttempts() {
        ++this.numberOfAttempts;
    }

    void reset() {
        this.assignments.forEach(AssignmentProgress::reset);
    }

    public Map<AssignmentProgress, Boolean> getLessonOverview() {
        return this.assignments.stream().collect(Collectors.toMap(a -> a, AssignmentProgress::isSolved));
    }

    long numberOfSolvedAssignments() {
        return this.assignments.size();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LessonProgress)) {
            return false;
        }
        LessonProgress other = (LessonProgress)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getNumberOfAttempts() != other.getNumberOfAttempts()) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.version;
        Integer other$version = other.version;
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$lessonName = this.getLessonName();
        String other$lessonName = other.getLessonName();
        if (this$lessonName == null ? other$lessonName != null : !this$lessonName.equals(other$lessonName)) {
            return false;
        }
        Set this$assignments = this.assignments;
        Set other$assignments = other.assignments;
        return !(this$assignments == null ? other$assignments != null : !((Object)this$assignments).equals(other$assignments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LessonProgress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfAttempts();
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.version;
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $lessonName = this.getLessonName();
        result = result * 59 + ($lessonName == null ? 43 : $lessonName.hashCode());
        Set $assignments = this.assignments;
        result = result * 59 + ($assignments == null ? 43 : ((Object)$assignments).hashCode());
        return result;
    }

    @Generated
    public String getLessonName() {
        return this.lessonName;
    }

    @Generated
    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }
}

