/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import lombok.Generated;
import org.owasp.webgoat.container.lessons.Assignment;
import org.springframework.util.Assert;

@Entity
public class AssignmentProgress {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne(cascade={CascadeType.ALL})
    private Assignment assignment;
    private boolean solved;

    protected AssignmentProgress() {
    }

    public AssignmentProgress(Assignment assignment) {
        this.assignment = assignment;
    }

    public boolean hasSameName(String name) {
        Assert.notNull((Object)name, (String)"Name cannot be null");
        return this.assignment.getName().equals(name);
    }

    public void solved() {
        this.solved = true;
    }

    public void reset() {
        this.solved = false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentProgress)) {
            return false;
        }
        AssignmentProgress other = (AssignmentProgress)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSolved() != other.isSolved()) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Assignment this$assignment = this.getAssignment();
        Assignment other$assignment = other.getAssignment();
        return !(this$assignment == null ? other$assignment != null : !this$assignment.equals(other$assignment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssignmentProgress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSolved() ? 79 : 97);
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Assignment $assignment = this.getAssignment();
        result = result * 59 + ($assignment == null ? 43 : $assignment.hashCode());
        return result;
    }

    @Generated
    public Assignment getAssignment() {
        return this.assignment;
    }

    @Generated
    public boolean isSolved() {
        return this.solved;
    }
}

