/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.service;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.owasp.webgoat.container.CurrentUser;
import org.owasp.webgoat.container.lessons.Initializable;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.lessons.LessonName;
import org.owasp.webgoat.container.session.Course;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class RestartLessonService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestartLessonService.class);
    private final Course course;
    private final UserProgressRepository userTrackerRepository;
    private final Function<String, Flyway> flywayLessons;
    private final List<Initializable> lessonsToInitialize;

    @GetMapping(path={"/service/restartlesson.mvc/{lesson}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void restartLesson(@PathVariable(value="lesson") LessonName lessonName, @CurrentUser WebGoatUser user) {
        Lesson lesson = this.course.getLessonByName(lessonName);
        UserProgress userTracker = this.userTrackerRepository.findByUser(user.getUsername());
        userTracker.reset(lesson);
        this.userTrackerRepository.save((Object)userTracker);
        Flyway flyway = (Flyway)this.flywayLessons.apply(user.getUsername());
        flyway.clean();
        flyway.migrate();
        this.lessonsToInitialize.forEach(i -> i.initialize(user));
    }

    @Generated
    public RestartLessonService(Course course, UserProgressRepository userTrackerRepository, Function<String, Flyway> flywayLessons, List<Initializable> lessonsToInitialize) {
        this.course = course;
        this.userTrackerRepository = userTrackerRepository;
        this.flywayLessons = flywayLessons;
        this.lessonsToInitialize = lessonsToInitialize;
    }
}

