/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.i18n;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.owasp.webgoat.container.i18n.Language;
import org.owasp.webgoat.container.i18n.Messages;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class PluginMessages
extends ReloadableResourceBundleMessageSource {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private final Language language;
    private final ResourcePatternResolver resourcePatternResolver;

    public PluginMessages(Messages messages, Language language, ResourcePatternResolver resourcePatternResolver) {
        this.language = language;
        this.setParentMessageSource((MessageSource)messages);
        this.setBasename("WebGoatLabels");
        this.resourcePatternResolver = resourcePatternResolver;
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder refreshProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        Properties properties = new Properties();
        long lastModified = System.currentTimeMillis();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources("classpath:/lessons/**/i18n/WebGoatLabels.properties")) {
                String sourcePath = resource.getURI().toString().replace(PROPERTIES_SUFFIX, "");
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = super.refreshProperties(sourcePath, propHolder);
                properties.putAll((Map<?, ?>)holder.getProperties());
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to read plugin message", (Throwable)e);
        }
        return new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, lastModified);
    }

    public Properties getMessages() {
        return this.getMergedProperties(this.language.getLocale()).getProperties();
    }

    public String getMessage(String code, Object ... args) {
        return this.getMessage(code, args, this.language.getLocale());
    }

    public String getMessage(String code, String defaultValue, Object ... args) {
        return super.getMessage(code, args, defaultValue, this.language.getLocale());
    }
}

