/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import lombok.Generated;
import org.owasp.webgoat.container.AjaxAuthenticationEntryPoint;
import org.owasp.webgoat.container.users.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private final UserService userDetailsService;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/favicon.ico", "/css/**", "/images/**", "/js/**", "fonts/**", "/plugins/**", "/registration", "/register.mvc", "/actuator/**"})).permitAll().anyRequest()).authenticated()).formLogin(login -> ((FormLoginConfigurer)login.loginPage("/login").defaultSuccessUrl("/welcome.mvc", true)).usernameParameter("username").passwordParameter("password").permitAll()).oauth2Login(oidc -> {
            oidc.defaultSuccessUrl("/login-oauth.mvc");
            oidc.loginPage("/login");
        }).logout(logout -> logout.deleteCookies(new String[]{"JSESSIONID"}).invalidateHttpSession(true)).csrf(csrf -> csrf.disable()).headers(headers -> headers.disable()).exceptionHandling(handling -> handling.authenticationEntryPoint((AuthenticationEntryPoint)new AjaxAuthenticationEntryPoint("/login"))).build();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsService);
    }

    @Bean
    @Primary
    public UserDetailsService userDetailsServiceBean() {
        return this.userDetailsService;
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    public NoOpPasswordEncoder passwordEncoder() {
        return (NoOpPasswordEncoder)NoOpPasswordEncoder.getInstance();
    }

    @Generated
    public WebSecurityConfig(UserService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

