/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import lombok.Generated;
import org.owasp.webgoat.container.AsciiDoctorTemplateResolver;
import org.owasp.webgoat.container.LessonResourceScanner;
import org.owasp.webgoat.container.LessonTemplateResolver;
import org.owasp.webgoat.container.MvcConfiguration;
import org.owasp.webgoat.container.UserInterceptor;
import org.owasp.webgoat.container.i18n.Language;
import org.owasp.webgoat.container.i18n.Messages;
import org.owasp.webgoat.container.i18n.PluginMessages;
import org.owasp.webgoat.container.session.LabelDebugger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.springsecurity6.dialect.SpringSecurityDialect;
import org.thymeleaf.spring6.ISpringTemplateEngine;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class MvcConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfiguration.class);
    private static final String UTF8 = "UTF-8";
    private final LessonResourceScanner lessonScanner;

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/login").setViewName("login");
        registry.addViewController("/lesson_content").setViewName("lesson_content");
        registry.addViewController("/start.mvc").setViewName("main_new");
        registry.addViewController("/scoreboard").setViewName("scoreboard");
    }

    @Bean
    public ViewResolver viewResolver(SpringTemplateEngine thymeleafTemplateEngine) {
        ThymeleafViewResolver resolver = new ThymeleafViewResolver();
        resolver.setTemplateEngine((ISpringTemplateEngine)thymeleafTemplateEngine);
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        return resolver;
    }

    @Bean
    public ITemplateResolver lessonThymeleafTemplateResolver(ResourceLoader resourceLoader) {
        1 resolver = new /* Unavailable Anonymous Inner Class!! */;
        resolver.setOrder(Integer.valueOf(1));
        return resolver;
    }

    @Bean
    public ITemplateResolver springThymeleafTemplateResolver(ApplicationContext applicationContext) {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setPrefix("classpath:/webgoat/templates/");
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setOrder(Integer.valueOf(2));
        resolver.setCharacterEncoding(UTF8);
        resolver.setApplicationContext(applicationContext);
        return resolver;
    }

    @Bean
    public LessonTemplateResolver lessonTemplateResolver(ResourceLoader resourceLoader) {
        LessonTemplateResolver resolver = new LessonTemplateResolver(resourceLoader);
        resolver.setOrder(Integer.valueOf(0));
        resolver.setCacheable(false);
        resolver.setCharacterEncoding(UTF8);
        return resolver;
    }

    @Bean
    public AsciiDoctorTemplateResolver asciiDoctorTemplateResolver(Language language, ResourceLoader resourceLoader) {
        log.debug("template locale {}", (Object)language);
        AsciiDoctorTemplateResolver resolver = new AsciiDoctorTemplateResolver(language, resourceLoader);
        resolver.setCacheable(false);
        resolver.setOrder(Integer.valueOf(1));
        resolver.setCharacterEncoding(UTF8);
        return resolver;
    }

    @Bean
    public SpringTemplateEngine thymeleafTemplateEngine(ITemplateResolver springThymeleafTemplateResolver, LessonTemplateResolver lessonTemplateResolver, AsciiDoctorTemplateResolver asciiDoctorTemplateResolver, ITemplateResolver lessonThymeleafTemplateResolver) {
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setEnableSpringELCompiler(true);
        engine.addDialect((IDialect)new SpringSecurityDialect());
        engine.setTemplateResolvers(Set.of(lessonTemplateResolver, asciiDoctorTemplateResolver, lessonThymeleafTemplateResolver, springThymeleafTemplateResolver));
        return engine;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"classpath:/webgoat/static/css/"});
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/webgoat/static/js/"});
        registry.addResourceHandler(new String[]{"/plugins/**"}).addResourceLocations(new String[]{"classpath:/webgoat/static/plugins/"});
        registry.addResourceHandler(new String[]{"/fonts/**"}).addResourceLocations(new String[]{"classpath:/webgoat/static/fonts/"});
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations((String[])this.lessonScanner.applyPattern("classpath:/lessons/%s/images/").toArray(String[]::new));
        registry.addResourceHandler(new String[]{"/lesson_js/**"}).addResourceLocations((String[])this.lessonScanner.applyPattern("classpath:/lessons/%s/js/").toArray(String[]::new));
        registry.addResourceHandler(new String[]{"/lesson_css/**"}).addResourceLocations((String[])this.lessonScanner.applyPattern("classpath:/lessons/%s/css/").toArray(String[]::new));
        registry.addResourceHandler(new String[]{"/lesson_templates/**"}).addResourceLocations((String[])this.lessonScanner.applyPattern("classpath:/lessons/%s/templates/").toArray(String[]::new));
        registry.addResourceHandler(new String[]{"/video/**"}).addResourceLocations((String[])this.lessonScanner.applyPattern("classpath:/lessons/%s/video/").toArray(String[]::new));
    }

    @Bean
    public PluginMessages pluginMessages(Messages messages, Language language, ResourcePatternResolver resourcePatternResolver) {
        PluginMessages pluginMessages = new PluginMessages(messages, language, resourcePatternResolver);
        pluginMessages.setDefaultEncoding(UTF8);
        pluginMessages.setBasenames(new String[]{"i18n/WebGoatLabels"});
        pluginMessages.setFallbackToSystemLocale(false);
        return pluginMessages;
    }

    @Bean
    public Language language(LocaleResolver localeResolver) {
        return new Language(localeResolver);
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        return localeResolver;
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
        registry.addInterceptor((HandlerInterceptor)new UserInterceptor());
    }

    @Bean
    public Messages messageSource(Language language) {
        Messages messages = new Messages(language);
        messages.setDefaultEncoding(UTF8);
        messages.setBasename("classpath:i18n/messages");
        messages.setFallbackToSystemLocale(false);
        return messages;
    }

    @Bean
    public LabelDebugger labelDebugger() {
        return new LabelDebugger();
    }

    @Generated
    public MvcConfiguration(LessonResourceScanner lessonScanner) {
        this.lessonScanner = lessonScanner;
    }
}

