/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class LessonTemplateResolver
extends FileTemplateResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LessonTemplateResolver.class);
    private static final String PREFIX = "lesson:";
    private final ResourceLoader resourceLoader;
    private final Map<String, byte[]> resources = new HashMap();

    public LessonTemplateResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.setResolvablePatterns(Set.of("lesson:*"));
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        String templateName = resourceName.substring(PREFIX.length());
        byte[] resource = (byte[])this.resources.get(templateName);
        if (resource == null) {
            try {
                resource = this.resourceLoader.getResource("classpath:/" + templateName).getInputStream().readAllBytes();
            }
            catch (IOException e) {
                log.error("Unable to find lesson HTML: {}", (Object)template);
            }
            this.resources.put(templateName, resource);
        }
        return new StringTemplateResource(new String(resource, StandardCharsets.UTF_8));
    }
}

