--
-- Export all playable skill gems from game data
--
local out = io.open("../Export/Skills/SkillGems.txt", "w")
out:write('-- This file is automatically generated, do not edit!\n')
out:write('-- Gem data (c) Grinding Gear Games\n\n')

local export = false

local types = { "Strength", "Dexterity", "Intelligence", "Other" }

local function grantedEffectString(grantedEffect) 
	local s =  "#skill "..grantedEffect.Id.."\n"
	for _, statSet in ipairs(grantedEffect.GrantedEffectStatSets) do
		if not (statSet.LabelType and statSet.LabelType.Id == "Hidden") then
			s = s.."#set "..statSet.Id.."\n#flags\n#mods\n"
		end
	end
	return s
end
for i, _ in ipairs(types) do
	local active = {}
	local support = {}
	local activeExport = {}
	local supportExport = {}
	local colour
	for skillGem in dat("SkillGems"):Rows() do
		for _, gemEffect in ipairs(skillGem.GemVariants) do
			if skillGem.Str >= 50 then
				colour = "Strength"
			elseif skillGem.Int >= 50 then
				colour = "Intelligence"
			elseif skillGem.Dex >= 50 then
				colour = "Dexterity"
			else
				colour = "Other"
			end
			if skillGem.IsSupport then
				local gemName = skillGem.BaseItemType.Name
				local gemId = gemEffect.Id
				if skillGem.GemColour == i and not gemId:match("Unknown") and not gemId:match("Playtest") and not gemId:match("Royale") and not gemName:match("DNT") and not gemName:match("UNUSED") and not gemName:match("NOT CURRENTLY USED") and not gemName:match("WIP") and not gemName:match("Unnamed") then
					local temp = skillGem.BaseItemType.Name..string.rep(" ", 45 - string.len(skillGem.BaseItemType.Name)).."\t\t----\t\t"..gemEffect.GrantedEffect.Id
					local temp1 = skillGem.BaseItemType.Name..grantedEffectString(gemEffect.GrantedEffect)
					if gemEffect.GrantedEffect2 then
						temp = temp.."\t"..gemEffect.GrantedEffect2.Id
						temp1 = temp1..grantedEffectString(gemEffect.GrantedEffect2)
					end
					table.insert(support, temp)
					table.insert(supportExport, temp1)
				end
			else
				local gemName = gemEffect.GrantedEffect.ActiveSkill.DisplayName
				local gemId = gemEffect.Id
				 if gemName ~= "" and types[i] == colour and not gemId:match("Unknown") and not gemId:match("Playtest") and not gemId:match("Royale") and not gemName:match("%.%.%.") and not gemName:match("DNT") and not gemName:match("UNUSED") and not gemName:match("NOT CURRENTLY USED") and not gemName:match("Unnamed") and not gemEffect.GrantedEffect.Id:match("HardMode") and not skillGem.BaseItemType.Name:match("DNT") 
				 and not (skillGem.IsVaalGem and gemEffect.Variant ~= 4) then
					local temp = gemName..string.rep(" ", 45 - string.len(gemName)).."\t\t----\t\t"..gemEffect.GrantedEffect.Id
					local temp1 = gemName..grantedEffectString(gemEffect.GrantedEffect)
				 	if gemEffect.GrantedEffect2 and not skillGem.IsVaalGem then
						temp = temp.."\t"..gemEffect.GrantedEffect2.Id
						temp1 = temp1..grantedEffectString(gemEffect.GrantedEffect2)
					end
					table.insert(active, temp)
					table.insert(activeExport, temp1)
				end
			end
		end
	end
	table.sort(active)
	table.sort(support)
	table.sort(supportExport)
	table.sort(activeExport)
	
	for i, row in ipairs(supportExport) do
		-- Remove text before "#skill" only if it is at the start of the string
		supportExport[i] = string.gsub(row, "^(.-)#skill", "#skill")
	end
	for i, row in ipairs(activeExport) do
		-- Remove text before "#skill" only if it is at the start of the string
		activeExport[i] = string.gsub(row, "^(.-)#skill", "#skill")
	end
	
	out:write("\t\t\t\t\t\t--------- Active "..types[i].." ---------\n")
	if export == false then
		out:write(table.concat(active, "\n"))
	else
		out:write(table.concat(activeExport, "\n"))
	end
	out:write('\n\n')
	out:write("\t\t\t\t\t\t--------- Support "..types[i].." ---------\n")
	if export == false then
		out:write(table.concat(support, "\n"))
	else
		out:write(table.concat(supportExport, "\n"))
	end
	out:write('\n\n')
end

out:close()

print("Skill gems exported.")
