if not table.containsId then
	dofile("Scripts/mods.lua")
end
dofile("Scripts/flavourText.lua")

local foulbornMods = LoadModule("../Data/ModFoulborn.lua")
local uniques = LoadModule("../Data/FlavourText.lua")
local finalUniqueMap = { }
local out = io.open("../Data/ModFoulbornMap.lua", "w")
out:write('-- This file is automatically generated, do not edit!\n')
out:write('-- Item data (c) Grinding Gear Games\n\nreturn {\n')

for _, unique in ipairs(uniques) do
	local uniqueName = unique.name
	for modId, mod in pairsSortByKey(foulbornMods) do
		if modId:match(unique.id .. "%a+") then
			if not finalUniqueMap[uniqueName] then
				finalUniqueMap[uniqueName] = {}
			end
			table.insert(finalUniqueMap[uniqueName], mod)
		end
	end
end

for uniqueName, modList in pairsSortByKey(finalUniqueMap) do
	out:write('\t["', uniqueName, '"] = {\n')
	for _, mod in ipairs(modList) do
		out:write('\t\t"', table.concat(mod, " "), '",\n')
	end
	out:write('\t},\n')
end
out:write('}\n')
out:close()

print("Foulborn mod map updated.")
