-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Active Strength skill gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["Absolution"] = {
	name = "Absolution",
	baseTypeName = "Absolution",
	color = 1,
	baseEffectiveness = 2.0517001152039,
	incrementalEffectiveness = 0.043200001120567,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 0.75,
	minionList = {
		"AbsolutionTemplarJudge",
		"AbsolutionTemplarJudgeVaal",
	},
	statMap = {
		["skill_physical_damage_%_to_convert_to_lightning"] = {
			mod("SkillPhysicalDamageConvertToLightning", "BASE", nil),
			mod("MinionModifier", "LIST", { mod = mod("SkillPhysicalDamageConvertToLightning", "BASE", nil, 0, 0) })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("radius", 25),
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_max_number_of_absolution_sentinels", 3 },
		{ "base_secondary_skill_effect_duration", 10000 },
		{ "absolution_blast_chance_to_summon_on_hitting_rare_or_unique_%", 25 },
		{ "display_minion_monster_type", 19 },
		{ "base_skill_effect_duration", 1000 },
		{ "base_max_number_of_vaal_absolution_sentinels", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_display_minion_actor_level",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 12, 0, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 15, 0, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 15, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 19, 1, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 23, 1, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 23, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 27, 1, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 27, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 31, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 35, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 35, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 38, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 38, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 41, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 41, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 44, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 47, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 47, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 50, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 53, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 53, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 56, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 59, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 59, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 62, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 64, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 66, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 68, 6, critChance = 6, damageEffectiveness = 2, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 70, 6, critChance = 6, damageEffectiveness = 2, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 72, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 74, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 76, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 28, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 78, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 80, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 82, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 84, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 86, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 31, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 88, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 90, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 91, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 92, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 93, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 94, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 95, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 96, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 97, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 98, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 99, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 100, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
	},
}
skills["AbsolutionAltX"] = {
	name = "Absolution of Inspiring",
	baseTypeName = "Absolution of Inspiring",
	color = 1,
	baseEffectiveness = 2.0517001152039,
	incrementalEffectiveness = 0.043200001120567,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 0.75,
	minionList = {
		"AbsolutionTemplarJudge",
		"AbsolutionTemplarJudgeVaal",
	},
	statMap = {
		["skill_physical_damage_%_to_convert_to_lightning"] = {
			mod("SkillPhysicalDamageConvertToLightning", "BASE", nil),
			mod("MinionModifier", "LIST", { mod = mod("SkillPhysicalDamageConvertToLightning", "BASE", nil, 0, 0) })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("radius", 25),
	},
	qualityStats = {
		Default = {
			{ "active_skill_additive_minion_damage_modifiers_apply_to_all_damage_at_%_value", 2.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_max_number_of_absolution_sentinels", 2 },
		{ "base_secondary_skill_effect_duration", 10000 },
		{ "absolution_blast_chance_to_summon_on_hitting_rare_or_unique_%", 25 },
		{ "display_minion_monster_type", 19 },
		{ "base_skill_effect_duration", 1000 },
		{ "base_max_number_of_vaal_absolution_sentinels", 1 },
		{ "active_skill_additive_minion_damage_modifiers_apply_to_all_damage_at_%_value", 250 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_display_minion_actor_level",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 12, 0, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 15, 0, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 15, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 19, 1, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 23, 1, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 23, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 27, 1, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 27, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 31, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 35, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 35, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 38, 2, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 38, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 41, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 41, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 44, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 47, 3, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 47, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 50, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 53, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 53, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 56, 4, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 59, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 59, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 62, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 64, 5, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 66, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 68, 6, critChance = 6, damageEffectiveness = 2, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 70, 6, critChance = 6, damageEffectiveness = 2, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 72, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 74, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 76, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 28, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 78, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 80, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 82, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 84, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 86, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 31, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 88, 9, critChance = 6, damageEffectiveness = 2, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 90, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 91, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 92, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 93, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 94, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 95, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 96, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 97, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 98, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 99, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 100, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
	},
}
skills["VaalAbsolution"] = {
	name = "Vaal Absolution",
	baseTypeName = "Vaal Absolution",
	color = 1,
	description = "Causes one of your existing Sentinels of Absolution to Ascend, becoming more powerful, gaining new spells, and overriding its duration, while maintaining its other bonuses, including from support gems. If you cannot have more Ascended Sentinels of Absolution, an existing one will be refreshed instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["vaal_upgrade_minion_damage_+%_final"] = {
		-- Stat is handled directly on minion
		},
		["vaal_upgrade_minion_damage_taken_+%_final"] = {
		-- Stat is handled directly on minion
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 15000 },
		{ "display_max_upgraded_sentinels_of_absolution", 1 },
		{ "vaal_upgrade_minion_damage_+%_final", 200 },
		{ "vaal_upgrade_minion_damage_taken_+%_final", -70 },
	},
	stats = {
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { levelRequirement = 12, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[2] = { levelRequirement = 15, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[3] = { levelRequirement = 19, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[4] = { levelRequirement = 23, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[5] = { levelRequirement = 27, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[6] = { levelRequirement = 31, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[7] = { levelRequirement = 35, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[8] = { levelRequirement = 38, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[9] = { levelRequirement = 41, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[10] = { levelRequirement = 44, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[11] = { levelRequirement = 47, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[12] = { levelRequirement = 50, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[13] = { levelRequirement = 53, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[14] = { levelRequirement = 56, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[15] = { levelRequirement = 59, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[16] = { levelRequirement = 62, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[17] = { levelRequirement = 64, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[18] = { levelRequirement = 66, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[19] = { levelRequirement = 68, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[20] = { levelRequirement = 70, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[21] = { levelRequirement = 72, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[22] = { levelRequirement = 74, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[23] = { levelRequirement = 76, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[24] = { levelRequirement = 78, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[25] = { levelRequirement = 80, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[26] = { levelRequirement = 82, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[27] = { levelRequirement = 84, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[28] = { levelRequirement = 86, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[29] = { levelRequirement = 88, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[30] = { levelRequirement = 90, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[31] = { levelRequirement = 91, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[32] = { levelRequirement = 92, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[33] = { levelRequirement = 93, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[34] = { levelRequirement = 94, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[35] = { levelRequirement = 95, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[36] = { levelRequirement = 96, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[37] = { levelRequirement = 97, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[38] = { levelRequirement = 98, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[39] = { levelRequirement = 99, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[40] = { levelRequirement = 100, soulPreventionDuration = 30, vaalStoredUses = 1, cost = { Soul = 40, }, },
	},
}
skills["AncestralCry"] = {
	name = "Ancestral Cry",
	baseTypeName = "Ancestral Cry",
	color = 1,
	description = "Performs a warcry, taunting all nearby enemies to attack the user and exerting subsequent strike attacks. The user and nearby allies gain a buff that  grants elemental resistances.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("AncestralExertedAttacks", "BASE", nil),
		},
		["ancestral_cry_elemental_resist_%_per_5_power_up_to_cap"] = {
			mod("ElementalResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 30 }),
		},
		["ancestral_cry_maximum_elemental_resist_%_per_10_power_up_to_cap"] = {
			mod("ElementalResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 10, limit = 30 }),
		},
		["skill_empower_limitation_specifier_for_stat_description"] = {
			-- Display only
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_empowers_next_x_melee_attacks", 8 },
		{ "ancestral_cry_elemental_resist_%_per_5_power_up_to_cap", 5 },
		{ "ancestral_cry_maximum_elemental_resist_%_per_10_power_up_to_cap", 1 },
		{ "ancestral_cry_empowered_attacks_strike_X_additional_enemies", 2 },
		{ "skill_empower_limitation_specifier_for_stat_description", 1 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["Anger"] = {
	name = "Anger",
	baseTypeName = "Anger",
	color = 1,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.023000000044703,
	description = "Casts an aura that adds fire damage to the attacks and spells of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["attack_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"spell_minimum_added_fire_damage",
		"spell_maximum_added_fire_damage",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[2] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[3] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[4] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[5] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[6] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[7] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[8] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[9] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[10] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[11] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[12] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[13] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[14] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[15] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[16] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[17] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[18] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[19] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[20] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[21] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[22] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[23] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[24] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[25] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[26] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[27] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[28] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[29] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[30] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[31] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[32] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[33] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[34] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[35] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[36] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[37] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[38] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[39] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[40] = { 0.34999999403954, 0.5, 0.34999999403954, 0.5, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
	},
}
skills["AnimateGuardian"] = {
	name = "Animate Guardian",
	baseTypeName = "Animate Guardian",
	color = 1,
	description = "Animates a melee weapon or armour, attaching it to an invisible Guardian that fights by your side. Animating multiple items attaches them to the same Guardian. You cannot animate unidentified items. Cannot be used by Traps or Mines. If your Guardian dies you cannot summon an Animated Guardian again in that area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "single_minion_spell_skill_stat_descriptions",
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
		["Weapon 2"] = true,
		["Helmet"] = true,
		["Body Armour"] = true,
		["Gloves"] = true,
		["Boots"] = true,
	},
	minionList = {
		"AnimatedArmour",
	},
	baseFlags = {
		spell = true,
		minion = true,
		permanentMinion = true,
	},
	qualityStats = {
		Default = {
			{ "minion_movement_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "emerge_speed_+%", 100 },
		{ "display_minion_monster_type", 3 },
	},
	stats = {
		"animate_item_maximum_level_requirement",
		"active_skill_minion_life_+%_final",
		"active_skill_minion_damage_+%_final",
		"base_display_minion_actor_level",
		"infinite_minion_duration",
	},
	notMinionStat = {
		"active_skill_minion_life_+%_final",
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 33, 0, 0, 28, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[2] = { 36, 2, 2, 31, levelRequirement = 31, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 39, 4, 4, 34, levelRequirement = 34, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[4] = { 43, 6, 6, 37, levelRequirement = 37, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[5] = { 46, 8, 8, 40, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[6] = { 48, 10, 10, 42, levelRequirement = 42, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[7] = { 51, 12, 12, 44, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[8] = { 53, 14, 14, 46, levelRequirement = 46, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[9] = { 56, 16, 16, 48, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[10] = { 58, 18, 18, 50, levelRequirement = 50, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[11] = { 61, 20, 20, 52, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[12] = { 63, 22, 22, 54, levelRequirement = 54, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[13] = { 66, 24, 24, 56, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 68, 26, 26, 58, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[15] = { 71, 28, 28, 60, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 73, 30, 30, 62, levelRequirement = 62, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 76, 32, 32, 64, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 79, 34, 34, 66, levelRequirement = 66, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 82, 36, 36, 68, levelRequirement = 68, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 100, 38, 38, 70, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 100, 40, 40, 72, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 100, 42, 42, 74, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 100, 44, 44, 76, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 100, 46, 46, 78, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 100, 48, 48, 80, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 100, 50, 50, 82, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 100, 52, 52, 84, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 100, 54, 54, 86, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 100, 56, 56, 88, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 100, 58, 58, 90, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 100, 59, 59, 91, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[32] = { 100, 60, 60, 92, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 100, 61, 61, 93, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 100, 62, 62, 94, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[35] = { 100, 63, 63, 95, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[36] = { 100, 64, 64, 96, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[37] = { 100, 65, 65, 97, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[38] = { 100, 66, 66, 98, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[39] = { 100, 67, 67, 99, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[40] = { 100, 68, 68, 100, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 26, }, },
	},
}
skills["AnimateGuardianAltX"] = {
	name = "Animate Guardian of Smiting",
	baseTypeName = "Animate Guardian of Smiting",
	color = 1,
	description = "Animates a melee weapon or armour, attaching it to an invisible Guardian that fights by your side using Smite of Divine Judgement, ignoring weapon restrictions. Animating multiple items attaches them to the same Guardian. You cannot animate unidentified items. Cannot be used by Traps or Mines. If your Guardian dies you cannot summon an Animated Guardian again in that area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, [SkillType.Lightning] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "single_minion_spell_skill_stat_descriptions",
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
		["Weapon 2"] = true,
		["Helmet"] = true,
		["Body Armour"] = true,
		["Gloves"] = true,
		["Boots"] = true,
	},
	minionList = {
		"AnimatedArmour",
	},
	baseFlags = {
		spell = true,
		minion = true,
		permanentMinion = true,
	},
	qualityStats = {
		Default = {
			{ "minion_movement_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "emerge_speed_+%", 100 },
		{ "display_minion_monster_type", 3 },
		{ "active_skill_minion_from_alternate_gem_index", 1 },
	},
	stats = {
		"animate_item_maximum_level_requirement",
		"active_skill_minion_damage_+%_final",
		"base_display_minion_actor_level",
		"infinite_minion_duration",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 33, 0, 28, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[2] = { 36, 2, 31, levelRequirement = 31, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 39, 4, 34, levelRequirement = 34, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[4] = { 43, 6, 37, levelRequirement = 37, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[5] = { 46, 8, 40, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[6] = { 48, 10, 42, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[7] = { 51, 12, 44, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[8] = { 53, 14, 46, levelRequirement = 46, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[9] = { 56, 16, 48, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[10] = { 58, 18, 50, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[11] = { 61, 20, 52, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[12] = { 63, 22, 54, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[13] = { 66, 24, 56, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 68, 26, 58, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[15] = { 71, 28, 60, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 73, 30, 62, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 76, 32, 64, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 79, 34, 66, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 82, 36, 68, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 100, 38, 70, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 100, 40, 72, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 100, 42, 74, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 100, 44, 76, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 100, 46, 78, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 100, 48, 80, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 100, 50, 82, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 100, 52, 84, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 100, 54, 86, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 100, 56, 88, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 100, 58, 90, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 100, 59, 91, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[32] = { 100, 60, 92, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 100, 61, 93, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 100, 62, 94, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[35] = { 100, 63, 95, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[36] = { 100, 64, 96, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[37] = { 100, 65, 97, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[38] = { 100, 66, 98, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[39] = { 100, 67, 99, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[40] = { 100, 68, 100, levelRequirement = 100, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
	},
}
skills["Autoexertion"] = {
	name = "Autoexertion",
	baseTypeName = "Autoexertion",
	color = 1,
	description = "Reserves mana based on the supported warcries to cause those warcries to be repeatedly triggered.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Instant] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["call_to_arms_behaviour"] = {
			-- Display only
		},
	},
	baseFlags = {
		spell = true,
	},
	stats = {
		"call_to_arms_behaviour",
	},
	levels = {
		[1] = { cooldown = 0.6, levelRequirement = 24, storedUses = 1, },
		[2] = { cooldown = 0.6, levelRequirement = 27, storedUses = 1, },
		[3] = { cooldown = 0.6, levelRequirement = 30, storedUses = 1, },
		[4] = { cooldown = 0.6, levelRequirement = 33, storedUses = 1, },
		[5] = { cooldown = 0.6, levelRequirement = 36, storedUses = 1, },
		[6] = { cooldown = 0.6, levelRequirement = 39, storedUses = 1, },
		[7] = { cooldown = 0.6, levelRequirement = 42, storedUses = 1, },
		[8] = { cooldown = 0.6, levelRequirement = 45, storedUses = 1, },
		[9] = { cooldown = 0.6, levelRequirement = 48, storedUses = 1, },
		[10] = { cooldown = 0.6, levelRequirement = 50, storedUses = 1, },
		[11] = { cooldown = 0.6, levelRequirement = 52, storedUses = 1, },
		[12] = { cooldown = 0.6, levelRequirement = 54, storedUses = 1, },
		[13] = { cooldown = 0.6, levelRequirement = 56, storedUses = 1, },
		[14] = { cooldown = 0.6, levelRequirement = 58, storedUses = 1, },
		[15] = { cooldown = 0.6, levelRequirement = 60, storedUses = 1, },
		[16] = { cooldown = 0.6, levelRequirement = 62, storedUses = 1, },
		[17] = { cooldown = 0.6, levelRequirement = 64, storedUses = 1, },
		[18] = { cooldown = 0.6, levelRequirement = 66, storedUses = 1, },
		[19] = { cooldown = 0.6, levelRequirement = 68, storedUses = 1, },
		[20] = { cooldown = 0.6, levelRequirement = 70, storedUses = 1, },
		[21] = { cooldown = 0.6, levelRequirement = 72, storedUses = 1, },
		[22] = { cooldown = 0.6, levelRequirement = 74, storedUses = 1, },
		[23] = { cooldown = 0.6, levelRequirement = 76, storedUses = 1, },
		[24] = { cooldown = 0.6, levelRequirement = 78, storedUses = 1, },
		[25] = { cooldown = 0.6, levelRequirement = 80, storedUses = 1, },
		[26] = { cooldown = 0.6, levelRequirement = 82, storedUses = 1, },
		[27] = { cooldown = 0.6, levelRequirement = 84, storedUses = 1, },
		[28] = { cooldown = 0.6, levelRequirement = 86, storedUses = 1, },
		[29] = { cooldown = 0.6, levelRequirement = 88, storedUses = 1, },
		[30] = { cooldown = 0.6, levelRequirement = 90, storedUses = 1, },
		[31] = { cooldown = 0.6, levelRequirement = 91, storedUses = 1, },
		[32] = { cooldown = 0.6, levelRequirement = 92, storedUses = 1, },
		[33] = { cooldown = 0.6, levelRequirement = 93, storedUses = 1, },
		[34] = { cooldown = 0.6, levelRequirement = 94, storedUses = 1, },
		[35] = { cooldown = 0.6, levelRequirement = 95, storedUses = 1, },
		[36] = { cooldown = 0.6, levelRequirement = 96, storedUses = 1, },
		[37] = { cooldown = 0.6, levelRequirement = 97, storedUses = 1, },
		[38] = { cooldown = 0.6, levelRequirement = 98, storedUses = 1, },
		[39] = { cooldown = 0.6, levelRequirement = 99, storedUses = 1, },
		[40] = { cooldown = 0.6, levelRequirement = 100, storedUses = 1, },
	},
}
skills["SupportAutoexertion"] = {
	name = "Autoexertion",
	description = "Supports warcry skills. Cannot support retaliation skills or modify the skills of minions.",
	color = 1,
	support = true,
	requireSkillTypes = { SkillType.Warcry, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.HasReservation, SkillType.SummonsTotem, SkillType.RemoteMined, SkillType.Trapped, SkillType.Vaal, SkillType.InbuiltTrigger, SkillType.Retaliation, },
	isTrigger = true,
	supportGemsOnly = true,
	ignoreMinionTypes = true,
	statDescriptionScope = "gem_stat_descriptions",
	statMap = {
		["warcries_do_not_apply_buffs_to_self_or_allies"] = {
			flag("CannotShareWarcryBuffs"),
		},
		["support_autoexertion_base_mana_cost_override"] = {
			mod("BaseManaCostOverride", "OVERRIDE", nil),
		},
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	constantStats = {
		{ "support_autoexertion_base_mana_cost_override", 10 },
	},
	stats = {
		"base_cooldown_speed_+%",
		"support_autocast_warcries",
		"warcries_do_not_apply_buffs_to_self_or_allies",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
	},
	levels = {
		[1] = { 0, cooldown = 0.2, levelRequirement = 24, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { 1, cooldown = 0.2, levelRequirement = 27, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { 2, cooldown = 0.2, levelRequirement = 30, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { 3, cooldown = 0.2, levelRequirement = 33, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[5] = { 4, cooldown = 0.2, levelRequirement = 36, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[6] = { 5, cooldown = 0.2, levelRequirement = 39, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[7] = { 6, cooldown = 0.2, levelRequirement = 42, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[8] = { 7, cooldown = 0.2, levelRequirement = 45, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[9] = { 8, cooldown = 0.2, levelRequirement = 48, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[10] = { 9, cooldown = 0.2, levelRequirement = 50, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[11] = { 10, cooldown = 0.2, levelRequirement = 52, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[12] = { 11, cooldown = 0.2, levelRequirement = 54, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[13] = { 12, cooldown = 0.2, levelRequirement = 56, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[14] = { 13, cooldown = 0.2, levelRequirement = 58, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[15] = { 14, cooldown = 0.2, levelRequirement = 60, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[16] = { 15, cooldown = 0.2, levelRequirement = 62, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[17] = { 16, cooldown = 0.2, levelRequirement = 64, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[18] = { 17, cooldown = 0.2, levelRequirement = 66, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[19] = { 18, cooldown = 0.2, levelRequirement = 68, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { 19, cooldown = 0.2, levelRequirement = 70, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[21] = { 20, cooldown = 0.2, levelRequirement = 72, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[22] = { 21, cooldown = 0.2, levelRequirement = 74, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[23] = { 22, cooldown = 0.2, levelRequirement = 76, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[24] = { 23, cooldown = 0.2, levelRequirement = 78, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[25] = { 24, cooldown = 0.2, levelRequirement = 80, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[26] = { 25, cooldown = 0.2, levelRequirement = 82, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[27] = { 26, cooldown = 0.2, levelRequirement = 84, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[28] = { 27, cooldown = 0.2, levelRequirement = 86, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[29] = { 28, cooldown = 0.2, levelRequirement = 88, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[30] = { 29, cooldown = 0.2, levelRequirement = 90, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[31] = { 29, cooldown = 0.2, levelRequirement = 91, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[32] = { 30, cooldown = 0.2, levelRequirement = 92, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[33] = { 30, cooldown = 0.2, levelRequirement = 93, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[34] = { 31, cooldown = 0.2, levelRequirement = 94, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[35] = { 31, cooldown = 0.2, levelRequirement = 95, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[36] = { 32, cooldown = 0.2, levelRequirement = 96, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[37] = { 32, cooldown = 0.2, levelRequirement = 97, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[38] = { 33, cooldown = 0.2, levelRequirement = 98, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[39] = { 33, cooldown = 0.2, levelRequirement = 99, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
		[40] = { 34, cooldown = 0.2, levelRequirement = 100, manaReservationPercent = 15, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["BattlemagesCry"] = {
	name = "Battlemage's Cry",
	baseTypeName = "Battlemage's Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. The user and nearby allies gain a buff that boosts critical strike chance.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("BattlemageExertedAttacks", "BASE", nil),
		},
		["divine_cry_additional_base_critical_strike_chance_per_5_power_up_to_cap"] = {
			mod("CritChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
			div = 100,
		},
		["display_battlemage_cry_exerted_attacks_trigger_supported_spell"] ={
			-- Display only
		},
	},
	baseFlags = {
		area = true,
		duration = true,
		warcry = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_empowers_next_x_melee_attacks", 5 },
		{ "divine_cry_additional_base_critical_strike_chance_per_5_power_up_to_cap", 50 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"display_battlemage_cry_exerted_attacks_trigger_supported_spell",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["BattlemagesCrySupport"] = {
	name = "Battlemage's Cry",
	description = "Supports spell skills, causing them to be triggered. Cannot support skills used by totems, traps, or mines. Vaal skills, channelling skills, and skills with a reservation cannot be triggered.",
	color = 1,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.HasReservation, SkillType.InbuiltTrigger, },
	isTrigger = true,
	ignoreMinionTypes = true,
	statDescriptionScope = "gem_stat_descriptions",
	statMap = {
		["support_divine_cry_damage_+%_final"] = {
			mod("Damage", "MORE", nil),
		},
		["triggered_by_divine_cry"] = {
			skill("triggeredByBattleMageCry", true),
		},
	},
	qualityStats = {
		Default = {
			{ "dummy_stat_display_nothing", 0 },
		},
	},
	stats = {
		"support_divine_cry_damage_+%_final",
		"triggered_by_divine_cry",
	},
	levels = {
		[1] = { -44, levelRequirement = 24, statInterpolation = { 1, }, },
		[2] = { -44, levelRequirement = 27, statInterpolation = { 1, }, },
		[3] = { -44, levelRequirement = 30, statInterpolation = { 1, }, },
		[4] = { -43, levelRequirement = 33, statInterpolation = { 1, }, },
		[5] = { -43, levelRequirement = 36, statInterpolation = { 1, }, },
		[6] = { -43, levelRequirement = 39, statInterpolation = { 1, }, },
		[7] = { -42, levelRequirement = 42, statInterpolation = { 1, }, },
		[8] = { -42, levelRequirement = 45, statInterpolation = { 1, }, },
		[9] = { -42, levelRequirement = 48, statInterpolation = { 1, }, },
		[10] = { -41, levelRequirement = 50, statInterpolation = { 1, }, },
		[11] = { -41, levelRequirement = 52, statInterpolation = { 1, }, },
		[12] = { -41, levelRequirement = 54, statInterpolation = { 1, }, },
		[13] = { -40, levelRequirement = 56, statInterpolation = { 1, }, },
		[14] = { -40, levelRequirement = 58, statInterpolation = { 1, }, },
		[15] = { -40, levelRequirement = 60, statInterpolation = { 1, }, },
		[16] = { -39, levelRequirement = 62, statInterpolation = { 1, }, },
		[17] = { -39, levelRequirement = 64, statInterpolation = { 1, }, },
		[18] = { -39, levelRequirement = 66, statInterpolation = { 1, }, },
		[19] = { -38, levelRequirement = 68, statInterpolation = { 1, }, },
		[20] = { -38, levelRequirement = 70, statInterpolation = { 1, }, },
		[21] = { -38, levelRequirement = 72, statInterpolation = { 1, }, },
		[22] = { -37, levelRequirement = 74, statInterpolation = { 1, }, },
		[23] = { -37, levelRequirement = 76, statInterpolation = { 1, }, },
		[24] = { -37, levelRequirement = 78, statInterpolation = { 1, }, },
		[25] = { -36, levelRequirement = 80, statInterpolation = { 1, }, },
		[26] = { -36, levelRequirement = 82, statInterpolation = { 1, }, },
		[27] = { -36, levelRequirement = 84, statInterpolation = { 1, }, },
		[28] = { -35, levelRequirement = 86, statInterpolation = { 1, }, },
		[29] = { -35, levelRequirement = 88, statInterpolation = { 1, }, },
		[30] = { -35, levelRequirement = 90, statInterpolation = { 1, }, },
		[31] = { -34, levelRequirement = 91, statInterpolation = { 1, }, },
		[32] = { -34, levelRequirement = 92, statInterpolation = { 1, }, },
		[33] = { -34, levelRequirement = 93, statInterpolation = { 1, }, },
		[34] = { -33, levelRequirement = 94, statInterpolation = { 1, }, },
		[35] = { -33, levelRequirement = 95, statInterpolation = { 1, }, },
		[36] = { -33, levelRequirement = 96, statInterpolation = { 1, }, },
		[37] = { -32, levelRequirement = 97, statInterpolation = { 1, }, },
		[38] = { -32, levelRequirement = 98, statInterpolation = { 1, }, },
		[39] = { -32, levelRequirement = 99, statInterpolation = { 1, }, },
		[40] = { -31, levelRequirement = 100, statInterpolation = { 1, }, },
	},
}
skills["Berserk"] = {
	name = "Berserk",
	baseTypeName = "Berserk",
	color = 1,
	baseEffectiveness = 0,
	description = "Consumes Rage at an accelerating rate to increase the effects of Rage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["berserk_rage_effect_+%"] = {
			mod("RageEffect", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	constantStats = {
		{ "berserk_minimum_rage", 5 },
		{ "berserk_base_rage_loss_per_second", 5 },
		{ "berserk_rage_loss_+%_per_second", 20 },
	},
	stats = {
		"berserk_rage_effect_+%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 40, cooldown = 5, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[2] = { 41, cooldown = 5, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[3] = { 42, cooldown = 5, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[4] = { 43, cooldown = 5, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[5] = { 44, cooldown = 5, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[6] = { 45, cooldown = 5, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[7] = { 46, cooldown = 5, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[8] = { 47, cooldown = 5, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[9] = { 48, cooldown = 5, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[10] = { 49, cooldown = 5, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[11] = { 50, cooldown = 5, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[12] = { 51, cooldown = 5, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[13] = { 52, cooldown = 5, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[14] = { 53, cooldown = 5, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[15] = { 54, cooldown = 5, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[16] = { 55, cooldown = 5, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[17] = { 56, cooldown = 5, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[18] = { 57, cooldown = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[19] = { 58, cooldown = 5, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[20] = { 59, cooldown = 5, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[21] = { 60, cooldown = 5, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[22] = { 61, cooldown = 5, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[23] = { 62, cooldown = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[24] = { 63, cooldown = 5, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[25] = { 64, cooldown = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[26] = { 65, cooldown = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[27] = { 66, cooldown = 5, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[28] = { 67, cooldown = 5, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[29] = { 68, cooldown = 5, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[30] = { 69, cooldown = 5, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[31] = { 69, cooldown = 5, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[32] = { 70, cooldown = 5, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[33] = { 70, cooldown = 5, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[34] = { 71, cooldown = 5, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[35] = { 71, cooldown = 5, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[36] = { 72, cooldown = 5, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[37] = { 72, cooldown = 5, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[38] = { 73, cooldown = 5, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[39] = { 73, cooldown = 5, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[40] = { 74, cooldown = 5, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 22, }, },
	},
}
skills["Bladestorm"] = {
	name = "Bladestorm",
	baseTypeName = "Bladestorm",
	color = 1,
	description = "Perform a spinning attack, damaging enemies around you and creating a bladestorm matching your stance. The bladestorm repeatedly damages enemies, based on your weapon damage and attack time, for a duration. Blood bladestorms are stationary and cause Bleeding, while Sand bladestorms move slowly forwards and Blind enemies. Requires a Sword or Axe. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
		},
		{
			name = "Bladestorm",
		},
	},
	statMap = {
		["bladestorm_storm_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["bladestorm_attack_speed_+%_final_while_in_bloodstorm"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Condition", var = "BladestormInBloodstorm" }),
		},
		["bladestorm_movement_speed_+%_while_in_sandstorm"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Sandstorm", effectCond = "BladestormInSandstorm" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("radiusLabel", "Area of initial attack:"),
		skill("radiusSecondary", 20),
		skill("radiusSecondaryLabel", "Area of bladestorms:"),
		mod("BleedChance", "BASE", 100, ModFlag.Attack, 0, { type = "Condition", var = "BloodStance" }, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "bladestorm_maximum_number_of_storms_allowed", 0.05 },
		},
	},
	constantStats = {
		{ "bladestorm_storm_damage_+%_final", -50 },
		{ "bladestorm_maximum_number_of_storms_allowed", 3 },
		{ "blind_art_variation", 1 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"bladestorm_attack_speed_+%_final_while_in_bloodstorm",
		"bladestorm_movement_speed_+%_while_in_sandstorm",
		"active_skill_bleeding_damage_+%_final_in_blood_stance",
		"is_area_damage",
		"console_skill_dont_chase",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_bladestorm_is_gem",
	},
	levels = {
		[1] = { 10, 30, 70, attackSpeedMultiplier = -30, baseMultiplier = 1.59, damageEffectiveness = 1.59, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { Mana = 10, }, },
		[2] = { 10, 30, 72, attackSpeedMultiplier = -30, baseMultiplier = 1.643, damageEffectiveness = 1.643, levelRequirement = 31, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 10, 31, 74, attackSpeedMultiplier = -30, baseMultiplier = 1.7, damageEffectiveness = 1.7, levelRequirement = 34, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[4] = { 10, 31, 76, attackSpeedMultiplier = -30, baseMultiplier = 1.758, damageEffectiveness = 1.758, levelRequirement = 37, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[5] = { 10, 32, 78, attackSpeedMultiplier = -30, baseMultiplier = 1.817, damageEffectiveness = 1.817, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[6] = { 10, 32, 80, attackSpeedMultiplier = -30, baseMultiplier = 1.875, damageEffectiveness = 1.875, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[7] = { 11, 32, 82, attackSpeedMultiplier = -30, baseMultiplier = 1.936, damageEffectiveness = 1.936, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[8] = { 11, 33, 84, attackSpeedMultiplier = -30, baseMultiplier = 1.999, damageEffectiveness = 1.999, levelRequirement = 46, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[9] = { 11, 33, 86, attackSpeedMultiplier = -30, baseMultiplier = 2.062, damageEffectiveness = 2.062, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[10] = { 11, 34, 88, attackSpeedMultiplier = -30, baseMultiplier = 2.129, damageEffectiveness = 2.129, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[11] = { 11, 34, 90, attackSpeedMultiplier = -30, baseMultiplier = 2.197, damageEffectiveness = 2.197, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[12] = { 11, 34, 92, attackSpeedMultiplier = -30, baseMultiplier = 2.267, damageEffectiveness = 2.267, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[13] = { 11, 35, 94, attackSpeedMultiplier = -30, baseMultiplier = 2.34, damageEffectiveness = 2.34, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[14] = { 12, 35, 96, attackSpeedMultiplier = -30, baseMultiplier = 2.415, damageEffectiveness = 2.415, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[15] = { 12, 36, 98, attackSpeedMultiplier = -30, baseMultiplier = 2.493, damageEffectiveness = 2.493, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[16] = { 12, 36, 100, attackSpeedMultiplier = -30, baseMultiplier = 2.573, damageEffectiveness = 2.573, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[17] = { 12, 36, 102, attackSpeedMultiplier = -30, baseMultiplier = 2.656, damageEffectiveness = 2.656, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[18] = { 12, 37, 104, attackSpeedMultiplier = -30, baseMultiplier = 2.741, damageEffectiveness = 2.741, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[19] = { 12, 37, 106, attackSpeedMultiplier = -30, baseMultiplier = 2.829, damageEffectiveness = 2.829, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[20] = { 12, 38, 108, attackSpeedMultiplier = -30, baseMultiplier = 2.919, damageEffectiveness = 2.919, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[21] = { 13, 38, 110, attackSpeedMultiplier = -30, baseMultiplier = 3.013, damageEffectiveness = 3.013, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[22] = { 13, 38, 112, attackSpeedMultiplier = -30, baseMultiplier = 3.109, damageEffectiveness = 3.109, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[23] = { 13, 39, 114, attackSpeedMultiplier = -30, baseMultiplier = 3.209, damageEffectiveness = 3.209, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[24] = { 13, 39, 116, attackSpeedMultiplier = -30, baseMultiplier = 3.312, damageEffectiveness = 3.312, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[25] = { 13, 40, 118, attackSpeedMultiplier = -30, baseMultiplier = 3.418, damageEffectiveness = 3.418, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[26] = { 13, 40, 120, attackSpeedMultiplier = -30, baseMultiplier = 3.527, damageEffectiveness = 3.527, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[27] = { 13, 40, 122, attackSpeedMultiplier = -30, baseMultiplier = 3.639, damageEffectiveness = 3.639, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[28] = { 14, 41, 124, attackSpeedMultiplier = -30, baseMultiplier = 3.755, damageEffectiveness = 3.755, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[29] = { 14, 41, 126, attackSpeedMultiplier = -30, baseMultiplier = 3.875, damageEffectiveness = 3.875, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[30] = { 14, 42, 128, attackSpeedMultiplier = -30, baseMultiplier = 3.999, damageEffectiveness = 3.999, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[31] = { 14, 42, 129, attackSpeedMultiplier = -30, baseMultiplier = 4.18, damageEffectiveness = 4.18, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[32] = { 14, 42, 130, attackSpeedMultiplier = -30, baseMultiplier = 4.246, damageEffectiveness = 4.246, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[33] = { 14, 42, 131, attackSpeedMultiplier = -30, baseMultiplier = 4.313, damageEffectiveness = 4.313, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[34] = { 14, 42, 132, attackSpeedMultiplier = -30, baseMultiplier = 4.382, damageEffectiveness = 4.382, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[35] = { 14, 43, 133, attackSpeedMultiplier = -30, baseMultiplier = 4.453, damageEffectiveness = 4.453, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[36] = { 14, 43, 134, attackSpeedMultiplier = -30, baseMultiplier = 4.523, damageEffectiveness = 4.523, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[37] = { 14, 43, 135, attackSpeedMultiplier = -30, baseMultiplier = 4.595, damageEffectiveness = 4.595, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[38] = { 14, 43, 136, attackSpeedMultiplier = -30, baseMultiplier = 4.668, damageEffectiveness = 4.668, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[39] = { 14, 43, 137, attackSpeedMultiplier = -30, baseMultiplier = 4.743, damageEffectiveness = 4.743, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[40] = { 15, 44, 138, attackSpeedMultiplier = -30, baseMultiplier = 4.81, damageEffectiveness = 4.81, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
	},
}
skills["BladestormAltX"] = {
	name = "Bladestorm of Uncertainty",
	baseTypeName = "Bladestorm of Uncertainty",
	color = 1,
	description = "Perform a spinning attack, damaging enemies around you and creating a random bladestorm. The bladestorm repeatedly damages enemies, based on your weapon damage and attack time, for a duration. Blood bladestorms are stationary and cause Bleeding, while Sand bladestorms move slowly forwards and Blind enemies. Requires a Sword or Axe.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
		},
		{
			name = "Bladestorm",
		},
	},
	statMap = {
		["bladestorm_storm_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["bladestorm_attack_speed_+%_final_while_in_bloodstorm"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Condition", var = "BladestormInBloodstorm" }),
		},
		["bladestorm_movement_speed_+%_while_in_sandstorm"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Sandstorm", effectCond = "BladestormInSandstorm" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("radiusLabel", "Area of initial attack:"),
		skill("radiusSecondary", 20),
		skill("radiusSecondaryLabel", "Area of bladestorms:"),
	},
	qualityStats = {
		Default = {
			{ "bladestorm_maximum_number_of_storms_allowed", 0.05 },
		},
	},
	constantStats = {
		{ "bladestorm_storm_damage_+%_final", -50 },
		{ "bladestorm_maximum_number_of_storms_allowed", 3 },
		{ "blind_art_variation", 1 },
		{ "base_skill_effect_duration", 3000 },
		{ "bladestorm_create_alternate_stance_storm_%_chance", 50 },
	},
	stats = {
		"bladestorm_attack_speed_+%_final_while_in_bloodstorm",
		"bladestorm_movement_speed_+%_while_in_sandstorm",
		"active_skill_bleeding_damage_+%_final",
		"is_area_damage",
		"console_skill_dont_chase",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_bladestorm_is_gem",
		"quality_display_active_skill_bleed_damage_final_is_gem",
	},
	notMinionStat = {
		"active_skill_bleeding_damage_+%_final",
	},
	levels = {
		[1] = { 10, 30, 50, attackSpeedMultiplier = -30, baseMultiplier = 1.892, damageEffectiveness = 1.892, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { Mana = 10, }, },
		[2] = { 10, 30, 52, attackSpeedMultiplier = -30, baseMultiplier = 1.957, damageEffectiveness = 1.957, levelRequirement = 31, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 10, 31, 54, attackSpeedMultiplier = -30, baseMultiplier = 2.023, damageEffectiveness = 2.023, levelRequirement = 34, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[4] = { 10, 31, 56, attackSpeedMultiplier = -30, baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 37, statInterpolation = { 1, 1, 1, }, cost = { Mana = 11, }, },
		[5] = { 10, 32, 58, attackSpeedMultiplier = -30, baseMultiplier = 2.164, damageEffectiveness = 2.164, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[6] = { 10, 32, 60, attackSpeedMultiplier = -30, baseMultiplier = 2.232, damageEffectiveness = 2.232, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[7] = { 11, 32, 62, attackSpeedMultiplier = -30, baseMultiplier = 2.305, damageEffectiveness = 2.305, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[8] = { 11, 33, 64, attackSpeedMultiplier = -30, baseMultiplier = 2.379, damageEffectiveness = 2.379, levelRequirement = 46, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[9] = { 11, 33, 66, attackSpeedMultiplier = -30, baseMultiplier = 2.455, damageEffectiveness = 2.455, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 12, }, },
		[10] = { 11, 34, 68, attackSpeedMultiplier = -30, baseMultiplier = 2.535, damageEffectiveness = 2.535, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[11] = { 11, 34, 70, attackSpeedMultiplier = -30, baseMultiplier = 2.615, damageEffectiveness = 2.615, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[12] = { 11, 34, 72, attackSpeedMultiplier = -30, baseMultiplier = 2.7, damageEffectiveness = 2.7, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[13] = { 11, 35, 74, attackSpeedMultiplier = -30, baseMultiplier = 2.786, damageEffectiveness = 2.786, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[14] = { 12, 35, 76, attackSpeedMultiplier = -30, baseMultiplier = 2.876, damageEffectiveness = 2.876, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[15] = { 12, 36, 78, attackSpeedMultiplier = -30, baseMultiplier = 2.968, damageEffectiveness = 2.968, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { Mana = 13, }, },
		[16] = { 12, 36, 80, attackSpeedMultiplier = -30, baseMultiplier = 3.064, damageEffectiveness = 3.064, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[17] = { 12, 36, 82, attackSpeedMultiplier = -30, baseMultiplier = 3.162, damageEffectiveness = 3.162, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[18] = { 12, 37, 84, attackSpeedMultiplier = -30, baseMultiplier = 3.263, damageEffectiveness = 3.263, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[19] = { 12, 37, 86, attackSpeedMultiplier = -30, baseMultiplier = 3.367, damageEffectiveness = 3.367, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[20] = { 12, 38, 88, attackSpeedMultiplier = -30, baseMultiplier = 3.475, damageEffectiveness = 3.475, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[21] = { 13, 38, 90, attackSpeedMultiplier = -30, baseMultiplier = 3.586, damageEffectiveness = 3.586, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[22] = { 13, 38, 92, attackSpeedMultiplier = -30, baseMultiplier = 3.701, damageEffectiveness = 3.701, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[23] = { 13, 39, 94, attackSpeedMultiplier = -30, baseMultiplier = 3.821, damageEffectiveness = 3.821, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[24] = { 13, 39, 96, attackSpeedMultiplier = -30, baseMultiplier = 3.943, damageEffectiveness = 3.943, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[25] = { 13, 40, 98, attackSpeedMultiplier = -30, baseMultiplier = 4.069, damageEffectiveness = 4.069, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[26] = { 13, 40, 100, attackSpeedMultiplier = -30, baseMultiplier = 4.198, damageEffectiveness = 4.198, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[27] = { 13, 40, 102, attackSpeedMultiplier = -30, baseMultiplier = 4.333, damageEffectiveness = 4.333, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[28] = { 14, 41, 104, attackSpeedMultiplier = -30, baseMultiplier = 4.47, damageEffectiveness = 4.47, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[29] = { 14, 41, 106, attackSpeedMultiplier = -30, baseMultiplier = 4.614, damageEffectiveness = 4.614, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[30] = { 14, 42, 108, attackSpeedMultiplier = -30, baseMultiplier = 4.761, damageEffectiveness = 4.761, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[31] = { 14, 42, 109, attackSpeedMultiplier = -30, baseMultiplier = 4.975, damageEffectiveness = 4.975, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[32] = { 14, 42, 110, attackSpeedMultiplier = -30, baseMultiplier = 5.054, damageEffectiveness = 5.054, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[33] = { 14, 42, 111, attackSpeedMultiplier = -30, baseMultiplier = 5.135, damageEffectiveness = 5.135, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[34] = { 14, 42, 112, attackSpeedMultiplier = -30, baseMultiplier = 5.217, damageEffectiveness = 5.217, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[35] = { 14, 43, 113, attackSpeedMultiplier = -30, baseMultiplier = 5.3, damageEffectiveness = 5.3, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[36] = { 14, 43, 114, attackSpeedMultiplier = -30, baseMultiplier = 5.385, damageEffectiveness = 5.385, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[37] = { 14, 43, 115, attackSpeedMultiplier = -30, baseMultiplier = 5.47, damageEffectiveness = 5.47, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[38] = { 14, 43, 116, attackSpeedMultiplier = -30, baseMultiplier = 5.558, damageEffectiveness = 5.558, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[39] = { 14, 43, 117, attackSpeedMultiplier = -30, baseMultiplier = 5.645, damageEffectiveness = 5.645, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[40] = { 15, 44, 118, attackSpeedMultiplier = -30, baseMultiplier = 5.727, damageEffectiveness = 5.727, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
	},
}
skills["BloodAndSand"] = {
	name = "Blood and Sand",
	baseTypeName = "Blood and Sand",
	color = 1,
	description = "Casts a buff that grants different bonuses to melee skills depending on your stance. Using the skill again alternates between Blood Stance and Sand Stance.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.HasReservation] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, [SkillType.Stance] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["blood_sand_stance_melee_skills_area_of_effect_+%_final_in_blood_stance"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Blood", effectCond = "BloodStance"}, { type = "SkillType", skillType = SkillType.Melee })
		},
		["blood_sand_stance_melee_skills_area_damage_+%_final_in_blood_stance"] = {
			mod("Damage", "MORE", nil, ModFlag.Area, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Blood", effectCond = "BloodStance"}, { type = "SkillType", skillType = SkillType.Melee })
		},
		["blood_sand_stance_melee_skills_area_of_effect_+%_final_in_sand_stance"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Sand", effectCond = "SandStance"}, { type = "SkillType", skillType = SkillType.Melee })
		},
		["blood_sand_stance_melee_skills_area_damage_+%_final_in_sand_stance"] = {
			mod("Damage", "MORE", nil, ModFlag.Area, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Sand", effectCond = "SandStance"}, { type = "SkillType", skillType = SkillType.Melee })
		},
	},
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	constantStats = {
		{ "blood_sand_stance_melee_skills_area_of_effect_+%_final_in_blood_stance", -5 },
		{ "blood_sand_stance_melee_skills_area_damage_+%_final_in_sand_stance", -5 },
	},
	stats = {
		"base_cooldown_speed_+%",
		"blood_sand_stance_melee_skills_area_damage_+%_final_in_blood_stance",
		"blood_sand_stance_melee_skills_area_of_effect_+%_final_in_sand_stance",
		"base_deal_no_damage",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
	},
	levels = {
		[1] = { 0, 10, 10, cooldown = 2, levelRequirement = 4, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 10, 11, 11, cooldown = 2, levelRequirement = 12, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 20, 12, 12, cooldown = 2, levelRequirement = 28, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 30, 13, 13, cooldown = 2, levelRequirement = 44, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 40, 14, 14, cooldown = 2, levelRequirement = 58, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 50, 15, 15, cooldown = 2, levelRequirement = 70, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 60, 16, 16, cooldown = 2, levelRequirement = 72, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 70, 17, 17, cooldown = 2, levelRequirement = 74, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 80, 18, 18, cooldown = 2, levelRequirement = 76, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 90, 19, 19, cooldown = 2, levelRequirement = 78, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 100, 20, 20, cooldown = 2, levelRequirement = 80, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 110, 21, 21, cooldown = 2, levelRequirement = 82, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 120, 22, 22, cooldown = 2, levelRequirement = 84, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 130, 23, 23, cooldown = 2, levelRequirement = 86, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 140, 24, 24, cooldown = 2, levelRequirement = 88, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 150, 25, 25, cooldown = 2, levelRequirement = 90, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 160, 25, 25, cooldown = 2, levelRequirement = 91, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 170, 26, 26, cooldown = 2, levelRequirement = 92, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 180, 26, 26, cooldown = 2, levelRequirement = 93, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 190, 27, 27, cooldown = 2, levelRequirement = 94, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 200, 27, 27, cooldown = 2, levelRequirement = 95, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 210, 28, 28, cooldown = 2, levelRequirement = 96, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 220, 28, 28, cooldown = 2, levelRequirement = 97, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 230, 29, 29, cooldown = 2, levelRequirement = 98, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 240, 29, 29, cooldown = 2, levelRequirement = 99, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 250, 30, 30, cooldown = 2, levelRequirement = 100, manaReservationPercent = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["Boneshatter"] = {
	name = "Boneshatter",
	baseTypeName = "Boneshatter",
	color = 1,
	baseEffectiveness = 0.18279999494553,
	incrementalEffectiveness = 0.053700000047684,
	description = "Attack enemies with a forceful melee strike that also hurts you. Successive uses will raise the damage dealt both to enemies and you. Stunning an enemy with the strike releases a damaging pulse. Requires a Mace, Sceptre, Axe or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.InnateTrauma] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
			area = false,
		},
		{
			name = "Pulse",
			area = true,
		},
	},
	statMap = {
		["trauma_strike_damage_+%_final_per_trauma"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "TraumaStacks" }),
		},
		["boneshatter_trauma_base_duration_ms"] = {
			mod("TraumaDuration", "BASE", nil),
			div = 1000,
		},
		["quality_display_boneshatter_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 14, { type = "SkillPart", skillPart = 2 }),
		flag("HasTrauma"),
	},
	qualityStats = {
		Default = {
			{ "trauma_strike_damage_+%_final_per_trauma", 0.05 },
		},
	},
	constantStats = {
		{ "trauma_strike_shockwave_area_of_effect_+%_per_100ms_stun_duration_up_to_400%", 15 },
		{ "boneshatter_trauma_base_duration_ms", 6000 },
	},
	stats = {
		"trauma_strike_self_damage_per_trauma",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"trauma_strike_damage_+%_final_per_trauma",
		"quality_display_boneshatter_is_gem",
	},
	notMinionStat = {
		"trauma_strike_self_damage_per_trauma",
	},
	levels = {
		[1] = { 0.60000002384186, 1.1200000047684, 1.6799999475479, 3, attackSpeedMultiplier = -15, baseMultiplier = 2.31, damageEffectiveness = 2.31, levelRequirement = 28, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[2] = { 0.60000002384186, 1.1039999723434, 1.6560000181198, 3, attackSpeedMultiplier = -15, baseMultiplier = 2.366, damageEffectiveness = 2.366, levelRequirement = 31, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 0.60000002384186, 1.0880000591278, 1.6319999694824, 3, attackSpeedMultiplier = -15, baseMultiplier = 2.423, damageEffectiveness = 2.423, levelRequirement = 34, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[4] = { 0.60000002384186, 1.0720000267029, 1.6080000400543, 3, attackSpeedMultiplier = -15, baseMultiplier = 2.481, damageEffectiveness = 2.481, levelRequirement = 37, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[5] = { 0.60000002384186, 1.055999994278, 1.5839999914169, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.539, damageEffectiveness = 2.539, levelRequirement = 40, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[6] = { 0.60000002384186, 1.039999961853, 1.5599999427795, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.594, damageEffectiveness = 2.594, levelRequirement = 42, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[7] = { 0.60000002384186, 1.0240000486374, 1.5360000133514, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.648, damageEffectiveness = 2.648, levelRequirement = 44, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[8] = { 0.80000001192093, 1.0080000162125, 1.5119999647141, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.703, damageEffectiveness = 2.703, levelRequirement = 46, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[9] = { 0.80000001192093, 0.99199998378754, 1.4880000352859, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.758, damageEffectiveness = 2.758, levelRequirement = 48, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[10] = { 0.80000001192093, 0.97600001096725, 1.4639999866486, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.813, damageEffectiveness = 2.813, levelRequirement = 50, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[11] = { 0.80000001192093, 0.95999997854233, 1.4400000572205, 5, attackSpeedMultiplier = -15, baseMultiplier = 2.868, damageEffectiveness = 2.868, levelRequirement = 52, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[12] = { 0.80000001192093, 0.94400000572205, 1.4160000085831, 5, attackSpeedMultiplier = -15, baseMultiplier = 2.924, damageEffectiveness = 2.924, levelRequirement = 54, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[13] = { 0.80000001192093, 0.92799997329712, 1.3919999599457, 5, attackSpeedMultiplier = -15, baseMultiplier = 2.98, damageEffectiveness = 2.98, levelRequirement = 56, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[14] = { 0.80000001192093, 0.91200000047684, 1.3680000305176, 5, attackSpeedMultiplier = -15, baseMultiplier = 3.037, damageEffectiveness = 3.037, levelRequirement = 58, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[15] = { 0.80000001192093, 0.89600002765656, 1.3439999818802, 5, attackSpeedMultiplier = -15, baseMultiplier = 3.093, damageEffectiveness = 3.093, levelRequirement = 60, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[16] = { 0.80000001192093, 0.87999999523163, 1.3200000524521, 5, attackSpeedMultiplier = -15, baseMultiplier = 3.152, damageEffectiveness = 3.152, levelRequirement = 62, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[17] = { 0.80000001192093, 0.86400002241135, 1.2960000038147, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.209, damageEffectiveness = 3.209, levelRequirement = 64, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[18] = { 0.80000001192093, 0.84799998998642, 1.2719999551773, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.267, damageEffectiveness = 3.267, levelRequirement = 66, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[19] = { 0.80000001192093, 0.83200001716614, 1.2480000257492, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.325, damageEffectiveness = 3.325, levelRequirement = 68, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[20] = { 1, 0.81599998474121, 1.2239999771118, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.383, damageEffectiveness = 3.383, levelRequirement = 70, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[21] = { 1, 0.80000001192093, 1.2000000476837, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.442, damageEffectiveness = 3.442, levelRequirement = 72, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[22] = { 1, 0.783999979496, 1.1759999990463, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.5, damageEffectiveness = 3.5, levelRequirement = 74, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[23] = { 1, 0.76800000667572, 1.1519999504089, 6, attackSpeedMultiplier = -15, baseMultiplier = 3.56, damageEffectiveness = 3.56, levelRequirement = 76, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[24] = { 1, 0.75199997425079, 1.1280000209808, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 78, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[25] = { 1, 0.73600000143051, 1.1039999723434, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.68, damageEffectiveness = 3.68, levelRequirement = 80, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[26] = { 1, 0.72000002861023, 1.0800000429153, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.74, damageEffectiveness = 3.74, levelRequirement = 82, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[27] = { 1, 0.7039999961853, 1.055999994278, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.801, damageEffectiveness = 3.801, levelRequirement = 84, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[28] = { 1, 0.68800002336502, 1.0319999456406, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.862, damageEffectiveness = 3.862, levelRequirement = 86, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[29] = { 1, 0.67199999094009, 1.0080000162125, 7, attackSpeedMultiplier = -15, baseMultiplier = 3.923, damageEffectiveness = 3.923, levelRequirement = 88, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[30] = { 1, 0.65600001811981, 0.98400002717972, 8, attackSpeedMultiplier = -15, baseMultiplier = 3.984, damageEffectiveness = 3.984, levelRequirement = 90, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[31] = { 1, 0.64800000190735, 0.97200000286102, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.015, damageEffectiveness = 4.015, levelRequirement = 91, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[32] = { 1, 0.63999998569489, 0.95999997854233, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.046, damageEffectiveness = 4.046, levelRequirement = 92, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[33] = { 1, 0.63200002908707, 0.94800001382828, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.077, damageEffectiveness = 4.077, levelRequirement = 93, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[34] = { 1, 0.6240000128746, 0.93599998950958, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.108, damageEffectiveness = 4.108, levelRequirement = 94, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[35] = { 1, 0.61599999666214, 0.92400002479553, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.139, damageEffectiveness = 4.139, levelRequirement = 95, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[36] = { 1.2000000476837, 0.60799998044968, 0.91200000047684, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.17, damageEffectiveness = 4.17, levelRequirement = 96, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[37] = { 1.2000000476837, 0.60000002384186, 0.89999997615814, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.202, damageEffectiveness = 4.202, levelRequirement = 97, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[38] = { 1.2000000476837, 0.59200000762939, 0.88800001144409, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.233, damageEffectiveness = 4.233, levelRequirement = 98, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[39] = { 1.2000000476837, 0.58399999141693, 0.8759999871254, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.266, damageEffectiveness = 4.266, levelRequirement = 99, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[40] = { 1.2000000476837, 0.57599997520447, 0.86400002241135, 8, attackSpeedMultiplier = -15, baseMultiplier = 4.297, damageEffectiveness = 4.297, levelRequirement = 100, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
	},
}
skills["BoneshatterAltX"] = {
	name = "Boneshatter of Complex Trauma",
	baseTypeName = "Boneshatter of Complex Trauma",
	color = 1,
	baseEffectiveness = 0.18279999494553,
	incrementalEffectiveness = 0.053700000047684,
	description = "Attack enemies with a forceful melee strike that also hurts you. Successive uses will raise the damage dealt both to enemies and you. Stunning an enemy with the strike releases a damaging pulse. Requires a Mace, Sceptre, Axe or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.InnateTrauma] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
			area = false,
		},
		{
			name = "Pulse",
			area = true,
		},
	},
	statMap = {
		["trauma_strike_damage_+%_final_per_trauma_capped"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "TraumaStacks", limitVar = "TraumaStacksMax" }),
		},
		["boneshatter_trauma_base_duration_ms"] = {
			mod("TraumaDuration", "BASE", nil),
			div = 1000,
		},
		["lose_all_trauma_at_X_trauma"] = {
			mod("Multiplier:TraumaStacksMax", "BASE", nil),
		},
		["quality_display_boneshatter_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 14, { type = "SkillPart", skillPart = 2 }),
		flag("HasTrauma"),
	},
	qualityStats = {
		Default = {
			{ "trauma_strike_damage_+%_final_per_trauma_capped", 0.25 },
		},
	},
	constantStats = {
		{ "trauma_strike_shockwave_area_of_effect_+%_per_100ms_stun_duration_up_to_400%", 15 },
		{ "boneshatter_trauma_base_duration_ms", 6000 },
		{ "lose_all_trauma_at_X_trauma", 10 },
	},
	stats = {
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"trauma_strike_self_damage_per_trauma",
		"trauma_strike_damage_+%_final_per_trauma_capped",
		"quality_display_boneshatter_is_gem",
	},
	notMinionStat = {
		"trauma_strike_self_damage_per_trauma",
	},
	levels = {
		[1] = { 1.1200000047684, 1.6799999475479, 1.7999999523163, 8, attackSpeedMultiplier = -15, baseMultiplier = 2.31, damageEffectiveness = 2.31, levelRequirement = 28, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[2] = { 1.1039999723434, 1.6560000181198, 1.8600000143051, 8, attackSpeedMultiplier = -15, baseMultiplier = 2.366, damageEffectiveness = 2.366, levelRequirement = 31, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 1.0880000591278, 1.6319999694824, 1.9299999475479, 9, attackSpeedMultiplier = -15, baseMultiplier = 2.423, damageEffectiveness = 2.423, levelRequirement = 34, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[4] = { 1.0720000267029, 1.6080000400543, 1.9900000095367, 9, attackSpeedMultiplier = -15, baseMultiplier = 2.481, damageEffectiveness = 2.481, levelRequirement = 37, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[5] = { 1.055999994278, 1.5839999914169, 2.0499999523163, 9, attackSpeedMultiplier = -15, baseMultiplier = 2.539, damageEffectiveness = 2.539, levelRequirement = 40, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[6] = { 1.039999961853, 1.5599999427795, 2.1199998855591, 10, attackSpeedMultiplier = -15, baseMultiplier = 2.594, damageEffectiveness = 2.594, levelRequirement = 42, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[7] = { 1.0240000486374, 1.5360000133514, 2.1800000667572, 10, attackSpeedMultiplier = -15, baseMultiplier = 2.648, damageEffectiveness = 2.648, levelRequirement = 44, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[8] = { 1.0080000162125, 1.5119999647141, 2.2400000095367, 11, attackSpeedMultiplier = -15, baseMultiplier = 2.703, damageEffectiveness = 2.703, levelRequirement = 46, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[9] = { 0.99199998378754, 1.4880000352859, 2.3099999427795, 11, attackSpeedMultiplier = -15, baseMultiplier = 2.758, damageEffectiveness = 2.758, levelRequirement = 48, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[10] = { 0.97600001096725, 1.4639999866486, 2.3699998855591, 11, attackSpeedMultiplier = -15, baseMultiplier = 2.813, damageEffectiveness = 2.813, levelRequirement = 50, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[11] = { 0.95999997854233, 1.4400000572205, 2.4300000667572, 12, attackSpeedMultiplier = -15, baseMultiplier = 2.868, damageEffectiveness = 2.868, levelRequirement = 52, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[12] = { 0.94400000572205, 1.4160000085831, 2.4900000095367, 12, attackSpeedMultiplier = -15, baseMultiplier = 2.924, damageEffectiveness = 2.924, levelRequirement = 54, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[13] = { 0.92799997329712, 1.3919999599457, 2.5599999427795, 12, attackSpeedMultiplier = -15, baseMultiplier = 2.98, damageEffectiveness = 2.98, levelRequirement = 56, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[14] = { 0.91200000047684, 1.3680000305176, 2.6199998855591, 13, attackSpeedMultiplier = -15, baseMultiplier = 3.037, damageEffectiveness = 3.037, levelRequirement = 58, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[15] = { 0.89600002765656, 1.3439999818802, 2.6800000667572, 13, attackSpeedMultiplier = -15, baseMultiplier = 3.093, damageEffectiveness = 3.093, levelRequirement = 60, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[16] = { 0.87999999523163, 1.3200000524521, 2.75, 14, attackSpeedMultiplier = -15, baseMultiplier = 3.152, damageEffectiveness = 3.152, levelRequirement = 62, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[17] = { 0.86400002241135, 1.2960000038147, 2.8099999427795, 14, attackSpeedMultiplier = -15, baseMultiplier = 3.209, damageEffectiveness = 3.209, levelRequirement = 64, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[18] = { 0.84799998998642, 1.2719999551773, 2.8699998855591, 14, attackSpeedMultiplier = -15, baseMultiplier = 3.267, damageEffectiveness = 3.267, levelRequirement = 66, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[19] = { 0.83200001716614, 1.2480000257492, 2.9400000572205, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.325, damageEffectiveness = 3.325, levelRequirement = 68, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[20] = { 0.81599998474121, 1.2239999771118, 3, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.383, damageEffectiveness = 3.383, levelRequirement = 70, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 3.0599999427795, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.442, damageEffectiveness = 3.442, levelRequirement = 72, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[22] = { 0.783999979496, 1.1759999990463, 3.1300001144409, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.5, damageEffectiveness = 3.5, levelRequirement = 74, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[23] = { 0.76800000667572, 1.1519999504089, 3.1900000572205, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.56, damageEffectiveness = 3.56, levelRequirement = 76, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[24] = { 0.75199997425079, 1.1280000209808, 3.25, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 78, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[25] = { 0.73600000143051, 1.1039999723434, 3.3199999332428, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.68, damageEffectiveness = 3.68, levelRequirement = 80, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[26] = { 0.72000002861023, 1.0800000429153, 3.3800001144409, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.74, damageEffectiveness = 3.74, levelRequirement = 82, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[27] = { 0.7039999961853, 1.055999994278, 3.4400000572205, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.801, damageEffectiveness = 3.801, levelRequirement = 84, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[28] = { 0.68800002336502, 1.0319999456406, 3.5099999904633, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.862, damageEffectiveness = 3.862, levelRequirement = 86, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[29] = { 0.67199999094009, 1.0080000162125, 3.5699999332428, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.923, damageEffectiveness = 3.923, levelRequirement = 88, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[30] = { 0.65600001811981, 0.98400002717972, 3.6300001144409, 15, attackSpeedMultiplier = -15, baseMultiplier = 3.984, damageEffectiveness = 3.984, levelRequirement = 90, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[31] = { 0.64800000190735, 0.97200000286102, 3.6600000858307, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.015, damageEffectiveness = 4.015, levelRequirement = 91, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[32] = { 0.63999998569489, 0.95999997854233, 3.6900000572205, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.046, damageEffectiveness = 4.046, levelRequirement = 92, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[33] = { 0.63200002908707, 0.94800001382828, 3.7300000190735, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.077, damageEffectiveness = 4.077, levelRequirement = 93, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[34] = { 0.6240000128746, 0.93599998950958, 3.7599999904633, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.108, damageEffectiveness = 4.108, levelRequirement = 94, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[35] = { 0.61599999666214, 0.92400002479553, 3.789999961853, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.139, damageEffectiveness = 4.139, levelRequirement = 95, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[36] = { 0.60799998044968, 0.91200000047684, 3.8199999332428, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.17, damageEffectiveness = 4.17, levelRequirement = 96, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[37] = { 0.60000002384186, 0.89999997615814, 3.8499999046326, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.202, damageEffectiveness = 4.202, levelRequirement = 97, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[38] = { 0.59200000762939, 0.88800001144409, 3.8800001144409, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.233, damageEffectiveness = 4.233, levelRequirement = 98, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[39] = { 0.58399999141693, 0.8759999871254, 3.9200000762939, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.266, damageEffectiveness = 4.266, levelRequirement = 99, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[40] = { 0.57599997520447, 0.86400002241135, 3.9500000476837, 15, attackSpeedMultiplier = -15, baseMultiplier = 4.297, damageEffectiveness = 4.297, levelRequirement = 100, statInterpolation = { 3, 3, 3, 1, }, cost = { Mana = 14, }, },
	},
}
skills["BoneshatterAltY"] = {
	name = "Boneshatter of Carnage",
	baseTypeName = "Boneshatter of Carnage",
	color = 1,
	baseEffectiveness = 0.18279999494553,
	incrementalEffectiveness = 0.053700000047684,
	description = "Attack enemies with a forceful melee strike. Stunning an enemy with the strike releases a damaging pulse. Requires a Mace, Sceptre, Axe or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
			area = false,
		},
		{
			name = "Pulse",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 14, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "active_skill_damage_+%_final_vs_stunned_enemies", 1 },
		},
	},
	constantStats = {
		{ "trauma_strike_shockwave_area_of_effect_+%_per_100ms_stun_duration_up_to_400%", 20 },
		{ "base_stun_threshold_reduction_+%", 25 },
	},
	stats = {
		"chance_to_double_stun_duration_%",
	},
	levels = {
		[1] = { 20, attackSpeedMultiplier = -15, baseMultiplier = 3.36, damageEffectiveness = 3.36, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 21, attackSpeedMultiplier = -15, baseMultiplier = 3.505, damageEffectiveness = 3.505, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 22, attackSpeedMultiplier = -15, baseMultiplier = 3.652, damageEffectiveness = 3.652, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[4] = { 23, attackSpeedMultiplier = -15, baseMultiplier = 3.8, damageEffectiveness = 3.8, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 24, attackSpeedMultiplier = -15, baseMultiplier = 3.95, damageEffectiveness = 3.95, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 25, attackSpeedMultiplier = -15, baseMultiplier = 4.094, damageEffectiveness = 4.094, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 26, attackSpeedMultiplier = -15, baseMultiplier = 4.238, damageEffectiveness = 4.238, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 27, attackSpeedMultiplier = -15, baseMultiplier = 4.384, damageEffectiveness = 4.384, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 28, attackSpeedMultiplier = -15, baseMultiplier = 4.53, damageEffectiveness = 4.53, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 29, attackSpeedMultiplier = -15, baseMultiplier = 4.678, damageEffectiveness = 4.678, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 30, attackSpeedMultiplier = -15, baseMultiplier = 4.827, damageEffectiveness = 4.827, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 31, attackSpeedMultiplier = -15, baseMultiplier = 4.976, damageEffectiveness = 4.976, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 32, attackSpeedMultiplier = -15, baseMultiplier = 5.126, damageEffectiveness = 5.126, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 33, attackSpeedMultiplier = -15, baseMultiplier = 5.277, damageEffectiveness = 5.277, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 34, attackSpeedMultiplier = -15, baseMultiplier = 5.429, damageEffectiveness = 5.429, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 35, attackSpeedMultiplier = -15, baseMultiplier = 5.582, damageEffectiveness = 5.582, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 36, attackSpeedMultiplier = -15, baseMultiplier = 5.736, damageEffectiveness = 5.736, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[18] = { 37, attackSpeedMultiplier = -15, baseMultiplier = 5.89, damageEffectiveness = 5.89, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 38, attackSpeedMultiplier = -15, baseMultiplier = 6.046, damageEffectiveness = 6.046, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 39, attackSpeedMultiplier = -15, baseMultiplier = 6.202, damageEffectiveness = 6.202, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[21] = { 40, attackSpeedMultiplier = -15, baseMultiplier = 6.359, damageEffectiveness = 6.359, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[22] = { 41, attackSpeedMultiplier = -15, baseMultiplier = 6.517, damageEffectiveness = 6.517, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[23] = { 42, attackSpeedMultiplier = -15, baseMultiplier = 6.676, damageEffectiveness = 6.676, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[24] = { 43, attackSpeedMultiplier = -15, baseMultiplier = 6.836, damageEffectiveness = 6.836, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[25] = { 44, attackSpeedMultiplier = -15, baseMultiplier = 6.997, damageEffectiveness = 6.997, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 45, attackSpeedMultiplier = -15, baseMultiplier = 7.159, damageEffectiveness = 7.159, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[27] = { 46, attackSpeedMultiplier = -15, baseMultiplier = 7.322, damageEffectiveness = 7.322, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[28] = { 47, attackSpeedMultiplier = -15, baseMultiplier = 7.485, damageEffectiveness = 7.485, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[29] = { 48, attackSpeedMultiplier = -15, baseMultiplier = 7.649, damageEffectiveness = 7.649, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[30] = { 49, attackSpeedMultiplier = -15, baseMultiplier = 7.816, damageEffectiveness = 7.816, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[31] = { 49, attackSpeedMultiplier = -15, baseMultiplier = 7.898, damageEffectiveness = 7.898, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[32] = { 50, attackSpeedMultiplier = -15, baseMultiplier = 7.982, damageEffectiveness = 7.982, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 50, attackSpeedMultiplier = -15, baseMultiplier = 8.065, damageEffectiveness = 8.065, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 51, attackSpeedMultiplier = -15, baseMultiplier = 8.149, damageEffectiveness = 8.149, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[35] = { 51, attackSpeedMultiplier = -15, baseMultiplier = 8.233, damageEffectiveness = 8.233, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[36] = { 52, attackSpeedMultiplier = -15, baseMultiplier = 8.317, damageEffectiveness = 8.317, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[37] = { 52, attackSpeedMultiplier = -15, baseMultiplier = 8.401, damageEffectiveness = 8.401, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[38] = { 53, attackSpeedMultiplier = -15, baseMultiplier = 8.486, damageEffectiveness = 8.486, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[39] = { 53, attackSpeedMultiplier = -15, baseMultiplier = 8.57, damageEffectiveness = 8.57, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[40] = { 54, attackSpeedMultiplier = -15, baseMultiplier = 8.656, damageEffectiveness = 8.656, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 14, }, },
	},
}
skills["ChainHook"] = {
	name = "Chain Hook",
	baseTypeName = "Chain Hook",
	color = 1,
	description = "When used at range, throws out a chain, pulling you to the enemy hit dealing damage in an area behind them. When close to the enemy, just causes the area damage directly. Requires a One Handed Mace, Sceptre, Sword or Axe.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Movement] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["chain_strike_cone_radius_+_per_x_rage"] = {
			mod("AreaOfEffect", "BASE", nil, 0, 0, { type = "Multiplier", var = "Rage", div = 5 }),
			div = 5,
		},
		["quality_display_chain_hook_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		Default = {
			{ "gain_x_rage_on_attack_hit", 0.05 },
		},
	},
	constantStats = {
		{ "chain_strike_cone_radius_+_per_x_rage", 5 },
		{ "gain_x_rage_on_attack_hit", 2 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 20, baseMultiplier = 1.711, damageEffectiveness = 1.711, levelRequirement = 12, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 20, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 15, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 20, baseMultiplier = 1.871, damageEffectiveness = 1.871, levelRequirement = 19, cost = { Mana = 6, }, },
		[4] = { attackSpeedMultiplier = 20, baseMultiplier = 1.959, damageEffectiveness = 1.959, levelRequirement = 23, cost = { Mana = 6, }, },
		[5] = { attackSpeedMultiplier = 20, baseMultiplier = 2.05, damageEffectiveness = 2.05, levelRequirement = 27, cost = { Mana = 6, }, },
		[6] = { attackSpeedMultiplier = 20, baseMultiplier = 2.146, damageEffectiveness = 2.146, levelRequirement = 31, cost = { Mana = 6, }, },
		[7] = { attackSpeedMultiplier = 20, baseMultiplier = 2.246, damageEffectiveness = 2.246, levelRequirement = 35, cost = { Mana = 6, }, },
		[8] = { attackSpeedMultiplier = 20, baseMultiplier = 2.346, damageEffectiveness = 2.346, levelRequirement = 38, cost = { Mana = 7, }, },
		[9] = { attackSpeedMultiplier = 20, baseMultiplier = 2.451, damageEffectiveness = 2.451, levelRequirement = 41, cost = { Mana = 7, }, },
		[10] = { attackSpeedMultiplier = 20, baseMultiplier = 2.561, damageEffectiveness = 2.561, levelRequirement = 44, cost = { Mana = 7, }, },
		[11] = { attackSpeedMultiplier = 20, baseMultiplier = 2.675, damageEffectiveness = 2.675, levelRequirement = 47, cost = { Mana = 7, }, },
		[12] = { attackSpeedMultiplier = 20, baseMultiplier = 2.794, damageEffectiveness = 2.794, levelRequirement = 50, cost = { Mana = 7, }, },
		[13] = { attackSpeedMultiplier = 20, baseMultiplier = 2.918, damageEffectiveness = 2.918, levelRequirement = 53, cost = { Mana = 7, }, },
		[14] = { attackSpeedMultiplier = 20, baseMultiplier = 3.049, damageEffectiveness = 3.049, levelRequirement = 56, cost = { Mana = 8, }, },
		[15] = { attackSpeedMultiplier = 20, baseMultiplier = 3.185, damageEffectiveness = 3.185, levelRequirement = 59, cost = { Mana = 8, }, },
		[16] = { attackSpeedMultiplier = 20, baseMultiplier = 3.325, damageEffectiveness = 3.325, levelRequirement = 62, cost = { Mana = 8, }, },
		[17] = { attackSpeedMultiplier = 20, baseMultiplier = 3.468, damageEffectiveness = 3.468, levelRequirement = 64, cost = { Mana = 8, }, },
		[18] = { attackSpeedMultiplier = 20, baseMultiplier = 3.616, damageEffectiveness = 3.616, levelRequirement = 66, cost = { Mana = 8, }, },
		[19] = { attackSpeedMultiplier = 20, baseMultiplier = 3.771, damageEffectiveness = 3.771, levelRequirement = 68, cost = { Mana = 8, }, },
		[20] = { attackSpeedMultiplier = 20, baseMultiplier = 3.931, damageEffectiveness = 3.931, levelRequirement = 70, cost = { Mana = 8, }, },
		[21] = { attackSpeedMultiplier = 20, baseMultiplier = 4.099, damageEffectiveness = 4.099, levelRequirement = 72, cost = { Mana = 8, }, },
		[22] = { attackSpeedMultiplier = 20, baseMultiplier = 4.273, damageEffectiveness = 4.273, levelRequirement = 74, cost = { Mana = 9, }, },
		[23] = { attackSpeedMultiplier = 20, baseMultiplier = 4.456, damageEffectiveness = 4.456, levelRequirement = 76, cost = { Mana = 9, }, },
		[24] = { attackSpeedMultiplier = 20, baseMultiplier = 4.646, damageEffectiveness = 4.646, levelRequirement = 78, cost = { Mana = 9, }, },
		[25] = { attackSpeedMultiplier = 20, baseMultiplier = 4.845, damageEffectiveness = 4.845, levelRequirement = 80, cost = { Mana = 9, }, },
		[26] = { attackSpeedMultiplier = 20, baseMultiplier = 5.051, damageEffectiveness = 5.051, levelRequirement = 82, cost = { Mana = 9, }, },
		[27] = { attackSpeedMultiplier = 20, baseMultiplier = 5.266, damageEffectiveness = 5.266, levelRequirement = 84, cost = { Mana = 9, }, },
		[28] = { attackSpeedMultiplier = 20, baseMultiplier = 5.49, damageEffectiveness = 5.49, levelRequirement = 86, cost = { Mana = 9, }, },
		[29] = { attackSpeedMultiplier = 20, baseMultiplier = 5.725, damageEffectiveness = 5.725, levelRequirement = 88, cost = { Mana = 9, }, },
		[30] = { attackSpeedMultiplier = 20, baseMultiplier = 5.968, damageEffectiveness = 5.968, levelRequirement = 90, cost = { Mana = 9, }, },
		[31] = { attackSpeedMultiplier = 20, baseMultiplier = 6.334, damageEffectiveness = 6.334, levelRequirement = 91, cost = { Mana = 10, }, },
		[32] = { attackSpeedMultiplier = 20, baseMultiplier = 6.469, damageEffectiveness = 6.469, levelRequirement = 92, cost = { Mana = 10, }, },
		[33] = { attackSpeedMultiplier = 20, baseMultiplier = 6.607, damageEffectiveness = 6.607, levelRequirement = 93, cost = { Mana = 10, }, },
		[34] = { attackSpeedMultiplier = 20, baseMultiplier = 6.746, damageEffectiveness = 6.746, levelRequirement = 94, cost = { Mana = 10, }, },
		[35] = { attackSpeedMultiplier = 20, baseMultiplier = 6.89, damageEffectiveness = 6.89, levelRequirement = 95, cost = { Mana = 10, }, },
		[36] = { attackSpeedMultiplier = 20, baseMultiplier = 7.037, damageEffectiveness = 7.037, levelRequirement = 96, cost = { Mana = 10, }, },
		[37] = { attackSpeedMultiplier = 20, baseMultiplier = 7.186, damageEffectiveness = 7.186, levelRequirement = 97, cost = { Mana = 10, }, },
		[38] = { attackSpeedMultiplier = 20, baseMultiplier = 7.339, damageEffectiveness = 7.339, levelRequirement = 98, cost = { Mana = 10, }, },
		[39] = { attackSpeedMultiplier = 20, baseMultiplier = 7.494, damageEffectiveness = 7.494, levelRequirement = 99, cost = { Mana = 10, }, },
		[40] = { attackSpeedMultiplier = 20, baseMultiplier = 7.654, damageEffectiveness = 7.654, levelRequirement = 100, cost = { Mana = 10, }, },
	},
}
skills["ChainHookAltY"] = {
	name = "Chain Hook of Trarthus",
	baseTypeName = "Chain Hook of Trarthus",
	color = 1,
	description = "Throws chains ahead of you, attaching them to targets hit. Enemies chained to you will grant rage when hit. When chains are broken, they snap and deal attack damage in an area around the target they were attached to. Requires a One Handed Mace, Sceptre, Sword or Axe.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["chain_strike_cone_radius_+_per_x_rage"] = {
			mod("AreaOfEffect", "BASE", nil, 0, 0, { type = "Multiplier", var = "Rage", div = 5 }),
			div = 5,
		},
		["chain_hook_attachment_rage_to_gain_per_hit"] = {
			flag("Condition:CanGainRage", { type = "GlobalEffect", effectType = "Buff", effectName = "Rage" } ),
		},
		["chain_hook_attachment_range"] = {
			skill("radiusSecondary", nil),
		}
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("radiusLabel", "Strike area:"),
		skill("radiusSecondaryLabel", "Chain length:"),
	},
	qualityStats = {
		Default = {
			{ "chain_hook_attaches_to_X_targets", 0.15 },
		},
	},
	constantStats = {
		{ "chain_strike_cone_radius_+_per_x_rage", 5 },
		{ "chain_hook_attaches_to_X_targets", 8 },
		{ "chain_hook_attachment_range", 60 },
		{ "chain_hook_attachment_rage_to_gain_per_hit", 1 },
		{ "chain_hook_max_attached_targets", 16 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 20, baseMultiplier = 2.138, damageEffectiveness = 2.138, levelRequirement = 12, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 20, baseMultiplier = 2.284, damageEffectiveness = 2.284, levelRequirement = 15, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 20, baseMultiplier = 2.43, damageEffectiveness = 2.43, levelRequirement = 19, cost = { Mana = 6, }, },
		[4] = { attackSpeedMultiplier = 20, baseMultiplier = 2.576, damageEffectiveness = 2.576, levelRequirement = 23, cost = { Mana = 6, }, },
		[5] = { attackSpeedMultiplier = 20, baseMultiplier = 2.722, damageEffectiveness = 2.722, levelRequirement = 27, cost = { Mana = 6, }, },
		[6] = { attackSpeedMultiplier = 20, baseMultiplier = 2.868, damageEffectiveness = 2.868, levelRequirement = 31, cost = { Mana = 6, }, },
		[7] = { attackSpeedMultiplier = 20, baseMultiplier = 3.014, damageEffectiveness = 3.014, levelRequirement = 35, cost = { Mana = 6, }, },
		[8] = { attackSpeedMultiplier = 20, baseMultiplier = 3.16, damageEffectiveness = 3.16, levelRequirement = 38, cost = { Mana = 7, }, },
		[9] = { attackSpeedMultiplier = 20, baseMultiplier = 3.306, damageEffectiveness = 3.306, levelRequirement = 41, cost = { Mana = 7, }, },
		[10] = { attackSpeedMultiplier = 20, baseMultiplier = 3.452, damageEffectiveness = 3.452, levelRequirement = 44, cost = { Mana = 7, }, },
		[11] = { attackSpeedMultiplier = 20, baseMultiplier = 3.598, damageEffectiveness = 3.598, levelRequirement = 47, cost = { Mana = 7, }, },
		[12] = { attackSpeedMultiplier = 20, baseMultiplier = 3.744, damageEffectiveness = 3.744, levelRequirement = 50, cost = { Mana = 7, }, },
		[13] = { attackSpeedMultiplier = 20, baseMultiplier = 3.89, damageEffectiveness = 3.89, levelRequirement = 53, cost = { Mana = 7, }, },
		[14] = { attackSpeedMultiplier = 20, baseMultiplier = 4.036, damageEffectiveness = 4.036, levelRequirement = 56, cost = { Mana = 8, }, },
		[15] = { attackSpeedMultiplier = 20, baseMultiplier = 4.182, damageEffectiveness = 4.182, levelRequirement = 59, cost = { Mana = 8, }, },
		[16] = { attackSpeedMultiplier = 20, baseMultiplier = 4.328, damageEffectiveness = 4.328, levelRequirement = 62, cost = { Mana = 8, }, },
		[17] = { attackSpeedMultiplier = 20, baseMultiplier = 4.474, damageEffectiveness = 4.474, levelRequirement = 64, cost = { Mana = 8, }, },
		[18] = { attackSpeedMultiplier = 20, baseMultiplier = 4.62, damageEffectiveness = 4.62, levelRequirement = 66, cost = { Mana = 8, }, },
		[19] = { attackSpeedMultiplier = 20, baseMultiplier = 4.766, damageEffectiveness = 4.766, levelRequirement = 68, cost = { Mana = 8, }, },
		[20] = { attackSpeedMultiplier = 20, baseMultiplier = 4.913, damageEffectiveness = 4.913, levelRequirement = 70, cost = { Mana = 8, }, },
		[21] = { attackSpeedMultiplier = 20, baseMultiplier = 5.059, damageEffectiveness = 5.059, levelRequirement = 72, cost = { Mana = 8, }, },
		[22] = { attackSpeedMultiplier = 20, baseMultiplier = 5.205, damageEffectiveness = 5.205, levelRequirement = 74, cost = { Mana = 9, }, },
		[23] = { attackSpeedMultiplier = 20, baseMultiplier = 5.351, damageEffectiveness = 5.351, levelRequirement = 76, cost = { Mana = 9, }, },
		[24] = { attackSpeedMultiplier = 20, baseMultiplier = 5.497, damageEffectiveness = 5.497, levelRequirement = 78, cost = { Mana = 9, }, },
		[25] = { attackSpeedMultiplier = 20, baseMultiplier = 5.643, damageEffectiveness = 5.643, levelRequirement = 80, cost = { Mana = 9, }, },
		[26] = { attackSpeedMultiplier = 20, baseMultiplier = 5.789, damageEffectiveness = 5.789, levelRequirement = 82, cost = { Mana = 9, }, },
		[27] = { attackSpeedMultiplier = 20, baseMultiplier = 5.935, damageEffectiveness = 5.935, levelRequirement = 84, cost = { Mana = 9, }, },
		[28] = { attackSpeedMultiplier = 20, baseMultiplier = 6.081, damageEffectiveness = 6.081, levelRequirement = 86, cost = { Mana = 9, }, },
		[29] = { attackSpeedMultiplier = 20, baseMultiplier = 6.227, damageEffectiveness = 6.227, levelRequirement = 88, cost = { Mana = 9, }, },
		[30] = { attackSpeedMultiplier = 20, baseMultiplier = 6.373, damageEffectiveness = 6.373, levelRequirement = 90, cost = { Mana = 9, }, },
		[31] = { attackSpeedMultiplier = 20, baseMultiplier = 6.446, damageEffectiveness = 6.446, levelRequirement = 91, cost = { Mana = 10, }, },
		[32] = { attackSpeedMultiplier = 20, baseMultiplier = 6.519, damageEffectiveness = 6.519, levelRequirement = 92, cost = { Mana = 10, }, },
		[33] = { attackSpeedMultiplier = 20, baseMultiplier = 6.592, damageEffectiveness = 6.592, levelRequirement = 93, cost = { Mana = 10, }, },
		[34] = { attackSpeedMultiplier = 20, baseMultiplier = 6.665, damageEffectiveness = 6.665, levelRequirement = 94, cost = { Mana = 10, }, },
		[35] = { attackSpeedMultiplier = 20, baseMultiplier = 6.738, damageEffectiveness = 6.738, levelRequirement = 95, cost = { Mana = 10, }, },
		[36] = { attackSpeedMultiplier = 20, baseMultiplier = 6.811, damageEffectiveness = 6.811, levelRequirement = 96, cost = { Mana = 10, }, },
		[37] = { attackSpeedMultiplier = 20, baseMultiplier = 6.884, damageEffectiveness = 6.884, levelRequirement = 97, cost = { Mana = 10, }, },
		[38] = { attackSpeedMultiplier = 20, baseMultiplier = 6.957, damageEffectiveness = 6.957, levelRequirement = 98, cost = { Mana = 10, }, },
		[39] = { attackSpeedMultiplier = 20, baseMultiplier = 7.03, damageEffectiveness = 7.03, levelRequirement = 99, cost = { Mana = 10, }, },
		[40] = { attackSpeedMultiplier = 20, baseMultiplier = 7.103, damageEffectiveness = 7.103, levelRequirement = 100, cost = { Mana = 10, }, },
	},
}
skills["Cleave"] = {
	name = "Cleave",
	baseTypeName = "Cleave",
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cleave_+1_base_radius_per_nearby_enemy_up_to_10"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "NearbyEnemies", limit = 10, limitTotal = true })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 20),
	},
	qualityStats = {
		Default = {
			{ "cleave_+1_base_radius_per_nearby_enemy_up_to_10", 1 },
		},
	},
	constantStats = {
		{ "active_skill_merged_damage_+%_final_while_dual_wielding", -40 },
	},
	stats = {
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -20, baseMultiplier = 1.794, damageEffectiveness = 1.794, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 1, attackSpeedMultiplier = -20, baseMultiplier = 1.887, damageEffectiveness = 1.887, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 1, attackSpeedMultiplier = -20, baseMultiplier = 1.989, damageEffectiveness = 1.989, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 2, attackSpeedMultiplier = -20, baseMultiplier = 2.1, damageEffectiveness = 2.1, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 2, attackSpeedMultiplier = -20, baseMultiplier = 2.221, damageEffectiveness = 2.221, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 3, attackSpeedMultiplier = -20, baseMultiplier = 2.354, damageEffectiveness = 2.354, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 3, attackSpeedMultiplier = -20, baseMultiplier = 2.489, damageEffectiveness = 2.489, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 2.631, damageEffectiveness = 2.631, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 2.783, damageEffectiveness = 2.783, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.943, damageEffectiveness = 2.943, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.111, damageEffectiveness = 3.111, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 3.289, damageEffectiveness = 3.289, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 3.478, damageEffectiveness = 3.478, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.677, damageEffectiveness = 3.677, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.887, damageEffectiveness = 3.887, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 4.11, damageEffectiveness = 4.11, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 4.343, damageEffectiveness = 4.343, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 4.591, damageEffectiveness = 4.591, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 4.844, damageEffectiveness = 4.844, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 5.112, damageEffectiveness = 5.112, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 5.385, damageEffectiveness = 5.385, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 11, attackSpeedMultiplier = -20, baseMultiplier = 5.673, damageEffectiveness = 5.673, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 11, attackSpeedMultiplier = -20, baseMultiplier = 5.976, damageEffectiveness = 5.976, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 6.295, damageEffectiveness = 6.295, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 6.632, damageEffectiveness = 6.632, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 13, attackSpeedMultiplier = -20, baseMultiplier = 6.985, damageEffectiveness = 6.985, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 13, attackSpeedMultiplier = -20, baseMultiplier = 7.358, damageEffectiveness = 7.358, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 14, attackSpeedMultiplier = -20, baseMultiplier = 7.751, damageEffectiveness = 7.751, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 14, attackSpeedMultiplier = -20, baseMultiplier = 8.165, damageEffectiveness = 8.165, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 8.6, damageEffectiveness = 8.6, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 9.27, damageEffectiveness = 9.27, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 9.517, damageEffectiveness = 9.517, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 9.771, damageEffectiveness = 9.771, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 10.03, damageEffectiveness = 10.03, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 10.297, damageEffectiveness = 10.297, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 10.572, damageEffectiveness = 10.572, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 10.854, damageEffectiveness = 10.854, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 11.142, damageEffectiveness = 11.142, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 11.439, damageEffectiveness = 11.439, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 11.743, damageEffectiveness = 11.743, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["CleaveAltX"] = {
	name = "Cleave of Rage",
	baseTypeName = "Cleave of Rage",
	color = 1,
	description = "The character swings both their weapons in an arc, damaging monsters in an area in front of them. Requires dual wielding both an Axe and a Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.DualWieldOnly] = true, [SkillType.DualWieldRequiresDifferentTypes] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["chain_strike_cone_radius_+_per_x_rage"] = {
			mod("AreaOfEffect", "BASE", nil, 0, 0, { type = "Multiplier", var = "Rage", div = 5 }),
			div = 5,
		},
		["quality_display_chain_hook_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 20),
	},
	qualityStats = {
		Default = {
			{ "gain_x_rage_on_attack_hit", 0.05 },
		},
	},
	constantStats = {
		{ "active_skill_merged_damage_+%_final_while_dual_wielding", -40 },
		{ "chain_strike_cone_radius_+_per_x_rage", 5 },
		{ "gain_x_rage_on_attack_hit", 2 },
	},
	stats = {
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 1.794, damageEffectiveness = 1.794, levelRequirement = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 1.887, damageEffectiveness = 1.887, levelRequirement = 2, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 1.989, damageEffectiveness = 1.989, levelRequirement = 4, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 2.1, damageEffectiveness = 2.1, levelRequirement = 7, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 2.221, damageEffectiveness = 2.221, levelRequirement = 11, cost = { Mana = 8, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 2.354, damageEffectiveness = 2.354, levelRequirement = 16, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 2.489, damageEffectiveness = 2.489, levelRequirement = 20, cost = { Mana = 9, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 2.631, damageEffectiveness = 2.631, levelRequirement = 24, cost = { Mana = 9, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 2.783, damageEffectiveness = 2.783, levelRequirement = 28, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 2.943, damageEffectiveness = 2.943, levelRequirement = 32, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 3.111, damageEffectiveness = 3.111, levelRequirement = 36, cost = { Mana = 10, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 3.289, damageEffectiveness = 3.289, levelRequirement = 40, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 3.478, damageEffectiveness = 3.478, levelRequirement = 44, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 3.677, damageEffectiveness = 3.677, levelRequirement = 48, cost = { Mana = 11, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 3.887, damageEffectiveness = 3.887, levelRequirement = 52, cost = { Mana = 11, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 4.11, damageEffectiveness = 4.11, levelRequirement = 56, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 4.343, damageEffectiveness = 4.343, levelRequirement = 60, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 4.591, damageEffectiveness = 4.591, levelRequirement = 64, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 4.844, damageEffectiveness = 4.844, levelRequirement = 67, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 5.112, damageEffectiveness = 5.112, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 5.385, damageEffectiveness = 5.385, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 5.673, damageEffectiveness = 5.673, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 5.976, damageEffectiveness = 5.976, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 6.295, damageEffectiveness = 6.295, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 6.632, damageEffectiveness = 6.632, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 6.985, damageEffectiveness = 6.985, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 7.358, damageEffectiveness = 7.358, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 7.751, damageEffectiveness = 7.751, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 8.165, damageEffectiveness = 8.165, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 8.6, damageEffectiveness = 8.6, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 9.27, damageEffectiveness = 9.27, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 9.517, damageEffectiveness = 9.517, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 9.771, damageEffectiveness = 9.771, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 10.03, damageEffectiveness = 10.03, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 10.297, damageEffectiveness = 10.297, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 10.572, damageEffectiveness = 10.572, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 10.854, damageEffectiveness = 10.854, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 11.142, damageEffectiveness = 11.142, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 11.439, damageEffectiveness = 11.439, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 11.743, damageEffectiveness = 11.743, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["VaalCleave"] = {
	name = "Vaal Cleave",
	baseTypeName = "Vaal Cleave",
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Killing Blows on Rare or Unique enemies grant a buff that improves Cleave for a duration. Killing Blows on Rare Enemies also steal their modifiers for a secondary duration. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Vaal] = true, [SkillType.Duration] = true, [SkillType.Buff] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cleave_+1_base_radius_per_nearby_enemy_up_to_10"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "NearbyEnemies", limit = 10, limitTotal = true })
		},
		["vaal_cleave_executioner_damage_against_enemies_on_low_life_+%"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "ActorCondition", actor = "enemy", var = "LowLife" }, { type = "SkillName", skillName = "Cleave", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Vaal Cleave", unscalable = true } ),
		},
		["vaal_cleave_executioner_area_of_effect_+%"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "SkillName", skillName = "Cleave", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Vaal Cleave", unscalable = true } ),
		},
	},
	baseFlags = {
		attack = true,
		area = true,
		duration = true,
		melee = true,
	},
	baseMods = {
		mod("CullPercent", "MAX", 10, 0, 0, { type = "SkillName", skillName = "Cleave", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Vaal Cleave", unscalable = true } ),
	},
	qualityStats = {
		Default = {
			{ "cleave_+1_base_radius_per_nearby_enemy_up_to_10", 1 },
		},
	},
	constantStats = {
		{ "active_skill_merged_damage_+%_final_while_dual_wielding", -40 },
		{ "base_skill_effect_duration", 20000 },
		{ "base_secondary_skill_effect_duration", 20000 },
		{ "vaal_cleave_executioner_area_of_effect_+%", 60 },
		{ "vaal_cleave_executioner_damage_against_enemies_on_low_life_+%", 60 },
		{ "additional_weapon_base_attack_time_ms", 800 },
	},
	stats = {
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
		"console_skill_dont_chase",
		"kill_enemy_on_hit_if_under_10%_life",
		"vaal_cleave_steal_mods_on_kill",
		"cannot_cancel_skill_before_contact_point",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"global_always_hit",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 2.875, damageEffectiveness = 2.875, levelRequirement = 1, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[2] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 3.019, damageEffectiveness = 3.019, levelRequirement = 2, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[3] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 3.17, damageEffectiveness = 3.17, levelRequirement = 4, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[4] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 3.328, damageEffectiveness = 3.328, levelRequirement = 7, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[5] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 3.495, damageEffectiveness = 3.495, levelRequirement = 11, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[6] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 3.669, damageEffectiveness = 3.669, levelRequirement = 16, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[7] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 3.853, damageEffectiveness = 3.853, levelRequirement = 20, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[8] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 4.045, damageEffectiveness = 4.045, levelRequirement = 24, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[9] = { 19, attackSpeedMultiplier = -20, baseMultiplier = 4.248, damageEffectiveness = 4.248, levelRequirement = 28, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[10] = { 19, attackSpeedMultiplier = -20, baseMultiplier = 4.46, damageEffectiveness = 4.46, levelRequirement = 32, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[11] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 4.683, damageEffectiveness = 4.683, levelRequirement = 36, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[12] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 4.917, damageEffectiveness = 4.917, levelRequirement = 40, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[13] = { 21, attackSpeedMultiplier = -20, baseMultiplier = 5.163, damageEffectiveness = 5.163, levelRequirement = 44, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[14] = { 21, attackSpeedMultiplier = -20, baseMultiplier = 5.421, damageEffectiveness = 5.421, levelRequirement = 48, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[15] = { 22, attackSpeedMultiplier = -20, baseMultiplier = 5.692, damageEffectiveness = 5.692, levelRequirement = 52, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[16] = { 22, attackSpeedMultiplier = -20, baseMultiplier = 5.977, damageEffectiveness = 5.977, levelRequirement = 56, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[17] = { 23, attackSpeedMultiplier = -20, baseMultiplier = 6.276, damageEffectiveness = 6.276, levelRequirement = 60, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[18] = { 23, attackSpeedMultiplier = -20, baseMultiplier = 6.59, damageEffectiveness = 6.59, levelRequirement = 64, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[19] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 6.919, damageEffectiveness = 6.919, levelRequirement = 67, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[20] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 7.265, damageEffectiveness = 7.265, levelRequirement = 70, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[21] = { 25, attackSpeedMultiplier = -20, baseMultiplier = 7.628, damageEffectiveness = 7.628, levelRequirement = 72, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[22] = { 25, attackSpeedMultiplier = -20, baseMultiplier = 8.01, damageEffectiveness = 8.01, levelRequirement = 74, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[23] = { 26, attackSpeedMultiplier = -20, baseMultiplier = 8.41, damageEffectiveness = 8.41, levelRequirement = 76, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[24] = { 26, attackSpeedMultiplier = -20, baseMultiplier = 8.831, damageEffectiveness = 8.831, levelRequirement = 78, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[25] = { 27, attackSpeedMultiplier = -20, baseMultiplier = 9.272, damageEffectiveness = 9.272, levelRequirement = 80, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[26] = { 27, attackSpeedMultiplier = -20, baseMultiplier = 9.736, damageEffectiveness = 9.736, levelRequirement = 82, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[27] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 10.223, damageEffectiveness = 10.223, levelRequirement = 84, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[28] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 10.734, damageEffectiveness = 10.734, levelRequirement = 86, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[29] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 11.27, damageEffectiveness = 11.27, levelRequirement = 88, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[30] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 11.834, damageEffectiveness = 11.834, levelRequirement = 90, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[31] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 12.736, damageEffectiveness = 12.736, levelRequirement = 91, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[32] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 13.055, damageEffectiveness = 13.055, levelRequirement = 92, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[33] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 13.381, damageEffectiveness = 13.381, levelRequirement = 93, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[34] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 13.716, damageEffectiveness = 13.716, levelRequirement = 94, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[35] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 14.058, damageEffectiveness = 14.058, levelRequirement = 95, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[36] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 14.41, damageEffectiveness = 14.41, levelRequirement = 96, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[37] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 14.77, damageEffectiveness = 14.77, levelRequirement = 97, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[38] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 15.139, damageEffectiveness = 15.139, levelRequirement = 98, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[39] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 15.518, damageEffectiveness = 15.518, levelRequirement = 99, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
		[40] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 15.906, damageEffectiveness = 15.906, levelRequirement = 100, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, }, cost = { Soul = 25, }, },
	},
}
skills["ConsecratedPath"] = {
	name = "Consecrated Path",
	baseTypeName = "Consecrated Path",
	color = 1,
	description = "Slams the ground at a targeted location. If an enemy is near where you target, you'll teleport to it from a short distance away, slam, and create an area of consecrated ground. Can't be supported by Multistrike, and requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Fire] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["groundslam_damage_to_close_targets_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Condition", var = "AtCloseRange" })
		},
		["quality_display_groundslam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 23),
	},
	qualityStats = {
		Default = {
			{ "groundslam_damage_to_close_targets_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "base_skill_effect_duration", 4000 },
		{ "groundslam_damage_to_close_targets_+%_final", 20 },
		{ "ignite_art_variation", 7 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_elemental_is_holy",
		"quality_display_groundslam_is_gem",
	},
	levels = {
		[1] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.27, damageEffectiveness = 2.27, levelRequirement = 28, cost = { Mana = 9, }, },
		[2] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.347, damageEffectiveness = 2.347, levelRequirement = 31, cost = { Mana = 9, }, },
		[3] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.428, damageEffectiveness = 2.428, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.511, damageEffectiveness = 2.511, levelRequirement = 37, cost = { Mana = 10, }, },
		[5] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.596, damageEffectiveness = 2.596, levelRequirement = 40, cost = { Mana = 10, }, },
		[6] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.679, damageEffectiveness = 2.679, levelRequirement = 42, cost = { Mana = 10, }, },
		[7] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.766, damageEffectiveness = 2.766, levelRequirement = 44, cost = { Mana = 10, }, },
		[8] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.854, damageEffectiveness = 2.854, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.041, damageEffectiveness = 3.041, levelRequirement = 50, cost = { Mana = 11, }, },
		[11] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.139, damageEffectiveness = 3.139, levelRequirement = 52, cost = { Mana = 11, }, },
		[12] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.239, damageEffectiveness = 3.239, levelRequirement = 54, cost = { Mana = 11, }, },
		[13] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.344, damageEffectiveness = 3.344, levelRequirement = 56, cost = { Mana = 11, }, },
		[14] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.451, damageEffectiveness = 3.451, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.561, damageEffectiveness = 3.561, levelRequirement = 60, cost = { Mana = 12, }, },
		[16] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.676, damageEffectiveness = 3.676, levelRequirement = 62, cost = { Mana = 12, }, },
		[17] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.794, damageEffectiveness = 3.794, levelRequirement = 64, cost = { Mana = 12, }, },
		[18] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.915, damageEffectiveness = 3.915, levelRequirement = 66, cost = { Mana = 12, }, },
		[19] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.041, damageEffectiveness = 4.041, levelRequirement = 68, cost = { Mana = 12, }, },
		[20] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.17, damageEffectiveness = 4.17, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.304, damageEffectiveness = 4.304, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.441, damageEffectiveness = 4.441, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.583, damageEffectiveness = 4.583, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.731, damageEffectiveness = 4.731, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.881, damageEffectiveness = 4.881, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.037, damageEffectiveness = 5.037, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.199, damageEffectiveness = 5.199, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.365, damageEffectiveness = 5.365, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.537, damageEffectiveness = 5.537, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.714, damageEffectiveness = 5.714, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.97, damageEffectiveness = 5.97, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.066, damageEffectiveness = 6.066, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.162, damageEffectiveness = 6.162, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.26, damageEffectiveness = 6.26, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.36, damageEffectiveness = 6.36, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.462, damageEffectiveness = 6.462, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.564, damageEffectiveness = 6.564, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.669, damageEffectiveness = 6.669, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.775, damageEffectiveness = 6.775, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 6.882, damageEffectiveness = 6.882, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["ConsecratedPathAltX"] = {
	name = "Consecrated Path of Endurance",
	baseTypeName = "Consecrated Path of Endurance",
	color = 1,
	description = "Slams the ground at a targeted location. If an enemy is near where you target, you'll teleport to it from a short distance away, slam, and create an area of consecrated ground. The cooldown can be bypassed by expending an Endurance Charge. Can't be supported by Multistrike, and requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Fire] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["groundslam_damage_to_close_targets_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Condition", var = "AtCloseRange" })
		},
		["quality_display_groundslam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 23),
	},
	qualityStats = {
		Default = {
			{ "groundslam_damage_to_close_targets_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "base_skill_effect_duration", 4000 },
		{ "groundslam_damage_to_close_targets_+%_final", 20 },
		{ "ignite_art_variation", 7 },
		{ "active_skill_area_of_effect_+%_final_per_endurance_charge", 10 },
		{ "active_skill_attack_damage_+%_final_per_endurance_charge", 10 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_elemental_is_holy",
		"quality_display_groundslam_is_gem",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.665, cooldown = 2, damageEffectiveness = 1.665, levelRequirement = 28, storedUses = 1, cost = { Mana = 9, }, },
		[2] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.722, cooldown = 2, damageEffectiveness = 1.722, levelRequirement = 31, storedUses = 1, cost = { Mana = 9, }, },
		[3] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.78, cooldown = 2, damageEffectiveness = 1.78, levelRequirement = 34, storedUses = 1, cost = { Mana = 10, }, },
		[4] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.841, cooldown = 2, damageEffectiveness = 1.841, levelRequirement = 37, storedUses = 1, cost = { Mana = 10, }, },
		[5] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.903, cooldown = 2, damageEffectiveness = 1.903, levelRequirement = 40, storedUses = 1, cost = { Mana = 10, }, },
		[6] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 1.965, cooldown = 2, damageEffectiveness = 1.965, levelRequirement = 42, storedUses = 1, cost = { Mana = 10, }, },
		[7] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.028, cooldown = 2, damageEffectiveness = 2.028, levelRequirement = 44, storedUses = 1, cost = { Mana = 10, }, },
		[8] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.093, cooldown = 2, damageEffectiveness = 2.093, levelRequirement = 46, storedUses = 1, cost = { Mana = 11, }, },
		[9] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.161, cooldown = 2, damageEffectiveness = 2.161, levelRequirement = 48, storedUses = 1, cost = { Mana = 11, }, },
		[10] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.23, cooldown = 2, damageEffectiveness = 2.23, levelRequirement = 50, storedUses = 1, cost = { Mana = 11, }, },
		[11] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.301, cooldown = 2, damageEffectiveness = 2.301, levelRequirement = 52, storedUses = 1, cost = { Mana = 11, }, },
		[12] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.376, cooldown = 2, damageEffectiveness = 2.376, levelRequirement = 54, storedUses = 1, cost = { Mana = 11, }, },
		[13] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.452, cooldown = 2, damageEffectiveness = 2.452, levelRequirement = 56, storedUses = 1, cost = { Mana = 11, }, },
		[14] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.53, cooldown = 2, damageEffectiveness = 2.53, levelRequirement = 58, storedUses = 1, cost = { Mana = 12, }, },
		[15] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.612, cooldown = 2, damageEffectiveness = 2.612, levelRequirement = 60, storedUses = 1, cost = { Mana = 12, }, },
		[16] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.695, cooldown = 2, damageEffectiveness = 2.695, levelRequirement = 62, storedUses = 1, cost = { Mana = 12, }, },
		[17] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.782, cooldown = 2, damageEffectiveness = 2.782, levelRequirement = 64, storedUses = 1, cost = { Mana = 12, }, },
		[18] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.871, cooldown = 2, damageEffectiveness = 2.871, levelRequirement = 66, storedUses = 1, cost = { Mana = 12, }, },
		[19] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 2.964, cooldown = 2, damageEffectiveness = 2.964, levelRequirement = 68, storedUses = 1, cost = { Mana = 12, }, },
		[20] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.058, cooldown = 2, damageEffectiveness = 3.058, levelRequirement = 70, storedUses = 1, cost = { Mana = 13, }, },
		[21] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.156, cooldown = 2, damageEffectiveness = 3.156, levelRequirement = 72, storedUses = 1, cost = { Mana = 13, }, },
		[22] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.258, cooldown = 2, damageEffectiveness = 3.258, levelRequirement = 74, storedUses = 1, cost = { Mana = 13, }, },
		[23] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.362, cooldown = 2, damageEffectiveness = 3.362, levelRequirement = 76, storedUses = 1, cost = { Mana = 13, }, },
		[24] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.47, cooldown = 2, damageEffectiveness = 3.47, levelRequirement = 78, storedUses = 1, cost = { Mana = 13, }, },
		[25] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.581, cooldown = 2, damageEffectiveness = 3.581, levelRequirement = 80, storedUses = 1, cost = { Mana = 13, }, },
		[26] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.694, cooldown = 2, damageEffectiveness = 3.694, levelRequirement = 82, storedUses = 1, cost = { Mana = 14, }, },
		[27] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.812, cooldown = 2, damageEffectiveness = 3.812, levelRequirement = 84, storedUses = 1, cost = { Mana = 14, }, },
		[28] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 3.935, cooldown = 2, damageEffectiveness = 3.935, levelRequirement = 86, storedUses = 1, cost = { Mana = 14, }, },
		[29] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.06, cooldown = 2, damageEffectiveness = 4.06, levelRequirement = 88, storedUses = 1, cost = { Mana = 14, }, },
		[30] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.189, cooldown = 2, damageEffectiveness = 4.189, levelRequirement = 90, storedUses = 1, cost = { Mana = 14, }, },
		[31] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.378, cooldown = 2, damageEffectiveness = 4.378, levelRequirement = 91, storedUses = 1, cost = { Mana = 14, }, },
		[32] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.448, cooldown = 2, damageEffectiveness = 4.448, levelRequirement = 92, storedUses = 1, cost = { Mana = 14, }, },
		[33] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.519, cooldown = 2, damageEffectiveness = 4.519, levelRequirement = 93, storedUses = 1, cost = { Mana = 14, }, },
		[34] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.591, cooldown = 2, damageEffectiveness = 4.591, levelRequirement = 94, storedUses = 1, cost = { Mana = 15, }, },
		[35] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.664, cooldown = 2, damageEffectiveness = 4.664, levelRequirement = 95, storedUses = 1, cost = { Mana = 15, }, },
		[36] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.738, cooldown = 2, damageEffectiveness = 4.738, levelRequirement = 96, storedUses = 1, cost = { Mana = 15, }, },
		[37] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.814, cooldown = 2, damageEffectiveness = 4.814, levelRequirement = 97, storedUses = 1, cost = { Mana = 15, }, },
		[38] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.89, cooldown = 2, damageEffectiveness = 4.89, levelRequirement = 98, storedUses = 1, cost = { Mana = 15, }, },
		[39] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 4.969, cooldown = 2, damageEffectiveness = 4.969, levelRequirement = 99, storedUses = 1, cost = { Mana = 15, }, },
		[40] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = -20, baseMultiplier = 5.047, cooldown = 2, damageEffectiveness = 5.047, levelRequirement = 100, storedUses = 1, cost = { Mana = 15, }, },
	},
}
skills["CorruptingFever"] = {
	name = "Corrupting Fever",
	baseTypeName = "Corrupting Fever",
	color = 1,
	baseEffectiveness = 0.362399995327,
	incrementalEffectiveness = 0.050000000745058,
	description = "Draws out your own blood to power a buff for a duration, letting this skill inflict the Corrupting Blood debuff on enemies you hit, dealing physical damage over time for a short secondary duration. The buff's duration will be refreshed if you spend enough life before it expires.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, [SkillType.DamageOverTime] = true, [SkillType.Totemable] = true, },
	statDescriptionScope = "secondary_debuff_skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		flag("dotIsCorruptingBlood"),
		mod("Multiplier:CorruptingFeverMaxStages", "BASE", 10),
		mod("Damage", "MORE", 100, ModFlag.Dot, 0, { type = "Multiplier", var = "CorruptingFeverStageAfterFirst"}),
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "base_secondary_skill_effect_duration", 1000 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"base_physical_damage_to_deal_per_minute",
		"blood_surge_refresh_on_total_life_spent",
	},
	levels = {
		[1] = { 66.666668156783, 26, cooldown = 1, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 78, }, },
		[2] = { 66.666668156783, 32, cooldown = 1, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 92, }, },
		[3] = { 66.666668156783, 38, cooldown = 1, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 113, }, },
		[4] = { 66.666668156783, 43, cooldown = 1, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 134, }, },
		[5] = { 66.666668156783, 47, cooldown = 1, levelRequirement = 31, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 159, }, },
		[6] = { 66.666668156783, 50, cooldown = 1, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 183, }, },
		[7] = { 66.666668156783, 53, cooldown = 1, levelRequirement = 37, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 203, }, },
		[8] = { 66.666668156783, 56, cooldown = 1, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 222, }, },
		[9] = { 66.666668156783, 67, cooldown = 1, levelRequirement = 43, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 254, }, },
		[10] = { 66.666668156783, 77, cooldown = 1, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 284, }, },
		[11] = { 66.666668156783, 89, cooldown = 1, levelRequirement = 49, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 310, }, },
		[12] = { 66.666668156783, 101, cooldown = 1, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 332, }, },
		[13] = { 66.666668156783, 117, cooldown = 1, levelRequirement = 55, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 385, }, },
		[14] = { 66.666668156783, 133, cooldown = 1, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 398, }, },
		[15] = { 66.666668156783, 144, cooldown = 1, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 407, }, },
		[16] = { 66.666668156783, 155, cooldown = 1, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 425, }, },
		[17] = { 66.666668156783, 169, cooldown = 1, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 441, }, },
		[18] = { 66.666668156783, 185, cooldown = 1, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 508, }, },
		[19] = { 66.666668156783, 201, cooldown = 1, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 515, }, },
		[20] = { 66.666668156783, 205, cooldown = 1, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 520, }, },
		[21] = { 66.666668156783, 210, cooldown = 1, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 585, }, },
		[22] = { 66.666668156783, 226, cooldown = 1, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 653, }, },
		[23] = { 66.666668156783, 239, cooldown = 1, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 726, }, },
		[24] = { 66.666668156783, 252, cooldown = 1, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 802, }, },
		[25] = { 66.666668156783, 262, cooldown = 1, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 881, }, },
		[26] = { 66.666668156783, 270, cooldown = 1, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 963, }, },
		[27] = { 66.666668156783, 275, cooldown = 1, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1047, }, },
		[28] = { 66.666668156783, 290, cooldown = 1, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1134, }, },
		[29] = { 66.666668156783, 305, cooldown = 1, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1223, }, },
		[30] = { 66.666668156783, 318, cooldown = 1, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1312, }, },
		[31] = { 66.666668156783, 335, cooldown = 1, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1351, }, },
		[32] = { 66.666668156783, 351, cooldown = 1, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1388, }, },
		[33] = { 66.666668156783, 368, cooldown = 1, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1427, }, },
		[34] = { 66.666668156783, 386, cooldown = 1, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1463, }, },
		[35] = { 66.666668156783, 405, cooldown = 1, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1500, }, },
		[36] = { 66.666668156783, 423, cooldown = 1, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1534, }, },
		[37] = { 66.666668156783, 443, cooldown = 1, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1570, }, },
		[38] = { 66.666668156783, 463, cooldown = 1, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1601, }, },
		[39] = { 66.666668156783, 484, cooldown = 1, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1633, }, },
		[40] = { 66.666668156783, 504, cooldown = 1, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Life = 1662, }, },
	},
}
skills["CrushingFist"] = {
	name = "Crushing Fist",
	baseTypeName = "Crushing Fist",
	color = 1,
	description = "Retaliate against a blocked hit by calling forth a huge armoured fist to slam into the ground in front of you as you do the same, dealing weapon damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cooldown] = true, [SkillType.Retaliation] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "retaliation_base_use_window_duration_ms", 2000 },
		{ "active_skill_ailment_damage_+%_final", -60 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
		"global_always_hit",
		"skill_cannot_be_exerted",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 20, attackSpeedMultiplier = -30, baseMultiplier = 10.039, cooldown = 4, damageEffectiveness = 10.039, levelRequirement = 4, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 20, attackSpeedMultiplier = -30, baseMultiplier = 10.461, cooldown = 4, damageEffectiveness = 10.461, levelRequirement = 6, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 21, attackSpeedMultiplier = -30, baseMultiplier = 10.9, cooldown = 4, damageEffectiveness = 10.9, levelRequirement = 9, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[4] = { 21, attackSpeedMultiplier = -30, baseMultiplier = 11.358, cooldown = 4, damageEffectiveness = 11.358, levelRequirement = 12, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 22, attackSpeedMultiplier = -30, baseMultiplier = 11.835, cooldown = 4, damageEffectiveness = 11.835, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 22, attackSpeedMultiplier = -30, baseMultiplier = 12.332, cooldown = 4, damageEffectiveness = 12.332, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 23, attackSpeedMultiplier = -30, baseMultiplier = 12.85, cooldown = 4, damageEffectiveness = 12.85, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 23, attackSpeedMultiplier = -30, baseMultiplier = 13.39, cooldown = 4, damageEffectiveness = 13.39, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 23, attackSpeedMultiplier = -30, baseMultiplier = 13.952, cooldown = 4, damageEffectiveness = 13.952, levelRequirement = 32, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 24, attackSpeedMultiplier = -30, baseMultiplier = 14.538, cooldown = 4, damageEffectiveness = 14.538, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 24, attackSpeedMultiplier = -30, baseMultiplier = 15.149, cooldown = 4, damageEffectiveness = 15.149, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[12] = { 25, attackSpeedMultiplier = -30, baseMultiplier = 15.785, cooldown = 4, damageEffectiveness = 15.785, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[13] = { 25, attackSpeedMultiplier = -30, baseMultiplier = 16.448, cooldown = 4, damageEffectiveness = 16.448, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[14] = { 25, attackSpeedMultiplier = -30, baseMultiplier = 17.139, cooldown = 4, damageEffectiveness = 17.139, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[15] = { 26, attackSpeedMultiplier = -30, baseMultiplier = 17.859, cooldown = 4, damageEffectiveness = 17.859, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[16] = { 26, attackSpeedMultiplier = -30, baseMultiplier = 18.609, cooldown = 4, damageEffectiveness = 18.609, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[17] = { 27, attackSpeedMultiplier = -30, baseMultiplier = 19.391, cooldown = 4, damageEffectiveness = 19.391, levelRequirement = 61, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[18] = { 27, attackSpeedMultiplier = -30, baseMultiplier = 20.205, cooldown = 4, damageEffectiveness = 20.205, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[19] = { 28, attackSpeedMultiplier = -30, baseMultiplier = 21.054, cooldown = 4, damageEffectiveness = 21.054, levelRequirement = 67, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[20] = { 28, attackSpeedMultiplier = -30, baseMultiplier = 21.938, cooldown = 4, damageEffectiveness = 21.938, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[21] = { 28, attackSpeedMultiplier = -30, baseMultiplier = 22.859, cooldown = 4, damageEffectiveness = 22.859, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[22] = { 29, attackSpeedMultiplier = -30, baseMultiplier = 23.819, cooldown = 4, damageEffectiveness = 23.819, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[23] = { 29, attackSpeedMultiplier = -30, baseMultiplier = 24.82, cooldown = 4, damageEffectiveness = 24.82, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[24] = { 30, attackSpeedMultiplier = -30, baseMultiplier = 25.862, cooldown = 4, damageEffectiveness = 25.862, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[25] = { 30, attackSpeedMultiplier = -30, baseMultiplier = 26.948, cooldown = 4, damageEffectiveness = 26.948, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[26] = { 31, attackSpeedMultiplier = -30, baseMultiplier = 28.08, cooldown = 4, damageEffectiveness = 28.08, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[27] = { 31, attackSpeedMultiplier = -30, baseMultiplier = 29.259, cooldown = 4, damageEffectiveness = 29.259, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[28] = { 31, attackSpeedMultiplier = -30, baseMultiplier = 30.488, cooldown = 4, damageEffectiveness = 30.488, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[29] = { 32, attackSpeedMultiplier = -30, baseMultiplier = 31.769, cooldown = 4, damageEffectiveness = 31.769, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[30] = { 32, attackSpeedMultiplier = -30, baseMultiplier = 33.103, cooldown = 4, damageEffectiveness = 33.103, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[31] = { 32, attackSpeedMultiplier = -30, baseMultiplier = 35.218, cooldown = 4, damageEffectiveness = 35.218, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[32] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 35.957, cooldown = 4, damageEffectiveness = 35.957, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[33] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 36.713, cooldown = 4, damageEffectiveness = 36.713, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[34] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 37.483, cooldown = 4, damageEffectiveness = 37.483, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[35] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 38.271, cooldown = 4, damageEffectiveness = 38.271, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[36] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 39.074, cooldown = 4, damageEffectiveness = 39.074, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[37] = { 34, attackSpeedMultiplier = -30, baseMultiplier = 39.895, cooldown = 4, damageEffectiveness = 39.895, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[38] = { 34, attackSpeedMultiplier = -30, baseMultiplier = 40.733, cooldown = 4, damageEffectiveness = 40.733, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[39] = { 34, attackSpeedMultiplier = -30, baseMultiplier = 41.588, cooldown = 4, damageEffectiveness = 41.588, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[40] = { 34, attackSpeedMultiplier = -30, baseMultiplier = 42.461, cooldown = 4, damageEffectiveness = 42.461, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
	},
}
skills["DecoyTotem"] = {
	name = "Decoy Totem",
	baseTypeName = "Decoy Totem",
	color = 1,
	description = "Summons a totem that taunts nearby monsters to attack it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.SummonsTotem] = true, [SkillType.Multicastable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 6,
	castTime = 1,
	baseFlags = {
		spell = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "totem_life_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 60 },
	},
	stats = {
		"totem_life_+%",
		"base_skill_is_totemified",
		"base_deal_no_damage",
		"totems_cannot_evade",
		"totem_ignores_cooldown",
		"is_totem",
	},
	levels = {
		[1] = { 0, cooldown = 4, levelRequirement = 4, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 4, cooldown = 4, levelRequirement = 6, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[3] = { 8, cooldown = 4, levelRequirement = 9, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 12, cooldown = 4, levelRequirement = 12, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[5] = { 16, cooldown = 4, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[6] = { 20, cooldown = 4, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[7] = { 24, cooldown = 4, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[8] = { 28, cooldown = 4, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[9] = { 32, cooldown = 4, levelRequirement = 32, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[10] = { 36, cooldown = 4, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[11] = { 40, cooldown = 4, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[12] = { 44, cooldown = 4, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[13] = { 48, cooldown = 4, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[14] = { 52, cooldown = 4, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[15] = { 56, cooldown = 4, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 31, }, },
		[16] = { 60, cooldown = 4, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 33, }, },
		[17] = { 64, cooldown = 4, levelRequirement = 61, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[18] = { 68, cooldown = 4, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[19] = { 72, cooldown = 4, levelRequirement = 67, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[20] = { 76, cooldown = 4, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 35, }, },
		[21] = { 80, cooldown = 4, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 36, }, },
		[22] = { 84, cooldown = 4, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 37, }, },
		[23] = { 88, cooldown = 4, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 37, }, },
		[24] = { 92, cooldown = 4, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 38, }, },
		[25] = { 96, cooldown = 4, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 38, }, },
		[26] = { 100, cooldown = 4, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 39, }, },
		[27] = { 104, cooldown = 4, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 40, }, },
		[28] = { 108, cooldown = 4, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 40, }, },
		[29] = { 112, cooldown = 4, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 41, }, },
		[30] = { 116, cooldown = 4, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 42, }, },
		[31] = { 118, cooldown = 4, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 43, }, },
		[32] = { 120, cooldown = 4, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[33] = { 122, cooldown = 4, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[34] = { 124, cooldown = 4, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 45, }, },
		[35] = { 126, cooldown = 4, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 45, }, },
		[36] = { 128, cooldown = 4, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 45, }, },
		[37] = { 130, cooldown = 4, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 46, }, },
		[38] = { 132, cooldown = 4, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 46, }, },
		[39] = { 134, cooldown = 4, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 46, }, },
		[40] = { 136, cooldown = 4, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 47, }, },
	},
}
skills["DefianceBanner"] = {
	name = "Defiance Banner",
	baseTypeName = "Defiance Banner",
	color = 1,
	description = "You must gain Valour from melee combat to use this skill, which will consume all Valour to place a banner with an aura. The aura will be larger and more powerful the more Valour was consumed. The banner lasts for a duration, but will end early if you leave the aura, or use the skill again while it's active.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.AuraDuration] = true, [SkillType.Banner] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "banner_aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_spell_suppression_chance_%"] = {
			mod("SpellSuppressionChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
		aura = true,
		banner = true,
	},
	baseMods = {
		skill("radius", 24),
		mod("AuraEffect", "MORE", -100, 0, 0, { type = "Condition", var = "BannerPlanted", neg = true }),
		flag("Condition:AffectedByPlacedBanner", { type = "Condition", var = "BannerPlanted" }, { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 100 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"base_movement_velocity_+%",
		"base_spell_suppression_chance_%",
		"damage_taken_+_from_suppressed_hits",
		"banner_area_of_effect_+%_final_per_resource",
		"banner_buff_effect_+%_final_per_resource",
		"base_can_gain_banner_resource",
	},
	levels = {
		[1] = { 8, 8, -5, 5, 5, cooldown = 1, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 8, 8, -5, 5, 5, cooldown = 1, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 8, 8, -6, 5, 6, cooldown = 1, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 8, 8, -6, 6, 6, cooldown = 1, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 8, -6, 6, 6, cooldown = 1, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 8, 8, -7, 6, 6, cooldown = 1, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 8, 8, -7, 6, 7, cooldown = 1, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 8, 8, -8, 7, 7, cooldown = 1, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 8, 8, -8, 7, 7, cooldown = 1, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[10] = { 8, 8, -8, 7, 7, cooldown = 1, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 8, 8, -9, 7, 8, cooldown = 1, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 8, 8, -9, 8, 8, cooldown = 1, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 8, 8, -9, 8, 8, cooldown = 1, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 8, 8, -10, 8, 8, cooldown = 1, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 8, 8, -10, 8, 9, cooldown = 1, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 8, 8, -11, 9, 9, cooldown = 1, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 8, 8, -11, 9, 9, cooldown = 1, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 8, 8, -11, 9, 9, cooldown = 1, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 8, 8, -12, 9, 10, cooldown = 1, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 8, 8, -12, 10, 10, cooldown = 1, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 8, 8, -12, 10, 10, cooldown = 1, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 8, 8, -13, 10, 10, cooldown = 1, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 8, 8, -13, 10, 11, cooldown = 1, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 8, 8, -13, 11, 11, cooldown = 1, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 8, 8, -14, 11, 11, cooldown = 1, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 8, 8, -14, 11, 11, cooldown = 1, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 8, 8, -15, 11, 12, cooldown = 1, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 8, 8, -15, 12, 12, cooldown = 1, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 8, 8, -15, 12, 12, cooldown = 1, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 8, 8, -16, 12, 12, cooldown = 1, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 8, 8, -16, 12, 12, cooldown = 1, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 8, 8, -16, 12, 13, cooldown = 1, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 8, 8, -16, 12, 13, cooldown = 1, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 8, 8, -16, 13, 13, cooldown = 1, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 8, 8, -17, 13, 13, cooldown = 1, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 8, 8, -17, 13, 13, cooldown = 1, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 8, 8, -17, 13, 13, cooldown = 1, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 8, 8, -17, 13, 13, cooldown = 1, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 8, 8, -17, 13, 13, cooldown = 1, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 8, 8, -18, 13, 14, cooldown = 1, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["Determination"] = {
	name = "Determination",
	baseTypeName = "Determination",
	color = 1,
	description = "Casts an aura that grants armour to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["determination_aura_armour_+%_final"] = {
			mod("Armour", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"determination_aura_armour_+%_final",
		"base_physical_damage_reduction_rating",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 40, 90, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 40, 107, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 41, 127, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 41, 150, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 42, 176, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 42, 209, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 43, 246, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 43, 286, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 44, 335, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 44, 373, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 45, 414, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 45, 458, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 46, 510, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 46, 561, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 47, 623, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 47, 689, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 48, 762, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 48, 842, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 49, 930, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 49, 1026, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 50, 1077, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 50, 1131, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 51, 1189, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 51, 1247, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 52, 1310, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 52, 1376, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { 53, 1444, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { 53, 1518, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { 54, 1594, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { 54, 1673, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { 55, 1716, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { 55, 1758, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { 55, 1801, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { 55, 1845, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { 56, 1892, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { 56, 1937, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { 56, 1985, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { 56, 2032, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { 57, 2084, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { 57, 2133, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["DevouringTotem"] = {
	name = "Devouring Totem",
	baseTypeName = "Devouring Totem",
	color = 1,
	baseEffectiveness = 0.69999998807907,
	incrementalEffectiveness = 0.029999999329448,
	description = "Summons a totem that can consume nearby corpses. If you are hurt, it will destroy a corpse to leech life to you.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 7,
	castTime = 1,
	statMap = {
		["corpse_consumption_life_to_gain"] = {
			skill("lifeLeechPerUse", nil),
		},
		["corpse_consumption_mana_to_gain"] = {
			skill("manaLeechPerUse", nil),
		},
	},
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "totem_life_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 60 },
	},
	stats = {
		"corpse_consumption_life_to_gain",
		"corpse_consumption_mana_to_gain",
		"totem_life_+%",
		"base_skill_is_totemified",
		"base_deal_no_damage",
		"is_totem",
	},
	levels = {
		[1] = { 30, 9, 0, levelRequirement = 4, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[2] = { 39, 12, 4, levelRequirement = 6, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[3] = { 45, 14, 8, levelRequirement = 9, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[4] = { 53, 17, 12, levelRequirement = 12, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[5] = { 61, 19, 16, levelRequirement = 16, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[6] = { 70, 22, 20, levelRequirement = 20, statInterpolation = { 1, 1, 1, }, cost = { Mana = 28, }, },
		[7] = { 79, 24, 24, levelRequirement = 24, statInterpolation = { 1, 1, 1, }, cost = { Mana = 30, }, },
		[8] = { 90, 27, 28, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { Mana = 31, }, },
		[9] = { 102, 29, 32, levelRequirement = 32, statInterpolation = { 1, 1, 1, }, cost = { Mana = 33, }, },
		[10] = { 115, 32, 36, levelRequirement = 36, statInterpolation = { 1, 1, 1, }, cost = { Mana = 34, }, },
		[11] = { 129, 34, 40, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { Mana = 36, }, },
		[12] = { 144, 37, 44, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { Mana = 37, }, },
		[13] = { 157, 40, 48, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 38, }, },
		[14] = { 173, 42, 52, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 39, }, },
		[15] = { 191, 45, 56, levelRequirement = 55, statInterpolation = { 1, 1, 1, }, cost = { Mana = 40, }, },
		[16] = { 211, 47, 60, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 41, }, },
		[17] = { 231, 50, 64, levelRequirement = 61, statInterpolation = { 1, 1, 1, }, cost = { Mana = 42, }, },
		[18] = { 253, 53, 68, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 42, }, },
		[19] = { 275, 56, 72, levelRequirement = 67, statInterpolation = { 1, 1, 1, }, cost = { Mana = 43, }, },
		[20] = { 299, 59, 76, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 44, }, },
		[21] = { 325, 62, 80, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 45, }, },
		[22] = { 352, 66, 84, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 45, }, },
		[23] = { 382, 69, 88, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 46, }, },
		[24] = { 413, 73, 92, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 46, }, },
		[25] = { 447, 76, 96, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 47, }, },
		[26] = { 483, 80, 100, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 48, }, },
		[27] = { 522, 84, 104, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 49, }, },
		[28] = { 563, 88, 108, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 50, }, },
		[29] = { 606, 92, 112, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 50, }, },
		[30] = { 652, 96, 116, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 51, }, },
		[31] = { 677, 98, 118, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 51, }, },
		[32] = { 701, 100, 120, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 52, }, },
		[33] = { 727, 102, 122, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 52, }, },
		[34] = { 753, 104, 124, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 52, }, },
		[35] = { 781, 106, 126, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 53, }, },
		[36] = { 808, 108, 128, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 53, }, },
		[37] = { 837, 110, 130, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 53, }, },
		[38] = { 866, 112, 132, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 54, }, },
		[39] = { 897, 114, 134, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 54, }, },
		[40] = { 927, 116, 136, levelRequirement = 100, statInterpolation = { 1, 1, 1, }, cost = { Mana = 54, }, },
	},
}
skills["DominatingBlow"] = {
	name = "Dominating Blow",
	baseTypeName = "Dominating Blow",
	color = 1,
	baseEffectiveness = 0,
	description = "Attacks enemies with a melee strike, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the enemy's corpse will be consumed and a Sentinel of Dominance with the same rarity, prefix and suffix modifiers will be summoned for a longer secondary duration.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"AxisEliteSoldierDominatingBlow",
		"AxisEliteSoldierDominatingBlowVaal",
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		minion = true,
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
		{ "base_max_number_of_dominated_normal_monsters", 9 },
		{ "base_max_number_of_dominated_magic_monsters", 3 },
		{ "base_max_number_of_dominated_rare_monsters", 1 },
		{ "base_secondary_skill_effect_duration", 20000 },
		{ "dominating_blow_chance_to_summon_on_hitting_unqiue_%", 25 },
		{ "base_max_number_of_vaal_dominated_monsters", 3 },
	},
	stats = {
		"is_dominated",
	},
	levels = {
		[1] = { baseMultiplier = 2.498, damageEffectiveness = 2.498, levelRequirement = 28, cost = { Mana = 7, }, },
		[2] = { baseMultiplier = 2.583, damageEffectiveness = 2.583, levelRequirement = 31, cost = { Mana = 8, }, },
		[3] = { baseMultiplier = 2.671, damageEffectiveness = 2.671, levelRequirement = 34, cost = { Mana = 8, }, },
		[4] = { baseMultiplier = 2.761, damageEffectiveness = 2.761, levelRequirement = 37, cost = { Mana = 8, }, },
		[5] = { baseMultiplier = 2.855, damageEffectiveness = 2.855, levelRequirement = 40, cost = { Mana = 8, }, },
		[6] = { baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 42, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 3.042, damageEffectiveness = 3.042, levelRequirement = 44, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 3.14, damageEffectiveness = 3.14, levelRequirement = 46, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 3.241, damageEffectiveness = 3.241, levelRequirement = 48, cost = { Mana = 9, }, },
		[10] = { baseMultiplier = 3.345, damageEffectiveness = 3.345, levelRequirement = 50, cost = { Mana = 9, }, },
		[11] = { baseMultiplier = 3.453, damageEffectiveness = 3.453, levelRequirement = 52, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 3.563, damageEffectiveness = 3.563, levelRequirement = 54, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 3.678, damageEffectiveness = 3.678, levelRequirement = 56, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 3.796, damageEffectiveness = 3.796, levelRequirement = 58, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 3.918, damageEffectiveness = 3.918, levelRequirement = 60, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 4.044, damageEffectiveness = 4.044, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 4.174, damageEffectiveness = 4.174, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 4.307, damageEffectiveness = 4.307, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 4.587, damageEffectiveness = 4.587, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 4.735, damageEffectiveness = 4.735, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 4.886, damageEffectiveness = 4.886, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 5.042, damageEffectiveness = 5.042, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 5.204, damageEffectiveness = 5.204, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 5.37, damageEffectiveness = 5.37, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 5.542, damageEffectiveness = 5.542, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 5.719, damageEffectiveness = 5.719, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 5.902, damageEffectiveness = 5.902, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 6.09, damageEffectiveness = 6.09, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 6.284, damageEffectiveness = 6.284, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 6.567, damageEffectiveness = 6.567, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 6.672, damageEffectiveness = 6.672, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 6.779, damageEffectiveness = 6.779, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 6.887, damageEffectiveness = 6.887, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 6.996, damageEffectiveness = 6.996, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 7.107, damageEffectiveness = 7.107, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 7.221, damageEffectiveness = 7.221, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 7.336, damageEffectiveness = 7.336, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 7.453, damageEffectiveness = 7.453, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 7.571, damageEffectiveness = 7.571, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["DominatingBlowAltX"] = {
	name = "Dominating Blow of Inspiring",
	baseTypeName = "Dominating Blow of Inspiring",
	color = 1,
	baseEffectiveness = 0,
	description = "Attacks enemies with a melee strike, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the enemy's corpse will be consumed and a Sentinel of Dominance with the same rarity, prefix and suffix modifiers will be summoned for a longer secondary duration.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"AxisEliteSoldierDominatingBlow",
		"AxisEliteSoldierDominatingBlowVaal",
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		minion = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_additive_minion_damage_modifiers_apply_to_all_damage_at_%_value", 2.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
		{ "base_max_number_of_dominated_normal_monsters", 6 },
		{ "base_max_number_of_dominated_magic_monsters", 3 },
		{ "base_max_number_of_dominated_rare_monsters", 1 },
		{ "base_secondary_skill_effect_duration", 20000 },
		{ "dominating_blow_chance_to_summon_on_hitting_unqiue_%", 25 },
		{ "base_max_number_of_vaal_dominated_monsters", 3 },
		{ "active_skill_additive_minion_damage_modifiers_apply_to_all_damage_at_%_value", 250 },
	},
	stats = {
		"is_dominated",
	},
	levels = {
		[1] = { baseMultiplier = 2.498, damageEffectiveness = 2.498, levelRequirement = 28, cost = { Mana = 7, }, },
		[2] = { baseMultiplier = 2.583, damageEffectiveness = 2.583, levelRequirement = 31, cost = { Mana = 8, }, },
		[3] = { baseMultiplier = 2.671, damageEffectiveness = 2.671, levelRequirement = 34, cost = { Mana = 8, }, },
		[4] = { baseMultiplier = 2.761, damageEffectiveness = 2.761, levelRequirement = 37, cost = { Mana = 8, }, },
		[5] = { baseMultiplier = 2.855, damageEffectiveness = 2.855, levelRequirement = 40, cost = { Mana = 8, }, },
		[6] = { baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 42, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 3.042, damageEffectiveness = 3.042, levelRequirement = 44, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 3.14, damageEffectiveness = 3.14, levelRequirement = 46, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 3.241, damageEffectiveness = 3.241, levelRequirement = 48, cost = { Mana = 9, }, },
		[10] = { baseMultiplier = 3.345, damageEffectiveness = 3.345, levelRequirement = 50, cost = { Mana = 9, }, },
		[11] = { baseMultiplier = 3.453, damageEffectiveness = 3.453, levelRequirement = 52, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 3.563, damageEffectiveness = 3.563, levelRequirement = 54, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 3.678, damageEffectiveness = 3.678, levelRequirement = 56, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 3.796, damageEffectiveness = 3.796, levelRequirement = 58, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 3.918, damageEffectiveness = 3.918, levelRequirement = 60, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 4.044, damageEffectiveness = 4.044, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 4.174, damageEffectiveness = 4.174, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 4.307, damageEffectiveness = 4.307, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 4.587, damageEffectiveness = 4.587, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 4.735, damageEffectiveness = 4.735, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 4.886, damageEffectiveness = 4.886, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 5.042, damageEffectiveness = 5.042, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 5.204, damageEffectiveness = 5.204, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 5.37, damageEffectiveness = 5.37, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 5.542, damageEffectiveness = 5.542, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 5.719, damageEffectiveness = 5.719, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 5.902, damageEffectiveness = 5.902, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 6.09, damageEffectiveness = 6.09, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 6.284, damageEffectiveness = 6.284, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 6.567, damageEffectiveness = 6.567, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 6.672, damageEffectiveness = 6.672, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 6.779, damageEffectiveness = 6.779, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 6.887, damageEffectiveness = 6.887, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 6.996, damageEffectiveness = 6.996, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 7.107, damageEffectiveness = 7.107, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 7.221, damageEffectiveness = 7.221, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 7.336, damageEffectiveness = 7.336, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 7.453, damageEffectiveness = 7.453, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 7.571, damageEffectiveness = 7.571, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["VaalDomination"] = {
	name = "Vaal Domination",
	baseTypeName = "Vaal Domination",
	color = 1,
	description = "This spell causes one of your existing Sentinels of Dominance to Ascend, becoming more powerful, gaining new attacks, and overriding its duration, while maintaining its monster modifiers and other bonuses, including from support gems. If you cannot have more Ascended Sentinels of Dominance, an existing one will be refreshed instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["vaal_upgrade_minion_damage_+%_final"] = {
		-- Stat is handled directly on minion
		},
		["vaal_upgrade_minion_damage_taken_+%_final"] = {
		-- Stat is handled directly on minion
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		minion = true,
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 30000 },
		{ "display_max_upgraded_sentinels_of_dominance", 3 },
		{ "vaal_upgrade_minion_damage_+%_final", 200 },
		{ "vaal_upgrade_minion_damage_taken_+%_final", -70 },
	},
	stats = {
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { levelRequirement = 28, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[2] = { levelRequirement = 31, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[3] = { levelRequirement = 34, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[4] = { levelRequirement = 37, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[5] = { levelRequirement = 40, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[6] = { levelRequirement = 42, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[7] = { levelRequirement = 44, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[8] = { levelRequirement = 46, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[9] = { levelRequirement = 48, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[10] = { levelRequirement = 50, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[11] = { levelRequirement = 52, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[12] = { levelRequirement = 54, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[13] = { levelRequirement = 56, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[14] = { levelRequirement = 58, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[15] = { levelRequirement = 60, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[16] = { levelRequirement = 62, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[17] = { levelRequirement = 64, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[18] = { levelRequirement = 66, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[19] = { levelRequirement = 68, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[20] = { levelRequirement = 70, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[21] = { levelRequirement = 72, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[22] = { levelRequirement = 74, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[23] = { levelRequirement = 76, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[24] = { levelRequirement = 78, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[25] = { levelRequirement = 80, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[26] = { levelRequirement = 82, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[27] = { levelRequirement = 84, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[28] = { levelRequirement = 86, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[29] = { levelRequirement = 88, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[30] = { levelRequirement = 90, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[31] = { levelRequirement = 91, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[32] = { levelRequirement = 92, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[33] = { levelRequirement = 93, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[34] = { levelRequirement = 94, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[35] = { levelRequirement = 95, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[36] = { levelRequirement = 96, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[37] = { levelRequirement = 97, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[38] = { levelRequirement = 98, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[39] = { levelRequirement = 99, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
		[40] = { levelRequirement = 100, soulPreventionDuration = 20, vaalStoredUses = 3, cost = { Soul = 30, }, },
	},
}
skills["DreadBanner"] = {
	name = "Dread Banner",
	baseTypeName = "Dread Banner",
	color = 1,
	description = "You must gain Valour from melee combat to use this skill, which will consume all Valour to place a banner with an aura. The aura will be larger and more powerful the more Valour was consumed. The banner lasts for a duration, but will end early if you leave the aura, or use the skill again while it's active.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.AuraDuration] = true, [SkillType.Banner] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "banner_aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["recover_X_life_on_block"] = {
			mod("LifeOnBlock", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["additional_block_%"] = {
			mod("BlockChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
	},
	baseMods = {
		skill("radius", 24),
		mod("AuraEffect", "MORE", -100, 0, 0, { type = "Condition", var = "BannerPlanted", neg = true }),
		flag("Condition:AffectedByPlacedBanner", { type = "Condition", var = "BannerPlanted" }, { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 100 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"additional_block_%",
		"recover_X_life_on_block",
		"banner_area_of_effect_+%_final_per_resource",
		"banner_buff_effect_+%_final_per_resource",
		"base_can_gain_banner_resource",
	},
	levels = {
		[1] = { 4, 9, 5, 5, cooldown = 1, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 4, 10, 5, 5, cooldown = 1, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 12, 5, 6, cooldown = 1, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 4, 13, 6, 6, cooldown = 1, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 4, 14, 6, 6, cooldown = 1, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 4, 16, 6, 6, cooldown = 1, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 4, 17, 6, 7, cooldown = 1, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 4, 18, 7, 7, cooldown = 1, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 4, 20, 7, 7, cooldown = 1, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 4, 21, 7, 7, cooldown = 1, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 4, 22, 7, 8, cooldown = 1, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 4, 23, 8, 8, cooldown = 1, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 4, 25, 8, 8, cooldown = 1, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 4, 26, 8, 8, cooldown = 1, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 4, 27, 8, 9, cooldown = 1, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 4, 29, 9, 9, cooldown = 1, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 4, 30, 9, 9, cooldown = 1, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 4, 31, 9, 9, cooldown = 1, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 4, 33, 9, 10, cooldown = 1, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 4, 34, 10, 10, cooldown = 1, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 4, 35, 10, 10, cooldown = 1, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 4, 36, 10, 10, cooldown = 1, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 4, 38, 10, 11, cooldown = 1, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 4, 39, 11, 11, cooldown = 1, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 4, 40, 11, 11, cooldown = 1, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 4, 42, 11, 11, cooldown = 1, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 4, 43, 11, 12, cooldown = 1, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 4, 44, 12, 12, cooldown = 1, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 4, 46, 12, 12, cooldown = 1, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 4, 47, 12, 12, cooldown = 1, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 4, 47, 12, 12, cooldown = 1, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 4, 48, 12, 13, cooldown = 1, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 4, 49, 12, 13, cooldown = 1, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 4, 49, 13, 13, cooldown = 1, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 4, 50, 13, 13, cooldown = 1, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 4, 51, 13, 13, cooldown = 1, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 4, 51, 13, 13, cooldown = 1, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 4, 52, 13, 13, cooldown = 1, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 4, 53, 13, 13, cooldown = 1, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 4, 53, 13, 14, cooldown = 1, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["Earthquake"] = {
	name = "Earthquake",
	baseTypeName = "Earthquake",
	color = 1,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		local duration = math.floor(activeSkill.skillData.duration * output.DurationMod * 10)
		activeSkill.skillModList:NewMod("Damage", "INC", activeSkill.skillModList:Sum("INC", activeSkill.skillCfg, "EarthquakeDurationIncDamage") * duration, "Skill:Earthquake")
	end,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Aftershock",
		},
	},
	statMap = {
		["quake_slam_fully_charged_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "SkillPart", skillPart = 2 }),
		},
		["quality_display_earthquake_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
		skill("radius", 28, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "quake_slam_fully_charged_explosion_damage_+%_final", 1.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
		{ "quake_slam_fully_charged_explosion_damage_+%_final", 150 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"is_player_earthquake",
		"quality_display_earthquake_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -25, baseMultiplier = 1.437, damageEffectiveness = 1.437, levelRequirement = 28, cost = { Mana = 10, }, },
		[2] = { attackSpeedMultiplier = -25, baseMultiplier = 1.476, damageEffectiveness = 1.476, levelRequirement = 31, cost = { Mana = 10, }, },
		[3] = { attackSpeedMultiplier = -25, baseMultiplier = 1.515, damageEffectiveness = 1.515, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { attackSpeedMultiplier = -25, baseMultiplier = 1.555, damageEffectiveness = 1.555, levelRequirement = 37, cost = { Mana = 11, }, },
		[5] = { attackSpeedMultiplier = -25, baseMultiplier = 1.595, damageEffectiveness = 1.595, levelRequirement = 40, cost = { Mana = 11, }, },
		[6] = { attackSpeedMultiplier = -25, baseMultiplier = 1.634, damageEffectiveness = 1.634, levelRequirement = 42, cost = { Mana = 11, }, },
		[7] = { attackSpeedMultiplier = -25, baseMultiplier = 1.674, damageEffectiveness = 1.674, levelRequirement = 44, cost = { Mana = 11, }, },
		[8] = { attackSpeedMultiplier = -25, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { attackSpeedMultiplier = -25, baseMultiplier = 1.758, damageEffectiveness = 1.758, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { attackSpeedMultiplier = -25, baseMultiplier = 1.801, damageEffectiveness = 1.801, levelRequirement = 50, cost = { Mana = 12, }, },
		[11] = { attackSpeedMultiplier = -25, baseMultiplier = 1.845, damageEffectiveness = 1.845, levelRequirement = 52, cost = { Mana = 12, }, },
		[12] = { attackSpeedMultiplier = -25, baseMultiplier = 1.89, damageEffectiveness = 1.89, levelRequirement = 54, cost = { Mana = 12, }, },
		[13] = { attackSpeedMultiplier = -25, baseMultiplier = 1.936, damageEffectiveness = 1.936, levelRequirement = 56, cost = { Mana = 12, }, },
		[14] = { attackSpeedMultiplier = -25, baseMultiplier = 1.983, damageEffectiveness = 1.983, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -25, baseMultiplier = 2.032, damageEffectiveness = 2.032, levelRequirement = 60, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -25, baseMultiplier = 2.081, damageEffectiveness = 2.081, levelRequirement = 62, cost = { Mana = 13, }, },
		[17] = { attackSpeedMultiplier = -25, baseMultiplier = 2.133, damageEffectiveness = 2.133, levelRequirement = 64, cost = { Mana = 13, }, },
		[18] = { attackSpeedMultiplier = -25, baseMultiplier = 2.184, damageEffectiveness = 2.184, levelRequirement = 66, cost = { Mana = 13, }, },
		[19] = { attackSpeedMultiplier = -25, baseMultiplier = 2.238, damageEffectiveness = 2.238, levelRequirement = 68, cost = { Mana = 13, }, },
		[20] = { attackSpeedMultiplier = -25, baseMultiplier = 2.293, damageEffectiveness = 2.293, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -25, baseMultiplier = 2.348, damageEffectiveness = 2.348, levelRequirement = 72, cost = { Mana = 14, }, },
		[22] = { attackSpeedMultiplier = -25, baseMultiplier = 2.405, damageEffectiveness = 2.405, levelRequirement = 74, cost = { Mana = 14, }, },
		[23] = { attackSpeedMultiplier = -25, baseMultiplier = 2.463, damageEffectiveness = 2.463, levelRequirement = 76, cost = { Mana = 14, }, },
		[24] = { attackSpeedMultiplier = -25, baseMultiplier = 2.524, damageEffectiveness = 2.524, levelRequirement = 78, cost = { Mana = 14, }, },
		[25] = { attackSpeedMultiplier = -25, baseMultiplier = 2.585, damageEffectiveness = 2.585, levelRequirement = 80, cost = { Mana = 14, }, },
		[26] = { attackSpeedMultiplier = -25, baseMultiplier = 2.648, damageEffectiveness = 2.648, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -25, baseMultiplier = 2.712, damageEffectiveness = 2.712, levelRequirement = 84, cost = { Mana = 15, }, },
		[28] = { attackSpeedMultiplier = -25, baseMultiplier = 2.777, damageEffectiveness = 2.777, levelRequirement = 86, cost = { Mana = 15, }, },
		[29] = { attackSpeedMultiplier = -25, baseMultiplier = 2.845, damageEffectiveness = 2.845, levelRequirement = 88, cost = { Mana = 15, }, },
		[30] = { attackSpeedMultiplier = -25, baseMultiplier = 2.914, damageEffectiveness = 2.914, levelRequirement = 90, cost = { Mana = 15, }, },
		[31] = { attackSpeedMultiplier = -25, baseMultiplier = 3.011, damageEffectiveness = 3.011, levelRequirement = 91, cost = { Mana = 15, }, },
		[32] = { attackSpeedMultiplier = -25, baseMultiplier = 3.048, damageEffectiveness = 3.048, levelRequirement = 92, cost = { Mana = 15, }, },
		[33] = { attackSpeedMultiplier = -25, baseMultiplier = 3.085, damageEffectiveness = 3.085, levelRequirement = 93, cost = { Mana = 15, }, },
		[34] = { attackSpeedMultiplier = -25, baseMultiplier = 3.122, damageEffectiveness = 3.122, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -25, baseMultiplier = 3.16, damageEffectiveness = 3.16, levelRequirement = 95, cost = { Mana = 16, }, },
		[36] = { attackSpeedMultiplier = -25, baseMultiplier = 3.198, damageEffectiveness = 3.198, levelRequirement = 96, cost = { Mana = 16, }, },
		[37] = { attackSpeedMultiplier = -25, baseMultiplier = 3.236, damageEffectiveness = 3.236, levelRequirement = 97, cost = { Mana = 16, }, },
		[38] = { attackSpeedMultiplier = -25, baseMultiplier = 3.275, damageEffectiveness = 3.275, levelRequirement = 98, cost = { Mana = 16, }, },
		[39] = { attackSpeedMultiplier = -25, baseMultiplier = 3.315, damageEffectiveness = 3.315, levelRequirement = 99, cost = { Mana = 16, }, },
		[40] = { attackSpeedMultiplier = -25, baseMultiplier = 3.355, damageEffectiveness = 3.355, levelRequirement = 100, cost = { Mana = 16, }, },
	},
}
skills["EarthquakeAltX"] = {
	name = "Earthquake of Amplification",
	baseTypeName = "Earthquake of Amplification",
	color = 1,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Aftershock",
		},
	},
	statMap = {
		["earthquake_skill_aftershock_hit_damage_+%_final_per_100ms_duration"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Hit, { type = "SkillPart", skillPart = 2 }, { type = "Multiplier", var = "100msEarthquakeDuration"} ),
		},
		["earthquake_skill_aftershock_ailment_damage_+%_final_per_100ms_duration"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Ailment, { type = "SkillPart", skillPart = 2 }, { type = "Multiplier", var = "100msEarthquakeDuration"} ),
		},
		["earthquake_skill_aftershock_area_of_effect_+%_final_per_100ms_duration"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }, { type = "Multiplier", var = "100msEarthquakeDuration"} ),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
		skill("radius", 28, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 25 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 2500 },
		{ "earthquake_skill_aftershock_hit_damage_+%_final_per_100ms_duration", 15 },
		{ "earthquake_skill_aftershock_ailment_damage_+%_final_per_100ms_duration", 5 },
		{ "earthquake_skill_aftershock_area_of_effect_+%_final_per_100ms_duration", 2 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"is_player_earthquake",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -25, baseMultiplier = 1.437, damageEffectiveness = 1.437, levelRequirement = 28, cost = { Mana = 10, }, },
		[2] = { attackSpeedMultiplier = -25, baseMultiplier = 1.476, damageEffectiveness = 1.476, levelRequirement = 31, cost = { Mana = 10, }, },
		[3] = { attackSpeedMultiplier = -25, baseMultiplier = 1.515, damageEffectiveness = 1.515, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { attackSpeedMultiplier = -25, baseMultiplier = 1.555, damageEffectiveness = 1.555, levelRequirement = 37, cost = { Mana = 11, }, },
		[5] = { attackSpeedMultiplier = -25, baseMultiplier = 1.595, damageEffectiveness = 1.595, levelRequirement = 40, cost = { Mana = 11, }, },
		[6] = { attackSpeedMultiplier = -25, baseMultiplier = 1.634, damageEffectiveness = 1.634, levelRequirement = 42, cost = { Mana = 11, }, },
		[7] = { attackSpeedMultiplier = -25, baseMultiplier = 1.674, damageEffectiveness = 1.674, levelRequirement = 44, cost = { Mana = 11, }, },
		[8] = { attackSpeedMultiplier = -25, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { attackSpeedMultiplier = -25, baseMultiplier = 1.758, damageEffectiveness = 1.758, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { attackSpeedMultiplier = -25, baseMultiplier = 1.801, damageEffectiveness = 1.801, levelRequirement = 50, cost = { Mana = 12, }, },
		[11] = { attackSpeedMultiplier = -25, baseMultiplier = 1.845, damageEffectiveness = 1.845, levelRequirement = 52, cost = { Mana = 12, }, },
		[12] = { attackSpeedMultiplier = -25, baseMultiplier = 1.89, damageEffectiveness = 1.89, levelRequirement = 54, cost = { Mana = 12, }, },
		[13] = { attackSpeedMultiplier = -25, baseMultiplier = 1.936, damageEffectiveness = 1.936, levelRequirement = 56, cost = { Mana = 12, }, },
		[14] = { attackSpeedMultiplier = -25, baseMultiplier = 1.983, damageEffectiveness = 1.983, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -25, baseMultiplier = 2.032, damageEffectiveness = 2.032, levelRequirement = 60, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -25, baseMultiplier = 2.081, damageEffectiveness = 2.081, levelRequirement = 62, cost = { Mana = 13, }, },
		[17] = { attackSpeedMultiplier = -25, baseMultiplier = 2.133, damageEffectiveness = 2.133, levelRequirement = 64, cost = { Mana = 13, }, },
		[18] = { attackSpeedMultiplier = -25, baseMultiplier = 2.184, damageEffectiveness = 2.184, levelRequirement = 66, cost = { Mana = 13, }, },
		[19] = { attackSpeedMultiplier = -25, baseMultiplier = 2.238, damageEffectiveness = 2.238, levelRequirement = 68, cost = { Mana = 13, }, },
		[20] = { attackSpeedMultiplier = -25, baseMultiplier = 2.293, damageEffectiveness = 2.293, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -25, baseMultiplier = 2.348, damageEffectiveness = 2.348, levelRequirement = 72, cost = { Mana = 14, }, },
		[22] = { attackSpeedMultiplier = -25, baseMultiplier = 2.405, damageEffectiveness = 2.405, levelRequirement = 74, cost = { Mana = 14, }, },
		[23] = { attackSpeedMultiplier = -25, baseMultiplier = 2.463, damageEffectiveness = 2.463, levelRequirement = 76, cost = { Mana = 14, }, },
		[24] = { attackSpeedMultiplier = -25, baseMultiplier = 2.524, damageEffectiveness = 2.524, levelRequirement = 78, cost = { Mana = 14, }, },
		[25] = { attackSpeedMultiplier = -25, baseMultiplier = 2.585, damageEffectiveness = 2.585, levelRequirement = 80, cost = { Mana = 14, }, },
		[26] = { attackSpeedMultiplier = -25, baseMultiplier = 2.648, damageEffectiveness = 2.648, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -25, baseMultiplier = 2.712, damageEffectiveness = 2.712, levelRequirement = 84, cost = { Mana = 15, }, },
		[28] = { attackSpeedMultiplier = -25, baseMultiplier = 2.777, damageEffectiveness = 2.777, levelRequirement = 86, cost = { Mana = 15, }, },
		[29] = { attackSpeedMultiplier = -25, baseMultiplier = 2.845, damageEffectiveness = 2.845, levelRequirement = 88, cost = { Mana = 15, }, },
		[30] = { attackSpeedMultiplier = -25, baseMultiplier = 2.914, damageEffectiveness = 2.914, levelRequirement = 90, cost = { Mana = 15, }, },
		[31] = { attackSpeedMultiplier = -25, baseMultiplier = 3.011, damageEffectiveness = 3.011, levelRequirement = 91, cost = { Mana = 15, }, },
		[32] = { attackSpeedMultiplier = -25, baseMultiplier = 3.048, damageEffectiveness = 3.048, levelRequirement = 92, cost = { Mana = 15, }, },
		[33] = { attackSpeedMultiplier = -25, baseMultiplier = 3.085, damageEffectiveness = 3.085, levelRequirement = 93, cost = { Mana = 15, }, },
		[34] = { attackSpeedMultiplier = -25, baseMultiplier = 3.122, damageEffectiveness = 3.122, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -25, baseMultiplier = 3.16, damageEffectiveness = 3.16, levelRequirement = 95, cost = { Mana = 16, }, },
		[36] = { attackSpeedMultiplier = -25, baseMultiplier = 3.198, damageEffectiveness = 3.198, levelRequirement = 96, cost = { Mana = 16, }, },
		[37] = { attackSpeedMultiplier = -25, baseMultiplier = 3.236, damageEffectiveness = 3.236, levelRequirement = 97, cost = { Mana = 16, }, },
		[38] = { attackSpeedMultiplier = -25, baseMultiplier = 3.275, damageEffectiveness = 3.275, levelRequirement = 98, cost = { Mana = 16, }, },
		[39] = { attackSpeedMultiplier = -25, baseMultiplier = 3.315, damageEffectiveness = 3.315, levelRequirement = 99, cost = { Mana = 16, }, },
		[40] = { attackSpeedMultiplier = -25, baseMultiplier = 3.355, damageEffectiveness = 3.355, levelRequirement = 100, cost = { Mana = 16, }, },
	},
}
skills["VaalEarthquake"] = {
	name = "Vaal Earthquake",
	baseTypeName = "Vaal Earthquake",
	color = 1,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a short duration. After using this skill, your steps will deal damage around you, cracking the earth if the previous cracks have erupted. This effect ends after a secondary duration, or after a maximum number of aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Aftershock",
		},
	},
	statMap = {
		["quake_slam_fully_charged_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "SkillPart", skillPart = 2 }),
		},
		["quality_display_earthquake_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
		skill("radius", 28, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "quake_slam_fully_charged_explosion_damage_+%_final", 1.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
		{ "base_secondary_skill_effect_duration", 12000 },
		{ "vaal_earthquake_maximum_aftershocks", 9 },
	},
	stats = {
		"quake_slam_fully_charged_explosion_damage_+%_final",
		"is_area_damage",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"force_lite_skill_effects",
		"is_player_earthquake",
		"quality_display_earthquake_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 350, attackSpeedMultiplier = -25, baseMultiplier = 1.009, damageEffectiveness = 1.009, levelRequirement = 28, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[2] = { 353, attackSpeedMultiplier = -25, baseMultiplier = 1.038, damageEffectiveness = 1.038, levelRequirement = 31, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[3] = { 356, attackSpeedMultiplier = -25, baseMultiplier = 1.068, damageEffectiveness = 1.068, levelRequirement = 34, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[4] = { 359, attackSpeedMultiplier = -25, baseMultiplier = 1.098, damageEffectiveness = 1.098, levelRequirement = 37, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[5] = { 362, attackSpeedMultiplier = -25, baseMultiplier = 1.13, damageEffectiveness = 1.13, levelRequirement = 40, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[6] = { 365, attackSpeedMultiplier = -25, baseMultiplier = 1.162, damageEffectiveness = 1.162, levelRequirement = 42, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[7] = { 368, attackSpeedMultiplier = -25, baseMultiplier = 1.195, damageEffectiveness = 1.195, levelRequirement = 44, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[8] = { 371, attackSpeedMultiplier = -25, baseMultiplier = 1.23, damageEffectiveness = 1.23, levelRequirement = 46, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[9] = { 374, attackSpeedMultiplier = -25, baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 48, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[10] = { 377, attackSpeedMultiplier = -25, baseMultiplier = 1.301, damageEffectiveness = 1.301, levelRequirement = 50, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[11] = { 380, attackSpeedMultiplier = -25, baseMultiplier = 1.338, damageEffectiveness = 1.338, levelRequirement = 52, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[12] = { 383, attackSpeedMultiplier = -25, baseMultiplier = 1.377, damageEffectiveness = 1.377, levelRequirement = 54, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[13] = { 386, attackSpeedMultiplier = -25, baseMultiplier = 1.416, damageEffectiveness = 1.416, levelRequirement = 56, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[14] = { 389, attackSpeedMultiplier = -25, baseMultiplier = 1.457, damageEffectiveness = 1.457, levelRequirement = 58, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[15] = { 392, attackSpeedMultiplier = -25, baseMultiplier = 1.499, damageEffectiveness = 1.499, levelRequirement = 60, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[16] = { 395, attackSpeedMultiplier = -25, baseMultiplier = 1.542, damageEffectiveness = 1.542, levelRequirement = 62, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[17] = { 398, attackSpeedMultiplier = -25, baseMultiplier = 1.586, damageEffectiveness = 1.586, levelRequirement = 64, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[18] = { 401, attackSpeedMultiplier = -25, baseMultiplier = 1.631, damageEffectiveness = 1.631, levelRequirement = 66, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[19] = { 404, attackSpeedMultiplier = -25, baseMultiplier = 1.678, damageEffectiveness = 1.678, levelRequirement = 68, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[20] = { 407, attackSpeedMultiplier = -25, baseMultiplier = 1.726, damageEffectiveness = 1.726, levelRequirement = 70, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[21] = { 410, attackSpeedMultiplier = -25, baseMultiplier = 1.775, damageEffectiveness = 1.775, levelRequirement = 72, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[22] = { 413, attackSpeedMultiplier = -25, baseMultiplier = 1.826, damageEffectiveness = 1.826, levelRequirement = 74, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[23] = { 416, attackSpeedMultiplier = -25, baseMultiplier = 1.879, damageEffectiveness = 1.879, levelRequirement = 76, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[24] = { 419, attackSpeedMultiplier = -25, baseMultiplier = 1.932, damageEffectiveness = 1.932, levelRequirement = 78, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[25] = { 422, attackSpeedMultiplier = -25, baseMultiplier = 1.988, damageEffectiveness = 1.988, levelRequirement = 80, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[26] = { 425, attackSpeedMultiplier = -25, baseMultiplier = 2.045, damageEffectiveness = 2.045, levelRequirement = 82, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[27] = { 428, attackSpeedMultiplier = -25, baseMultiplier = 2.103, damageEffectiveness = 2.103, levelRequirement = 84, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[28] = { 431, attackSpeedMultiplier = -25, baseMultiplier = 2.164, damageEffectiveness = 2.164, levelRequirement = 86, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[29] = { 434, attackSpeedMultiplier = -25, baseMultiplier = 2.225, damageEffectiveness = 2.225, levelRequirement = 88, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[30] = { 437, attackSpeedMultiplier = -25, baseMultiplier = 2.289, damageEffectiveness = 2.289, levelRequirement = 90, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[31] = { 437, attackSpeedMultiplier = -25, baseMultiplier = 2.389, damageEffectiveness = 2.389, levelRequirement = 91, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[32] = { 440, attackSpeedMultiplier = -25, baseMultiplier = 2.423, damageEffectiveness = 2.423, levelRequirement = 92, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[33] = { 440, attackSpeedMultiplier = -25, baseMultiplier = 2.457, damageEffectiveness = 2.457, levelRequirement = 93, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[34] = { 443, attackSpeedMultiplier = -25, baseMultiplier = 2.493, damageEffectiveness = 2.493, levelRequirement = 94, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[35] = { 443, attackSpeedMultiplier = -25, baseMultiplier = 2.528, damageEffectiveness = 2.528, levelRequirement = 95, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[36] = { 446, attackSpeedMultiplier = -25, baseMultiplier = 2.565, damageEffectiveness = 2.565, levelRequirement = 96, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[37] = { 446, attackSpeedMultiplier = -25, baseMultiplier = 2.601, damageEffectiveness = 2.601, levelRequirement = 97, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[38] = { 449, attackSpeedMultiplier = -25, baseMultiplier = 2.639, damageEffectiveness = 2.639, levelRequirement = 98, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[39] = { 449, attackSpeedMultiplier = -25, baseMultiplier = 2.676, damageEffectiveness = 2.676, levelRequirement = 99, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[40] = { 452, attackSpeedMultiplier = -25, baseMultiplier = 2.715, damageEffectiveness = 2.715, levelRequirement = 100, soulPreventionDuration = 9, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
	},
}
skills["Earthshatter"] = {
	name = "Earthshatter",
	baseTypeName = "Earthshatter",
	color = 1,
	description = "Slam the ground, sending out rectangular fissures that deal area damage to enemies and thrust a spike from the ground when they end. Warcries or other Slam Attacks performed by you or allied players near any spike will cause them to shatter, damaging surrounding enemies. Works with Maces, Sceptres, Axes, Staves and Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Spike",
		},
	},
	statMap = {
		["spike_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["active_skill_area_of_effect_+%_final"] = {
			mod("AreaOfEffect", "MORE", nil),
		},
		["spike_slam_spike_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["quality_display_earthshatter_spike_damage_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
	},
	qualityStats = {
		Default = {
			{ "spike_slam_num_spikes", 0.05 },
			{ "spike_slam_max_spikes", 0.15 },
		},
	},
	constantStats = {
		{ "spike_slam_explosion_damage_+%_final", -30 },
		{ "spike_slam_num_spikes", 5 },
		{ "spike_slam_max_spikes", 15 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"active_skill_area_of_effect_+%_final",
		"is_area_damage",
		"quality_display_spike_slam_is_gem",
		"quality_display_max_spikes_is_gem",
		"quality_display_earthshatter_spike_damage_is_gem",
	},
	notMinionStat = {
		"active_skill_area_of_effect_+%_final",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -20, baseMultiplier = 1.711, damageEffectiveness = 1.711, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 1, attackSpeedMultiplier = -20, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 2, attackSpeedMultiplier = -20, baseMultiplier = 1.871, damageEffectiveness = 1.871, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 3, attackSpeedMultiplier = -20, baseMultiplier = 1.959, damageEffectiveness = 1.959, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 2.05, damageEffectiveness = 2.05, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.146, damageEffectiveness = 2.146, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 2.246, damageEffectiveness = 2.246, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 2.346, damageEffectiveness = 2.346, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 2.451, damageEffectiveness = 2.451, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 2.561, damageEffectiveness = 2.561, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.675, damageEffectiveness = 2.675, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 11, attackSpeedMultiplier = -20, baseMultiplier = 2.794, damageEffectiveness = 2.794, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 2.918, damageEffectiveness = 2.918, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 13, attackSpeedMultiplier = -20, baseMultiplier = 3.049, damageEffectiveness = 3.049, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 14, attackSpeedMultiplier = -20, baseMultiplier = 3.185, damageEffectiveness = 3.185, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 3.325, damageEffectiveness = 3.325, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 3.468, damageEffectiveness = 3.468, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 3.616, damageEffectiveness = 3.616, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 3.771, damageEffectiveness = 3.771, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 19, attackSpeedMultiplier = -20, baseMultiplier = 3.931, damageEffectiveness = 3.931, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 4.099, damageEffectiveness = 4.099, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 21, attackSpeedMultiplier = -20, baseMultiplier = 4.273, damageEffectiveness = 4.273, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 22, attackSpeedMultiplier = -20, baseMultiplier = 4.456, damageEffectiveness = 4.456, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 23, attackSpeedMultiplier = -20, baseMultiplier = 4.646, damageEffectiveness = 4.646, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 4.845, damageEffectiveness = 4.845, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 25, attackSpeedMultiplier = -20, baseMultiplier = 5.051, damageEffectiveness = 5.051, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 26, attackSpeedMultiplier = -20, baseMultiplier = 5.266, damageEffectiveness = 5.266, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 27, attackSpeedMultiplier = -20, baseMultiplier = 5.49, damageEffectiveness = 5.49, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 5.725, damageEffectiveness = 5.725, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 5.968, damageEffectiveness = 5.968, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 6.334, damageEffectiveness = 6.334, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 6.469, damageEffectiveness = 6.469, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 6.607, damageEffectiveness = 6.607, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 6.746, damageEffectiveness = 6.746, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 6.89, damageEffectiveness = 6.89, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 7.037, damageEffectiveness = 7.037, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 7.186, damageEffectiveness = 7.186, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 33, attackSpeedMultiplier = -20, baseMultiplier = 7.339, damageEffectiveness = 7.339, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 33, attackSpeedMultiplier = -20, baseMultiplier = 7.494, damageEffectiveness = 7.494, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 34, attackSpeedMultiplier = -20, baseMultiplier = 7.654, damageEffectiveness = 7.654, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["EarthshatterAltX"] = {
	name = "Earthshatter of Fragility",
	baseTypeName = "Earthshatter of Fragility",
	color = 1,
	description = "Slam the ground, sending out rectangular fissures that deal area damage to enemies and thrust a spike from the ground when they end. The spikes shatter after a duration, damaging surrounding enemies. Works with Maces, Sceptres, Axes, Staves and Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Spike",
		},
	},
	statMap = {
		["spike_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["spike_slam_spike_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["quality_display_earthshatter_spike_damage_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
	},
	qualityStats = {
		Default = {
			{ "spike_slam_num_spikes", 0.05 },
			{ "spike_slam_max_spikes", 0.15 },
		},
	},
	constantStats = {
		{ "spike_slam_explosion_damage_+%_final", -30 },
		{ "spike_slam_num_spikes", 5 },
		{ "spike_slam_max_spikes", 15 },
		{ "base_skill_effect_duration", 1500 },
	},
	stats = {
		"active_skill_area_of_effect_+%_final",
		"is_area_damage",
		"quality_display_spike_slam_is_gem",
		"quality_display_max_spikes_is_gem",
		"quality_display_earthshatter_spike_damage_is_gem",
	},
	notMinionStat = {
		"active_skill_area_of_effect_+%_final",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -20, baseMultiplier = 1.369, damageEffectiveness = 1.369, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 1, attackSpeedMultiplier = -20, baseMultiplier = 1.43, damageEffectiveness = 1.43, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 2, attackSpeedMultiplier = -20, baseMultiplier = 1.497, damageEffectiveness = 1.497, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 3, attackSpeedMultiplier = -20, baseMultiplier = 1.567, damageEffectiveness = 1.567, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 1.64, damageEffectiveness = 1.64, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 1.796, damageEffectiveness = 1.796, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 1.877, damageEffectiveness = 1.877, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 1.961, damageEffectiveness = 1.961, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 2.048, damageEffectiveness = 2.048, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.14, damageEffectiveness = 2.14, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 11, attackSpeedMultiplier = -20, baseMultiplier = 2.235, damageEffectiveness = 2.235, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 2.335, damageEffectiveness = 2.335, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 13, attackSpeedMultiplier = -20, baseMultiplier = 2.439, damageEffectiveness = 2.439, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 14, attackSpeedMultiplier = -20, baseMultiplier = 2.547, damageEffectiveness = 2.547, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 15, attackSpeedMultiplier = -20, baseMultiplier = 2.661, damageEffectiveness = 2.661, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 2.775, damageEffectiveness = 2.775, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 17, attackSpeedMultiplier = -20, baseMultiplier = 2.892, damageEffectiveness = 2.892, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 18, attackSpeedMultiplier = -20, baseMultiplier = 3.017, damageEffectiveness = 3.017, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 19, attackSpeedMultiplier = -20, baseMultiplier = 3.145, damageEffectiveness = 3.145, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 3.28, damageEffectiveness = 3.28, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 21, attackSpeedMultiplier = -20, baseMultiplier = 3.419, damageEffectiveness = 3.419, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 22, attackSpeedMultiplier = -20, baseMultiplier = 3.565, damageEffectiveness = 3.565, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 23, attackSpeedMultiplier = -20, baseMultiplier = 3.718, damageEffectiveness = 3.718, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 3.875, damageEffectiveness = 3.875, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 25, attackSpeedMultiplier = -20, baseMultiplier = 4.041, damageEffectiveness = 4.041, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 26, attackSpeedMultiplier = -20, baseMultiplier = 4.213, damageEffectiveness = 4.213, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 27, attackSpeedMultiplier = -20, baseMultiplier = 4.393, damageEffectiveness = 4.393, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 4.58, damageEffectiveness = 4.58, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 4.775, damageEffectiveness = 4.775, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 29, attackSpeedMultiplier = -20, baseMultiplier = 5.067, damageEffectiveness = 5.067, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 5.175, damageEffectiveness = 5.175, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 30, attackSpeedMultiplier = -20, baseMultiplier = 5.285, damageEffectiveness = 5.285, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 5.397, damageEffectiveness = 5.397, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 31, attackSpeedMultiplier = -20, baseMultiplier = 5.513, damageEffectiveness = 5.513, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 5.629, damageEffectiveness = 5.629, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 5.749, damageEffectiveness = 5.749, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 33, attackSpeedMultiplier = -20, baseMultiplier = 5.871, damageEffectiveness = 5.871, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 33, attackSpeedMultiplier = -20, baseMultiplier = 5.995, damageEffectiveness = 5.995, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 34, attackSpeedMultiplier = -20, baseMultiplier = 6.123, damageEffectiveness = 6.123, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["EarthshatterAltY"] = {
	name = "Earthshatter of Prominence",
	baseTypeName = "Earthshatter of Prominence",
	color = 1,
	description = "Slam the ground, sending out a rectangular fissure that deals area damage to enemies and thrusts a large spike from the ground where it ends. Warcries or other Slam Attacks performed by you or allied players near the spike will cause it to shatter, damaging surrounding enemies. Works with Maces, Sceptres, Axes, Staves and Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Spike",
		},
	},
	statMap = {
		["spike_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["earthshatter_spike_area_of_effect_+%_final"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["quality_display_earthshatter_spike_damage_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
	},
	qualityStats = {
		Default = {
			{ "spike_slam_explosion_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "spike_slam_explosion_damage_+%_final", 100 },
		{ "spike_slam_num_spikes", 1 },
		{ "spike_slam_max_spikes", 5 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"earthshatter_spike_area_of_effect_+%_final",
		"is_area_damage",
		"quality_display_spike_slam_is_gem",
		"quality_display_max_spikes_is_gem",
		"quality_display_earthshatter_spike_damage_is_gem",
	},
	levels = {
		[1] = { 100, attackSpeedMultiplier = -20, baseMultiplier = 1.506, damageEffectiveness = 1.506, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 103, attackSpeedMultiplier = -20, baseMultiplier = 1.574, damageEffectiveness = 1.574, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 106, attackSpeedMultiplier = -20, baseMultiplier = 1.647, damageEffectiveness = 1.647, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 109, attackSpeedMultiplier = -20, baseMultiplier = 1.723, damageEffectiveness = 1.723, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 112, attackSpeedMultiplier = -20, baseMultiplier = 1.805, damageEffectiveness = 1.805, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 115, attackSpeedMultiplier = -20, baseMultiplier = 1.888, damageEffectiveness = 1.888, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 118, attackSpeedMultiplier = -20, baseMultiplier = 1.976, damageEffectiveness = 1.976, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 121, attackSpeedMultiplier = -20, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 124, attackSpeedMultiplier = -20, baseMultiplier = 2.157, damageEffectiveness = 2.157, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 127, attackSpeedMultiplier = -20, baseMultiplier = 2.253, damageEffectiveness = 2.253, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 130, attackSpeedMultiplier = -20, baseMultiplier = 2.354, damageEffectiveness = 2.354, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 133, attackSpeedMultiplier = -20, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 136, attackSpeedMultiplier = -20, baseMultiplier = 2.568, damageEffectiveness = 2.568, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 139, attackSpeedMultiplier = -20, baseMultiplier = 2.683, damageEffectiveness = 2.683, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 142, attackSpeedMultiplier = -20, baseMultiplier = 2.801, damageEffectiveness = 2.801, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 145, attackSpeedMultiplier = -20, baseMultiplier = 2.927, damageEffectiveness = 2.927, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 148, attackSpeedMultiplier = -20, baseMultiplier = 3.052, damageEffectiveness = 3.052, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 151, attackSpeedMultiplier = -20, baseMultiplier = 3.182, damageEffectiveness = 3.182, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 154, attackSpeedMultiplier = -20, baseMultiplier = 3.318, damageEffectiveness = 3.318, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 157, attackSpeedMultiplier = -20, baseMultiplier = 3.46, damageEffectiveness = 3.46, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 160, attackSpeedMultiplier = -20, baseMultiplier = 3.607, damageEffectiveness = 3.607, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 163, attackSpeedMultiplier = -20, baseMultiplier = 3.762, damageEffectiveness = 3.762, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 166, attackSpeedMultiplier = -20, baseMultiplier = 3.922, damageEffectiveness = 3.922, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 169, attackSpeedMultiplier = -20, baseMultiplier = 4.089, damageEffectiveness = 4.089, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 172, attackSpeedMultiplier = -20, baseMultiplier = 4.264, damageEffectiveness = 4.264, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 175, attackSpeedMultiplier = -20, baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 178, attackSpeedMultiplier = -20, baseMultiplier = 4.634, damageEffectiveness = 4.634, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 181, attackSpeedMultiplier = -20, baseMultiplier = 4.832, damageEffectiveness = 4.832, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 184, attackSpeedMultiplier = -20, baseMultiplier = 5.037, damageEffectiveness = 5.037, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 187, attackSpeedMultiplier = -20, baseMultiplier = 5.251, damageEffectiveness = 5.251, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 188, attackSpeedMultiplier = -20, baseMultiplier = 5.575, damageEffectiveness = 5.575, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 190, attackSpeedMultiplier = -20, baseMultiplier = 5.692, damageEffectiveness = 5.692, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 191, attackSpeedMultiplier = -20, baseMultiplier = 5.814, damageEffectiveness = 5.814, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 193, attackSpeedMultiplier = -20, baseMultiplier = 5.938, damageEffectiveness = 5.938, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 194, attackSpeedMultiplier = -20, baseMultiplier = 6.063, damageEffectiveness = 6.063, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 196, attackSpeedMultiplier = -20, baseMultiplier = 6.193, damageEffectiveness = 6.193, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 197, attackSpeedMultiplier = -20, baseMultiplier = 6.324, damageEffectiveness = 6.324, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 199, attackSpeedMultiplier = -20, baseMultiplier = 6.457, damageEffectiveness = 6.457, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 200, attackSpeedMultiplier = -20, baseMultiplier = 6.595, damageEffectiveness = 6.595, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 202, attackSpeedMultiplier = -20, baseMultiplier = 6.736, damageEffectiveness = 6.736, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["EnduringCry"] = {
	name = "Enduring Cry",
	baseTypeName = "Enduring Cry",
	color = 1,
	baseEffectiveness = 0,
	description = "Performs a warcry, taunting all nearby enemies to attack the user and granting a buff to the user and nearby allies. The user and allied players also gain endurance charges.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["enduring_cry_life_regeneration_rate_per_minute_%_per_5_power_up_to_cap"] = {
			mod("LifeRegenPercent", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
			div = 60,
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "endurance_charge_granted_per_X_monster_power_during_endurance_warcry", 5 },
		{ "enduring_cry_life_regeneration_rate_per_minute_%_per_5_power_up_to_cap", 120 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 57, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 63, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["Eviscerate"] = {
	name = "Eviscerate",
	baseTypeName = "Eviscerate",
	color = 1,
	description = "Retaliate against a blocked hit with an arcing slash that releases two waves of force. Enemies close in front of you can be hit by both waves. Requires a Sword or Axe and a Shield.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cooldown] = true, [SkillType.Retaliation] = true, [SkillType.RequiresShield] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Wave",
		},
		{
			name = "Both Waves",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "retaliation_base_use_window_duration_ms", 2000 },
		{ "active_skill_base_area_of_effect_radius", 100 },
		{ "active_skill_base_secondary_area_of_effect_radius", 28 },
		{ "active_skill_area_of_effect_description_mode", 5 },
		{ "active_skill_secondary_area_of_effect_description_mode", 5 },
	},
	stats = {
		"active_skill_base_secondary_area_of_effect_radius",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
		"global_always_hit",
		"skill_cannot_be_exerted",
		"global_bleed_on_hit",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 0, baseMultiplier = 6.745, cooldown = 3, damageEffectiveness = 6.745, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 0, baseMultiplier = 6.994, cooldown = 3, damageEffectiveness = 6.994, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 0, baseMultiplier = 7.253, cooldown = 3, damageEffectiveness = 7.253, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 1, baseMultiplier = 7.521, cooldown = 3, damageEffectiveness = 7.521, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 1, baseMultiplier = 7.8, cooldown = 3, damageEffectiveness = 7.8, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 1, baseMultiplier = 8.088, cooldown = 3, damageEffectiveness = 8.088, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 1, baseMultiplier = 8.387, cooldown = 3, damageEffectiveness = 8.387, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 1, baseMultiplier = 8.698, cooldown = 3, damageEffectiveness = 8.698, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 2, baseMultiplier = 9.02, cooldown = 3, damageEffectiveness = 9.02, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 2, baseMultiplier = 9.353, cooldown = 3, damageEffectiveness = 9.353, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 2, baseMultiplier = 9.699, cooldown = 3, damageEffectiveness = 9.699, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 2, baseMultiplier = 10.058, cooldown = 3, damageEffectiveness = 10.058, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 3, baseMultiplier = 10.43, cooldown = 3, damageEffectiveness = 10.43, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 3, baseMultiplier = 10.816, cooldown = 3, damageEffectiveness = 10.816, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 3, baseMultiplier = 11.217, cooldown = 3, damageEffectiveness = 11.217, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 3, baseMultiplier = 11.632, cooldown = 3, damageEffectiveness = 11.632, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 3, baseMultiplier = 12.062, cooldown = 3, damageEffectiveness = 12.062, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 4, baseMultiplier = 12.508, cooldown = 3, damageEffectiveness = 12.508, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 4, baseMultiplier = 12.971, cooldown = 3, damageEffectiveness = 12.971, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 4, baseMultiplier = 13.451, cooldown = 3, damageEffectiveness = 13.451, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 4, baseMultiplier = 13.949, cooldown = 3, damageEffectiveness = 13.949, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 4, baseMultiplier = 14.465, cooldown = 3, damageEffectiveness = 14.465, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 5, baseMultiplier = 15, cooldown = 3, damageEffectiveness = 15, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 5, baseMultiplier = 15.555, cooldown = 3, damageEffectiveness = 15.555, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 5, baseMultiplier = 16.131, cooldown = 3, damageEffectiveness = 16.131, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 5, baseMultiplier = 16.727, cooldown = 3, damageEffectiveness = 16.727, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 5, baseMultiplier = 17.346, cooldown = 3, damageEffectiveness = 17.346, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 6, baseMultiplier = 17.988, cooldown = 3, damageEffectiveness = 17.988, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 6, baseMultiplier = 18.654, cooldown = 3, damageEffectiveness = 18.654, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 6, baseMultiplier = 19.344, cooldown = 3, damageEffectiveness = 19.344, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 6, baseMultiplier = 20.431, cooldown = 3, damageEffectiveness = 20.431, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 6, baseMultiplier = 20.809, cooldown = 3, damageEffectiveness = 20.809, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 6, baseMultiplier = 21.194, cooldown = 3, damageEffectiveness = 21.194, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 7, baseMultiplier = 21.586, cooldown = 3, damageEffectiveness = 21.586, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 7, baseMultiplier = 21.985, cooldown = 3, damageEffectiveness = 21.985, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 7, baseMultiplier = 22.392, cooldown = 3, damageEffectiveness = 22.392, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 7, baseMultiplier = 22.806, cooldown = 3, damageEffectiveness = 22.806, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 7, baseMultiplier = 23.228, cooldown = 3, damageEffectiveness = 23.228, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 7, baseMultiplier = 23.658, cooldown = 3, damageEffectiveness = 23.658, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 7, baseMultiplier = 24.095, cooldown = 3, damageEffectiveness = 24.095, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["Exsanguinate"] = {
	name = "Exsanguinate",
	baseTypeName = "Exsanguinate",
	color = 1,
	baseEffectiveness = 1.5195000171661,
	incrementalEffectiveness = 0.052499998360872,
	description = "Releases several tendrils of blood from your character, targeting enemies in a narrow angle in front of you. The beams deal physical damage and inflict a physical damage over time debuff to enemies, which can stack up to 3 times. Effects which allow skills to chain can apply to these tendrils.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.DamageOverTime] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["base_physical_damage_to_deal_per_minute"] = {
			skill("PhysicalDot", nil, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage", neg = true }),
			skill("FireDot", nil, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage"}),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		chaining = true,
	},
	baseMods = {
		skill("debuff", true),
		mod("Multiplier:ExsanguinateMaxStages", "BASE", 3),
		mod("PhysicalDamage", "MORE", 100, 0, KeywordFlag.PhysicalDot, { type = "Multiplier", var = "ExsanguinateStageAfterFirst"}, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage", neg = true }),
		mod("FireDamage", "MORE", 100, bit.bor(ModFlag.Spell,ModFlag.Dot), 0, { type = "Multiplier", var = "ExsanguinateStageAfterFirst"}, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage" }),
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 75 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_physical_damage_to_deal_per_minute",
		"blood_tendrils_beam_count",
		"spell_damage_modifiers_apply_to_skill_dot",
		"quality_display_exsanguinate_beam_targets_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 77.238338925305, 7, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 12, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 16, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 76.421667853482, 7, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 15, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 18, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 75.086666831821, 7, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 19, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 21, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 73.768331269212, 7, critChance = 6, damageEffectiveness = 1.7, levelRequirement = 23, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 23, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 72.466669112941, 7, critChance = 6, damageEffectiveness = 1.7, levelRequirement = 27, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 25, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 71.185002328617, 7, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 31, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 26, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 69.916671090449, 7, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 35, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 28, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 69.136668796912, 8, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 38, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 30, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 68.360004363557, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 41, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 32, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 67.586669843098, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 44, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 33, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 66.816665235534, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 47, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 34, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 66.050002461796, 8, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 50, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 35, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 65.286669600954, 8, critChance = 6, damageEffectiveness = 2.3, levelRequirement = 53, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 37, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 64.526666653007, 8, critChance = 6, damageEffectiveness = 2.3, levelRequirement = 56, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 39, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 63.771666521691, 9, critChance = 6, damageEffectiveness = 2.4, levelRequirement = 59, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 40, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 63.020000276913, 9, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 62, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 42, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 62.700002800177, 9, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 64, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 43, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 62.380001349797, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 66, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 44, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 62.053336099982, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 68, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 45, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 61.726666876525, 9, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 70, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 46, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 61.396667740171, 9, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 72, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 47, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 61.063334717279, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 74, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 48, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 60.730001694386, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 76, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 49, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 60.391669828507, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 78, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 50, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 60.053333988984, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 80, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 51, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 59.711668236566, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 82, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 52, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 59.370002484148, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 84, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 53, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 59.0233339151, 10, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 86, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 54, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 58.678334276142, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 88, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 55, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 58.331669680737, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 90, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 56, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 58.380001101444, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 91, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 57, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 58.428336495794, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 92, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 58, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 58.471669073515, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 93, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 58, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 58.510002808248, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 94, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 59, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 58.548336542981, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 95, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 59, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 58.581667461085, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 96, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 58.611668466292, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 97, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 58.63666665487, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 98, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 58.661668817091, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 99, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 61, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 58.68500204922, 11, critChance = 6, damageEffectiveness = 2.7, levelRequirement = 100, statInterpolation = { 3, 3, 3, 1, }, cost = { Life = 61, }, },
	},
}
skills["ExsanguinateAltX"] = {
	name = "Exsanguinate of Transmission",
	baseTypeName = "Exsanguinate of Transmission",
	color = 1,
	baseEffectiveness = 1.7024999856949,
	incrementalEffectiveness = 0.052499998360872,
	description = "Releases a tendril of blood from your character, which will target an enemy in front of you, then chain to other enemies. The tendril deals physical damage and inflicts a physical damage over time debuff to enemies, which can stack up to 3 times.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.DamageOverTime] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["base_physical_damage_to_deal_per_minute"] = {
			skill("PhysicalDot", nil, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage", neg = true }),
			skill("FireDot", nil, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage"}),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		chaining = true,
	},
	baseMods = {
		skill("debuff", true),
		mod("Multiplier:ExsanguinateofTransmissionMaxStages", "BASE", 3),
		mod("PhysicalDamage", "MORE", 100, 0, KeywordFlag.PhysicalDot, { type = "Multiplier", var = "ExsanguinateofTransmissionStageAfterFirst"}, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage", neg = true }),
		mod("FireDamage", "MORE", 100, bit.bor(ModFlag.Spell,ModFlag.Dot), 0, { type = "Multiplier", var = "ExsanguinateofTransmissionStageAfterFirst"}, { type = "Condition", var = "ExsanguinateDebuffIsFireDamage" }),
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 100 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "blood_tendrils_beam_count", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_physical_damage_to_deal_per_minute",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_chains",
		"spell_damage_modifiers_apply_to_skill_dot",
		"quality_display_exsanguinate_beam_targets_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 77.238338925305, -0.63999998569489, -0.95999997854233, 6, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 16, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 76.421667853482, -0.63999998569489, -0.95999997854233, 6, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 18, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 75.086666831821, -0.63999998569489, -0.95999997854233, 6, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 21, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 73.768331269212, -0.63999998569489, -0.95999997854233, 7, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 23, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 72.466669112941, -0.63999998569489, -0.95999997854233, 7, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 25, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 71.185002328617, -0.63999998569489, -0.95999997854233, 7, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 26, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 69.916671090449, -0.63999998569489, -0.95999997854233, 7, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 28, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 69.136668796912, -0.63999998569489, -0.95999997854233, 7, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 30, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 68.360004363557, -0.63999998569489, -0.95999997854233, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 32, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 67.586669843098, -0.63999998569489, -0.95999997854233, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 33, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 66.816665235534, -0.63999998569489, -0.95999997854233, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 34, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 66.050002461796, -0.63999998569489, -0.95999997854233, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 35, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 65.286669600954, -0.63999998569489, -0.95999997854233, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 37, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 64.526666653007, -0.63999998569489, -0.95999997854233, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 39, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 63.771666521691, -0.63999998569489, -0.95999997854233, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 40, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 63.020000276913, -0.63999998569489, -0.95999997854233, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 42, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 62.700002800177, -0.63999998569489, -0.95999997854233, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 43, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 62.380001349797, -0.63999998569489, -0.95999997854233, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 44, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 62.053336099982, -0.63999998569489, -0.95999997854233, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 45, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 61.726666876525, -0.63999998569489, -0.95999997854233, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 46, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 61.396667740171, -0.63999998569489, -0.95999997854233, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 47, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 61.063334717279, -0.63999998569489, -0.95999997854233, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 48, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 60.730001694386, -0.63999998569489, -0.95999997854233, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 49, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 60.391669828507, -0.63999998569489, -0.95999997854233, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 50, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 60.053333988984, -0.63999998569489, -0.95999997854233, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 51, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 59.711668236566, -0.63999998569489, -0.95999997854233, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 52, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 59.370002484148, -0.63999998569489, -0.95999997854233, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 53, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 59.0233339151, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 54, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 58.678334276142, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 55, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 58.331669680737, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 56, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 58.380001101444, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 57, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 58.428336495794, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 58, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 58.471669073515, -0.63999998569489, -0.95999997854233, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 58, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 58.510002808248, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 59, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 58.548336542981, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 59, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 58.581667461085, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 58.611668466292, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 58.63666665487, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 60, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 58.661668817091, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 61, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 58.68500204922, -0.63999998569489, -0.95999997854233, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Life = 61, }, },
	},
}
skills["FlameLink"] = {
	name = "Flame Link",
	baseTypeName = "Flame Link",
	color = 1,
	baseEffectiveness = 0.52499997615814,
	incrementalEffectiveness = 0.039000000804663,
	description = "Targets an allied player to apply a buff which links you to them for a duration. While linked, they deal additional fire damage based on your life. If the target dies while linked, you will also die. This skill cannot be triggered, or used by Totems, Traps, or Mines.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Link] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["flame_link_minimum_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Link" }),
		},
		["flame_link_maximum_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Link" }),
		},
		["flame_link_added_fire_damage_from_life_%"] = {
			mod("FireMin", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Link" }, { type = "PercentStat", stat = "Life", percent = 1, actor = "parent" }),
			mod("FireMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Link" }, { type = "PercentStat", stat = "Life", percent = 1, actor = "parent" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 75 },
		},
	},
	constantStats = {
		{ "flame_link_added_fire_damage_from_life_%", 5 },
	},
	stats = {
		"flame_link_minimum_fire_damage",
		"flame_link_maximum_fire_damage",
		"base_skill_effect_duration",
		"skill_cost_over_time_is_not_removed_with_skill",
		"display_link_stuff",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 8000, levelRequirement = 34, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 900, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 8100, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 960, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 8200, levelRequirement = 38, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1030, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 8300, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1080, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 8400, levelRequirement = 42, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1140, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 8500, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1200, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 8600, levelRequirement = 46, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1250, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 8700, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1310, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 8800, levelRequirement = 50, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1380, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 8900, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1440, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 9000, levelRequirement = 54, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1490, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 9100, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1550, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 9200, levelRequirement = 58, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1610, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 9300, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1680, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 9400, levelRequirement = 62, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1730, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 9500, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1790, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 9600, levelRequirement = 66, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1850, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 9700, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1900, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 9800, levelRequirement = 69, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1940, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 9900, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 1960, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 10000, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2030, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 10100, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2090, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 10200, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2140, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 10300, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2200, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 10400, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2260, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 10500, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2330, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 10600, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2380, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 10700, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2440, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 10800, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2500, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 10900, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2550, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 11000, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2590, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 11050, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2610, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 11100, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2650, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 11150, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2680, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 11200, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2700, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 11250, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2740, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 11300, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2760, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 11350, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2790, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 11400, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2830, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 11450, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { ManaPerMinute = 2850, }, },
	},
}
skills["FleshAndStone"] = {
	name = "Flesh and Stone",
	baseTypeName = "Flesh and Stone",
	color = 1,
	description = "Buffs you, and affects nearby enemies with an aura, differently depending on your stance. Both stances are more impactful against enemies closer to you. Using the skill again alternates between Blood Stance and Sand Stance.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Aura] = true, [SkillType.AuraAffectsEnemies] = true, [SkillType.Instant] = true, [SkillType.HasReservation] = true, [SkillType.Area] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, [SkillType.Stance] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["flesh_stone_blood_stance_enemies_physical_damage_taken_when_hit_+%_final_from_player_distance"] = {
			mod("PhysicalDamageTaken", "MORE", nil, ModFlag.Hit, 0, { type = "GlobalEffect", effectType = "AuraDebuff", effectCond = "BloodStance" }),
		},
		["flesh_stone_sand_stance_damage_taken_+%_final_from_distance_from_enemy_hits"] = {
			mod("DamageTakenWhenHit", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectCond = "SandStance" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 28),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 28 },
		{ "active_skill_area_of_effect_description_mode", 4 },
	},
	stats = {
		"base_cooldown_speed_+%",
		"flesh_stone_sand_stance_damage_taken_+%_final_from_distance_from_enemy_hits",
		"flesh_stone_blood_stance_enemies_physical_damage_taken_when_hit_+%_final_from_player_distance",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
	},
	levels = {
		[1] = { 0, -10, 10, cooldown = 2, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 2, -10, 11, cooldown = 2, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 5, -11, 11, cooldown = 2, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 7, -11, 12, cooldown = 2, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 10, -12, 12, cooldown = 2, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 13, -12, 13, cooldown = 2, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 15, -13, 13, cooldown = 2, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 18, -13, 14, cooldown = 2, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 21, -14, 14, cooldown = 2, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 23, -14, 15, cooldown = 2, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 26, -15, 15, cooldown = 2, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 29, -15, 16, cooldown = 2, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 31, -16, 16, cooldown = 2, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 34, -16, 17, cooldown = 2, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 37, -17, 17, cooldown = 2, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 39, -17, 18, cooldown = 2, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 42, -18, 18, cooldown = 2, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 45, -18, 19, cooldown = 2, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 47, -19, 19, cooldown = 2, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 50, -19, 20, cooldown = 2, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 53, -20, 20, cooldown = 2, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 56, -20, 21, cooldown = 2, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 59, -21, 21, cooldown = 2, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 62, -21, 22, cooldown = 2, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 65, -22, 22, cooldown = 2, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 68, -22, 23, cooldown = 2, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { 71, -23, 23, cooldown = 2, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { 74, -23, 24, cooldown = 2, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { 77, -24, 24, cooldown = 2, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { 80, -24, 25, cooldown = 2, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { 82, -24, 25, cooldown = 2, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { 84, -25, 25, cooldown = 2, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { 86, -25, 25, cooldown = 2, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { 88, -25, 26, cooldown = 2, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { 90, -25, 26, cooldown = 2, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { 92, -26, 26, cooldown = 2, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { 94, -26, 26, cooldown = 2, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { 96, -26, 27, cooldown = 2, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { 98, -26, 27, cooldown = 2, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { 100, -27, 27, cooldown = 2, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["FrozenLegion"] = {
	name = "Frozen Legion",
	baseTypeName = "Frozen Legion",
	color = 1,
	description = "This spell consumes multiple cooldown uses to summon icy Statues in a ring. Each Statue uses your Frozen Sweep attack once before vanishing. Requires an Axe, Mace, Sceptre, or Staff. This skill cannot be triggered, supported by Spell Echo or Unleash, or used by Totems, Traps, or Mines. ",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Cooldown] = true, [SkillType.Cold] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "ring_of_ice_placement_distance", 28 },
	},
	stats = {
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { cooldown = 0.8, levelRequirement = 34, storedUses = 6, cost = { Mana = 12, }, },
		[2] = { cooldown = 0.8, levelRequirement = 36, storedUses = 6, cost = { Mana = 13, }, },
		[3] = { cooldown = 0.8, levelRequirement = 38, storedUses = 6, cost = { Mana = 13, }, },
		[4] = { cooldown = 0.8, levelRequirement = 40, storedUses = 6, cost = { Mana = 14, }, },
		[5] = { cooldown = 0.8, levelRequirement = 42, storedUses = 6, cost = { Mana = 14, }, },
		[6] = { cooldown = 0.8, levelRequirement = 44, storedUses = 6, cost = { Mana = 15, }, },
		[7] = { cooldown = 0.8, levelRequirement = 46, storedUses = 6, cost = { Mana = 15, }, },
		[8] = { cooldown = 0.8, levelRequirement = 48, storedUses = 6, cost = { Mana = 16, }, },
		[9] = { cooldown = 0.8, levelRequirement = 50, storedUses = 6, cost = { Mana = 17, }, },
		[10] = { cooldown = 0.8, levelRequirement = 52, storedUses = 6, cost = { Mana = 17, }, },
		[11] = { cooldown = 0.8, levelRequirement = 54, storedUses = 6, cost = { Mana = 18, }, },
		[12] = { cooldown = 0.8, levelRequirement = 56, storedUses = 6, cost = { Mana = 18, }, },
		[13] = { cooldown = 0.8, levelRequirement = 58, storedUses = 6, cost = { Mana = 19, }, },
		[14] = { cooldown = 0.8, levelRequirement = 60, storedUses = 6, cost = { Mana = 20, }, },
		[15] = { cooldown = 0.8, levelRequirement = 62, storedUses = 6, cost = { Mana = 20, }, },
		[16] = { cooldown = 0.8, levelRequirement = 64, storedUses = 6, cost = { Mana = 21, }, },
		[17] = { cooldown = 0.8, levelRequirement = 66, storedUses = 6, cost = { Mana = 21, }, },
		[18] = { cooldown = 0.8, levelRequirement = 68, storedUses = 6, cost = { Mana = 22, }, },
		[19] = { cooldown = 0.8, levelRequirement = 69, storedUses = 6, cost = { Mana = 22, }, },
		[20] = { cooldown = 0.8, levelRequirement = 70, storedUses = 6, cost = { Mana = 23, }, },
		[21] = { cooldown = 0.8, levelRequirement = 72, storedUses = 6, cost = { Mana = 24, }, },
		[22] = { cooldown = 0.8, levelRequirement = 74, storedUses = 6, cost = { Mana = 24, }, },
		[23] = { cooldown = 0.8, levelRequirement = 76, storedUses = 6, cost = { Mana = 25, }, },
		[24] = { cooldown = 0.8, levelRequirement = 78, storedUses = 6, cost = { Mana = 25, }, },
		[25] = { cooldown = 0.8, levelRequirement = 80, storedUses = 6, cost = { Mana = 26, }, },
		[26] = { cooldown = 0.8, levelRequirement = 82, storedUses = 6, cost = { Mana = 26, }, },
		[27] = { cooldown = 0.8, levelRequirement = 84, storedUses = 6, cost = { Mana = 27, }, },
		[28] = { cooldown = 0.8, levelRequirement = 86, storedUses = 6, cost = { Mana = 28, }, },
		[29] = { cooldown = 0.8, levelRequirement = 88, storedUses = 6, cost = { Mana = 28, }, },
		[30] = { cooldown = 0.8, levelRequirement = 90, storedUses = 6, cost = { Mana = 29, }, },
		[31] = { cooldown = 0.8, levelRequirement = 91, storedUses = 6, cost = { Mana = 29, }, },
		[32] = { cooldown = 0.8, levelRequirement = 92, storedUses = 6, cost = { Mana = 29, }, },
		[33] = { cooldown = 0.8, levelRequirement = 93, storedUses = 6, cost = { Mana = 30, }, },
		[34] = { cooldown = 0.8, levelRequirement = 94, storedUses = 6, cost = { Mana = 30, }, },
		[35] = { cooldown = 0.8, levelRequirement = 95, storedUses = 6, cost = { Mana = 30, }, },
		[36] = { cooldown = 0.8, levelRequirement = 96, storedUses = 6, cost = { Mana = 31, }, },
		[37] = { cooldown = 0.8, levelRequirement = 97, storedUses = 6, cost = { Mana = 31, }, },
		[38] = { cooldown = 0.8, levelRequirement = 98, storedUses = 6, cost = { Mana = 31, }, },
		[39] = { cooldown = 0.8, levelRequirement = 99, storedUses = 6, cost = { Mana = 31, }, },
		[40] = { cooldown = 0.8, levelRequirement = 100, storedUses = 6, cost = { Mana = 32, }, },
	},
}
skills["FrozenLegionAltX"] = {
	name = "Frozen Legion of Rallying",
	baseTypeName = "Frozen Legion of Rallying",
	color = 1,
	description = "This spell consumes multiple cooldown uses to summon icy Statues in a ring. Each Statue uses your Frozen Sweep attack once before vanishing. Requires an Axe, Mace, Sceptre, or Staff. This skill cannot be triggered, supported by Spell Echo or Unleash, or used by Totems, Traps, or Mines. ",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Cooldown] = true, [SkillType.Cold] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "ring_of_ice_placement_distance", 28 },
	},
	stats = {
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { cooldown = 0.3, levelRequirement = 34, storedUses = 5, cost = { Mana = 12, }, },
		[2] = { cooldown = 0.3, levelRequirement = 36, storedUses = 5, cost = { Mana = 13, }, },
		[3] = { cooldown = 0.3, levelRequirement = 38, storedUses = 5, cost = { Mana = 13, }, },
		[4] = { cooldown = 0.3, levelRequirement = 40, storedUses = 5, cost = { Mana = 14, }, },
		[5] = { cooldown = 0.3, levelRequirement = 42, storedUses = 5, cost = { Mana = 14, }, },
		[6] = { cooldown = 0.3, levelRequirement = 44, storedUses = 5, cost = { Mana = 15, }, },
		[7] = { cooldown = 0.3, levelRequirement = 46, storedUses = 5, cost = { Mana = 15, }, },
		[8] = { cooldown = 0.3, levelRequirement = 48, storedUses = 5, cost = { Mana = 16, }, },
		[9] = { cooldown = 0.3, levelRequirement = 50, storedUses = 5, cost = { Mana = 17, }, },
		[10] = { cooldown = 0.3, levelRequirement = 52, storedUses = 5, cost = { Mana = 17, }, },
		[11] = { cooldown = 0.3, levelRequirement = 54, storedUses = 5, cost = { Mana = 18, }, },
		[12] = { cooldown = 0.3, levelRequirement = 56, storedUses = 5, cost = { Mana = 18, }, },
		[13] = { cooldown = 0.3, levelRequirement = 58, storedUses = 5, cost = { Mana = 19, }, },
		[14] = { cooldown = 0.3, levelRequirement = 60, storedUses = 5, cost = { Mana = 20, }, },
		[15] = { cooldown = 0.3, levelRequirement = 62, storedUses = 5, cost = { Mana = 20, }, },
		[16] = { cooldown = 0.3, levelRequirement = 64, storedUses = 5, cost = { Mana = 21, }, },
		[17] = { cooldown = 0.3, levelRequirement = 66, storedUses = 5, cost = { Mana = 21, }, },
		[18] = { cooldown = 0.3, levelRequirement = 68, storedUses = 5, cost = { Mana = 22, }, },
		[19] = { cooldown = 0.3, levelRequirement = 69, storedUses = 5, cost = { Mana = 22, }, },
		[20] = { cooldown = 0.3, levelRequirement = 70, storedUses = 5, cost = { Mana = 23, }, },
		[21] = { cooldown = 0.3, levelRequirement = 72, storedUses = 5, cost = { Mana = 24, }, },
		[22] = { cooldown = 0.3, levelRequirement = 74, storedUses = 5, cost = { Mana = 24, }, },
		[23] = { cooldown = 0.3, levelRequirement = 76, storedUses = 5, cost = { Mana = 25, }, },
		[24] = { cooldown = 0.3, levelRequirement = 78, storedUses = 5, cost = { Mana = 25, }, },
		[25] = { cooldown = 0.3, levelRequirement = 80, storedUses = 5, cost = { Mana = 26, }, },
		[26] = { cooldown = 0.3, levelRequirement = 82, storedUses = 5, cost = { Mana = 26, }, },
		[27] = { cooldown = 0.3, levelRequirement = 84, storedUses = 5, cost = { Mana = 27, }, },
		[28] = { cooldown = 0.3, levelRequirement = 86, storedUses = 5, cost = { Mana = 28, }, },
		[29] = { cooldown = 0.3, levelRequirement = 88, storedUses = 5, cost = { Mana = 28, }, },
		[30] = { cooldown = 0.3, levelRequirement = 90, storedUses = 5, cost = { Mana = 29, }, },
		[31] = { cooldown = 0.3, levelRequirement = 91, storedUses = 5, cost = { Mana = 29, }, },
		[32] = { cooldown = 0.3, levelRequirement = 92, storedUses = 5, cost = { Mana = 29, }, },
		[33] = { cooldown = 0.3, levelRequirement = 93, storedUses = 5, cost = { Mana = 30, }, },
		[34] = { cooldown = 0.3, levelRequirement = 94, storedUses = 5, cost = { Mana = 30, }, },
		[35] = { cooldown = 0.3, levelRequirement = 95, storedUses = 5, cost = { Mana = 30, }, },
		[36] = { cooldown = 0.3, levelRequirement = 96, storedUses = 5, cost = { Mana = 31, }, },
		[37] = { cooldown = 0.3, levelRequirement = 97, storedUses = 5, cost = { Mana = 31, }, },
		[38] = { cooldown = 0.3, levelRequirement = 98, storedUses = 5, cost = { Mana = 31, }, },
		[39] = { cooldown = 0.3, levelRequirement = 99, storedUses = 5, cost = { Mana = 31, }, },
		[40] = { cooldown = 0.3, levelRequirement = 100, storedUses = 5, cost = { Mana = 32, }, },
	},
}
skills["FrozenSweep"] = {
	name = "Frozen Sweep",
	baseTypeName = "Frozen Sweep",
	color = 1,
	description = "This attack is used by your Statues to deal damage in an area around them while stepping forward. This skill cannot repeat and can only be used by Statues from Frozen Legion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.NonRepeatable] = true, [SkillType.OtherThingUsesSkill] = true, [SkillType.OwnerCannotUse] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 charge",
		},
		{
			name = "Wait for max charges",
		},
	},
	preDamageFunc = function(activeSkill, output, breakdown)
		local parentSkill
		local m_ceil = math.ceil
		local m_max = math.max
		activeSkill.skillData.showAverage = false
		activeSkill.skillFlags.showAverage = false
		activeSkill.skillFlags.notAverage = true	
		
		for _, skill in ipairs(activeSkill.actor.activeSkillList) do
			if skill.activeEffect.grantedEffect.name == "Frozen Legion" and activeSkill.actor.mainSkill.socketGroup.slot == activeSkill.socketGroup.slot then
				parentSkill = skill
				break
			end
		end

		if parentSkill.skillModList:Flag(parentSkill.skillCfg, "DisableSkill") and not parentSkill.skillModList:Flag(parentSkill.skillCfg, "EnableSkill") then
			return
		end

		activeSkill.skillData.cooldown = parentSkill.skillData.cooldown
		local cooldownOverride = parentSkill.skillModList:Override(parentSkill.skillCfg, "CooldownRecovery")
		local cooldown = cooldownOverride or (parentSkill.skillData.cooldown + parentSkill.skillModList:Sum("BASE", parentSkill.skillCfg, "CooldownRecovery")) / m_max(0, calcLib.mod(parentSkill.skillModList, parentSkill.skillCfg, "CooldownRecovery"))
		output.Cooldown = m_ceil(cooldown * data.misc.ServerTickRate) / data.misc.ServerTickRate
		activeSkill.skillData.hitTimeOverride = output.Cooldown

		local maxStatues = parentSkill.skillData.storedUses + parentSkill.skillModList:Sum("BASE", parentSkill.skillCfg, "AdditionalCooldownUses")
		local statuesWaitedFor

		if activeSkill.skillPart == 1 then
			statuesWaitedFor = 1
		elseif activeSkill.skillPart == 2 then
			statuesWaitedFor = maxStatues
		end
		activeSkill.skillData.averageBurstHits = statuesWaitedFor
	end,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
		skill("radius", 25),
	},
	qualityStats = {
		Default = {
			{ "dummy_stat_display_nothing", 0 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "skill_disabled_unless_cloned", 1 },
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 1.946, damageEffectiveness = 1.946, levelRequirement = 39, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 2.002, damageEffectiveness = 2.002, levelRequirement = 41, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 2.059, damageEffectiveness = 2.059, levelRequirement = 43, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 2.118, damageEffectiveness = 2.118, levelRequirement = 45, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 2.179, damageEffectiveness = 2.179, levelRequirement = 47, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 2.241, damageEffectiveness = 2.241, levelRequirement = 49, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 2.306, damageEffectiveness = 2.306, levelRequirement = 51, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 2.372, damageEffectiveness = 2.372, levelRequirement = 53, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 2.44, damageEffectiveness = 2.44, levelRequirement = 55, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 2.509, damageEffectiveness = 2.509, levelRequirement = 57, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 2.581, damageEffectiveness = 2.581, levelRequirement = 59, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 2.655, damageEffectiveness = 2.655, levelRequirement = 61, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 2.731, damageEffectiveness = 2.731, levelRequirement = 63, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 2.81, damageEffectiveness = 2.81, levelRequirement = 64, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 2.89, damageEffectiveness = 2.89, levelRequirement = 65, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 2.973, damageEffectiveness = 2.973, levelRequirement = 66, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 3.058, damageEffectiveness = 3.058, levelRequirement = 67, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 3.146, damageEffectiveness = 3.146, levelRequirement = 68, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 3.236, damageEffectiveness = 3.236, levelRequirement = 69, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 3.329, damageEffectiveness = 3.329, levelRequirement = 70, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 3.424, damageEffectiveness = 3.424, levelRequirement = 72, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 3.522, damageEffectiveness = 3.522, levelRequirement = 74, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 3.623, damageEffectiveness = 3.623, levelRequirement = 76, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 3.727, damageEffectiveness = 3.727, levelRequirement = 78, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 3.833, damageEffectiveness = 3.833, levelRequirement = 80, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 3.943, damageEffectiveness = 3.943, levelRequirement = 82, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 4.056, damageEffectiveness = 4.056, levelRequirement = 84, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 4.172, damageEffectiveness = 4.172, levelRequirement = 86, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 4.292, damageEffectiveness = 4.292, levelRequirement = 88, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 4.415, damageEffectiveness = 4.415, levelRequirement = 90, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 4.607, damageEffectiveness = 4.607, levelRequirement = 91, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 4.673, damageEffectiveness = 4.673, levelRequirement = 92, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 4.739, damageEffectiveness = 4.739, levelRequirement = 93, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 4.807, damageEffectiveness = 4.807, levelRequirement = 94, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 4.876, damageEffectiveness = 4.876, levelRequirement = 95, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 4.946, damageEffectiveness = 4.946, levelRequirement = 96, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 5.017, damageEffectiveness = 5.017, levelRequirement = 97, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 5.089, damageEffectiveness = 5.089, levelRequirement = 98, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 5.162, damageEffectiveness = 5.162, levelRequirement = 99, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 5.236, damageEffectiveness = 5.236, levelRequirement = 100, },
	},
}
skills["FrozenSweepAltX"] = {
	name = "Frozen Sweep",
	baseTypeName = "Frozen Sweep",
	color = 1,
	description = "This attack is used by your Statues to deal damage in an area around them while stepping forward. This skill cannot repeat and can only be used by Statues from Frozen Legion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.NonRepeatable] = true, [SkillType.OtherThingUsesSkill] = true, [SkillType.OwnerCannotUse] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 charge",
		},
		{
			name = "Wait for max charges",
		},
	},
	preDamageFunc = function(activeSkill, output, breakdown)
		local parentSkill
		local m_ceil = math.ceil
		local m_max = math.max
		activeSkill.skillData.showAverage = false
		activeSkill.skillFlags.showAverage = false
		activeSkill.skillFlags.notAverage = true

		for _, skill in ipairs(activeSkill.actor.activeSkillList) do
			if skill.activeEffect.grantedEffect.name == "Frozen Legion of Rallying" and activeSkill.actor.mainSkill.socketGroup.slot == activeSkill.socketGroup.slot then
				parentSkill = skill
				break
			end
		end

		if parentSkill.skillModList:Flag(parentSkill.skillCfg, "DisableSkill") and not parentSkill.skillModList:Flag(parentSkill.skillCfg, "EnableSkill") then
			return
		end

		activeSkill.skillData.cooldown = parentSkill.skillData.cooldown
		local cooldownOverride = parentSkill.skillModList:Override(parentSkill.skillCfg, "CooldownRecovery")
		local cooldown = cooldownOverride or (parentSkill.skillData.cooldown + parentSkill.skillModList:Sum("BASE", parentSkill.skillCfg, "CooldownRecovery")) / m_max(0, calcLib.mod(parentSkill.skillModList, parentSkill.skillCfg, "CooldownRecovery"))
		output.Cooldown = m_ceil(cooldown * data.misc.ServerTickRate) / data.misc.ServerTickRate
		activeSkill.skillData.hitTimeOverride = output.Cooldown

		local maxStatues = parentSkill.skillData.storedUses + parentSkill.skillModList:Sum("BASE", parentSkill.skillCfg, "AdditionalCooldownUses")
		local statuesWaitedFor

		if activeSkill.skillPart == 1 then
			statuesWaitedFor = 1
		elseif activeSkill.skillPart == 2 then
			statuesWaitedFor = maxStatues
		end
		activeSkill.skillData.averageBurstHits = statuesWaitedFor
	end,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
		skill("radius", 25),
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "skill_disabled_unless_cloned", 1 },
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 1.081, damageEffectiveness = 1.081, levelRequirement = 39, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 1.112, damageEffectiveness = 1.112, levelRequirement = 41, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 1.144, damageEffectiveness = 1.144, levelRequirement = 43, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 1.177, damageEffectiveness = 1.177, levelRequirement = 45, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 1.211, damageEffectiveness = 1.211, levelRequirement = 47, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 1.245, damageEffectiveness = 1.245, levelRequirement = 49, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 1.281, damageEffectiveness = 1.281, levelRequirement = 51, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 1.318, damageEffectiveness = 1.318, levelRequirement = 53, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 1.355, damageEffectiveness = 1.355, levelRequirement = 55, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 1.394, damageEffectiveness = 1.394, levelRequirement = 57, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 1.434, damageEffectiveness = 1.434, levelRequirement = 59, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 1.475, damageEffectiveness = 1.475, levelRequirement = 61, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 1.517, damageEffectiveness = 1.517, levelRequirement = 63, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 1.561, damageEffectiveness = 1.561, levelRequirement = 64, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 1.606, damageEffectiveness = 1.606, levelRequirement = 65, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 1.652, damageEffectiveness = 1.652, levelRequirement = 66, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 1.699, damageEffectiveness = 1.699, levelRequirement = 67, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 1.748, damageEffectiveness = 1.748, levelRequirement = 68, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 1.798, damageEffectiveness = 1.798, levelRequirement = 69, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 1.849, damageEffectiveness = 1.849, levelRequirement = 70, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 1.902, damageEffectiveness = 1.902, levelRequirement = 72, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 1.957, damageEffectiveness = 1.957, levelRequirement = 74, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 2.013, damageEffectiveness = 2.013, levelRequirement = 76, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 2.07, damageEffectiveness = 2.07, levelRequirement = 78, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 2.13, damageEffectiveness = 2.13, levelRequirement = 80, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 2.191, damageEffectiveness = 2.191, levelRequirement = 82, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 2.253, damageEffectiveness = 2.253, levelRequirement = 84, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 2.318, damageEffectiveness = 2.318, levelRequirement = 86, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 2.384, damageEffectiveness = 2.384, levelRequirement = 88, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 2.453, damageEffectiveness = 2.453, levelRequirement = 90, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 2.559, damageEffectiveness = 2.559, levelRequirement = 91, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 2.596, damageEffectiveness = 2.596, levelRequirement = 92, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 2.633, damageEffectiveness = 2.633, levelRequirement = 93, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 2.671, damageEffectiveness = 2.671, levelRequirement = 94, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 2.709, damageEffectiveness = 2.709, levelRequirement = 95, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 2.748, damageEffectiveness = 2.748, levelRequirement = 96, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 2.787, damageEffectiveness = 2.787, levelRequirement = 97, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 2.827, damageEffectiveness = 2.827, levelRequirement = 98, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 2.868, damageEffectiveness = 2.868, levelRequirement = 99, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 2.909, damageEffectiveness = 2.909, levelRequirement = 100, },
	},
}
skills["GeneralsCry"] = {
	name = "General's Cry",
	baseTypeName = "General's Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user, and summoning Mirage Warriors from nearby corpses. The Mirage Warriors each use a linked attack skill once before dissipating.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["spiritual_cry_doubles_summoned_per_5_MP"] = {
		},
		["maximum_number_of_spiritual_cry_warriors"] = {
			mod("GeneralsCryDoubleMaxCount", "BASE", nil),
		},
		["quality_display_generals_cry_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "maximum_number_of_spiritual_cry_warriors", 0.05 },
		},
	},
	constantStats = {
		{ "spiritual_cry_doubles_summoned_per_5_MP", 2 },
		{ "maximum_number_of_spiritual_cry_warriors", 5 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_gain_mp_from_corpses",
		"warcry_count_power_from_enemies",
		"quality_display_generals_cry_is_gem",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 4000, cooldown = 3, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 2, 4000, cooldown = 3, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 4100, cooldown = 3, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 4100, cooldown = 3, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 4200, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 10, 4200, cooldown = 3, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 12, 4300, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 4300, cooldown = 3, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 4400, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 18, 4400, cooldown = 3, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 20, 4500, cooldown = 3, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 4500, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 4600, cooldown = 3, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 26, 4600, cooldown = 3, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 4700, cooldown = 3, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 4700, cooldown = 3, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 4800, cooldown = 3, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 4800, cooldown = 3, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 4900, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 4900, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 5000, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 5000, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 5100, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 5100, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 5200, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 5200, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 5300, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 5300, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 5400, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 5400, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 5400, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 5400, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 5500, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 5500, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 5500, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 5500, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 5600, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 5600, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 5600, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 5600, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["GeneralsCrySupport"] = {
	name = "General's Cry",
	description = "Supports melee attack skills. Those skills will be used by Mirage Warriors summoned by General's Cry. Supported skills cannot be supported by Multistrike.",
	color = 1,
	support = true,
	requireSkillTypes = { SkillType.Melee, SkillType.Attack, SkillType.AND, },
	addSkillTypes = { SkillType.NonRepeatable, SkillType.OtherThingUsesSkill, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.HasReservation, SkillType.Vaal, SkillType.Instant, SkillType.Spell, SkillType.Triggered, SkillType.InbuiltTrigger, SkillType.OwnerCannotUse, },
	ignoreMinionTypes = true,
	statDescriptionScope = "gem_stat_descriptions",
	addFlags = {
		forceMainHand = true,
	},
	statMap = {
		["support_spiritual_cry_damage_+%_final"] = {
			mod("Damage", "MORE", nil),
		},
		["number_of_warcries_exerting_this_action"] = {
		},
	},
	constantStats = {
		{ "number_of_warcries_exerting_this_action", 1 },
	},
	stats = {
		"support_spiritual_cry_damage_+%_final",
		"triggered_by_spiritual_cry",
		"no_spirit_strikes",
		"force_lite_skill_effects",
		"base_damage_not_from_skill_user",
	},
	levels = {
		[1] = { -60, levelRequirement = 24, statInterpolation = { 1, }, },
		[2] = { -60, levelRequirement = 27, statInterpolation = { 1, }, },
		[3] = { -59, levelRequirement = 30, statInterpolation = { 1, }, },
		[4] = { -59, levelRequirement = 33, statInterpolation = { 1, }, },
		[5] = { -58, levelRequirement = 36, statInterpolation = { 1, }, },
		[6] = { -58, levelRequirement = 39, statInterpolation = { 1, }, },
		[7] = { -57, levelRequirement = 42, statInterpolation = { 1, }, },
		[8] = { -57, levelRequirement = 45, statInterpolation = { 1, }, },
		[9] = { -56, levelRequirement = 48, statInterpolation = { 1, }, },
		[10] = { -56, levelRequirement = 50, statInterpolation = { 1, }, },
		[11] = { -55, levelRequirement = 52, statInterpolation = { 1, }, },
		[12] = { -55, levelRequirement = 54, statInterpolation = { 1, }, },
		[13] = { -54, levelRequirement = 56, statInterpolation = { 1, }, },
		[14] = { -54, levelRequirement = 58, statInterpolation = { 1, }, },
		[15] = { -53, levelRequirement = 60, statInterpolation = { 1, }, },
		[16] = { -53, levelRequirement = 62, statInterpolation = { 1, }, },
		[17] = { -52, levelRequirement = 64, statInterpolation = { 1, }, },
		[18] = { -52, levelRequirement = 66, statInterpolation = { 1, }, },
		[19] = { -51, levelRequirement = 68, statInterpolation = { 1, }, },
		[20] = { -51, levelRequirement = 70, statInterpolation = { 1, }, },
		[21] = { -50, levelRequirement = 72, statInterpolation = { 1, }, },
		[22] = { -50, levelRequirement = 74, statInterpolation = { 1, }, },
		[23] = { -49, levelRequirement = 76, statInterpolation = { 1, }, },
		[24] = { -49, levelRequirement = 78, statInterpolation = { 1, }, },
		[25] = { -48, levelRequirement = 80, statInterpolation = { 1, }, },
		[26] = { -48, levelRequirement = 82, statInterpolation = { 1, }, },
		[27] = { -47, levelRequirement = 84, statInterpolation = { 1, }, },
		[28] = { -47, levelRequirement = 86, statInterpolation = { 1, }, },
		[29] = { -46, levelRequirement = 88, statInterpolation = { 1, }, },
		[30] = { -46, levelRequirement = 90, statInterpolation = { 1, }, },
		[31] = { -46, levelRequirement = 91, statInterpolation = { 1, }, },
		[32] = { -45, levelRequirement = 92, statInterpolation = { 1, }, },
		[33] = { -45, levelRequirement = 93, statInterpolation = { 1, }, },
		[34] = { -45, levelRequirement = 94, statInterpolation = { 1, }, },
		[35] = { -45, levelRequirement = 95, statInterpolation = { 1, }, },
		[36] = { -44, levelRequirement = 96, statInterpolation = { 1, }, },
		[37] = { -44, levelRequirement = 97, statInterpolation = { 1, }, },
		[38] = { -44, levelRequirement = 98, statInterpolation = { 1, }, },
		[39] = { -44, levelRequirement = 99, statInterpolation = { 1, }, },
		[40] = { -43, levelRequirement = 100, statInterpolation = { 1, }, },
	},
}
skills["GlacialHammer"] = {
	name = "Glacial Hammer",
	baseTypeName = "Glacial Hammer",
	color = 1,
	description = "Hits enemies, converting some of your physical damage to cold damage. If a non-unique enemy is frozen and is on less than one third life, they will shatter when hit by Glacial Hammer. If striking three times in a row, the third strike will freeze enemies more easily. Requires a Mace, Sceptre or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["glacial_hammer_third_hit_freeze_as_though_dealt_damage_+%"] = {
			mod("FreezeAsThoughDealing", "MORE", nil)
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "glacial_hammer_third_hit_freeze_as_though_dealt_damage_+%", 5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "base_chance_to_freeze_%", 25 },
		{ "cold_ailment_duration_+%", 35 },
		{ "additional_main_hand_hits_per_combo_average", 1 },
	},
	stats = {
		"cold_ailment_effect_+%",
		"glacial_hammer_third_hit_freeze_as_though_dealt_damage_+%",
		"glacial_hammer_shatter_frozen_enemies_at_33%_life",
		"quality_display_glacial_hammer_is_gem",
	},
	levels = {
		[1] = { 10, 200, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 11, 210, baseMultiplier = 2.298, damageEffectiveness = 2.298, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 12, 220, baseMultiplier = 2.422, damageEffectiveness = 2.422, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 13, 230, baseMultiplier = 2.557, damageEffectiveness = 2.557, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 14, 240, baseMultiplier = 2.705, damageEffectiveness = 2.705, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[6] = { 15, 250, baseMultiplier = 2.866, damageEffectiveness = 2.866, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 16, 260, baseMultiplier = 3.031, damageEffectiveness = 3.031, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[8] = { 17, 270, baseMultiplier = 3.206, damageEffectiveness = 3.206, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[9] = { 18, 280, baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[10] = { 19, 290, baseMultiplier = 3.584, damageEffectiveness = 3.584, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 20, 300, baseMultiplier = 3.789, damageEffectiveness = 3.789, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[12] = { 21, 310, baseMultiplier = 4.007, damageEffectiveness = 4.007, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[13] = { 22, 320, baseMultiplier = 4.236, damageEffectiveness = 4.236, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[14] = { 23, 330, baseMultiplier = 4.478, damageEffectiveness = 4.478, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[15] = { 24, 340, baseMultiplier = 4.734, damageEffectiveness = 4.734, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[16] = { 25, 350, baseMultiplier = 5.004, damageEffectiveness = 5.004, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[17] = { 26, 360, baseMultiplier = 5.291, damageEffectiveness = 5.291, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[18] = { 27, 370, baseMultiplier = 5.592, damageEffectiveness = 5.592, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[19] = { 28, 380, baseMultiplier = 5.9, damageEffectiveness = 5.9, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[20] = { 29, 390, baseMultiplier = 6.226, damageEffectiveness = 6.226, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[21] = { 30, 400, baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[22] = { 31, 410, baseMultiplier = 6.909, damageEffectiveness = 6.909, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[23] = { 32, 420, baseMultiplier = 7.279, damageEffectiveness = 7.279, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[24] = { 33, 430, baseMultiplier = 7.667, damageEffectiveness = 7.667, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 34, 440, baseMultiplier = 8.077, damageEffectiveness = 8.077, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[26] = { 35, 450, baseMultiplier = 8.508, damageEffectiveness = 8.508, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[27] = { 36, 460, baseMultiplier = 8.962, damageEffectiveness = 8.962, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[28] = { 37, 470, baseMultiplier = 9.441, damageEffectiveness = 9.441, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[29] = { 38, 480, baseMultiplier = 9.944, damageEffectiveness = 9.944, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[30] = { 39, 490, baseMultiplier = 10.475, damageEffectiveness = 10.475, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[31] = { 39, 495, baseMultiplier = 11.292, damageEffectiveness = 11.292, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[32] = { 40, 500, baseMultiplier = 11.592, damageEffectiveness = 11.592, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[33] = { 40, 505, baseMultiplier = 11.901, damageEffectiveness = 11.901, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[34] = { 41, 510, baseMultiplier = 12.217, damageEffectiveness = 12.217, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[35] = { 41, 515, baseMultiplier = 12.542, damageEffectiveness = 12.542, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[36] = { 42, 520, baseMultiplier = 12.876, damageEffectiveness = 12.876, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[37] = { 42, 525, baseMultiplier = 13.219, damageEffectiveness = 13.219, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[38] = { 43, 530, baseMultiplier = 13.571, damageEffectiveness = 13.571, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[39] = { 43, 535, baseMultiplier = 13.932, damageEffectiveness = 13.932, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[40] = { 44, 540, baseMultiplier = 14.302, damageEffectiveness = 14.302, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
	},
}
skills["GlacialHammerAltX"] = {
	name = "Glacial Hammer of Shattering",
	baseTypeName = "Glacial Hammer of Shattering",
	color = 1,
	description = "Hits enemies, converting some of your physical damage to cold damage. If striking three times in a row, the third strike will be a critical strike. Requires a Mace, Sceptre or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["glacial_hammer_third_hit_always_crits"] = {
			flag("Every3UseCrit"),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "base_critical_strike_multiplier_+", 2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "additional_main_hand_hits_per_combo_average", 1 },
	},
	stats = {
		"quality_display_glacial_hammer_is_gem",
		"glacial_hammer_third_hit_always_crits",
	},
	levels = {
		[1] = { baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, cost = { Mana = 6, }, },
		[2] = { baseMultiplier = 2.298, damageEffectiveness = 2.298, levelRequirement = 2, cost = { Mana = 6, }, },
		[3] = { baseMultiplier = 2.422, damageEffectiveness = 2.422, levelRequirement = 4, cost = { Mana = 6, }, },
		[4] = { baseMultiplier = 2.557, damageEffectiveness = 2.557, levelRequirement = 7, cost = { Mana = 6, }, },
		[5] = { baseMultiplier = 2.705, damageEffectiveness = 2.705, levelRequirement = 11, cost = { Mana = 6, }, },
		[6] = { baseMultiplier = 2.866, damageEffectiveness = 2.866, levelRequirement = 16, cost = { Mana = 7, }, },
		[7] = { baseMultiplier = 3.031, damageEffectiveness = 3.031, levelRequirement = 20, cost = { Mana = 7, }, },
		[8] = { baseMultiplier = 3.206, damageEffectiveness = 3.206, levelRequirement = 24, cost = { Mana = 7, }, },
		[9] = { baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 28, cost = { Mana = 7, }, },
		[10] = { baseMultiplier = 3.584, damageEffectiveness = 3.584, levelRequirement = 32, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 3.789, damageEffectiveness = 3.789, levelRequirement = 36, cost = { Mana = 8, }, },
		[12] = { baseMultiplier = 4.007, damageEffectiveness = 4.007, levelRequirement = 40, cost = { Mana = 8, }, },
		[13] = { baseMultiplier = 4.236, damageEffectiveness = 4.236, levelRequirement = 44, cost = { Mana = 8, }, },
		[14] = { baseMultiplier = 4.478, damageEffectiveness = 4.478, levelRequirement = 48, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 4.734, damageEffectiveness = 4.734, levelRequirement = 52, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 5.004, damageEffectiveness = 5.004, levelRequirement = 56, cost = { Mana = 9, }, },
		[17] = { baseMultiplier = 5.291, damageEffectiveness = 5.291, levelRequirement = 60, cost = { Mana = 9, }, },
		[18] = { baseMultiplier = 5.592, damageEffectiveness = 5.592, levelRequirement = 64, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 5.9, damageEffectiveness = 5.9, levelRequirement = 67, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 6.226, damageEffectiveness = 6.226, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 6.909, damageEffectiveness = 6.909, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 7.279, damageEffectiveness = 7.279, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 7.667, damageEffectiveness = 7.667, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 8.077, damageEffectiveness = 8.077, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 8.508, damageEffectiveness = 8.508, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 8.962, damageEffectiveness = 8.962, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 9.441, damageEffectiveness = 9.441, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 9.944, damageEffectiveness = 9.944, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 10.475, damageEffectiveness = 10.475, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 11.292, damageEffectiveness = 11.292, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 11.592, damageEffectiveness = 11.592, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 11.901, damageEffectiveness = 11.901, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 12.217, damageEffectiveness = 12.217, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 12.542, damageEffectiveness = 12.542, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 12.876, damageEffectiveness = 12.876, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 13.219, damageEffectiveness = 13.219, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 13.571, damageEffectiveness = 13.571, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 13.932, damageEffectiveness = 13.932, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 14.302, damageEffectiveness = 14.302, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["VaalGlacialHammer"] = {
	name = "Vaal Glacial Hammer",
	baseTypeName = "Vaal Glacial Hammer",
	color = 1,
	description = "Hits enemies, converting some of your physical damage to cold damage. It traps enemies with you in a circle of ice so that they can't escape. Requires a Mace, Sceptre or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.Vaal] = true, [SkillType.Cold] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 20),
	},
	qualityStats = {
		Default = {
			{ "cold_ailment_duration_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "base_chance_to_freeze_%", 25 },
		{ "cold_ailment_duration_+%", 35 },
	},
	stats = {
		"base_skill_effect_duration",
		"cold_ailment_effect_+%",
		"freeze_as_though_dealt_damage_+%",
		"global_always_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 3400, 10, 200, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[2] = { 3450, 11, 210, baseMultiplier = 2.294, damageEffectiveness = 2.294, levelRequirement = 2, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[3] = { 3500, 12, 220, baseMultiplier = 2.409, damageEffectiveness = 2.409, levelRequirement = 4, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[4] = { 3550, 13, 230, baseMultiplier = 2.529, damageEffectiveness = 2.529, levelRequirement = 7, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[5] = { 3600, 14, 240, baseMultiplier = 2.656, damageEffectiveness = 2.656, levelRequirement = 11, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[6] = { 3650, 15, 250, baseMultiplier = 2.789, damageEffectiveness = 2.789, levelRequirement = 16, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[7] = { 3700, 16, 260, baseMultiplier = 2.928, damageEffectiveness = 2.928, levelRequirement = 20, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[8] = { 3750, 17, 270, baseMultiplier = 3.075, damageEffectiveness = 3.075, levelRequirement = 24, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[9] = { 3800, 18, 280, baseMultiplier = 3.228, damageEffectiveness = 3.228, levelRequirement = 28, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[10] = { 3850, 19, 290, baseMultiplier = 3.39, damageEffectiveness = 3.39, levelRequirement = 32, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[11] = { 3900, 20, 300, baseMultiplier = 3.559, damageEffectiveness = 3.559, levelRequirement = 36, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[12] = { 3950, 21, 310, baseMultiplier = 3.737, damageEffectiveness = 3.737, levelRequirement = 40, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[13] = { 4000, 22, 320, baseMultiplier = 3.924, damageEffectiveness = 3.924, levelRequirement = 44, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[14] = { 4050, 23, 330, baseMultiplier = 4.12, damageEffectiveness = 4.12, levelRequirement = 48, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[15] = { 4100, 24, 340, baseMultiplier = 4.326, damageEffectiveness = 4.326, levelRequirement = 52, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[16] = { 4150, 25, 350, baseMultiplier = 4.542, damageEffectiveness = 4.542, levelRequirement = 56, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[17] = { 4200, 26, 360, baseMultiplier = 4.77, damageEffectiveness = 4.77, levelRequirement = 60, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[18] = { 4250, 27, 370, baseMultiplier = 5.008, damageEffectiveness = 5.008, levelRequirement = 64, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[19] = { 4300, 28, 380, baseMultiplier = 5.258, damageEffectiveness = 5.258, levelRequirement = 67, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[20] = { 4350, 29, 390, baseMultiplier = 5.521, damageEffectiveness = 5.521, levelRequirement = 70, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[21] = { 4400, 30, 400, baseMultiplier = 5.797, damageEffectiveness = 5.797, levelRequirement = 72, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[22] = { 4450, 31, 410, baseMultiplier = 6.087, damageEffectiveness = 6.087, levelRequirement = 74, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[23] = { 4500, 32, 420, baseMultiplier = 6.392, damageEffectiveness = 6.392, levelRequirement = 76, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[24] = { 4550, 33, 430, baseMultiplier = 6.711, damageEffectiveness = 6.711, levelRequirement = 78, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[25] = { 4600, 34, 440, baseMultiplier = 7.047, damageEffectiveness = 7.047, levelRequirement = 80, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[26] = { 4650, 35, 450, baseMultiplier = 7.399, damageEffectiveness = 7.399, levelRequirement = 82, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[27] = { 4700, 36, 460, baseMultiplier = 7.769, damageEffectiveness = 7.769, levelRequirement = 84, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[28] = { 4750, 37, 470, baseMultiplier = 8.158, damageEffectiveness = 8.158, levelRequirement = 86, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[29] = { 4800, 38, 480, baseMultiplier = 8.565, damageEffectiveness = 8.565, levelRequirement = 88, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[30] = { 4850, 39, 490, baseMultiplier = 8.994, damageEffectiveness = 8.994, levelRequirement = 90, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[31] = { 4850, 39, 495, baseMultiplier = 9.68, damageEffectiveness = 9.68, levelRequirement = 91, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[32] = { 4900, 40, 500, baseMultiplier = 9.922, damageEffectiveness = 9.922, levelRequirement = 92, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[33] = { 4900, 40, 505, baseMultiplier = 10.17, damageEffectiveness = 10.17, levelRequirement = 93, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[34] = { 4950, 41, 510, baseMultiplier = 10.424, damageEffectiveness = 10.424, levelRequirement = 94, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[35] = { 4950, 41, 515, baseMultiplier = 10.684, damageEffectiveness = 10.684, levelRequirement = 95, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[36] = { 5000, 42, 520, baseMultiplier = 10.951, damageEffectiveness = 10.951, levelRequirement = 96, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[37] = { 5000, 42, 525, baseMultiplier = 11.225, damageEffectiveness = 11.225, levelRequirement = 97, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[38] = { 5050, 43, 530, baseMultiplier = 11.506, damageEffectiveness = 11.506, levelRequirement = 98, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[39] = { 5050, 43, 535, baseMultiplier = 11.794, damageEffectiveness = 11.794, levelRequirement = 99, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
		[40] = { 5100, 44, 540, baseMultiplier = 12.088, damageEffectiveness = 12.088, levelRequirement = 100, soulPreventionDuration = 4, vaalStoredUses = 3, statInterpolation = { 1, 1, 1, }, cost = { Soul = 15, }, },
	},
}
skills["GroundSlam"] = {
	name = "Ground Slam",
	baseTypeName = "Ground Slam",
	color = 1,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slams the ground in front of you, creating a wave that travels forward and damages enemies with an increased chance to stun. The wave deals more damage to closer enemies. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["groundslam_damage_to_close_targets_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Condition", var = "AtCloseRange" })
		},
		["quality_display_groundslam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 35),
	},
	qualityStats = {
		Default = {
			{ "groundslam_damage_to_close_targets_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_stun_threshold_reduction_+%", 25 },
	},
	stats = {
		"active_skill_base_radius_+",
		"groundslam_damage_to_close_targets_+%_final",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_groundslam_is_gem",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, 40, attackSpeedMultiplier = -10, baseMultiplier = 1.323, damageEffectiveness = 1.323, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 1, 40, attackSpeedMultiplier = -10, baseMultiplier = 1.388, damageEffectiveness = 1.388, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 1, 41, attackSpeedMultiplier = -10, baseMultiplier = 1.458, damageEffectiveness = 1.458, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 2, 41, attackSpeedMultiplier = -10, baseMultiplier = 1.535, damageEffectiveness = 1.535, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 2, 42, attackSpeedMultiplier = -10, baseMultiplier = 1.618, damageEffectiveness = 1.618, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 3, 42, attackSpeedMultiplier = -10, baseMultiplier = 1.71, damageEffectiveness = 1.71, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 3, 43, attackSpeedMultiplier = -10, baseMultiplier = 1.803, damageEffectiveness = 1.803, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 4, 43, attackSpeedMultiplier = -10, baseMultiplier = 1.902, damageEffectiveness = 1.902, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 4, 44, attackSpeedMultiplier = -10, baseMultiplier = 2.005, damageEffectiveness = 2.005, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[10] = { 5, 44, attackSpeedMultiplier = -10, baseMultiplier = 2.114, damageEffectiveness = 2.114, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 5, 45, attackSpeedMultiplier = -10, baseMultiplier = 2.229, damageEffectiveness = 2.229, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 6, 45, attackSpeedMultiplier = -10, baseMultiplier = 2.35, damageEffectiveness = 2.35, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[13] = { 6, 46, attackSpeedMultiplier = -10, baseMultiplier = 2.478, damageEffectiveness = 2.478, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[14] = { 7, 46, attackSpeedMultiplier = -10, baseMultiplier = 2.612, damageEffectiveness = 2.612, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[15] = { 7, 47, attackSpeedMultiplier = -10, baseMultiplier = 2.753, damageEffectiveness = 2.753, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[16] = { 8, 47, attackSpeedMultiplier = -10, baseMultiplier = 2.902, damageEffectiveness = 2.902, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[17] = { 8, 48, attackSpeedMultiplier = -10, baseMultiplier = 3.059, damageEffectiveness = 3.059, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[18] = { 9, 48, attackSpeedMultiplier = -10, baseMultiplier = 3.223, damageEffectiveness = 3.223, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[19] = { 9, 49, attackSpeedMultiplier = -10, baseMultiplier = 3.392, damageEffectiveness = 3.392, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[20] = { 10, 49, attackSpeedMultiplier = -10, baseMultiplier = 3.569, damageEffectiveness = 3.569, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[21] = { 10, 50, attackSpeedMultiplier = -10, baseMultiplier = 3.749, damageEffectiveness = 3.749, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[22] = { 11, 50, attackSpeedMultiplier = -10, baseMultiplier = 3.939, damageEffectiveness = 3.939, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[23] = { 11, 51, attackSpeedMultiplier = -10, baseMultiplier = 4.137, damageEffectiveness = 4.137, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[24] = { 12, 51, attackSpeedMultiplier = -10, baseMultiplier = 4.345, damageEffectiveness = 4.345, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[25] = { 12, 52, attackSpeedMultiplier = -10, baseMultiplier = 4.564, damageEffectiveness = 4.564, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[26] = { 13, 52, attackSpeedMultiplier = -10, baseMultiplier = 4.794, damageEffectiveness = 4.794, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[27] = { 13, 53, attackSpeedMultiplier = -10, baseMultiplier = 5.035, damageEffectiveness = 5.035, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[28] = { 14, 53, attackSpeedMultiplier = -10, baseMultiplier = 5.289, damageEffectiveness = 5.289, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[29] = { 14, 54, attackSpeedMultiplier = -10, baseMultiplier = 5.555, damageEffectiveness = 5.555, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[30] = { 15, 54, attackSpeedMultiplier = -10, baseMultiplier = 5.835, damageEffectiveness = 5.835, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[31] = { 15, 54, attackSpeedMultiplier = -10, baseMultiplier = 6.263, damageEffectiveness = 6.263, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[32] = { 15, 55, attackSpeedMultiplier = -10, baseMultiplier = 6.42, damageEffectiveness = 6.42, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[33] = { 16, 55, attackSpeedMultiplier = -10, baseMultiplier = 6.581, damageEffectiveness = 6.581, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[34] = { 16, 55, attackSpeedMultiplier = -10, baseMultiplier = 6.746, damageEffectiveness = 6.746, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[35] = { 16, 55, attackSpeedMultiplier = -10, baseMultiplier = 6.917, damageEffectiveness = 6.917, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[36] = { 17, 55, attackSpeedMultiplier = -10, baseMultiplier = 7.09, damageEffectiveness = 7.09, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[37] = { 17, 55, attackSpeedMultiplier = -10, baseMultiplier = 7.268, damageEffectiveness = 7.268, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[38] = { 17, 56, attackSpeedMultiplier = -10, baseMultiplier = 7.451, damageEffectiveness = 7.451, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[39] = { 18, 56, attackSpeedMultiplier = -10, baseMultiplier = 7.637, damageEffectiveness = 7.637, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[40] = { 18, 56, attackSpeedMultiplier = -10, baseMultiplier = 7.829, damageEffectiveness = 7.829, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
	},
}
skills["GroundSlamAltX"] = {
	name = "Ground Slam of Earthshaking",
	baseTypeName = "Ground Slam of Earthshaking",
	color = 1,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slams the ground in front of you, creating a wide wave that travels forward and damages enemies with an increased chance to stun. Requires a Two Handed Axe, Two Handed Mace, or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["groundslam_damage_to_close_targets_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Condition", var = "AtCloseRange" })
		},
		["quality_display_groundslam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 35),
	},
	qualityStats = {
		Default = {
			{ "groundslam_damage_to_close_targets_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_stun_threshold_reduction_+%", 25 },
		{ "ground_slam_angle_+%", 100 },
	},
	stats = {
		"active_skill_base_radius_+",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_groundslam_is_gem",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -30, baseMultiplier = 2.415, damageEffectiveness = 2.415, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 2.541, damageEffectiveness = 2.541, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 2.678, damageEffectiveness = 2.678, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 2.827, damageEffectiveness = 2.827, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 2.989, damageEffectiveness = 2.989, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 3.168, damageEffectiveness = 3.168, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 3.35, damageEffectiveness = 3.35, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 3.543, damageEffectiveness = 3.543, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 3.746, damageEffectiveness = 3.746, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 3.961, damageEffectiveness = 3.961, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 4.189, damageEffectiveness = 4.189, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 4.428, damageEffectiveness = 4.428, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[13] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 4.682, damageEffectiveness = 4.682, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[14] = { 7, attackSpeedMultiplier = -30, baseMultiplier = 4.95, damageEffectiveness = 4.95, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[15] = { 7, attackSpeedMultiplier = -30, baseMultiplier = 5.233, damageEffectiveness = 5.233, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[16] = { 8, attackSpeedMultiplier = -30, baseMultiplier = 5.532, damageEffectiveness = 5.532, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[17] = { 8, attackSpeedMultiplier = -30, baseMultiplier = 5.847, damageEffectiveness = 5.847, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[18] = { 9, attackSpeedMultiplier = -30, baseMultiplier = 6.18, damageEffectiveness = 6.18, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[19] = { 9, attackSpeedMultiplier = -30, baseMultiplier = 6.522, damageEffectiveness = 6.522, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[20] = { 10, attackSpeedMultiplier = -30, baseMultiplier = 6.882, damageEffectiveness = 6.882, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[21] = { 10, attackSpeedMultiplier = -30, baseMultiplier = 7.25, damageEffectiveness = 7.25, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[22] = { 11, attackSpeedMultiplier = -30, baseMultiplier = 7.637, damageEffectiveness = 7.637, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[23] = { 11, attackSpeedMultiplier = -30, baseMultiplier = 8.045, damageEffectiveness = 8.045, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[24] = { 12, attackSpeedMultiplier = -30, baseMultiplier = 8.475, damageEffectiveness = 8.475, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[25] = { 12, attackSpeedMultiplier = -30, baseMultiplier = 8.927, damageEffectiveness = 8.927, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[26] = { 13, attackSpeedMultiplier = -30, baseMultiplier = 9.403, damageEffectiveness = 9.403, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[27] = { 13, attackSpeedMultiplier = -30, baseMultiplier = 9.906, damageEffectiveness = 9.906, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[28] = { 14, attackSpeedMultiplier = -30, baseMultiplier = 10.434, damageEffectiveness = 10.434, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[29] = { 14, attackSpeedMultiplier = -30, baseMultiplier = 10.991, damageEffectiveness = 10.991, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[30] = { 15, attackSpeedMultiplier = -30, baseMultiplier = 11.577, damageEffectiveness = 11.577, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[31] = { 15, attackSpeedMultiplier = -30, baseMultiplier = 12.479, damageEffectiveness = 12.479, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[32] = { 15, attackSpeedMultiplier = -30, baseMultiplier = 12.812, damageEffectiveness = 12.812, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[33] = { 16, attackSpeedMultiplier = -30, baseMultiplier = 13.153, damageEffectiveness = 13.153, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[34] = { 16, attackSpeedMultiplier = -30, baseMultiplier = 13.503, damageEffectiveness = 13.503, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[35] = { 16, attackSpeedMultiplier = -30, baseMultiplier = 13.863, damageEffectiveness = 13.863, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[36] = { 17, attackSpeedMultiplier = -30, baseMultiplier = 14.231, damageEffectiveness = 14.231, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[37] = { 17, attackSpeedMultiplier = -30, baseMultiplier = 14.61, damageEffectiveness = 14.61, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[38] = { 17, attackSpeedMultiplier = -30, baseMultiplier = 14.999, damageEffectiveness = 14.999, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[39] = { 18, attackSpeedMultiplier = -30, baseMultiplier = 15.398, damageEffectiveness = 15.398, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[40] = { 18, attackSpeedMultiplier = -30, baseMultiplier = 15.808, damageEffectiveness = 15.808, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 17, }, },
	},
}
skills["VaalGroundSlam"] = {
	name = "Vaal Ground Slam",
	baseTypeName = "Vaal Ground Slam",
	color = 1,
	baseEffectiveness = 0.6700000166893,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slams the ground in front of you, creating a wave that travels in all directions that damages enemies with an increased chance to stun. The wave deals more damage to closer enemies. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Vaal] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["groundslam_damage_to_close_targets_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Condition", var = "AtCloseRange" })
		},
		["vaal_skill_exertable"] = {
			-- Display only
		},
		["quality_display_groundslam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 39),
	},
	qualityStats = {
		Default = {
			{ "groundslam_damage_to_close_targets_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_stun_duration_+%", 200 },
		{ "base_stun_threshold_reduction_+%", 25 },
	},
	stats = {
		"active_skill_base_radius_+",
		"groundslam_damage_to_close_targets_+%_final",
		"is_area_damage",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
		"vaal_skill_exertable",
		"skill_cannot_be_stunned_before_contact_point",
		"quality_display_groundslam_is_gem",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, 40, attackSpeedMultiplier = -10, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[2] = { 0, 40, attackSpeedMultiplier = -10, baseMultiplier = 2.288, damageEffectiveness = 2.288, levelRequirement = 2, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[3] = { 1, 41, attackSpeedMultiplier = -10, baseMultiplier = 2.395, damageEffectiveness = 2.395, levelRequirement = 4, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[4] = { 1, 41, attackSpeedMultiplier = -10, baseMultiplier = 2.508, damageEffectiveness = 2.508, levelRequirement = 7, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[5] = { 2, 42, attackSpeedMultiplier = -10, baseMultiplier = 2.626, damageEffectiveness = 2.626, levelRequirement = 11, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[6] = { 2, 42, attackSpeedMultiplier = -10, baseMultiplier = 2.749, damageEffectiveness = 2.749, levelRequirement = 16, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[7] = { 3, 43, attackSpeedMultiplier = -10, baseMultiplier = 2.878, damageEffectiveness = 2.878, levelRequirement = 20, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[8] = { 3, 43, attackSpeedMultiplier = -10, baseMultiplier = 3.014, damageEffectiveness = 3.014, levelRequirement = 24, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[9] = { 4, 44, attackSpeedMultiplier = -10, baseMultiplier = 3.155, damageEffectiveness = 3.155, levelRequirement = 28, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[10] = { 4, 44, attackSpeedMultiplier = -10, baseMultiplier = 3.303, damageEffectiveness = 3.303, levelRequirement = 32, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[11] = { 5, 45, attackSpeedMultiplier = -10, baseMultiplier = 3.459, damageEffectiveness = 3.459, levelRequirement = 36, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[12] = { 5, 45, attackSpeedMultiplier = -10, baseMultiplier = 3.621, damageEffectiveness = 3.621, levelRequirement = 40, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[13] = { 6, 46, attackSpeedMultiplier = -10, baseMultiplier = 3.792, damageEffectiveness = 3.792, levelRequirement = 44, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[14] = { 6, 46, attackSpeedMultiplier = -10, baseMultiplier = 3.97, damageEffectiveness = 3.97, levelRequirement = 48, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[15] = { 7, 47, attackSpeedMultiplier = -10, baseMultiplier = 4.156, damageEffectiveness = 4.156, levelRequirement = 52, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[16] = { 7, 47, attackSpeedMultiplier = -10, baseMultiplier = 4.352, damageEffectiveness = 4.352, levelRequirement = 56, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[17] = { 8, 48, attackSpeedMultiplier = -10, baseMultiplier = 4.556, damageEffectiveness = 4.556, levelRequirement = 60, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[18] = { 8, 48, attackSpeedMultiplier = -10, baseMultiplier = 4.77, damageEffectiveness = 4.77, levelRequirement = 64, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[19] = { 9, 49, attackSpeedMultiplier = -10, baseMultiplier = 4.994, damageEffectiveness = 4.994, levelRequirement = 67, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[20] = { 9, 49, attackSpeedMultiplier = -10, baseMultiplier = 5.229, damageEffectiveness = 5.229, levelRequirement = 70, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[21] = { 10, 50, attackSpeedMultiplier = -10, baseMultiplier = 5.475, damageEffectiveness = 5.475, levelRequirement = 72, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[22] = { 10, 50, attackSpeedMultiplier = -10, baseMultiplier = 5.732, damageEffectiveness = 5.732, levelRequirement = 74, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[23] = { 11, 51, attackSpeedMultiplier = -10, baseMultiplier = 6.002, damageEffectiveness = 6.002, levelRequirement = 76, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[24] = { 11, 51, attackSpeedMultiplier = -10, baseMultiplier = 6.284, damageEffectiveness = 6.284, levelRequirement = 78, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[25] = { 12, 52, attackSpeedMultiplier = -10, baseMultiplier = 6.579, damageEffectiveness = 6.579, levelRequirement = 80, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[26] = { 12, 52, attackSpeedMultiplier = -10, baseMultiplier = 6.888, damageEffectiveness = 6.888, levelRequirement = 82, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[27] = { 13, 53, attackSpeedMultiplier = -10, baseMultiplier = 7.212, damageEffectiveness = 7.212, levelRequirement = 84, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[28] = { 13, 53, attackSpeedMultiplier = -10, baseMultiplier = 7.551, damageEffectiveness = 7.551, levelRequirement = 86, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[29] = { 14, 54, attackSpeedMultiplier = -10, baseMultiplier = 7.906, damageEffectiveness = 7.906, levelRequirement = 88, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[30] = { 14, 54, attackSpeedMultiplier = -10, baseMultiplier = 8.278, damageEffectiveness = 8.278, levelRequirement = 90, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[31] = { 14, 54, attackSpeedMultiplier = -10, baseMultiplier = 8.87, damageEffectiveness = 8.87, levelRequirement = 91, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[32] = { 15, 55, attackSpeedMultiplier = -10, baseMultiplier = 9.079, damageEffectiveness = 9.079, levelRequirement = 92, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[33] = { 15, 55, attackSpeedMultiplier = -10, baseMultiplier = 9.292, damageEffectiveness = 9.292, levelRequirement = 93, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[34] = { 15, 55, attackSpeedMultiplier = -10, baseMultiplier = 9.51, damageEffectiveness = 9.51, levelRequirement = 94, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[35] = { 15, 55, attackSpeedMultiplier = -10, baseMultiplier = 9.734, damageEffectiveness = 9.734, levelRequirement = 95, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[36] = { 16, 56, attackSpeedMultiplier = -10, baseMultiplier = 9.963, damageEffectiveness = 9.963, levelRequirement = 96, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[37] = { 16, 56, attackSpeedMultiplier = -10, baseMultiplier = 10.197, damageEffectiveness = 10.197, levelRequirement = 97, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[38] = { 16, 56, attackSpeedMultiplier = -10, baseMultiplier = 10.436, damageEffectiveness = 10.436, levelRequirement = 98, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[39] = { 16, 56, attackSpeedMultiplier = -10, baseMultiplier = 10.682, damageEffectiveness = 10.682, levelRequirement = 99, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
		[40] = { 17, 57, attackSpeedMultiplier = -10, baseMultiplier = 10.933, damageEffectiveness = 10.933, levelRequirement = 100, soulPreventionDuration = 1, vaalStoredUses = 4, statInterpolation = { 1, 1, }, cost = { Soul = 15, }, },
	},
}
skills["HeavyStrike"] = {
	name = "Heavy Strike",
	baseTypeName = "Heavy Strike",
	color = 1,
	baseEffectiveness = 0,
	description = "Attacks enemies with a forceful blow. Requires a Mace, Sceptre, Axe, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["chance_to_deal_double_damage_%"] = {
			mod("DoubleDamageChance", "BASE", nil),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "chance_to_deal_double_damage_%", 1 },
		},
	},
	constantStats = {
		{ "base_stun_threshold_reduction_+%", 25 },
	},
	stats = {
		"chance_to_deal_double_damage_%",
	},
	levels = {
		[1] = { 20, attackSpeedMultiplier = -15, baseMultiplier = 2.243, damageEffectiveness = 2.243, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 21, attackSpeedMultiplier = -15, baseMultiplier = 2.341, damageEffectiveness = 2.341, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 22, attackSpeedMultiplier = -15, baseMultiplier = 2.449, damageEffectiveness = 2.449, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 23, attackSpeedMultiplier = -15, baseMultiplier = 2.565, damageEffectiveness = 2.565, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 24, attackSpeedMultiplier = -15, baseMultiplier = 2.693, damageEffectiveness = 2.693, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 25, attackSpeedMultiplier = -15, baseMultiplier = 2.831, damageEffectiveness = 2.831, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 26, attackSpeedMultiplier = -15, baseMultiplier = 2.971, damageEffectiveness = 2.971, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 27, attackSpeedMultiplier = -15, baseMultiplier = 3.118, damageEffectiveness = 3.118, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 28, attackSpeedMultiplier = -15, baseMultiplier = 3.273, damageEffectiveness = 3.273, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 29, attackSpeedMultiplier = -15, baseMultiplier = 3.433, damageEffectiveness = 3.433, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 30, attackSpeedMultiplier = -15, baseMultiplier = 3.603, damageEffectiveness = 3.603, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 31, attackSpeedMultiplier = -15, baseMultiplier = 3.78, damageEffectiveness = 3.78, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 32, attackSpeedMultiplier = -15, baseMultiplier = 3.966, damageEffectiveness = 3.966, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 33, attackSpeedMultiplier = -15, baseMultiplier = 4.161, damageEffectiveness = 4.161, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[15] = { 34, attackSpeedMultiplier = -15, baseMultiplier = 4.365, damageEffectiveness = 4.365, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[16] = { 35, attackSpeedMultiplier = -15, baseMultiplier = 4.58, damageEffectiveness = 4.58, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 36, attackSpeedMultiplier = -15, baseMultiplier = 4.804, damageEffectiveness = 4.804, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[18] = { 37, attackSpeedMultiplier = -15, baseMultiplier = 5.039, damageEffectiveness = 5.039, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[19] = { 38, attackSpeedMultiplier = -15, baseMultiplier = 5.277, damageEffectiveness = 5.277, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 39, attackSpeedMultiplier = -15, baseMultiplier = 5.525, damageEffectiveness = 5.525, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[21] = { 40, attackSpeedMultiplier = -15, baseMultiplier = 5.777, damageEffectiveness = 5.777, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[22] = { 41, attackSpeedMultiplier = -15, baseMultiplier = 6.04, damageEffectiveness = 6.04, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[23] = { 42, attackSpeedMultiplier = -15, baseMultiplier = 6.313, damageEffectiveness = 6.313, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[24] = { 43, attackSpeedMultiplier = -15, baseMultiplier = 6.6, damageEffectiveness = 6.6, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[25] = { 44, attackSpeedMultiplier = -15, baseMultiplier = 6.899, damageEffectiveness = 6.899, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 45, attackSpeedMultiplier = -15, baseMultiplier = 7.212, damageEffectiveness = 7.212, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[27] = { 46, attackSpeedMultiplier = -15, baseMultiplier = 7.54, damageEffectiveness = 7.54, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[28] = { 47, attackSpeedMultiplier = -15, baseMultiplier = 7.881, damageEffectiveness = 7.881, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[29] = { 48, attackSpeedMultiplier = -15, baseMultiplier = 8.238, damageEffectiveness = 8.238, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[30] = { 49, attackSpeedMultiplier = -15, baseMultiplier = 8.611, damageEffectiveness = 8.611, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[31] = { 49, attackSpeedMultiplier = -15, baseMultiplier = 9.177, damageEffectiveness = 9.177, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[32] = { 50, attackSpeedMultiplier = -15, baseMultiplier = 9.384, damageEffectiveness = 9.384, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 50, attackSpeedMultiplier = -15, baseMultiplier = 9.597, damageEffectiveness = 9.597, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 51, attackSpeedMultiplier = -15, baseMultiplier = 9.814, damageEffectiveness = 9.814, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[35] = { 51, attackSpeedMultiplier = -15, baseMultiplier = 10.036, damageEffectiveness = 10.036, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[36] = { 52, attackSpeedMultiplier = -15, baseMultiplier = 10.262, damageEffectiveness = 10.262, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[37] = { 52, attackSpeedMultiplier = -15, baseMultiplier = 10.494, damageEffectiveness = 10.494, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[38] = { 53, attackSpeedMultiplier = -15, baseMultiplier = 10.732, damageEffectiveness = 10.732, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[39] = { 53, attackSpeedMultiplier = -15, baseMultiplier = 10.974, damageEffectiveness = 10.974, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[40] = { 54, attackSpeedMultiplier = -15, baseMultiplier = 11.222, damageEffectiveness = 11.222, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 14, }, },
	},
}
skills["HeavyStrikeAltY"] = {
	name = "Heavy Strike of Trarthus",
	baseTypeName = "Heavy Strike of Trarthus",
	color = 1,
	baseEffectiveness = 0,
	description = "Attacks enemies with a forceful blow. Requires a Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Staff"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_additive_spell_damage_modifiers_apply_to_attack_damage_at_%_value", 1 },
		},
	},
	constantStats = {
		{ "chance_to_deal_double_damage_%_per_10_intelligence", 2 },
		{ "active_skill_additive_spell_damage_modifiers_apply_to_attack_damage_at_%_value", 150 },
	},
	stats = {
		"quality_display_spell_damage_to_attack_damage_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -15, baseMultiplier = 2.243, damageEffectiveness = 2.243, levelRequirement = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -15, baseMultiplier = 2.341, damageEffectiveness = 2.341, levelRequirement = 2, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -15, baseMultiplier = 2.449, damageEffectiveness = 2.449, levelRequirement = 4, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -15, baseMultiplier = 2.565, damageEffectiveness = 2.565, levelRequirement = 7, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -15, baseMultiplier = 2.693, damageEffectiveness = 2.693, levelRequirement = 11, cost = { Mana = 7, }, },
		[6] = { attackSpeedMultiplier = -15, baseMultiplier = 2.831, damageEffectiveness = 2.831, levelRequirement = 16, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -15, baseMultiplier = 2.971, damageEffectiveness = 2.971, levelRequirement = 20, cost = { Mana = 8, }, },
		[8] = { attackSpeedMultiplier = -15, baseMultiplier = 3.118, damageEffectiveness = 3.118, levelRequirement = 24, cost = { Mana = 8, }, },
		[9] = { attackSpeedMultiplier = -15, baseMultiplier = 3.273, damageEffectiveness = 3.273, levelRequirement = 28, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -15, baseMultiplier = 3.433, damageEffectiveness = 3.433, levelRequirement = 32, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -15, baseMultiplier = 3.603, damageEffectiveness = 3.603, levelRequirement = 36, cost = { Mana = 9, }, },
		[12] = { attackSpeedMultiplier = -15, baseMultiplier = 3.78, damageEffectiveness = 3.78, levelRequirement = 40, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -15, baseMultiplier = 3.966, damageEffectiveness = 3.966, levelRequirement = 44, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -15, baseMultiplier = 4.161, damageEffectiveness = 4.161, levelRequirement = 48, cost = { Mana = 10, }, },
		[15] = { attackSpeedMultiplier = -15, baseMultiplier = 4.365, damageEffectiveness = 4.365, levelRequirement = 52, cost = { Mana = 10, }, },
		[16] = { attackSpeedMultiplier = -15, baseMultiplier = 4.58, damageEffectiveness = 4.58, levelRequirement = 56, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -15, baseMultiplier = 4.804, damageEffectiveness = 4.804, levelRequirement = 60, cost = { Mana = 11, }, },
		[18] = { attackSpeedMultiplier = -15, baseMultiplier = 5.039, damageEffectiveness = 5.039, levelRequirement = 64, cost = { Mana = 11, }, },
		[19] = { attackSpeedMultiplier = -15, baseMultiplier = 5.277, damageEffectiveness = 5.277, levelRequirement = 67, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -15, baseMultiplier = 5.525, damageEffectiveness = 5.525, levelRequirement = 70, cost = { Mana = 12, }, },
		[21] = { attackSpeedMultiplier = -15, baseMultiplier = 5.777, damageEffectiveness = 5.777, levelRequirement = 72, cost = { Mana = 12, }, },
		[22] = { attackSpeedMultiplier = -15, baseMultiplier = 6.04, damageEffectiveness = 6.04, levelRequirement = 74, cost = { Mana = 12, }, },
		[23] = { attackSpeedMultiplier = -15, baseMultiplier = 6.313, damageEffectiveness = 6.313, levelRequirement = 76, cost = { Mana = 12, }, },
		[24] = { attackSpeedMultiplier = -15, baseMultiplier = 6.6, damageEffectiveness = 6.6, levelRequirement = 78, cost = { Mana = 12, }, },
		[25] = { attackSpeedMultiplier = -15, baseMultiplier = 6.899, damageEffectiveness = 6.899, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -15, baseMultiplier = 7.212, damageEffectiveness = 7.212, levelRequirement = 82, cost = { Mana = 13, }, },
		[27] = { attackSpeedMultiplier = -15, baseMultiplier = 7.54, damageEffectiveness = 7.54, levelRequirement = 84, cost = { Mana = 13, }, },
		[28] = { attackSpeedMultiplier = -15, baseMultiplier = 7.881, damageEffectiveness = 7.881, levelRequirement = 86, cost = { Mana = 13, }, },
		[29] = { attackSpeedMultiplier = -15, baseMultiplier = 8.238, damageEffectiveness = 8.238, levelRequirement = 88, cost = { Mana = 13, }, },
		[30] = { attackSpeedMultiplier = -15, baseMultiplier = 8.611, damageEffectiveness = 8.611, levelRequirement = 90, cost = { Mana = 13, }, },
		[31] = { attackSpeedMultiplier = -15, baseMultiplier = 9.177, damageEffectiveness = 9.177, levelRequirement = 91, cost = { Mana = 13, }, },
		[32] = { attackSpeedMultiplier = -15, baseMultiplier = 9.384, damageEffectiveness = 9.384, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -15, baseMultiplier = 9.597, damageEffectiveness = 9.597, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -15, baseMultiplier = 9.814, damageEffectiveness = 9.814, levelRequirement = 94, cost = { Mana = 14, }, },
		[35] = { attackSpeedMultiplier = -15, baseMultiplier = 10.036, damageEffectiveness = 10.036, levelRequirement = 95, cost = { Mana = 14, }, },
		[36] = { attackSpeedMultiplier = -15, baseMultiplier = 10.262, damageEffectiveness = 10.262, levelRequirement = 96, cost = { Mana = 14, }, },
		[37] = { attackSpeedMultiplier = -15, baseMultiplier = 10.494, damageEffectiveness = 10.494, levelRequirement = 97, cost = { Mana = 14, }, },
		[38] = { attackSpeedMultiplier = -15, baseMultiplier = 10.732, damageEffectiveness = 10.732, levelRequirement = 98, cost = { Mana = 14, }, },
		[39] = { attackSpeedMultiplier = -15, baseMultiplier = 10.974, damageEffectiveness = 10.974, levelRequirement = 99, cost = { Mana = 14, }, },
		[40] = { attackSpeedMultiplier = -15, baseMultiplier = 11.222, damageEffectiveness = 11.222, levelRequirement = 100, cost = { Mana = 14, }, },
	},
}
skills["HeraldOfAsh"] = {
	name = "Herald of Ash",
	baseTypeName = "Herald of Ash",
	color = 1,
	baseEffectiveness = 0.5,
	incrementalEffectiveness = 0.032699998468161,
	description = "Grants a buff providing fire damage based on your physical damage. While you have this buff, if you kill an enemy, other enemies near them will be burned based on the overkill damage. The burn inflicted by this skill can only be affected by modifiers to damage over time (burning damage is damage over time).",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.CausesBurning] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Herald] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.FireDot = (activeSkill.skillData.hoaOverkill or 0) * (1 + activeSkill.skillData.hoaMoreBurn / 100) * activeSkill.skillData.hoaOverkillPercent
	end,
	statMap = {
		["physical_damage_%_to_add_as_fire"] = {
			mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" })
		},
		["herald_of_ash_burning_damage_+%_final"] = {
			skill("hoaMoreBurn", nil),
		},
		["herald_of_ash_burning_%_overkill_damage_per_minute"] = {
			skill("hoaOverkillPercent", nil),
			div = 6000,
		},
		["quality_display_herald_of_ash_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
	},
	baseMods = {
		skill("radius", 10),
		flag("dotIsHeraldOfAsh"),
	},
	qualityStats = {
		Default = {
			{ "herald_of_ash_burning_%_overkill_damage_per_minute", 15 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "herald_of_ash_burning_%_overkill_damage_per_minute", 1500 },
	},
	stats = {
		"herald_of_ash_burning_damage_+%_final",
		"physical_damage_%_to_add_as_fire",
		"is_area_damage",
		"quality_display_herald_of_ash_is_gem",
	},
	levels = {
		[1] = { 0, 15, cooldown = 1, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[2] = { 2, 15, cooldown = 1, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[3] = { 4, 15, cooldown = 1, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[4] = { 6, 15, cooldown = 1, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[5] = { 8, 15, cooldown = 1, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[6] = { 10, 16, cooldown = 1, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[7] = { 12, 16, cooldown = 1, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[8] = { 14, 16, cooldown = 1, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[9] = { 16, 17, cooldown = 1, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[10] = { 18, 17, cooldown = 1, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[11] = { 20, 17, cooldown = 1, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[12] = { 22, 18, cooldown = 1, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[13] = { 24, 18, cooldown = 1, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[14] = { 26, 18, cooldown = 1, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[15] = { 28, 19, cooldown = 1, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[16] = { 30, 19, cooldown = 1, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[17] = { 32, 19, cooldown = 1, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[18] = { 34, 20, cooldown = 1, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[19] = { 36, 20, cooldown = 1, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[20] = { 38, 20, cooldown = 1, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[21] = { 40, 21, cooldown = 1, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[22] = { 42, 21, cooldown = 1, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[23] = { 44, 21, cooldown = 1, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[24] = { 46, 22, cooldown = 1, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[25] = { 48, 22, cooldown = 1, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[26] = { 50, 22, cooldown = 1, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[27] = { 52, 23, cooldown = 1, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[28] = { 54, 23, cooldown = 1, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[29] = { 56, 23, cooldown = 1, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[30] = { 58, 24, cooldown = 1, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[31] = { 59, 24, cooldown = 1, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[32] = { 60, 24, cooldown = 1, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[33] = { 61, 24, cooldown = 1, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[34] = { 62, 24, cooldown = 1, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[35] = { 63, 24, cooldown = 1, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[36] = { 64, 25, cooldown = 1, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[37] = { 65, 25, cooldown = 1, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[38] = { 66, 25, cooldown = 1, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[39] = { 67, 25, cooldown = 1, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[40] = { 68, 25, cooldown = 1, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["HeraldOfPurity"] = {
	name = "Herald of Purity",
	baseTypeName = "Herald of Purity",
	color = 1,
	baseEffectiveness = 0.31700000166893,
	incrementalEffectiveness = 0.01799999922514,
	description = "Grants a buff which lets you deal more physical damage. When you kill an enemy while you have this buff, this skill will summon a Sentinel of Purity, or refresh the duration and life of an existing one instead if you have the maximum number of them. The Sentinels of Purity have a single-target melee attack and an area melee attack.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.Herald] = true, [SkillType.Minion] = true, [SkillType.Instant] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.CreatesMinion] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Area] = true, },
	statDescriptionScope = "minion_skill_stat_descriptions",
	castTime = 0,
	minionList = {
		"AxisEliteSoldierHeraldOfLight",
	},
	statMap = {
		["base_number_of_champions_of_light_allowed"] = {
			mod("ActiveSentinelOfPurityLimit", "BASE", nil)
		},
		["herald_of_purity_physical_damage_+%_final"] = {
			mod("PhysicalDamage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_number_of_champions_of_light_allowed", 4 },
		{ "herald_of_light_summon_champion_on_unique_or_rare_enemy_hit_%", 20 },
		{ "base_skill_effect_duration", 12000 },
		{ "display_minion_monster_type", 21 },
	},
	stats = {
		"herald_of_purity_physical_damage_+%_final",
		"active_skill_minion_physical_damage_+%_final",
		"active_skill_minion_life_+%_final",
		"base_display_minion_actor_level",
		"herald_of_light_summon_champion_on_kill",
	},
	notMinionStat = {
		"herald_of_purity_physical_damage_+%_final",
		"active_skill_minion_physical_damage_+%_final",
		"active_skill_minion_life_+%_final",
	},
	levels = {
		[1] = { 9, 0, 0, 16, cooldown = 1, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 9, 5, 2, 20, cooldown = 1, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 9, 10, 4, 24, cooldown = 1, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 9, 15, 6, 28, cooldown = 1, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 9, 20, 8, 31, cooldown = 1, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 10, 25, 10, 34, cooldown = 1, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 10, 30, 12, 37, cooldown = 1, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 10, 35, 14, 40, cooldown = 1, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 10, 40, 16, 43, cooldown = 1, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 10, 45, 18, 46, cooldown = 1, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 11, 50, 20, 49, cooldown = 1, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 11, 55, 22, 52, cooldown = 1, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 11, 60, 24, 55, cooldown = 1, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 11, 65, 26, 58, cooldown = 1, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 11, 70, 28, 60, cooldown = 1, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 12, 75, 30, 62, cooldown = 1, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 12, 80, 32, 64, cooldown = 1, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 12, 85, 34, 66, cooldown = 1, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 12, 90, 36, 68, cooldown = 1, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 12, 95, 38, 70, cooldown = 1, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 13, 100, 40, 72, cooldown = 1, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 13, 105, 42, 74, cooldown = 1, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 13, 110, 44, 76, cooldown = 1, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 13, 115, 46, 78, cooldown = 1, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 13, 120, 48, 80, cooldown = 1, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 14, 125, 50, 82, cooldown = 1, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 14, 130, 52, 84, cooldown = 1, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 14, 135, 54, 86, cooldown = 1, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 14, 140, 56, 88, cooldown = 1, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 14, 145, 58, 90, cooldown = 1, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 14, 147, 60, 91, cooldown = 1, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 15, 150, 62, 92, cooldown = 1, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 15, 152, 64, 93, cooldown = 1, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 15, 155, 66, 94, cooldown = 1, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 15, 157, 68, 95, cooldown = 1, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 15, 160, 70, 96, cooldown = 1, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 15, 162, 72, 97, cooldown = 1, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 15, 165, 74, 98, cooldown = 1, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 15, 167, 76, 99, cooldown = 1, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 15, 170, 78, 100, cooldown = 1, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["HolyFlameTotem"] = {
	name = "Holy Flame Totem",
	baseTypeName = "Holy Flame Totem",
	color = 1,
	baseEffectiveness = 0.74919998645782,
	incrementalEffectiveness = 0.032200001180172,
	description = "Summons a totem that channels to fire a stream of flame at nearby enemies, and creates an area of consecrated ground around the totem.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, [SkillType.Channel] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 17,
	castTime = 0.25,
	baseFlags = {
		spell = true,
		totem = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 16),
	},
	qualityStats = {
		Default = {
			{ "base_projectile_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 100 },
		{ "base_number_of_projectiles", 3 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "ignite_art_variation", 7 },
		{ "active_skill_projectile_speed_+%_variation_final", 30 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_totem",
		"base_skill_is_totemified",
		"base_is_projectile",
		"always_pierce",
		"consecrated_ground_immune_to_curses",
		"visual_hit_effect_elemental_is_holy",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.60000002384186, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 4, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[2] = { 0.60000002384186, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 6, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[3] = { 0.60000002384186, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 9, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 12, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[5] = { 0.69999998807907, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 16, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 20, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 24, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 32, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 36, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 55, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 61, statInterpolation = { 3, 3, }, cost = { Mana = 36, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 37, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 67, statInterpolation = { 3, 3, }, cost = { Mana = 38, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 39, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 40, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 41, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 42, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 43, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 44, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 45, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 46, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 46, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 47, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 48, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 50, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 50, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 51, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 51, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
	},
}
skills["HolyFlameTotemAltX"] = {
	name = "Holy Flame Totem of Ire",
	baseTypeName = "Holy Flame Totem of Ire",
	color = 1,
	baseEffectiveness = 0.74919998645782,
	incrementalEffectiveness = 0.032200001180172,
	description = "Summons a totem that channels to fire a stream of flame at nearby enemies, and creates an area of consecrated ground around the totem.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, [SkillType.Channel] = true, [SkillType.Physical] = true, [SkillType.ProjectilesNotFired] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 17,
	castTime = 0.18,
	baseFlags = {
		spell = true,
		totem = true,
		projectile = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "holy_flame_totem_consecrated_ground_area_+%", 2 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 100 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "ignite_art_variation", 7 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_projectile_speed_+%_final",
		"is_totem",
		"base_skill_is_totemified",
		"base_is_projectile",
		"always_pierce",
		"consecrated_ground_immune_to_curses",
		"visual_hit_effect_elemental_is_holy",
		"quality_display_base_number_of_projectiles_is_gem",
		"modifiers_to_projectile_count_do_not_apply",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.60000002384186, 1.2000000476837, 90, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[2] = { 0.60000002384186, 1.2000000476837, 92, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 6, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[3] = { 0.60000002384186, 1.2000000476837, 94, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 9, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 96, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 12, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[5] = { 0.69999998807907, 1.2000000476837, 98, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 100, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 102, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 104, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 106, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 108, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 110, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 112, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 114, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 116, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 32, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 118, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 55, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 120, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 58, statInterpolation = { 3, 3, 1, }, cost = { Mana = 34, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 122, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 61, statInterpolation = { 3, 3, 1, }, cost = { Mana = 36, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 124, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 37, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 126, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { Mana = 38, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 128, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 39, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 130, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 40, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 132, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 41, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 134, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 42, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 136, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 43, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 138, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 44, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 140, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 45, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 142, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 46, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 144, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 46, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 146, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 47, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 148, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 48, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 149, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 49, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 150, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 49, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 151, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 49, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 152, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 50, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 153, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 50, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 154, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 51, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 155, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 51, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 156, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 52, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 157, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 52, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 158, critChance = 5, damageEffectiveness = 0.35, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 52, }, },
	},
}
skills["IceCrash"] = {
	name = "Ice Crash",
	baseTypeName = "Ice Crash",
	color = 1,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slam the ground, damaging enemies in an area around the impact in three stages of increasing size. Enemies take slightly less damage on the second and third stage, and can only be hit by one stage. Works with Swords, Maces, Sceptres, Axes, Staves and Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "First Hit",
		},
		{
			name = "Second Hit",
		},
		{
			name = "Third Hit",
		},
	},
	statMap = {
		["ice_crash_second_hit_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["ice_crash_third_hit_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 3 }),
		},
		["quality_display_ice_crash_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "First hit:"),
		skill("radiusSecondaryLabel", "Second hit:"),
		skill("radiusTertiaryLabel", "Third hit:"),
	},
	qualityStats = {
		Default = {
			{ "physical_damage_%_to_add_as_cold", 0.75 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "ice_crash_second_hit_damage_+%_final", -15 },
		{ "ice_crash_third_hit_damage_+%_final", -30 },
		{ "active_skill_base_area_of_effect_radius", 11 },
		{ "active_skill_base_secondary_area_of_effect_radius", 21 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 31 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_ice_crash_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 3.329, damageEffectiveness = 3.329, levelRequirement = 28, cost = { Mana = 10, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 3.443, damageEffectiveness = 3.443, levelRequirement = 31, cost = { Mana = 11, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 3.561, damageEffectiveness = 3.561, levelRequirement = 34, cost = { Mana = 11, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 3.682, damageEffectiveness = 3.682, levelRequirement = 37, cost = { Mana = 11, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 3.807, damageEffectiveness = 3.807, levelRequirement = 40, cost = { Mana = 12, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 3.93, damageEffectiveness = 3.93, levelRequirement = 42, cost = { Mana = 12, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 4.056, damageEffectiveness = 4.056, levelRequirement = 44, cost = { Mana = 12, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 4.187, damageEffectiveness = 4.187, levelRequirement = 46, cost = { Mana = 12, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 4.322, damageEffectiveness = 4.322, levelRequirement = 48, cost = { Mana = 12, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 4.46, damageEffectiveness = 4.46, levelRequirement = 50, cost = { Mana = 13, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 4.604, damageEffectiveness = 4.604, levelRequirement = 52, cost = { Mana = 13, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 4.751, damageEffectiveness = 4.751, levelRequirement = 54, cost = { Mana = 13, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 4.904, damageEffectiveness = 4.904, levelRequirement = 56, cost = { Mana = 13, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 5.062, damageEffectiveness = 5.062, levelRequirement = 58, cost = { Mana = 13, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 5.224, damageEffectiveness = 5.224, levelRequirement = 60, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 5.392, damageEffectiveness = 5.392, levelRequirement = 62, cost = { Mana = 14, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 5.565, damageEffectiveness = 5.565, levelRequirement = 64, cost = { Mana = 14, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 5.742, damageEffectiveness = 5.742, levelRequirement = 66, cost = { Mana = 14, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 5.927, damageEffectiveness = 5.927, levelRequirement = 68, cost = { Mana = 14, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 6.116, damageEffectiveness = 6.116, levelRequirement = 70, cost = { Mana = 14, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 6.313, damageEffectiveness = 6.313, levelRequirement = 72, cost = { Mana = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 6.515, damageEffectiveness = 6.515, levelRequirement = 74, cost = { Mana = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 6.723, damageEffectiveness = 6.723, levelRequirement = 76, cost = { Mana = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 6.938, damageEffectiveness = 6.938, levelRequirement = 78, cost = { Mana = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 7.16, damageEffectiveness = 7.16, levelRequirement = 80, cost = { Mana = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 7.389, damageEffectiveness = 7.389, levelRequirement = 82, cost = { Mana = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 7.625, damageEffectiveness = 7.625, levelRequirement = 84, cost = { Mana = 16, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 7.869, damageEffectiveness = 7.869, levelRequirement = 86, cost = { Mana = 16, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 8.12, damageEffectiveness = 8.12, levelRequirement = 88, cost = { Mana = 16, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 8.38, damageEffectiveness = 8.38, levelRequirement = 90, cost = { Mana = 16, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 8.757, damageEffectiveness = 8.757, levelRequirement = 91, cost = { Mana = 16, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 8.896, damageEffectiveness = 8.896, levelRequirement = 92, cost = { Mana = 16, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 9.039, damageEffectiveness = 9.039, levelRequirement = 93, cost = { Mana = 16, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 9.182, damageEffectiveness = 9.182, levelRequirement = 94, cost = { Mana = 17, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 9.328, damageEffectiveness = 9.328, levelRequirement = 95, cost = { Mana = 17, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 9.477, damageEffectiveness = 9.477, levelRequirement = 96, cost = { Mana = 17, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 9.628, damageEffectiveness = 9.628, levelRequirement = 97, cost = { Mana = 17, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 9.781, damageEffectiveness = 9.781, levelRequirement = 98, cost = { Mana = 17, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 9.937, damageEffectiveness = 9.937, levelRequirement = 99, cost = { Mana = 17, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 10.095, damageEffectiveness = 10.095, levelRequirement = 100, cost = { Mana = 17, }, },
	},
}
skills["IceCrashAltX"] = {
	name = "Ice Crash of Cadence",
	baseTypeName = "Ice Crash of Cadence",
	color = 1,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.023299999535084,
	description = "Slam the ground, damaging enemies in an area. Slams with main hand weapon deal more damage. Slams with off hand weapon have larger area of effect. Requires dual-wielding Swords, Maces, Sceptres, or Axes to use.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.DualWieldOnly] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "physical_damage_%_to_add_as_cold", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "active_skill_main_hand_weapon_damage_+%_final", 80 },
		{ "active_skill_base_area_of_effect_radius", 11 },
		{ "active_skill_base_secondary_area_of_effect_radius", 31 },
		{ "active_skill_area_of_effect_description_mode", 3 },
		{ "active_skill_secondary_area_of_effect_description_mode", 3 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_ice_crash_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 2.498, damageEffectiveness = 2.498, levelRequirement = 28, cost = { Mana = 7, }, },
		[2] = { baseMultiplier = 2.583, damageEffectiveness = 2.583, levelRequirement = 31, cost = { Mana = 7, }, },
		[3] = { baseMultiplier = 2.671, damageEffectiveness = 2.671, levelRequirement = 34, cost = { Mana = 8, }, },
		[4] = { baseMultiplier = 2.761, damageEffectiveness = 2.761, levelRequirement = 37, cost = { Mana = 8, }, },
		[5] = { baseMultiplier = 2.855, damageEffectiveness = 2.855, levelRequirement = 40, cost = { Mana = 8, }, },
		[6] = { baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 42, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 3.042, damageEffectiveness = 3.042, levelRequirement = 44, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 3.14, damageEffectiveness = 3.14, levelRequirement = 46, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 3.241, damageEffectiveness = 3.241, levelRequirement = 48, cost = { Mana = 9, }, },
		[10] = { baseMultiplier = 3.345, damageEffectiveness = 3.345, levelRequirement = 50, cost = { Mana = 9, }, },
		[11] = { baseMultiplier = 3.453, damageEffectiveness = 3.453, levelRequirement = 52, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 3.563, damageEffectiveness = 3.563, levelRequirement = 54, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 3.678, damageEffectiveness = 3.678, levelRequirement = 56, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 3.796, damageEffectiveness = 3.796, levelRequirement = 58, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 3.918, damageEffectiveness = 3.918, levelRequirement = 60, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 4.044, damageEffectiveness = 4.044, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 4.174, damageEffectiveness = 4.174, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 4.307, damageEffectiveness = 4.307, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 4.587, damageEffectiveness = 4.587, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 4.735, damageEffectiveness = 4.735, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 4.886, damageEffectiveness = 4.886, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 5.042, damageEffectiveness = 5.042, levelRequirement = 76, cost = { Mana = 11, }, },
		[24] = { baseMultiplier = 5.204, damageEffectiveness = 5.204, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 5.37, damageEffectiveness = 5.37, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 5.542, damageEffectiveness = 5.542, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 5.719, damageEffectiveness = 5.719, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 5.902, damageEffectiveness = 5.902, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 6.09, damageEffectiveness = 6.09, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 6.284, damageEffectiveness = 6.284, levelRequirement = 90, cost = { Mana = 12, }, },
		[31] = { baseMultiplier = 6.567, damageEffectiveness = 6.567, levelRequirement = 91, cost = { Mana = 12, }, },
		[32] = { baseMultiplier = 6.672, damageEffectiveness = 6.672, levelRequirement = 92, cost = { Mana = 12, }, },
		[33] = { baseMultiplier = 6.779, damageEffectiveness = 6.779, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 6.887, damageEffectiveness = 6.887, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 6.996, damageEffectiveness = 6.996, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 7.107, damageEffectiveness = 7.107, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 7.221, damageEffectiveness = 7.221, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 7.336, damageEffectiveness = 7.336, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 7.453, damageEffectiveness = 7.453, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 7.571, damageEffectiveness = 7.571, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["ImmortalCall"] = {
	name = "Immortal Call",
	baseTypeName = "Immortal Call",
	color = 1,
	baseEffectiveness = 0,
	description = "Take less Physical and Elemental Damage for a short time. Consumes up to 5 Endurance Charges to lengthen the buff and further lessen Physical Damage taken. Shares a cooldown with other Guard skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.Guard] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["mortal_call_elemental_damage_taken_+%_final"] = {
			mod("ElementalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
		},
		["mortal_call_physical_damage_taken_+%_final"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
		},
		["mortal_call_physical_damage_taken_per_endurance_charge_consumed_final_permyriad"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }, { type = "Multiplier", var = "RemovableEnduranceCharge", limit = 5 }),
			div = 100,
		},
		["quality_display_immortal_call_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "mortal_call_physical_damage_taken_per_endurance_charge_consumed_final_permyriad", -1500 },
		{ "buff_effect_duration_+%_per_removable_endurance_charge_limited_to_5", 20 },
		{ "base_skill_effect_duration", 1000 },
	},
	stats = {
		"mortal_call_elemental_damage_taken_+%_final",
		"mortal_call_physical_damage_taken_+%_final",
		"base_deal_no_damage",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"quality_display_immortal_call_is_gem",
	},
	levels = {
		[1] = { -25, -25, cooldown = 3, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[2] = { -25, -26, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[3] = { -26, -26, cooldown = 3, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[4] = { -26, -27, cooldown = 3, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[5] = { -27, -27, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[6] = { -27, -28, cooldown = 3, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[7] = { -28, -28, cooldown = 3, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[8] = { -28, -29, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 27, }, },
		[9] = { -29, -29, cooldown = 3, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 28, }, },
		[10] = { -29, -30, cooldown = 3, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 29, }, },
		[11] = { -30, -30, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 30, }, },
		[12] = { -30, -31, cooldown = 3, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 31, }, },
		[13] = { -31, -31, cooldown = 3, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 31, }, },
		[14] = { -31, -32, cooldown = 3, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[15] = { -32, -32, cooldown = 3, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 33, }, },
		[16] = { -32, -33, cooldown = 3, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[17] = { -33, -33, cooldown = 3, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 35, }, },
		[18] = { -33, -34, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[19] = { -34, -34, cooldown = 3, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[20] = { -34, -35, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[21] = { -35, -35, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 37, }, },
		[22] = { -35, -36, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 38, }, },
		[23] = { -36, -36, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[24] = { -36, -37, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[25] = { -37, -37, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[26] = { -37, -38, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[27] = { -38, -38, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[28] = { -38, -39, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 43, }, },
		[29] = { -39, -39, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
		[30] = { -39, -40, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 45, }, },
		[31] = { -39, -40, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 45, }, },
		[32] = { -40, -40, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[33] = { -40, -40, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[34] = { -40, -41, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[35] = { -40, -41, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[36] = { -41, -41, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 47, }, },
		[37] = { -41, -41, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 47, }, },
		[38] = { -41, -42, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[39] = { -41, -42, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[40] = { -42, -42, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 49, }, },
	},
}
skills["VaalImmortalCall"] = {
	name = "Vaal Immortal Call",
	baseTypeName = "Vaal Immortal Call",
	color = 1,
	baseEffectiveness = 0,
	description = "Discharges Endurance Charges, making the character unable to die or gain Vaal souls for a short time, proportional to how many endurance charges were expended.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Vaal] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		flag("Condition:CannotDie", { type = "GlobalEffect", effectType = "Guard" }),
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 400 },
	},
	stats = {
		"buff_effect_duration_+%_per_removable_endurance_charge",
		"immortal_call_prevent_all_damage",
		"base_deal_no_damage",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"display_skill_fixed_duration_buff",
	},
	levels = {
		[1] = { 100, cooldown = 60, levelRequirement = 34, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[2] = { 103, cooldown = 60, levelRequirement = 36, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[3] = { 106, cooldown = 60, levelRequirement = 38, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[4] = { 109, cooldown = 60, levelRequirement = 40, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[5] = { 112, cooldown = 60, levelRequirement = 42, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[6] = { 115, cooldown = 60, levelRequirement = 44, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[7] = { 118, cooldown = 60, levelRequirement = 46, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[8] = { 121, cooldown = 60, levelRequirement = 48, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[9] = { 124, cooldown = 60, levelRequirement = 50, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[10] = { 127, cooldown = 60, levelRequirement = 52, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[11] = { 130, cooldown = 60, levelRequirement = 54, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[12] = { 133, cooldown = 60, levelRequirement = 56, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[13] = { 136, cooldown = 60, levelRequirement = 58, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[14] = { 139, cooldown = 60, levelRequirement = 60, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[15] = { 142, cooldown = 60, levelRequirement = 62, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[16] = { 145, cooldown = 60, levelRequirement = 64, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[17] = { 148, cooldown = 60, levelRequirement = 66, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[18] = { 151, cooldown = 60, levelRequirement = 68, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[19] = { 154, cooldown = 60, levelRequirement = 69, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[20] = { 157, cooldown = 60, levelRequirement = 70, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[21] = { 160, cooldown = 60, levelRequirement = 72, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[22] = { 163, cooldown = 60, levelRequirement = 74, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[23] = { 166, cooldown = 60, levelRequirement = 76, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[24] = { 169, cooldown = 60, levelRequirement = 78, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[25] = { 172, cooldown = 60, levelRequirement = 80, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[26] = { 175, cooldown = 60, levelRequirement = 82, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[27] = { 178, cooldown = 60, levelRequirement = 84, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[28] = { 181, cooldown = 60, levelRequirement = 86, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[29] = { 184, cooldown = 60, levelRequirement = 88, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[30] = { 187, cooldown = 60, levelRequirement = 90, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[31] = { 189, cooldown = 60, levelRequirement = 91, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[32] = { 190, cooldown = 60, levelRequirement = 92, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[33] = { 192, cooldown = 60, levelRequirement = 93, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[34] = { 193, cooldown = 60, levelRequirement = 94, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[35] = { 195, cooldown = 60, levelRequirement = 95, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[36] = { 196, cooldown = 60, levelRequirement = 96, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[37] = { 198, cooldown = 60, levelRequirement = 97, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[38] = { 199, cooldown = 60, levelRequirement = 98, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[39] = { 201, cooldown = 60, levelRequirement = 99, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
		[40] = { 202, cooldown = 60, levelRequirement = 100, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 100, }, },
	},
}
skills["InfernalCry"] = {
	name = "Infernal Cry",
	baseTypeName = "Infernal Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. The user and nearby allies gain a buff that grants a portion of their physical damage as extra fire damage. In addition to being taunted, enemies are inflicted with a secondary debuff causing them to explode when they die, dealing fire damage in an area.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Fire] = true, [SkillType.Damage] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "secondary_debuff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("InfernalExertedAttacks", "BASE", nil),
		},
		["infernal_cry_physical_damage_%_to_add_as_fire_per_5_power_up_to_cap"] = {
			mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
		},
		["infernal_cry_empowered_attacks_trigger_combust_display"] = {
			-- Display only
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
		skill("radiusLabel", "Warcry area:"),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "infernal_cry_%_max_life_as_fire_on_death", 8 },
		{ "infernal_cry_physical_damage_%_to_add_as_fire_per_5_power_up_to_cap", 5 },
		{ "skill_empowers_next_x_melee_attacks", 6 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"damage_cannot_be_reflected",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"infernal_cry_empowered_attacks_trigger_combust_display",
	},
	notMinionStat = {
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, 2500, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 2, 2500, 2500, cooldown = 8, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 2600, 2600, cooldown = 8, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, 2600, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, 2700, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 10, 2700, 2700, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 12, 2800, 2800, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, 2800, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, 2900, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 18, 2900, 2900, cooldown = 8, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 20, 3000, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, 3000, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, 3100, cooldown = 8, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 26, 3100, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["Combust"] = {
	name = "Combust",
	baseTypeName = "Combust",
	color = 1,
	description = "Deals attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Melee] = true, [SkillType.InbuiltTrigger] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["triggered_by_infernal_cry"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
		Default = {
			{ "dummy_stat_display_nothing", 0 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
	},
	stats = {
		"is_area_damage",
		"triggered_by_infernal_cry",
	},
	levels = {
		[1] = { baseMultiplier = 1.369, damageEffectiveness = 1.369, levelRequirement = 24, },
		[2] = { baseMultiplier = 1.409, damageEffectiveness = 1.409, levelRequirement = 27, },
		[3] = { baseMultiplier = 1.449, damageEffectiveness = 1.449, levelRequirement = 30, },
		[4] = { baseMultiplier = 1.491, damageEffectiveness = 1.491, levelRequirement = 33, },
		[5] = { baseMultiplier = 1.533, damageEffectiveness = 1.533, levelRequirement = 36, },
		[6] = { baseMultiplier = 1.577, damageEffectiveness = 1.577, levelRequirement = 39, },
		[7] = { baseMultiplier = 1.622, damageEffectiveness = 1.622, levelRequirement = 42, },
		[8] = { baseMultiplier = 1.669, damageEffectiveness = 1.669, levelRequirement = 45, },
		[9] = { baseMultiplier = 1.717, damageEffectiveness = 1.717, levelRequirement = 48, },
		[10] = { baseMultiplier = 1.766, damageEffectiveness = 1.766, levelRequirement = 50, },
		[11] = { baseMultiplier = 1.817, damageEffectiveness = 1.817, levelRequirement = 52, },
		[12] = { baseMultiplier = 1.869, damageEffectiveness = 1.869, levelRequirement = 54, },
		[13] = { baseMultiplier = 1.922, damageEffectiveness = 1.922, levelRequirement = 56, },
		[14] = { baseMultiplier = 1.977, damageEffectiveness = 1.977, levelRequirement = 58, },
		[15] = { baseMultiplier = 2.034, damageEffectiveness = 2.034, levelRequirement = 60, },
		[16] = { baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 62, },
		[17] = { baseMultiplier = 2.152, damageEffectiveness = 2.152, levelRequirement = 64, },
		[18] = { baseMultiplier = 2.214, damageEffectiveness = 2.214, levelRequirement = 66, },
		[19] = { baseMultiplier = 2.277, damageEffectiveness = 2.277, levelRequirement = 68, },
		[20] = { baseMultiplier = 2.342, damageEffectiveness = 2.342, levelRequirement = 70, },
		[21] = { baseMultiplier = 2.409, damageEffectiveness = 2.409, levelRequirement = 72, },
		[22] = { baseMultiplier = 2.478, damageEffectiveness = 2.478, levelRequirement = 74, },
		[23] = { baseMultiplier = 2.549, damageEffectiveness = 2.549, levelRequirement = 76, },
		[24] = { baseMultiplier = 2.622, damageEffectiveness = 2.622, levelRequirement = 78, },
		[25] = { baseMultiplier = 2.698, damageEffectiveness = 2.698, levelRequirement = 80, },
		[26] = { baseMultiplier = 2.775, damageEffectiveness = 2.775, levelRequirement = 82, },
		[27] = { baseMultiplier = 2.854, damageEffectiveness = 2.854, levelRequirement = 84, },
		[28] = { baseMultiplier = 2.936, damageEffectiveness = 2.936, levelRequirement = 86, },
		[29] = { baseMultiplier = 3.02, damageEffectiveness = 3.02, levelRequirement = 88, },
		[30] = { baseMultiplier = 3.107, damageEffectiveness = 3.107, levelRequirement = 90, },
		[31] = { baseMultiplier = 3.242, damageEffectiveness = 3.242, levelRequirement = 91, },
		[32] = { baseMultiplier = 3.288, damageEffectiveness = 3.288, levelRequirement = 92, },
		[33] = { baseMultiplier = 3.335, damageEffectiveness = 3.335, levelRequirement = 93, },
		[34] = { baseMultiplier = 3.383, damageEffectiveness = 3.383, levelRequirement = 94, },
		[35] = { baseMultiplier = 3.431, damageEffectiveness = 3.431, levelRequirement = 95, },
		[36] = { baseMultiplier = 3.481, damageEffectiveness = 3.481, levelRequirement = 96, },
		[37] = { baseMultiplier = 3.53, damageEffectiveness = 3.53, levelRequirement = 97, },
		[38] = { baseMultiplier = 3.581, damageEffectiveness = 3.581, levelRequirement = 98, },
		[39] = { baseMultiplier = 3.632, damageEffectiveness = 3.632, levelRequirement = 99, },
		[40] = { baseMultiplier = 3.684, damageEffectiveness = 3.684, levelRequirement = 100, },
	},
}
skills["InfernalBlow"] = {
	name = "Infernal Blow",
	baseTypeName = "Infernal Blow",
	color = 1,
	description = "Attacks with your weapon, applying a charged debuff to enemies hit by your strike, and an uncharged debuff to any other enemies hit. Upon reaching 6 charges, expiring, or the enemy's death, the charged debuff is removed to damage that and other surrounding enemies. Enemies with either debuff explode when they die, damaging other surrounding enemies. Damage from this explosion cannot be reflected. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		local effect = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "DebuffEffect")
		if activeSkill.skillPart == 2 or activeSkill.skillPart == 3 then
			activeSkill.skillModList:NewMod("Damage", "MORE", effect, "Skill:InfernalBlow", 0, { type = "Multiplier", var = "DebuffStack", base = -100 + effect })
		end
		if activeSkill.skillPart == 3 then
			activeSkill.skillData.dpsMultiplier = 1 / 6
		end
	end,
	parts = {
		{
			name = "Melee Hit",
			area = false
		},
		{
			name = "Debuff Explosion - 1 Stack",
			area = true
		},
		{
			name = "Debuff Explosion - 6 Stacks",
			area = true
		},
	},
	statMap = {
		["infernal_blow_explosion_damage_%_of_total_per_stack"] = {
			mod("DebuffEffect", "BASE", nil)
		},
		["quality_display_infernal_blow_is_gem"] = {
			-- Display Only
		},
		["active_skill_base_area_of_effect_radius"] = {
			skill("radius", nil, { type = "SkillPart", skillPart = 1 }),
		},
		["active_skill_base_secondary_area_of_effect_radius"] = {
			skill("radius", nil, { type = "SkillPart", skillPartList = { 2, 3 } }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:DebuffStack", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 3 }),
		skill("radiusLabel", "Hit area:", { type = "SkillPart", skillPart = 1 }),
		skill("radiusLabel", "Explosion area:", { type = "SkillPart", skillPartList = { 2, 3 } }),
	},
	qualityStats = {
		Default = {
			{ "infernal_blow_explosion_damage_%_of_total_per_stack", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "base_skill_effect_duration", 800 },
		{ "corpse_explosion_monster_life_%", 6 },
		{ "infernal_blow_explosion_damage_%_of_total_per_stack", 66 },
		{ "active_skill_base_area_of_effect_radius", 24 },
		{ "active_skill_base_secondary_area_of_effect_radius", 18 },
		{ "active_skill_secondary_area_of_effect_description_mode", 1 },
	},
	stats = {
		"quality_display_infernal_blow_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 1.643, damageEffectiveness = 1.643, levelRequirement = 12, cost = { Mana = 6, }, },
		[2] = { baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 15, cost = { Mana = 6, }, },
		[3] = { baseMultiplier = 1.797, damageEffectiveness = 1.797, levelRequirement = 19, cost = { Mana = 7, }, },
		[4] = { baseMultiplier = 1.881, damageEffectiveness = 1.881, levelRequirement = 23, cost = { Mana = 7, }, },
		[5] = { baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 27, cost = { Mana = 7, }, },
		[6] = { baseMultiplier = 2.06, damageEffectiveness = 2.06, levelRequirement = 31, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 2.156, damageEffectiveness = 2.156, levelRequirement = 35, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 2.252, damageEffectiveness = 2.252, levelRequirement = 38, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 2.353, damageEffectiveness = 2.353, levelRequirement = 41, cost = { Mana = 8, }, },
		[10] = { baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 44, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 2.567, damageEffectiveness = 2.567, levelRequirement = 47, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 2.682, damageEffectiveness = 2.682, levelRequirement = 50, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 2.802, damageEffectiveness = 2.802, levelRequirement = 53, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 2.926, damageEffectiveness = 2.926, levelRequirement = 56, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 3.057, damageEffectiveness = 3.057, levelRequirement = 59, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 3.193, damageEffectiveness = 3.193, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 3.33, damageEffectiveness = 3.33, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 3.472, damageEffectiveness = 3.472, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 3.774, damageEffectiveness = 3.774, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 3.935, damageEffectiveness = 3.935, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 4.103, damageEffectiveness = 4.103, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 4.278, damageEffectiveness = 4.278, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 4.46, damageEffectiveness = 4.46, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 4.651, damageEffectiveness = 4.651, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 4.849, damageEffectiveness = 4.849, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 5.056, damageEffectiveness = 5.056, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 5.271, damageEffectiveness = 5.271, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 5.496, damageEffectiveness = 5.496, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 5.729, damageEffectiveness = 5.729, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 6.081, damageEffectiveness = 6.081, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 6.21, damageEffectiveness = 6.21, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 6.342, damageEffectiveness = 6.342, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 6.477, damageEffectiveness = 6.477, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 6.615, damageEffectiveness = 6.615, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 6.755, damageEffectiveness = 6.755, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 6.898, damageEffectiveness = 6.898, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 7.045, damageEffectiveness = 7.045, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 7.194, damageEffectiveness = 7.194, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 7.347, damageEffectiveness = 7.347, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["InfernalBlowAltX"] = {
	name = "Infernal Blow of Immolation",
	baseTypeName = "Infernal Blow of Immolation",
	color = 1,
	description = "Attacks with your weapon, applying a charged debuff to you the first time you hit an enemy with this skill. Upon reaching 6 charges, or charges expiring, the charged debuff is removed to damage nearby enemies. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		local effect = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "DebuffEffect")
		if activeSkill.skillPart == 2 or activeSkill.skillPart == 3 then
			activeSkill.skillModList:NewMod("Damage", "MORE", effect, "Skill:InfernalBlowAltX", 0, { type = "Multiplier", var = "DebuffStack", base = -100 + effect })
		end
		if activeSkill.skillPart == 3 then
			activeSkill.skillData.dpsMultiplier = 1 / 6
		end
	end,
	parts = {
		{
			name = "Melee Hit",
			area = false
		},
		{
			name = "Debuff Explosion - 1 Stack",
			area = true
		},
		{
			name = "Debuff Explosion - 6 Stacks",
			area = true
		},
	},
	statMap = {
		["infernal_blow_explosion_damage_%_of_total_per_stack"] = {
			mod("DebuffEffect", "BASE", nil)
		},
		["quality_display_infernal_blow_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:DebuffStack", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		Default = {
			{ "infernal_blow_explosion_damage_%_of_total_per_stack", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "base_skill_effect_duration", 3000 },
		{ "infernal_blow_explosion_damage_%_of_total_per_stack", 80 },
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"quality_display_infernal_blow_is_gem",
	},
	levels = {
		[1] = { 2, baseMultiplier = 1.643, damageEffectiveness = 1.643, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 2, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 2, baseMultiplier = 1.797, damageEffectiveness = 1.797, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 2, baseMultiplier = 1.881, damageEffectiveness = 1.881, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 2, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 3, baseMultiplier = 2.06, damageEffectiveness = 2.06, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 3, baseMultiplier = 2.156, damageEffectiveness = 2.156, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 3, baseMultiplier = 2.252, damageEffectiveness = 2.252, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 3, baseMultiplier = 2.353, damageEffectiveness = 2.353, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 3, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 4, baseMultiplier = 2.567, damageEffectiveness = 2.567, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 4, baseMultiplier = 2.682, damageEffectiveness = 2.682, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 4, baseMultiplier = 2.802, damageEffectiveness = 2.802, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 4, baseMultiplier = 2.926, damageEffectiveness = 2.926, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 4, baseMultiplier = 3.057, damageEffectiveness = 3.057, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 5, baseMultiplier = 3.193, damageEffectiveness = 3.193, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 5, baseMultiplier = 3.33, damageEffectiveness = 3.33, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 5, baseMultiplier = 3.472, damageEffectiveness = 3.472, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 5, baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 5, baseMultiplier = 3.774, damageEffectiveness = 3.774, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 6, baseMultiplier = 3.935, damageEffectiveness = 3.935, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 6, baseMultiplier = 4.103, damageEffectiveness = 4.103, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 6, baseMultiplier = 4.278, damageEffectiveness = 4.278, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 6, baseMultiplier = 4.46, damageEffectiveness = 4.46, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 6, baseMultiplier = 4.651, damageEffectiveness = 4.651, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 7, baseMultiplier = 4.849, damageEffectiveness = 4.849, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 7, baseMultiplier = 5.056, damageEffectiveness = 5.056, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 7, baseMultiplier = 5.271, damageEffectiveness = 5.271, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 7, baseMultiplier = 5.496, damageEffectiveness = 5.496, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 7, baseMultiplier = 5.729, damageEffectiveness = 5.729, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 7, baseMultiplier = 6.081, damageEffectiveness = 6.081, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 8, baseMultiplier = 6.21, damageEffectiveness = 6.21, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 8, baseMultiplier = 6.342, damageEffectiveness = 6.342, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 8, baseMultiplier = 6.477, damageEffectiveness = 6.477, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 8, baseMultiplier = 6.615, damageEffectiveness = 6.615, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 8, baseMultiplier = 6.755, damageEffectiveness = 6.755, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 8, baseMultiplier = 6.898, damageEffectiveness = 6.898, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 8, baseMultiplier = 7.045, damageEffectiveness = 7.045, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 8, baseMultiplier = 7.194, damageEffectiveness = 7.194, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 8, baseMultiplier = 7.347, damageEffectiveness = 7.347, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["IntimidatingCry"] = {
	name = "Intimidating Cry",
	baseTypeName = "Intimidating Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. The user and nearby allies gain a buff that grants movement speed.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("IntimidatingExertedAttacks", "BASE", nil),
		},
		["intimidating_cry_movement_speed_+%_per_5_power_up_to_cap"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 30 }),
		},
		["intimidating_cry_empowerd_attacks_deal_double_damage_display"] = {
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "intimidating_cry_movement_speed_+%_per_5_power_up_to_cap", 3 },
		{ "skill_empowers_next_x_melee_attacks", 2 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"intimidating_cry_empowerd_attacks_deal_double_damage_display",
		"enemies_taunted_by_your_warcies_are_intimidated",
		"use_intimidating_cry_buff_visual_for_intimidate",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 57, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 63, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["LeapSlam"] = {
	name = "Leap Slam",
	baseTypeName = "Leap Slam",
	color = 1,
	baseEffectiveness = 0,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "stun_duration_+%_vs_enemies_that_are_on_full_life", 2 },
		},
	},
	constantStats = {
		{ "additional_weapon_base_attack_time_ms", 550 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"stun_duration_+%_vs_enemies_that_are_on_full_life",
		"is_area_damage",
		"always_stun_enemies_that_are_on_full_life",
		"leap_slam_always_knockback_within_range",
	},
	levels = {
		[1] = { 20, baseMultiplier = 1.364, damageEffectiveness = 1.364, levelRequirement = 10, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 21, baseMultiplier = 1.425, damageEffectiveness = 1.425, levelRequirement = 13, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 22, baseMultiplier = 1.492, damageEffectiveness = 1.492, levelRequirement = 17, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 23, baseMultiplier = 1.562, damageEffectiveness = 1.562, levelRequirement = 21, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 24, baseMultiplier = 1.634, damageEffectiveness = 1.634, levelRequirement = 25, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 25, baseMultiplier = 1.71, damageEffectiveness = 1.71, levelRequirement = 29, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[7] = { 26, baseMultiplier = 1.79, damageEffectiveness = 1.79, levelRequirement = 33, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 27, baseMultiplier = 1.871, damageEffectiveness = 1.871, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 28, baseMultiplier = 1.954, damageEffectiveness = 1.954, levelRequirement = 39, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 29, baseMultiplier = 2.041, damageEffectiveness = 2.041, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 30, baseMultiplier = 2.133, damageEffectiveness = 2.133, levelRequirement = 45, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[12] = { 31, baseMultiplier = 2.227, damageEffectiveness = 2.227, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 32, baseMultiplier = 2.327, damageEffectiveness = 2.327, levelRequirement = 51, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 33, baseMultiplier = 2.431, damageEffectiveness = 2.431, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 34, baseMultiplier = 2.538, damageEffectiveness = 2.538, levelRequirement = 57, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 35, baseMultiplier = 2.652, damageEffectiveness = 2.652, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[17] = { 36, baseMultiplier = 2.77, damageEffectiveness = 2.77, levelRequirement = 63, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 37, baseMultiplier = 2.892, damageEffectiveness = 2.892, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 38, baseMultiplier = 3.017, damageEffectiveness = 3.017, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 39, baseMultiplier = 3.145, damageEffectiveness = 3.145, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 40, baseMultiplier = 3.28, damageEffectiveness = 3.28, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 41, baseMultiplier = 3.419, damageEffectiveness = 3.419, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 42, baseMultiplier = 3.565, damageEffectiveness = 3.565, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 43, baseMultiplier = 3.718, damageEffectiveness = 3.718, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 44, baseMultiplier = 3.875, damageEffectiveness = 3.875, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 45, baseMultiplier = 4.041, damageEffectiveness = 4.041, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 46, baseMultiplier = 4.213, damageEffectiveness = 4.213, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 47, baseMultiplier = 4.393, damageEffectiveness = 4.393, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 48, baseMultiplier = 4.58, damageEffectiveness = 4.58, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 49, baseMultiplier = 4.775, damageEffectiveness = 4.775, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 50, baseMultiplier = 5.067, damageEffectiveness = 5.067, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 50, baseMultiplier = 5.175, damageEffectiveness = 5.175, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 51, baseMultiplier = 5.285, damageEffectiveness = 5.285, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 51, baseMultiplier = 5.397, damageEffectiveness = 5.397, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 52, baseMultiplier = 5.513, damageEffectiveness = 5.513, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 52, baseMultiplier = 5.629, damageEffectiveness = 5.629, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 53, baseMultiplier = 5.749, damageEffectiveness = 5.749, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 53, baseMultiplier = 5.871, damageEffectiveness = 5.871, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 54, baseMultiplier = 5.995, damageEffectiveness = 5.995, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 54, baseMultiplier = 6.123, damageEffectiveness = 6.123, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["LeapSlamAltX"] = {
	name = "Leap Slam of Groundbreaking",
	baseTypeName = "Leap Slam of Groundbreaking",
	color = 1,
	baseEffectiveness = 0,
	description = "Jump a short distance through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "stun_duration_+%_vs_enemies_that_are_on_full_life", 2 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 25 },
	},
	stats = {
		"stun_duration_+%_vs_enemies_that_are_on_full_life",
		"is_area_damage",
		"always_stun_enemies_that_are_on_full_life",
		"leap_slam_always_knockback_within_range",
	},
	levels = {
		[1] = { 20, attackSpeedMultiplier = -30, baseMultiplier = 2.864, damageEffectiveness = 2.864, levelRequirement = 10, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 21, attackSpeedMultiplier = -30, baseMultiplier = 2.993, damageEffectiveness = 2.993, levelRequirement = 13, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 22, attackSpeedMultiplier = -30, baseMultiplier = 3.133, damageEffectiveness = 3.133, levelRequirement = 17, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[4] = { 23, attackSpeedMultiplier = -30, baseMultiplier = 3.279, damageEffectiveness = 3.279, levelRequirement = 21, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 24, attackSpeedMultiplier = -30, baseMultiplier = 3.433, damageEffectiveness = 3.433, levelRequirement = 25, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 25, attackSpeedMultiplier = -30, baseMultiplier = 3.593, damageEffectiveness = 3.593, levelRequirement = 29, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[7] = { 26, attackSpeedMultiplier = -30, baseMultiplier = 3.76, damageEffectiveness = 3.76, levelRequirement = 33, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[8] = { 27, attackSpeedMultiplier = -30, baseMultiplier = 3.928, damageEffectiveness = 3.928, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 28, attackSpeedMultiplier = -30, baseMultiplier = 4.104, damageEffectiveness = 4.104, levelRequirement = 39, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 29, attackSpeedMultiplier = -30, baseMultiplier = 4.287, damageEffectiveness = 4.287, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[11] = { 30, attackSpeedMultiplier = -30, baseMultiplier = 4.478, damageEffectiveness = 4.478, levelRequirement = 45, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[12] = { 31, attackSpeedMultiplier = -30, baseMultiplier = 4.678, damageEffectiveness = 4.678, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[13] = { 32, attackSpeedMultiplier = -30, baseMultiplier = 4.887, damageEffectiveness = 4.887, levelRequirement = 51, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[14] = { 33, attackSpeedMultiplier = -30, baseMultiplier = 5.104, damageEffectiveness = 5.104, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[15] = { 34, attackSpeedMultiplier = -30, baseMultiplier = 5.331, damageEffectiveness = 5.331, levelRequirement = 57, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[16] = { 35, attackSpeedMultiplier = -30, baseMultiplier = 5.569, damageEffectiveness = 5.569, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[17] = { 36, attackSpeedMultiplier = -30, baseMultiplier = 5.817, damageEffectiveness = 5.817, levelRequirement = 63, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[18] = { 37, attackSpeedMultiplier = -30, baseMultiplier = 6.075, damageEffectiveness = 6.075, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[19] = { 38, attackSpeedMultiplier = -30, baseMultiplier = 6.335, damageEffectiveness = 6.335, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[20] = { 39, attackSpeedMultiplier = -30, baseMultiplier = 6.605, damageEffectiveness = 6.605, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[21] = { 40, attackSpeedMultiplier = -30, baseMultiplier = 6.887, damageEffectiveness = 6.887, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[22] = { 41, attackSpeedMultiplier = -30, baseMultiplier = 7.18, damageEffectiveness = 7.18, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[23] = { 42, attackSpeedMultiplier = -30, baseMultiplier = 7.486, damageEffectiveness = 7.486, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[24] = { 43, attackSpeedMultiplier = -30, baseMultiplier = 7.806, damageEffectiveness = 7.806, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[25] = { 44, attackSpeedMultiplier = -30, baseMultiplier = 8.139, damageEffectiveness = 8.139, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[26] = { 45, attackSpeedMultiplier = -30, baseMultiplier = 8.486, damageEffectiveness = 8.486, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[27] = { 46, attackSpeedMultiplier = -30, baseMultiplier = 8.848, damageEffectiveness = 8.848, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[28] = { 47, attackSpeedMultiplier = -30, baseMultiplier = 9.224, damageEffectiveness = 9.224, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[29] = { 48, attackSpeedMultiplier = -30, baseMultiplier = 9.617, damageEffectiveness = 9.617, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[30] = { 49, attackSpeedMultiplier = -30, baseMultiplier = 10.026, damageEffectiveness = 10.026, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[31] = { 50, attackSpeedMultiplier = -30, baseMultiplier = 10.642, damageEffectiveness = 10.642, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[32] = { 50, attackSpeedMultiplier = -30, baseMultiplier = 10.868, damageEffectiveness = 10.868, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[33] = { 51, attackSpeedMultiplier = -30, baseMultiplier = 11.099, damageEffectiveness = 11.099, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[34] = { 51, attackSpeedMultiplier = -30, baseMultiplier = 11.335, damageEffectiveness = 11.335, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[35] = { 52, attackSpeedMultiplier = -30, baseMultiplier = 11.576, damageEffectiveness = 11.576, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[36] = { 52, attackSpeedMultiplier = -30, baseMultiplier = 11.821, damageEffectiveness = 11.821, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[37] = { 53, attackSpeedMultiplier = -30, baseMultiplier = 12.073, damageEffectiveness = 12.073, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[38] = { 53, attackSpeedMultiplier = -30, baseMultiplier = 12.329, damageEffectiveness = 12.329, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[39] = { 54, attackSpeedMultiplier = -30, baseMultiplier = 12.59, damageEffectiveness = 12.59, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[40] = { 54, attackSpeedMultiplier = -30, baseMultiplier = 12.858, damageEffectiveness = 12.858, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 17, }, },
	},
}
skills["MoltenShell"] = {
	name = "Molten Shell",
	baseTypeName = "Molten Shell",
	color = 1,
	baseEffectiveness = 9.6499996185303,
	incrementalEffectiveness = 0.016499999910593,
	description = "Applies a buff that adds to your armour, and can take some of the damage from hits for you before being depleted. When the buff expires or is depleted, the skill deals reflected damage to enemies around you based on the total damage that was taken from the buff. Shares a cooldown with other Guard skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsWhenNotDetached] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Triggerable] = true, [SkillType.Guard] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	preDamageFunc = function(activeSkill, output)
		local add = (activeSkill.skillData.MoltenShellDamageMitigated or 0) * activeSkill.skillData.moltenShellReflect / 100
		activeSkill.skillData.FireMin = add
		activeSkill.skillData.FireMax = add
	end,
	statMap = {
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
		},
		["molten_shell_damage_absorbed_%"] = {
			mod("GuardAbsorbRate", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["molten_shell_damage_absorb_limit_%_of_armour"] = {
			mod("GuardAbsorbLimit", "BASE", nil, 0, 0, { type = "PerStat", stat = "Armour", limitVar = "GuardAbsorbMax", limitTotal = true }, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
			div = 100,
		},
		["molten_shell_max_damage_absorbed"] = {
			mod("Multiplier:GuardAbsorbMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["molten_shell_%_of_absorbed_damage_dealt_as_reflected_fire"] = {
			skill("moltenShellReflect", nil),
		},
	},
	baseFlags = {
		hit = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "skill_override_pvp_scaling_time_ms", 200 },
		{ "molten_shell_damage_absorbed_%", 75 },
		{ "molten_shell_damage_absorb_limit_%_of_armour", 10 },
		{ "molten_shell_max_damage_absorbed", 5000 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"base_physical_damage_reduction_rating",
		"molten_shell_%_of_absorbed_damage_dealt_as_reflected_fire",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"damage_originates_from_initiator_location",
	},
	levels = {
		[1] = { 1, 100, cooldown = 4, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[2] = { 1, 130, cooldown = 4, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[3] = { 1, 180, cooldown = 4, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[4] = { 1, 250, cooldown = 4, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[5] = { 1, 330, cooldown = 4, levelRequirement = 31, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[6] = { 1, 420, cooldown = 4, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[7] = { 1, 530, cooldown = 4, levelRequirement = 37, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[8] = { 1, 650, cooldown = 4, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[9] = { 1, 780, cooldown = 4, levelRequirement = 43, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[10] = { 1, 920, cooldown = 4, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[11] = { 1, 1080, cooldown = 4, levelRequirement = 49, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[12] = { 1, 1250, cooldown = 4, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[13] = { 1, 1430, cooldown = 4, levelRequirement = 55, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[14] = { 1, 1620, cooldown = 4, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[15] = { 1, 1820, cooldown = 4, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[16] = { 1, 2040, cooldown = 4, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[17] = { 1, 2260, cooldown = 4, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[18] = { 1, 2500, cooldown = 4, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[19] = { 1, 2740, cooldown = 4, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[20] = { 1, 3000, cooldown = 4, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[21] = { 1, 3270, cooldown = 4, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[22] = { 1, 3550, cooldown = 4, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[23] = { 1, 3830, cooldown = 4, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[24] = { 1, 4130, cooldown = 4, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[25] = { 1, 4440, cooldown = 4, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[26] = { 1, 4760, cooldown = 4, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[27] = { 1, 5090, cooldown = 4, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[28] = { 1, 5430, cooldown = 4, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[29] = { 1, 5770, cooldown = 4, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[30] = { 1, 6130, cooldown = 4, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[31] = { 1, 6500, cooldown = 4, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[32] = { 1, 6880, cooldown = 4, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[33] = { 1, 7260, cooldown = 4, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 16, }, },
		[34] = { 1, 7660, cooldown = 4, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 16, }, },
		[35] = { 1, 8060, cooldown = 4, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 16, }, },
		[36] = { 1, 8480, cooldown = 4, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 16, }, },
		[37] = { 1, 8900, cooldown = 4, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 17, }, },
		[38] = { 1, 9340, cooldown = 4, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 17, }, },
		[39] = { 1, 9780, cooldown = 4, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 17, }, },
		[40] = { 1, 10230, cooldown = 4, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, 1, }, cost = { Mana = 17, }, },
	},
}
skills["VaalMoltenShell"] = {
	name = "Vaal Molten Shell",
	baseTypeName = "Vaal Molten Shell",
	color = 1,
	baseEffectiveness = 9.6499996185303,
	incrementalEffectiveness = 0.016499999910593,
	description = "Applies a buff that raises your armour, and takes some of the damage from hits for you before being depleted. Each second, the skill deals reflected damage to surrounding enemies based on the damage taken by the buff in that second. When the buff is removed, the skill deals reflected damage to enemies around you based on the total damage that was taken by the buff. You cannot have the buff at the same time as any other Guard skill.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsWhenNotDetached] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Vaal] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.Cooldown] = true, [SkillType.Guard] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	preDamageFunc = function(activeSkill, output)
		local add = (activeSkill.skillData.VaalMoltenShellDamageMitigated or 0) * activeSkill.skillData.moltenShellReflect / 100
		activeSkill.skillData.FireMin = add
		activeSkill.skillData.FireMax = add
	end,
	statMap = {
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
		},
		["molten_shell_damage_absorbed_%"] = {
			mod("GuardAbsorbRate", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["molten_shell_damage_absorb_limit_%_of_armour"] = {
			mod("GuardAbsorbLimit", "BASE", nil, 0, 0, { type = "PerStat", stat = "Armour", limitVar = "GuardAbsorbMax", limitTotal = true }, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
			div = 100,
		},
		["molten_shell_max_damage_absorbed"] = {
			mod("Multiplier:GuardAbsorbMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["molten_shell_%_of_absorbed_damage_dealt_as_reflected_fire"] = {
			skill("moltenShellReflect", nil),
		},
	},
	baseFlags = {
		hit = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "skill_override_pvp_scaling_time_ms", 1400 },
		{ "molten_shell_damage_absorb_limit_%_of_armour", 20 },
		{ "molten_shell_max_damage_absorbed", 10000 },
		{ "base_skill_effect_duration", 9000 },
	},
	stats = {
		"base_physical_damage_reduction_rating",
		"molten_shell_damage_absorbed_%",
		"molten_shell_%_of_absorbed_damage_dealt_as_reflected_fire",
		"base_skill_show_average_damage_instead_of_dps",
		"molten_shell_explode_each_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"display_vaal_molten_shell_alternate_description",
		"damage_originates_from_initiator_location",
	},
	levels = {
		[1] = { 1, 35, 300, cooldown = 0.5, levelRequirement = 16, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 1, 35, 390, cooldown = 0.5, levelRequirement = 20, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 1, 35, 540, cooldown = 0.5, levelRequirement = 24, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 1, 35, 750, cooldown = 0.5, levelRequirement = 28, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 1, 36, 990, cooldown = 0.5, levelRequirement = 31, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 1, 36, 1260, cooldown = 0.5, levelRequirement = 34, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 1, 36, 1590, cooldown = 0.5, levelRequirement = 37, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 1, 36, 1950, cooldown = 0.5, levelRequirement = 40, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 1, 37, 2340, cooldown = 0.5, levelRequirement = 43, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 1, 37, 2760, cooldown = 0.5, levelRequirement = 46, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 1, 37, 3240, cooldown = 0.5, levelRequirement = 49, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 1, 37, 3750, cooldown = 0.5, levelRequirement = 52, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 1, 38, 4290, cooldown = 0.5, levelRequirement = 55, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 1, 38, 4860, cooldown = 0.5, levelRequirement = 58, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 1, 38, 5460, cooldown = 0.5, levelRequirement = 60, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 1, 38, 6120, cooldown = 0.5, levelRequirement = 62, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 1, 39, 6780, cooldown = 0.5, levelRequirement = 64, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 1, 39, 7500, cooldown = 0.5, levelRequirement = 66, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 1, 39, 8220, cooldown = 0.5, levelRequirement = 68, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 1, 39, 9000, cooldown = 0.5, levelRequirement = 70, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 1, 40, 9810, cooldown = 0.5, levelRequirement = 72, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 1, 40, 10650, cooldown = 0.5, levelRequirement = 74, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 1, 40, 11490, cooldown = 0.5, levelRequirement = 76, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 1, 40, 12390, cooldown = 0.5, levelRequirement = 78, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 1, 41, 13320, cooldown = 0.5, levelRequirement = 80, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 1, 41, 14280, cooldown = 0.5, levelRequirement = 82, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 1, 41, 15270, cooldown = 0.5, levelRequirement = 84, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 1, 41, 16290, cooldown = 0.5, levelRequirement = 86, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 1, 42, 17310, cooldown = 0.5, levelRequirement = 88, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 1, 42, 18390, cooldown = 0.5, levelRequirement = 90, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 1, 42, 19500, cooldown = 0.5, levelRequirement = 91, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 1, 42, 20640, cooldown = 0.5, levelRequirement = 92, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 1, 42, 21780, cooldown = 0.5, levelRequirement = 93, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 1, 42, 22980, cooldown = 0.5, levelRequirement = 94, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 1, 42, 24180, cooldown = 0.5, levelRequirement = 95, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 1, 43, 25440, cooldown = 0.5, levelRequirement = 96, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 1, 43, 26700, cooldown = 0.5, levelRequirement = 97, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 1, 43, 28020, cooldown = 0.5, levelRequirement = 98, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 1, 43, 29340, cooldown = 0.5, levelRequirement = 99, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 1, 43, 30690, cooldown = 0.5, levelRequirement = 100, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 3, 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["MoltenStrike"] = {
	name = "Molten Strike",
	baseTypeName = "Molten Strike",
	color = 1,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will deal area attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			melee = true,
			projectile = false,
			area = false,
		},
		{
			name = "Magma Balls",
			melee = false,
			projectile = true,
			area = true,
		},
		{
			name = "Average Balls Hitting",
			melee = false,
			projectile = true,
			area = true,
		},
	},
	preDamageFunc = function(activeSkill, output, breakdown)
		local skillCfg = activeSkill.skillCfg
		local skillData = activeSkill.skillData
		local skillPart = activeSkill.skillPart
		local skillModList = activeSkill.skillModList
		local t_insert = table.insert
		local s_format = string.format

		-- melee part doesn't need to calc balls
		if skillPart == 1 then
			return
		end

		local enemyRadius = skillModList:Override(skillCfg, "EnemyRadius") or skillModList:Sum("BASE", skillCfg, "EnemyRadius")
		local ballRadius = output.AreaOfEffectRadius
		local innerRadius = output.AreaOfEffectRadiusSecondary
		local outerRadius = output.AreaOfEffectRadiusTertiary

		-- logic adapted from MoldyDwarf's calculator
		local hitRange = enemyRadius + ballRadius - innerRadius
		local landingRange = outerRadius - innerRadius
		local overlapChance = math.min(1, hitRange / landingRange)
		output.OverlapChance = overlapChance * 100

		if breakdown then
			breakdown.OverlapChance = { }
			t_insert(breakdown.OverlapChance, "Chance for individual balls to land on the enemy:")
			t_insert(breakdown.OverlapChance, "^8= (area where a ball can land on enemy) / (total area)")
			t_insert(breakdown.OverlapChance, "^8= (enemy radius + ball radius - min travel) / (max travel - min travel)")
			t_insert(breakdown.OverlapChance, s_format("^8= (^7%d^8 + ^7%d^8 - ^7%d) / (^7%d^8 - ^7%d)",
				enemyRadius, ballRadius, innerRadius, outerRadius, innerRadius))
			t_insert(breakdown.OverlapChance, s_format("^8=^7 %.2f^8%%", output.OverlapChance))
		end

		local numProjectiles = skillModList:Sum("BASE", skillCfg, "ProjectileCount")
		local dpsMult = 1
		if skillPart == 3 or skillPart == 5 or skillPart == 6 then
			dpsMult = overlapChance * numProjectiles

			if skillPart ~= 6 then
				if breakdown then
					breakdown.SkillDPSMultiplier = {}
					t_insert(breakdown.SkillDPSMultiplier, "DPS multiplier")
					t_insert(breakdown.SkillDPSMultiplier, "^8= number of projectiles * overlap chance")
					t_insert(breakdown.SkillDPSMultiplier, s_format("^8=^7 %d^8 *^7 %.3f^8", numProjectiles, overlapChance))
					t_insert(breakdown.SkillDPSMultiplier, s_format("^8=^7 %.3f", dpsMult))
				end
			else
				-- zenith: make an effective dpsMult for the weighted average of normal and 5th attack balls
				local gemQuality = activeSkill.activeEffect.quality
				local fifthAttackMulti = 1 + 8 + 0.1 * gemQuality
				local fifthAttackOverallMulti = fifthAttackMulti * overlapChance * (numProjectiles + 5)
				dpsMult = 0.8 * dpsMult + 0.2 * fifthAttackOverallMulti

				if breakdown then
					breakdown.SkillDPSMultiplier = {}
					t_insert(breakdown.SkillDPSMultiplier, "Weighted average DPS multiplier for balls")
					t_insert(breakdown.SkillDPSMultiplier, "^8= (0.8 * balls dps) + (0.2 * 5th attack balls dps)")
					t_insert(breakdown.SkillDPSMultiplier, "^8= (0.8 * normal ball hit * overlap chance * number of projectiles) " ..
						"+ (0.2 * ball hit * 5th attack multiplier * overlap chance * (number of projectiles + 5))")
					t_insert(breakdown.SkillDPSMultiplier, "^8= ball hit * overlap chance * (0.8 * number of projectiles " ..
						"+ 0.2 * 5th attack multiplier * (number of projectiles + 5))")
					t_insert(breakdown.SkillDPSMultiplier, s_format("^8= ball hit * ^7%.3f ^8* (0.8 * ^7%d ^8+ 0.2 * ^7%.1f ^8* ^7%d^8)",
						overlapChance, numProjectiles, fifthAttackMulti, numProjectiles + 5))
					t_insert(breakdown.SkillDPSMultiplier, s_format("^8= ball hit * ^7 %.3f", dpsMult))
				end
			end
		end
		if dpsMult ~= 1 then
			skillData.dpsMultiplier = (skillData.dpsMultiplier or 1) * dpsMult
			output.SkillDPSMultiplier = (output.SkillDPSMultiplier or 1) * dpsMult
		end
	end,
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPartList = { 2, 3 } })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("projectileSpeedAppliesToMSAreaOfEffect", true),
		skill("radius", 9, { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("radiusLabel", "Ball area:", { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("radiusSecondary", 2, { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("radiusSecondaryLabel", "Chain Minimum Distance:", { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("radiusTertiary", 25, { type = "SkillPart", skillPartList = { 2, 3 } }),
		skill("radiusTertiaryLabel", "Chain Maximum Distance:", { type = "SkillPart", skillPartList = { 2, 3 } }),
		flag("CannotSplit"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_hit_ailment_damage_with_projectile_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "base_number_of_projectiles", 4 },
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -60 },
	},
	stats = {
		"show_number_of_projectiles",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 1, cost = { Mana = 6, }, },
		[2] = { baseMultiplier = 1.324, damageEffectiveness = 1.324, levelRequirement = 2, cost = { Mana = 6, }, },
		[3] = { baseMultiplier = 1.389, damageEffectiveness = 1.389, levelRequirement = 4, cost = { Mana = 6, }, },
		[4] = { baseMultiplier = 1.46, damageEffectiveness = 1.46, levelRequirement = 7, cost = { Mana = 6, }, },
		[5] = { baseMultiplier = 1.537, damageEffectiveness = 1.537, levelRequirement = 11, cost = { Mana = 6, }, },
		[6] = { baseMultiplier = 1.62, damageEffectiveness = 1.62, levelRequirement = 16, cost = { Mana = 7, }, },
		[7] = { baseMultiplier = 1.705, damageEffectiveness = 1.705, levelRequirement = 20, cost = { Mana = 7, }, },
		[8] = { baseMultiplier = 1.794, damageEffectiveness = 1.794, levelRequirement = 24, cost = { Mana = 7, }, },
		[9] = { baseMultiplier = 1.889, damageEffectiveness = 1.889, levelRequirement = 28, cost = { Mana = 7, }, },
		[10] = { baseMultiplier = 1.988, damageEffectiveness = 1.988, levelRequirement = 32, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 36, cost = { Mana = 8, }, },
		[12] = { baseMultiplier = 2.201, damageEffectiveness = 2.201, levelRequirement = 40, cost = { Mana = 8, }, },
		[13] = { baseMultiplier = 2.316, damageEffectiveness = 2.316, levelRequirement = 44, cost = { Mana = 8, }, },
		[14] = { baseMultiplier = 2.437, damageEffectiveness = 2.437, levelRequirement = 48, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 2.564, damageEffectiveness = 2.564, levelRequirement = 52, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 2.697, damageEffectiveness = 2.697, levelRequirement = 56, cost = { Mana = 9, }, },
		[17] = { baseMultiplier = 2.837, damageEffectiveness = 2.837, levelRequirement = 60, cost = { Mana = 9, }, },
		[18] = { baseMultiplier = 2.985, damageEffectiveness = 2.985, levelRequirement = 64, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 3.135, damageEffectiveness = 3.135, levelRequirement = 67, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 3.292, damageEffectiveness = 3.292, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 3.452, damageEffectiveness = 3.452, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 3.794, damageEffectiveness = 3.794, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 3.977, damageEffectiveness = 3.977, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 4.17, damageEffectiveness = 4.17, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 4.372, damageEffectiveness = 4.372, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 4.583, damageEffectiveness = 4.583, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 4.805, damageEffectiveness = 4.805, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 5.037, damageEffectiveness = 5.037, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 5.281, damageEffectiveness = 5.281, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 5.651, damageEffectiveness = 5.651, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 5.787, damageEffectiveness = 5.787, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 5.927, damageEffectiveness = 5.927, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 6.07, damageEffectiveness = 6.07, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 6.216, damageEffectiveness = 6.216, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 6.367, damageEffectiveness = 6.367, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 6.519, damageEffectiveness = 6.519, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 6.677, damageEffectiveness = 6.677, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 6.837, damageEffectiveness = 6.837, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 7.003, damageEffectiveness = 7.003, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["MoltenStrikeAltX"] = {
	name = "Molten Strike of the Zenith",
	baseTypeName = "Molten Strike of the Zenith",
	color = 1,
	description = "Infuses your two-handed melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will deal area attack damage to enemies where they land. Every fifth time you attack with this skill it fires more, high-damage projectiles.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			melee = true,
			projectile = false,
			area = false,
		},
		{
			name = "Magma Balls",
			melee = false,
			projectile = true,
			area = true,
		},
		{
			name = "Average Balls Hitting",
			melee = false,
			projectile = true,
			area = true,
		},
		{
			name = "Magma Balls (5th attack)",
			melee = false,
			projectile = true,
			area = true,
		},
		{
			name = "Average Balls (5th attack)",
			melee = false,
			projectile = true,
			area = true,
		},
		{
			name = "Total Weighted Ball Average",
			melee = false,
			projectile = true,
			area = true,
		},
	},
	preDamageFunc = skills.MoltenStrike.preDamageFunc,
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } })
		},
		["molten_strike_every_5th_attack_projectiles_damage_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPartList = { 4, 5 } })
		},
		["molten_strike_every_5th_attack_fire_X_additional_projectiles"] = {
			mod("ProjectileCount", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 4, 5 } })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("projectileSpeedAppliesToMSAreaOfEffect", true),
		skill("radius", 9, { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		skill("radiusLabel", "Ball area:", { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		skill("radiusSecondary", 2, { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		skill("radiusSecondaryLabel", "Chain Minimum Distance:", { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		skill("radiusTertiary", 25, { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		skill("radiusTertiaryLabel", "Chain Maximum Distance:", { type = "SkillPart", skillPartList = { 2, 3, 4, 5, 6 } }),
		flag("CannotSplit"),
	},
	qualityStats = {
		Default = {
			{ "molten_strike_every_5th_attack_projectiles_damage_+%_final", 10 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "base_number_of_projectiles", 3 },
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -60 },
		{ "molten_strike_every_5th_attack_fire_X_additional_projectiles", 5 },
		{ "molten_strike_every_5th_attack_projectiles_damage_+%_final", 600 },
	},
	stats = {
		"show_number_of_projectiles",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 0.963, damageEffectiveness = 0.963, levelRequirement = 2, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 1.011, damageEffectiveness = 1.011, levelRequirement = 4, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 1.062, damageEffectiveness = 1.062, levelRequirement = 7, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 1.117, damageEffectiveness = 1.117, levelRequirement = 11, cost = { Mana = 8, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 1.178, damageEffectiveness = 1.178, levelRequirement = 16, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 1.24, damageEffectiveness = 1.24, levelRequirement = 20, cost = { Mana = 9, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 1.305, damageEffectiveness = 1.305, levelRequirement = 24, cost = { Mana = 9, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 1.373, damageEffectiveness = 1.373, levelRequirement = 28, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 1.445, damageEffectiveness = 1.445, levelRequirement = 32, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 1.522, damageEffectiveness = 1.522, levelRequirement = 36, cost = { Mana = 10, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 1.601, damageEffectiveness = 1.601, levelRequirement = 40, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 1.684, damageEffectiveness = 1.684, levelRequirement = 44, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 1.772, damageEffectiveness = 1.772, levelRequirement = 48, cost = { Mana = 11, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 1.865, damageEffectiveness = 1.865, levelRequirement = 52, cost = { Mana = 11, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 1.961, damageEffectiveness = 1.961, levelRequirement = 56, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 60, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 2.171, damageEffectiveness = 2.171, levelRequirement = 64, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 2.28, damageEffectiveness = 2.28, levelRequirement = 67, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 2.394, damageEffectiveness = 2.394, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 2.51, damageEffectiveness = 2.51, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 2.632, damageEffectiveness = 2.632, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 2.759, damageEffectiveness = 2.759, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 2.893, damageEffectiveness = 2.893, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 3.033, damageEffectiveness = 3.033, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 3.179, damageEffectiveness = 3.179, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 3.333, damageEffectiveness = 3.333, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 3.494, damageEffectiveness = 3.494, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 3.663, damageEffectiveness = 3.663, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 3.84, damageEffectiveness = 3.84, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 4.11, damageEffectiveness = 4.11, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 4.208, damageEffectiveness = 4.208, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 4.311, damageEffectiveness = 4.311, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 4.414, damageEffectiveness = 4.414, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 4.521, damageEffectiveness = 4.521, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 4.63, damageEffectiveness = 4.63, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 4.741, damageEffectiveness = 4.741, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 4.856, damageEffectiveness = 4.856, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 4.973, damageEffectiveness = 4.973, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 5.092, damageEffectiveness = 5.092, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["VaalMoltenStrike"] = {
	name = "Vaal Molten Strike",
	baseTypeName = "Vaal Molten Strike",
	color = 1,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth causing area attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Chains] = true, [SkillType.Vaal] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			melee = true,
			projectile = false,
			area = false,
			chaining = false,
		},
		{
			name = "Magma Balls",
			melee = false,
			projectile = true,
			area = true,
			chaining = true,
		},
	},
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		area = true,
		chaining = true,
	},
	baseMods = {
		skill("projectileSpeedAppliesToMSAreaOfEffect", true),
		skill("radius", 9, { type = "SkillPart", skillPart = 2 }),
		skill("radiusLabel", "Ball area:", { type = "SkillPart", skillPart = 2 }),
		skill("radiusSecondary", 2, { type = "SkillPart", skillPart = 2 }),
		skill("radiusSecondaryLabel", "Chain Minimum Distance:", { type = "SkillPart", skillPart = 2 }),
		skill("radiusTertiary", 25, { type = "SkillPart", skillPart = 2 }),
		skill("radiusTertiaryLabel", "Chain Maximum Distance:", { type = "SkillPart", skillPart = 2 }),
		flag("CannotSplit"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_hit_ailment_damage_with_projectile_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "base_number_of_projectiles", 9 },
		{ "number_of_chains", 8 },
		{ "active_skill_projectile_speed_+%_variation_final", 20 },
		{ "active_skill_base_radius_+", 4 },
	},
	stats = {
		"show_number_of_projectiles",
		"molten_strike_projectiles_chain_when_impacting_ground",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
		"quality_display_base_number_of_projectiles_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 0.863, damageEffectiveness = 0.863, levelRequirement = 1, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 0.901, damageEffectiveness = 0.901, levelRequirement = 2, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 0.942, damageEffectiveness = 0.942, levelRequirement = 4, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 0.984, damageEffectiveness = 0.984, levelRequirement = 7, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 1.029, damageEffectiveness = 1.029, levelRequirement = 11, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 1.075, damageEffectiveness = 1.075, levelRequirement = 16, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 1.123, damageEffectiveness = 1.123, levelRequirement = 20, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 1.174, damageEffectiveness = 1.174, levelRequirement = 24, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 1.227, damageEffectiveness = 1.227, levelRequirement = 28, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 1.282, damageEffectiveness = 1.282, levelRequirement = 32, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 1.339, damageEffectiveness = 1.339, levelRequirement = 36, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 1.4, damageEffectiveness = 1.4, levelRequirement = 40, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 1.463, damageEffectiveness = 1.463, levelRequirement = 44, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 1.529, damageEffectiveness = 1.529, levelRequirement = 48, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 1.597, damageEffectiveness = 1.597, levelRequirement = 52, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 1.669, damageEffectiveness = 1.669, levelRequirement = 56, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 1.744, damageEffectiveness = 1.744, levelRequirement = 60, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 1.823, damageEffectiveness = 1.823, levelRequirement = 64, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 1.905, damageEffectiveness = 1.905, levelRequirement = 67, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 1.991, damageEffectiveness = 1.991, levelRequirement = 70, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 2.08, damageEffectiveness = 2.08, levelRequirement = 72, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 2.174, damageEffectiveness = 2.174, levelRequirement = 74, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 2.272, damageEffectiveness = 2.272, levelRequirement = 76, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 2.374, damageEffectiveness = 2.374, levelRequirement = 78, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 2.481, damageEffectiveness = 2.481, levelRequirement = 80, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 2.592, damageEffectiveness = 2.592, levelRequirement = 82, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 2.709, damageEffectiveness = 2.709, levelRequirement = 84, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 2.831, damageEffectiveness = 2.831, levelRequirement = 86, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 2.958, damageEffectiveness = 2.958, levelRequirement = 88, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 3.091, damageEffectiveness = 3.091, levelRequirement = 90, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 3.303, damageEffectiveness = 3.303, levelRequirement = 91, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 3.377, damageEffectiveness = 3.377, levelRequirement = 92, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 3.453, damageEffectiveness = 3.453, levelRequirement = 93, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 3.531, damageEffectiveness = 3.531, levelRequirement = 94, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 3.61, damageEffectiveness = 3.61, levelRequirement = 95, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 3.692, damageEffectiveness = 3.692, levelRequirement = 96, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 3.775, damageEffectiveness = 3.775, levelRequirement = 97, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 3.86, damageEffectiveness = 3.86, levelRequirement = 98, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 3.947, damageEffectiveness = 3.947, levelRequirement = 99, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 4.035, damageEffectiveness = 4.035, levelRequirement = 100, soulPreventionDuration = 3, vaalStoredUses = 3, cost = { Soul = 15, }, },
	},
}
skills["Perforate"] = {
	name = "Perforate",
	baseTypeName = "Perforate",
	color = 1,
	description = "Smash the ground to bring forth multiple spears to damage enemies. When in Blood Stance, multiple spikes burst from the ground in sequence, able to hit enemies multiple times. In Sand Stance, the spikes are thrust outwards. Requires a Sword or Axe. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = math.max(activeSkill.skillData.dpsMultiplier or 1, 1)
	end,
	statMap = {
		["blood_spears_base_number_of_spears"] = {
			mod("Multiplier:PerforateMaxSpikes", "BASE", nil),
		},
		["blood_spears_damage_+%_final_in_blood_stance"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Condition", var = "BloodStance" }),
		},
		["quality_display_perforate_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("dpsMultiplier", 1, { type = "Multiplier", var = "PerforateSpikeOverlap", limitVar = "PerforateMaxSpikes" }, { type = "Condition", var = "BloodStance" }),
		skill("radius", 11, { type = "Condition", var = "SandStance" }),
		skill("radius", 8, { type = "Condition", var = "BloodStance" }),
	},
	qualityStats = {
		Default = {
			{ "blood_spears_base_number_of_spears", 0.1 },
		},
	},
	constantStats = {
		{ "blood_spears_base_number_of_spears", 7 },
		{ "blood_spears_damage_+%_final_in_blood_stance", -75 },
		{ "blood_spears_aoe_modifiers_apply_to_blood_spear_placement_range_at_%_value", 50 },
	},
	stats = {
		"skill_area_of_effect_+%_final_in_sand_stance",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_perforate_is_gem",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -20, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 2.298, damageEffectiveness = 2.298, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 2.422, damageEffectiveness = 2.422, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 2.557, damageEffectiveness = 2.557, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 2.705, damageEffectiveness = 2.705, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 2.866, damageEffectiveness = 2.866, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 3.031, damageEffectiveness = 3.031, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 3.206, damageEffectiveness = 3.206, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 36, attackSpeedMultiplier = -20, baseMultiplier = 3.584, damageEffectiveness = 3.584, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 40, attackSpeedMultiplier = -20, baseMultiplier = 3.789, damageEffectiveness = 3.789, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 44, attackSpeedMultiplier = -20, baseMultiplier = 4.007, damageEffectiveness = 4.007, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 48, attackSpeedMultiplier = -20, baseMultiplier = 4.236, damageEffectiveness = 4.236, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 52, attackSpeedMultiplier = -20, baseMultiplier = 4.478, damageEffectiveness = 4.478, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 56, attackSpeedMultiplier = -20, baseMultiplier = 4.734, damageEffectiveness = 4.734, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 60, attackSpeedMultiplier = -20, baseMultiplier = 5.004, damageEffectiveness = 5.004, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 64, attackSpeedMultiplier = -20, baseMultiplier = 5.291, damageEffectiveness = 5.291, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 68, attackSpeedMultiplier = -20, baseMultiplier = 5.592, damageEffectiveness = 5.592, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 72, attackSpeedMultiplier = -20, baseMultiplier = 5.9, damageEffectiveness = 5.9, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 76, attackSpeedMultiplier = -20, baseMultiplier = 6.226, damageEffectiveness = 6.226, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 80, attackSpeedMultiplier = -20, baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 84, attackSpeedMultiplier = -20, baseMultiplier = 6.909, damageEffectiveness = 6.909, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 88, attackSpeedMultiplier = -20, baseMultiplier = 7.279, damageEffectiveness = 7.279, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 92, attackSpeedMultiplier = -20, baseMultiplier = 7.667, damageEffectiveness = 7.667, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 96, attackSpeedMultiplier = -20, baseMultiplier = 8.077, damageEffectiveness = 8.077, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 100, attackSpeedMultiplier = -20, baseMultiplier = 8.508, damageEffectiveness = 8.508, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 104, attackSpeedMultiplier = -20, baseMultiplier = 8.962, damageEffectiveness = 8.962, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 108, attackSpeedMultiplier = -20, baseMultiplier = 9.441, damageEffectiveness = 9.441, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 112, attackSpeedMultiplier = -20, baseMultiplier = 9.944, damageEffectiveness = 9.944, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 116, attackSpeedMultiplier = -20, baseMultiplier = 10.475, damageEffectiveness = 10.475, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 118, attackSpeedMultiplier = -20, baseMultiplier = 11.292, damageEffectiveness = 11.292, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 120, attackSpeedMultiplier = -20, baseMultiplier = 11.592, damageEffectiveness = 11.592, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 122, attackSpeedMultiplier = -20, baseMultiplier = 11.901, damageEffectiveness = 11.901, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 124, attackSpeedMultiplier = -20, baseMultiplier = 12.217, damageEffectiveness = 12.217, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 126, attackSpeedMultiplier = -20, baseMultiplier = 12.542, damageEffectiveness = 12.542, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 128, attackSpeedMultiplier = -20, baseMultiplier = 12.876, damageEffectiveness = 12.876, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 130, attackSpeedMultiplier = -20, baseMultiplier = 13.219, damageEffectiveness = 13.219, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 132, attackSpeedMultiplier = -20, baseMultiplier = 13.571, damageEffectiveness = 13.571, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 134, attackSpeedMultiplier = -20, baseMultiplier = 13.932, damageEffectiveness = 13.932, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 136, attackSpeedMultiplier = -20, baseMultiplier = 14.302, damageEffectiveness = 14.302, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["PerforateAltX"] = {
	name = "Perforate of Duality",
	baseTypeName = "Perforate of Duality",
	color = 1,
	description = "Smash the ground to bring forth multiple spears to damage enemies. When in Blood Stance, multiple spikes burst from the ground in sequence, able to hit enemies multiple times. In Sand Stance, the spikes are thrust outwards. Requires a Sword or Axe. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = math.max(activeSkill.skillData.dpsMultiplier or 1, 1)
	end,
	statMap = {
		["blood_spears_base_number_of_spears"] = {
			mod("Multiplier:PerforateofDualityMaxSpikes", "BASE", nil),
		},
		["blood_spears_damage_+%_final_in_blood_stance"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Condition", var = "BloodStance" }),
		},
		["blood_spears_additional_number_of_spears_if_changed_stance_recently"] = {
			mod("Multiplier:PerforateofDualityMaxSpikes", "BASE", nil, 0, 0, { type = "Condition", var = "ChangedStanceRecently" }),
		},
		["quality_display_perforate_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("dpsMultiplier", 1, { type = "Multiplier", var = "PerforateSpikeOverlap", limitVar = "PerforateofDualityMaxSpikes" }, { type = "Condition", var = "BloodStance" }),
		skill("radius", 11, { type = "Condition", var = "SandStance" }),
		skill("radius", 8, { type = "Condition", var = "BloodStance" }),
	},
	qualityStats = {
		Default = {
			{ "blood_spears_damage_+%_final_in_blood_stance", 0.25 },
			{ "skill_area_of_effect_+%_final_in_sand_stance", 1 },
		},
	},
	constantStats = {
		{ "blood_spears_base_number_of_spears", 5 },
		{ "blood_spears_damage_+%_final_in_blood_stance", -75 },
		{ "blood_spears_aoe_modifiers_apply_to_blood_spear_placement_range_at_%_value", 50 },
		{ "blood_spears_additional_number_of_spears_if_changed_stance_recently", 10 },
	},
	stats = {
		"skill_area_of_effect_+%_final_in_sand_stance",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_perforate_is_gem",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -20, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 4, attackSpeedMultiplier = -20, baseMultiplier = 2.298, damageEffectiveness = 2.298, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 2.422, damageEffectiveness = 2.422, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 12, attackSpeedMultiplier = -20, baseMultiplier = 2.557, damageEffectiveness = 2.557, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 16, attackSpeedMultiplier = -20, baseMultiplier = 2.705, damageEffectiveness = 2.705, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 20, attackSpeedMultiplier = -20, baseMultiplier = 2.866, damageEffectiveness = 2.866, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 24, attackSpeedMultiplier = -20, baseMultiplier = 3.031, damageEffectiveness = 3.031, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 28, attackSpeedMultiplier = -20, baseMultiplier = 3.206, damageEffectiveness = 3.206, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 32, attackSpeedMultiplier = -20, baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 36, attackSpeedMultiplier = -20, baseMultiplier = 3.584, damageEffectiveness = 3.584, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 40, attackSpeedMultiplier = -20, baseMultiplier = 3.789, damageEffectiveness = 3.789, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 44, attackSpeedMultiplier = -20, baseMultiplier = 4.007, damageEffectiveness = 4.007, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 48, attackSpeedMultiplier = -20, baseMultiplier = 4.236, damageEffectiveness = 4.236, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 52, attackSpeedMultiplier = -20, baseMultiplier = 4.478, damageEffectiveness = 4.478, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 56, attackSpeedMultiplier = -20, baseMultiplier = 4.734, damageEffectiveness = 4.734, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 60, attackSpeedMultiplier = -20, baseMultiplier = 5.004, damageEffectiveness = 5.004, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 64, attackSpeedMultiplier = -20, baseMultiplier = 5.291, damageEffectiveness = 5.291, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 68, attackSpeedMultiplier = -20, baseMultiplier = 5.592, damageEffectiveness = 5.592, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 72, attackSpeedMultiplier = -20, baseMultiplier = 5.9, damageEffectiveness = 5.9, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 76, attackSpeedMultiplier = -20, baseMultiplier = 6.226, damageEffectiveness = 6.226, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 80, attackSpeedMultiplier = -20, baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 84, attackSpeedMultiplier = -20, baseMultiplier = 6.909, damageEffectiveness = 6.909, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 88, attackSpeedMultiplier = -20, baseMultiplier = 7.279, damageEffectiveness = 7.279, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 92, attackSpeedMultiplier = -20, baseMultiplier = 7.667, damageEffectiveness = 7.667, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 96, attackSpeedMultiplier = -20, baseMultiplier = 8.077, damageEffectiveness = 8.077, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 100, attackSpeedMultiplier = -20, baseMultiplier = 8.508, damageEffectiveness = 8.508, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 104, attackSpeedMultiplier = -20, baseMultiplier = 8.962, damageEffectiveness = 8.962, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 108, attackSpeedMultiplier = -20, baseMultiplier = 9.441, damageEffectiveness = 9.441, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 112, attackSpeedMultiplier = -20, baseMultiplier = 9.944, damageEffectiveness = 9.944, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 116, attackSpeedMultiplier = -20, baseMultiplier = 10.475, damageEffectiveness = 10.475, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 118, attackSpeedMultiplier = -20, baseMultiplier = 11.292, damageEffectiveness = 11.292, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 120, attackSpeedMultiplier = -20, baseMultiplier = 11.592, damageEffectiveness = 11.592, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 122, attackSpeedMultiplier = -20, baseMultiplier = 11.901, damageEffectiveness = 11.901, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 124, attackSpeedMultiplier = -20, baseMultiplier = 12.217, damageEffectiveness = 12.217, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 126, attackSpeedMultiplier = -20, baseMultiplier = 12.542, damageEffectiveness = 12.542, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 128, attackSpeedMultiplier = -20, baseMultiplier = 12.876, damageEffectiveness = 12.876, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 130, attackSpeedMultiplier = -20, baseMultiplier = 13.219, damageEffectiveness = 13.219, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 132, attackSpeedMultiplier = -20, baseMultiplier = 13.571, damageEffectiveness = 13.571, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 134, attackSpeedMultiplier = -20, baseMultiplier = 13.932, damageEffectiveness = 13.932, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 136, attackSpeedMultiplier = -20, baseMultiplier = 14.302, damageEffectiveness = 14.302, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["PerforateAltY"] = {
	name = "Perforate of Bloodshed",
	baseTypeName = "Perforate of Bloodshed",
	color = 1,
	description = "Smash the ground to bring forth multiple spikes from the ground in sequence, able to hit enemies multiple times.\nRequires a Sword or Axe.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = math.max(activeSkill.skillData.dpsMultiplier or 1, 1)
	end,
	statMap = {
		["blood_spears_base_number_of_spears"] = {
			mod("Multiplier:PerforateofBloodshedMaxSpikes", "BASE", nil),
		},
		["quality_display_perforate_is_gem"] = {
			-- Display Only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("dpsMultiplier", 1, { type = "Multiplier", var = "PerforateSpikeOverlap", limitVar = "PerforateofBloodshedMaxSpikes" }),
		skill("radius", 11),
	},
	qualityStats = {
		Default = {
			{ "active_skill_bleeding_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "blood_spears_base_number_of_spears", 6 },
		{ "blood_spears_aoe_modifiers_apply_to_blood_spear_placement_range_at_%_value", 50 },
		{ "bleed_on_hit_with_attacks_%", 25 },
	},
	stats = {
		"active_skill_bleeding_damage_+%_final",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_perforate_is_gem",
		"quality_display_active_skill_bleed_damage_final_is_gem",
	},
	notMinionStat = {
		"active_skill_bleeding_damage_+%_final",
	},
	levels = {
		[1] = { 50, attackSpeedMultiplier = -20, baseMultiplier = 0.992, damageEffectiveness = 0.992, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 52, attackSpeedMultiplier = -20, baseMultiplier = 1.044, damageEffectiveness = 1.044, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 54, attackSpeedMultiplier = -20, baseMultiplier = 1.099, damageEffectiveness = 1.099, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 56, attackSpeedMultiplier = -20, baseMultiplier = 1.16, damageEffectiveness = 1.16, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 58, attackSpeedMultiplier = -20, baseMultiplier = 1.227, damageEffectiveness = 1.227, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 60, attackSpeedMultiplier = -20, baseMultiplier = 1.302, damageEffectiveness = 1.302, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 62, attackSpeedMultiplier = -20, baseMultiplier = 1.377, damageEffectiveness = 1.377, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 64, attackSpeedMultiplier = -20, baseMultiplier = 1.456, damageEffectiveness = 1.456, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 66, attackSpeedMultiplier = -20, baseMultiplier = 1.539, damageEffectiveness = 1.539, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 68, attackSpeedMultiplier = -20, baseMultiplier = 1.627, damageEffectiveness = 1.627, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 70, attackSpeedMultiplier = -20, baseMultiplier = 1.72, damageEffectiveness = 1.72, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 72, attackSpeedMultiplier = -20, baseMultiplier = 1.818, damageEffectiveness = 1.818, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 74, attackSpeedMultiplier = -20, baseMultiplier = 1.923, damageEffectiveness = 1.923, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 76, attackSpeedMultiplier = -20, baseMultiplier = 2.032, damageEffectiveness = 2.032, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 78, attackSpeedMultiplier = -20, baseMultiplier = 2.149, damageEffectiveness = 2.149, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 80, attackSpeedMultiplier = -20, baseMultiplier = 2.271, damageEffectiveness = 2.271, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 82, attackSpeedMultiplier = -20, baseMultiplier = 2.402, damageEffectiveness = 2.402, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 84, attackSpeedMultiplier = -20, baseMultiplier = 2.538, damageEffectiveness = 2.538, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 86, attackSpeedMultiplier = -20, baseMultiplier = 2.678, damageEffectiveness = 2.678, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 88, attackSpeedMultiplier = -20, baseMultiplier = 2.826, damageEffectiveness = 2.826, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 90, attackSpeedMultiplier = -20, baseMultiplier = 2.977, damageEffectiveness = 2.977, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 92, attackSpeedMultiplier = -20, baseMultiplier = 3.137, damageEffectiveness = 3.137, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 94, attackSpeedMultiplier = -20, baseMultiplier = 3.304, damageEffectiveness = 3.304, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 96, attackSpeedMultiplier = -20, baseMultiplier = 3.48, damageEffectiveness = 3.48, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 98, attackSpeedMultiplier = -20, baseMultiplier = 3.667, damageEffectiveness = 3.667, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 100, attackSpeedMultiplier = -20, baseMultiplier = 3.863, damageEffectiveness = 3.863, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 102, attackSpeedMultiplier = -20, baseMultiplier = 4.069, damageEffectiveness = 4.069, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 104, attackSpeedMultiplier = -20, baseMultiplier = 4.285, damageEffectiveness = 4.285, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 106, attackSpeedMultiplier = -20, baseMultiplier = 4.514, damageEffectiveness = 4.514, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 108, attackSpeedMultiplier = -20, baseMultiplier = 4.755, damageEffectiveness = 4.755, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 109, attackSpeedMultiplier = -20, baseMultiplier = 5.126, damageEffectiveness = 5.126, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 110, attackSpeedMultiplier = -20, baseMultiplier = 5.261, damageEffectiveness = 5.261, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 111, attackSpeedMultiplier = -20, baseMultiplier = 5.402, damageEffectiveness = 5.402, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 112, attackSpeedMultiplier = -20, baseMultiplier = 5.546, damageEffectiveness = 5.546, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 113, attackSpeedMultiplier = -20, baseMultiplier = 5.695, damageEffectiveness = 5.695, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 114, attackSpeedMultiplier = -20, baseMultiplier = 5.845, damageEffectiveness = 5.845, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 115, attackSpeedMultiplier = -20, baseMultiplier = 6.001, damageEffectiveness = 6.001, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 116, attackSpeedMultiplier = -20, baseMultiplier = 6.161, damageEffectiveness = 6.161, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 117, attackSpeedMultiplier = -20, baseMultiplier = 6.324, damageEffectiveness = 6.324, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 118, attackSpeedMultiplier = -20, baseMultiplier = 6.493, damageEffectiveness = 6.493, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["PetrifiedBlood"] = {
	name = "Petrified Blood",
	baseTypeName = "Petrified Blood",
	color = 1,
	description = "Applies a buff that protects the lower half of your life, preventing some of the immediate life loss when damaged by hits and applying the loss over time instead. Your life cannot be raised above low life other than by flasks, and while above low life, skills will cost life as well as mana.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["skill_grants_life_cost_%_mana_cost_while_not_on_low_life"] = {
			mod("ManaCostAsLifeCost", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Petrified Blood", unscalable = true }, { type="Condition", var="LowLife", neg = true }),
		},
		["petrified_blood_%_life_loss_below_half_from_hit_to_prevent"] = {
			mod("LifeLossBelowHalfPrevented", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Petrified Blood" }),
		},
		["petrified_blood_%_prevented_life_loss_to_lose_over_time"] = {
			mod("LifeLossBelowHalfLost", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Petrified Blood" }),
		},
		["cannot_recover_above_low_life_except_flasks"] = {
			-- Display Only, this mod controls multiple lines for some reason
		},
	},
	baseFlags = {
	},
	qualityStats = {
		Default = {
			{ "petrified_blood_%_prevented_life_loss_to_lose_over_time", -0.25 },
		},
	},
	constantStats = {
		{ "petrified_blood_%_life_loss_below_half_from_hit_to_prevent", 40 },
		{ "skill_grants_life_cost_%_mana_cost_while_not_on_low_life", 40 },
	},
	stats = {
		"petrified_blood_%_prevented_life_loss_to_lose_over_time",
		"cannot_recover_above_low_life_except_flasks",
	},
	levels = {
		[1] = { 100, cooldown = 1, levelRequirement = 24, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { 99, cooldown = 1, levelRequirement = 27, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { 98, cooldown = 1, levelRequirement = 30, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { 97, cooldown = 1, levelRequirement = 33, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[5] = { 96, cooldown = 1, levelRequirement = 36, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[6] = { 95, cooldown = 1, levelRequirement = 39, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[7] = { 94, cooldown = 1, levelRequirement = 42, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[8] = { 93, cooldown = 1, levelRequirement = 45, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[9] = { 92, cooldown = 1, levelRequirement = 48, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[10] = { 91, cooldown = 1, levelRequirement = 50, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[11] = { 90, cooldown = 1, levelRequirement = 52, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[12] = { 89, cooldown = 1, levelRequirement = 54, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[13] = { 88, cooldown = 1, levelRequirement = 56, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[14] = { 87, cooldown = 1, levelRequirement = 58, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[15] = { 86, cooldown = 1, levelRequirement = 60, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[16] = { 85, cooldown = 1, levelRequirement = 62, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[17] = { 84, cooldown = 1, levelRequirement = 64, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[18] = { 83, cooldown = 1, levelRequirement = 66, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[19] = { 82, cooldown = 1, levelRequirement = 68, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { 81, cooldown = 1, levelRequirement = 70, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[21] = { 80, cooldown = 1, levelRequirement = 72, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[22] = { 79, cooldown = 1, levelRequirement = 74, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[23] = { 78, cooldown = 1, levelRequirement = 76, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[24] = { 77, cooldown = 1, levelRequirement = 78, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[25] = { 76, cooldown = 1, levelRequirement = 80, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[26] = { 75, cooldown = 1, levelRequirement = 82, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[27] = { 74, cooldown = 1, levelRequirement = 84, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[28] = { 73, cooldown = 1, levelRequirement = 86, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[29] = { 72, cooldown = 1, levelRequirement = 88, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[30] = { 71, cooldown = 1, levelRequirement = 90, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[31] = { 71, cooldown = 1, levelRequirement = 91, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[32] = { 70, cooldown = 1, levelRequirement = 92, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[33] = { 70, cooldown = 1, levelRequirement = 93, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[34] = { 69, cooldown = 1, levelRequirement = 94, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[35] = { 69, cooldown = 1, levelRequirement = 95, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[36] = { 68, cooldown = 1, levelRequirement = 96, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[37] = { 68, cooldown = 1, levelRequirement = 97, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[38] = { 67, cooldown = 1, levelRequirement = 98, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[39] = { 67, cooldown = 1, levelRequirement = 99, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
		[40] = { 66, cooldown = 1, levelRequirement = 100, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["Pride"] = {
	name = "Pride",
	baseTypeName = "Pride",
	color = 1,
	description = "Casts an aura that causes nearby enemies to take more physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.AuraAffectsEnemies] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["physical_damage_aura_nearby_enemies_physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "AuraDebuff", modCond = "PrideMinEffect" }),
		},
		["physical_damage_aura_nearby_enemies_physical_damage_taken_+%_max"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "AuraDebuff", modCond = "PrideMaxEffect" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"physical_damage_aura_nearby_enemies_physical_damage_taken_+%",
		"physical_damage_aura_nearby_enemies_physical_damage_taken_+%_max",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 15, 30, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 15, 30, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 15, 31, 1, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 15, 31, 2, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 16, 32, 2, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 16, 32, 3, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 16, 33, 3, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 16, 33, 4, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 17, 34, 4, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 17, 34, 5, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 17, 35, 5, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 17, 35, 6, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 18, 36, 6, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 18, 36, 7, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 18, 37, 7, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 18, 37, 8, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 19, 38, 8, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 19, 38, 9, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 19, 39, 9, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 19, 39, 10, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 20, 40, 10, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 20, 40, 11, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 20, 41, 11, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 20, 41, 12, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 21, 42, 12, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 21, 42, 13, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { 21, 43, 13, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { 21, 43, 14, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { 22, 44, 14, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { 22, 44, 15, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { 22, 45, 15, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { 22, 45, 15, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { 22, 46, 15, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { 22, 46, 16, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { 22, 47, 16, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { 23, 47, 16, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { 23, 48, 16, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { 23, 48, 17, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { 23, 49, 17, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { 23, 49, 17, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["ProtectiveLink"] = {
	name = "Protective Link",
	baseTypeName = "Protective Link",
	color = 1,
	description = "Targets an allied player to apply a buff which links you to them for a duration. While linked, they copy your block chance and recover life when they block. If the target dies while linked, you will also die. This skill cannot be triggered, or used by Totems, Traps, or Mines.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Link] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["bulwark_link_grants_recover_X_life_on_block"] = {
			mod("LifeOnBlock", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Link" }),
		},
		["display_bulwark_link_overrides_attack_block_and_maximum_attack_block"] = {
			mod("BlockAttackChanceIsEqualToParent", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Link" }),
			mod("MaximumBlockAttackChanceIsEqualToParent", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Link" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 75 },
		},
	},
	stats = {
		"bulwark_link_grants_recover_X_life_on_block",
		"base_skill_effect_duration",
		"skill_cost_over_time_is_not_removed_with_skill",
		"display_link_stuff",
		"display_bulwark_link_overrides_attack_block_and_maximum_attack_block",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 31, 8000, levelRequirement = 34, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 900, }, },
		[2] = { 36, 8100, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 960, }, },
		[3] = { 41, 8200, levelRequirement = 38, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1030, }, },
		[4] = { 48, 8300, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1080, }, },
		[5] = { 54, 8400, levelRequirement = 42, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1140, }, },
		[6] = { 60, 8500, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1200, }, },
		[7] = { 71, 8600, levelRequirement = 46, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1250, }, },
		[8] = { 80, 8700, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1310, }, },
		[9] = { 88, 8800, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1380, }, },
		[10] = { 104, 8900, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1440, }, },
		[11] = { 116, 9000, levelRequirement = 54, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1490, }, },
		[12] = { 128, 9100, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1550, }, },
		[13] = { 150, 9200, levelRequirement = 58, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1610, }, },
		[14] = { 167, 9300, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1680, }, },
		[15] = { 183, 9400, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1730, }, },
		[16] = { 207, 9500, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1790, }, },
		[17] = { 234, 9600, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1850, }, },
		[18] = { 264, 9700, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1900, }, },
		[19] = { 281, 9800, levelRequirement = 69, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1940, }, },
		[20] = { 297, 9900, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 1960, }, },
		[21] = { 322, 10000, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2030, }, },
		[22] = { 347, 10100, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2090, }, },
		[23] = { 372, 10200, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2140, }, },
		[24] = { 396, 10300, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2200, }, },
		[25] = { 421, 10400, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2260, }, },
		[26] = { 446, 10500, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2330, }, },
		[27] = { 471, 10600, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2380, }, },
		[28] = { 495, 10700, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2440, }, },
		[29] = { 520, 10800, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2500, }, },
		[30] = { 545, 10900, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2550, }, },
		[31] = { 557, 11000, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2590, }, },
		[32] = { 570, 11050, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2610, }, },
		[33] = { 582, 11100, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2650, }, },
		[34] = { 594, 11150, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2680, }, },
		[35] = { 607, 11200, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2700, }, },
		[36] = { 619, 11250, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2740, }, },
		[37] = { 632, 11300, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2760, }, },
		[38] = { 644, 11350, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2790, }, },
		[39] = { 656, 11400, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2830, }, },
		[40] = { 668, 11450, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { ManaPerMinute = 2850, }, },
	},
}
skills["Punishment"] = {
	name = "Punishment",
	baseTypeName = "Punishment",
	color = 1,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, causing them to be debilitated when they hit enemies and increasing damage they take while on low life.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["damage_taken_+%_on_low_life"] = {
			mod("DamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "LowLife"}),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("DebilitateChance", "BASE", 100),
	},
	qualityStats = {
		Default = {
			{ "debilitate_self_for_x_milliseconds_on_hit", 50 },
		},
	},
	constantStats = {
		{ "debilitate_self_for_x_milliseconds_on_hit", 2000 },
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"damage_taken_+%_on_low_life",
		"base_deal_no_damage",
		"quality_display_debilitate_self_for_x_milliseconds_on_hit_is_gem",
	},
	notMinionStat = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 8000, 0, 30, levelRequirement = 24, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[2] = { 8200, 1, 31, levelRequirement = 27, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[3] = { 8400, 1, 33, levelRequirement = 30, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[4] = { 8600, 2, 34, levelRequirement = 33, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[5] = { 8800, 2, 36, levelRequirement = 36, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[6] = { 9000, 3, 37, levelRequirement = 39, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[7] = { 9200, 3, 39, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[8] = { 9400, 4, 40, levelRequirement = 45, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[9] = { 9600, 4, 42, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[10] = { 9800, 5, 43, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[11] = { 10000, 5, 45, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 26, }, },
		[12] = { 10200, 6, 46, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { Mana = 27, }, },
		[13] = { 10400, 6, 48, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { Mana = 28, }, },
		[14] = { 10600, 7, 49, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 29, }, },
		[15] = { 10800, 7, 51, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { Mana = 29, }, },
		[16] = { 11000, 8, 52, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, cost = { Mana = 30, }, },
		[17] = { 11200, 8, 54, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 31, }, },
		[18] = { 11400, 9, 55, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { Mana = 31, }, },
		[19] = { 11600, 9, 57, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { Mana = 32, }, },
		[20] = { 11800, 10, 58, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 33, }, },
		[21] = { 12000, 10, 60, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 34, }, },
		[22] = { 12200, 11, 61, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 34, }, },
		[23] = { 12400, 11, 63, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 35, }, },
		[24] = { 12600, 12, 64, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 36, }, },
		[25] = { 12800, 12, 66, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 36, }, },
		[26] = { 13000, 13, 67, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 37, }, },
		[27] = { 13200, 13, 69, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 38, }, },
		[28] = { 13400, 14, 70, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 39, }, },
		[29] = { 13600, 14, 72, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 39, }, },
		[30] = { 13800, 15, 73, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 40, }, },
		[31] = { 13900, 15, 74, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 40, }, },
		[32] = { 14000, 15, 75, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 41, }, },
		[33] = { 14100, 15, 75, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 41, }, },
		[34] = { 14200, 16, 76, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 42, }, },
		[35] = { 14300, 16, 77, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 42, }, },
		[36] = { 14400, 16, 78, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 42, }, },
		[37] = { 14500, 16, 78, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 43, }, },
		[38] = { 14600, 17, 79, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 43, }, },
		[39] = { 14700, 17, 80, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 43, }, },
		[40] = { 14800, 17, 81, levelRequirement = 100, statInterpolation = { 1, 1, 1, }, cost = { Mana = 44, }, },
	},
}
skills["PurityOfFire"] = {
	name = "Purity of Fire",
	baseTypeName = "Purity of Fire",
	color = 1,
	description = "Casts an aura that grants fire resistance to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_fire_damage_resistance_%"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_fire_damage_resistance_%"] = {
			mod("FireResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_fire_damage_resistance_%", 0.5 },
		},
	},
	stats = {
		"base_fire_damage_resistance_%",
		"base_maximum_fire_damage_resistance_%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 22, 0, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 23, 0, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 24, 0, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 25, 0, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 26, 1, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 27, 1, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 28, 1, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 29, 1, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 30, 1, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 31, 1, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 32, 2, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 33, 2, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 34, 2, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 35, 2, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 36, 2, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 37, 2, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 38, 3, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 39, 3, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 40, 3, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 41, 4, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 42, 4, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 43, 4, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 44, 5, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 45, 5, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 46, 5, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 47, 5, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { 48, 5, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { 49, 5, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { 50, 5, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { 51, 5, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { 51, 5, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { 52, 5, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { 52, 5, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { 53, 5, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { 53, 5, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { 54, 5, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { 54, 5, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { 55, 5, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { 55, 5, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { 56, 5, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 35, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["VaalImpurityOfFire"] = {
	name = "Vaal Impurity of Fire",
	baseTypeName = "Vaal Impurity of Fire",
	color = 1,
	description = "Casts an aura that reduces fire damage taken and provides ignite immunity to you and nearby allies, and makes hits against nearby enemies ignore their fire resistance. ",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["hits_ignore_my_fire_resistance"] = {
			flag("SelfIgnoreFireResistance", { type = "GlobalEffect", effectType = "AuraDebuff" })
		},
		["base_maximum_fire_damage_resistance_%"] = {
			mod("FireResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_immune_to_ignite"] = {
			flag("IgniteImmune", { type = "GlobalEffect", effectType = "Aura"}),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	constantStats = {
		{ "base_maximum_fire_damage_resistance_%", 5 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"active_skill_base_radius_+",
		"aura_effect_+%",
		"base_deal_no_damage",
		"base_immune_to_ignite",
		"hits_ignore_my_fire_resistance",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 14, 0, cooldown = 0.5, levelRequirement = 24, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 14, 4, cooldown = 0.5, levelRequirement = 27, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 14, 8, cooldown = 0.5, levelRequirement = 30, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 15, 12, cooldown = 0.5, levelRequirement = 33, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 15, 16, cooldown = 0.5, levelRequirement = 36, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 15, 20, cooldown = 0.5, levelRequirement = 39, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 16, 24, cooldown = 0.5, levelRequirement = 42, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 16, 28, cooldown = 0.5, levelRequirement = 45, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 16, 32, cooldown = 0.5, levelRequirement = 48, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 17, 36, cooldown = 0.5, levelRequirement = 50, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 17, 40, cooldown = 0.5, levelRequirement = 52, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 17, 44, cooldown = 0.5, levelRequirement = 54, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 18, 48, cooldown = 0.5, levelRequirement = 56, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 18, 52, cooldown = 0.5, levelRequirement = 58, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 18, 56, cooldown = 0.5, levelRequirement = 60, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 19, 60, cooldown = 0.5, levelRequirement = 62, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 19, 64, cooldown = 0.5, levelRequirement = 64, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 19, 68, cooldown = 0.5, levelRequirement = 66, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 20, 72, cooldown = 0.5, levelRequirement = 68, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 20, 76, cooldown = 0.5, levelRequirement = 70, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 20, 80, cooldown = 0.5, levelRequirement = 72, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 21, 84, cooldown = 0.5, levelRequirement = 74, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 21, 88, cooldown = 0.5, levelRequirement = 76, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 21, 92, cooldown = 0.5, levelRequirement = 78, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 22, 96, cooldown = 0.5, levelRequirement = 80, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 22, 100, cooldown = 0.5, levelRequirement = 82, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 22, 104, cooldown = 0.5, levelRequirement = 84, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 23, 108, cooldown = 0.5, levelRequirement = 86, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 23, 112, cooldown = 0.5, levelRequirement = 88, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 23, 116, cooldown = 0.5, levelRequirement = 90, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 23, 118, cooldown = 0.5, levelRequirement = 91, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 24, 120, cooldown = 0.5, levelRequirement = 92, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 24, 122, cooldown = 0.5, levelRequirement = 93, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 24, 124, cooldown = 0.5, levelRequirement = 94, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 24, 126, cooldown = 0.5, levelRequirement = 95, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 24, 128, cooldown = 0.5, levelRequirement = 96, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 24, 130, cooldown = 0.5, levelRequirement = 97, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 25, 132, cooldown = 0.5, levelRequirement = 98, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 25, 134, cooldown = 0.5, levelRequirement = 99, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 25, 136, cooldown = 0.5, levelRequirement = 100, soulPreventionDuration = 8, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["RageVortex"] = {
	name = "Rage Vortex",
	baseTypeName = "Rage Vortex",
	color = 1,
	description = "Spin with a sword or axe to deal damage in an area around you. Sacrifices some rage to send a ragestorm forward. While enemies are inside it, the ragestorm will slow its movement and repeatedly deal attack damage based on your attack speed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preSkillTypeFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			local maxRage = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "MaximumRage")
			local rageVortexSacrificePercentage = activeSkill.skillData.MaxRageVortexSacrificePercentage / 100
			local configOverride= activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "Multiplier:RageSacrificedStacks")
			local maxSacrificedRage = math.floor(rageVortexSacrificePercentage * maxRage)
			local stacks = math.min((configOverride > 0 and configOverride) or maxSacrificedRage, maxSacrificedRage)
			activeSkill.skillModList:NewMod("Multiplier:RageSacrificed", "BASE", stacks, "Skill:RageVortex")
		end
	end,
	parts = {
		{
			name = "Melee",
		},
		{
			name = "Rage Storm",
		},
	},
	statMap = {
		["rage_slash_radius_+_per_amount_of_rage_sacrificed"] = {
			mod("AreaOfEffect", "BASE", nil, 0, 0, { type = "Multiplier", var = "RageSacrificed", divVar = "RagePerRadius" }),
		},
		["rage_slash_damage_+%_final_per_amount_of_rage_sacrificed"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "RageSacrificed", divVar = "RagePerDamage" }),
		},
		["rage_slash_rage_sacrifice_per_radius_bonus"] = {
			mod("Multiplier:RagePerRadius", "BASE", nil),
		},
		["rage_slash_rage_sacrifice_per_damage_bonus"] = {
			mod("Multiplier:RagePerDamage", "BASE", nil),
		},
		["rage_slash_vortex_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["rage_slash_sacrifice_rage_%"] = {
			skill("MaxRageVortexSacrificePercentage", nil),
		},
		["quality_display_rage_vortex_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "rage_slash_sacrifice_rage_%", 0.25 },
		},
	},
	constantStats = {
		{ "rage_slash_sacrifice_rage_%", 20 },
		{ "rage_slash_radius_+_per_amount_of_rage_sacrificed", 1 },
		{ "rage_slash_rage_sacrifice_per_radius_bonus", 2 },
		{ "rage_slash_damage_+%_final_per_amount_of_rage_sacrificed", 10 },
		{ "rage_slash_rage_sacrifice_per_damage_bonus", 1 },
		{ "rage_slash_maximum_vortices", 1 },
		{ "rage_slash_vortex_attack_speed_+%_final", 250 },
		{ "base_skill_effect_duration", 3000 },
		{ "active_skill_base_area_of_effect_radius", 18 },
	},
	stats = {
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"console_skill_dont_chase",
		"quality_display_rage_vortex_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 0.42, damageEffectiveness = 0.42, levelRequirement = 28, cost = { Life = 25, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 0.435, damageEffectiveness = 0.435, levelRequirement = 31, cost = { Life = 26, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 0.449, damageEffectiveness = 0.449, levelRequirement = 34, cost = { Life = 27, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 0.464, damageEffectiveness = 0.464, levelRequirement = 37, cost = { Life = 28, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 0.478, damageEffectiveness = 0.478, levelRequirement = 40, cost = { Life = 29, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 0.493, damageEffectiveness = 0.493, levelRequirement = 42, cost = { Life = 31, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 0.506, damageEffectiveness = 0.506, levelRequirement = 44, cost = { Life = 32, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 0.521, damageEffectiveness = 0.521, levelRequirement = 46, cost = { Life = 33, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 0.536, damageEffectiveness = 0.536, levelRequirement = 48, cost = { Life = 34, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 0.55, damageEffectiveness = 0.55, levelRequirement = 50, cost = { Life = 35, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 0.565, damageEffectiveness = 0.565, levelRequirement = 52, cost = { Life = 36, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 0.579, damageEffectiveness = 0.579, levelRequirement = 54, cost = { Life = 37, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 0.594, damageEffectiveness = 0.594, levelRequirement = 56, cost = { Life = 38, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 0.609, damageEffectiveness = 0.609, levelRequirement = 58, cost = { Life = 39, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 0.623, damageEffectiveness = 0.623, levelRequirement = 60, cost = { Life = 40, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 0.639, damageEffectiveness = 0.639, levelRequirement = 62, cost = { Life = 42, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 0.653, damageEffectiveness = 0.653, levelRequirement = 64, cost = { Life = 43, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 0.669, damageEffectiveness = 0.669, levelRequirement = 66, cost = { Life = 44, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 0.683, damageEffectiveness = 0.683, levelRequirement = 68, cost = { Life = 45, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 0.699, damageEffectiveness = 0.699, levelRequirement = 70, cost = { Life = 46, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 0.715, damageEffectiveness = 0.715, levelRequirement = 72, cost = { Life = 47, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 0.73, damageEffectiveness = 0.73, levelRequirement = 74, cost = { Life = 48, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 0.746, damageEffectiveness = 0.746, levelRequirement = 76, cost = { Life = 49, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 0.761, damageEffectiveness = 0.761, levelRequirement = 78, cost = { Life = 50, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 0.777, damageEffectiveness = 0.777, levelRequirement = 80, cost = { Life = 52, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 0.792, damageEffectiveness = 0.792, levelRequirement = 82, cost = { Life = 53, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 0.809, damageEffectiveness = 0.809, levelRequirement = 84, cost = { Life = 54, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 0.825, damageEffectiveness = 0.825, levelRequirement = 86, cost = { Life = 55, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 0.841, damageEffectiveness = 0.841, levelRequirement = 88, cost = { Life = 56, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 0.857, damageEffectiveness = 0.857, levelRequirement = 90, cost = { Life = 57, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 0.866, damageEffectiveness = 0.866, levelRequirement = 91, cost = { Life = 58, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 0.873, damageEffectiveness = 0.873, levelRequirement = 92, cost = { Life = 58, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 0.881, damageEffectiveness = 0.881, levelRequirement = 93, cost = { Life = 59, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 0.89, damageEffectiveness = 0.89, levelRequirement = 94, cost = { Life = 59, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 0.898, damageEffectiveness = 0.898, levelRequirement = 95, cost = { Life = 60, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 0.907, damageEffectiveness = 0.907, levelRequirement = 96, cost = { Life = 60, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 0.914, damageEffectiveness = 0.914, levelRequirement = 97, cost = { Life = 61, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 0.922, damageEffectiveness = 0.922, levelRequirement = 98, cost = { Life = 61, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 99, cost = { Life = 62, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 0.938, damageEffectiveness = 0.938, levelRequirement = 100, cost = { Life = 63, }, },
	},
}
skills["RageVortexAltX"] = {
	name = "Rage Vortex of Berserking",
	baseTypeName = "Rage Vortex of Berserking",
	color = 1,
	description = "Spin with a sword or axe to deal damage in an area around you. If you have at least 10 rage, create a ragestorm attached to you that repeatedly deals attack damage to enemies inside based on your attack speed. The ragestorm consumes rage at an accelerating rate, and ends if you run out.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee",
		},
		{
			name = "Rage Storm",
		},
	},
	statMap = {
		["rage_slash_vortex_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.1 },
		},
	},
	constantStats = {
		{ "rage_slash_maximum_vortices", 1 },
		{ "rage_slash_vortex_attack_speed_+%_final", 250 },
		{ "active_skill_base_area_of_effect_radius", 22 },
		{ "rage_storm_scaling_rage_hundred_times_base_cost", 300 },
		{ "rage_storm_scaling_rage_loss_+%_per_second", 20 },
	},
	stats = {
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 0.42, damageEffectiveness = 0.42, levelRequirement = 28, cost = { Life = 25, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 0.435, damageEffectiveness = 0.435, levelRequirement = 31, cost = { Life = 26, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 0.449, damageEffectiveness = 0.449, levelRequirement = 34, cost = { Life = 27, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 0.464, damageEffectiveness = 0.464, levelRequirement = 37, cost = { Life = 28, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 0.478, damageEffectiveness = 0.478, levelRequirement = 40, cost = { Life = 29, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 0.493, damageEffectiveness = 0.493, levelRequirement = 42, cost = { Life = 31, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 0.506, damageEffectiveness = 0.506, levelRequirement = 44, cost = { Life = 32, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 0.521, damageEffectiveness = 0.521, levelRequirement = 46, cost = { Life = 33, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 0.536, damageEffectiveness = 0.536, levelRequirement = 48, cost = { Life = 34, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 0.55, damageEffectiveness = 0.55, levelRequirement = 50, cost = { Life = 35, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 0.565, damageEffectiveness = 0.565, levelRequirement = 52, cost = { Life = 36, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 0.579, damageEffectiveness = 0.579, levelRequirement = 54, cost = { Life = 37, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 0.594, damageEffectiveness = 0.594, levelRequirement = 56, cost = { Life = 38, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 0.609, damageEffectiveness = 0.609, levelRequirement = 58, cost = { Life = 39, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 0.623, damageEffectiveness = 0.623, levelRequirement = 60, cost = { Life = 40, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 0.639, damageEffectiveness = 0.639, levelRequirement = 62, cost = { Life = 42, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 0.653, damageEffectiveness = 0.653, levelRequirement = 64, cost = { Life = 43, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 0.669, damageEffectiveness = 0.669, levelRequirement = 66, cost = { Life = 44, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 0.683, damageEffectiveness = 0.683, levelRequirement = 68, cost = { Life = 45, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 0.699, damageEffectiveness = 0.699, levelRequirement = 70, cost = { Life = 46, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 0.715, damageEffectiveness = 0.715, levelRequirement = 72, cost = { Life = 47, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 0.73, damageEffectiveness = 0.73, levelRequirement = 74, cost = { Life = 48, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 0.746, damageEffectiveness = 0.746, levelRequirement = 76, cost = { Life = 49, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 0.761, damageEffectiveness = 0.761, levelRequirement = 78, cost = { Life = 50, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 0.777, damageEffectiveness = 0.777, levelRequirement = 80, cost = { Life = 52, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 0.792, damageEffectiveness = 0.792, levelRequirement = 82, cost = { Life = 53, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 0.809, damageEffectiveness = 0.809, levelRequirement = 84, cost = { Life = 54, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 0.825, damageEffectiveness = 0.825, levelRequirement = 86, cost = { Life = 55, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 0.841, damageEffectiveness = 0.841, levelRequirement = 88, cost = { Life = 56, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 0.857, damageEffectiveness = 0.857, levelRequirement = 90, cost = { Life = 57, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 0.866, damageEffectiveness = 0.866, levelRequirement = 91, cost = { Life = 58, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 0.873, damageEffectiveness = 0.873, levelRequirement = 92, cost = { Life = 58, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 0.881, damageEffectiveness = 0.881, levelRequirement = 93, cost = { Life = 59, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 0.89, damageEffectiveness = 0.89, levelRequirement = 94, cost = { Life = 59, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 0.898, damageEffectiveness = 0.898, levelRequirement = 95, cost = { Life = 60, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 0.907, damageEffectiveness = 0.907, levelRequirement = 96, cost = { Life = 60, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 0.914, damageEffectiveness = 0.914, levelRequirement = 97, cost = { Life = 61, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 0.922, damageEffectiveness = 0.922, levelRequirement = 98, cost = { Life = 61, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 99, cost = { Life = 62, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 0.938, damageEffectiveness = 0.938, levelRequirement = 100, cost = { Life = 63, }, },
	},
}
skills["RallyingCry"] = {
	name = "Rallying Cry",
	baseTypeName = "Rallying Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. Nearby allies gain a buff based on the damage of your weapon.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["rallying_cry_damage_+%_final_from_osm_per_nearby_ally"] = {
			mod("RallyingCryExertDamageBonus", "BASE", nil),
		},
		["skill_empowers_next_x_melee_attacks"] = {
			mod("RallyingExertedAttacks", "BASE", nil),
		},
		["rallying_cry_weapon_damage_%_for_allies_per_5_monster_power"] = {
			mod("RallyingCryAllyDamageBonusPer5Power", "BASE", nil),
			mod("Dummy", "DUMMY", 1, 0, 0, { type = "GlobalEffect", effectType = "Warcry" }, { type = "Multiplier", var = "NearbyAlly" }),
		},
		["rallying_cry_buff_effect_on_minions_+%_final"] = {
			mod("RallyingCryMinionDamageBonusMultiplier", "BASE", nil),
			div = 100
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "rallying_cry_damage_+%_final_from_osm_per_nearby_ally", 5 },
		{ "skill_empowers_next_x_melee_attacks", 5 },
		{ "rallying_cry_weapon_damage_%_for_allies_per_5_monster_power", 4 },
		{ "rallying_cry_buff_effect_on_minions_+%_final", 100 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_gain_mp_from_allies",
		"warcry_count_power_from_enemies",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["RejuvenationTotem"] = {
	name = "Rejuvenation Totem",
	baseTypeName = "Rejuvenation Totem",
	color = 1,
	description = "Summons a totem that has an aura which regenerates life for you and your nearby allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.TotemCastsWhenNotDetached] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 4,
	castTime = 0.6,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			{ mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60 },
			{ mod("ManaRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", var = "RejuvenationTotemManaRegen" }),
			div = 400 },
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "totem_life_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 10 },
	},
	stats = {
		"base_life_regeneration_rate_per_minute",
		"totem_life_+%",
		"base_skill_is_totemified",
		"base_deal_no_damage",
		"is_totem",
	},
	levels = {
		[1] = { 514, 0, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[2] = { 786, 4, levelRequirement = 6, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[3] = { 1068, 8, levelRequirement = 9, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[4] = { 1452, 12, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[5] = { 1940, 16, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[6] = { 2446, 20, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[7] = { 3064, 24, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 3800, 28, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[9] = { 4560, 32, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[10] = { 5443, 36, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[11] = { 6354, 40, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[12] = { 7604, 44, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[13] = { 8785, 48, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[14] = { 9999, 52, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[15] = { 11248, 56, levelRequirement = 55, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[16] = { 12640, 60, levelRequirement = 58, statInterpolation = { 1, 1, }, cost = { Mana = 27, }, },
		[17] = { 13845, 64, levelRequirement = 61, statInterpolation = { 1, 1, }, cost = { Mana = 28, }, },
		[18] = { 15537, 68, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 29, }, },
		[19] = { 17272, 72, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 31, }, },
		[20] = { 19051, 76, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[21] = { 20158, 80, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[22] = { 21410, 84, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 33, }, },
		[23] = { 22320, 88, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[24] = { 23745, 92, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[25] = { 25326, 96, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 35, }, },
		[26] = { 26302, 100, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[27] = { 28071, 104, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[28] = { 29877, 108, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 37, }, },
		[29] = { 31986, 112, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 38, }, },
		[30] = { 34003, 116, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[31] = { 35381, 118, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[32] = { 36782, 120, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[33] = { 38067, 122, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[34] = { 39514, 124, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[35] = { 40984, 126, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[36] = { 42477, 128, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[37] = { 43848, 130, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[38] = { 45387, 132, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[39] = { 46949, 134, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[40] = { 48384, 136, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
	},
}
skills["VaalRejuvenationTotem"] = {
	name = "Vaal Rejuvenation Totem",
	baseTypeName = "Vaal Rejuvenation Totem",
	color = 1,
	description = "Summons a totem that has an aura which regenerates life for you and your nearby allies. When things affected by the aura are hit, the totem's life is removed instead for some of the damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.TotemCastsWhenNotDetached] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 21,
	castTime = 0.1,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
		["vaal_rejuvenation_totem_%_damage_taken_applied_to_totem_instead"] = {
			mod("takenFromVaalRejuvenationTotemsBeforeYou", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "totem_life_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 4000 },
		{ "base_totem_range", 10 },
		{ "vaal_rejuvenation_totem_%_damage_taken_applied_to_totem_instead", 40 },
		{ "number_of_additional_totems_allowed", 1 },
		{ "active_skill_area_of_effect_+%_final", -30 },
		{ "totem_scale_pluspercent", 20 },
	},
	stats = {
		"base_life_regeneration_rate_per_minute",
		"totem_life_+%",
		"base_skill_is_totemified",
		"base_deal_no_damage",
		"is_totem",
		"modifiers_to_totem_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 1157, 50, levelRequirement = 4, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 1769, 56, levelRequirement = 6, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 2403, 62, levelRequirement = 9, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 3267, 68, levelRequirement = 12, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 4365, 74, levelRequirement = 16, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 5504, 80, levelRequirement = 20, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 6894, 86, levelRequirement = 24, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 8550, 92, levelRequirement = 28, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 10260, 98, levelRequirement = 32, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 12248, 104, levelRequirement = 36, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 14297, 110, levelRequirement = 40, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 17109, 116, levelRequirement = 44, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 19767, 122, levelRequirement = 48, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 22499, 128, levelRequirement = 52, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 25308, 134, levelRequirement = 55, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 28440, 140, levelRequirement = 58, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 31152, 146, levelRequirement = 61, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 34959, 152, levelRequirement = 64, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 38862, 158, levelRequirement = 67, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 42866, 164, levelRequirement = 70, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 45356, 170, levelRequirement = 72, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 48173, 176, levelRequirement = 74, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 50220, 182, levelRequirement = 76, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 53427, 188, levelRequirement = 78, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 56984, 194, levelRequirement = 80, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 59180, 200, levelRequirement = 82, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 63161, 206, levelRequirement = 84, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 67224, 212, levelRequirement = 86, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 71969, 218, levelRequirement = 88, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 76508, 224, levelRequirement = 90, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 79608, 227, levelRequirement = 91, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 82760, 230, levelRequirement = 92, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 85652, 233, levelRequirement = 93, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 88907, 236, levelRequirement = 94, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 92214, 239, levelRequirement = 95, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 95574, 242, levelRequirement = 96, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 98658, 245, levelRequirement = 97, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 102122, 248, levelRequirement = 98, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 105636, 251, levelRequirement = 99, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 108864, 254, levelRequirement = 100, soulPreventionDuration = 12, vaalStoredUses = 1, statInterpolation = { 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["SearingBond"] = {
	name = "Searing Bond",
	baseTypeName = "Searing Bond",
	color = 1,
	baseEffectiveness = 7.5956997871399,
	incrementalEffectiveness = 0.062199998646975,
	description = "Summons a totem that casts a beam of fire at you and each other totem you control, dealing burning damage to enemies caught in the beam. Enemies near either end of a beam also suffer burning damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.DamageOverTime] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CausesBurning] = true, [SkillType.SummonsTotem] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.DegenOnlySpellDamage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 9,
	castTime = 1,
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "number_of_additional_totems_allowed", 0.1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 100 },
		{ "number_of_additional_totems_allowed", 1 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"is_totem",
		"base_skill_is_totemified",
		"spell_damage_modifiers_apply_to_skill_dot",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, levelRequirement = 12, statInterpolation = { 3, }, cost = { Mana = 18, }, },
		[2] = { 16.666667039196, levelRequirement = 15, statInterpolation = { 3, }, cost = { Mana = 19, }, },
		[3] = { 16.666667039196, levelRequirement = 19, statInterpolation = { 3, }, cost = { Mana = 20, }, },
		[4] = { 16.666667039196, levelRequirement = 23, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[5] = { 16.666667039196, levelRequirement = 27, statInterpolation = { 3, }, cost = { Mana = 23, }, },
		[6] = { 16.666667039196, levelRequirement = 31, statInterpolation = { 3, }, cost = { Mana = 25, }, },
		[7] = { 16.666667039196, levelRequirement = 35, statInterpolation = { 3, }, cost = { Mana = 27, }, },
		[8] = { 16.666667039196, levelRequirement = 38, statInterpolation = { 3, }, cost = { Mana = 29, }, },
		[9] = { 16.666667039196, levelRequirement = 41, statInterpolation = { 3, }, cost = { Mana = 31, }, },
		[10] = { 16.666667039196, levelRequirement = 44, statInterpolation = { 3, }, cost = { Mana = 33, }, },
		[11] = { 16.666667039196, levelRequirement = 47, statInterpolation = { 3, }, cost = { Mana = 35, }, },
		[12] = { 16.666667039196, levelRequirement = 50, statInterpolation = { 3, }, cost = { Mana = 37, }, },
		[13] = { 16.666667039196, levelRequirement = 53, statInterpolation = { 3, }, cost = { Mana = 39, }, },
		[14] = { 16.666667039196, levelRequirement = 56, statInterpolation = { 3, }, cost = { Mana = 40, }, },
		[15] = { 16.666667039196, levelRequirement = 59, statInterpolation = { 3, }, cost = { Mana = 42, }, },
		[16] = { 16.666667039196, levelRequirement = 62, statInterpolation = { 3, }, cost = { Mana = 44, }, },
		[17] = { 16.666667039196, levelRequirement = 64, statInterpolation = { 3, }, cost = { Mana = 46, }, },
		[18] = { 16.666667039196, levelRequirement = 66, statInterpolation = { 3, }, cost = { Mana = 48, }, },
		[19] = { 16.666667039196, levelRequirement = 68, statInterpolation = { 3, }, cost = { Mana = 50, }, },
		[20] = { 16.666667039196, levelRequirement = 70, statInterpolation = { 3, }, cost = { Mana = 51, }, },
		[21] = { 16.666667039196, levelRequirement = 72, statInterpolation = { 3, }, cost = { Mana = 53, }, },
		[22] = { 16.666667039196, levelRequirement = 74, statInterpolation = { 3, }, cost = { Mana = 53, }, },
		[23] = { 16.666667039196, levelRequirement = 76, statInterpolation = { 3, }, cost = { Mana = 54, }, },
		[24] = { 16.666667039196, levelRequirement = 78, statInterpolation = { 3, }, cost = { Mana = 56, }, },
		[25] = { 16.666667039196, levelRequirement = 80, statInterpolation = { 3, }, cost = { Mana = 58, }, },
		[26] = { 16.666667039196, levelRequirement = 82, statInterpolation = { 3, }, cost = { Mana = 59, }, },
		[27] = { 16.666667039196, levelRequirement = 84, statInterpolation = { 3, }, cost = { Mana = 59, }, },
		[28] = { 16.666667039196, levelRequirement = 86, statInterpolation = { 3, }, cost = { Mana = 61, }, },
		[29] = { 16.666667039196, levelRequirement = 88, statInterpolation = { 3, }, cost = { Mana = 62, }, },
		[30] = { 16.666667039196, levelRequirement = 90, statInterpolation = { 3, }, cost = { Mana = 62, }, },
		[31] = { 16.666667039196, levelRequirement = 91, statInterpolation = { 3, }, cost = { Mana = 63, }, },
		[32] = { 16.666667039196, levelRequirement = 92, statInterpolation = { 3, }, cost = { Mana = 64, }, },
		[33] = { 16.666667039196, levelRequirement = 93, statInterpolation = { 3, }, cost = { Mana = 65, }, },
		[34] = { 16.666667039196, levelRequirement = 94, statInterpolation = { 3, }, cost = { Mana = 65, }, },
		[35] = { 16.666667039196, levelRequirement = 95, statInterpolation = { 3, }, cost = { Mana = 66, }, },
		[36] = { 16.666667039196, levelRequirement = 96, statInterpolation = { 3, }, cost = { Mana = 67, }, },
		[37] = { 16.666667039196, levelRequirement = 97, statInterpolation = { 3, }, cost = { Mana = 67, }, },
		[38] = { 16.666667039196, levelRequirement = 98, statInterpolation = { 3, }, cost = { Mana = 68, }, },
		[39] = { 16.666667039196, levelRequirement = 99, statInterpolation = { 3, }, cost = { Mana = 69, }, },
		[40] = { 16.666667039196, levelRequirement = 100, statInterpolation = { 3, }, cost = { Mana = 70, }, },
	},
}
skills["SeismicCry"] = {
	name = "Seismic Cry",
	baseTypeName = "Seismic Cry",
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent slam attacks. The user and nearby allies gain a buff that increases their armour and stun threshold.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("SeismicExertedAttacks", "BASE", nil),
		},
		["seismic_cry_base_slam_skill_area_+%_final"] = {
			mod("SeismicAoEMoreMultiplier", "BASE", nil),
		},
		["seismic_cry_stun_threshold_+%_per_5_power_up_to_cap"] = {
			mod("StunThreshold", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
		},
		["seismic_cry_armour_+%_final_per_5_power_up_to_cap"] = {
			mod("Armour", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
		},
		["skill_empower_limitation_specifier_for_stat_description"] = {
			-- Display only
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_empowers_next_x_melee_attacks", 6 },
		{ "seismic_cry_armour_+%_final_per_5_power_up_to_cap", 5 },
		{ "seismic_cry_stun_threshold_+%_per_5_power_up_to_cap", 15 },
		{ "seismic_cry_base_slam_skill_area_+%_final", 50 },
		{ "skill_empower_limitation_specifier_for_stat_description", 2 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"warcries_knock_back_enemies",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"active_skill_200%_increased_knockback_distance",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["ShieldCharge"] = {
	name = "Shield Charge",
	baseTypeName = "Shield Charge",
	color = 1,
	baseEffectiveness = 2.0499999523163,
	incrementalEffectiveness = 0.024599999189377,
	description = "Charges at a targeted location or enemy, pushing away enemies in your path and repeatedly dealing off-hand damage in a small area in front of you. You deal damage in a larger area when you reach the target. The further you travel, the more damage you deal, and the greater your chance of stunning enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RequiresShield] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		shieldAttack = true,
	},
	baseMods = {
		skill("radius", 28),
		skill("radiusLabel", "End Cone area:"),
		skill("radiusSecondary", 16),
		skill("radiusSecondaryLabel", "End Circle area:"),
		skill("radiusTertiary", 8),
		skill("radiusTertiaryLabel", "Charging area:"),
	},
	qualityStats = {
		Default = {
			{ "base_movement_velocity_+%", 1 },
		},
	},
	constantStats = {
		{ "shield_charge_scaling_stun_threshold_reduction_+%_at_maximum_range", 75 },
		{ "shield_charge_damage_+%_maximum", 100 },
	},
	stats = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
		"base_movement_velocity_+%",
		"off_hand_minimum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"off_hand_maximum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"ignores_proximity_shield",
		"is_area_damage",
		"shield_charge_attack_time_+30%_if_no_charge",
		"attack_is_melee_override",
	},
	notMinionStat = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 90, 3, 5, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 91, 3, 5, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 6, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 92, 4, 6, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 93, 4, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 94, 5, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 95, 5, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 96, 5, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 97, 5, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 98, 5, 7, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 99, 5, 8, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 100, 5, 8, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 101, 6, 9, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 102, 6, 9, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 103, 6, 9, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 104, 6, 10, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 55, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 105, 6, 10, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 106, 7, 11, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 107, 7, 12, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 108, 8, 12, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 109, 8, 12, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 110, 8, 13, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 111, 9, 14, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 112, 9, 14, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 113, 10, 15, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 114, 10, 15, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 115, 10, 15, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 116, 10, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 117, 10, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 118, 11, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 119, 11, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 119, 11, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 120, 12, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 120, 12, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 121, 12, 16, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 121, 13, 17, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 122, 13, 17, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 122, 13, 17, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 123, 13, 17, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 123, 13, 17, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 124, 14, 18, PvPDamageMultiplier = -30, attackTime = 500, critChance = 5, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
	},
}
skills["ShieldCrush"] = {
	name = "Shield Crush",
	baseTypeName = "Shield Crush",
	color = 1,
	baseEffectiveness = 1.3899999856949,
	incrementalEffectiveness = 0.032999999821186,
	description = "Swipe your shield, dealing area damage in three waves in front of you. Enemies can be hit by two of the waves where they overlap.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RequiresShield] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Wave",
		},
		{
			name = "2 Overlapping Waves",
		},
	},
	statMap = {
		["shield_crush_damage_+%_final_from_distance"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "MeleeProximity", ramp = {1,0} }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		shieldAttack = true,
	},
	baseMods = {
		skill("radius", 29),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "shield_crush_damage_+%_final_from_distance", 0.5 },
		},
	},
	stats = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
		"off_hand_minimum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"off_hand_maximum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"active_skill_base_radius_+",
		"is_area_damage",
		"attack_is_melee_override",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 3, 5, 0, attackTime = 800, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 3, 5, 0, attackTime = 800, critChance = 5, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 3, 5, 1, attackTime = 800, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 5, 7, 1, attackTime = 800, critChance = 5, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 5, 7, 1, attackTime = 800, critChance = 5, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 5, 7, 2, attackTime = 800, critChance = 5, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 5, 7, 2, attackTime = 800, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 5, 7, 2, attackTime = 800, critChance = 5, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 5, 7, 3, attackTime = 800, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 5, 8, 3, attackTime = 800, critChance = 5, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 5, 8, 3, attackTime = 800, critChance = 5, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 6, 9, 4, attackTime = 800, critChance = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 6, 9, 4, attackTime = 800, critChance = 5, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 6, 9, 4, attackTime = 800, critChance = 5, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 6, 9, 5, attackTime = 800, critChance = 5, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 6, 9, 5, attackTime = 800, critChance = 5, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 6, 9, 5, attackTime = 800, critChance = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 8, 12, 6, attackTime = 800, critChance = 5, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 8, 12, 6, attackTime = 800, critChance = 5, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 8, 12, 6, attackTime = 800, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 8, 12, 7, attackTime = 800, critChance = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 8, 12, 7, attackTime = 800, critChance = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 8, 12, 7, attackTime = 800, critChance = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 10, 15, 8, attackTime = 800, critChance = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 10, 15, 8, attackTime = 800, critChance = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 10, 15, 8, attackTime = 800, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 10, 15, 9, attackTime = 800, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 10, 16, 9, attackTime = 800, critChance = 5, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 11, 16, 9, attackTime = 800, critChance = 5, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 11, 16, 10, attackTime = 800, critChance = 5, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 11, 16, 10, attackTime = 800, critChance = 5, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 11, 16, 10, attackTime = 800, critChance = 5, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 11, 17, 10, attackTime = 800, critChance = 5, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 13, 19, 10, attackTime = 800, critChance = 5, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 13, 19, 10, attackTime = 800, critChance = 5, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 13, 20, 11, attackTime = 800, critChance = 5, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 13, 20, 11, attackTime = 800, critChance = 5, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 13, 20, 11, attackTime = 800, critChance = 5, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 14, 20, 11, attackTime = 800, critChance = 5, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 14, 21, 11, attackTime = 800, critChance = 5, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 15, }, },
	},
}
skills["ShieldCrushAltX"] = {
	name = "Shield Crush of the Chieftain",
	baseTypeName = "Shield Crush of the Chieftain",
	color = 1,
	baseEffectiveness = 1.7999999523163,
	incrementalEffectiveness = 0.032999999821186,
	description = "Swipe your shield, dealing area damage in three waves in front of you. Enemies can be hit by two of the waves where they overlap.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RequiresShield] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Wave",
		},
		{
			name = "2 Overlapping Waves",
		},
	},
	statMap = {
		["shield_crush_damage_+%_final_from_distance"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "MeleeProximity", ramp = {1,0} }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		shieldAttack = true,
	},
	baseMods = {
		skill("radius", 29),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "shield_crush_helmet_enchantment_aoe_+%_final", 2 },
		},
	},
	stats = {
		"off_hand_local_minimum_added_fire_damage",
		"off_hand_local_maximum_added_fire_damage",
		"off_hand_minimum_added_fire_damage_per_15_shield_armour",
		"off_hand_maximum_added_fire_damage_per_15_shield_armour",
		"shield_crush_helmet_enchantment_aoe_+%_final",
		"is_area_damage",
		"attack_is_melee_override",
		"console_skill_dont_chase",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 8, 12, 50, attackTime = 900, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 8, 12, 52, attackTime = 900, critChance = 5, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 8, 13, 54, attackTime = 900, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 9, 13, 56, attackTime = 900, critChance = 5, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 9, 14, 58, attackTime = 900, critChance = 5, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 10, 14, 60, attackTime = 900, critChance = 5, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 10, 15, 62, attackTime = 900, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 11, 16, 64, attackTime = 900, critChance = 5, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 11, 17, 66, attackTime = 900, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 12, 17, 68, attackTime = 900, critChance = 5, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 12, 18, 70, attackTime = 900, critChance = 5, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 13, 18, 72, attackTime = 900, critChance = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 9, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 13, 19, 74, attackTime = 900, critChance = 5, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 13, 20, 76, attackTime = 900, critChance = 5, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 10, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 14, 21, 78, attackTime = 900, critChance = 5, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 15, 22, 80, attackTime = 900, critChance = 5, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 15, 23, 82, attackTime = 900, critChance = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 11, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 16, 23, 84, attackTime = 900, critChance = 5, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 16, 24, 86, attackTime = 900, critChance = 5, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 16, 24, 88, attackTime = 900, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 16, 25, 90, attackTime = 900, critChance = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 17, 25, 92, attackTime = 900, critChance = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 17, 26, 94, attackTime = 900, critChance = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 18, 26, 96, attackTime = 900, critChance = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 19, 28, 98, attackTime = 900, critChance = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 12, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 19, 29, 100, attackTime = 900, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 19, 29, 102, attackTime = 900, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 20, 30, 104, attackTime = 900, critChance = 5, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 20, 30, 106, attackTime = 900, critChance = 5, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 21, 31, 108, attackTime = 900, critChance = 5, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 13, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 22, 31, 109, attackTime = 900, critChance = 5, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 22, 31, 110, attackTime = 900, critChance = 5, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 22, 32, 111, attackTime = 900, critChance = 5, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 22, 32, 112, attackTime = 900, critChance = 5, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 22, 32, 113, attackTime = 900, critChance = 5, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 23, 32, 114, attackTime = 900, critChance = 5, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 23, 33, 115, attackTime = 900, critChance = 5, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 24, 33, 116, attackTime = 900, critChance = 5, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 24, 34, 117, attackTime = 900, critChance = 5, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 24, 34, 118, attackTime = 900, critChance = 5, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 14, }, },
	},
}
skills["ShockwaveTotem"] = {
	name = "Shockwave Totem",
	baseTypeName = "Shockwave Totem",
	color = 1,
	baseEffectiveness = 1.0778000354767,
	incrementalEffectiveness = 0.043600000441074,
	description = "Summons a totem that shakes the earth around it, knocking back and damaging nearby enemies",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Multicastable] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 5,
	castTime = 0.6,
	baseFlags = {
		spell = true,
		totem = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.1 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 8000 },
		{ "base_totem_range", 80 },
		{ "base_global_chance_to_knockback_%", 25 },
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_totem",
		"is_area_damage",
		"base_skill_is_totemified",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.3999999761581, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[2] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[3] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[4] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[5] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[6] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[7] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[8] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[9] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[10] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[11] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[12] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[13] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[14] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[15] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 35, }, },
		[16] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 36, }, },
		[17] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 37, }, },
		[18] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 38, }, },
		[19] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 39, }, },
		[20] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 39, }, },
		[21] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 40, }, },
		[22] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 41, }, },
		[23] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 42, }, },
		[24] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 43, }, },
		[25] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 44, }, },
		[26] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 45, }, },
		[27] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 46, }, },
		[28] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 46, }, },
		[29] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 47, }, },
		[30] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 48, }, },
		[31] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[32] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[33] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 49, }, },
		[34] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 50, }, },
		[35] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 50, }, },
		[36] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 51, }, },
		[37] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 51, }, },
		[38] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
		[39] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
		[40] = { 0.69999998807907, 1.2999999523163, critChance = 5, damageEffectiveness = 1.1, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 52, }, },
	},
}
skills["Smite"] = {
	name = "Smite",
	baseTypeName = "Smite",
	color = 1,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.028000000864267,
	description = "Performs a melee attack, and causes lightning to strike a nearby enemy, dealing damage in an area. Each target can only be hit once by this skill. Hitting an enemy grants an aura for a duration. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Damage] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Aura] = true, [SkillType.Buff] = true, [SkillType.Lightning] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			area = false,
		},
		{
			name = "Area Hit",
			area = true,
			melee = false,
		},
	},
	statMap = {
		["base_chance_to_shock_%_from_skill"] = {
			mod("EnemyShockChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", neg = true, var = "AffectedByVaalSmite" }),
		},
		["minimum_added_lightning_damage_from_skill"] = {
			mod("LightningMin", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", neg = true, var = "AffectedByVaalSmite" }),
		},
		["maximum_added_lightning_damage_from_skill"] = {
			mod("LightningMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", neg = true, var = "AffectedByVaalSmite" }),
		},
		["quality_display_active_skill_area_damage_quality_negated_from_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "Lightning Strike area:"),
		skill("radiusSecondaryLabel", "Aura area:"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_area_damage_+%_final", 0.5 },
			{ "quality_display_active_skill_area_damage_quality_negated_from_gem", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_skill_effect_duration", 4000 },
		{ "base_smite_number_of_targets", 1 },
		{ "smite_lightning_target_range", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "active_skill_base_secondary_area_of_effect_radius", 36 },
		{ "active_skill_secondary_area_of_effect_description_mode", 4 },
	},
	stats = {
		"minimum_added_lightning_damage_from_skill",
		"maximum_added_lightning_damage_from_skill",
		"base_chance_to_shock_%_from_skill",
		"active_skill_base_area_of_effect_radius",
		"active_skill_base_secondary_area_of_effect_radius",
		"active_skill_area_damage_+%_final",
		"visual_hit_effect_elemental_is_holy",
		"console_skill_dont_chase",
		"quality_display_active_skill_area_damage_is_gem",
	},
	notMinionStat = {
		"active_skill_area_damage_+%_final",
	},
	levels = {
		[1] = { 0.10000000149012, 1.8999999761581, 10, 0, 0, -30, attackSpeedMultiplier = -15, baseMultiplier = 2.254, damageEffectiveness = 2.254, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0.10000000149012, 1.8999999761581, 10, 0, 0, -29, attackSpeedMultiplier = -15, baseMultiplier = 2.337, damageEffectiveness = 2.337, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.10000000149012, 1.8999999761581, 11, 1, 1, -29, attackSpeedMultiplier = -15, baseMultiplier = 2.428, damageEffectiveness = 2.428, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.10000000149012, 1.8999999761581, 11, 1, 1, -28, attackSpeedMultiplier = -15, baseMultiplier = 2.527, damageEffectiveness = 2.527, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.10000000149012, 1.8999999761581, 12, 1, 1, -28, attackSpeedMultiplier = -15, baseMultiplier = 2.635, damageEffectiveness = 2.635, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.10000000149012, 1.8999999761581, 12, 2, 2, -27, attackSpeedMultiplier = -15, baseMultiplier = 2.751, damageEffectiveness = 2.751, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.10000000149012, 1.8999999761581, 13, 2, 2, -27, attackSpeedMultiplier = -15, baseMultiplier = 2.868, damageEffectiveness = 2.868, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 0.10000000149012, 1.8999999761581, 13, 2, 2, -26, attackSpeedMultiplier = -15, baseMultiplier = 2.99, damageEffectiveness = 2.99, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 0.10000000149012, 1.8999999761581, 14, 3, 3, -26, attackSpeedMultiplier = -15, baseMultiplier = 3.116, damageEffectiveness = 3.116, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 0.10000000149012, 1.8999999761581, 14, 3, 3, -25, attackSpeedMultiplier = -15, baseMultiplier = 3.248, damageEffectiveness = 3.248, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[11] = { 0.10000000149012, 1.8999999761581, 15, 3, 3, -25, attackSpeedMultiplier = -15, baseMultiplier = 3.385, damageEffectiveness = 3.385, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 0.10000000149012, 1.8999999761581, 15, 4, 4, -24, attackSpeedMultiplier = -15, baseMultiplier = 3.528, damageEffectiveness = 3.528, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[13] = { 0.10000000149012, 1.8999999761581, 16, 4, 4, -24, attackSpeedMultiplier = -15, baseMultiplier = 3.677, damageEffectiveness = 3.677, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[14] = { 0.10000000149012, 1.8999999761581, 16, 4, 4, -23, attackSpeedMultiplier = -15, baseMultiplier = 3.831, damageEffectiveness = 3.831, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[15] = { 0.10000000149012, 1.8999999761581, 17, 5, 5, -23, attackSpeedMultiplier = -15, baseMultiplier = 3.993, damageEffectiveness = 3.993, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[16] = { 0.10000000149012, 1.8999999761581, 17, 5, 5, -22, attackSpeedMultiplier = -15, baseMultiplier = 4.16, damageEffectiveness = 4.16, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[17] = { 0.10000000149012, 1.8999999761581, 18, 5, 5, -22, attackSpeedMultiplier = -15, baseMultiplier = 4.335, damageEffectiveness = 4.335, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[18] = { 0.10000000149012, 1.8999999761581, 18, 6, 6, -21, attackSpeedMultiplier = -15, baseMultiplier = 4.516, damageEffectiveness = 4.516, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[19] = { 0.10000000149012, 1.8999999761581, 19, 6, 6, -21, attackSpeedMultiplier = -15, baseMultiplier = 4.698, damageEffectiveness = 4.698, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[20] = { 0.10000000149012, 1.8999999761581, 19, 6, 6, -20, attackSpeedMultiplier = -15, baseMultiplier = 4.886, damageEffectiveness = 4.886, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[21] = { 0.10000000149012, 1.8999999761581, 20, 7, 7, -20, attackSpeedMultiplier = -15, baseMultiplier = 5.074, damageEffectiveness = 5.074, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[22] = { 0.10000000149012, 1.8999999761581, 20, 7, 7, -19, attackSpeedMultiplier = -15, baseMultiplier = 5.269, damageEffectiveness = 5.269, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[23] = { 0.10000000149012, 1.8999999761581, 21, 7, 7, -19, attackSpeedMultiplier = -15, baseMultiplier = 5.471, damageEffectiveness = 5.471, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[24] = { 0.10000000149012, 1.8999999761581, 21, 8, 8, -18, attackSpeedMultiplier = -15, baseMultiplier = 5.681, damageEffectiveness = 5.681, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[25] = { 0.10000000149012, 1.8999999761581, 22, 8, 8, -18, attackSpeedMultiplier = -15, baseMultiplier = 5.899, damageEffectiveness = 5.899, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[26] = { 0.10000000149012, 1.8999999761581, 22, 8, 8, -17, attackSpeedMultiplier = -15, baseMultiplier = 6.125, damageEffectiveness = 6.125, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[27] = { 0.10000000149012, 1.8999999761581, 23, 8, 8, -17, attackSpeedMultiplier = -15, baseMultiplier = 6.36, damageEffectiveness = 6.36, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[28] = { 0.10000000149012, 1.8999999761581, 23, 9, 9, -16, attackSpeedMultiplier = -15, baseMultiplier = 6.603, damageEffectiveness = 6.603, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[29] = { 0.10000000149012, 1.8999999761581, 24, 9, 9, -16, attackSpeedMultiplier = -15, baseMultiplier = 6.857, damageEffectiveness = 6.857, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[30] = { 0.10000000149012, 1.8999999761581, 24, 9, 9, -15, attackSpeedMultiplier = -15, baseMultiplier = 7.12, damageEffectiveness = 7.12, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[31] = { 0.10000000149012, 1.8999999761581, 24, 10, 10, -15, attackSpeedMultiplier = -15, baseMultiplier = 7.509, damageEffectiveness = 7.509, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[32] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, -15, attackSpeedMultiplier = -15, baseMultiplier = 7.653, damageEffectiveness = 7.653, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[33] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, -15, attackSpeedMultiplier = -15, baseMultiplier = 7.799, damageEffectiveness = 7.799, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[34] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, -14, attackSpeedMultiplier = -15, baseMultiplier = 7.948, damageEffectiveness = 7.948, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[35] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, -14, attackSpeedMultiplier = -15, baseMultiplier = 8.1, damageEffectiveness = 8.1, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[36] = { 0.10000000149012, 1.8999999761581, 26, 10, 10, -14, attackSpeedMultiplier = -15, baseMultiplier = 8.255, damageEffectiveness = 8.255, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[37] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, -14, attackSpeedMultiplier = -15, baseMultiplier = 8.412, damageEffectiveness = 8.412, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[38] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, -13, attackSpeedMultiplier = -15, baseMultiplier = 8.572, damageEffectiveness = 8.572, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[39] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, -13, attackSpeedMultiplier = -15, baseMultiplier = 8.737, damageEffectiveness = 8.737, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[40] = { 0.10000000149012, 1.8999999761581, 27, 11, 11, -13, attackSpeedMultiplier = -15, baseMultiplier = 8.903, damageEffectiveness = 8.903, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
	},
}
skills["SmiteAltX"] = {
	name = "Smite of Divine Judgement",
	baseTypeName = "Smite of Divine Judgement",
	color = 1,
	description = "Performs a melee attack, and causes lightning to strike nearby enemies, dealing damage in an area. Each target can only be hit once by this skill. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Damage] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Lightning] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			area = false,
		},
		{
			name = "Area Hit",
			area = true,
			melee = false,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "smite_lightning_target_range", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_smite_number_of_targets", 3 },
		{ "smite_lightning_target_range", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"active_skill_area_damage_+%_final",
		"visual_hit_effect_elemental_is_holy",
		"console_skill_dont_chase",
		"quality_display_active_skill_area_damage_is_gem",
	},
	notMinionStat = {
		"active_skill_area_damage_+%_final",
	},
	levels = {
		[1] = { 0, 0, attackSpeedMultiplier = -15, baseMultiplier = 2.013, damageEffectiveness = 2.013, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0, 2, attackSpeedMultiplier = -15, baseMultiplier = 2.069, damageEffectiveness = 2.069, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[3] = { 1, 4, attackSpeedMultiplier = -15, baseMultiplier = 2.131, damageEffectiveness = 2.131, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 1, 6, attackSpeedMultiplier = -15, baseMultiplier = 2.198, damageEffectiveness = 2.198, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 1, 8, attackSpeedMultiplier = -15, baseMultiplier = 2.271, damageEffectiveness = 2.271, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 2, 10, attackSpeedMultiplier = -15, baseMultiplier = 2.351, damageEffectiveness = 2.351, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 2, 12, attackSpeedMultiplier = -15, baseMultiplier = 2.431, damageEffectiveness = 2.431, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 2, 14, attackSpeedMultiplier = -15, baseMultiplier = 2.512, damageEffectiveness = 2.512, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 3, 16, attackSpeedMultiplier = -15, baseMultiplier = 2.594, damageEffectiveness = 2.594, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 3, 18, attackSpeedMultiplier = -15, baseMultiplier = 2.68, damageEffectiveness = 2.68, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[11] = { 3, 20, attackSpeedMultiplier = -15, baseMultiplier = 2.769, damageEffectiveness = 2.769, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 4, 22, attackSpeedMultiplier = -15, baseMultiplier = 2.862, damageEffectiveness = 2.862, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[13] = { 4, 24, attackSpeedMultiplier = -15, baseMultiplier = 2.956, damageEffectiveness = 2.956, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[14] = { 4, 26, attackSpeedMultiplier = -15, baseMultiplier = 3.054, damageEffectiveness = 3.054, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[15] = { 5, 28, attackSpeedMultiplier = -15, baseMultiplier = 3.155, damageEffectiveness = 3.155, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[16] = { 5, 30, attackSpeedMultiplier = -15, baseMultiplier = 3.259, damageEffectiveness = 3.259, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[17] = { 5, 32, attackSpeedMultiplier = -15, baseMultiplier = 3.366, damageEffectiveness = 3.366, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[18] = { 6, 34, attackSpeedMultiplier = -15, baseMultiplier = 3.476, damageEffectiveness = 3.476, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[19] = { 6, 36, attackSpeedMultiplier = -15, baseMultiplier = 3.584, damageEffectiveness = 3.584, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[20] = { 6, 38, attackSpeedMultiplier = -15, baseMultiplier = 3.695, damageEffectiveness = 3.695, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[21] = { 7, 40, attackSpeedMultiplier = -15, baseMultiplier = 3.805, damageEffectiveness = 3.805, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[22] = { 7, 42, attackSpeedMultiplier = -15, baseMultiplier = 3.916, damageEffectiveness = 3.916, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[23] = { 7, 44, attackSpeedMultiplier = -15, baseMultiplier = 4.031, damageEffectiveness = 4.031, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[24] = { 8, 46, attackSpeedMultiplier = -15, baseMultiplier = 4.149, damageEffectiveness = 4.149, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[25] = { 8, 48, attackSpeedMultiplier = -15, baseMultiplier = 4.271, damageEffectiveness = 4.271, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[26] = { 8, 50, attackSpeedMultiplier = -15, baseMultiplier = 4.396, damageEffectiveness = 4.396, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[27] = { 8, 52, attackSpeedMultiplier = -15, baseMultiplier = 4.525, damageEffectiveness = 4.525, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[28] = { 9, 54, attackSpeedMultiplier = -15, baseMultiplier = 4.658, damageEffectiveness = 4.658, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[29] = { 9, 56, attackSpeedMultiplier = -15, baseMultiplier = 4.794, damageEffectiveness = 4.794, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[30] = { 9, 58, attackSpeedMultiplier = -15, baseMultiplier = 4.935, damageEffectiveness = 4.935, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[31] = { 10, 59, attackSpeedMultiplier = -15, baseMultiplier = 5.136, damageEffectiveness = 5.136, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[32] = { 10, 60, attackSpeedMultiplier = -15, baseMultiplier = 5.211, damageEffectiveness = 5.211, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[33] = { 10, 61, attackSpeedMultiplier = -15, baseMultiplier = 5.287, damageEffectiveness = 5.287, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[34] = { 10, 62, attackSpeedMultiplier = -15, baseMultiplier = 5.364, damageEffectiveness = 5.364, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[35] = { 10, 63, attackSpeedMultiplier = -15, baseMultiplier = 5.443, damageEffectiveness = 5.443, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[36] = { 10, 64, attackSpeedMultiplier = -15, baseMultiplier = 5.522, damageEffectiveness = 5.522, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[37] = { 11, 65, attackSpeedMultiplier = -15, baseMultiplier = 5.603, damageEffectiveness = 5.603, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[38] = { 11, 66, attackSpeedMultiplier = -15, baseMultiplier = 5.685, damageEffectiveness = 5.685, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[39] = { 11, 67, attackSpeedMultiplier = -15, baseMultiplier = 5.767, damageEffectiveness = 5.767, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[40] = { 11, 68, attackSpeedMultiplier = -15, baseMultiplier = 5.852, damageEffectiveness = 5.852, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
	},
}
skills["VaalSmite"] = {
	name = "Vaal Smite",
	baseTypeName = "Vaal Smite",
	color = 1,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.028000000864267,
	description = "Calls lightning down to infuse your weapon, then performs a melee attack and causes lightning to strike nearby enemies, dealing damage in an area. Hitting an enemy grants an aura for a duration. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Aura] = true, [SkillType.Buff] = true, [SkillType.Lightning] = true, [SkillType.Vaal] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			area = false,
		},
		{
			name = "Area Hit",
			area = true,
			melee = false,
		},
	},
	statMap = {
		["base_chance_to_shock_%_from_skill"] = {
			mod("EnemyShockChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["minimum_added_lightning_damage_from_skill"] = {
			mod("LightningMin", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["maximum_added_lightning_damage_from_skill"] = {
			mod("LightningMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "Lightning Strike area:"),
		skill("radiusSecondaryLabel", "Aura area:"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_area_damage_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_skill_effect_duration", 8000 },
		{ "base_smite_number_of_targets", 30 },
		{ "buff_grants_smite_additional_lightning_targets", 1 },
		{ "smite_lightning_target_range", 100 },
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "active_skill_base_secondary_area_of_effect_radius", 36 },
		{ "active_skill_secondary_area_of_effect_description_mode", 4 },
	},
	stats = {
		"minimum_added_lightning_damage_from_skill",
		"maximum_added_lightning_damage_from_skill",
		"base_chance_to_shock_%_from_skill",
		"active_skill_base_area_of_effect_radius",
		"active_skill_base_secondary_area_of_effect_radius",
		"visual_hit_effect_elemental_is_holy",
		"console_skill_dont_chase",
		"cannot_cancel_skill_before_contact_point",
		"has_vaal_smite_behaviour",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"global_always_hit",
		"quality_display_active_skill_area_damage_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 0.10000000149012, 1.8999999761581, 10, 0, 0, attackSpeedMultiplier = -50, baseMultiplier = 3.45, damageEffectiveness = 3.45, levelRequirement = 1, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[2] = { 0.10000000149012, 1.8999999761581, 10, 0, 0, attackSpeedMultiplier = -50, baseMultiplier = 3.595, damageEffectiveness = 3.595, levelRequirement = 2, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[3] = { 0.10000000149012, 1.8999999761581, 11, 1, 1, attackSpeedMultiplier = -50, baseMultiplier = 3.746, damageEffectiveness = 3.746, levelRequirement = 4, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[4] = { 0.10000000149012, 1.8999999761581, 11, 1, 1, attackSpeedMultiplier = -50, baseMultiplier = 3.903, damageEffectiveness = 3.903, levelRequirement = 7, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[5] = { 0.10000000149012, 1.8999999761581, 12, 1, 1, attackSpeedMultiplier = -50, baseMultiplier = 4.067, damageEffectiveness = 4.067, levelRequirement = 11, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[6] = { 0.10000000149012, 1.8999999761581, 12, 2, 2, attackSpeedMultiplier = -50, baseMultiplier = 4.238, damageEffectiveness = 4.238, levelRequirement = 16, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[7] = { 0.10000000149012, 1.8999999761581, 13, 2, 2, attackSpeedMultiplier = -50, baseMultiplier = 4.416, damageEffectiveness = 4.416, levelRequirement = 20, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[8] = { 0.10000000149012, 1.8999999761581, 13, 2, 2, attackSpeedMultiplier = -50, baseMultiplier = 4.601, damageEffectiveness = 4.601, levelRequirement = 24, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[9] = { 0.10000000149012, 1.8999999761581, 14, 3, 3, attackSpeedMultiplier = -50, baseMultiplier = 4.795, damageEffectiveness = 4.795, levelRequirement = 28, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[10] = { 0.10000000149012, 1.8999999761581, 14, 3, 3, attackSpeedMultiplier = -50, baseMultiplier = 4.996, damageEffectiveness = 4.996, levelRequirement = 32, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[11] = { 0.10000000149012, 1.8999999761581, 15, 3, 3, attackSpeedMultiplier = -50, baseMultiplier = 5.206, damageEffectiveness = 5.206, levelRequirement = 36, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[12] = { 0.10000000149012, 1.8999999761581, 15, 4, 4, attackSpeedMultiplier = -50, baseMultiplier = 5.425, damageEffectiveness = 5.425, levelRequirement = 40, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[13] = { 0.10000000149012, 1.8999999761581, 16, 4, 4, attackSpeedMultiplier = -50, baseMultiplier = 5.652, damageEffectiveness = 5.652, levelRequirement = 44, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[14] = { 0.10000000149012, 1.8999999761581, 16, 4, 4, attackSpeedMultiplier = -50, baseMultiplier = 5.89, damageEffectiveness = 5.89, levelRequirement = 48, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[15] = { 0.10000000149012, 1.8999999761581, 17, 5, 5, attackSpeedMultiplier = -50, baseMultiplier = 6.137, damageEffectiveness = 6.137, levelRequirement = 52, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[16] = { 0.10000000149012, 1.8999999761581, 17, 5, 5, attackSpeedMultiplier = -50, baseMultiplier = 6.395, damageEffectiveness = 6.395, levelRequirement = 56, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[17] = { 0.10000000149012, 1.8999999761581, 18, 5, 5, attackSpeedMultiplier = -50, baseMultiplier = 6.664, damageEffectiveness = 6.664, levelRequirement = 60, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[18] = { 0.10000000149012, 1.8999999761581, 18, 6, 6, attackSpeedMultiplier = -50, baseMultiplier = 6.943, damageEffectiveness = 6.943, levelRequirement = 64, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[19] = { 0.10000000149012, 1.8999999761581, 19, 6, 6, attackSpeedMultiplier = -50, baseMultiplier = 7.235, damageEffectiveness = 7.235, levelRequirement = 67, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[20] = { 0.10000000149012, 1.8999999761581, 19, 6, 6, attackSpeedMultiplier = -50, baseMultiplier = 7.539, damageEffectiveness = 7.539, levelRequirement = 70, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[21] = { 0.10000000149012, 1.8999999761581, 20, 7, 7, attackSpeedMultiplier = -50, baseMultiplier = 7.855, damageEffectiveness = 7.855, levelRequirement = 72, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[22] = { 0.10000000149012, 1.8999999761581, 20, 7, 7, attackSpeedMultiplier = -50, baseMultiplier = 8.185, damageEffectiveness = 8.185, levelRequirement = 74, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[23] = { 0.10000000149012, 1.8999999761581, 21, 7, 7, attackSpeedMultiplier = -50, baseMultiplier = 8.529, damageEffectiveness = 8.529, levelRequirement = 76, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[24] = { 0.10000000149012, 1.8999999761581, 21, 8, 8, attackSpeedMultiplier = -50, baseMultiplier = 8.887, damageEffectiveness = 8.887, levelRequirement = 78, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[25] = { 0.10000000149012, 1.8999999761581, 22, 8, 8, attackSpeedMultiplier = -50, baseMultiplier = 9.261, damageEffectiveness = 9.261, levelRequirement = 80, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[26] = { 0.10000000149012, 1.8999999761581, 22, 8, 8, attackSpeedMultiplier = -50, baseMultiplier = 9.65, damageEffectiveness = 9.65, levelRequirement = 82, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[27] = { 0.10000000149012, 1.8999999761581, 23, 8, 8, attackSpeedMultiplier = -50, baseMultiplier = 10.055, damageEffectiveness = 10.055, levelRequirement = 84, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[28] = { 0.10000000149012, 1.8999999761581, 23, 9, 9, attackSpeedMultiplier = -50, baseMultiplier = 10.477, damageEffectiveness = 10.477, levelRequirement = 86, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[29] = { 0.10000000149012, 1.8999999761581, 24, 9, 9, attackSpeedMultiplier = -50, baseMultiplier = 10.917, damageEffectiveness = 10.917, levelRequirement = 88, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[30] = { 0.10000000149012, 1.8999999761581, 24, 9, 9, attackSpeedMultiplier = -50, baseMultiplier = 11.376, damageEffectiveness = 11.376, levelRequirement = 90, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[31] = { 0.10000000149012, 1.8999999761581, 24, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 12.103, damageEffectiveness = 12.103, levelRequirement = 91, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[32] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 12.357, damageEffectiveness = 12.357, levelRequirement = 92, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[33] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 12.616, damageEffectiveness = 12.616, levelRequirement = 93, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[34] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 12.881, damageEffectiveness = 12.881, levelRequirement = 94, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[35] = { 0.10000000149012, 1.8999999761581, 25, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 13.152, damageEffectiveness = 13.152, levelRequirement = 95, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[36] = { 0.10000000149012, 1.8999999761581, 26, 10, 10, attackSpeedMultiplier = -50, baseMultiplier = 13.428, damageEffectiveness = 13.428, levelRequirement = 96, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[37] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, attackSpeedMultiplier = -50, baseMultiplier = 13.71, damageEffectiveness = 13.71, levelRequirement = 97, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[38] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, attackSpeedMultiplier = -50, baseMultiplier = 13.998, damageEffectiveness = 13.998, levelRequirement = 98, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[39] = { 0.10000000149012, 1.8999999761581, 26, 11, 11, attackSpeedMultiplier = -50, baseMultiplier = 14.292, damageEffectiveness = 14.292, levelRequirement = 99, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
		[40] = { 0.10000000149012, 1.8999999761581, 27, 11, 11, attackSpeedMultiplier = -50, baseMultiplier = 14.592, damageEffectiveness = 14.592, levelRequirement = 100, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Soul = 20, }, },
	},
}
skills["StaticStrike"] = {
	name = "Static Strike",
	baseTypeName = "Static Strike",
	color = 1,
	description = "Attack with a melee weapon, gaining static energy for a duration if you hit an enemy. While you have static energy, you'll frequently hit a number of nearby enemies with beams, dealing attack damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Lightning] = true, [SkillType.Chains] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.hitTimeOverride = activeSkill.skillData.repeatFrequency / (1 + activeSkill.skillModList:Sum("INC", activeSkill.skillCfg, "StaticStrikeFrequency") / 100)
		end
	end,
	parts = {
		{
			name = "Melee hit",
			chaining = false,
		},
		{
			name = "Beams",
			chaining = true,
		}
	},
	statMap = {
		["static_strike_beam_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2}),
		},
		["static_strike_base_zap_frequency_ms"] = {
			skill("repeatFrequency", nil),
			div = 1000,
		},
		["static_strike_zap_speed_+%"] = {
			mod("StaticStrikeFrequency", "INC", nil),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 20),
	},
	qualityStats = {
		Default = {
			{ "static_strike_zap_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "number_of_chains", 1 },
		{ "static_strike_beam_damage_+%_final", -40 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"static_strike_base_zap_frequency_ms",
		"static_strike_number_of_beam_targets",
	},
	levels = {
		[1] = { 400, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.506, damageEffectiveness = 1.506, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 400, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.574, damageEffectiveness = 1.574, levelRequirement = 15, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 390, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.647, damageEffectiveness = 1.647, levelRequirement = 19, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 390, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.723, damageEffectiveness = 1.723, levelRequirement = 23, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 380, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.805, damageEffectiveness = 1.805, levelRequirement = 27, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 380, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.888, damageEffectiveness = 1.888, levelRequirement = 31, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 380, 4, PvPDamageMultiplier = -20, baseMultiplier = 1.976, damageEffectiveness = 1.976, levelRequirement = 35, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 370, 4, PvPDamageMultiplier = -20, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 38, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 370, 4, PvPDamageMultiplier = -20, baseMultiplier = 2.157, damageEffectiveness = 2.157, levelRequirement = 41, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[10] = { 360, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.253, damageEffectiveness = 2.253, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 360, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.354, damageEffectiveness = 2.354, levelRequirement = 47, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 360, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[13] = { 350, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.568, damageEffectiveness = 2.568, levelRequirement = 53, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[14] = { 350, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.683, damageEffectiveness = 2.683, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[15] = { 340, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.801, damageEffectiveness = 2.801, levelRequirement = 59, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[16] = { 340, 5, PvPDamageMultiplier = -20, baseMultiplier = 2.927, damageEffectiveness = 2.927, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[17] = { 340, 5, PvPDamageMultiplier = -20, baseMultiplier = 3.052, damageEffectiveness = 3.052, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[18] = { 330, 5, PvPDamageMultiplier = -20, baseMultiplier = 3.182, damageEffectiveness = 3.182, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[19] = { 330, 5, PvPDamageMultiplier = -20, baseMultiplier = 3.318, damageEffectiveness = 3.318, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[20] = { 320, 6, PvPDamageMultiplier = -20, baseMultiplier = 3.46, damageEffectiveness = 3.46, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[21] = { 320, 6, PvPDamageMultiplier = -20, baseMultiplier = 3.607, damageEffectiveness = 3.607, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[22] = { 320, 6, PvPDamageMultiplier = -20, baseMultiplier = 3.762, damageEffectiveness = 3.762, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[23] = { 310, 6, PvPDamageMultiplier = -20, baseMultiplier = 3.922, damageEffectiveness = 3.922, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[24] = { 310, 6, PvPDamageMultiplier = -20, baseMultiplier = 4.089, damageEffectiveness = 4.089, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 300, 6, PvPDamageMultiplier = -20, baseMultiplier = 4.264, damageEffectiveness = 4.264, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[26] = { 300, 6, PvPDamageMultiplier = -20, baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[27] = { 300, 6, PvPDamageMultiplier = -20, baseMultiplier = 4.634, damageEffectiveness = 4.634, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[28] = { 290, 6, PvPDamageMultiplier = -20, baseMultiplier = 4.832, damageEffectiveness = 4.832, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[29] = { 290, 6, PvPDamageMultiplier = -20, baseMultiplier = 5.037, damageEffectiveness = 5.037, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[30] = { 280, 7, PvPDamageMultiplier = -20, baseMultiplier = 5.251, damageEffectiveness = 5.251, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[31] = { 280, 7, PvPDamageMultiplier = -20, baseMultiplier = 5.575, damageEffectiveness = 5.575, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[32] = { 280, 7, PvPDamageMultiplier = -20, baseMultiplier = 5.692, damageEffectiveness = 5.692, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[33] = { 280, 7, PvPDamageMultiplier = -20, baseMultiplier = 5.814, damageEffectiveness = 5.814, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[34] = { 280, 7, PvPDamageMultiplier = -20, baseMultiplier = 5.938, damageEffectiveness = 5.938, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[35] = { 270, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.063, damageEffectiveness = 6.063, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[36] = { 270, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.193, damageEffectiveness = 6.193, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[37] = { 270, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.324, damageEffectiveness = 6.324, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[38] = { 270, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.457, damageEffectiveness = 6.457, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[39] = { 270, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.595, damageEffectiveness = 6.595, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[40] = { 260, 7, PvPDamageMultiplier = -20, baseMultiplier = 6.736, damageEffectiveness = 6.736, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
	},
}
skills["Swordstorm"] = {
	name = "Swordstorm",
	baseTypeName = "Swordstorm",
	color = 1,
	description = "Retaliate against a blocked hit with a hail of blades that rains down in front of you, repeatedly dealing the damage of both your weapons combined. Requires Dual Wielding Melee Weapons.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cooldown] = true, [SkillType.DualWieldOnly] = true, [SkillType.Retaliation] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["swordstorm_num_hits"] = {
			skill("dpsMultiplier", nil)
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("doubleHitsWhenDualWielding", true),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "retaliation_base_use_window_duration_ms", 2000 },
		{ "swordstorm_num_hits", 8 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
		"global_always_hit",
		"is_area_damage",
		"skill_cannot_be_exerted",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 18, baseMultiplier = 1.239, cooldown = 3, damageEffectiveness = 1.239, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 18, baseMultiplier = 1.285, cooldown = 3, damageEffectiveness = 1.285, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 19, baseMultiplier = 1.332, cooldown = 3, damageEffectiveness = 1.332, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 19, baseMultiplier = 1.381, cooldown = 3, damageEffectiveness = 1.381, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 19, baseMultiplier = 1.433, cooldown = 3, damageEffectiveness = 1.433, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 19, baseMultiplier = 1.486, cooldown = 3, damageEffectiveness = 1.486, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 20, baseMultiplier = 1.541, cooldown = 3, damageEffectiveness = 1.541, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 20, baseMultiplier = 1.598, cooldown = 3, damageEffectiveness = 1.598, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 20, baseMultiplier = 1.657, cooldown = 3, damageEffectiveness = 1.657, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 20, baseMultiplier = 1.718, cooldown = 3, damageEffectiveness = 1.718, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 21, baseMultiplier = 1.782, cooldown = 3, damageEffectiveness = 1.782, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 21, baseMultiplier = 1.847, cooldown = 3, damageEffectiveness = 1.847, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 21, baseMultiplier = 1.916, cooldown = 3, damageEffectiveness = 1.916, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 21, baseMultiplier = 1.987, cooldown = 3, damageEffectiveness = 1.987, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 22, baseMultiplier = 2.06, cooldown = 3, damageEffectiveness = 2.06, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 22, baseMultiplier = 2.136, cooldown = 3, damageEffectiveness = 2.136, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 22, baseMultiplier = 2.215, cooldown = 3, damageEffectiveness = 2.215, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 22, baseMultiplier = 2.297, cooldown = 3, damageEffectiveness = 2.297, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 23, baseMultiplier = 2.382, cooldown = 3, damageEffectiveness = 2.382, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 23, baseMultiplier = 2.471, cooldown = 3, damageEffectiveness = 2.471, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 23, baseMultiplier = 2.562, cooldown = 3, damageEffectiveness = 2.562, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 24, baseMultiplier = 2.657, cooldown = 3, damageEffectiveness = 2.657, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 24, baseMultiplier = 2.755, cooldown = 3, damageEffectiveness = 2.755, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 24, baseMultiplier = 2.857, cooldown = 3, damageEffectiveness = 2.857, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 24, baseMultiplier = 2.963, cooldown = 3, damageEffectiveness = 2.963, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 25, baseMultiplier = 3.072, cooldown = 3, damageEffectiveness = 3.072, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 25, baseMultiplier = 3.186, cooldown = 3, damageEffectiveness = 3.186, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 25, baseMultiplier = 3.304, cooldown = 3, damageEffectiveness = 3.304, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 25, baseMultiplier = 3.426, cooldown = 3, damageEffectiveness = 3.426, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 26, baseMultiplier = 3.553, cooldown = 3, damageEffectiveness = 3.553, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 26, baseMultiplier = 3.753, cooldown = 3, damageEffectiveness = 3.753, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 26, baseMultiplier = 3.822, cooldown = 3, damageEffectiveness = 3.822, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 26, baseMultiplier = 3.893, cooldown = 3, damageEffectiveness = 3.893, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 26, baseMultiplier = 3.965, cooldown = 3, damageEffectiveness = 3.965, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 26, baseMultiplier = 4.038, cooldown = 3, damageEffectiveness = 4.038, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 26, baseMultiplier = 4.113, cooldown = 3, damageEffectiveness = 4.113, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 27, baseMultiplier = 4.189, cooldown = 3, damageEffectiveness = 4.189, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 27, baseMultiplier = 4.266, cooldown = 3, damageEffectiveness = 4.266, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 27, baseMultiplier = 4.345, cooldown = 3, damageEffectiveness = 4.345, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 27, baseMultiplier = 4.426, cooldown = 3, damageEffectiveness = 4.426, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["QuickGuard"] = {
	name = "Steelskin",
	baseTypeName = "Steelskin",
	color = 1,
	baseEffectiveness = 10,
	incrementalEffectiveness = 0.029999999329448,
	description = "Applies a buff which can take some of the damage from hits for you before being depleted. Shares a cooldown with other Guard skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Guard] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["quick_guard_damage_absorbed_%"] = {
			mod("GuardAbsorbRate", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["quick_guard_damage_absorb_limit"] = {
			mod("GuardAbsorbLimit", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		mod("AvoidBleed", "BASE", 100, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	constantStats = {
		{ "quick_guard_damage_absorbed_%", 70 },
		{ "base_skill_effect_duration", 1500 },
	},
	stats = {
		"quick_guard_damage_absorb_limit",
		"base_deal_no_damage",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"display_skill_buff_grants_bleeding_immunity",
	},
	levels = {
		[1] = { 1, cooldown = 3, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 4, }, },
		[2] = { 1, cooldown = 3, levelRequirement = 6, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 5, }, },
		[3] = { 1, cooldown = 3, levelRequirement = 9, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 5, }, },
		[4] = { 1, cooldown = 3, levelRequirement = 12, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 6, }, },
		[5] = { 1, cooldown = 3, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 7, }, },
		[6] = { 1, cooldown = 3, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 7, }, },
		[7] = { 1, cooldown = 3, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 8, }, },
		[8] = { 1, cooldown = 3, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 9, }, },
		[9] = { 1, cooldown = 3, levelRequirement = 32, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[10] = { 1, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[11] = { 1, cooldown = 3, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[12] = { 1, cooldown = 3, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[13] = { 1, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[14] = { 1, cooldown = 3, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[15] = { 1, cooldown = 3, levelRequirement = 55, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[16] = { 1, cooldown = 3, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[17] = { 1, cooldown = 3, levelRequirement = 61, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[18] = { 1, cooldown = 3, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[19] = { 1, cooldown = 3, levelRequirement = 67, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 16, }, },
		[20] = { 1, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 16, }, },
		[21] = { 1, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 17, }, },
		[22] = { 1, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 17, }, },
		[23] = { 1, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 18, }, },
		[24] = { 1, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 18, }, },
		[25] = { 1, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 18, }, },
		[26] = { 1, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 19, }, },
		[27] = { 1, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 19, }, },
		[28] = { 1, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 19, }, },
		[29] = { 1, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 20, }, },
		[30] = { 1, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 20, }, },
		[31] = { 1, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 20, }, },
		[32] = { 1, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 20, }, },
		[33] = { 1, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[34] = { 1, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[35] = { 1, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[36] = { 1, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[37] = { 1, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 21, }, },
		[38] = { 1, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 22, }, },
		[39] = { 1, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 22, }, },
		[40] = { 1, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, }, cost = { Mana = 22, }, },
	},
}
skills["Reap"] = {
	name = "Reap",
	baseTypeName = "Reap",
	color = 1,
	baseEffectiveness = 1.405699968338,
	incrementalEffectiveness = 0.05009999871254,
	description = "A bloody scythe swipes across a selected area, applying a physical damage over time debuff and hitting enemies with physical damage. If any survive, you gain a blood charge which raises the damage and cost of the skill. Players can have 5 maximum blood charges.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.DamageOverTime] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["blood_scythe_damage_+%_final_per_charge"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "BloodCharge" }),
		},
		["blood_scythe_cost_+%_final_per_charge"] = {
			mod("LifeCost", "MORE", nil, 0, 0, { type = "Multiplier", var = "BloodCharge" }),
		},
		["base_physical_damage_to_deal_per_minute"] = {
			skill("PhysicalDot", nil, { type = "Condition", var = "ReapDebuffIsFireDamage", neg = true }),
			skill("FireDot", nil, { type = "Condition", var = "ReapDebuffIsFireDamage"}),
			div = 60,
		},
		["quality_display_reap_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 25),
		skill("debuff", true),
	},
	qualityStats = {
		Default = {
			{ "blood_scythe_damage_+%_final_per_charge", 0.25 },
		},
	},
	constantStats = {
		{ "blood_scythe_damage_+%_final_per_charge", 15 },
		{ "blood_scythe_cost_+%_final_per_charge", 20 },
		{ "base_skill_effect_duration", 1000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_physical_damage_to_deal_per_minute",
		"spell_damage_modifiers_apply_to_skill_dot",
		"is_area_damage",
		"lose_blood_scythe_charge_on_kill",
		"quality_display_reap_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 115.76667090729, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 28, statInterpolation = { 3, 3, 3, }, cost = { Life = 25, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 114.4083366535, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 31, statInterpolation = { 3, 3, 3, }, cost = { Life = 26, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 113.19500063547, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 34, statInterpolation = { 3, 3, 3, }, cost = { Life = 28, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 111.73833461018, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 37, statInterpolation = { 3, 3, 3, }, cost = { Life = 30, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 110.43000468083, critChance = 6, damageEffectiveness = 1.7, levelRequirement = 40, statInterpolation = { 3, 3, 3, }, cost = { Life = 31, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 109.88333470859, critChance = 6, damageEffectiveness = 1.7, levelRequirement = 42, statInterpolation = { 3, 3, 3, }, cost = { Life = 32, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 109.30333381824, critChance = 6, damageEffectiveness = 1.7, levelRequirement = 44, statInterpolation = { 3, 3, 3, }, cost = { Life = 33, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 108.69500085278, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 46, statInterpolation = { 3, 3, 3, }, cost = { Life = 34, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 108.26166712829, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 48, statInterpolation = { 3, 3, 3, }, cost = { Life = 35, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 107.59167116961, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 50, statInterpolation = { 3, 3, 3, }, cost = { Life = 36, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 107.10333427769, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 52, statInterpolation = { 3, 3, 3, }, cost = { Life = 37, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 106.58833424075, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 54, statInterpolation = { 3, 3, 3, }, cost = { Life = 38, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 106.04500212869, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 56, statInterpolation = { 3, 3, 3, }, cost = { Life = 39, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 105.47666785441, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 58, statInterpolation = { 3, 3, 3, }, cost = { Life = 40, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 104.88000150502, critChance = 6, damageEffectiveness = 2, levelRequirement = 60, statInterpolation = { 3, 3, 3, }, cost = { Life = 41, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 104.2566720106, critChance = 6, damageEffectiveness = 2, levelRequirement = 62, statInterpolation = { 3, 3, 3, }, cost = { Life = 42, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 103.38500571863, critChance = 6, damageEffectiveness = 2, levelRequirement = 64, statInterpolation = { 3, 3, 3, }, cost = { Life = 43, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 102.48166949137, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 66, statInterpolation = { 3, 3, 3, }, cost = { Life = 44, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 102.45333741625, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 68, statInterpolation = { 3, 3, 3, }, cost = { Life = 45, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 101.95333390827, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 70, statInterpolation = { 3, 3, 3, }, cost = { Life = 46, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 101.43000511544, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 72, statInterpolation = { 3, 3, 3, }, cost = { Life = 47, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 100.651671752, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 74, statInterpolation = { 3, 3, 3, }, cost = { Life = 48, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 100.07999961754, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 76, statInterpolation = { 3, 3, 3, }, cost = { Life = 49, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 99.486671128323, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 78, statInterpolation = { 3, 3, 3, }, cost = { Life = 50, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 98.870001459693, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 80, statInterpolation = { 3, 3, 3, }, cost = { Life = 51, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 98.229998558934, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 82, statInterpolation = { 3, 3, 3, }, cost = { Life = 52, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 97.566670373331, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 84, statInterpolation = { 3, 3, 3, }, cost = { Life = 53, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 97.123338962868, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 86, statInterpolation = { 3, 3, 3, }, cost = { Life = 54, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 96.416666278616, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 88, statInterpolation = { 3, 3, 3, }, cost = { Life = 55, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 95.684999379429, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 90, statInterpolation = { 3, 3, 3, }, cost = { Life = 56, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 95.680000536442, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 91, statInterpolation = { 3, 3, 3, }, cost = { Life = 57, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 95.913332857738, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 92, statInterpolation = { 3, 3, 3, }, cost = { Life = 58, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 95.886669712712, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 93, statInterpolation = { 3, 3, 3, }, cost = { Life = 58, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 95.848332004336, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 94, statInterpolation = { 3, 3, 3, }, cost = { Life = 58, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 96.055001180607, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 95, statInterpolation = { 3, 3, 3, }, cost = { Life = 60, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 95.996668100283, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 96, statInterpolation = { 3, 3, 3, }, cost = { Life = 60, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 95.924999473803, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 97, statInterpolation = { 3, 3, 3, }, cost = { Life = 60, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 96.105005505048, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 98, statInterpolation = { 3, 3, 3, }, cost = { Life = 60, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 96.013333559334, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 99, statInterpolation = { 3, 3, 3, }, cost = { Life = 61, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 95.910002944842, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 100, statInterpolation = { 3, 3, 3, }, cost = { Life = 61, }, },
	},
}
skills["VaalReap"] = {
	name = "Vaal Reap",
	baseTypeName = "Vaal Reap",
	color = 1,
	baseEffectiveness = 2.5599999427795,
	incrementalEffectiveness = 0.053599998354912,
	description = "Bloody scythes swipe around a selected area, hitting enemies with physical damage. An area of boiling blood is left beneath them for a duration which deals physical damage over time. Also gives a bonus to maximum Blood Charges for a secondary duration.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.DamageOverTime] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["blood_scythe_damage_+%_final_per_charge"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "BloodCharge" }),
		},
		["vaal_reap_additional_maximum_blood_charges"] = {
			mod("BloodChargesMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
		["base_physical_damage_to_deal_per_minute"] = {
			skill("PhysicalDot", nil, { type = "Condition", var = "ReapDebuffIsFireDamage", neg = true }),
			skill("FireDot", nil, { type = "Condition", var = "ReapDebuffIsFireDamage"}),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 23),
		skill("dotIsArea", true),
	},
	qualityStats = {
		Default = {
			{ "blood_scythe_damage_+%_final_per_charge", 0.25 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "vaal_reap_additional_maximum_blood_charges", 4 },
		{ "blood_ground_leaving_area_lasts_for_ms", 2000 },
		{ "base_secondary_skill_effect_duration", 8000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_physical_damage_to_deal_per_minute",
		"spell_damage_modifiers_apply_to_skill_dot",
		"is_area_damage",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"vaal_reap_gain_maximum_blood_charges_to_on_use",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3, levelRequirement = 28, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.1, levelRequirement = 31, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 34, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.4, levelRequirement = 37, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.5, levelRequirement = 40, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.6, levelRequirement = 42, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.6, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.7, levelRequirement = 46, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.8, levelRequirement = 48, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 3.9, levelRequirement = 50, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4, levelRequirement = 52, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.1, levelRequirement = 54, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.2, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.2, levelRequirement = 58, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.3, levelRequirement = 60, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.4, levelRequirement = 62, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.5, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.6, levelRequirement = 66, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.7, levelRequirement = 68, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 86.250005106752, critChance = 6, damageEffectiveness = 4.8, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 3, }, cost = { Soul = 25, }, },
	},
}
skills["SummonFlameGolem"] = {
	name = "Summon Flame Golem",
	baseTypeName = "Summon Flame Golem",
	color = 1,
	description = "Summons a Flame Golem that grants you increased Damage and Area of Effect. The Flame Golem can cast a fire spray, a wave of fire damage, and an explosive arcing projectile.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedFlameGolem",
	},
	statMap = {
		["fire_golem_grants_damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["fire_golem_grants_area_of_effect_+%"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveFireGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "golem_buff_effect_+%", 1 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 1 },
		{ "display_minion_monster_type", 7 },
	},
	stats = {
		"base_actor_scale_+%",
		"fire_golem_grants_damage_+%",
		"base_display_minion_actor_level",
		"fire_golem_grants_area_of_effect_+%",
		"infinite_minion_duration",
	},
	levels = {
		[1] = { 0, 20, 34, 20, cooldown = 6, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 30, }, },
		[2] = { 1, 20, 36, 20, cooldown = 6, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 32, }, },
		[3] = { 1, 21, 38, 20, cooldown = 6, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 34, }, },
		[4] = { 2, 21, 40, 20, cooldown = 6, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 36, }, },
		[5] = { 2, 22, 42, 20, cooldown = 6, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 38, }, },
		[6] = { 3, 22, 44, 20, cooldown = 6, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 40, }, },
		[7] = { 3, 23, 46, 20, cooldown = 6, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 42, }, },
		[8] = { 4, 23, 48, 20, cooldown = 6, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 44, }, },
		[9] = { 4, 24, 50, 20, cooldown = 6, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 44, }, },
		[10] = { 5, 24, 52, 20, cooldown = 6, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 46, }, },
		[11] = { 5, 25, 54, 20, cooldown = 6, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 48, }, },
		[12] = { 6, 25, 56, 20, cooldown = 6, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 48, }, },
		[13] = { 6, 26, 58, 20, cooldown = 6, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 50, }, },
		[14] = { 7, 26, 60, 20, cooldown = 6, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 50, }, },
		[15] = { 7, 27, 62, 20, cooldown = 6, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[16] = { 8, 27, 64, 20, cooldown = 6, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[17] = { 8, 28, 66, 20, cooldown = 6, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[18] = { 9, 28, 68, 20, cooldown = 6, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[19] = { 9, 29, 69, 20, cooldown = 6, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 54, }, },
		[20] = { 10, 29, 70, 20, cooldown = 6, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 54, }, },
		[21] = { 10, 30, 72, 20, cooldown = 6, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 56, }, },
		[22] = { 11, 30, 74, 20, cooldown = 6, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 56, }, },
		[23] = { 11, 31, 76, 20, cooldown = 6, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 58, }, },
		[24] = { 12, 31, 78, 20, cooldown = 6, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 58, }, },
		[25] = { 12, 32, 80, 20, cooldown = 6, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[26] = { 13, 32, 82, 20, cooldown = 6, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[27] = { 13, 33, 84, 20, cooldown = 6, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[28] = { 14, 33, 86, 20, cooldown = 6, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[29] = { 14, 34, 88, 20, cooldown = 6, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[30] = { 15, 34, 90, 20, cooldown = 6, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[31] = { 15, 34, 91, 20, cooldown = 6, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[32] = { 15, 35, 92, 20, cooldown = 6, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[33] = { 15, 35, 93, 20, cooldown = 6, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[34] = { 16, 35, 94, 20, cooldown = 6, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[35] = { 16, 35, 95, 20, cooldown = 6, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[36] = { 16, 36, 96, 20, cooldown = 6, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[37] = { 16, 36, 97, 20, cooldown = 6, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[38] = { 17, 36, 98, 20, cooldown = 6, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[39] = { 17, 36, 99, 20, cooldown = 6, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[40] = { 17, 37, 100, 20, cooldown = 6, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
	},
}
skills["SummonFlameGolemAltX"] = {
	name = "Summon Flame Golem of Hordes",
	baseTypeName = "Summon Flame Golem of Hordes",
	color = 1,
	description = "Summons a Flame Golem. The Flame Golem can cast a fire spray, a wave of fire damage, and an explosive arcing projectile.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedFlameGolem",
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveFireGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 3 },
		{ "display_minion_monster_type", 7 },
		{ "base_actor_scale_+%", -20 },
	},
	stats = {
		"base_display_minion_actor_level",
		"infinite_minion_duration",
		"active_skill_no_golem_aura",
	},
	levels = {
		[1] = { 34, cooldown = 2, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[2] = { 36, cooldown = 2, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[3] = { 38, cooldown = 2, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[4] = { 40, cooldown = 2, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 36, }, },
		[5] = { 42, cooldown = 2, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 38, }, },
		[6] = { 44, cooldown = 2, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 40, }, },
		[7] = { 46, cooldown = 2, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 42, }, },
		[8] = { 48, cooldown = 2, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[9] = { 50, cooldown = 2, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[10] = { 52, cooldown = 2, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 46, }, },
		[11] = { 54, cooldown = 2, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 48, }, },
		[12] = { 56, cooldown = 2, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 48, }, },
		[13] = { 58, cooldown = 2, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 50, }, },
		[14] = { 60, cooldown = 2, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 50, }, },
		[15] = { 62, cooldown = 2, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[16] = { 64, cooldown = 2, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[17] = { 66, cooldown = 2, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[18] = { 68, cooldown = 2, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[19] = { 69, cooldown = 2, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 54, }, },
		[20] = { 70, cooldown = 2, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 54, }, },
		[21] = { 72, cooldown = 2, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 56, }, },
		[22] = { 74, cooldown = 2, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 56, }, },
		[23] = { 76, cooldown = 2, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 58, }, },
		[24] = { 78, cooldown = 2, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 58, }, },
		[25] = { 80, cooldown = 2, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[26] = { 82, cooldown = 2, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[27] = { 84, cooldown = 2, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[28] = { 86, cooldown = 2, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[29] = { 88, cooldown = 2, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[30] = { 90, cooldown = 2, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[31] = { 91, cooldown = 2, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[32] = { 92, cooldown = 2, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[33] = { 93, cooldown = 2, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[34] = { 94, cooldown = 2, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[35] = { 95, cooldown = 2, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[36] = { 96, cooldown = 2, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[37] = { 97, cooldown = 2, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[38] = { 98, cooldown = 2, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[39] = { 99, cooldown = 2, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[40] = { 100, cooldown = 2, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
	},
}
skills["SummonFlameGolemAltY"] = {
	name = "Summon Flame Golem of the Meteor",
	baseTypeName = "Summon Flame Golem of the Meteor",
	color = 1,
	description = "Summons a Flame Golem. When summoned, the Flame Golem attacks by falling from the sky, dealing fire damage in an area and leaving burning ground around the impact. After landing, it can cast a fire spray and a wave of fire damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.CausesBurning] = true, [SkillType.DamageOverTime] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedFlameGolem",
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveFireGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 1 },
		{ "display_minion_monster_type", 7 },
		{ "active_skill_minion_from_alternate_gem_index", 2 },
		{ "golem_summon_distance_+", 70 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_display_minion_actor_level",
		"infinite_minion_duration",
		"active_skill_no_golem_aura",
		"golem_can_summoned_within_range",
	},
	levels = {
		[1] = { 0, 34, cooldown = 2, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 30, }, },
		[2] = { 1, 36, cooldown = 2, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[3] = { 1, 38, cooldown = 2, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[4] = { 2, 40, cooldown = 2, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[5] = { 2, 42, cooldown = 2, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 38, }, },
		[6] = { 3, 44, cooldown = 2, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[7] = { 3, 46, cooldown = 2, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[8] = { 4, 48, cooldown = 2, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
		[9] = { 4, 50, cooldown = 2, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
		[10] = { 5, 52, cooldown = 2, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[11] = { 5, 54, cooldown = 2, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[12] = { 6, 56, cooldown = 2, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[13] = { 6, 58, cooldown = 2, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 50, }, },
		[14] = { 7, 60, cooldown = 2, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 50, }, },
		[15] = { 7, 62, cooldown = 2, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[16] = { 8, 64, cooldown = 2, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[17] = { 8, 66, cooldown = 2, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[18] = { 9, 68, cooldown = 2, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[19] = { 9, 69, cooldown = 2, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 54, }, },
		[20] = { 10, 70, cooldown = 2, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 54, }, },
		[21] = { 10, 72, cooldown = 2, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 56, }, },
		[22] = { 11, 74, cooldown = 2, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 56, }, },
		[23] = { 11, 76, cooldown = 2, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 58, }, },
		[24] = { 12, 78, cooldown = 2, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 58, }, },
		[25] = { 12, 80, cooldown = 2, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[26] = { 13, 82, cooldown = 2, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[27] = { 13, 84, cooldown = 2, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[28] = { 14, 86, cooldown = 2, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[29] = { 14, 88, cooldown = 2, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[30] = { 15, 90, cooldown = 2, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[31] = { 15, 91, cooldown = 2, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[32] = { 15, 92, cooldown = 2, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[33] = { 15, 93, cooldown = 2, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[34] = { 16, 94, cooldown = 2, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[35] = { 16, 95, cooldown = 2, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[36] = { 16, 96, cooldown = 2, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[37] = { 16, 97, cooldown = 2, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[38] = { 17, 98, cooldown = 2, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[39] = { 17, 99, cooldown = 2, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[40] = { 17, 100, cooldown = 2, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
	},
}
skills["SummonStoneGolem"] = {
	name = "Summon Stone Golem",
	baseTypeName = "Summon Stone Golem",
	color = 1,
	description = "Summons a Stone Golem that grants you life regeneration and defences. In addition to its melee attack, the Stone Golem uses a rolling charge and a powerful slam that can taunt enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.Physical] = true, [SkillType.CreatesMinion] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedStoneGolem",
	},
	statMap = {
		["stone_golem_grants_base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
		["stone_golem_grants_defences_+%"] = {
			mod("Defences", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HavePhysicalGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "golem_buff_effect_+%", 1 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 1 },
		{ "display_minion_monster_type", 10 },
	},
	stats = {
		"base_actor_scale_+%",
		"stone_golem_grants_base_life_regeneration_rate_per_minute",
		"base_display_minion_actor_level",
		"stone_golem_grants_defences_+%",
		"infinite_minion_duration",
	},
	levels = {
		[1] = { 0, 1980, 34, 20, cooldown = 6, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 30, }, },
		[2] = { 1, 2160, 36, 20, cooldown = 6, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 32, }, },
		[3] = { 1, 2340, 38, 20, cooldown = 6, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 34, }, },
		[4] = { 2, 2520, 40, 20, cooldown = 6, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 36, }, },
		[5] = { 2, 2700, 42, 20, cooldown = 6, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 38, }, },
		[6] = { 3, 2940, 44, 20, cooldown = 6, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 40, }, },
		[7] = { 3, 3120, 46, 20, cooldown = 6, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 42, }, },
		[8] = { 4, 3360, 48, 20, cooldown = 6, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 44, }, },
		[9] = { 4, 3600, 50, 20, cooldown = 6, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 44, }, },
		[10] = { 5, 3840, 52, 20, cooldown = 6, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 46, }, },
		[11] = { 5, 4080, 54, 20, cooldown = 6, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 48, }, },
		[12] = { 6, 4320, 56, 20, cooldown = 6, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 48, }, },
		[13] = { 6, 4560, 58, 20, cooldown = 6, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 50, }, },
		[14] = { 7, 4860, 60, 20, cooldown = 6, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 50, }, },
		[15] = { 7, 5100, 62, 20, cooldown = 6, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[16] = { 8, 5400, 64, 20, cooldown = 6, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[17] = { 8, 5700, 66, 20, cooldown = 6, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[18] = { 9, 6000, 68, 20, cooldown = 6, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 52, }, },
		[19] = { 9, 6180, 69, 20, cooldown = 6, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 54, }, },
		[20] = { 10, 6300, 70, 20, cooldown = 6, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 54, }, },
		[21] = { 10, 6600, 72, 20, cooldown = 6, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 56, }, },
		[22] = { 11, 6960, 74, 20, cooldown = 6, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 56, }, },
		[23] = { 11, 7260, 76, 20, cooldown = 6, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 58, }, },
		[24] = { 12, 7620, 78, 20, cooldown = 6, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 58, }, },
		[25] = { 12, 7980, 80, 20, cooldown = 6, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[26] = { 13, 8340, 82, 20, cooldown = 6, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[27] = { 13, 8700, 84, 20, cooldown = 6, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[28] = { 14, 9060, 86, 20, cooldown = 6, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 60, }, },
		[29] = { 14, 9420, 88, 20, cooldown = 6, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[30] = { 15, 9840, 90, 20, cooldown = 6, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[31] = { 15, 10020, 91, 20, cooldown = 6, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 62, }, },
		[32] = { 15, 10200, 92, 20, cooldown = 6, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[33] = { 15, 10380, 93, 20, cooldown = 6, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[34] = { 16, 10560, 94, 20, cooldown = 6, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[35] = { 16, 10740, 95, 20, cooldown = 6, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 63, }, },
		[36] = { 16, 10920, 96, 20, cooldown = 6, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[37] = { 16, 11100, 97, 20, cooldown = 6, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[38] = { 17, 11280, 98, 20, cooldown = 6, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[39] = { 17, 11460, 99, 20, cooldown = 6, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
		[40] = { 17, 11640, 100, 20, cooldown = 6, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 64, }, },
	},
}
skills["SummonStoneGolemAltX"] = {
	name = "Summon Stone Golem of Hordes",
	baseTypeName = "Summon Stone Golem of Hordes",
	color = 1,
	description = "Summons a Stone Golem. In addition to its melee attack, the Stone Golem uses a rolling charge and a powerful slam that can taunt enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.Physical] = true, [SkillType.CreatesMinion] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedStoneGolem",
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HavePhysicalGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "minion_cooldown_recovery_+%", 2 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 3 },
		{ "display_minion_monster_type", 10 },
		{ "base_actor_scale_+%", -20 },
	},
	stats = {
		"base_display_minion_actor_level",
		"infinite_minion_duration",
		"active_skill_no_golem_aura",
	},
	levels = {
		[1] = { 34, cooldown = 2, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[2] = { 36, cooldown = 2, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[3] = { 38, cooldown = 2, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[4] = { 40, cooldown = 2, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 36, }, },
		[5] = { 42, cooldown = 2, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 38, }, },
		[6] = { 44, cooldown = 2, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 40, }, },
		[7] = { 46, cooldown = 2, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 42, }, },
		[8] = { 48, cooldown = 2, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[9] = { 50, cooldown = 2, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 44, }, },
		[10] = { 52, cooldown = 2, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 46, }, },
		[11] = { 54, cooldown = 2, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 48, }, },
		[12] = { 56, cooldown = 2, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 48, }, },
		[13] = { 58, cooldown = 2, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 50, }, },
		[14] = { 60, cooldown = 2, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 50, }, },
		[15] = { 62, cooldown = 2, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[16] = { 64, cooldown = 2, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[17] = { 66, cooldown = 2, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[18] = { 68, cooldown = 2, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 52, }, },
		[19] = { 69, cooldown = 2, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 54, }, },
		[20] = { 70, cooldown = 2, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 54, }, },
		[21] = { 72, cooldown = 2, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 56, }, },
		[22] = { 74, cooldown = 2, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 56, }, },
		[23] = { 76, cooldown = 2, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 58, }, },
		[24] = { 78, cooldown = 2, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 58, }, },
		[25] = { 80, cooldown = 2, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[26] = { 82, cooldown = 2, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[27] = { 84, cooldown = 2, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[28] = { 86, cooldown = 2, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 60, }, },
		[29] = { 88, cooldown = 2, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[30] = { 90, cooldown = 2, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[31] = { 91, cooldown = 2, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 62, }, },
		[32] = { 92, cooldown = 2, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[33] = { 93, cooldown = 2, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[34] = { 94, cooldown = 2, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[35] = { 95, cooldown = 2, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 63, }, },
		[36] = { 96, cooldown = 2, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[37] = { 97, cooldown = 2, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[38] = { 98, cooldown = 2, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[39] = { 99, cooldown = 2, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
		[40] = { 100, cooldown = 2, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 64, }, },
	},
}
skills["SummonStoneGolemAltY"] = {
	name = "Summon Stone Golem of Safeguarding",
	baseTypeName = "Summon Stone Golem of Safeguarding",
	color = 1,
	description = "Summons a Stone Golem that takes a portion of the melee damage you recieve from enemy hits from its life before yours. In addition to its melee attack, the Stone Golem uses a rolling charge and a powerful slam that can taunt enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Golem] = true, [SkillType.Physical] = true, [SkillType.CreatesMinion] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"SummonedStoneGolem",
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
		permanentMinion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HavePhysicalGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		Default = {
			{ "golem_buff_effect_+%", 1 },
		},
	},
	constantStats = {
		{ "base_number_of_golems_allowed", 1 },
		{ "display_minion_monster_type", 10 },
		{ "active_skill_minion_from_alternate_gem_index", 2 },
		{ "stone_golem_grants_melee_damage_removed_from_stone_golem_before_life_or_es_%", 15 },
		{ "active_skill_minion_life_+%_final", -50 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_display_minion_actor_level",
		"infinite_minion_duration",
	},
	levels = {
		[1] = { 0, 34, cooldown = 15, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 30, }, },
		[2] = { 1, 36, cooldown = 15, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[3] = { 1, 38, cooldown = 15, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[4] = { 2, 40, cooldown = 15, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[5] = { 2, 42, cooldown = 15, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 38, }, },
		[6] = { 3, 44, cooldown = 15, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[7] = { 3, 46, cooldown = 15, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[8] = { 4, 48, cooldown = 15, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
		[9] = { 4, 50, cooldown = 15, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
		[10] = { 5, 52, cooldown = 15, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 46, }, },
		[11] = { 5, 54, cooldown = 15, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[12] = { 6, 56, cooldown = 15, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 48, }, },
		[13] = { 6, 58, cooldown = 15, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 50, }, },
		[14] = { 7, 60, cooldown = 15, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 50, }, },
		[15] = { 7, 62, cooldown = 15, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[16] = { 8, 64, cooldown = 15, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[17] = { 8, 66, cooldown = 15, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[18] = { 9, 68, cooldown = 15, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 52, }, },
		[19] = { 9, 69, cooldown = 15, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 54, }, },
		[20] = { 10, 70, cooldown = 15, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 54, }, },
		[21] = { 10, 72, cooldown = 15, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 56, }, },
		[22] = { 11, 74, cooldown = 15, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 56, }, },
		[23] = { 11, 76, cooldown = 15, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 58, }, },
		[24] = { 12, 78, cooldown = 15, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 58, }, },
		[25] = { 12, 80, cooldown = 15, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[26] = { 13, 82, cooldown = 15, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[27] = { 13, 84, cooldown = 15, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[28] = { 14, 86, cooldown = 15, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 60, }, },
		[29] = { 14, 88, cooldown = 15, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[30] = { 15, 90, cooldown = 15, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[31] = { 15, 91, cooldown = 15, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 62, }, },
		[32] = { 15, 92, cooldown = 15, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[33] = { 15, 93, cooldown = 15, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[34] = { 16, 94, cooldown = 15, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[35] = { 16, 95, cooldown = 15, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 63, }, },
		[36] = { 16, 96, cooldown = 15, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[37] = { 16, 97, cooldown = 15, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[38] = { 17, 98, cooldown = 15, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[39] = { 17, 99, cooldown = 15, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
		[40] = { 17, 100, cooldown = 15, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 64, }, },
	},
}
skills["Sunder"] = {
	name = "Sunder",
	baseTypeName = "Sunder",
	color = 1,
	description = "Slams the ground, creating a slow wave of churning terrain that damages enemies in a sequence of areas in front of you. A number of enemies hit by the wave will release a shockwave, damaging other enemies around them. Using the skill again will stop the previous wave. Requires a Mace, Sceptre, Axe, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "First Wave Area",
		},
		{
			name = "Final Wave Area",
		},
		{
			name = "Shockwaves",
		},
	},
	statMap = {
		["shockwave_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 3 }),
		},
		["active_skill_area_of_effect_+%_final"] = {
			mod("AreaOfEffect", "MORE", nil),
		},
		["sunder_wave_radius_+_per_step"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "SunderWaveArea" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
		mod("Multiplier:SunderWaveArea", "BASE", 4, 0, 0, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "sunder_wave_radius_+_per_step", 0.05 },
		},
	},
	constantStats = {
		{ "shockwave_slam_explosion_damage_+%_final", -40 },
		{ "base_sunder_wave_delay_ms", 400 },
		{ "sunder_wave_radius_+_per_step", 2 },
		{ "sunder_wave_max_steps", 5 },
		{ "sunder_wave_min_steps", 2 },
		{ "sunder_shockwave_limit_per_cascade", 5 },
	},
	stats = {
		"active_skill_area_of_effect_+%_final",
		"sunder_wave_delay_+%",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"active_skill_area_of_effect_+%_final",
	},
	levels = {
		[1] = { 0, 0, attackSpeedMultiplier = -25, baseMultiplier = 2.738, damageEffectiveness = 2.738, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[2] = { 1, -1, attackSpeedMultiplier = -25, baseMultiplier = 2.86, damageEffectiveness = 2.86, levelRequirement = 15, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[3] = { 2, -3, attackSpeedMultiplier = -25, baseMultiplier = 2.995, damageEffectiveness = 2.995, levelRequirement = 19, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[4] = { 3, -4, attackSpeedMultiplier = -25, baseMultiplier = 3.135, damageEffectiveness = 3.135, levelRequirement = 23, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[5] = { 4, -5, attackSpeedMultiplier = -25, baseMultiplier = 3.281, damageEffectiveness = 3.281, levelRequirement = 27, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[6] = { 5, -7, attackSpeedMultiplier = -25, baseMultiplier = 3.434, damageEffectiveness = 3.434, levelRequirement = 31, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[7] = { 6, -8, attackSpeedMultiplier = -25, baseMultiplier = 3.594, damageEffectiveness = 3.594, levelRequirement = 35, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[8] = { 7, -9, attackSpeedMultiplier = -25, baseMultiplier = 3.755, damageEffectiveness = 3.755, levelRequirement = 38, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[9] = { 8, -11, attackSpeedMultiplier = -25, baseMultiplier = 3.921, damageEffectiveness = 3.921, levelRequirement = 41, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[10] = { 9, -12, attackSpeedMultiplier = -25, baseMultiplier = 4.097, damageEffectiveness = 4.097, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[11] = { 10, -13, attackSpeedMultiplier = -25, baseMultiplier = 4.28, damageEffectiveness = 4.28, levelRequirement = 47, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[12] = { 11, -14, attackSpeedMultiplier = -25, baseMultiplier = 4.471, damageEffectiveness = 4.471, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[13] = { 12, -16, attackSpeedMultiplier = -25, baseMultiplier = 4.67, damageEffectiveness = 4.67, levelRequirement = 53, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[14] = { 13, -17, attackSpeedMultiplier = -25, baseMultiplier = 4.877, damageEffectiveness = 4.877, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[15] = { 14, -18, attackSpeedMultiplier = -25, baseMultiplier = 5.095, damageEffectiveness = 5.095, levelRequirement = 59, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[16] = { 15, -20, attackSpeedMultiplier = -25, baseMultiplier = 5.322, damageEffectiveness = 5.322, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[17] = { 16, -21, attackSpeedMultiplier = -25, baseMultiplier = 5.548, damageEffectiveness = 5.548, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[18] = { 17, -22, attackSpeedMultiplier = -25, baseMultiplier = 5.785, damageEffectiveness = 5.785, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[19] = { 18, -24, attackSpeedMultiplier = -25, baseMultiplier = 6.032, damageEffectiveness = 6.032, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[20] = { 19, -25, attackSpeedMultiplier = -25, baseMultiplier = 6.29, damageEffectiveness = 6.29, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[21] = { 20, -26, attackSpeedMultiplier = -25, baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[22] = { 21, -28, attackSpeedMultiplier = -25, baseMultiplier = 6.839, damageEffectiveness = 6.839, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[23] = { 22, -29, attackSpeedMultiplier = -25, baseMultiplier = 7.13, damageEffectiveness = 7.13, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[24] = { 23, -30, attackSpeedMultiplier = -25, baseMultiplier = 7.434, damageEffectiveness = 7.434, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[25] = { 24, -32, attackSpeedMultiplier = -25, baseMultiplier = 7.751, damageEffectiveness = 7.751, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[26] = { 25, -33, attackSpeedMultiplier = -25, baseMultiplier = 8.081, damageEffectiveness = 8.081, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[27] = { 26, -34, attackSpeedMultiplier = -25, baseMultiplier = 8.426, damageEffectiveness = 8.426, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[28] = { 27, -36, attackSpeedMultiplier = -25, baseMultiplier = 8.785, damageEffectiveness = 8.785, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[29] = { 28, -37, attackSpeedMultiplier = -25, baseMultiplier = 9.159, damageEffectiveness = 9.159, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[30] = { 29, -38, attackSpeedMultiplier = -25, baseMultiplier = 9.549, damageEffectiveness = 9.549, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[31] = { 29, -39, attackSpeedMultiplier = -25, baseMultiplier = 10.135, damageEffectiveness = 10.135, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[32] = { 30, -39, attackSpeedMultiplier = -25, baseMultiplier = 10.35, damageEffectiveness = 10.35, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[33] = { 30, -40, attackSpeedMultiplier = -25, baseMultiplier = 10.57, damageEffectiveness = 10.57, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[34] = { 31, -41, attackSpeedMultiplier = -25, baseMultiplier = 10.795, damageEffectiveness = 10.795, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[35] = { 31, -41, attackSpeedMultiplier = -25, baseMultiplier = 11.024, damageEffectiveness = 11.024, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[36] = { 32, -42, attackSpeedMultiplier = -25, baseMultiplier = 11.259, damageEffectiveness = 11.259, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[37] = { 32, -43, attackSpeedMultiplier = -25, baseMultiplier = 11.498, damageEffectiveness = 11.498, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[38] = { 33, -43, attackSpeedMultiplier = -25, baseMultiplier = 11.741, damageEffectiveness = 11.741, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[39] = { 33, -44, attackSpeedMultiplier = -25, baseMultiplier = 11.991, damageEffectiveness = 11.991, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[40] = { 34, -45, attackSpeedMultiplier = -25, baseMultiplier = 12.246, damageEffectiveness = 12.246, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
	},
}
skills["SunderAltX"] = {
	name = "Sunder of Earthbreaking",
	baseTypeName = "Sunder of Earthbreaking",
	color = 1,
	description = "Slams the ground, creating a wave of churning terrain that damages enemies in a sequence of areas in front of you. A number of enemies hit by the wave will release a shockwave, damaging other enemies around them. Requires a Mace, Sceptre, Axe, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Wave",
		},
		{
			name = "Shockwaves",
		},
	},
	statMap = {
		["shockwave_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["active_skill_area_of_effect_+%_final"] = {
			mod("AreaOfEffect", "MORE", nil),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
	},
	qualityStats = {
		Default = {
			{ "sunder_wave_max_steps", 0.1 },
		},
	},
	constantStats = {
		{ "shockwave_slam_explosion_damage_+%_final", -40 },
		{ "base_sunder_wave_delay_ms", 400 },
		{ "sunder_wave_max_steps", 6 },
		{ "sunder_shockwave_limit_per_cascade", 3 },
		{ "sunder_wave_delay_+%", -75 },
	},
	stats = {
		"active_skill_area_of_effect_+%_final",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"active_skill_area_of_effect_+%_final",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -10, baseMultiplier = 2.191, damageEffectiveness = 2.191, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 2, attackSpeedMultiplier = -10, baseMultiplier = 2.289, damageEffectiveness = 2.289, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 4, attackSpeedMultiplier = -10, baseMultiplier = 2.395, damageEffectiveness = 2.395, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 6, attackSpeedMultiplier = -10, baseMultiplier = 2.507, damageEffectiveness = 2.507, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[5] = { 8, attackSpeedMultiplier = -10, baseMultiplier = 2.624, damageEffectiveness = 2.624, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 10, attackSpeedMultiplier = -10, baseMultiplier = 2.746, damageEffectiveness = 2.746, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 12, attackSpeedMultiplier = -10, baseMultiplier = 2.875, damageEffectiveness = 2.875, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 14, attackSpeedMultiplier = -10, baseMultiplier = 3.003, damageEffectiveness = 3.003, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 16, attackSpeedMultiplier = -10, baseMultiplier = 3.137, damageEffectiveness = 3.137, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 18, attackSpeedMultiplier = -10, baseMultiplier = 3.278, damageEffectiveness = 3.278, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 20, attackSpeedMultiplier = -10, baseMultiplier = 3.423, damageEffectiveness = 3.423, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 22, attackSpeedMultiplier = -10, baseMultiplier = 3.576, damageEffectiveness = 3.576, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 24, attackSpeedMultiplier = -10, baseMultiplier = 3.736, damageEffectiveness = 3.736, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 26, attackSpeedMultiplier = -10, baseMultiplier = 3.902, damageEffectiveness = 3.902, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[15] = { 28, attackSpeedMultiplier = -10, baseMultiplier = 4.076, damageEffectiveness = 4.076, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[16] = { 30, attackSpeedMultiplier = -10, baseMultiplier = 4.257, damageEffectiveness = 4.257, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 32, attackSpeedMultiplier = -10, baseMultiplier = 4.438, damageEffectiveness = 4.438, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[18] = { 34, attackSpeedMultiplier = -10, baseMultiplier = 4.629, damageEffectiveness = 4.629, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[19] = { 36, attackSpeedMultiplier = -10, baseMultiplier = 4.826, damageEffectiveness = 4.826, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[20] = { 38, attackSpeedMultiplier = -10, baseMultiplier = 5.032, damageEffectiveness = 5.032, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[21] = { 40, attackSpeedMultiplier = -10, baseMultiplier = 5.247, damageEffectiveness = 5.247, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[22] = { 42, attackSpeedMultiplier = -10, baseMultiplier = 5.471, damageEffectiveness = 5.471, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[23] = { 44, attackSpeedMultiplier = -10, baseMultiplier = 5.704, damageEffectiveness = 5.704, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[24] = { 46, attackSpeedMultiplier = -10, baseMultiplier = 5.948, damageEffectiveness = 5.948, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[25] = { 48, attackSpeedMultiplier = -10, baseMultiplier = 6.201, damageEffectiveness = 6.201, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[26] = { 50, attackSpeedMultiplier = -10, baseMultiplier = 6.466, damageEffectiveness = 6.466, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[27] = { 52, attackSpeedMultiplier = -10, baseMultiplier = 6.74, damageEffectiveness = 6.74, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[28] = { 54, attackSpeedMultiplier = -10, baseMultiplier = 7.028, damageEffectiveness = 7.028, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[29] = { 56, attackSpeedMultiplier = -10, baseMultiplier = 7.327, damageEffectiveness = 7.327, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[30] = { 58, attackSpeedMultiplier = -10, baseMultiplier = 7.639, damageEffectiveness = 7.639, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[31] = { 59, attackSpeedMultiplier = -10, baseMultiplier = 8.108, damageEffectiveness = 8.108, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[32] = { 60, attackSpeedMultiplier = -10, baseMultiplier = 8.28, damageEffectiveness = 8.28, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[33] = { 61, attackSpeedMultiplier = -10, baseMultiplier = 8.456, damageEffectiveness = 8.456, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[34] = { 62, attackSpeedMultiplier = -10, baseMultiplier = 8.636, damageEffectiveness = 8.636, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[35] = { 63, attackSpeedMultiplier = -10, baseMultiplier = 8.82, damageEffectiveness = 8.82, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[36] = { 64, attackSpeedMultiplier = -10, baseMultiplier = 9.006, damageEffectiveness = 9.006, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[37] = { 65, attackSpeedMultiplier = -10, baseMultiplier = 9.198, damageEffectiveness = 9.198, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[38] = { 66, attackSpeedMultiplier = -10, baseMultiplier = 9.393, damageEffectiveness = 9.393, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[39] = { 67, attackSpeedMultiplier = -10, baseMultiplier = 9.593, damageEffectiveness = 9.593, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[40] = { 68, attackSpeedMultiplier = -10, baseMultiplier = 9.796, damageEffectiveness = 9.796, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 13, }, },
	},
}
skills["SunderAltY"] = {
	name = "Sunder of Trarthus",
	baseTypeName = "Sunder of Trarthus",
	color = 1,
	description = "Slams the ground, creating a slow wave of churning terrain that damages enemies in a sequence of areas in front of you. A number of enemies hit by the wave will release a shockwave, damaging other enemies around them. Using the skill again will stop the previous wave. When the wave reaches a target or terrain, it can restart aiming towards an enemy, if one is in range. Requires a Mace, Sceptre, Axe, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "First Wave Area",
		},
		{
			name = "Final Wave Area",
		},
		{
			name = "Shockwaves",
		},
	},
	statMap = {
		["shockwave_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 3 }),
		},
		["sunder_wave_radius_+_per_step"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "SunderWaveArea" }),
		},
		["sunder_wave_max_steps"] = {
			mod("Multiplier:SunderWaveArea", "BASE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
			base = -1,
		},
		["sunder_number_of_fake_chains"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
	},
	qualityStats = {
		Default = {
			{ "sunder_wave_delay_+%", -0.5 },
		},
	},
	constantStats = {
		{ "shockwave_slam_explosion_damage_+%_final", -40 },
		{ "base_sunder_wave_delay_ms", 300 },
		{ "sunder_wave_radius_+_per_step", 1 },
		{ "sunder_wave_max_steps", 4 },
		{ "sunder_wave_min_steps", 2 },
		{ "sunder_shockwave_limit_per_cascade", 5 },
		{ "sunder_number_of_fake_chains", 3 },
	},
	stats = {
		"active_skill_area_of_effect_+%_final",
		"sunder_wave_delay_+%",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"active_skill_area_of_effect_+%_final",
	},
	levels = {
		[1] = { 0, 0, attackSpeedMultiplier = -25, baseMultiplier = 2.05, damageEffectiveness = 2.05, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[2] = { 1, -1, attackSpeedMultiplier = -25, baseMultiplier = 2.19, damageEffectiveness = 2.19, levelRequirement = 15, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[3] = { 2, -3, attackSpeedMultiplier = -25, baseMultiplier = 2.33, damageEffectiveness = 2.33, levelRequirement = 19, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[4] = { 3, -4, attackSpeedMultiplier = -25, baseMultiplier = 2.47, damageEffectiveness = 2.47, levelRequirement = 23, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[5] = { 4, -5, attackSpeedMultiplier = -25, baseMultiplier = 2.61, damageEffectiveness = 2.61, levelRequirement = 27, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[6] = { 5, -7, attackSpeedMultiplier = -25, baseMultiplier = 2.75, damageEffectiveness = 2.75, levelRequirement = 31, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[7] = { 6, -8, attackSpeedMultiplier = -25, baseMultiplier = 2.89, damageEffectiveness = 2.89, levelRequirement = 35, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[8] = { 7, -9, attackSpeedMultiplier = -25, baseMultiplier = 3.03, damageEffectiveness = 3.03, levelRequirement = 38, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[9] = { 8, -11, attackSpeedMultiplier = -25, baseMultiplier = 3.17, damageEffectiveness = 3.17, levelRequirement = 41, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[10] = { 9, -12, attackSpeedMultiplier = -25, baseMultiplier = 3.31, damageEffectiveness = 3.31, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[11] = { 10, -13, attackSpeedMultiplier = -25, baseMultiplier = 3.45, damageEffectiveness = 3.45, levelRequirement = 47, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[12] = { 11, -14, attackSpeedMultiplier = -25, baseMultiplier = 3.59, damageEffectiveness = 3.59, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[13] = { 12, -16, attackSpeedMultiplier = -25, baseMultiplier = 3.73, damageEffectiveness = 3.73, levelRequirement = 53, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[14] = { 13, -17, attackSpeedMultiplier = -25, baseMultiplier = 3.87, damageEffectiveness = 3.87, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[15] = { 14, -18, attackSpeedMultiplier = -25, baseMultiplier = 4.01, damageEffectiveness = 4.01, levelRequirement = 59, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[16] = { 15, -20, attackSpeedMultiplier = -25, baseMultiplier = 4.15, damageEffectiveness = 4.15, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[17] = { 16, -21, attackSpeedMultiplier = -25, baseMultiplier = 4.29, damageEffectiveness = 4.29, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[18] = { 17, -22, attackSpeedMultiplier = -25, baseMultiplier = 4.43, damageEffectiveness = 4.43, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[19] = { 18, -24, attackSpeedMultiplier = -25, baseMultiplier = 4.57, damageEffectiveness = 4.57, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[20] = { 19, -25, attackSpeedMultiplier = -25, baseMultiplier = 4.71, damageEffectiveness = 4.71, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[21] = { 20, -26, attackSpeedMultiplier = -25, baseMultiplier = 4.85, damageEffectiveness = 4.85, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[22] = { 21, -28, attackSpeedMultiplier = -25, baseMultiplier = 4.99, damageEffectiveness = 4.99, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[23] = { 22, -29, attackSpeedMultiplier = -25, baseMultiplier = 5.13, damageEffectiveness = 5.13, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[24] = { 23, -30, attackSpeedMultiplier = -25, baseMultiplier = 5.27, damageEffectiveness = 5.27, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[25] = { 24, -32, attackSpeedMultiplier = -25, baseMultiplier = 5.41, damageEffectiveness = 5.41, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[26] = { 25, -33, attackSpeedMultiplier = -25, baseMultiplier = 5.55, damageEffectiveness = 5.55, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[27] = { 26, -34, attackSpeedMultiplier = -25, baseMultiplier = 5.69, damageEffectiveness = 5.69, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[28] = { 27, -36, attackSpeedMultiplier = -25, baseMultiplier = 5.83, damageEffectiveness = 5.83, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[29] = { 28, -37, attackSpeedMultiplier = -25, baseMultiplier = 5.97, damageEffectiveness = 5.97, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[30] = { 29, -38, attackSpeedMultiplier = -25, baseMultiplier = 6.11, damageEffectiveness = 6.11, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[31] = { 29, -39, attackSpeedMultiplier = -25, baseMultiplier = 6.18, damageEffectiveness = 6.18, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[32] = { 30, -39, attackSpeedMultiplier = -25, baseMultiplier = 6.25, damageEffectiveness = 6.25, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[33] = { 30, -40, attackSpeedMultiplier = -25, baseMultiplier = 6.32, damageEffectiveness = 6.32, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[34] = { 31, -41, attackSpeedMultiplier = -25, baseMultiplier = 6.39, damageEffectiveness = 6.39, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[35] = { 31, -41, attackSpeedMultiplier = -25, baseMultiplier = 6.46, damageEffectiveness = 6.46, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[36] = { 32, -42, attackSpeedMultiplier = -25, baseMultiplier = 6.53, damageEffectiveness = 6.53, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[37] = { 32, -43, attackSpeedMultiplier = -25, baseMultiplier = 6.6, damageEffectiveness = 6.6, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[38] = { 33, -43, attackSpeedMultiplier = -25, baseMultiplier = 6.67, damageEffectiveness = 6.67, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[39] = { 33, -44, attackSpeedMultiplier = -25, baseMultiplier = 6.74, damageEffectiveness = 6.74, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[40] = { 34, -45, attackSpeedMultiplier = -25, baseMultiplier = 6.81, damageEffectiveness = 6.81, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
	},
}
skills["Sweep"] = {
	name = "Sweep",
	baseTypeName = "Sweep",
	color = 1,
	description = "Swings a two handed melee weapon in a circle, knocking back monsters around the character.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.15,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.2 },
		},
	},
	stats = {
		"active_skill_base_radius_+",
		"is_area_damage",
		"console_skill_dont_chase",
		"global_knockback",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, attackSpeedMultiplier = -30, baseMultiplier = 2.892, damageEffectiveness = 2.892, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 0, attackSpeedMultiplier = -30, baseMultiplier = 3.021, damageEffectiveness = 3.021, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 0, attackSpeedMultiplier = -30, baseMultiplier = 3.163, damageEffectiveness = 3.163, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 0, attackSpeedMultiplier = -30, baseMultiplier = 3.31, damageEffectiveness = 3.31, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 3.465, damageEffectiveness = 3.465, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 3.627, damageEffectiveness = 3.627, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[7] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 3.796, damageEffectiveness = 3.796, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[8] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 3.965, damageEffectiveness = 3.965, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 1, attackSpeedMultiplier = -30, baseMultiplier = 4.142, damageEffectiveness = 4.142, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[10] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 4.327, damageEffectiveness = 4.327, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[11] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 4.521, damageEffectiveness = 4.521, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[12] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 4.721, damageEffectiveness = 4.721, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[13] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 4.932, damageEffectiveness = 4.932, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[14] = { 2, attackSpeedMultiplier = -30, baseMultiplier = 5.152, damageEffectiveness = 5.152, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[15] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 5.381, damageEffectiveness = 5.381, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[16] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 5.62, damageEffectiveness = 5.62, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[17] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 5.861, damageEffectiveness = 5.861, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[18] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 6.111, damageEffectiveness = 6.111, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[19] = { 3, attackSpeedMultiplier = -30, baseMultiplier = 6.372, damageEffectiveness = 6.372, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[20] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 6.644, damageEffectiveness = 6.644, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[21] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 6.927, damageEffectiveness = 6.927, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[22] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 7.223, damageEffectiveness = 7.223, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[23] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 7.532, damageEffectiveness = 7.532, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[24] = { 4, attackSpeedMultiplier = -30, baseMultiplier = 7.852, damageEffectiveness = 7.852, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[25] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 8.187, damageEffectiveness = 8.187, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[26] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 8.536, damageEffectiveness = 8.536, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[27] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 8.9, damageEffectiveness = 8.9, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[28] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 9.279, damageEffectiveness = 9.279, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[29] = { 5, attackSpeedMultiplier = -30, baseMultiplier = 9.674, damageEffectiveness = 9.674, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[30] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 10.086, damageEffectiveness = 10.086, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[31] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 10.705, damageEffectiveness = 10.705, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[32] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 10.932, damageEffectiveness = 10.932, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[33] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 11.165, damageEffectiveness = 11.165, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[34] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 11.402, damageEffectiveness = 11.402, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[35] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 11.644, damageEffectiveness = 11.644, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[36] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 11.892, damageEffectiveness = 11.892, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[37] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 12.145, damageEffectiveness = 12.145, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[38] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 12.402, damageEffectiveness = 12.402, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[39] = { 6, attackSpeedMultiplier = -30, baseMultiplier = 12.666, damageEffectiveness = 12.666, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[40] = { 7, attackSpeedMultiplier = -30, baseMultiplier = 12.934, damageEffectiveness = 12.934, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 17, }, },
	},
}
skills["TectonicSlam"] = {
	name = "Tectonic Slam",
	baseTypeName = "Tectonic Slam",
	color = 1,
	description = "Slam the ground, unleashing a fiery fissure in front of you, dealing area damage and randomly releasing a number of smaller fissures branching off from it. Consume an Endurance Charge every third time you slam the ground with this skill. Requires a Mace, Sceptre, Sword, Axe, Staff, or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("radiusLabel", "Fissure Length:"),
		skill("radiusSecondary", 7),
		skill("radiusSecondaryLabel", "Fissure Width:"),
	},
	qualityStats = {
		Default = {
			{ "tectonic_slam_side_crack_additional_chance_%", 1.5 },
		},
	},
	constantStats = {
		{ "tectonic_slam_side_crack_additional_chance_%_per_endurance_charge", 5 },
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "active_skill_area_of_effect_+%_final_per_endurance_charge", 5 },
		{ "tectonic_slam_side_crack_additional_chance_%", 30 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_tectonic_slam_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 2.951, damageEffectiveness = 2.951, levelRequirement = 28, cost = { Mana = 9, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 3.053, damageEffectiveness = 3.053, levelRequirement = 31, cost = { Mana = 9, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 3.156, damageEffectiveness = 3.156, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 3.264, damageEffectiveness = 3.264, levelRequirement = 37, cost = { Mana = 10, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 3.374, damageEffectiveness = 3.374, levelRequirement = 40, cost = { Mana = 10, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 3.484, damageEffectiveness = 3.484, levelRequirement = 42, cost = { Mana = 10, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 3.595, damageEffectiveness = 3.595, levelRequirement = 44, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 3.711, damageEffectiveness = 3.711, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 3.83, damageEffectiveness = 3.83, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 3.954, damageEffectiveness = 3.954, levelRequirement = 50, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 4.081, damageEffectiveness = 4.081, levelRequirement = 52, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 4.211, damageEffectiveness = 4.211, levelRequirement = 54, cost = { Mana = 11, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 4.346, damageEffectiveness = 4.346, levelRequirement = 56, cost = { Mana = 11, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 4.486, damageEffectiveness = 4.486, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 4.631, damageEffectiveness = 4.631, levelRequirement = 60, cost = { Mana = 12, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 4.779, damageEffectiveness = 4.779, levelRequirement = 62, cost = { Mana = 12, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 4.932, damageEffectiveness = 4.932, levelRequirement = 64, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 5.09, damageEffectiveness = 5.09, levelRequirement = 66, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 5.253, damageEffectiveness = 5.253, levelRequirement = 68, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 5.422, damageEffectiveness = 5.422, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 5.596, damageEffectiveness = 5.596, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 5.774, damageEffectiveness = 5.774, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 5.959, damageEffectiveness = 5.959, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 6.15, damageEffectiveness = 6.15, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 6.346, damageEffectiveness = 6.346, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 6.55, damageEffectiveness = 6.55, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 6.759, damageEffectiveness = 6.759, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 6.975, damageEffectiveness = 6.975, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 7.198, damageEffectiveness = 7.198, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 7.427, damageEffectiveness = 7.427, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 7.762, damageEffectiveness = 7.762, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 7.885, damageEffectiveness = 7.885, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 8.011, damageEffectiveness = 8.011, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 8.139, damageEffectiveness = 8.139, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 8.268, damageEffectiveness = 8.268, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 8.4, damageEffectiveness = 8.4, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 8.534, damageEffectiveness = 8.534, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 8.669, damageEffectiveness = 8.669, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 8.808, damageEffectiveness = 8.808, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 8.948, damageEffectiveness = 8.948, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["TectonicSlamAltX"] = {
	name = "Tectonic Slam of Cataclysm",
	baseTypeName = "Tectonic Slam of Cataclysm",
	color = 1,
	description = "Slam the ground, consuming all Endurance Charges and unleashing a fiery fissure in front of you, dealing area damage and randomly releasing a number of smaller fissures branching off from it. Requires a Mace, Sceptre, Sword, Axe, Staff, or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["endurance_charge_slam_damage_+%_final_per_endurance_charge_consumed"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "RemovableEnduranceCharge" }),
		},
		["tectonic_slam_area_of_effect_+%_final_per_endurance_charge_consumed"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "RemovableEnduranceCharge" }),
		},
		["quality_display_alternate_tectonic_slam_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("radiusLabel", "Fissure Length:"),
		skill("radiusSecondary", 7),
		skill("radiusSecondaryLabel", "Fissure Width:"),
	},
	qualityStats = {
		Default = {
			{ "endurance_charge_slam_damage_+%_final_per_endurance_charge_consumed", 0.25 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "endurance_charge_slam_damage_+%_final_per_endurance_charge_consumed", 15 },
		{ "tectonic_slam_side_crack_additional_chance_%_per_endurance_charge_consumed", 10 },
		{ "tectonic_slam_area_of_effect_+%_final_per_endurance_charge_consumed", 10 },
	},
	stats = {
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_alternate_tectonic_slam_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 2.573, damageEffectiveness = 2.573, levelRequirement = 28, cost = { Mana = 9, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 2.661, damageEffectiveness = 2.661, levelRequirement = 31, cost = { Mana = 9, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 2.751, damageEffectiveness = 2.751, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 2.845, damageEffectiveness = 2.845, levelRequirement = 37, cost = { Mana = 10, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 2.942, damageEffectiveness = 2.942, levelRequirement = 40, cost = { Mana = 10, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 3.036, damageEffectiveness = 3.036, levelRequirement = 42, cost = { Mana = 10, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 3.134, damageEffectiveness = 3.134, levelRequirement = 44, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 3.235, damageEffectiveness = 3.235, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 3.339, damageEffectiveness = 3.339, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 3.446, damageEffectiveness = 3.446, levelRequirement = 50, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 3.558, damageEffectiveness = 3.558, levelRequirement = 52, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 3.672, damageEffectiveness = 3.672, levelRequirement = 54, cost = { Mana = 11, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 3.79, damageEffectiveness = 3.79, levelRequirement = 56, cost = { Mana = 11, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 3.911, damageEffectiveness = 3.911, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 4.036, damageEffectiveness = 4.036, levelRequirement = 60, cost = { Mana = 12, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 4.167, damageEffectiveness = 4.167, levelRequirement = 62, cost = { Mana = 12, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 4.3, damageEffectiveness = 4.3, levelRequirement = 64, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 4.437, damageEffectiveness = 4.437, levelRequirement = 66, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 4.58, damageEffectiveness = 4.58, levelRequirement = 68, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 4.726, damageEffectiveness = 4.726, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 4.878, damageEffectiveness = 4.878, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 5.034, damageEffectiveness = 5.034, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 5.195, damageEffectiveness = 5.195, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 5.362, damageEffectiveness = 5.362, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 5.532, damageEffectiveness = 5.532, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 5.71, damageEffectiveness = 5.71, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 5.892, damageEffectiveness = 5.892, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 6.08, damageEffectiveness = 6.08, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 6.275, damageEffectiveness = 6.275, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 6.475, damageEffectiveness = 6.475, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 6.767, damageEffectiveness = 6.767, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 6.875, damageEffectiveness = 6.875, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 6.984, damageEffectiveness = 6.984, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 7.096, damageEffectiveness = 7.096, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 7.208, damageEffectiveness = 7.208, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 7.323, damageEffectiveness = 7.323, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 7.44, damageEffectiveness = 7.44, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 7.558, damageEffectiveness = 7.558, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 7.678, damageEffectiveness = 7.678, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 7.801, damageEffectiveness = 7.801, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["VengefulCry"] = {
	name = "Vengeful Cry",
	baseTypeName = "Vengeful Cry",
	color = 1,
	description = "Retaliate against a savage hit with a warcry, taunting all nearby enemies to attack the user. The user and nearby allies gain a buff which grants rage and prevents rage from being lost. Minions cannot gain rage.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, [SkillType.Retaliation] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["rage_warcry_gain_X_rage_per_minute_per_5_monster_power_max_25_power"] = {
			mod("RageRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry", div = 5, limit = 25 }),
			flag("Condition:CanGainRage", { type = "GlobalEffect", effectType = "Warcry"} ),
			flag("InherentRageLossIsPrevented", { type = "GlobalEffect", effectType = "Warcry"} ),
			div = 60,
		},
		["rage_warcry_maximum_rage_+"] = {
			mod("MaximumRage", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Warcry" }),
		},
		["display_retaliation_use_requirement_variation"] = {
			-- Display only
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "retaliation_base_use_window_duration_ms", 2000 },
		{ "display_retaliation_use_requirement_variation", 1 },
		{ "rage_warcry_gain_X_rage_per_minute_per_5_monster_power_max_25_power", 180 },
		{ "rage_warcry_maximum_rage_+", 25 },
	},
	stats = {
		"warcry_speed_+%",
		"base_skill_effect_duration",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
		"warcry_count_power_from_enemies",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 2500, cooldown = 8, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[2] = { 2, 2500, cooldown = 8, levelRequirement = 27, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 4, 2600, cooldown = 8, levelRequirement = 30, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 6, 2600, cooldown = 8, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 8, 2700, cooldown = 8, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 10, 2700, cooldown = 8, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 12, 2800, cooldown = 8, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 14, 2800, cooldown = 8, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 16, 2900, cooldown = 8, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 18, 2900, cooldown = 8, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 20, 3000, cooldown = 8, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 22, 3000, cooldown = 8, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 24, 3100, cooldown = 8, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 26, 3100, cooldown = 8, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 28, 3200, cooldown = 8, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 30, 3200, cooldown = 8, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 32, 3300, cooldown = 8, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 34, 3300, cooldown = 8, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 36, 3400, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 38, 3400, cooldown = 8, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[21] = { 40, 3500, cooldown = 8, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 41, 3500, cooldown = 8, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[23] = { 42, 3600, cooldown = 8, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[24] = { 43, 3600, cooldown = 8, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[25] = { 44, 3700, cooldown = 8, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[26] = { 45, 3700, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[27] = { 46, 3800, cooldown = 8, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[28] = { 47, 3800, cooldown = 8, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 48, 3900, cooldown = 8, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 49, 3900, cooldown = 8, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 49, 3900, cooldown = 8, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[32] = { 50, 4000, cooldown = 8, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[33] = { 50, 4000, cooldown = 8, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[34] = { 51, 4000, cooldown = 8, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[35] = { 51, 4000, cooldown = 8, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[36] = { 52, 4100, cooldown = 8, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[37] = { 52, 4100, cooldown = 8, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[38] = { 53, 4100, cooldown = 8, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[39] = { 53, 4100, cooldown = 8, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[40] = { 54, 4200, cooldown = 8, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
	},
}
skills["VigilantStrike"] = {
	name = "Vigilant Strike",
	baseTypeName = "Vigilant Strike",
	color = 1,
	description = "Attacks enemies with a powerful melee strike which grants Fortification, reducing damage you take from hits. The cooldown can be bypassed by expending an Endurance Charge. Requires a Melee Weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Buff] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_attack_damage_+%_final_per_endurance_charge", 0.2 },
		},
	},
	constantStats = {
		{ "gain_fortify_on_melee_hit_ms", 8000 },
	},
	stats = {
	},
	levels = {
		[1] = { attackSpeedMultiplier = -15, baseMultiplier = 2.902, cooldown = 4, damageEffectiveness = 2.902, levelRequirement = 4, storedUses = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -15, baseMultiplier = 3.043, cooldown = 4, damageEffectiveness = 3.043, levelRequirement = 6, storedUses = 1, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -15, baseMultiplier = 3.197, cooldown = 4, damageEffectiveness = 3.197, levelRequirement = 9, storedUses = 1, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -15, baseMultiplier = 3.357, cooldown = 4, damageEffectiveness = 3.357, levelRequirement = 12, storedUses = 1, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -15, baseMultiplier = 3.532, cooldown = 4, damageEffectiveness = 3.532, levelRequirement = 16, storedUses = 1, cost = { Mana = 8, }, },
		[6] = { attackSpeedMultiplier = -15, baseMultiplier = 3.716, cooldown = 4, damageEffectiveness = 3.716, levelRequirement = 20, storedUses = 1, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -15, baseMultiplier = 3.911, cooldown = 4, damageEffectiveness = 3.911, levelRequirement = 24, storedUses = 1, cost = { Mana = 8, }, },
		[8] = { attackSpeedMultiplier = -15, baseMultiplier = 4.114, cooldown = 4, damageEffectiveness = 4.114, levelRequirement = 28, storedUses = 1, cost = { Mana = 9, }, },
		[9] = { attackSpeedMultiplier = -15, baseMultiplier = 4.328, cooldown = 4, damageEffectiveness = 4.328, levelRequirement = 32, storedUses = 1, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -15, baseMultiplier = 4.552, cooldown = 4, damageEffectiveness = 4.552, levelRequirement = 36, storedUses = 1, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -15, baseMultiplier = 4.788, cooldown = 4, damageEffectiveness = 4.788, levelRequirement = 40, storedUses = 1, cost = { Mana = 10, }, },
		[12] = { attackSpeedMultiplier = -15, baseMultiplier = 5.036, cooldown = 4, damageEffectiveness = 5.036, levelRequirement = 44, storedUses = 1, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -15, baseMultiplier = 5.298, cooldown = 4, damageEffectiveness = 5.298, levelRequirement = 48, storedUses = 1, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -15, baseMultiplier = 5.571, cooldown = 4, damageEffectiveness = 5.571, levelRequirement = 52, storedUses = 1, cost = { Mana = 10, }, },
		[15] = { attackSpeedMultiplier = -15, baseMultiplier = 5.849, cooldown = 4, damageEffectiveness = 5.849, levelRequirement = 55, storedUses = 1, cost = { Mana = 11, }, },
		[16] = { attackSpeedMultiplier = -15, baseMultiplier = 6.142, cooldown = 4, damageEffectiveness = 6.142, levelRequirement = 58, storedUses = 1, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -15, baseMultiplier = 6.447, cooldown = 4, damageEffectiveness = 6.447, levelRequirement = 61, storedUses = 1, cost = { Mana = 11, }, },
		[18] = { attackSpeedMultiplier = -15, baseMultiplier = 6.769, cooldown = 4, damageEffectiveness = 6.769, levelRequirement = 64, storedUses = 1, cost = { Mana = 11, }, },
		[19] = { attackSpeedMultiplier = -15, baseMultiplier = 7.106, cooldown = 4, damageEffectiveness = 7.106, levelRequirement = 67, storedUses = 1, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -15, baseMultiplier = 7.459, cooldown = 4, damageEffectiveness = 7.459, levelRequirement = 70, storedUses = 1, cost = { Mana = 12, }, },
		[21] = { attackSpeedMultiplier = -15, baseMultiplier = 7.819, cooldown = 4, damageEffectiveness = 7.819, levelRequirement = 72, storedUses = 1, cost = { Mana = 12, }, },
		[22] = { attackSpeedMultiplier = -15, baseMultiplier = 8.194, cooldown = 4, damageEffectiveness = 8.194, levelRequirement = 74, storedUses = 1, cost = { Mana = 12, }, },
		[23] = { attackSpeedMultiplier = -15, baseMultiplier = 8.587, cooldown = 4, damageEffectiveness = 8.587, levelRequirement = 76, storedUses = 1, cost = { Mana = 12, }, },
		[24] = { attackSpeedMultiplier = -15, baseMultiplier = 9, cooldown = 4, damageEffectiveness = 9, levelRequirement = 78, storedUses = 1, cost = { Mana = 12, }, },
		[25] = { attackSpeedMultiplier = -15, baseMultiplier = 9.432, cooldown = 4, damageEffectiveness = 9.432, levelRequirement = 80, storedUses = 1, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -15, baseMultiplier = 9.884, cooldown = 4, damageEffectiveness = 9.884, levelRequirement = 82, storedUses = 1, cost = { Mana = 13, }, },
		[27] = { attackSpeedMultiplier = -15, baseMultiplier = 10.359, cooldown = 4, damageEffectiveness = 10.359, levelRequirement = 84, storedUses = 1, cost = { Mana = 13, }, },
		[28] = { attackSpeedMultiplier = -15, baseMultiplier = 10.856, cooldown = 4, damageEffectiveness = 10.856, levelRequirement = 86, storedUses = 1, cost = { Mana = 13, }, },
		[29] = { attackSpeedMultiplier = -15, baseMultiplier = 11.376, cooldown = 4, damageEffectiveness = 11.376, levelRequirement = 88, storedUses = 1, cost = { Mana = 13, }, },
		[30] = { attackSpeedMultiplier = -15, baseMultiplier = 11.921, cooldown = 4, damageEffectiveness = 11.921, levelRequirement = 90, storedUses = 1, cost = { Mana = 13, }, },
		[31] = { attackSpeedMultiplier = -15, baseMultiplier = 12.752, cooldown = 4, damageEffectiveness = 12.752, levelRequirement = 91, storedUses = 1, cost = { Mana = 13, }, },
		[32] = { attackSpeedMultiplier = -15, baseMultiplier = 13.057, cooldown = 4, damageEffectiveness = 13.057, levelRequirement = 92, storedUses = 1, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -15, baseMultiplier = 13.37, cooldown = 4, damageEffectiveness = 13.37, levelRequirement = 93, storedUses = 1, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -15, baseMultiplier = 13.69, cooldown = 4, damageEffectiveness = 13.69, levelRequirement = 94, storedUses = 1, cost = { Mana = 14, }, },
		[35] = { attackSpeedMultiplier = -15, baseMultiplier = 14.018, cooldown = 4, damageEffectiveness = 14.018, levelRequirement = 95, storedUses = 1, cost = { Mana = 14, }, },
		[36] = { attackSpeedMultiplier = -15, baseMultiplier = 14.352, cooldown = 4, damageEffectiveness = 14.352, levelRequirement = 96, storedUses = 1, cost = { Mana = 14, }, },
		[37] = { attackSpeedMultiplier = -15, baseMultiplier = 14.695, cooldown = 4, damageEffectiveness = 14.695, levelRequirement = 97, storedUses = 1, cost = { Mana = 14, }, },
		[38] = { attackSpeedMultiplier = -15, baseMultiplier = 15.047, cooldown = 4, damageEffectiveness = 15.047, levelRequirement = 98, storedUses = 1, cost = { Mana = 14, }, },
		[39] = { attackSpeedMultiplier = -15, baseMultiplier = 15.407, cooldown = 4, damageEffectiveness = 15.407, levelRequirement = 99, storedUses = 1, cost = { Mana = 14, }, },
		[40] = { attackSpeedMultiplier = -15, baseMultiplier = 15.775, cooldown = 4, damageEffectiveness = 15.775, levelRequirement = 100, storedUses = 1, cost = { Mana = 14, }, },
	},
}
skills["Vitality"] = {
	name = "Vitality",
	baseTypeName = "Vitality",
	color = 1,
	description = "Casts an aura that grants life regeneration to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"base_life_regeneration_rate_per_minute",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 600, 0, cooldown = 1.2, levelRequirement = 10, manaReservationFlat = 28, storedUses = 1, statInterpolation = { 1, 1, }, },
		[2] = { 725, 1, cooldown = 1.2, levelRequirement = 13, manaReservationFlat = 40, storedUses = 1, statInterpolation = { 1, 1, }, },
		[3] = { 977, 2, cooldown = 1.2, levelRequirement = 17, manaReservationFlat = 51, storedUses = 1, statInterpolation = { 1, 1, }, },
		[4] = { 1184, 3, cooldown = 1.2, levelRequirement = 21, manaReservationFlat = 63, storedUses = 1, statInterpolation = { 1, 1, }, },
		[5] = { 1370, 4, cooldown = 1.2, levelRequirement = 25, manaReservationFlat = 74, storedUses = 1, statInterpolation = { 1, 1, }, },
		[6] = { 1760, 5, cooldown = 1.2, levelRequirement = 29, manaReservationFlat = 85, storedUses = 1, statInterpolation = { 1, 1, }, },
		[7] = { 2284, 6, cooldown = 1.2, levelRequirement = 33, manaReservationFlat = 96, storedUses = 1, statInterpolation = { 1, 1, }, },
		[8] = { 2556, 7, cooldown = 1.2, levelRequirement = 36, manaReservationFlat = 108, storedUses = 1, statInterpolation = { 1, 1, }, },
		[9] = { 2831, 8, cooldown = 1.2, levelRequirement = 39, manaReservationFlat = 118, storedUses = 1, statInterpolation = { 1, 1, }, },
		[10] = { 3370, 9, cooldown = 1.2, levelRequirement = 42, manaReservationFlat = 128, storedUses = 1, statInterpolation = { 1, 1, }, },
		[11] = { 3915, 10, cooldown = 1.2, levelRequirement = 45, manaReservationFlat = 138, storedUses = 1, statInterpolation = { 1, 1, }, },
		[12] = { 4730, 11, cooldown = 1.2, levelRequirement = 48, manaReservationFlat = 148, storedUses = 1, statInterpolation = { 1, 1, }, },
		[13] = { 5557, 12, cooldown = 1.2, levelRequirement = 51, manaReservationFlat = 158, storedUses = 1, statInterpolation = { 1, 1, }, },
		[14] = { 6394, 13, cooldown = 1.2, levelRequirement = 54, manaReservationFlat = 169, storedUses = 1, statInterpolation = { 1, 1, }, },
		[15] = { 7241, 14, cooldown = 1.2, levelRequirement = 57, manaReservationFlat = 178, storedUses = 1, statInterpolation = { 1, 1, }, },
		[16] = { 8100, 15, cooldown = 1.2, levelRequirement = 60, manaReservationFlat = 189, storedUses = 1, statInterpolation = { 1, 1, }, },
		[17] = { 9241, 16, cooldown = 1.2, levelRequirement = 63, manaReservationFlat = 199, storedUses = 1, statInterpolation = { 1, 1, }, },
		[18] = { 10397, 17, cooldown = 1.2, levelRequirement = 66, manaReservationFlat = 209, storedUses = 1, statInterpolation = { 1, 1, }, },
		[19] = { 10992, 18, cooldown = 1.2, levelRequirement = 68, manaReservationFlat = 221, storedUses = 1, statInterpolation = { 1, 1, }, },
		[20] = { 11592, 19, cooldown = 1.2, levelRequirement = 70, manaReservationFlat = 233, storedUses = 1, statInterpolation = { 1, 1, }, },
		[21] = { 12197, 20, cooldown = 1.2, levelRequirement = 72, manaReservationFlat = 244, storedUses = 1, statInterpolation = { 1, 1, }, },
		[22] = { 12806, 21, cooldown = 1.2, levelRequirement = 74, manaReservationFlat = 253, storedUses = 1, statInterpolation = { 1, 1, }, },
		[23] = { 13421, 22, cooldown = 1.2, levelRequirement = 76, manaReservationFlat = 261, storedUses = 1, statInterpolation = { 1, 1, }, },
		[24] = { 14040, 23, cooldown = 1.2, levelRequirement = 78, manaReservationFlat = 269, storedUses = 1, statInterpolation = { 1, 1, }, },
		[25] = { 14664, 24, cooldown = 1.2, levelRequirement = 80, manaReservationFlat = 278, storedUses = 1, statInterpolation = { 1, 1, }, },
		[26] = { 15293, 25, cooldown = 1.2, levelRequirement = 82, manaReservationFlat = 286, storedUses = 1, statInterpolation = { 1, 1, }, },
		[27] = { 15926, 26, cooldown = 1.2, levelRequirement = 84, manaReservationFlat = 294, storedUses = 1, statInterpolation = { 1, 1, }, },
		[28] = { 16565, 27, cooldown = 1.2, levelRequirement = 86, manaReservationFlat = 303, storedUses = 1, statInterpolation = { 1, 1, }, },
		[29] = { 17208, 28, cooldown = 1.2, levelRequirement = 88, manaReservationFlat = 311, storedUses = 1, statInterpolation = { 1, 1, }, },
		[30] = { 17856, 29, cooldown = 1.2, levelRequirement = 90, manaReservationFlat = 319, storedUses = 1, statInterpolation = { 1, 1, }, },
		[31] = { 18182, 29, cooldown = 1.2, levelRequirement = 91, manaReservationFlat = 338, storedUses = 1, statInterpolation = { 1, 1, }, },
		[32] = { 18509, 30, cooldown = 1.2, levelRequirement = 92, manaReservationFlat = 348, storedUses = 1, statInterpolation = { 1, 1, }, },
		[33] = { 18837, 30, cooldown = 1.2, levelRequirement = 93, manaReservationFlat = 358, storedUses = 1, statInterpolation = { 1, 1, }, },
		[34] = { 19166, 31, cooldown = 1.2, levelRequirement = 94, manaReservationFlat = 368, storedUses = 1, statInterpolation = { 1, 1, }, },
		[35] = { 19497, 31, cooldown = 1.2, levelRequirement = 95, manaReservationFlat = 379, storedUses = 1, statInterpolation = { 1, 1, }, },
		[36] = { 19829, 32, cooldown = 1.2, levelRequirement = 96, manaReservationFlat = 389, storedUses = 1, statInterpolation = { 1, 1, }, },
		[37] = { 20162, 32, cooldown = 1.2, levelRequirement = 97, manaReservationFlat = 399, storedUses = 1, statInterpolation = { 1, 1, }, },
		[38] = { 20496, 33, cooldown = 1.2, levelRequirement = 98, manaReservationFlat = 409, storedUses = 1, statInterpolation = { 1, 1, }, },
		[39] = { 20831, 33, cooldown = 1.2, levelRequirement = 99, manaReservationFlat = 419, storedUses = 1, statInterpolation = { 1, 1, }, },
		[40] = { 21168, 34, cooldown = 1.2, levelRequirement = 100, manaReservationFlat = 429, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["VolcanicFissure"] = {
	name = "Volcanic Fissure",
	baseTypeName = "Volcanic Fissure",
	color = 1,
	description = "Slam the ground, creating a winding fissure that deals area damage while travelling outwards. When it reaches the target location it erupts, releasing a burst of molten projectiles. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Fire] = true, [SkillType.Multistrikeable] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Ground Fissure",
			melee = true,
			projectile = false,
		},
		{
			name = "Magma Balls",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		melee = true,
		attack = true,
		projectile = true,
		area = true,
		slam = true,
	},
	baseMods = {
		flag("CannotSplit"),
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.1 },
		},
	},
	constantStats = {
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -50 },
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
	},
	stats = {
		"base_number_of_projectiles",
		"is_area_damage",
		"show_number_of_projectiles",
		"projectiles_not_offset",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 1.779, damageEffectiveness = 1.779, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 1.843, damageEffectiveness = 1.843, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 1.912, damageEffectiveness = 1.912, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 1.984, damageEffectiveness = 1.984, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.057, damageEffectiveness = 2.057, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.134, damageEffectiveness = 2.134, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.213, damageEffectiveness = 2.213, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.292, damageEffectiveness = 2.292, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.372, damageEffectiveness = 2.372, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.457, damageEffectiveness = 2.457, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.543, damageEffectiveness = 2.543, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.633, damageEffectiveness = 2.633, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.726, damageEffectiveness = 2.726, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.822, damageEffectiveness = 2.822, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 2.921, damageEffectiveness = 2.921, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.024, damageEffectiveness = 3.024, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.125, damageEffectiveness = 3.125, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.23, damageEffectiveness = 3.23, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.337, damageEffectiveness = 3.337, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.448, damageEffectiveness = 3.448, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.564, damageEffectiveness = 3.564, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.682, damageEffectiveness = 3.682, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.806, damageEffectiveness = 3.806, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 3.932, damageEffectiveness = 3.932, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 4.063, damageEffectiveness = 4.063, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 4.199, damageEffectiveness = 4.199, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 4.339, damageEffectiveness = 4.339, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 4.483, damageEffectiveness = 4.483, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 5, attackSpeedMultiplier = -20, baseMultiplier = 4.632, damageEffectiveness = 4.632, levelRequirement = 88, statInterpolation = { 1, }, cost