-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Active Dexterity skill gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AlchemistsMark"] = {
	name = "Alchemist's Mark",
	baseTypeName = "Alchemist's Mark",
	color = 2,
	baseEffectiveness = 0,
	description = "Curses a single enemy, granting flask charges when you hit them and creating Burning Ground under them if your hit Ignites them, and Caustic Ground if it Poisons them. Damage modifiers do not apply to these ground effects. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.AreaSpell] = true, [SkillType.Fire] = true, [SkillType.Chaos] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["alchemists_mark_igniter_creates_burning_ground_%_ignite_damage"] = {
			mod("IgniteDpsAsBurningGround", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["alchemists_mark_poisoner_creates_caustic_ground_%_poison_damage"] = {
			mod("PoisonDpsAsCausticGround", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["alchemists_mark_grant_attacker_x_flask_charges_when_hit_once_per_3s"] = {
			-- Uncomment below and delete subsequent line when we get "per hit" flask charge generation working
			-- mod("FlaskChargesGenerated", "BASE", nil, 0, KeywordFlag.Hit, { type = "ActorCondition", actor = "enemy", var = "Cursed" }),
			-- Delete this line if you uncomment the one above: this assume we are hitting the marked target as often as we can
			mod("FlaskChargesGenerated", "BASE", nil),
			div = 3,
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		mark = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 20),
	},
	qualityStats = {
		Default = {
			{ "mark_skills_curse_effect_+%", 0.5 },
		},
	},
	constantStats = {
		{ "alchemists_mark_grant_attacker_x_flask_charges_when_hit_once_per_3s", 1 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"alchemists_mark_igniter_creates_burning_ground_%_ignite_damage",
		"alchemists_mark_poisoner_creates_caustic_ground_%_poison_damage",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 20, 60, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[2] = { 20, 61, levelRequirement = 27, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[3] = { 21, 62, levelRequirement = 30, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[4] = { 21, 63, levelRequirement = 33, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[5] = { 21, 64, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[6] = { 22, 65, levelRequirement = 39, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[7] = { 22, 66, levelRequirement = 42, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[8] = { 22, 67, levelRequirement = 45, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[9] = { 23, 68, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[10] = { 23, 69, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[11] = { 23, 70, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[12] = { 24, 71, levelRequirement = 54, statInterpolation = { 1, 1, }, cost = { Mana = 27, }, },
		[13] = { 24, 72, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 28, }, },
		[14] = { 24, 73, levelRequirement = 58, statInterpolation = { 1, 1, }, cost = { Mana = 29, }, },
		[15] = { 25, 74, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 29, }, },
		[16] = { 25, 75, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 30, }, },
		[17] = { 25, 76, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 31, }, },
		[18] = { 26, 77, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 31, }, },
		[19] = { 26, 78, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 32, }, },
		[20] = { 26, 79, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 33, }, },
		[21] = { 27, 80, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[22] = { 27, 81, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 34, }, },
		[23] = { 27, 82, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 35, }, },
		[24] = { 28, 83, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[25] = { 28, 84, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 36, }, },
		[26] = { 28, 85, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 37, }, },
		[27] = { 29, 86, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 38, }, },
		[28] = { 29, 87, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[29] = { 29, 88, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 39, }, },
		[30] = { 30, 89, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[31] = { 30, 90, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
		[32] = { 30, 91, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[33] = { 30, 92, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 41, }, },
		[34] = { 30, 93, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[35] = { 30, 94, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[36] = { 31, 95, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 42, }, },
		[37] = { 31, 96, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 43, }, },
		[38] = { 31, 97, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 43, }, },
		[39] = { 31, 98, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 43, }, },
		[40] = { 31, 99, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 44, }, },
	},
}
skills["Ambush"] = {
	name = "Ambush",
	baseTypeName = "Ambush",
	color = 2,
	description = "Teleports you to a nearby enemy, applying a buff to you for a short duration and blinding the enemy for a secondary duration. Performing a melee attack with a One-Handed Weapon removes the buff to exert that attack.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Travel] = true, [SkillType.Triggerable] = true, [SkillType.Cooldown] = true, [SkillType.LateConsumeCooldown] = true, },
	statDescriptionScope = "secondary_debuff_skill_stat_descriptions",
	castTime = 0.3,
	statMap = {
		["ambush_additional_critical_strike_chance_permyriad"] = {
			mod("CritChance", "BASE", nil, ModFlag.Melee, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Ambush" }),
			div = 100,
		},
		["vanishing_ambush_critical_strike_multiplier_+"] = {
			mod("CritMultiplier", "BASE", nil, ModFlag.Melee, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Ambush" }),
		},
		-- not excluding Exert for Two-Handed weapons, to simulate a potential weapon swap for skills with a duration ( Rage Vortex )
	},
	baseFlags = {
		spell = true,
		movement = true,
		duration = true,
		travel = true,
	},
	qualityStats = {
		Default = {
			{ "ambush_additional_critical_strike_chance_permyriad", 50 },
		},
	},
	constantStats = {
		{ "skill_empower_limitation_specifier_for_stat_description", 3 },
		{ "skill_empowers_next_x_melee_attacks", 1 },
		{ "ambush_additional_critical_strike_chance_permyriad", 2500 },
		{ "base_secondary_skill_effect_duration", 3000 },
		{ "base_skill_effect_duration", 1500 },
	},
	stats = {
		"vanishing_ambush_critical_strike_multiplier_+",
	},
	levels = {
		[1] = { 100, cooldown = 5, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 102, cooldown = 5, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 104, cooldown = 5, levelRequirement = 38, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 106, cooldown = 5, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 108, cooldown = 5, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[6] = { 110, cooldown = 5, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[7] = { 112, cooldown = 5, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[8] = { 114, cooldown = 5, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[9] = { 116, cooldown = 5, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[10] = { 118, cooldown = 5, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[11] = { 120, cooldown = 5, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[12] = { 122, cooldown = 5, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[13] = { 124, cooldown = 5, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[14] = { 126, cooldown = 5, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[15] = { 128, cooldown = 5, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[16] = { 130, cooldown = 5, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[17] = { 132, cooldown = 5, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[18] = { 134, cooldown = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[19] = { 136, cooldown = 5, levelRequirement = 69, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[20] = { 138, cooldown = 5, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[21] = { 140, cooldown = 5, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[22] = { 142, cooldown = 5, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[23] = { 144, cooldown = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[24] = { 146, cooldown = 5, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[25] = { 148, cooldown = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[26] = { 150, cooldown = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[27] = { 152, cooldown = 5, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[28] = { 154, cooldown = 5, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[29] = { 156, cooldown = 5, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[30] = { 158, cooldown = 5, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 31, }, },
		[31] = { 159, cooldown = 5, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[32] = { 160, cooldown = 5, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[33] = { 161, cooldown = 5, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 33, }, },
		[34] = { 162, cooldown = 5, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[35] = { 163, cooldown = 5, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 35, }, },
		[36] = { 164, cooldown = 5, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 36, }, },
		[37] = { 165, cooldown = 5, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 36, }, },
		[38] = { 166, cooldown = 5, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 37, }, },
		[39] = { 167, cooldown = 5, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 38, }, },
		[40] = { 168, cooldown = 5, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, }, cost = { Mana = 39, }, },
	},
}
skills["AnimateWeapon"] = {
	name = "Animate Weapon",
	baseTypeName = "Animate Weapon",
	color = 2,
	baseEffectiveness = 0.21999999880791,
	incrementalEffectiveness = 0.029999999329448,
	description = "Animates a Melee Weapon Item or Lingering Blade to fight by your side. You cannot animate unidentified Weapons. Will not animate weapons with 6 sockets. Cannot be used by Traps or Mines.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.CreatesMinion] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_minimum_added_physical_damage_for_ethereal_blades"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "ActorCondition", actor = "parent", var = "AnimatingLingeringBlades" }) }),
		},
		["attack_maximum_added_physical_damage_for_ethereal_blades"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "ActorCondition", actor = "parent", var = "AnimatingLingeringBlades" }) }),
		},
		["base_number_of_animated_weapons_allowed"] = {
			mod("Multiplier:AnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_animated_weapons_allowed", 0.1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 40000 },
		{ "display_minion_monster_type", 22 },
	},
	stats = {
		"attack_minimum_added_physical_damage_for_ethereal_blades",
		"attack_maximum_added_physical_damage_for_ethereal_blades",
		"animate_item_maximum_level_requirement",
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_number_of_animated_weapons_allowed",
		"base_display_minion_actor_level",
		"quality_display_animate_weapon_is_gem",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
	},
	levels = {
		[1] = { 0.34999999403954, 1.6499999761581, 9, 0, 0, 5, 8, 5, 4, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 4, }, },
		[2] = { 0.34999999403954, 1.6499999761581, 11, 2, 2, 6, 11, 5, 6, levelRequirement = 6, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 5, }, },
		[3] = { 0.34999999403954, 1.6499999761581, 14, 4, 4, 10, 15, 6, 9, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 5, }, },
		[4] = { 0.34999999403954, 1.6499999761581, 18, 6, 6, 13, 18, 6, 12, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 0.34999999403954, 1.6499999761581, 22, 8, 8, 17, 25, 7, 16, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.34999999403954, 1.6499999761581, 26, 10, 10, 21, 32, 7, 20, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 0.34999999403954, 1.6499999761581, 31, 12, 12, 26, 38, 8, 24, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 0.34999999403954, 1.6499999761581, 35, 14, 14, 32, 47, 8, 28, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 0.34999999403954, 1.6499999761581, 40, 16, 16, 39, 57, 9, 32, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 0.34999999403954, 1.6499999761581, 44, 18, 18, 48, 72, 9, 36, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[11] = { 0.34999999403954, 1.6499999761581, 49, 20, 20, 53, 81, 10, 40, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[12] = { 0.34999999403954, 1.6499999761581, 53, 22, 22, 61, 91, 10, 44, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[13] = { 0.34999999403954, 1.6499999761581, 58, 24, 24, 68, 99, 11, 48, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[14] = { 0.34999999403954, 1.6499999761581, 62, 26, 26, 73, 112, 11, 52, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[15] = { 0.34999999403954, 1.6499999761581, 66, 28, 28, 83, 124, 12, 55, levelRequirement = 55, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[16] = { 0.34999999403954, 1.6499999761581, 70, 30, 30, 89, 136, 12, 58, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[17] = { 0.34999999403954, 1.6499999761581, 74, 32, 32, 99, 148, 13, 61, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[18] = { 0.34999999403954, 1.6499999761581, 78, 34, 34, 108, 159, 13, 64, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[19] = { 0.34999999403954, 1.6499999761581, 82, 36, 36, 115, 173, 14, 67, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[20] = { 0.34999999403954, 1.6499999761581, 100, 38, 38, 126, 184, 14, 70, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[21] = { 0.34999999403954, 1.6299999952316, 100, 39, 39, 130, 190, 15, 72, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[22] = { 0.34000000357628, 1.6100000143051, 100, 40, 40, 134, 196, 15, 74, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[23] = { 0.34000000357628, 1.5900000333786, 100, 41, 41, 138, 202, 16, 76, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[24] = { 0.33000001311302, 1.5700000524521, 100, 42, 42, 142, 208, 16, 78, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[25] = { 0.33000001311302, 1.5499999523163, 100, 43, 43, 146, 214, 17, 80, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[26] = { 0.31999999284744, 1.5299999713898, 100, 44, 44, 150, 220, 17, 82, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[27] = { 0.31999999284744, 1.5099999904633, 100, 45, 45, 155, 227, 18, 84, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[28] = { 0.31000000238419, 1.4900000095367, 100, 46, 46, 160, 234, 18, 86, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 0.31000000238419, 1.4700000286102, 100, 47, 47, 165, 241, 19, 88, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 0.30000001192093, 1.4500000476837, 100, 48, 48, 170, 248, 19, 90, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 0.30000001192093, 1.4299999475479, 100, 49, 49, 175, 255, 20, 91, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[32] = { 0.28999999165535, 1.4099999666214, 100, 50, 50, 180, 263, 20, 92, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[33] = { 0.28999999165535, 1.3899999856949, 100, 51, 51, 185, 271, 21, 93, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[34] = { 0.28000000119209, 1.3700000047684, 100, 52, 52, 191, 279, 21, 94, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[35] = { 0.28000000119209, 1.3500000238419, 100, 53, 53, 197, 287, 22, 95, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[36] = { 0.27000001072884, 1.3300000429153, 100, 54, 54, 203, 296, 22, 96, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[37] = { 0.27000001072884, 1.3099999427795, 100, 55, 55, 209, 305, 23, 97, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[38] = { 0.25999999046326, 1.289999961853, 100, 56, 56, 215, 314, 23, 98, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[39] = { 0.25999999046326, 1.2699999809265, 100, 57, 57, 221, 323, 24, 99, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[40] = { 0.25, 1.25, 100, 58, 58, 228, 333, 24, 100, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
	},
}
skills["AnimateWeaponAltX"] = {
	name = "Animate Weapon of Self Reflection",
	baseTypeName = "Animate Weapon of Self Reflection",
	color = 2,
	baseEffectiveness = 0.21999999880791,
	incrementalEffectiveness = 0.029999999329448,
	description = "Animates a copy of your main hand Melee Weapon to fight by your side. Cannot be used by Totems, Traps or Mines.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.CreatesMinion] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["base_number_of_animated_weapons_allowed"] = {
			mod("Multiplier:AnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_animated_weapons_allowed", 0.05 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 15000 },
		{ "display_minion_monster_type", 22 },
	},
	stats = {
		"animate_item_maximum_level_requirement",
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
		"base_display_minion_actor_level",
		"base_number_of_animated_weapons_allowed",
		"quality_display_animate_weapon_is_gem",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
	},
	levels = {
		[1] = { 9, 0, 0, 4, 6, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 4, }, },
		[2] = { 11, 2, 2, 6, 6, levelRequirement = 6, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 5, }, },
		[3] = { 14, 4, 4, 9, 6, levelRequirement = 9, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 5, }, },
		[4] = { 18, 6, 6, 12, 6, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 22, 8, 8, 16, 6, levelRequirement = 16, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 26, 10, 10, 20, 6, levelRequirement = 20, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 31, 12, 12, 24, 6, levelRequirement = 24, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 35, 14, 14, 28, 6, levelRequirement = 28, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 40, 16, 16, 32, 6, levelRequirement = 32, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 44, 18, 18, 36, 6, levelRequirement = 36, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[11] = { 49, 20, 20, 40, 6, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[12] = { 53, 22, 22, 44, 6, levelRequirement = 44, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[13] = { 58, 24, 24, 48, 6, levelRequirement = 48, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[14] = { 62, 26, 26, 52, 6, levelRequirement = 52, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[15] = { 66, 28, 28, 55, 6, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[16] = { 70, 30, 30, 58, 6, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[17] = { 74, 32, 32, 61, 6, levelRequirement = 61, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[18] = { 78, 34, 34, 64, 6, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[19] = { 82, 36, 36, 67, 6, levelRequirement = 67, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[20] = { 100, 38, 38, 70, 6, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[21] = { 100, 39, 39, 72, 6, levelRequirement = 72, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[22] = { 100, 40, 40, 74, 6, levelRequirement = 74, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[23] = { 100, 41, 41, 76, 6, levelRequirement = 76, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[24] = { 100, 42, 42, 78, 6, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[25] = { 100, 43, 43, 80, 6, levelRequirement = 80, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[26] = { 100, 44, 44, 82, 6, levelRequirement = 82, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[27] = { 100, 45, 45, 84, 6, levelRequirement = 84, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[28] = { 100, 46, 46, 86, 6, levelRequirement = 86, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[29] = { 100, 47, 47, 88, 6, levelRequirement = 88, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[30] = { 100, 48, 48, 90, 6, levelRequirement = 90, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[31] = { 100, 49, 49, 91, 6, levelRequirement = 91, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[32] = { 100, 50, 50, 92, 6, levelRequirement = 92, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[33] = { 100, 51, 51, 93, 6, levelRequirement = 93, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[34] = { 100, 52, 52, 94, 6, levelRequirement = 94, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[35] = { 100, 53, 53, 95, 6, levelRequirement = 95, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[36] = { 100, 54, 54, 96, 6, levelRequirement = 96, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[37] = { 100, 55, 55, 97, 6, levelRequirement = 97, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[38] = { 100, 56, 56, 98, 6, levelRequirement = 98, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[39] = { 100, 57, 57, 99, 6, levelRequirement = 99, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[40] = { 100, 58, 58, 100, 6, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
	},
}
skills["AnimateWeaponAltY"] = {
	name = "Animate Weapon of Ranged Arms",
	baseTypeName = "Animate Weapon of Ranged Arms",
	color = 2,
	baseEffectiveness = 0.21999999880791,
	incrementalEffectiveness = 0.029999999329448,
	description = "Animates a Ranged Weapon Item or Lingering Blade to fight by your side. You cannot animate unidentified Weapons. Will not animate weapons with 6 sockets. Cannot be used by Traps or Mines.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.CreatesMinion] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.75,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_minimum_added_physical_damage_for_ethereal_blades"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "ActorCondition", actor = "parent", var = "AnimatingLingeringBlades" }) }),
		},
		["attack_maximum_added_physical_damage_for_ethereal_blades"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "ActorCondition", actor = "parent", var = "AnimatingLingeringBlades" }) }),
		},
		["base_number_of_animated_weapons_allowed"] = {
			mod("Multiplier:AnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_animated_weapons_allowed", 0.1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 40000 },
		{ "display_minion_monster_type", 22 },
	},
	stats = {
		"attack_minimum_added_physical_damage_for_ethereal_blades",
		"attack_maximum_added_physical_damage_for_ethereal_blades",
		"animate_item_maximum_level_requirement",
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_number_of_animated_weapons_allowed",
		"base_display_minion_actor_level",
		"quality_display_animate_weapon_is_gem",
		"animate_weapon_can_only_animate_range_weapons",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
	},
	levels = {
		[1] = { 0.34999999403954, 1.6499999761581, 9, 0, 0, 5, 8, 5, 4, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 5, }, },
		[2] = { 0.34999999403954, 1.6499999761581, 11, 2, 2, 6, 11, 5, 6, levelRequirement = 6, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.34999999403954, 1.6499999761581, 14, 4, 4, 10, 15, 6, 9, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.34999999403954, 1.6499999761581, 18, 6, 6, 13, 18, 6, 12, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.34999999403954, 1.6499999761581, 22, 8, 8, 17, 25, 7, 16, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 0.34999999403954, 1.6499999761581, 26, 10, 10, 21, 32, 7, 20, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[7] = { 0.34999999403954, 1.6499999761581, 31, 12, 12, 26, 38, 8, 24, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[8] = { 0.34999999403954, 1.6499999761581, 35, 14, 14, 32, 47, 8, 28, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[9] = { 0.34999999403954, 1.6499999761581, 40, 16, 16, 39, 57, 9, 32, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[10] = { 0.34999999403954, 1.6499999761581, 44, 18, 18, 48, 72, 9, 36, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[11] = { 0.34999999403954, 1.6499999761581, 49, 20, 20, 53, 81, 10, 40, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[12] = { 0.34999999403954, 1.6499999761581, 53, 22, 22, 61, 91, 10, 44, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[13] = { 0.34999999403954, 1.6499999761581, 58, 24, 24, 68, 99, 11, 48, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[14] = { 0.34999999403954, 1.6499999761581, 62, 26, 26, 73, 112, 11, 52, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[15] = { 0.34999999403954, 1.6499999761581, 66, 28, 28, 83, 124, 12, 55, levelRequirement = 55, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[16] = { 0.34999999403954, 1.6499999761581, 70, 30, 30, 89, 136, 12, 58, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[17] = { 0.34999999403954, 1.6499999761581, 74, 32, 32, 99, 148, 13, 61, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.34999999403954, 1.6499999761581, 78, 34, 34, 108, 159, 13, 64, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[19] = { 0.34999999403954, 1.6499999761581, 82, 36, 36, 115, 173, 14, 67, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.34999999403954, 1.6499999761581, 100, 38, 38, 126, 184, 14, 70, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.34999999403954, 1.6299999952316, 100, 39, 39, 130, 190, 15, 72, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[22] = { 0.34000000357628, 1.6100000143051, 100, 40, 40, 134, 196, 15, 74, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[23] = { 0.34000000357628, 1.5900000333786, 100, 41, 41, 138, 202, 16, 76, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[24] = { 0.33000001311302, 1.5700000524521, 100, 42, 42, 142, 208, 16, 78, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[25] = { 0.33000001311302, 1.5499999523163, 100, 43, 43, 146, 214, 17, 80, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[26] = { 0.31999999284744, 1.5299999713898, 100, 44, 44, 150, 220, 17, 82, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[27] = { 0.31999999284744, 1.5099999904633, 100, 45, 45, 155, 227, 18, 84, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[28] = { 0.31000000238419, 1.4900000095367, 100, 46, 46, 160, 234, 18, 86, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[29] = { 0.31000000238419, 1.4700000286102, 100, 47, 47, 165, 241, 19, 88, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[30] = { 0.30000001192093, 1.4500000476837, 100, 48, 48, 170, 248, 19, 90, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[31] = { 0.30000001192093, 1.4299999475479, 100, 49, 49, 175, 255, 20, 91, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[32] = { 0.28999999165535, 1.4099999666214, 100, 50, 50, 180, 263, 20, 92, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 29, }, },
		[33] = { 0.28999999165535, 1.3899999856949, 100, 51, 51, 185, 271, 21, 93, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 29, }, },
		[34] = { 0.28000000119209, 1.3700000047684, 100, 52, 52, 191, 279, 21, 94, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 29, }, },
		[35] = { 0.28000000119209, 1.3500000238419, 100, 53, 53, 197, 287, 22, 95, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 30, }, },
		[36] = { 0.27000001072884, 1.3300000429153, 100, 54, 54, 203, 296, 22, 96, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 30, }, },
		[37] = { 0.27000001072884, 1.3099999427795, 100, 55, 55, 209, 305, 23, 97, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 31, }, },
		[38] = { 0.25999999046326, 1.289999961853, 100, 56, 56, 215, 314, 23, 98, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 31, }, },
		[39] = { 0.25999999046326, 1.2699999809265, 100, 57, 57, 221, 323, 24, 99, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 31, }, },
		[40] = { 0.25, 1.25, 100, 58, 58, 228, 333, 24, 100, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 32, }, },
	},
}
skills["VaalAnimateWeapon"] = {
	name = "Vaal Animate Weapon",
	baseTypeName = "Vaal Animate Weapon",
	color = 2,
	baseEffectiveness = 0.21999999880791,
	incrementalEffectiveness = 0.029999999329448,
	description = "Animates multiple Melee Weapon Items and Lingering Blades to fight by your side, and transforms them into different, unique weapons. You cannot animate unidentified Weapons. Will not animate weapons with 6 sockets. Cannot be used by Traps or Mines.",
	skillTypes = { [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.CreatesMinion] = true, [SkillType.Vaal] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", nil) }),
		},
		["base_number_of_animated_weapons_allowed"] = {
			mod("Multiplier:VaalAnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_animated_weapons_allowed", 0.1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 15000 },
		{ "display_minion_monster_type", 22 },
	},
	stats = {
		"animate_item_maximum_level_requirement",
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
		"base_number_of_animated_weapons_allowed",
		"base_display_minion_actor_level",
		"vaal_animate_weapon_minimum_level_requirement",
		"vaal_animate_weapon_raise_up_to_X_weapons_as_uniques",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"quality_display_animate_weapon_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
	},
	levels = {
		[1] = { 9, 50, 0, 5, 4, 1, 5, levelRequirement = 4, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 11, 53, 2, 5, 6, 1, 5, levelRequirement = 6, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 14, 56, 4, 6, 9, 1, 6, levelRequirement = 9, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 18, 59, 6, 6, 12, 1, 6, levelRequirement = 12, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 22, 62, 8, 6, 16, 1, 6, levelRequirement = 16, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 26, 65, 10, 7, 20, 1, 7, levelRequirement = 20, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 31, 68, 12, 7, 24, 1, 7, levelRequirement = 24, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 35, 71, 14, 7, 28, 1, 7, levelRequirement = 28, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 40, 74, 16, 7, 32, 2, 7, levelRequirement = 32, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 44, 77, 18, 8, 36, 6, 8, levelRequirement = 36, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 49, 80, 20, 8, 40, 10, 8, levelRequirement = 40, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 53, 83, 22, 8, 44, 14, 8, levelRequirement = 44, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 58, 86, 24, 8, 48, 18, 8, levelRequirement = 48, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 62, 89, 26, 9, 52, 22, 9, levelRequirement = 52, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 66, 92, 28, 9, 55, 25, 9, levelRequirement = 55, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 70, 95, 30, 9, 58, 28, 9, levelRequirement = 58, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 74, 98, 32, 9, 61, 31, 9, levelRequirement = 61, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 78, 101, 34, 10, 64, 34, 10, levelRequirement = 64, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 82, 104, 36, 10, 67, 37, 10, levelRequirement = 67, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 100, 107, 38, 10, 70, 40, 10, levelRequirement = 70, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 100, 109, 39, 10, 72, 42, 10, levelRequirement = 72, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 100, 110, 40, 11, 74, 44, 11, levelRequirement = 74, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 100, 112, 41, 11, 76, 46, 11, levelRequirement = 76, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 100, 113, 42, 11, 78, 48, 11, levelRequirement = 78, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 100, 115, 43, 11, 80, 50, 11, levelRequirement = 80, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 100, 116, 44, 11, 82, 50, 11, levelRequirement = 82, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 100, 118, 45, 11, 84, 50, 11, levelRequirement = 84, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 100, 119, 46, 11, 86, 50, 11, levelRequirement = 86, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 100, 121, 47, 12, 88, 50, 12, levelRequirement = 88, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 100, 122, 48, 12, 90, 50, 12, levelRequirement = 90, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 100, 124, 49, 12, 91, 50, 12, levelRequirement = 91, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 100, 125, 50, 12, 92, 50, 12, levelRequirement = 92, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 100, 127, 51, 12, 93, 50, 12, levelRequirement = 93, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 100, 128, 52, 12, 94, 50, 12, levelRequirement = 94, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 100, 130, 53, 12, 95, 50, 12, levelRequirement = 95, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 100, 131, 54, 12, 96, 50, 12, levelRequirement = 96, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 100, 133, 55, 12, 97, 50, 12, levelRequirement = 97, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 100, 134, 56, 12, 98, 50, 12, levelRequirement = 98, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 100, 136, 57, 12, 99, 50, 12, levelRequirement = 99, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 100, 137, 58, 13, 100, 50, 13, levelRequirement = 100, soulPreventionDuration = 40, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["ArcticArmour"] = {
	name = "Arctic Armour",
	baseTypeName = "Arctic Armour",
	color = 2,
	incrementalEffectiveness = 0.029999999329448,
	description = "Conjures an icy barrier that chills enemies when they hit you. You drop chilled ground while moving, and take less Fire and Physical damage while stationary.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Totemable] = true, [SkillType.Duration] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Cold] = true, [SkillType.ElementalStatus] = true, [SkillType.Instant] = true, [SkillType.NonHitChill] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["new_arctic_armour_physical_damage_taken_when_hit_+%_final"] = {
			mod("PhysicalDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["new_arctic_armour_fire_damage_taken_when_hit_+%_final"] = {
			mod("FireDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_immune_to_freeze"] = {
			flag("FreezeImmune", { type = "GlobalEffect", effectType = "Buff"}),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "arctic_armour_chill_when_hit_duration", 500 },
		{ "ground_ice_art_variation", 6 },
	},
	stats = {
		"new_arctic_armour_physical_damage_taken_when_hit_+%_final",
		"new_arctic_armour_fire_damage_taken_when_hit_+%_final",
		"base_skill_effect_duration",
		"base_immune_to_freeze",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { -11, -11, 2500, cooldown = 1, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { -12, -11, 2600, cooldown = 1, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { -12, -12, 2700, cooldown = 1, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { -13, -12, 2800, cooldown = 1, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { -13, -13, 2900, cooldown = 1, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { -14, -13, 3000, cooldown = 1, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { -14, -14, 3100, cooldown = 1, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { -15, -14, 3200, cooldown = 1, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { -15, -15, 3300, cooldown = 1, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { -16, -15, 3400, cooldown = 1, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { -16, -16, 3500, cooldown = 1, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { -17, -16, 3600, cooldown = 1, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { -17, -17, 3700, cooldown = 1, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { -18, -17, 3800, cooldown = 1, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { -18, -18, 3900, cooldown = 1, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { -19, -18, 4000, cooldown = 1, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { -19, -19, 4100, cooldown = 1, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { -20, -19, 4200, cooldown = 1, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { -20, -20, 4300, cooldown = 1, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { -21, -20, 4400, cooldown = 1, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { -21, -21, 4500, cooldown = 1, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { -22, -21, 4600, cooldown = 1, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { -22, -22, 4700, cooldown = 1, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { -23, -22, 4800, cooldown = 1, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { -23, -23, 4900, cooldown = 1, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { -24, -23, 5000, cooldown = 1, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { -24, -24, 5100, cooldown = 1, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { -25, -24, 5200, cooldown = 1, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { -25, -25, 5300, cooldown = 1, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { -26, -25, 5400, cooldown = 1, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { -26, -25, 5450, cooldown = 1, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { -26, -26, 5500, cooldown = 1, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { -26, -26, 5550, cooldown = 1, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { -27, -26, 5600, cooldown = 1, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { -27, -26, 5650, cooldown = 1, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { -27, -27, 5700, cooldown = 1, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { -27, -27, 5750, cooldown = 1, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { -28, -27, 5800, cooldown = 1, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { -28, -27, 5850, cooldown = 1, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { -28, -28, 5900, cooldown = 1, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["VaalArcticArmour"] = {
	name = "Vaal Arctic Armour",
	baseTypeName = "Vaal Arctic Armour",
	color = 2,
	description = "Immediately encases you in ice, protecting you for a duration or until you take damage from a number of hits, and also grants a buff once the cast time has finished. You cannot move or perform non-instant actions while in the ice. When the ice breaks, the buff is also removed.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Cold] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["vaal_arctic_armour_damage_taken_+%_final_from_hits"] = {
			mod("VaalArcticArmourMitigation", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
		["vaal_arctic_armour_number_of_hits_absorbed"] = {
			mod("VaalArcticArmourMaxHits", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
		["base_mana_regeneration_rate_per_minute"] = {
			mod("ManaRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
		["base_energy_shield_regeneration_rate_per_minute"] = {
			mod("EnergyShieldRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
		},
	},
	constantStats = {
		{ "vaal_arctic_armour_damage_taken_+%_final_from_hits", -90 },
		{ "vaal_arctic_armour_number_of_hits_absorbed", 3 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_energy_shield_regeneration_rate_per_minute",
		"base_mana_regeneration_rate_per_minute",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 5000, 1200, 300, levelRequirement = 16, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 5000, 1404, 330, levelRequirement = 20, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 5000, 1643, 363, levelRequirement = 24, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 5000, 1922, 399, levelRequirement = 28, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 5000, 2249, 439, levelRequirement = 31, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 5000, 2631, 483, levelRequirement = 34, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 5000, 3078, 532, levelRequirement = 37, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 5000, 3602, 585, levelRequirement = 40, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 5000, 4214, 643, levelRequirement = 43, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 5000, 4930, 707, levelRequirement = 46, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 5000, 5768, 778, levelRequirement = 49, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 5000, 6749, 856, levelRequirement = 52, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 5000, 7896, 942, levelRequirement = 55, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 5000, 9238, 1036, levelRequirement = 58, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 5000, 10809, 1139, levelRequirement = 60, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 5000, 12647, 1253, levelRequirement = 62, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 5000, 14796, 1379, levelRequirement = 64, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 5000, 17312, 1516, levelRequirement = 66, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 5000, 20255, 1668, levelRequirement = 68, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 5000, 23698, 1835, levelRequirement = 70, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 5000, 27727, 2018, levelRequirement = 72, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 5000, 32440, 2220, levelRequirement = 74, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 5000, 37955, 2442, levelRequirement = 76, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 5000, 44408, 2686, levelRequirement = 78, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 5000, 51957, 2955, levelRequirement = 80, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 5000, 60789, 3250, levelRequirement = 82, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 5000, 71124, 3576, levelRequirement = 84, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 5000, 83215, 3933, levelRequirement = 86, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 5000, 97361, 4326, levelRequirement = 88, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 5000, 113913, 4759, levelRequirement = 90, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 5000, 123595, 4997, levelRequirement = 91, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 5000, 134101, 5247, levelRequirement = 92, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 5000, 145499, 5509, levelRequirement = 93, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 5000, 157867, 5785, levelRequirement = 94, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 5000, 171285, 6074, levelRequirement = 95, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 5000, 185845, 6377, levelRequirement = 96, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 5000, 201641, 6696, levelRequirement = 97, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 5000, 218781, 7031, levelRequirement = 98, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 5000, 237377, 7383, levelRequirement = 99, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 5000, 257554, 7752, levelRequirement = 100, soulPreventionDuration = 24, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["ArtilleryBallista"] = {
	name = "Artillery Ballista",
	baseTypeName = "Artillery Ballista",
	color = 2,
	description = "Summons a ballista totem that propels a sequence of fiery arrows into the air. The arrows impact the ground in a line, each dealing area damage to enemies around it. Requires a Bow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.ProjectileNumber] = true, [SkillType.ProjectileSpeed] = true, [SkillType.AttackInPlaceIsDefault] = true, [SkillType.TotemsAreBallistae] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 19,
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		totem = true,
		ballista = true,
	},
	baseMods = {
		flag("OneShotProj"),
	},
	qualityStats = {
		Default = {
			{ "base_number_of_arrows", 0.05 },
		},
	},
	constantStats = {
		{ "base_totem_range", 80 },
		{ "base_totem_duration", 8000 },
		{ "base_number_of_arrows", 6 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
	},
	stats = {
		"attack_skills_additional_ballista_totems_allowed",
		"base_is_projectile",
		"base_skill_is_totemified",
		"is_totem",
		"skill_can_fire_arrows",
		"is_area_damage",
		"is_ranged_attack_totem",
		"quality_display_base_additional_arrows_is_gem",
		"totem_ignores_cooldown",
	},
	levels = {
		[1] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.508, damageEffectiveness = 0.508, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.516, damageEffectiveness = 0.516, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.524, damageEffectiveness = 0.524, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.532, damageEffectiveness = 0.532, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.539, damageEffectiveness = 0.539, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.547, damageEffectiveness = 0.547, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.555, damageEffectiveness = 0.555, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.563, damageEffectiveness = 0.563, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.571, damageEffectiveness = 0.571, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.579, damageEffectiveness = 0.579, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.587, damageEffectiveness = 0.587, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.595, damageEffectiveness = 0.595, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.603, damageEffectiveness = 0.603, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[15] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.611, damageEffectiveness = 0.611, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.618, damageEffectiveness = 0.618, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.626, damageEffectiveness = 0.626, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.634, damageEffectiveness = 0.634, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.642, damageEffectiveness = 0.642, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.65, damageEffectiveness = 0.65, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.658, damageEffectiveness = 0.658, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.666, damageEffectiveness = 0.666, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.674, damageEffectiveness = 0.674, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.682, damageEffectiveness = 0.682, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.689, damageEffectiveness = 0.689, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.697, damageEffectiveness = 0.697, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.705, damageEffectiveness = 0.705, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.713, damageEffectiveness = 0.713, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.721, damageEffectiveness = 0.721, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.729, damageEffectiveness = 0.729, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.733, damageEffectiveness = 0.733, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.737, damageEffectiveness = 0.737, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.741, damageEffectiveness = 0.741, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.745, damageEffectiveness = 0.745, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.749, damageEffectiveness = 0.749, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.753, damageEffectiveness = 0.753, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.757, damageEffectiveness = 0.757, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.761, damageEffectiveness = 0.761, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.764, damageEffectiveness = 0.764, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.768, damageEffectiveness = 0.768, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["ArtilleryBallistaAltX"] = {
	name = "Artillery Ballista of Cross Strafe",
	baseTypeName = "Artillery Ballista of Cross Strafe",
	color = 2,
	description = "Summons a ballista totem that propels a sequence of fiery arrows into the air. The arrows impact the ground in two perpendicular lines, each dealing area damage to enemies around it. Requires a Bow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.ProjectileNumber] = true, [SkillType.ProjectileSpeed] = true, [SkillType.AttackInPlaceIsDefault] = true, [SkillType.TotemsAreBallistae] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 19,
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		totem = true,
		ballista = true,
	},
	baseMods = {
		flag("OneShotProj"),
	},
	qualityStats = {
		Default = {
			{ "base_number_of_arrows", 0.05 },
		},
	},
	constantStats = {
		{ "base_totem_range", 80 },
		{ "base_totem_duration", 8000 },
		{ "base_number_of_arrows", 6 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
	},
	stats = {
		"attack_skills_additional_ballista_totems_allowed",
		"base_is_projectile",
		"base_skill_is_totemified",
		"is_totem",
		"skill_can_fire_arrows",
		"is_area_damage",
		"is_ranged_attack_totem",
		"quality_display_base_additional_arrows_is_gem",
		"totem_ignores_cooldown",
		"artillery_ballista_cross_strafe_pattern",
	},
	levels = {
		[1] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.508, damageEffectiveness = 0.508, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.516, damageEffectiveness = 0.516, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.524, damageEffectiveness = 0.524, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.532, damageEffectiveness = 0.532, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.539, damageEffectiveness = 0.539, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.547, damageEffectiveness = 0.547, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.555, damageEffectiveness = 0.555, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.563, damageEffectiveness = 0.563, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.571, damageEffectiveness = 0.571, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.579, damageEffectiveness = 0.579, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.587, damageEffectiveness = 0.587, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.595, damageEffectiveness = 0.595, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.603, damageEffectiveness = 0.603, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[15] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.611, damageEffectiveness = 0.611, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.618, damageEffectiveness = 0.618, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.626, damageEffectiveness = 0.626, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.634, damageEffectiveness = 0.634, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.642, damageEffectiveness = 0.642, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.65, damageEffectiveness = 0.65, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.658, damageEffectiveness = 0.658, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.666, damageEffectiveness = 0.666, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.674, damageEffectiveness = 0.674, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.682, damageEffectiveness = 0.682, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.689, damageEffectiveness = 0.689, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.697, damageEffectiveness = 0.697, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.705, damageEffectiveness = 0.705, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.713, damageEffectiveness = 0.713, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.721, damageEffectiveness = 0.721, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.729, damageEffectiveness = 0.729, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.733, damageEffectiveness = 0.733, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.737, damageEffectiveness = 0.737, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.741, damageEffectiveness = 0.741, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.745, damageEffectiveness = 0.745, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.749, damageEffectiveness = 0.749, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.753, damageEffectiveness = 0.753, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.757, damageEffectiveness = 0.757, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.761, damageEffectiveness = 0.761, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.764, damageEffectiveness = 0.764, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.768, damageEffectiveness = 0.768, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["ArtilleryBallistaAltY"] = {
	name = "Artillery Ballista of Focus Fire",
	baseTypeName = "Artillery Ballista of Focus Fire",
	color = 2,
	description = "Summons a ballista totem that propels a number of fiery arrows into the air, each targeting a specific enemy. Arrows deal area damage to enemies around it on landing. Requires a Bow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.ProjectileNumber] = true, [SkillType.ProjectileSpeed] = true, [SkillType.AttackInPlaceIsDefault] = true, [SkillType.TotemsAreBallistae] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 19,
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		totem = true,
		ballista = true,
	},
	baseMods = {
		flag("OneShotProj"),
	},
	qualityStats = {
		Default = {
			{ "base_number_of_arrows", 0.05 },
		},
	},
	constantStats = {
		{ "base_totem_range", 80 },
		{ "base_totem_duration", 8000 },
		{ "base_number_of_arrows", 5 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
	},
	stats = {
		"attack_skills_additional_ballista_totems_allowed",
		"base_is_projectile",
		"base_skill_is_totemified",
		"is_totem",
		"skill_can_fire_arrows",
		"is_area_damage",
		"is_ranged_attack_totem",
		"quality_display_base_additional_arrows_is_gem",
		"totem_ignores_cooldown",
		"artillery_ballista_number_of_arrows_is_equal_to_number_of_nearby_targets",
	},
	levels = {
		[1] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.8, damageEffectiveness = 0.8, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.821, damageEffectiveness = 0.821, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.842, damageEffectiveness = 0.842, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.863, damageEffectiveness = 0.863, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.884, damageEffectiveness = 0.884, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.905, damageEffectiveness = 0.905, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.926, damageEffectiveness = 0.926, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.947, damageEffectiveness = 0.947, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.968, damageEffectiveness = 0.968, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 2, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 0.989, damageEffectiveness = 0.989, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.011, damageEffectiveness = 1.011, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.032, damageEffectiveness = 1.032, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.053, damageEffectiveness = 1.053, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.074, damageEffectiveness = 1.074, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[15] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.095, damageEffectiveness = 1.095, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.116, damageEffectiveness = 1.116, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.137, damageEffectiveness = 1.137, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.158, damageEffectiveness = 1.158, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.179, damageEffectiveness = 1.179, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.2, damageEffectiveness = 1.2, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 3, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.221, damageEffectiveness = 1.221, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.242, damageEffectiveness = 1.242, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.263, damageEffectiveness = 1.263, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.284, damageEffectiveness = 1.284, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.305, damageEffectiveness = 1.305, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.326, damageEffectiveness = 1.326, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.347, damageEffectiveness = 1.347, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.368, damageEffectiveness = 1.368, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.389, damageEffectiveness = 1.389, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.411, damageEffectiveness = 1.411, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.421, damageEffectiveness = 1.421, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.432, damageEffectiveness = 1.432, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.442, damageEffectiveness = 1.442, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.453, damageEffectiveness = 1.453, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.463, damageEffectiveness = 1.463, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.474, damageEffectiveness = 1.474, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.484, damageEffectiveness = 1.484, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.495, damageEffectiveness = 1.495, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.505, damageEffectiveness = 1.505, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 4, PvPDamageMultiplier = -30, attackSpeedMultiplier = -50, baseMultiplier = 1.516, damageEffectiveness = 1.516, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["Barrage"] = {
	name = "Barrage",
	baseTypeName = "Barrage",
	color = 2,
	description = "After a short preparation time, you fire individual projectiles repeatedly with a Bow or Wand. These projectiles have a small randomised spread. This skill cannot be Triggered.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.WandAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Wand"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	statMap = {
		["projectiles_barrage"] = {
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.05 },
		},
	},
	constantStats = {
		{ "base_number_of_projectiles", 5 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"projectiles_barrage",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 15, baseMultiplier = 0.47, damageEffectiveness = 0.47, levelRequirement = 12, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 15, baseMultiplier = 0.474, damageEffectiveness = 0.47, levelRequirement = 15, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 15, baseMultiplier = 0.478, damageEffectiveness = 0.48, levelRequirement = 19, cost = { Mana = 6, }, },
		[4] = { attackSpeedMultiplier = 15, baseMultiplier = 0.482, damageEffectiveness = 0.48, levelRequirement = 23, cost = { Mana = 6, }, },
		[5] = { attackSpeedMultiplier = 15, baseMultiplier = 0.486, damageEffectiveness = 0.49, levelRequirement = 27, cost = { Mana = 6, }, },
		[6] = { attackSpeedMultiplier = 15, baseMultiplier = 0.49, damageEffectiveness = 0.49, levelRequirement = 31, cost = { Mana = 7, }, },
		[7] = { attackSpeedMultiplier = 15, baseMultiplier = 0.494, damageEffectiveness = 0.49, levelRequirement = 35, cost = { Mana = 7, }, },
		[8] = { attackSpeedMultiplier = 15, baseMultiplier = 0.498, damageEffectiveness = 0.5, levelRequirement = 38, cost = { Mana = 7, }, },
		[9] = { attackSpeedMultiplier = 15, baseMultiplier = 0.502, damageEffectiveness = 0.5, levelRequirement = 41, cost = { Mana = 7, }, },
		[10] = { attackSpeedMultiplier = 15, baseMultiplier = 0.506, damageEffectiveness = 0.51, levelRequirement = 44, cost = { Mana = 7, }, },
		[11] = { attackSpeedMultiplier = 15, baseMultiplier = 0.51, damageEffectiveness = 0.51, levelRequirement = 47, cost = { Mana = 8, }, },
		[12] = { attackSpeedMultiplier = 15, baseMultiplier = 0.514, damageEffectiveness = 0.51, levelRequirement = 50, cost = { Mana = 8, }, },
		[13] = { attackSpeedMultiplier = 15, baseMultiplier = 0.518, damageEffectiveness = 0.52, levelRequirement = 53, cost = { Mana = 8, }, },
		[14] = { attackSpeedMultiplier = 15, baseMultiplier = 0.522, damageEffectiveness = 0.52, levelRequirement = 56, cost = { Mana = 8, }, },
		[15] = { attackSpeedMultiplier = 15, baseMultiplier = 0.526, damageEffectiveness = 0.53, levelRequirement = 59, cost = { Mana = 8, }, },
		[16] = { attackSpeedMultiplier = 15, baseMultiplier = 0.53, damageEffectiveness = 0.53, levelRequirement = 62, cost = { Mana = 9, }, },
		[17] = { attackSpeedMultiplier = 15, baseMultiplier = 0.534, damageEffectiveness = 0.53, levelRequirement = 64, cost = { Mana = 9, }, },
		[18] = { attackSpeedMultiplier = 15, baseMultiplier = 0.538, damageEffectiveness = 0.54, levelRequirement = 66, cost = { Mana = 9, }, },
		[19] = { attackSpeedMultiplier = 15, baseMultiplier = 0.542, damageEffectiveness = 0.54, levelRequirement = 68, cost = { Mana = 9, }, },
		[20] = { attackSpeedMultiplier = 15, baseMultiplier = 0.546, damageEffectiveness = 0.55, levelRequirement = 70, cost = { Mana = 9, }, },
		[21] = { attackSpeedMultiplier = 15, baseMultiplier = 0.55, damageEffectiveness = 0.55, levelRequirement = 72, cost = { Mana = 9, }, },
		[22] = { attackSpeedMultiplier = 15, baseMultiplier = 0.554, damageEffectiveness = 0.55, levelRequirement = 74, cost = { Mana = 9, }, },
		[23] = { attackSpeedMultiplier = 15, baseMultiplier = 0.558, damageEffectiveness = 0.56, levelRequirement = 76, cost = { Mana = 9, }, },
		[24] = { attackSpeedMultiplier = 15, baseMultiplier = 0.562, damageEffectiveness = 0.56, levelRequirement = 78, cost = { Mana = 9, }, },
		[25] = { attackSpeedMultiplier = 15, baseMultiplier = 0.566, damageEffectiveness = 0.57, levelRequirement = 80, cost = { Mana = 9, }, },
		[26] = { attackSpeedMultiplier = 15, baseMultiplier = 0.57, damageEffectiveness = 0.57, levelRequirement = 82, cost = { Mana = 9, }, },
		[27] = { attackSpeedMultiplier = 15, baseMultiplier = 0.574, damageEffectiveness = 0.57, levelRequirement = 84, cost = { Mana = 9, }, },
		[28] = { attackSpeedMultiplier = 15, baseMultiplier = 0.578, damageEffectiveness = 0.58, levelRequirement = 86, cost = { Mana = 9, }, },
		[29] = { attackSpeedMultiplier = 15, baseMultiplier = 0.582, damageEffectiveness = 0.58, levelRequirement = 88, cost = { Mana = 9, }, },
		[30] = { attackSpeedMultiplier = 15, baseMultiplier = 0.586, damageEffectiveness = 0.59, levelRequirement = 90, cost = { Mana = 9, }, },
		[31] = { attackSpeedMultiplier = 15, baseMultiplier = 0.588, damageEffectiveness = 0.59, levelRequirement = 91, cost = { Mana = 9, }, },
		[32] = { attackSpeedMultiplier = 15, baseMultiplier = 0.59, damageEffectiveness = 0.59, levelRequirement = 92, cost = { Mana = 9, }, },
		[33] = { attackSpeedMultiplier = 15, baseMultiplier = 0.592, damageEffectiveness = 0.59, levelRequirement = 93, cost = { Mana = 10, }, },
		[34] = { attackSpeedMultiplier = 15, baseMultiplier = 0.594, damageEffectiveness = 0.59, levelRequirement = 94, cost = { Mana = 10, }, },
		[35] = { attackSpeedMultiplier = 15, baseMultiplier = 0.596, damageEffectiveness = 0.6, levelRequirement = 95, cost = { Mana = 10, }, },
		[36] = { attackSpeedMultiplier = 15, baseMultiplier = 0.598, damageEffectiveness = 0.6, levelRequirement = 96, cost = { Mana = 10, }, },
		[37] = { attackSpeedMultiplier = 15, baseMultiplier = 0.6, damageEffectiveness = 0.6, levelRequirement = 97, cost = { Mana = 10, }, },
		[38] = { attackSpeedMultiplier = 15, baseMultiplier = 0.602, damageEffectiveness = 0.6, levelRequirement = 98, cost = { Mana = 10, }, },
		[39] = { attackSpeedMultiplier = 15, baseMultiplier = 0.604, damageEffectiveness = 0.6, levelRequirement = 99, cost = { Mana = 10, }, },
		[40] = { attackSpeedMultiplier = 15, baseMultiplier = 0.606, damageEffectiveness = 0.61, levelRequirement = 100, cost = { Mana = 10, }, },
	},
}
skills["BarrageAltX"] = {
	name = "Barrage of Volley Fire",
	baseTypeName = "Barrage of Volley Fire",
	color = 2,
	description = "After a short preparation time, you fire projectiles repeatedly with a Bow or Wand. These projectiles have a small randomised spread. This skill cannot be Triggered.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.WandAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Wand"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	statMap = {
		["projectiles_barrage"] = {
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "barrage_final_volley_fires_x_additional_projectiles_simultaneously", 0.2 },
		},
	},
	constantStats = {
		{ "base_number_of_projectiles", 4 },
		{ "barrage_final_volley_fires_x_additional_projectiles_simultaneously", 6 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"projectiles_barrage",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 15, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 12, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 15, baseMultiplier = 0.505, damageEffectiveness = 0.505, levelRequirement = 15, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 15, baseMultiplier = 0.511, damageEffectiveness = 0.511, levelRequirement = 19, cost = { Mana = 6, }, },
		[4] = { attackSpeedMultiplier = 15, baseMultiplier = 0.516, damageEffectiveness = 0.516, levelRequirement = 23, cost = { Mana = 6, }, },
		[5] = { attackSpeedMultiplier = 15, baseMultiplier = 0.521, damageEffectiveness = 0.521, levelRequirement = 27, cost = { Mana = 6, }, },
		[6] = { attackSpeedMultiplier = 15, baseMultiplier = 0.526, damageEffectiveness = 0.526, levelRequirement = 31, cost = { Mana = 7, }, },
		[7] = { attackSpeedMultiplier = 15, baseMultiplier = 0.532, damageEffectiveness = 0.532, levelRequirement = 35, cost = { Mana = 7, }, },
		[8] = { attackSpeedMultiplier = 15, baseMultiplier = 0.537, damageEffectiveness = 0.537, levelRequirement = 38, cost = { Mana = 7, }, },
		[9] = { attackSpeedMultiplier = 15, baseMultiplier = 0.542, damageEffectiveness = 0.542, levelRequirement = 41, cost = { Mana = 7, }, },
		[10] = { attackSpeedMultiplier = 15, baseMultiplier = 0.547, damageEffectiveness = 0.547, levelRequirement = 44, cost = { Mana = 7, }, },
		[11] = { attackSpeedMultiplier = 15, baseMultiplier = 0.553, damageEffectiveness = 0.553, levelRequirement = 47, cost = { Mana = 8, }, },
		[12] = { attackSpeedMultiplier = 15, baseMultiplier = 0.558, damageEffectiveness = 0.558, levelRequirement = 50, cost = { Mana = 8, }, },
		[13] = { attackSpeedMultiplier = 15, baseMultiplier = 0.563, damageEffectiveness = 0.563, levelRequirement = 53, cost = { Mana = 8, }, },
		[14] = { attackSpeedMultiplier = 15, baseMultiplier = 0.568, damageEffectiveness = 0.568, levelRequirement = 56, cost = { Mana = 8, }, },
		[15] = { attackSpeedMultiplier = 15, baseMultiplier = 0.574, damageEffectiveness = 0.574, levelRequirement = 59, cost = { Mana = 8, }, },
		[16] = { attackSpeedMultiplier = 15, baseMultiplier = 0.579, damageEffectiveness = 0.579, levelRequirement = 62, cost = { Mana = 9, }, },
		[17] = { attackSpeedMultiplier = 15, baseMultiplier = 0.584, damageEffectiveness = 0.584, levelRequirement = 64, cost = { Mana = 9, }, },
		[18] = { attackSpeedMultiplier = 15, baseMultiplier = 0.589, damageEffectiveness = 0.589, levelRequirement = 66, cost = { Mana = 9, }, },
		[19] = { attackSpeedMultiplier = 15, baseMultiplier = 0.595, damageEffectiveness = 0.595, levelRequirement = 68, cost = { Mana = 9, }, },
		[20] = { attackSpeedMultiplier = 15, baseMultiplier = 0.6, damageEffectiveness = 0.6, levelRequirement = 70, cost = { Mana = 9, }, },
		[21] = { attackSpeedMultiplier = 15, baseMultiplier = 0.605, damageEffectiveness = 0.605, levelRequirement = 72, cost = { Mana = 9, }, },
		[22] = { attackSpeedMultiplier = 15, baseMultiplier = 0.611, damageEffectiveness = 0.611, levelRequirement = 74, cost = { Mana = 9, }, },
		[23] = { attackSpeedMultiplier = 15, baseMultiplier = 0.616, damageEffectiveness = 0.616, levelRequirement = 76, cost = { Mana = 9, }, },
		[24] = { attackSpeedMultiplier = 15, baseMultiplier = 0.621, damageEffectiveness = 0.621, levelRequirement = 78, cost = { Mana = 9, }, },
		[25] = { attackSpeedMultiplier = 15, baseMultiplier = 0.626, damageEffectiveness = 0.626, levelRequirement = 80, cost = { Mana = 9, }, },
		[26] = { attackSpeedMultiplier = 15, baseMultiplier = 0.632, damageEffectiveness = 0.632, levelRequirement = 82, cost = { Mana = 9, }, },
		[27] = { attackSpeedMultiplier = 15, baseMultiplier = 0.637, damageEffectiveness = 0.637, levelRequirement = 84, cost = { Mana = 9, }, },
		[28] = { attackSpeedMultiplier = 15, baseMultiplier = 0.642, damageEffectiveness = 0.642, levelRequirement = 86, cost = { Mana = 9, }, },
		[29] = { attackSpeedMultiplier = 15, baseMultiplier = 0.647, damageEffectiveness = 0.647, levelRequirement = 88, cost = { Mana = 9, }, },
		[30] = { attackSpeedMultiplier = 15, baseMultiplier = 0.653, damageEffectiveness = 0.653, levelRequirement = 90, cost = { Mana = 9, }, },
		[31] = { attackSpeedMultiplier = 15, baseMultiplier = 0.655, damageEffectiveness = 0.655, levelRequirement = 91, cost = { Mana = 9, }, },
		[32] = { attackSpeedMultiplier = 15, baseMultiplier = 0.658, damageEffectiveness = 0.658, levelRequirement = 92, cost = { Mana = 9, }, },
		[33] = { attackSpeedMultiplier = 15, baseMultiplier = 0.661, damageEffectiveness = 0.661, levelRequirement = 93, cost = { Mana = 10, }, },
		[34] = { attackSpeedMultiplier = 15, baseMultiplier = 0.663, damageEffectiveness = 0.663, levelRequirement = 94, cost = { Mana = 10, }, },
		[35] = { attackSpeedMultiplier = 15, baseMultiplier = 0.666, damageEffectiveness = 0.666, levelRequirement = 95, cost = { Mana = 10, }, },
		[36] = { attackSpeedMultiplier = 15, baseMultiplier = 0.668, damageEffectiveness = 0.668, levelRequirement = 96, cost = { Mana = 10, }, },
		[37] = { attackSpeedMultiplier = 15, baseMultiplier = 0.671, damageEffectiveness = 0.671, levelRequirement = 97, cost = { Mana = 10, }, },
		[38] = { attackSpeedMultiplier = 15, baseMultiplier = 0.674, damageEffectiveness = 0.674, levelRequirement = 98, cost = { Mana = 10, }, },
		[39] = { attackSpeedMultiplier = 15, baseMultiplier = 0.676, damageEffectiveness = 0.676, levelRequirement = 99, cost = { Mana = 10, }, },
		[40] = { attackSpeedMultiplier = 15, baseMultiplier = 0.679, damageEffectiveness = 0.679, levelRequirement = 100, cost = { Mana = 10, }, },
	},
}
skills["BearTrap"] = {
	name = "Bear Trap",
	baseTypeName = "Bear Trap",
	color = 2,
	baseEffectiveness = 2.8499999046326,
	incrementalEffectiveness = 0.042500000447035,
	description = "Throws a trap that damages and immobilises a single enemy for a duration based on how much damage was dealt. After the immobilise expires, a debuff remains on the enemy for a duration, lowering their movement speed by an amount which lessens over time. The affected enemy will take increased damage from traps and mines until the debuff expires. Modifiers to spell damage do not affect this skill's damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Mineable] = true, [SkillType.Trapped] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["bear_trap_damage_taken_+%_from_traps_and_mines"] = {
			mod("TrapMineDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff" }),
		},
	},
	baseFlags = {
		cast = true,
		trap = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 50 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "trap_override_pvp_scaling_time_ms", 750 },
		{ "bear_trap_damage_taken_+%_from_traps_and_mines", 25 },
		{ "bear_trap_movement_speed_+%_final", -80 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
		"base_skill_is_trapped",
		"display_skill_deals_secondary_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"no_movement_speed",
		"traps_do_not_explode_on_timeout",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 4, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 6, }, },
		[2] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 6, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 7, }, },
		[3] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 9, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 7, }, },
		[4] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 12, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[5] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 16, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[6] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 20, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[7] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 24, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[8] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 28, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[9] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 32, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[10] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 36, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[11] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 40, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[12] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 44, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[13] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 48, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[14] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 52, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[15] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 55, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[16] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 58, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[17] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 61, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[18] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 64, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[19] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 67, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[20] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 70, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[21] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 72, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[22] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 74, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[23] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 76, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[24] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 78, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[25] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 80, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[26] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 82, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[27] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 84, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[28] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 86, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[29] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 88, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[30] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 90, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[31] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 91, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[32] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 92, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[33] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 93, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 94, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 95, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[36] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 96, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[37] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 97, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[38] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 98, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[39] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 99, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[40] = { 1, 1.3999999761581, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 3, levelRequirement = 100, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
	},
}
skills["BearTrapAltX"] = {
	name = "Bear Trap of Skewers",
	baseTypeName = "Bear Trap of Skewers",
	color = 2,
	baseEffectiveness = 1.3999999761581,
	incrementalEffectiveness = 0.042500000447035,
	description = "Throws a trap that damages and impales a single enemy, and immobilises them for a duration based on how much damage was dealt. Modifiers to spell damage do not affect this skill's damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Mineable] = true, [SkillType.Trapped] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		cast = true,
		trap = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "impale_debuff_effect_+%", 4 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "trap_override_pvp_scaling_time_ms", 750 },
		{ "impale_on_hit_%_chance", 100 },
		{ "apply_enemy_impale_damage_to_nearby_enemies_on_killing_blow_%_chance", 100 },
	},
	stats = {
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
		"impale_debuff_effect_+%",
		"base_skill_is_trapped",
		"display_skill_deals_secondary_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"no_movement_speed",
		"traps_do_not_explode_on_timeout",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 1, 1.3999999761581, 100, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 4, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 1, 1.3999999761581, 105, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 6, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 7, }, },
		[3] = { 1, 1.3999999761581, 110, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 9, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 7, }, },
		[4] = { 1, 1.3999999761581, 115, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 12, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[5] = { 1, 1.3999999761581, 120, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 16, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[6] = { 1, 1.3999999761581, 125, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 20, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[7] = { 1, 1.3999999761581, 130, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 24, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[8] = { 1, 1.3999999761581, 135, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 28, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[9] = { 1, 1.3999999761581, 140, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 32, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[10] = { 1, 1.3999999761581, 145, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 36, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[11] = { 1, 1.3999999761581, 150, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 40, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[12] = { 1, 1.3999999761581, 155, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 44, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[13] = { 1, 1.3999999761581, 160, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 48, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[14] = { 1, 1.3999999761581, 165, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 52, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[15] = { 1, 1.3999999761581, 170, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 55, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[16] = { 1, 1.3999999761581, 175, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 58, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[17] = { 1, 1.3999999761581, 180, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 61, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[18] = { 1, 1.3999999761581, 185, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 64, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[19] = { 1, 1.3999999761581, 190, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 67, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[20] = { 1, 1.3999999761581, 195, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 70, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[21] = { 1, 1.3999999761581, 200, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 72, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[22] = { 1, 1.3999999761581, 205, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 74, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[23] = { 1, 1.3999999761581, 210, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 76, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[24] = { 1, 1.3999999761581, 215, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 78, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[25] = { 1, 1.3999999761581, 220, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 80, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[26] = { 1, 1.3999999761581, 225, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 82, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[27] = { 1, 1.3999999761581, 230, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 84, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[28] = { 1, 1.3999999761581, 235, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 86, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[29] = { 1, 1.3999999761581, 240, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 88, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[30] = { 1, 1.3999999761581, 245, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 90, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[31] = { 1, 1.3999999761581, 247, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 91, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[32] = { 1, 1.3999999761581, 250, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 92, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[33] = { 1, 1.3999999761581, 252, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 93, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[34] = { 1, 1.3999999761581, 255, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 94, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[35] = { 1, 1.3999999761581, 257, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 95, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[36] = { 1, 1.3999999761581, 260, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 96, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[37] = { 1, 1.3999999761581, 262, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 97, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[38] = { 1, 1.3999999761581, 265, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 98, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[39] = { 1, 1.3999999761581, 267, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 99, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 32, }, },
		[40] = { 1, 1.3999999761581, 270, PvPDamageMultiplier = -30, cooldown = 4, critChance = 6, damageEffectiveness = 1.5, levelRequirement = 100, storedUses = 3, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
	},
}
skills["BladeBlast"] = {
	name = "Blade Blast",
	baseTypeName = "Blade Blast",
	color = 2,
	baseEffectiveness = 0.82349997758865,
	incrementalEffectiveness = 0.041299998760223,
	description = "Deals spell damage in a targeted area. Each time this spell deals damage,  it will detonate any of your Lingering Blades it touches, dealing damage again in an area around them. Up to 50 Blades can be detonated this way.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	parts = {
		{
			name = "Blade Hits Per Cast",
			stages = true,
		},
		{
			name = "Blade Hits Per Sec",
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = (activeSkill.skillData.dpsMultiplier or 1) * activeSkill.skillData.dpsBaseMultiplier
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.hitTimeOverride = 1
		end
	end,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		mod("Multiplier:BladeBlastMaxStages", "BASE", 900, 0, 0),
		skill("dpsBaseMultiplier", 1, { type = "Multiplier", var = "BladeBlastStage" }),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.05 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 14 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 16, statInterpolation = { 3, 3, }, cost = { Mana = 6, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 20, statInterpolation = { 3, 3, }, cost = { Mana = 6, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 24, statInterpolation = { 3, 3, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 43, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 49, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 55, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 0.7, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
	},
}
skills["BladeBlastAltX"] = {
	name = "Blade Blast of Unloading",
	baseTypeName = "Blade Blast of Unloading",
	color = 2,
	baseEffectiveness = 2.9500000476837,
	incrementalEffectiveness = 0.041299998760223,
	description = "Deals spell damage in an area around you. If you have Blade Vortex blades orbiting you, it will detonate each of them in turn, dealing damage again in an area around you for each one.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	parts = {
		{
			name = "Blade Hits Per Cast",
			stages = true,
		},
		{
			name = "Blade Hits Per Sec",
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = (activeSkill.skillData.dpsMultiplier or 1) * activeSkill.skillData.dpsBaseMultiplier
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.hitTimeOverride = 1
		end
	end,
	statMap = {
		["blade_burst_area_of_effect_+%_final_per_blade_vortex_blade_detonated"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "BladeBlastofUnloadingStage" })
		},
		["blade_vortex_damage_+%_per_blade_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "BladeBlastofUnloadingStage" })
		},
		["damage_per_blade_vortex_blade_description_mode"] = {},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		mod("Multiplier:BladeBlastofUnloadingMaxStages", "BASE", 10, 0, 0),
		skill("dpsBaseMultiplier", 1, { type = "Multiplier", var = "BladeBlastofUnloadingStage" }),
	},
	qualityStats = {
		Default = {
			{ "blade_burst_area_of_effect_+%_final_per_blade_vortex_blade_detonated", 1 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 16 },
		{ "blade_burst_area_of_effect_+%_final_per_blade_vortex_blade_detonated", 80 },
		{ "blade_vortex_damage_+%_per_blade_final", 5 },
		{ "damage_per_blade_vortex_blade_description_mode", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 16, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 20, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 24, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 43, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 49, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 55, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
	},
}
skills["BladeBlastAltY"] = {
	name = "Blade Blast of Dagger Detonation",
	baseTypeName = "Blade Blast of Dagger Detonation",
	color = 2,
	baseEffectiveness = 0.82349997758865,
	incrementalEffectiveness = 0.041299998760223,
	description = "Deals spell damage in an area around you. Your equipped daggers add to this damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	statMap = {
		["gain_%_of_base_dagger_damage_as_added_spell_damage"] = {
			skill("gainPercentBaseDaggerDamage", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.15 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 26 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"gain_%_of_base_dagger_damage_as_added_spell_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 200, critChance = 6, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 225, critChance = 6, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 250, critChance = 6, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 275, critChance = 6, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 300, critChance = 6, levelRequirement = 31, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 325, critChance = 6, levelRequirement = 34, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 350, critChance = 6, levelRequirement = 37, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 375, critChance = 6, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 400, critChance = 6, levelRequirement = 43, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 425, critChance = 6, levelRequirement = 46, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 450, critChance = 6, levelRequirement = 49, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 475, critChance = 6, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 500, critChance = 6, levelRequirement = 55, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 525, critChance = 6, levelRequirement = 58, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 550, critChance = 6, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 575, critChance = 6, levelRequirement = 62, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 600, critChance = 6, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 625, critChance = 6, levelRequirement = 66, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 650, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 675, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 700, critChance = 6, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 725, critChance = 6, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 750, critChance = 6, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 775, critChance = 6, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 800, critChance = 6, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 825, critChance = 6, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 850, critChance = 6, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 875, critChance = 6, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 900, critChance = 6, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 925, critChance = 6, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 937, critChance = 6, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 950, critChance = 6, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 962, critChance = 6, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 975, critChance = 6, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 987, critChance = 6, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 1000, critChance = 6, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 1012, critChance = 6, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 1025, critChance = 6, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 1037, critChance = 6, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 1050, critChance = 6, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
	},
}
skills["BladeTrap"] = {
	name = "Blade Trap",
	baseTypeName = "Blade Trap",
	color = 2,
	description = "Throws a trap which, once triggered, swings two copies of your equipped Dagger, Claw or One Handed Sword around it in circles, each repeatedly damaging enemies it spins through.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		trap = true,
	},
	qualityStats = {
		Default = {
			{ "base_trap_duration", 50 },
			{ "base_weapon_trap_total_rotation_%", 5 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "base_weapon_trap_total_rotation_%", 400 },
		{ "weapon_trap_total_rotation_%_if_dual_wielding", 100 },
		{ "weapon_trap_rotation_speed_+%_if_dual_wielding", 25 },
		{ "trap_variation", 18 },
		{ "active_skill_base_area_of_effect_radius", 16 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"attack_is_not_melee_override",
		"trap_use_alternate_death_animation",
		"quality_display_trap_duration_is_gem",
		"quality_display_blade_trap_is_gem",
	},
	levels = {
		[1] = { 0, baseMultiplier = 0.76, damageEffectiveness = 0.76, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 0, baseMultiplier = 0.771, damageEffectiveness = 0.77, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 1, baseMultiplier = 0.781, damageEffectiveness = 0.78, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[4] = { 1, baseMultiplier = 0.792, damageEffectiveness = 0.79, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 1, baseMultiplier = 0.802, damageEffectiveness = 0.8, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[6] = { 2, baseMultiplier = 0.813, damageEffectiveness = 0.81, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[7] = { 2, baseMultiplier = 0.823, damageEffectiveness = 0.82, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[8] = { 2, baseMultiplier = 0.834, damageEffectiveness = 0.83, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[9] = { 3, baseMultiplier = 0.844, damageEffectiveness = 0.84, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[10] = { 3, baseMultiplier = 0.855, damageEffectiveness = 0.85, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[11] = { 3, baseMultiplier = 0.865, damageEffectiveness = 0.87, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[12] = { 4, baseMultiplier = 0.876, damageEffectiveness = 0.88, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[13] = { 4, baseMultiplier = 0.886, damageEffectiveness = 0.89, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[14] = { 4, baseMultiplier = 0.897, damageEffectiveness = 0.9, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[15] = { 5, baseMultiplier = 0.907, damageEffectiveness = 0.91, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[16] = { 5, baseMultiplier = 0.918, damageEffectiveness = 0.92, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[17] = { 5, baseMultiplier = 0.928, damageEffectiveness = 0.93, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[18] = { 6, baseMultiplier = 0.939, damageEffectiveness = 0.94, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[19] = { 6, baseMultiplier = 0.949, damageEffectiveness = 0.95, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[20] = { 6, baseMultiplier = 0.96, damageEffectiveness = 0.96, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[21] = { 7, baseMultiplier = 0.971, damageEffectiveness = 0.97, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[22] = { 7, baseMultiplier = 0.981, damageEffectiveness = 0.98, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[23] = { 7, baseMultiplier = 0.992, damageEffectiveness = 0.99, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[24] = { 8, baseMultiplier = 1.002, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[25] = { 8, baseMultiplier = 1.013, damageEffectiveness = 1.01, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[26] = { 8, baseMultiplier = 1.023, damageEffectiveness = 1.02, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[27] = { 9, baseMultiplier = 1.034, damageEffectiveness = 1.03, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[28] = { 9, baseMultiplier = 1.044, damageEffectiveness = 1.04, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[29] = { 9, baseMultiplier = 1.055, damageEffectiveness = 1.05, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[30] = { 10, baseMultiplier = 1.065, damageEffectiveness = 1.07, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[31] = { 10, baseMultiplier = 1.071, damageEffectiveness = 1.07, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[32] = { 10, baseMultiplier = 1.076, damageEffectiveness = 1.08, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[33] = { 10, baseMultiplier = 1.081, damageEffectiveness = 1.08, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[34] = { 10, baseMultiplier = 1.086, damageEffectiveness = 1.09, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[35] = { 10, baseMultiplier = 1.092, damageEffectiveness = 1.09, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[36] = { 11, baseMultiplier = 1.097, damageEffectiveness = 1.1, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[37] = { 11, baseMultiplier = 1.102, damageEffectiveness = 1.1, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[38] = { 11, baseMultiplier = 1.107, damageEffectiveness = 1.11, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[39] = { 11, baseMultiplier = 1.113, damageEffectiveness = 1.11, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[40] = { 11, baseMultiplier = 1.118, damageEffectiveness = 1.12, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 29, }, },
	},
}
skills["BladeTrapAltX"] = {
	name = "Blade Trap of Greatswords",
	baseTypeName = "Blade Trap of Greatswords",
	color = 2,
	description = "Throws a trap which, once triggered, swings two copies of your equipped Two Handed Sword around it in circles for a duration, each repeatedly damaging enemies it spins through",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Area] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		trap = true,
	},
	qualityStats = {
		Default = {
			{ "base_skill_effect_duration", 25 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "trap_variation", 18 },
		{ "active_skill_base_area_of_effect_radius", 22 },
		{ "base_skill_effect_duration", 3500 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"attack_is_not_melee_override",
		"trap_use_alternate_death_animation",
		"quality_display_trap_duration_is_gem",
	},
	levels = {
		[1] = { 0, baseMultiplier = 1.467, cooldown = 6, damageEffectiveness = 1.467, levelRequirement = 12, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[2] = { 0, baseMultiplier = 1.506, cooldown = 6, damageEffectiveness = 1.506, levelRequirement = 15, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[3] = { 1, baseMultiplier = 1.544, cooldown = 6, damageEffectiveness = 1.544, levelRequirement = 19, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[4] = { 1, baseMultiplier = 1.583, cooldown = 6, damageEffectiveness = 1.583, levelRequirement = 23, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[5] = { 1, baseMultiplier = 1.621, cooldown = 6, damageEffectiveness = 1.621, levelRequirement = 27, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[6] = { 2, baseMultiplier = 1.66, cooldown = 6, damageEffectiveness = 1.66, levelRequirement = 31, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[7] = { 2, baseMultiplier = 1.698, cooldown = 6, damageEffectiveness = 1.698, levelRequirement = 35, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[8] = { 2, baseMultiplier = 1.737, cooldown = 6, damageEffectiveness = 1.737, levelRequirement = 38, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[9] = { 3, baseMultiplier = 1.776, cooldown = 6, damageEffectiveness = 1.776, levelRequirement = 41, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[10] = { 3, baseMultiplier = 1.814, cooldown = 6, damageEffectiveness = 1.814, levelRequirement = 44, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[11] = { 3, baseMultiplier = 1.853, cooldown = 6, damageEffectiveness = 1.853, levelRequirement = 47, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[12] = { 4, baseMultiplier = 1.891, cooldown = 6, damageEffectiveness = 1.891, levelRequirement = 50, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[13] = { 4, baseMultiplier = 1.93, cooldown = 6, damageEffectiveness = 1.93, levelRequirement = 53, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[14] = { 4, baseMultiplier = 1.969, cooldown = 6, damageEffectiveness = 1.969, levelRequirement = 56, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[15] = { 5, baseMultiplier = 2.007, cooldown = 6, damageEffectiveness = 2.007, levelRequirement = 59, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[16] = { 5, baseMultiplier = 2.046, cooldown = 6, damageEffectiveness = 2.046, levelRequirement = 62, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[17] = { 5, baseMultiplier = 2.084, cooldown = 6, damageEffectiveness = 2.084, levelRequirement = 64, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[18] = { 6, baseMultiplier = 2.123, cooldown = 6, damageEffectiveness = 2.123, levelRequirement = 66, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[19] = { 6, baseMultiplier = 2.161, cooldown = 6, damageEffectiveness = 2.161, levelRequirement = 68, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[20] = { 6, baseMultiplier = 2.2, cooldown = 6, damageEffectiveness = 2.2, levelRequirement = 70, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[21] = { 7, baseMultiplier = 2.239, cooldown = 6, damageEffectiveness = 2.239, levelRequirement = 72, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[22] = { 7, baseMultiplier = 2.277, cooldown = 6, damageEffectiveness = 2.277, levelRequirement = 74, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[23] = { 7, baseMultiplier = 2.316, cooldown = 6, damageEffectiveness = 2.316, levelRequirement = 76, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[24] = { 8, baseMultiplier = 2.354, cooldown = 6, damageEffectiveness = 2.354, levelRequirement = 78, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[25] = { 8, baseMultiplier = 2.393, cooldown = 6, damageEffectiveness = 2.393, levelRequirement = 80, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[26] = { 8, baseMultiplier = 2.431, cooldown = 6, damageEffectiveness = 2.431, levelRequirement = 82, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[27] = { 9, baseMultiplier = 2.47, cooldown = 6, damageEffectiveness = 2.47, levelRequirement = 84, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[28] = { 9, baseMultiplier = 2.509, cooldown = 6, damageEffectiveness = 2.509, levelRequirement = 86, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[29] = { 9, baseMultiplier = 2.547, cooldown = 6, damageEffectiveness = 2.547, levelRequirement = 88, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 31, }, },
		[30] = { 10, baseMultiplier = 2.586, cooldown = 6, damageEffectiveness = 2.586, levelRequirement = 90, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 31, }, },
		[31] = { 10, baseMultiplier = 2.605, cooldown = 6, damageEffectiveness = 2.605, levelRequirement = 91, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[32] = { 10, baseMultiplier = 2.624, cooldown = 6, damageEffectiveness = 2.624, levelRequirement = 92, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[33] = { 10, baseMultiplier = 2.644, cooldown = 6, damageEffectiveness = 2.644, levelRequirement = 93, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 32, }, },
		[34] = { 10, baseMultiplier = 2.663, cooldown = 6, damageEffectiveness = 2.663, levelRequirement = 94, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 33, }, },
		[35] = { 10, baseMultiplier = 2.682, cooldown = 6, damageEffectiveness = 2.682, levelRequirement = 95, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 33, }, },
		[36] = { 11, baseMultiplier = 2.702, cooldown = 6, damageEffectiveness = 2.702, levelRequirement = 96, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 33, }, },
		[37] = { 11, baseMultiplier = 2.721, cooldown = 6, damageEffectiveness = 2.721, levelRequirement = 97, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[38] = { 11, baseMultiplier = 2.74, cooldown = 6, damageEffectiveness = 2.74, levelRequirement = 98, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[39] = { 11, baseMultiplier = 2.759, cooldown = 6, damageEffectiveness = 2.759, levelRequirement = 99, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 34, }, },
		[40] = { 11, baseMultiplier = 2.779, cooldown = 6, damageEffectiveness = 2.779, levelRequirement = 100, storedUses = 3, statInterpolation = { 1, }, cost = { Mana = 34, }, },
	},
}
skills["BladeTrapAltY"] = {
	name = "Blade Trap of Laceration",
	baseTypeName = "Blade Trap of Laceration",
	color = 2,
	description = "Throws a trap which, once triggered, swings two copies of your equipped Dagger, Claw, One Handed Sword or One Handed Axe around it in a circle, each damaging enemies it spins through.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Area] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["quality_display_active_skill_bleed_damage_final_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		attack = true,
		area = true,
		trap = true,
	},
	qualityStats = {
		Default = {
			{ "faster_bleed_%", 0.5 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "base_weapon_trap_total_rotation_%", 100 },
		{ "trap_variation", 18 },
		{ "active_skill_base_area_of_effect_radius", 16 },
		{ "bleed_on_hit_with_attacks_%", 25 },
		{ "faster_bleed_%", 50 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"attack_is_not_melee_override",
		"trap_use_alternate_death_animation",
		"quality_display_trap_duration_is_gem",
		"quality_display_blade_trap_is_gem",
		"quality_display_active_skill_bleed_damage_final_is_gem",
	},
	levels = {
		[1] = { 0, baseMultiplier = 1.8, damageEffectiveness = 1.8, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 0, baseMultiplier = 1.842, damageEffectiveness = 1.842, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 1, baseMultiplier = 1.884, damageEffectiveness = 1.884, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[4] = { 1, baseMultiplier = 1.926, damageEffectiveness = 1.926, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 1, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[6] = { 2, baseMultiplier = 2.011, damageEffectiveness = 2.011, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[7] = { 2, baseMultiplier = 2.053, damageEffectiveness = 2.053, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[8] = { 2, baseMultiplier = 2.095, damageEffectiveness = 2.095, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[9] = { 3, baseMultiplier = 2.137, damageEffectiveness = 2.137, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[10] = { 3, baseMultiplier = 2.179, damageEffectiveness = 2.179, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[11] = { 3, baseMultiplier = 2.221, damageEffectiveness = 2.221, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[12] = { 4, baseMultiplier = 2.263, damageEffectiveness = 2.263, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[13] = { 4, baseMultiplier = 2.305, damageEffectiveness = 2.305, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[14] = { 4, baseMultiplier = 2.347, damageEffectiveness = 2.347, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[15] = { 5, baseMultiplier = 2.389, damageEffectiveness = 2.389, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[16] = { 5, baseMultiplier = 2.432, damageEffectiveness = 2.432, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[17] = { 5, baseMultiplier = 2.474, damageEffectiveness = 2.474, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[18] = { 6, baseMultiplier = 2.516, damageEffectiveness = 2.516, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[19] = { 6, baseMultiplier = 2.558, damageEffectiveness = 2.558, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[20] = { 6, baseMultiplier = 2.6, damageEffectiveness = 2.6, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[21] = { 7, baseMultiplier = 2.642, damageEffectiveness = 2.642, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[22] = { 7, baseMultiplier = 2.684, damageEffectiveness = 2.684, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[23] = { 7, baseMultiplier = 2.726, damageEffectiveness = 2.726, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[24] = { 8, baseMultiplier = 2.768, damageEffectiveness = 2.768, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[25] = { 8, baseMultiplier = 2.811, damageEffectiveness = 2.811, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[26] = { 8, baseMultiplier = 2.853, damageEffectiveness = 2.853, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[27] = { 9, baseMultiplier = 2.895, damageEffectiveness = 2.895, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[28] = { 9, baseMultiplier = 2.937, damageEffectiveness = 2.937, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[29] = { 9, baseMultiplier = 2.979, damageEffectiveness = 2.979, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[30] = { 10, baseMultiplier = 3.021, damageEffectiveness = 3.021, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[31] = { 10, baseMultiplier = 3.042, damageEffectiveness = 3.042, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[32] = { 10, baseMultiplier = 3.063, damageEffectiveness = 3.063, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[33] = { 10, baseMultiplier = 3.084, damageEffectiveness = 3.084, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[34] = { 10, baseMultiplier = 3.105, damageEffectiveness = 3.105, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[35] = { 10, baseMultiplier = 3.126, damageEffectiveness = 3.126, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[36] = { 11, baseMultiplier = 3.147, damageEffectiveness = 3.147, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[37] = { 11, baseMultiplier = 3.168, damageEffectiveness = 3.168, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[38] = { 11, baseMultiplier = 3.189, damageEffectiveness = 3.189, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[39] = { 11, baseMultiplier = 3.211, damageEffectiveness = 3.211, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[40] = { 11, baseMultiplier = 3.232, damageEffectiveness = 3.232, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 29, }, },
	},
}
skills["BladeFlurry"] = {
	name = "Blade Flurry",
	baseTypeName = "Blade Flurry",
	color = 2,
	description = "Repeatedly hit enemies in a circle in front of you while channelling, dealing damage to and around the enemy. The damage is continually boosted while channelling. You unleash an additional hit for each stage reached once the channelling ends. Requires a Dagger, Claw or One-Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Channel] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Channelling",
			stages = true,
		},
		{
			name = "Channel & Release",
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 and activeSkill.skillData.numStages > 0 then
			local numStages = activeSkill.skillData.numStages
			local channelMulti = 0
			for i = 1, numStages do
				channelMulti = channelMulti + (0.8 + (0.2 * i))
			end
			channelMulti = channelMulti / (0.8 + (0.2 * numStages))
			activeSkill.skillData.dpsMultiplier = channelMulti / numStages + 1
		end
	end,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["charged_attack_damage_per_stack_+%_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "BladeFlurryStage" }),
		},
		["display_max_charged_attack_stats"] = {
			mod("Multiplier:BladeFlurryMaxStages", "BASE", nil),
		},
		["blade_flurry_damage_+%_final_while_at_max_stages"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "MultiplierThreshold", var = "BladeFlurryStage", thresholdVar = "BladeFlurryMaxStages" }),
		},
		["quality_display_charged_attack_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("numStages", 1, { type = "Multiplier", var = "BladeFlurryStage" }),
		skill("stackMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 14),
	},
	qualityStats = {
		Default = {
			{ "blade_flurry_damage_+%_final_while_at_max_stages", 1 },
		},
	},
	constantStats = {
		{ "charged_attack_damage_per_stack_+%_final", 25 },
		{ "display_max_charged_attack_stats", 6 },
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_charged_attack_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 60, baseMultiplier = 0.682, damageEffectiveness = 0.682, levelRequirement = 28, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 60, baseMultiplier = 0.704, damageEffectiveness = 0.704, levelRequirement = 31, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 60, baseMultiplier = 0.728, damageEffectiveness = 0.728, levelRequirement = 34, cost = { Mana = 5, }, },
		[4] = { attackSpeedMultiplier = 60, baseMultiplier = 0.754, damageEffectiveness = 0.754, levelRequirement = 37, cost = { Mana = 5, }, },
		[5] = { attackSpeedMultiplier = 60, baseMultiplier = 0.78, damageEffectiveness = 0.78, levelRequirement = 40, cost = { Mana = 5, }, },
		[6] = { attackSpeedMultiplier = 60, baseMultiplier = 0.803, damageEffectiveness = 0.803, levelRequirement = 42, cost = { Mana = 5, }, },
		[7] = { attackSpeedMultiplier = 60, baseMultiplier = 0.829, damageEffectiveness = 0.829, levelRequirement = 44, cost = { Mana = 5, }, },
		[8] = { attackSpeedMultiplier = 60, baseMultiplier = 0.857, damageEffectiveness = 0.857, levelRequirement = 46, cost = { Mana = 5, }, },
		[9] = { attackSpeedMultiplier = 60, baseMultiplier = 0.884, damageEffectiveness = 0.884, levelRequirement = 48, cost = { Mana = 5, }, },
		[10] = { attackSpeedMultiplier = 60, baseMultiplier = 0.912, damageEffectiveness = 0.912, levelRequirement = 50, cost = { Mana = 5, }, },
		[11] = { attackSpeedMultiplier = 60, baseMultiplier = 0.942, damageEffectiveness = 0.942, levelRequirement = 52, cost = { Mana = 6, }, },
		[12] = { attackSpeedMultiplier = 60, baseMultiplier = 0.972, damageEffectiveness = 0.972, levelRequirement = 54, cost = { Mana = 6, }, },
		[13] = { attackSpeedMultiplier = 60, baseMultiplier = 1.002, damageEffectiveness = 1.002, levelRequirement = 56, cost = { Mana = 6, }, },
		[14] = { attackSpeedMultiplier = 60, baseMultiplier = 1.035, damageEffectiveness = 1.035, levelRequirement = 58, cost = { Mana = 6, }, },
		[15] = { attackSpeedMultiplier = 60, baseMultiplier = 1.068, damageEffectiveness = 1.068, levelRequirement = 60, cost = { Mana = 6, }, },
		[16] = { attackSpeedMultiplier = 60, baseMultiplier = 1.103, damageEffectiveness = 1.103, levelRequirement = 62, cost = { Mana = 6, }, },
		[17] = { attackSpeedMultiplier = 60, baseMultiplier = 1.139, damageEffectiveness = 1.139, levelRequirement = 64, cost = { Mana = 6, }, },
		[18] = { attackSpeedMultiplier = 60, baseMultiplier = 1.175, damageEffectiveness = 1.175, levelRequirement = 66, cost = { Mana = 6, }, },
		[19] = { attackSpeedMultiplier = 60, baseMultiplier = 1.213, damageEffectiveness = 1.213, levelRequirement = 68, cost = { Mana = 6, }, },
		[20] = { attackSpeedMultiplier = 60, baseMultiplier = 1.251, damageEffectiveness = 1.251, levelRequirement = 70, cost = { Mana = 6, }, },
		[21] = { attackSpeedMultiplier = 60, baseMultiplier = 1.29, damageEffectiveness = 1.29, levelRequirement = 72, cost = { Mana = 6, }, },
		[22] = { attackSpeedMultiplier = 60, baseMultiplier = 1.333, damageEffectiveness = 1.333, levelRequirement = 74, cost = { Mana = 6, }, },
		[23] = { attackSpeedMultiplier = 60, baseMultiplier = 1.375, damageEffectiveness = 1.375, levelRequirement = 76, cost = { Mana = 7, }, },
		[24] = { attackSpeedMultiplier = 60, baseMultiplier = 1.419, damageEffectiveness = 1.419, levelRequirement = 78, cost = { Mana = 7, }, },
		[25] = { attackSpeedMultiplier = 60, baseMultiplier = 1.465, damageEffectiveness = 1.465, levelRequirement = 80, cost = { Mana = 7, }, },
		[26] = { attackSpeedMultiplier = 60, baseMultiplier = 1.511, damageEffectiveness = 1.511, levelRequirement = 82, cost = { Mana = 7, }, },
		[27] = { attackSpeedMultiplier = 60, baseMultiplier = 1.56, damageEffectiveness = 1.56, levelRequirement = 84, cost = { Mana = 7, }, },
		[28] = { attackSpeedMultiplier = 60, baseMultiplier = 1.609, damageEffectiveness = 1.609, levelRequirement = 86, cost = { Mana = 7, }, },
		[29] = { attackSpeedMultiplier = 60, baseMultiplier = 1.662, damageEffectiveness = 1.662, levelRequirement = 88, cost = { Mana = 7, }, },
		[30] = { attackSpeedMultiplier = 60, baseMultiplier = 1.713, damageEffectiveness = 1.713, levelRequirement = 90, cost = { Mana = 7, }, },
		[31] = { attackSpeedMultiplier = 60, baseMultiplier = 1.791, damageEffectiveness = 1.791, levelRequirement = 91, cost = { Mana = 7, }, },
		[32] = { attackSpeedMultiplier = 60, baseMultiplier = 1.819, damageEffectiveness = 1.819, levelRequirement = 92, cost = { Mana = 7, }, },
		[33] = { attackSpeedMultiplier = 60, baseMultiplier = 1.848, damageEffectiveness = 1.848, levelRequirement = 93, cost = { Mana = 7, }, },
		[34] = { attackSpeedMultiplier = 60, baseMultiplier = 1.878, damageEffectiveness = 1.878, levelRequirement = 94, cost = { Mana = 7, }, },
		[35] = { attackSpeedMultiplier = 60, baseMultiplier = 1.908, damageEffectiveness = 1.908, levelRequirement = 95, cost = { Mana = 7, }, },
		[36] = { attackSpeedMultiplier = 60, baseMultiplier = 1.937, damageEffectiveness = 1.937, levelRequirement = 96, cost = { Mana = 7, }, },
		[37] = { attackSpeedMultiplier = 60, baseMultiplier = 1.969, damageEffectiveness = 1.969, levelRequirement = 97, cost = { Mana = 7, }, },
		[38] = { attackSpeedMultiplier = 60, baseMultiplier = 2.001, damageEffectiveness = 2.001, levelRequirement = 98, cost = { Mana = 7, }, },
		[39] = { attackSpeedMultiplier = 60, baseMultiplier = 2.032, damageEffectiveness = 2.032, levelRequirement = 99, cost = { Mana = 7, }, },
		[40] = { attackSpeedMultiplier = 60, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 100, cost = { Mana = 8, }, },
	},
}
skills["BladeFlurryAltX"] = {
	name = "Blade Flurry of Incision",
	baseTypeName = "Blade Flurry of Incision",
	color = 2,
	description = "Repeatedly hit enemies in a circle in front of you while channelling, dealing damage to and around the enemy. The critical strike chance is continually boosted while channelling. You unleash an additional hit for each stage reached once the channelling ends. Requires a Dagger, Claw or One-Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Channel] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Channelling",
			stages = true,
		},
		{
			name = "Channel & Release",
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 and activeSkill.skillData.numStages > 0 then
			local numStages = activeSkill.skillData.numStages
			local channelMulti = 0
			for i = 1, numStages do
				channelMulti = channelMulti + (0.8 + (0.2 * i))
			end
			channelMulti = channelMulti / (0.8 + (0.2 * numStages))
			activeSkill.skillData.dpsMultiplier = channelMulti / numStages + 1
		end
	end,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["blade_flurry_critical_strike_chance_per_stage_+%_final"] = {
			mod("CritChance", "MORE", nil, 0, 0, { type = "Multiplier", var = "BladeFlurryofIncisionStage" }),
		},
		["blade_flurry_critical_strike_multiplier_+_while_at_max_stages"] = {
			mod("CritMultiplier", "BASE", nil, 0, 0, { type = "MultiplierThreshold", var = "BladeFlurryofIncisionStage", thresholdVar = "BladeFlurryofIncisionMaxStages" }),
		},
		["display_max_charged_attack_stats"] = {
			mod("Multiplier:BladeFlurryofIncisionMaxStages", "BASE", nil),
		},
		["quality_display_charged_attack_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("numStages", 1, { type = "Multiplier", var = "BladeFlurryofIncisionStage" }),
		skill("stackMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 14),
	},
	qualityStats = {
		Default = {
			{ "blade_flurry_critical_strike_multiplier_+_while_at_max_stages", 2 },
		},
	},
	constantStats = {
		{ "display_max_charged_attack_stats", 6 },
		{ "blade_flurry_critical_strike_chance_per_stage_+%_final", 40 },
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_charged_attack_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 80, baseMultiplier = 0.606, damageEffectiveness = 0.606, levelRequirement = 28, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 80, baseMultiplier = 0.626, damageEffectiveness = 0.626, levelRequirement = 31, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 80, baseMultiplier = 0.647, damageEffectiveness = 0.647, levelRequirement = 34, cost = { Mana = 5, }, },
		[4] = { attackSpeedMultiplier = 80, baseMultiplier = 0.67, damageEffectiveness = 0.67, levelRequirement = 37, cost = { Mana = 5, }, },
		[5] = { attackSpeedMultiplier = 80, baseMultiplier = 0.693, damageEffectiveness = 0.693, levelRequirement = 40, cost = { Mana = 5, }, },
		[6] = { attackSpeedMultiplier = 80, baseMultiplier = 0.714, damageEffectiveness = 0.714, levelRequirement = 42, cost = { Mana = 5, }, },
		[7] = { attackSpeedMultiplier = 80, baseMultiplier = 0.737, damageEffectiveness = 0.737, levelRequirement = 44, cost = { Mana = 5, }, },
		[8] = { attackSpeedMultiplier = 80, baseMultiplier = 0.762, damageEffectiveness = 0.762, levelRequirement = 46, cost = { Mana = 5, }, },
		[9] = { attackSpeedMultiplier = 80, baseMultiplier = 0.786, damageEffectiveness = 0.786, levelRequirement = 48, cost = { Mana = 5, }, },
		[10] = { attackSpeedMultiplier = 80, baseMultiplier = 0.811, damageEffectiveness = 0.811, levelRequirement = 50, cost = { Mana = 5, }, },
		[11] = { attackSpeedMultiplier = 80, baseMultiplier = 0.837, damageEffectiveness = 0.837, levelRequirement = 52, cost = { Mana = 6, }, },
		[12] = { attackSpeedMultiplier = 80, baseMultiplier = 0.864, damageEffectiveness = 0.864, levelRequirement = 54, cost = { Mana = 6, }, },
		[13] = { attackSpeedMultiplier = 80, baseMultiplier = 0.891, damageEffectiveness = 0.891, levelRequirement = 56, cost = { Mana = 6, }, },
		[14] = { attackSpeedMultiplier = 80, baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 58, cost = { Mana = 6, }, },
		[15] = { attackSpeedMultiplier = 80, baseMultiplier = 0.949, damageEffectiveness = 0.949, levelRequirement = 60, cost = { Mana = 6, }, },
		[16] = { attackSpeedMultiplier = 80, baseMultiplier = 0.98, damageEffectiveness = 0.98, levelRequirement = 62, cost = { Mana = 6, }, },
		[17] = { attackSpeedMultiplier = 80, baseMultiplier = 1.012, damageEffectiveness = 1.012, levelRequirement = 64, cost = { Mana = 6, }, },
		[18] = { attackSpeedMultiplier = 80, baseMultiplier = 1.044, damageEffectiveness = 1.044, levelRequirement = 66, cost = { Mana = 6, }, },
		[19] = { attackSpeedMultiplier = 80, baseMultiplier = 1.078, damageEffectiveness = 1.078, levelRequirement = 68, cost = { Mana = 6, }, },
		[20] = { attackSpeedMultiplier = 80, baseMultiplier = 1.112, damageEffectiveness = 1.112, levelRequirement = 70, cost = { Mana = 6, }, },
		[21] = { attackSpeedMultiplier = 80, baseMultiplier = 1.147, damageEffectiveness = 1.147, levelRequirement = 72, cost = { Mana = 6, }, },
		[22] = { attackSpeedMultiplier = 80, baseMultiplier = 1.185, damageEffectiveness = 1.185, levelRequirement = 74, cost = { Mana = 6, }, },
		[23] = { attackSpeedMultiplier = 80, baseMultiplier = 1.222, damageEffectiveness = 1.222, levelRequirement = 76, cost = { Mana = 7, }, },
		[24] = { attackSpeedMultiplier = 80, baseMultiplier = 1.261, damageEffectiveness = 1.261, levelRequirement = 78, cost = { Mana = 7, }, },
		[25] = { attackSpeedMultiplier = 80, baseMultiplier = 1.302, damageEffectiveness = 1.302, levelRequirement = 80, cost = { Mana = 7, }, },
		[26] = { attackSpeedMultiplier = 80, baseMultiplier = 1.343, damageEffectiveness = 1.343, levelRequirement = 82, cost = { Mana = 7, }, },
		[27] = { attackSpeedMultiplier = 80, baseMultiplier = 1.387, damageEffectiveness = 1.387, levelRequirement = 84, cost = { Mana = 7, }, },
		[28] = { attackSpeedMultiplier = 80, baseMultiplier = 1.43, damageEffectiveness = 1.43, levelRequirement = 86, cost = { Mana = 7, }, },
		[29] = { attackSpeedMultiplier = 80, baseMultiplier = 1.477, damageEffectiveness = 1.477, levelRequirement = 88, cost = { Mana = 7, }, },
		[30] = { attackSpeedMultiplier = 80, baseMultiplier = 1.523, damageEffectiveness = 1.523, levelRequirement = 90, cost = { Mana = 7, }, },
		[31] = { attackSpeedMultiplier = 80, baseMultiplier = 1.592, damageEffectiveness = 1.592, levelRequirement = 91, cost = { Mana = 7, }, },
		[32] = { attackSpeedMultiplier = 80, baseMultiplier = 1.617, damageEffectiveness = 1.617, levelRequirement = 92, cost = { Mana = 7, }, },
		[33] = { attackSpeedMultiplier = 80, baseMultiplier = 1.643, damageEffectiveness = 1.643, levelRequirement = 93, cost = { Mana = 7, }, },
		[34] = { attackSpeedMultiplier = 80, baseMultiplier = 1.669, damageEffectiveness = 1.669, levelRequirement = 94, cost = { Mana = 7, }, },
		[35] = { attackSpeedMultiplier = 80, baseMultiplier = 1.696, damageEffectiveness = 1.696, levelRequirement = 95, cost = { Mana = 7, }, },
		[36] = { attackSpeedMultiplier = 80, baseMultiplier = 1.722, damageEffectiveness = 1.722, levelRequirement = 96, cost = { Mana = 7, }, },
		[37] = { attackSpeedMultiplier = 80, baseMultiplier = 1.75, damageEffectiveness = 1.75, levelRequirement = 97, cost = { Mana = 7, }, },
		[38] = { attackSpeedMultiplier = 80, baseMultiplier = 1.779, damageEffectiveness = 1.779, levelRequirement = 98, cost = { Mana = 7, }, },
		[39] = { attackSpeedMultiplier = 80, baseMultiplier = 1.806, damageEffectiveness = 1.806, levelRequirement = 99, cost = { Mana = 7, }, },
		[40] = { attackSpeedMultiplier = 80, baseMultiplier = 1.835, damageEffectiveness = 1.835, levelRequirement = 100, cost = { Mana = 8, }, },
	},
}
skills["VaalBladeFlurry"] = {
	name = "Vaal Blade Flurry",
	baseTypeName = "Vaal Blade Flurry",
	color = 2,
	description = "Channel to create an expanding circle area around you that blinds enemies within it. When you stop channelling, deals damage in a smaller area around each enemy in the circle. Requires a Dagger, Claw or One-Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Channel] = true, [SkillType.Melee] = true, [SkillType.Vaal] = true, [SkillType.Cooldown] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["vaal_charged_attack_damage_taken_+%_final"] = {
			mod("DamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "charged_attack_damage_per_stack_+%_final", 0.25 },
		},
	},
	constantStats = {
		{ "vaal_charged_attack_damage_taken_+%_final", -50 },
		{ "vaal_charged_attack_radius_+_per_stage", 5 },
		{ "global_chance_to_blind_on_hit_%", 100 },
	},
	stats = {
		"blind_effect_+%",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 30, attackSpeedMultiplier = 220, baseMultiplier = 4.036, cooldown = 0.5, damageEffectiveness = 4.036, levelRequirement = 28, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[2] = { 32, attackSpeedMultiplier = 220, baseMultiplier = 4.152, cooldown = 0.5, damageEffectiveness = 4.152, levelRequirement = 31, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[3] = { 34, attackSpeedMultiplier = 220, baseMultiplier = 4.271, cooldown = 0.5, damageEffectiveness = 4.271, levelRequirement = 34, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[4] = { 36, attackSpeedMultiplier = 220, baseMultiplier = 4.393, cooldown = 0.5, damageEffectiveness = 4.393, levelRequirement = 37, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[5] = { 38, attackSpeedMultiplier = 220, baseMultiplier = 4.519, cooldown = 0.5, damageEffectiveness = 4.519, levelRequirement = 40, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[6] = { 40, attackSpeedMultiplier = 220, baseMultiplier = 4.649, cooldown = 0.5, damageEffectiveness = 4.649, levelRequirement = 42, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[7] = { 42, attackSpeedMultiplier = 220, baseMultiplier = 4.782, cooldown = 0.5, damageEffectiveness = 4.782, levelRequirement = 44, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[8] = { 44, attackSpeedMultiplier = 220, baseMultiplier = 4.919, cooldown = 0.5, damageEffectiveness = 4.919, levelRequirement = 46, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[9] = { 46, attackSpeedMultiplier = 220, baseMultiplier = 5.06, cooldown = 0.5, damageEffectiveness = 5.06, levelRequirement = 48, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[10] = { 48, attackSpeedMultiplier = 220, baseMultiplier = 5.205, cooldown = 0.5, damageEffectiveness = 5.205, levelRequirement = 50, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[11] = { 50, attackSpeedMultiplier = 220, baseMultiplier = 5.354, cooldown = 0.5, damageEffectiveness = 5.354, levelRequirement = 52, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[12] = { 52, attackSpeedMultiplier = 220, baseMultiplier = 5.507, cooldown = 0.5, damageEffectiveness = 5.507, levelRequirement = 54, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[13] = { 54, attackSpeedMultiplier = 220, baseMultiplier = 5.665, cooldown = 0.5, damageEffectiveness = 5.665, levelRequirement = 56, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[14] = { 56, attackSpeedMultiplier = 220, baseMultiplier = 5.827, cooldown = 0.5, damageEffectiveness = 5.827, levelRequirement = 58, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[15] = { 58, attackSpeedMultiplier = 220, baseMultiplier = 5.994, cooldown = 0.5, damageEffectiveness = 5.994, levelRequirement = 60, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[16] = { 60, attackSpeedMultiplier = 220, baseMultiplier = 6.166, cooldown = 0.5, damageEffectiveness = 6.166, levelRequirement = 62, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[17] = { 62, attackSpeedMultiplier = 220, baseMultiplier = 6.343, cooldown = 0.5, damageEffectiveness = 6.343, levelRequirement = 64, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[18] = { 64, attackSpeedMultiplier = 220, baseMultiplier = 6.524, cooldown = 0.5, damageEffectiveness = 6.524, levelRequirement = 66, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[19] = { 66, attackSpeedMultiplier = 220, baseMultiplier = 6.711, cooldown = 0.5, damageEffectiveness = 6.711, levelRequirement = 68, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[20] = { 68, attackSpeedMultiplier = 220, baseMultiplier = 6.904, cooldown = 0.5, damageEffectiveness = 6.904, levelRequirement = 70, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[21] = { 70, attackSpeedMultiplier = 220, baseMultiplier = 7.101, cooldown = 0.5, damageEffectiveness = 7.101, levelRequirement = 72, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[22] = { 72, attackSpeedMultiplier = 220, baseMultiplier = 7.305, cooldown = 0.5, damageEffectiveness = 7.305, levelRequirement = 74, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[23] = { 74, attackSpeedMultiplier = 220, baseMultiplier = 7.514, cooldown = 0.5, damageEffectiveness = 7.514, levelRequirement = 76, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[24] = { 76, attackSpeedMultiplier = 220, baseMultiplier = 7.729, cooldown = 0.5, damageEffectiveness = 7.729, levelRequirement = 78, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[25] = { 78, attackSpeedMultiplier = 220, baseMultiplier = 7.951, cooldown = 0.5, damageEffectiveness = 7.951, levelRequirement = 80, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[26] = { 80, attackSpeedMultiplier = 220, baseMultiplier = 8.179, cooldown = 0.5, damageEffectiveness = 8.179, levelRequirement = 82, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[27] = { 82, attackSpeedMultiplier = 220, baseMultiplier = 8.413, cooldown = 0.5, damageEffectiveness = 8.413, levelRequirement = 84, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[28] = { 84, attackSpeedMultiplier = 220, baseMultiplier = 8.654, cooldown = 0.5, damageEffectiveness = 8.654, levelRequirement = 86, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[29] = { 86, attackSpeedMultiplier = 220, baseMultiplier = 8.902, cooldown = 0.5, damageEffectiveness = 8.902, levelRequirement = 88, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[30] = { 88, attackSpeedMultiplier = 220, baseMultiplier = 9.157, cooldown = 0.5, damageEffectiveness = 9.157, levelRequirement = 90, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[31] = { 90, attackSpeedMultiplier = 220, baseMultiplier = 9.554, cooldown = 0.5, damageEffectiveness = 9.554, levelRequirement = 91, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[32] = { 92, attackSpeedMultiplier = 220, baseMultiplier = 9.691, cooldown = 0.5, damageEffectiveness = 9.691, levelRequirement = 92, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[33] = { 94, attackSpeedMultiplier = 220, baseMultiplier = 9.83, cooldown = 0.5, damageEffectiveness = 9.83, levelRequirement = 93, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[34] = { 96, attackSpeedMultiplier = 220, baseMultiplier = 9.971, cooldown = 0.5, damageEffectiveness = 9.971, levelRequirement = 94, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[35] = { 98, attackSpeedMultiplier = 220, baseMultiplier = 10.114, cooldown = 0.5, damageEffectiveness = 10.114, levelRequirement = 95, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[36] = { 100, attackSpeedMultiplier = 220, baseMultiplier = 10.258, cooldown = 0.5, damageEffectiveness = 10.258, levelRequirement = 96, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[37] = { 102, attackSpeedMultiplier = 220, baseMultiplier = 10.405, cooldown = 0.5, damageEffectiveness = 10.405, levelRequirement = 97, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[38] = { 104, attackSpeedMultiplier = 220, baseMultiplier = 10.554, cooldown = 0.5, damageEffectiveness = 10.554, levelRequirement = 98, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[39] = { 106, attackSpeedMultiplier = 220, baseMultiplier = 10.706, cooldown = 0.5, damageEffectiveness = 10.706, levelRequirement = 99, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[40] = { 108, attackSpeedMultiplier = 220, baseMultiplier = 10.859, cooldown = 0.5, damageEffectiveness = 10.859, levelRequirement = 100, soulPreventionDuration = 3, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 30, }, },
	},
}
skills["BladeVortex"] = {
	name = "Blade Vortex",
	baseTypeName = "Blade Vortex",
	color = 2,
	baseEffectiveness = 0.33660000562668,
	incrementalEffectiveness = 0.042899999767542,
	description = "This spell creates ethereal blades which orbit in an area around you, dealing damage every 0.6 seconds to all enemies in their radius. As more blades are added, the damage becomes greater and more frequent.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = activeSkill.skillData.hitFrequency / (1 + activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "Multiplier:BladeVortexBlade") * activeSkill.skillData.hitFrequencyPerBlade)
	end,
	parts = {
		{
			name = "0 Blades",
		},
		{
			name = "5 Blades",
		},
		{
			name = "10 Blades",
		},
	},
	statMap = {
		["blade_vortex_damage_+%_per_blade_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "BladeVortexBlade" }),
		},
		["blade_vortex_ailment_damage_+%_per_blade_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Ailment, { type = "Multiplier", var = "BladeVortexBlade" }),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["maximum_number_of_spinning_blades"] = {
			mod("Multiplier:BladeVortexMaxStages", "BASE", nil),
		},
		["blade_vortex_hit_rate_+%_per_blade"] = {
			skill("hitFrequencyPerBlade", nil),
			div = 100,
		},
		["quality_display_blade_vortex_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("hitFrequency", 0.6),
		mod("Multiplier:BladeVortexBlade", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:BladeVortexBlade", "BASE", 10, 0, 0, { type = "SkillPart", skillPart = 3 }),
		flag("Condition:HaveBladeVortex"),
	},
	qualityStats = {
		Default = {
			{ "blade_vortex_hit_rate_+%_per_blade", 0.25 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "maximum_number_of_spinning_blades", 10 },
		{ "blade_vortex_hit_rate_+%_per_blade", 35 },
		{ "blade_vortex_damage_+%_per_blade_final", 35 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"action_ignores_crit_tracking",
		"base_skill_show_average_damage_instead_of_dps",
		"damage_originates_from_initiator_location",
		"skill_cannot_gain_repeat_bonuses",
		"quality_display_blade_vortex_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 12, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 15, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 19, statInterpolation = { 3, 3, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 23, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 27, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 31, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 0, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 35, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 38, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 41, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 47, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 50, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 53, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 59, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 62, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 66, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 0.3, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
	},
}
skills["BladeVortexAltX"] = {
	name = "Blade Vortex of the Scythe",
	baseTypeName = "Blade Vortex of the Scythe",
	color = 2,
	baseEffectiveness = 3.2437999248505,
	incrementalEffectiveness = 0.042899999767542,
	description = "This spell creates a swarm of ethereal blades which briefly orbit in an area around you, dealing damage every 0.6 seconds to all enemies in their radius.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["quality_display_blade_vortex_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("hitTimeOverride", 0.6),
		flag("Condition:HaveBladeVortex"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_physical_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "maximum_number_of_spinning_blades", 1 },
		{ "base_skill_effect_duration", 800 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"action_ignores_crit_tracking",
		"base_skill_show_average_damage_instead_of_dps",
		"damage_originates_from_initiator_location",
		"skill_cannot_gain_repeat_bonuses",
		"quality_display_blade_vortex_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3, levelRequirement = 12, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3, levelRequirement = 15, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3, levelRequirement = 19, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3, levelRequirement = 23, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 3, levelRequirement = 27, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 3, levelRequirement = 31, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 3, levelRequirement = 35, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 3, levelRequirement = 38, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 3, levelRequirement = 41, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 3, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 3, levelRequirement = 47, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 3, levelRequirement = 50, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 3, levelRequirement = 53, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 3, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 32, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 3, levelRequirement = 59, statInterpolation = { 3, 3, 1, }, cost = { Mana = 32, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 3, levelRequirement = 62, statInterpolation = { 3, 3, 1, }, cost = { Mana = 34, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 3, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 34, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 3, levelRequirement = 66, statInterpolation = { 3, 3, 1, }, cost = { Mana = 35, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 3, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { Mana = 35, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 3, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 36, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 20, critChance = 6, damageEffectiveness = 3, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 38, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 20, critChance = 6, damageEffectiveness = 3, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 36, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 21, critChance = 6, damageEffectiveness = 3, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 39, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 21, critChance = 6, damageEffectiveness = 3, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 41, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 22, critChance = 6, damageEffectiveness = 3, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 41, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 22, critChance = 6, damageEffectiveness = 3, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 42, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 23, critChance = 6, damageEffectiveness = 3, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 42, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 23, critChance = 6, damageEffectiveness = 3, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 43, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 24, critChance = 6, damageEffectiveness = 3, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 43, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 24, critChance = 6, damageEffectiveness = 3, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 45, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 25, critChance = 6, damageEffectiveness = 3, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 45, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 25, critChance = 6, damageEffectiveness = 3, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 45, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 25, critChance = 6, damageEffectiveness = 3, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 46, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 25, critChance = 6, damageEffectiveness = 3, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 46, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 26, critChance = 6, damageEffectiveness = 3, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 46, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 26, critChance = 6, damageEffectiveness = 3, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 48, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 26, critChance = 6, damageEffectiveness = 3, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 48, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 26, critChance = 6, damageEffectiveness = 3, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 48, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 27, critChance = 6, damageEffectiveness = 3, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 49, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 27, critChance = 6, damageEffectiveness = 3, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 49, }, },
	},
}
skills["VaalBladeVortex"] = {
	name = "Vaal Blade Vortex",
	baseTypeName = "Vaal Blade Vortex",
	color = 2,
	baseEffectiveness = 1.25,
	incrementalEffectiveness = 0.033300001174212,
	description = "Creates an independently-moving vortex of ethereal blades which lasts for a duration. The vortex moves toward nearby enemies, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Vaal] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = activeSkill.skillData.hitFrequency / (1 + activeSkill.skillData.VaalBladeVortexBlade * (activeSkill.skillData.hitFrequencyPerBlade or 0))
	end,
	statMap = {
		["base_blade_vortex_hit_rate_ms"] = {
			skill("hitFrequency", nil),
			div = 1000,
		},
		["blade_vortex_hit_rate_+%_per_blade"] = {
			skill("hitFrequencyPerBlade", nil),
			div = 100,
		},
		["vaal_blade_vortex_has_10_spinning_blades"] = {
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("VaalBladeVortexBlade", 10),
	},
	qualityStats = {
		Default = {
			{ "blade_vortex_hit_rate_+%_per_blade", 0.25 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "extra_gore_chance_override_%", 15 },
		{ "base_blade_vortex_hit_rate_ms", 200 },
		{ "critical_strike_chance_+%", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"vaal_blade_vortex_has_10_spinning_blades",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 12, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 15, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 19, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 23, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 27, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 31, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 35, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 38, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 41, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 44, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 47, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 50, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 53, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 56, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 59, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 62, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 64, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 66, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 68, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 70, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 72, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 74, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 76, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 78, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 80, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 82, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 84, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 86, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 88, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 90, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 91, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 92, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 93, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 94, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 95, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 96, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 97, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 98, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 99, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 100, soulPreventionDuration = 6, vaalStoredUses = 2, statInterpolation = { 3, 3, 1, }, cost = { Soul = 30, }, },
	},
}
skills["Bladefall"] = {
	name = "Bladefall",
	baseTypeName = "Bladefall",
	color = 2,
	baseEffectiveness = 1.2013000249863,
	incrementalEffectiveness = 0.045499999076128,
	description = "Ethereal weapons rain from the sky, dealing damage to enemies in a sequence of volleys. Enemies can be hit multiple times where these overlap.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	statMap = {
		["quality_display_bladefall_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 44),
		skill("radiusLabel", "Volley Width:"),
		skill("radiusSecondary", 12),
		skill("radiusSecondaryLabel", "Volley Length:"),
	},
	qualityStats = {
		Default = {
			{ "bladefall_number_of_volleys", 0.05 },
		},
	},
	constantStats = {
		{ "bladefall_number_of_volleys", 5 },
		{ "bladefall_blade_left_in_ground_for_every_X_volleys", 1 },
		{ "maximum_number_of_blades_left_in_ground", 40 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"quality_display_bladefall_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 10, damageEffectiveness = 1.4, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
	},
}
skills["BladefallAltX"] = {
	name = "Bladefall of Volleys",
	baseTypeName = "Bladefall of Volleys",
	color = 2,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.045499999076128,
	description = "Ethereal weapons rain from the sky, dealing damage to enemies in a sequence of volleys, each wider and more damaging than the last. Enemies can be hit multiple times where these overlap.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	statMap = {
		["bladefall_damage_per_stage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "BladefallofVolleysStage" }),
		},
		["bladefall_critical_strike_chance_+%_per_stage"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "Multiplier", var = "BladefallofVolleysStage" }),
		},
		["bladefall_number_of_volleys"] = {
			mod("Multiplier:BladefallofVolleysMaxStages", "BASE", nil),
		},
		["quality_display_bladefall_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "bladefall_number_of_volleys", 0.05 },
		},
	},
	constantStats = {
		{ "bladefall_number_of_volleys", 6 },
		{ "bladefall_damage_per_stage_+%_final", 10 },
		{ "bladefall_critical_strike_chance_+%_per_stage", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"quality_display_bladefall_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 10, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
	},
}
skills["BladefallAltY"] = {
	name = "Bladefall of Impaling",
	baseTypeName = "Bladefall of Impaling",
	color = 2,
	baseEffectiveness = 1.2013000249863,
	incrementalEffectiveness = 0.045499999076128,
	description = "Ethereal weapons rain from the sky, dealing damage to enemies in a sequence of volleys. Enemies can be hit multiple times where these overlap.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	statMap = {
		["quality_display_bladefall_is_gem"] = {
			--Display only
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "impale_debuff_effect_+%", 2 },
		},
	},
	constantStats = {
		{ "bladefall_number_of_volleys", 5 },
		{ "spell_impale_on_crit_%_chance", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"impale_debuff_effect_+%",
		"is_area_damage",
		"quality_display_bladefall_is_gem",
		"no_critical_strike_multiplier",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 53, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 31, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 56, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 34, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 59, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 37, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 62, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 65, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 42, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 68, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 71, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 46, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 74, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 77, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 50, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 80, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 83, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 54, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 86, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 89, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 58, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 92, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 95, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 62, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 98, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 101, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 66, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 104, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 107, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 110, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 113, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 116, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 119, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 122, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 125, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 128, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 131, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 134, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 137, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 138, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 140, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 141, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 143, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 144, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 146, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 147, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 149, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 150, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 152, critChance = 15, damageEffectiveness = 1.4, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
	},
}
skills["BladefallAltZ"] = {
	name = "Bladefall of Trarthus",
	baseTypeName = "Bladefall of Trarthus",
	color = 2,
	baseEffectiveness = 1.081200003624,
	incrementalEffectiveness = 0.045499999076128,
	description = "Once activated, continuously spends mana to cause volleys of ethereal weapons rain from the sky around you, dealing damage to enemies they impact. Each Blade will target a separate enemy in the volley area if possible. Each enemy can only be hit once by each volley, even if multiple blades land near them. This skill cannot be triggered or used by Totems, Traps, or Mines.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.Instant] = true, [SkillType.Arcane] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = activeSkill.skillData.hitFrequency / (1 + activeSkill.skillData.incVolleyFrequency / 100)
	end,
	statMap = {
		["quality_display_bladefall_is_gem"] = {
			--Display only
		},
		["bladefall_base_volley_frequency_ms"] = {
			skill("hitFrequency", nil),
			div = 1000,
		},
		["bladefall_volley_frequency_+%_per_100_maximum_mana"] = {
			skill("incVolleyFrequency", nil, { type = "PerStat", stat = "Mana", div = 100 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.15 },
		},
	},
	constantStats = {
		{ "maximum_number_of_blades_left_in_ground", 40 },
		{ "base_skill_effect_duration", 6000 },
		{ "bladefall_base_volley_frequency_ms", 700 },
		{ "bladefall_volley_frequency_+%_per_100_maximum_mana", 2 },
		{ "active_skill_base_area_of_effect_radius", 25 },
		{ "active_skill_base_secondary_area_of_effect_radius", 10 },
		{ "bladefall_create_X_lingering_blades_per_volley", 5 },
		{ "active_skill_area_of_effect_description_mode", 6 },
		{ "active_skill_secondary_area_of_effect_description_mode", 6 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"quality_display_bladefall_is_gem",
		"skill_can_add_multiple_charges_per_action",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 31, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[3] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[4] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 37, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[5] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[6] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 42, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[7] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[8] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[9] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[10] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 50, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[11] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[12] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 54, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[13] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 56, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[14] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[15] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[16] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[17] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[18] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[19] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[20] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[21] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[22] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[23] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[24] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[25] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[26] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[27] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[28] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[29] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[30] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[31] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[32] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[33] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[34] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[35] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[36] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[37] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[38] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[39] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
		[40] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 10, damageEffectiveness = 1.2, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, 3, }, cost = { ManaPercentPerMinute = 300, }, },
	},
}
skills["BlastRain"] = {
	name = "Blast Rain",
	baseTypeName = "Blast Rain",
	color = 2,
	description = "Fires arrows up in the air, to rain down in an area. Each arrow deals area damage around where it lands, and they will all overlap on the targeted location.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Fire] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		flag("OneShotProj"),
	},
	qualityStats = {
		Default = {
			{ "base_number_of_arrows", 0.05 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
		{ "base_number_of_arrows", 6 },
		{ "blast_rain_arrow_delay_ms", 80 },
	},
	stats = {
		"base_reduce_enemy_fire_resistance_%",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"quality_display_base_additional_arrows_is_gem",
	},
	levels = {
		[1] = { 20, baseMultiplier = 0.3, damageEffectiveness = 0.3, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 21, baseMultiplier = 0.303, damageEffectiveness = 0.3, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 21, baseMultiplier = 0.306, damageEffectiveness = 0.31, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 22, baseMultiplier = 0.309, damageEffectiveness = 0.31, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[5] = { 22, baseMultiplier = 0.312, damageEffectiveness = 0.31, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 23, baseMultiplier = 0.315, damageEffectiveness = 0.31, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 23, baseMultiplier = 0.318, damageEffectiveness = 0.32, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 24, baseMultiplier = 0.321, damageEffectiveness = 0.32, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 24, baseMultiplier = 0.324, damageEffectiveness = 0.32, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 25, baseMultiplier = 0.327, damageEffectiveness = 0.33, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 25, baseMultiplier = 0.329, damageEffectiveness = 0.33, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 26, baseMultiplier = 0.332, damageEffectiveness = 0.33, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 26, baseMultiplier = 0.335, damageEffectiveness = 0.34, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 27, baseMultiplier = 0.338, damageEffectiveness = 0.34, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 27, baseMultiplier = 0.341, damageEffectiveness = 0.34, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 28, baseMultiplier = 0.344, damageEffectiveness = 0.34, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 28, baseMultiplier = 0.347, damageEffectiveness = 0.35, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 29, baseMultiplier = 0.35, damageEffectiveness = 0.35, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 29, baseMultiplier = 0.353, damageEffectiveness = 0.35, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 30, baseMultiplier = 0.356, damageEffectiveness = 0.36, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 31, baseMultiplier = 0.359, damageEffectiveness = 0.36, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 31, baseMultiplier = 0.362, damageEffectiveness = 0.36, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 32, baseMultiplier = 0.365, damageEffectiveness = 0.36, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 32, baseMultiplier = 0.368, damageEffectiveness = 0.37, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 33, baseMultiplier = 0.371, damageEffectiveness = 0.37, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 33, baseMultiplier = 0.374, damageEffectiveness = 0.37, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 34, baseMultiplier = 0.377, damageEffectiveness = 0.38, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 34, baseMultiplier = 0.38, damageEffectiveness = 0.38, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 35, baseMultiplier = 0.383, damageEffectiveness = 0.38, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 35, baseMultiplier = 0.385, damageEffectiveness = 0.39, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 36, baseMultiplier = 0.387, damageEffectiveness = 0.39, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 36, baseMultiplier = 0.388, damageEffectiveness = 0.39, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 37, baseMultiplier = 0.39, damageEffectiveness = 0.39, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 37, baseMultiplier = 0.391, damageEffectiveness = 0.39, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 38, baseMultiplier = 0.393, damageEffectiveness = 0.39, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 38, baseMultiplier = 0.394, damageEffectiveness = 0.39, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 39, baseMultiplier = 0.396, damageEffectiveness = 0.4, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 39, baseMultiplier = 0.397, damageEffectiveness = 0.4, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 40, baseMultiplier = 0.399, damageEffectiveness = 0.4, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 41, baseMultiplier = 0.4, damageEffectiveness = 0.4, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["BlastRainAltX"] = {
	name = "Blast Rain of Trarthus",
	baseTypeName = "Blast Rain of Trarthus",
	color = 2,
	baseEffectiveness = 2.8175001144409,
	incrementalEffectiveness = 0.054000001400709,
	description = "Fires a single arrow up in the air, to rain down at a targeted location. The arrow deals area damage around where it lands, as well as releasing a wave of fire which will apply a burning debuff to enemies. The impact of the arrow will also inflict this debuff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Fire] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, [SkillType.DamageOverTime] = true, [SkillType.CausesBurning] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "fire_dot_multiplier_+", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
		{ "base_number_of_arrows", 1 },
		{ "blast_rain_arrow_delay_ms", 80 },
		{ "active_skill_base_area_of_effect_radius", 10 },
		{ "base_skill_effect_duration", 4000 },
		{ "active_skill_base_secondary_area_of_effect_radius", 40 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"quality_display_base_additional_arrows_is_gem",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"modifiers_to_projectile_count_do_not_apply",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.9, damageEffectiveness = 0.9, levelRequirement = 28, statInterpolation = { 3, }, cost = { Mana = 9, }, },
		[2] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.908, damageEffectiveness = 0.908, levelRequirement = 31, statInterpolation = { 3, }, cost = { Mana = 9, }, },
		[3] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.916, damageEffectiveness = 0.916, levelRequirement = 34, statInterpolation = { 3, }, cost = { Mana = 9, }, },
		[4] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.924, damageEffectiveness = 0.924, levelRequirement = 37, statInterpolation = { 3, }, cost = { Mana = 9, }, },
		[5] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.932, damageEffectiveness = 0.932, levelRequirement = 40, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[6] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.939, damageEffectiveness = 0.939, levelRequirement = 42, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[7] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.947, damageEffectiveness = 0.947, levelRequirement = 44, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[8] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.955, damageEffectiveness = 0.955, levelRequirement = 46, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[9] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.963, damageEffectiveness = 0.963, levelRequirement = 48, statInterpolation = { 3, }, cost = { Mana = 10, }, },
		[10] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.971, damageEffectiveness = 0.971, levelRequirement = 50, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[11] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.979, damageEffectiveness = 0.979, levelRequirement = 52, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[12] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.987, damageEffectiveness = 0.987, levelRequirement = 54, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[13] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 0.995, damageEffectiveness = 0.995, levelRequirement = 56, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[14] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.003, damageEffectiveness = 1.003, levelRequirement = 58, statInterpolation = { 3, }, cost = { Mana = 11, }, },
		[15] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.011, damageEffectiveness = 1.011, levelRequirement = 60, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[16] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.018, damageEffectiveness = 1.018, levelRequirement = 62, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[17] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.026, damageEffectiveness = 1.026, levelRequirement = 64, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[18] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.034, damageEffectiveness = 1.034, levelRequirement = 66, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[19] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.042, damageEffectiveness = 1.042, levelRequirement = 68, statInterpolation = { 3, }, cost = { Mana = 12, }, },
		[20] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.05, damageEffectiveness = 1.05, levelRequirement = 70, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[21] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.058, damageEffectiveness = 1.058, levelRequirement = 72, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[22] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.066, damageEffectiveness = 1.066, levelRequirement = 74, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[23] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.074, damageEffectiveness = 1.074, levelRequirement = 76, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[24] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.082, damageEffectiveness = 1.082, levelRequirement = 78, statInterpolation = { 3, }, cost = { Mana = 13, }, },
		[25] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.089, damageEffectiveness = 1.089, levelRequirement = 80, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[26] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.097, damageEffectiveness = 1.097, levelRequirement = 82, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[27] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.105, damageEffectiveness = 1.105, levelRequirement = 84, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[28] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.113, damageEffectiveness = 1.113, levelRequirement = 86, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[29] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.121, damageEffectiveness = 1.121, levelRequirement = 88, statInterpolation = { 3, }, cost = { Mana = 14, }, },
		[30] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.129, damageEffectiveness = 1.129, levelRequirement = 90, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[31] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.133, damageEffectiveness = 1.133, levelRequirement = 91, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[32] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.137, damageEffectiveness = 1.137, levelRequirement = 92, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[33] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.141, damageEffectiveness = 1.141, levelRequirement = 93, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[34] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.145, damageEffectiveness = 1.145, levelRequirement = 94, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[35] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.149, damageEffectiveness = 1.149, levelRequirement = 95, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[36] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.153, damageEffectiveness = 1.153, levelRequirement = 96, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[37] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.157, damageEffectiveness = 1.157, levelRequirement = 97, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[38] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.161, damageEffectiveness = 1.161, levelRequirement = 98, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[39] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.164, damageEffectiveness = 1.164, levelRequirement = 99, statInterpolation = { 3, }, cost = { Mana = 15, }, },
		[40] = { 64.666670019428, attackSpeedMultiplier = -20, baseMultiplier = 1.168, damageEffectiveness = 1.168, levelRequirement = 100, statInterpolation = { 3, }, cost = { Mana = 16, }, },
	},
}
skills["BlinkArrow"] = {
	name = "Blink Arrow",
	baseTypeName = "Blink Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, you are teleported to it and a clone is summoned at your old location. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [SkillType.ProjectileSpeed] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.RangedAttack] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, [SkillType.Travel] = true, [SkillType.Cooldown] = true, [SkillType.Rain] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesFromUser] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"ArrowClone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "number_of_monsters_to_summon", 1 },
		{ "display_minion_monster_type", 25 },
	},
	stats = {
		"base_display_minion_actor_level",
		"base_cooldown_speed_+%",
		"active_skill_minion_damage_+%_final",
		"base_is_projectile",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 10, 0, 0, cooldown = 3, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 13, 2, 3, cooldown = 3, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 17, 5, 6, cooldown = 3, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 21, 7, 9, cooldown = 3, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 25, 10, 12, cooldown = 3, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 29, 12, 15, cooldown = 3, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 33, 15, 18, cooldown = 3, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 36, 17, 21, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 39, 20, 24, cooldown = 3, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 42, 22, 27, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 45, 25, 30, cooldown = 3, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 48, 27, 33, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 51, 30, 36, cooldown = 3, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 54, 32, 39, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 57, 35, 42, cooldown = 3, levelRequirement = 57, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 60, 37, 45, cooldown = 3, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[17] = { 63, 40, 48, cooldown = 3, levelRequirement = 63, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 66, 42, 51, cooldown = 3, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 68, 45, 54, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[20] = { 70, 47, 57, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 72, 50, 60, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 74, 52, 63, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 76, 55, 66, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 78, 57, 69, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 80, 60, 72, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 82, 62, 75, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 84, 65, 78, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 22, }, },
		[28] = { 86, 67, 81, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 88, 70, 84, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[30] = { 90, 72, 87, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[31] = { 91, 73, 88, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[32] = { 92, 75, 90, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 23, }, },
		[33] = { 93, 76, 91, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[34] = { 94, 77, 93, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[35] = { 95, 78, 94, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[36] = { 96, 80, 96, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[37] = { 97, 81, 97, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[38] = { 98, 82, 99, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 24, }, },
		[39] = { 99, 83, 100, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
		[40] = { 100, 85, 102, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 25, }, },
	},
}
skills["BlinkArrowAltX"] = {
	name = "Blink Arrow of Bombarding Clones",
	baseTypeName = "Blink Arrow of Bombarding Clones",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, you are teleported to it and a clone is summoned at your old location. The clone is a minion that uses your bow and quiver to fire arrows into the air to land around a target.",
	skillTypes = { [SkillType.ProjectileSpeed] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.RangedAttack] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, [SkillType.Travel] = true, [SkillType.Cooldown] = true, [SkillType.Rain] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Rain] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"ArrowCloneRoA",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "number_of_monsters_to_summon", 1 },
		{ "display_minion_monster_type", 25 },
		{ "base_number_of_blink_mirror_arrow_rain_of_arrows_clones", 3 },
	},
	stats = {
		"base_display_minion_actor_level",
		"active_skill_minion_damage_+%_final",
		"base_is_projectile",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 10, 0, cooldown = 3, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 13, 3, cooldown = 3, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 17, 6, cooldown = 3, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 21, 9, cooldown = 3, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 25, 12, cooldown = 3, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 29, 15, cooldown = 3, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 33, 18, cooldown = 3, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 36, 21, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 39, 24, cooldown = 3, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 42, 27, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 45, 30, cooldown = 3, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 48, 33, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 51, 36, cooldown = 3, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 54, 39, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 57, 42, cooldown = 3, levelRequirement = 57, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 60, 45, cooldown = 3, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[17] = { 63, 48, cooldown = 3, levelRequirement = 63, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 66, 51, cooldown = 3, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 68, 54, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[20] = { 70, 57, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 72, 60, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 74, 63, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 76, 66, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 78, 69, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 80, 72, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 82, 75, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 84, 78, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[28] = { 86, 81, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 88, 84, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[30] = { 90, 87, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[31] = { 91, 88, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[32] = { 92, 90, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[33] = { 93, 91, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[34] = { 94, 93, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[35] = { 95, 94, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[36] = { 96, 96, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[37] = { 97, 97, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[38] = { 98, 99, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[39] = { 99, 100, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[40] = { 100, 102, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
	},
}
skills["BlinkArrowAltY"] = {
	name = "Blink Arrow of Prismatic Clones",
	baseTypeName = "Blink Arrow of Prismatic Clones",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, you are teleported to it and a clone is summoned at your old location. The clone is a minion that uses your bow and quiver to fire random elemental arrows which convert all physical damage to the chosen element and deal no damage of other damage types.",
	skillTypes = { [SkillType.ProjectileSpeed] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.RangedAttack] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, [SkillType.Travel] = true, [SkillType.Cooldown] = true, [SkillType.Rain] = true, [SkillType.RandomElement] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RandomElement] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"ArrowCloneEle",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "number_of_monsters_to_summon", 1 },
		{ "display_minion_monster_type", 25 },
		{ "base_number_of_blink_mirror_arrow_elemental_hit_clones", 3 },
	},
	stats = {
		"base_display_minion_actor_level",
		"active_skill_minion_damage_+%_final",
		"base_is_projectile",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 10, 0, cooldown = 3, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 13, 3, cooldown = 3, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 17, 6, cooldown = 3, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 21, 9, cooldown = 3, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 25, 12, cooldown = 3, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 29, 15, cooldown = 3, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 33, 18, cooldown = 3, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 36, 21, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 39, 24, cooldown = 3, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 42, 27, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 45, 30, cooldown = 3, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 48, 33, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 51, 36, cooldown = 3, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 54, 39, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 57, 42, cooldown = 3, levelRequirement = 57, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 60, 45, cooldown = 3, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[17] = { 63, 48, cooldown = 3, levelRequirement = 63, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[18] = { 66, 51, cooldown = 3, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 68, 54, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[20] = { 70, 57, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 72, 60, cooldown = 3, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 74, 63, cooldown = 3, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 76, 66, cooldown = 3, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 78, 69, cooldown = 3, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 80, 72, cooldown = 3, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 82, 75, cooldown = 3, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 84, 78, cooldown = 3, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[28] = { 86, 81, cooldown = 3, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 88, 84, cooldown = 3, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[30] = { 90, 87, cooldown = 3, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[31] = { 91, 88, cooldown = 3, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[32] = { 92, 90, cooldown = 3, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[33] = { 93, 91, cooldown = 3, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[34] = { 94, 93, cooldown = 3, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[35] = { 95, 94, cooldown = 3, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[36] = { 96, 96, cooldown = 3, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[37] = { 97, 97, cooldown = 3, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[38] = { 98, 99, cooldown = 3, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[39] = { 99, 100, cooldown = 3, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[40] = { 100, 102, cooldown = 3, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
	},
}
skills["BloodRage"] = {
	name = "Blood Rage",
	baseTypeName = "Blood Rage",
	color = 2,
	baseEffectiveness = 0,
	description = "Adds a buff that deals Physical Damage over time, while increasing Attack Speed and Life Leech. Killing an enemy while this buff is active refreshes the buff duration, and can grant a Frenzy Charge.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_physical_damage_%_of_maximum_life_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "Life", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "EnergyShield", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["life_leech_from_physical_attack_damage_permyriad"] = {
			mod("PhysicalDamageLifeLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("thisIsNotABuff", true),
	},
	qualityStats = {
		Default = {
			{ "attack_speed_+%_granted_from_skill", 0.25 },
		},
	},
	constantStats = {
		{ "life_leech_from_physical_attack_damage_permyriad", 120 },
		{ "base_physical_damage_%_of_maximum_life_to_deal_per_minute", 240 },
		{ "base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute", 240 },
		{ "add_frenzy_charge_on_kill_%_chance", 25 },
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"base_skill_effect_duration",
		"skill_level",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 5, 7000, 1, cooldown = 1, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 12, }, },
		[2] = { 6, 7200, 2, cooldown = 1, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 13, }, },
		[3] = { 6, 7400, 3, cooldown = 1, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 14, }, },
		[4] = { 7, 7600, 4, cooldown = 1, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 15, }, },
		[5] = { 7, 7800, 5, cooldown = 1, levelRequirement = 31, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 16, }, },
		[6] = { 8, 8000, 6, cooldown = 1, levelRequirement = 34, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 17, }, },
		[7] = { 8, 8200, 7, cooldown = 1, levelRequirement = 37, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 18, }, },
		[8] = { 9, 8400, 8, cooldown = 1, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 19, }, },
		[9] = { 9, 8600, 9, cooldown = 1, levelRequirement = 43, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 20, }, },
		[10] = { 10, 8800, 10, cooldown = 1, levelRequirement = 46, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 21, }, },
		[11] = { 10, 9000, 11, cooldown = 1, levelRequirement = 49, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 22, }, },
		[12] = { 11, 9200, 12, cooldown = 1, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 23, }, },
		[13] = { 11, 9400, 13, cooldown = 1, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 24, }, },
		[14] = { 12, 9600, 14, cooldown = 1, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 25, }, },
		[15] = { 12, 9800, 15, cooldown = 1, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 26, }, },
		[16] = { 13, 10000, 16, cooldown = 1, levelRequirement = 62, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 26, }, },
		[17] = { 13, 10200, 17, cooldown = 1, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 27, }, },
		[18] = { 14, 10400, 18, cooldown = 1, levelRequirement = 66, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 28, }, },
		[19] = { 14, 10600, 19, cooldown = 1, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 28, }, },
		[20] = { 15, 10800, 20, cooldown = 1, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 29, }, },
		[21] = { 15, 11000, 21, cooldown = 1, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 30, }, },
		[22] = { 16, 11200, 22, cooldown = 1, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 31, }, },
		[23] = { 16, 11400, 23, cooldown = 1, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 32, }, },
		[24] = { 17, 11600, 24, cooldown = 1, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 32, }, },
		[25] = { 17, 11800, 25, cooldown = 1, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 33, }, },
		[26] = { 18, 12000, 26, cooldown = 1, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 33, }, },
		[27] = { 18, 12200, 27, cooldown = 1, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 34, }, },
		[28] = { 19, 12400, 28, cooldown = 1, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 34, }, },
		[29] = { 19, 12600, 29, cooldown = 1, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 35, }, },
		[30] = { 20, 12800, 30, cooldown = 1, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 35, }, },
		[31] = { 20, 12900, 31, cooldown = 1, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 36, }, },
		[32] = { 20, 13000, 32, cooldown = 1, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 36, }, },
		[33] = { 20, 13100, 33, cooldown = 1, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 37, }, },
		[34] = { 21, 13200, 34, cooldown = 1, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 37, }, },
		[35] = { 21, 13300, 35, cooldown = 1, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 38, }, },
		[36] = { 21, 13400, 36, cooldown = 1, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 38, }, },
		[37] = { 21, 13500, 37, cooldown = 1, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 38, }, },
		[38] = { 22, 13600, 38, cooldown = 1, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 39, }, },
		[39] = { 22, 13700, 39, cooldown = 1, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 39, }, },
		[40] = { 22, 13800, 40, cooldown = 1, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Life = 39, }, },
	},
}
skills["BurningArrow"] = {
	name = "Burning Arrow",
	baseTypeName = "Burning Arrow",
	color = 2,
	description = "Fires a burning arrow that deals fire damage and has a chance to ignite.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_ignite_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_chance_to_ignite_%", 25 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
	},
	stats = {
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 2.8, damageEffectiveness = 2.8, levelRequirement = 1, cost = { Mana = 8, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 2.874, damageEffectiveness = 2.874, levelRequirement = 2, cost = { Mana = 8, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 4, cost = { Mana = 8, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 3.021, damageEffectiveness = 3.021, levelRequirement = 7, cost = { Mana = 9, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 3.095, damageEffectiveness = 3.095, levelRequirement = 11, cost = { Mana = 9, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 3.168, damageEffectiveness = 3.168, levelRequirement = 16, cost = { Mana = 9, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 3.242, damageEffectiveness = 3.242, levelRequirement = 20, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 3.316, damageEffectiveness = 3.316, levelRequirement = 24, cost = { Mana = 10, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 28, cost = { Mana = 10, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 3.463, damageEffectiveness = 3.463, levelRequirement = 32, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 3.537, damageEffectiveness = 3.537, levelRequirement = 36, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 3.611, damageEffectiveness = 3.611, levelRequirement = 40, cost = { Mana = 12, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 3.684, damageEffectiveness = 3.684, levelRequirement = 44, cost = { Mana = 12, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 3.758, damageEffectiveness = 3.758, levelRequirement = 48, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 3.832, damageEffectiveness = 3.832, levelRequirement = 52, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 3.905, damageEffectiveness = 3.905, levelRequirement = 56, cost = { Mana = 13, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 3.979, damageEffectiveness = 3.979, levelRequirement = 60, cost = { Mana = 13, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 4.053, damageEffectiveness = 4.053, levelRequirement = 64, cost = { Mana = 14, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 4.126, damageEffectiveness = 4.126, levelRequirement = 67, cost = { Mana = 14, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 4.2, damageEffectiveness = 4.2, levelRequirement = 70, cost = { Mana = 14, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 4.274, damageEffectiveness = 4.274, levelRequirement = 72, cost = { Mana = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 4.347, damageEffectiveness = 4.347, levelRequirement = 74, cost = { Mana = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 4.421, damageEffectiveness = 4.421, levelRequirement = 76, cost = { Mana = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 4.495, damageEffectiveness = 4.495, levelRequirement = 78, cost = { Mana = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 4.568, damageEffectiveness = 4.568, levelRequirement = 80, cost = { Mana = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 4.642, damageEffectiveness = 4.642, levelRequirement = 82, cost = { Mana = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 4.716, damageEffectiveness = 4.716, levelRequirement = 84, cost = { Mana = 16, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 4.789, damageEffectiveness = 4.789, levelRequirement = 86, cost = { Mana = 16, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 4.863, damageEffectiveness = 4.863, levelRequirement = 88, cost = { Mana = 16, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 4.937, damageEffectiveness = 4.937, levelRequirement = 90, cost = { Mana = 16, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 4.974, damageEffectiveness = 4.974, levelRequirement = 91, cost = { Mana = 16, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 5.011, damageEffectiveness = 5.011, levelRequirement = 92, cost = { Mana = 16, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 5.047, damageEffectiveness = 5.047, levelRequirement = 93, cost = { Mana = 16, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 5.084, damageEffectiveness = 5.084, levelRequirement = 94, cost = { Mana = 17, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 5.121, damageEffectiveness = 5.121, levelRequirement = 95, cost = { Mana = 17, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 5.158, damageEffectiveness = 5.158, levelRequirement = 96, cost = { Mana = 17, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 5.195, damageEffectiveness = 5.195, levelRequirement = 97, cost = { Mana = 17, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 5.232, damageEffectiveness = 5.232, levelRequirement = 98, cost = { Mana = 17, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 5.268, damageEffectiveness = 5.268, levelRequirement = 99, cost = { Mana = 17, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 5.305, damageEffectiveness = 5.305, levelRequirement = 100, cost = { Mana = 17, }, },
	},
}
skills["BurningArrowAltX"] = {
	name = "Burning Arrow of Vigour",
	baseTypeName = "Burning Arrow of Vigour",
	color = 2,
	description = "Fires a burning arrow that deals fire damage and has a chance to ignite.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["added_fire_damage_to_attacks_equal_to_%_maximum_life"] = {
			mod("FireMin", "BASE", nil, ModFlag.Attack, 0, { type = "PercentStat", stat = "Life", percent = 1 }),
			mod("FireMax", "BASE", nil, ModFlag.Attack, 0, { type = "PercentStat", stat = "Life", percent = 1 }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_ignite_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_chance_to_ignite_%", 25 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
	},
	stats = {
		"added_fire_damage_to_attacks_equal_to_%_maximum_life",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 21, attackSpeedMultiplier = -25, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 21, attackSpeedMultiplier = -25, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 22, attackSpeedMultiplier = -25, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 22, attackSpeedMultiplier = -25, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[5] = { 23, attackSpeedMultiplier = -25, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 23, attackSpeedMultiplier = -25, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 24, attackSpeedMultiplier = -25, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 25, attackSpeedMultiplier = -25, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 25, attackSpeedMultiplier = -25, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 26, attackSpeedMultiplier = -25, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 27, attackSpeedMultiplier = -25, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 28, attackSpeedMultiplier = -25, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 28, attackSpeedMultiplier = -25, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 29, attackSpeedMultiplier = -25, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 30, attackSpeedMultiplier = -25, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 30, attackSpeedMultiplier = -25, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 31, attackSpeedMultiplier = -25, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 31, attackSpeedMultiplier = -25, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[19] = { 32, attackSpeedMultiplier = -25, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[20] = { 32, attackSpeedMultiplier = -25, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 33, attackSpeedMultiplier = -25, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[22] = { 33, attackSpeedMultiplier = -25, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[23] = { 34, attackSpeedMultiplier = -25, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[24] = { 34, attackSpeedMultiplier = -25, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[25] = { 35, attackSpeedMultiplier = -25, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[26] = { 35, attackSpeedMultiplier = -25, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 36, attackSpeedMultiplier = -25, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[28] = { 36, attackSpeedMultiplier = -25, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[29] = { 37, attackSpeedMultiplier = -25, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[30] = { 37, attackSpeedMultiplier = -25, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[31] = { 37, attackSpeedMultiplier = -25, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[32] = { 38, attackSpeedMultiplier = -25, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[33] = { 38, attackSpeedMultiplier = -25, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[34] = { 38, attackSpeedMultiplier = -25, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[35] = { 38, attackSpeedMultiplier = -25, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[36] = { 39, attackSpeedMultiplier = -25, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[37] = { 39, attackSpeedMultiplier = -25, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[38] = { 39, attackSpeedMultiplier = -25, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[39] = { 39, attackSpeedMultiplier = -25, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[40] = { 40, attackSpeedMultiplier = -25, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 16, }, },
	},
}
skills["VaalBurningArrow"] = {
	name = "Vaal Burning Arrow",
	baseTypeName = "Vaal Burning Arrow",
	color = 2,
	description = "Fires an arrow that explodes, dealing fire damage to its target and other nearby enemies, with an increased chance of igniting them.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Vaal] = true, [SkillType.Fire] = true, [SkillType.ThresholdJewelDuration] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 16),
	},
	qualityStats = {
		Default = {
			{ "active_skill_ignite_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "base_chance_to_ignite_%", 50 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
		{ "projectile_base_number_of_targets_to_pierce", 3 },
	},
	stats = {
		"vaal_burning_arrow_explode_on_hit",
		"global_always_hit",
		"skill_can_fire_arrows",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 3.9, damageEffectiveness = 3.9, levelRequirement = 1, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 3.989, damageEffectiveness = 3.989, levelRequirement = 2, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 4.079, damageEffectiveness = 4.079, levelRequirement = 4, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 4.168, damageEffectiveness = 4.168, levelRequirement = 7, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 4.258, damageEffectiveness = 4.258, levelRequirement = 11, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 4.347, damageEffectiveness = 4.347, levelRequirement = 16, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 4.437, damageEffectiveness = 4.437, levelRequirement = 20, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 4.526, damageEffectiveness = 4.526, levelRequirement = 24, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 4.616, damageEffectiveness = 4.616, levelRequirement = 28, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 4.705, damageEffectiveness = 4.705, levelRequirement = 32, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 4.795, damageEffectiveness = 4.795, levelRequirement = 36, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 4.884, damageEffectiveness = 4.884, levelRequirement = 40, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 4.974, damageEffectiveness = 4.974, levelRequirement = 44, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 5.063, damageEffectiveness = 5.063, levelRequirement = 48, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 5.153, damageEffectiveness = 5.153, levelRequirement = 52, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 5.242, damageEffectiveness = 5.242, levelRequirement = 56, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 5.332, damageEffectiveness = 5.332, levelRequirement = 60, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 5.421, damageEffectiveness = 5.421, levelRequirement = 64, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 5.511, damageEffectiveness = 5.511, levelRequirement = 67, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 5.6, damageEffectiveness = 5.6, levelRequirement = 70, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 5.689, damageEffectiveness = 5.689, levelRequirement = 72, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 5.779, damageEffectiveness = 5.779, levelRequirement = 74, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 5.868, damageEffectiveness = 5.868, levelRequirement = 76, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 5.958, damageEffectiveness = 5.958, levelRequirement = 78, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 6.047, damageEffectiveness = 6.047, levelRequirement = 80, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 6.137, damageEffectiveness = 6.137, levelRequirement = 82, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 6.226, damageEffectiveness = 6.226, levelRequirement = 84, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 6.316, damageEffectiveness = 6.316, levelRequirement = 86, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 6.405, damageEffectiveness = 6.405, levelRequirement = 88, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 6.495, damageEffectiveness = 6.495, levelRequirement = 90, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 6.539, damageEffectiveness = 6.539, levelRequirement = 91, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 6.584, damageEffectiveness = 6.584, levelRequirement = 92, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 6.629, damageEffectiveness = 6.629, levelRequirement = 93, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 6.674, damageEffectiveness = 6.674, levelRequirement = 94, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 6.718, damageEffectiveness = 6.718, levelRequirement = 95, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 6.763, damageEffectiveness = 6.763, levelRequirement = 96, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 6.808, damageEffectiveness = 6.808, levelRequirement = 97, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 6.853, damageEffectiveness = 6.853, levelRequirement = 98, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 6.897, damageEffectiveness = 6.897, levelRequirement = 99, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 6.942, damageEffectiveness = 6.942, levelRequirement = 100, soulPreventionDuration = 2, vaalStoredUses = 3, cost = { Soul = 15, }, },
	},
}
skills["CausticArrow"] = {
	name = "Caustic Arrow",
	baseTypeName = "Caustic Arrow",
	color = 2,
	baseEffectiveness = 8.1670999526978,
	incrementalEffectiveness = 0.050299998372793,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["caustic_arrow_explode_on_hit_base_area_of_effect_radius"] = {
			skill("radius", nil),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radiusSecondary", 20),
		skill("radiusLabel", "AoE Explosion:"),
		skill("radiusSecondaryLabel", "Caustic Ground:"),
		skill("dotIsArea", true),
		flag("dotIsCausticGround"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "caustic_arrow_explode_on_hit_base_area_of_effect_radius", 12 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"active_skill_base_radius_+",
		"skill_can_fire_arrows",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 16.666667039196, 0, PvPDamageMultiplier = -30, baseMultiplier = 0.55, damageEffectiveness = 0.55, levelRequirement = 1, statInterpolation = { 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 16.666667039196, 0, PvPDamageMultiplier = -30, baseMultiplier = 0.555, damageEffectiveness = 0.55, levelRequirement = 2, statInterpolation = { 3, 1, }, cost = { Mana = 6, }, },
		[3] = { 16.666667039196, 1, PvPDamageMultiplier = -30, baseMultiplier = 0.56, damageEffectiveness = 0.56, levelRequirement = 4, statInterpolation = { 3, 1, }, cost = { Mana = 6, }, },
		[4] = { 16.666667039196, 1, PvPDamageMultiplier = -30, baseMultiplier = 0.565, damageEffectiveness = 0.56, levelRequirement = 7, statInterpolation = { 3, 1, }, cost = { Mana = 6, }, },
		[5] = { 16.666667039196, 1, PvPDamageMultiplier = -30, baseMultiplier = 0.57, damageEffectiveness = 0.57, levelRequirement = 11, statInterpolation = { 3, 1, }, cost = { Mana = 6, }, },
		[6] = { 16.666667039196, 2, PvPDamageMultiplier = -30, baseMultiplier = 0.575, damageEffectiveness = 0.57, levelRequirement = 16, statInterpolation = { 3, 1, }, cost = { Mana = 7, }, },
		[7] = { 16.666667039196, 2, PvPDamageMultiplier = -30, baseMultiplier = 0.58, damageEffectiveness = 0.58, levelRequirement = 20, statInterpolation = { 3, 1, }, cost = { Mana = 7, }, },
		[8] = { 16.666667039196, 2, PvPDamageMultiplier = -30, baseMultiplier = 0.585, damageEffectiveness = 0.58, levelRequirement = 24, statInterpolation = { 3, 1, }, cost = { Mana = 7, }, },
		[9] = { 16.666667039196, 3, PvPDamageMultiplier = -30, baseMultiplier = 0.59, damageEffectiveness = 0.59, levelRequirement = 28, statInterpolation = { 3, 1, }, cost = { Mana = 7, }, },
		[10] = { 16.666667039196, 3, PvPDamageMultiplier = -30, baseMultiplier = 0.595, damageEffectiveness = 0.59, levelRequirement = 32, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[11] = { 16.666667039196, 3, PvPDamageMultiplier = -30, baseMultiplier = 0.599, damageEffectiveness = 0.6, levelRequirement = 36, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[12] = { 16.666667039196, 3, PvPDamageMultiplier = -30, baseMultiplier = 0.604, damageEffectiveness = 0.6, levelRequirement = 40, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[13] = { 16.666667039196, 4, PvPDamageMultiplier = -30, baseMultiplier = 0.609, damageEffectiveness = 0.61, levelRequirement = 44, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[14] = { 16.666667039196, 4, PvPDamageMultiplier = -30, baseMultiplier = 0.614, damageEffectiveness = 0.61, levelRequirement = 48, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[15] = { 16.666667039196, 4, PvPDamageMultiplier = -30, baseMultiplier = 0.619, damageEffectiveness = 0.62, levelRequirement = 52, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[16] = { 16.666667039196, 5, PvPDamageMultiplier = -30, baseMultiplier = 0.624, damageEffectiveness = 0.62, levelRequirement = 56, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[17] = { 16.666667039196, 5, PvPDamageMultiplier = -30, baseMultiplier = 0.629, damageEffectiveness = 0.63, levelRequirement = 60, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[18] = { 16.666667039196, 5, PvPDamageMultiplier = -30, baseMultiplier = 0.634, damageEffectiveness = 0.63, levelRequirement = 64, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[19] = { 16.666667039196, 6, PvPDamageMultiplier = -30, baseMultiplier = 0.639, damageEffectiveness = 0.64, levelRequirement = 67, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[20] = { 16.666667039196, 6, PvPDamageMultiplier = -30, baseMultiplier = 0.644, damageEffectiveness = 0.64, levelRequirement = 70, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[21] = { 16.666667039196, 6, PvPDamageMultiplier = -30, baseMultiplier = 0.649, damageEffectiveness = 0.65, levelRequirement = 72, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[22] = { 16.666667039196, 7, PvPDamageMultiplier = -30, baseMultiplier = 0.654, damageEffectiveness = 0.65, levelRequirement = 74, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[23] = { 16.666667039196, 7, PvPDamageMultiplier = -30, baseMultiplier = 0.659, damageEffectiveness = 0.66, levelRequirement = 76, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[24] = { 16.666667039196, 7, PvPDamageMultiplier = -30, baseMultiplier = 0.664, damageEffectiveness = 0.66, levelRequirement = 78, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[25] = { 16.666667039196, 8, PvPDamageMultiplier = -30, baseMultiplier = 0.669, damageEffectiveness = 0.67, levelRequirement = 80, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[26] = { 16.666667039196, 8, PvPDamageMultiplier = -30, baseMultiplier = 0.674, damageEffectiveness = 0.67, levelRequirement = 82, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[27] = { 16.666667039196, 8, PvPDamageMultiplier = -30, baseMultiplier = 0.679, damageEffectiveness = 0.68, levelRequirement = 84, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[28] = { 16.666667039196, 9, PvPDamageMultiplier = -30, baseMultiplier = 0.684, damageEffectiveness = 0.68, levelRequirement = 86, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[29] = { 16.666667039196, 9, PvPDamageMultiplier = -30, baseMultiplier = 0.689, damageEffectiveness = 0.69, levelRequirement = 88, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[30] = { 16.666667039196, 9, PvPDamageMultiplier = -30, baseMultiplier = 0.694, damageEffectiveness = 0.69, levelRequirement = 90, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[31] = { 16.666667039196, 9, PvPDamageMultiplier = -30, baseMultiplier = 0.698, damageEffectiveness = 0.7, levelRequirement = 91, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[32] = { 16.666667039196, 10, PvPDamageMultiplier = -30, baseMultiplier = 0.703, damageEffectiveness = 0.7, levelRequirement = 92, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[33] = { 16.666667039196, 10, PvPDamageMultiplier = -30, baseMultiplier = 0.708, damageEffectiveness = 0.71, levelRequirement = 93, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[34] = { 16.666667039196, 10, PvPDamageMultiplier = -30, baseMultiplier = 0.713, damageEffectiveness = 0.71, levelRequirement = 94, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[35] = { 16.666667039196, 11, PvPDamageMultiplier = -30, baseMultiplier = 0.718, damageEffectiveness = 0.72, levelRequirement = 95, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[36] = { 16.666667039196, 11, PvPDamageMultiplier = -30, baseMultiplier = 0.723, damageEffectiveness = 0.72, levelRequirement = 96, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[37] = { 16.666667039196, 11, PvPDamageMultiplier = -30, baseMultiplier = 0.728, damageEffectiveness = 0.73, levelRequirement = 97, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[38] = { 16.666667039196, 12, PvPDamageMultiplier = -30, baseMultiplier = 0.733, damageEffectiveness = 0.73, levelRequirement = 98, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[39] = { 16.666667039196, 12, PvPDamageMultiplier = -30, baseMultiplier = 0.738, damageEffectiveness = 0.74, levelRequirement = 99, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[40] = { 16.666667039196, 12, PvPDamageMultiplier = -30, baseMultiplier = 0.743, damageEffectiveness = 0.74, levelRequirement = 100, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
	},
}
skills["CausticArrowAltX"] = {
	name = "Caustic Arrow of Poison",
	baseTypeName = "Caustic Arrow of Poison",
	color = 2,
	description = "Fires a poisonous arrow which deals chaos damage in an area on impact.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["caustic_arrow_explode_on_hit_base_area_of_effect_radius"] = {
			skill("radius", nil),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "AoE Explosion:"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "caustic_arrow_explode_on_hit_base_area_of_effect_radius", 12 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"active_skill_base_radius_+",
		"skill_can_fire_arrows",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, PvPDamageMultiplier = -30, baseMultiplier = 0.715, damageEffectiveness = 0.715, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 0, PvPDamageMultiplier = -30, baseMultiplier = 0.725, damageEffectiveness = 0.725, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 1, PvPDamageMultiplier = -30, baseMultiplier = 0.736, damageEffectiveness = 0.736, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[4] = { 1, PvPDamageMultiplier = -30, baseMultiplier = 0.746, damageEffectiveness = 0.746, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[5] = { 1, PvPDamageMultiplier = -30, baseMultiplier = 0.757, damageEffectiveness = 0.757, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[6] = { 2, PvPDamageMultiplier = -30, baseMultiplier = 0.766, damageEffectiveness = 0.766, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[7] = { 2, PvPDamageMultiplier = -30, baseMultiplier = 0.776, damageEffectiveness = 0.776, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[8] = { 2, PvPDamageMultiplier = -30, baseMultiplier = 0.786, damageEffectiveness = 0.786, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[9] = { 3, PvPDamageMultiplier = -30, baseMultiplier = 0.797, damageEffectiveness = 0.797, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[10] = { 3, PvPDamageMultiplier = -30, baseMultiplier = 0.807, damageEffectiveness = 0.807, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 3, PvPDamageMultiplier = -30, baseMultiplier = 0.818, damageEffectiveness = 0.818, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[12] = { 3, PvPDamageMultiplier = -30, baseMultiplier = 0.828, damageEffectiveness = 0.828, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[13] = { 4, PvPDamageMultiplier = -30, baseMultiplier = 0.838, damageEffectiveness = 0.838, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[14] = { 4, PvPDamageMultiplier = -30, baseMultiplier = 0.849, damageEffectiveness = 0.849, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 4, PvPDamageMultiplier = -30, baseMultiplier = 0.859, damageEffectiveness = 0.859, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 5, PvPDamageMultiplier = -30, baseMultiplier = 0.868, damageEffectiveness = 0.868, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[17] = { 5, PvPDamageMultiplier = -30, baseMultiplier = 0.879, damageEffectiveness = 0.879, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[18] = { 5, PvPDamageMultiplier = -30, baseMultiplier = 0.889, damageEffectiveness = 0.889, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 6, PvPDamageMultiplier = -30, baseMultiplier = 0.9, damageEffectiveness = 0.9, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 6, PvPDamageMultiplier = -30, baseMultiplier = 0.91, damageEffectiveness = 0.91, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 6, PvPDamageMultiplier = -30, baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 7, PvPDamageMultiplier = -30, baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 7, PvPDamageMultiplier = -30, baseMultiplier = 0.941, damageEffectiveness = 0.941, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 7, PvPDamageMultiplier = -30, baseMultiplier = 0.952, damageEffectiveness = 0.952, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 8, PvPDamageMultiplier = -30, baseMultiplier = 0.961, damageEffectiveness = 0.961, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 8, PvPDamageMultiplier = -30, baseMultiplier = 0.971, damageEffectiveness = 0.971, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 8, PvPDamageMultiplier = -30, baseMultiplier = 0.981, damageEffectiveness = 0.981, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 9, PvPDamageMultiplier = -30, baseMultiplier = 0.992, damageEffectiveness = 0.992, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 9, PvPDamageMultiplier = -30, baseMultiplier = 1.002, damageEffectiveness = 1.002, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 9, PvPDamageMultiplier = -30, baseMultiplier = 1.013, damageEffectiveness = 1.013, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 9, PvPDamageMultiplier = -30, baseMultiplier = 1.018, damageEffectiveness = 1.018, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 10, PvPDamageMultiplier = -30, baseMultiplier = 1.023, damageEffectiveness = 1.023, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 10, PvPDamageMultiplier = -30, baseMultiplier = 1.028, damageEffectiveness = 1.028, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 10, PvPDamageMultiplier = -30, baseMultiplier = 1.034, damageEffectiveness = 1.034, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 11, PvPDamageMultiplier = -30, baseMultiplier = 1.039, damageEffectiveness = 1.039, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 11, PvPDamageMultiplier = -30, baseMultiplier = 1.044, damageEffectiveness = 1.044, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 11, PvPDamageMultiplier = -30, baseMultiplier = 1.049, damageEffectiveness = 1.049, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 12, PvPDamageMultiplier = -30, baseMultiplier = 1.054, damageEffectiveness = 1.054, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 12, PvPDamageMultiplier = -30, baseMultiplier = 1.058, damageEffectiveness = 1.058, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 12, PvPDamageMultiplier = -30, baseMultiplier = 1.063, damageEffectiveness = 1.063, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["VaalCausticArrow"] = {
	name = "Vaal Caustic Arrow",
	baseTypeName = "Vaal Caustic Arrow",
	color = 2,
	baseEffectiveness = 19.590000152588,
	incrementalEffectiveness = 0.050299998372793,
	description = "Fires a slow-moving serpentine arrow which deals chaos damage while piercing enemies, and leaves a trail of caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Vaal] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 12),
		skill("radiusSecondary", 20),
		skill("radiusLabel", "AoE Explosion:"),
		skill("radiusSecondaryLabel", "Caustic Ground:"),
		skill("dotIsArea", true),
		flag("dotIsCausticGround"),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "vaal_caustic_arrow_ground_art_variation", 14 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"skill_can_fire_arrows",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"always_pierce",
		"global_always_hit",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 2.8, damageEffectiveness = 2.8, levelRequirement = 1, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[2] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 2.863, damageEffectiveness = 2.86, levelRequirement = 2, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[3] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 2.926, damageEffectiveness = 2.93, levelRequirement = 4, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[4] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 2.989, damageEffectiveness = 2.99, levelRequirement = 7, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[5] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.053, damageEffectiveness = 3.05, levelRequirement = 11, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[6] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.116, damageEffectiveness = 3.12, levelRequirement = 16, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[7] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.179, damageEffectiveness = 3.18, levelRequirement = 20, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[8] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.242, damageEffectiveness = 3.24, levelRequirement = 24, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[9] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.305, damageEffectiveness = 3.31, levelRequirement = 28, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[10] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.368, damageEffectiveness = 3.37, levelRequirement = 32, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[11] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.432, damageEffectiveness = 3.43, levelRequirement = 36, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[12] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.495, damageEffectiveness = 3.49, levelRequirement = 40, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[13] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.558, damageEffectiveness = 3.56, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[14] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.621, damageEffectiveness = 3.62, levelRequirement = 48, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[15] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.684, damageEffectiveness = 3.68, levelRequirement = 52, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[16] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.747, damageEffectiveness = 3.75, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[17] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.811, damageEffectiveness = 3.81, levelRequirement = 60, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[18] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.874, damageEffectiveness = 3.87, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[19] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 3.937, damageEffectiveness = 3.94, levelRequirement = 67, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[20] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4, damageEffectiveness = 4, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[21] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.063, damageEffectiveness = 4.06, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[22] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.126, damageEffectiveness = 4.13, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[23] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.189, damageEffectiveness = 4.19, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[24] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.253, damageEffectiveness = 4.25, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[25] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.316, damageEffectiveness = 4.32, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[26] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.379, damageEffectiveness = 4.38, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[27] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.442, damageEffectiveness = 4.44, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[28] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.505, damageEffectiveness = 4.51, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[29] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.568, damageEffectiveness = 4.57, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[30] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.632, damageEffectiveness = 4.63, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[31] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.663, damageEffectiveness = 4.66, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[32] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.695, damageEffectiveness = 4.69, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[33] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.726, damageEffectiveness = 4.73, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[34] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.758, damageEffectiveness = 4.76, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[35] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.789, damageEffectiveness = 4.79, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[36] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.821, damageEffectiveness = 4.82, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[37] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.853, damageEffectiveness = 4.85, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[38] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.884, damageEffectiveness = 4.88, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[39] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.916, damageEffectiveness = 4.92, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
		[40] = { 16.666667039196, attackSpeedMultiplier = -30, baseMultiplier = 4.947, damageEffectiveness = 4.95, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 3, }, cost = { Soul = 20, }, },
	},
}
skills["CallOfSteel"] = {
	name = "Call of Steel",
	hidden = true,
	color = 1,
	description = "Calls impale debuffs from enemies, alive or dead, in a large area around you to gain steel shards. Deals reflected damage in a smaller area around each such enemy based on the impales removed from them. Continues to grant shards over time until you reach maximum or spend them.",
	skillTypes = { [SkillType.Cooldown] = true, [SkillType.Area] = true, [SkillType.Steel] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	cannotBeSupported = true,
	baseFlags = {
		area = true,
	},
	constantStats = {
		{ "call_of_steel_reload_amount", 4 },
		{ "call_of_steel_reload_time", 500 },
	},
	stats = {
		"skill_is_steel_skill_reload",
	},
	levels = {
		[1] = { baseMultiplier = 1.3, damageEffectiveness = 1.3, levelRequirement = 1, },
	},
}
skills["ChargedDash"] = {
	name = "Charged Dash",
	baseTypeName = "Charged Dash",
	color = 2,
	description = "Channel to project an illusion which you steer. You gain stages while it moves, until it stops at a maximum total distance. Waves of area damage frequently pulse along its path, based on your attack speed. Stop channelling to teleport to the illusion, dealing a final wave of damage. Requires a Melee Weapon.",
	skillTypes = { [SkillType.Movement] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Channel] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Lightning] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Channelling, No Stages",
		},
		{
			name = "Channelling, Max Stages",
		},
		{
			name = "Release",
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		   if activeSkill.skillPart == 3 then
			   local finalWaveDamageModifier = activeSkill.skillModList:Sum("INC", activeSkill.skillCfg, "chargedDashFinalDamageModifier")
			   activeSkill.skillModList:NewMod("Damage", "MORE", finalWaveDamageModifier, "Skill:ChargedDash", ModFlag.Attack, { type = "Release Damage", skillPart = 3 })
		   end
	end,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["charged_dash_damage_+%_final"] = {
			mod("chargedDashFinalDamageModifier", "INC", nil, 0, 0, { type = "SkillPart", skillPart = 3 }),
		},
		["charged_dash_damage_+%_final_per_stack"] = {
			mod("chargedDashFinalDamageModifier", "INC", nil, 0, 0, { type = "Multiplier", var = "ChargedDashStage" }, { type = "SkillPart", skillPart = 3 }),
		},
		["charged_dash_channelling_damage_at_full_stacks_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 14),
		skill("radiusLabel", "Start of Dash:"),
		skill("radiusSecondary", 26),
		skill("radiusSecondaryLabel", "End of Dash:"),
		skill("hitTimeMultiplier", 2, { type = "Skill", skillPartList = { 1, 2 } }),
		mod("Multiplier:ChargedDashMaxStages", "BASE", 15),
		skill("showAverage", true, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		Default = {
			{ "charged_dash_skill_inherent_movement_speed_+%_final", 1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "charged_dash_damage_+%_final", -100 },
		{ "charged_dash_damage_+%_final_per_stack", 75 },
		{ "charged_dash_channelling_damage_at_full_stacks_+%_final", 150 },
		{ "charged_dash_skill_inherent_movement_speed_+%_final", 30 },
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_chaged_dash_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 60, baseMultiplier = 1.437, damageEffectiveness = 1.437, levelRequirement = 28, cost = { Mana = 5, }, },
		[2] = { attackSpeedMultiplier = 60, baseMultiplier = 1.487, damageEffectiveness = 1.487, levelRequirement = 31, cost = { Mana = 5, }, },
		[3] = { attackSpeedMultiplier = 60, baseMultiplier = 1.537, damageEffectiveness = 1.537, levelRequirement = 34, cost = { Mana = 5, }, },
		[4] = { attackSpeedMultiplier = 60, baseMultiplier = 1.59, damageEffectiveness = 1.59, levelRequirement = 37, cost = { Mana = 5, }, },
		[5] = { attackSpeedMultiplier = 60, baseMultiplier = 1.644, damageEffectiveness = 1.644, levelRequirement = 40, cost = { Mana = 5, }, },
		[6] = { attackSpeedMultiplier = 60, baseMultiplier = 1.697, damageEffectiveness = 1.697, levelRequirement = 42, cost = { Mana = 5, }, },
		[7] = { attackSpeedMultiplier = 60, baseMultiplier = 1.751, damageEffectiveness = 1.751, levelRequirement = 44, cost = { Mana = 5, }, },
		[8] = { attackSpeedMultiplier = 60, baseMultiplier = 1.808, damageEffectiveness = 1.808, levelRequirement = 46, cost = { Mana = 5, }, },
		[9] = { attackSpeedMultiplier = 60, baseMultiplier = 1.866, damageEffectiveness = 1.866, levelRequirement = 48, cost = { Mana = 5, }, },
		[10] = { attackSpeedMultiplier = 60, baseMultiplier = 1.926, damageEffectiveness = 1.926, levelRequirement = 50, cost = { Mana = 5, }, },
		[11] = { attackSpeedMultiplier = 60, baseMultiplier = 1.988, damageEffectiveness = 1.988, levelRequirement = 52, cost = { Mana = 6, }, },
		[12] = { attackSpeedMultiplier = 60, baseMultiplier = 2.052, damageEffectiveness = 2.052, levelRequirement = 54, cost = { Mana = 6, }, },
		[13] = { attackSpeedMultiplier = 60, baseMultiplier = 2.118, damageEffectiveness = 2.118, levelRequirement = 56, cost = { Mana = 6, }, },
		[14] = { attackSpeedMultiplier = 60, baseMultiplier = 2.185, damageEffectiveness = 2.185, levelRequirement = 58, cost = { Mana = 6, }, },
		[15] = { attackSpeedMultiplier = 60, baseMultiplier = 2.256, damageEffectiveness = 2.256, levelRequirement = 60, cost = { Mana = 6, }, },
		[16] = { attackSpeedMultiplier = 60, baseMultiplier = 2.328, damageEffectiveness = 2.328, levelRequirement = 62, cost = { Mana = 6, }, },
		[17] = { attackSpeedMultiplier = 60, baseMultiplier = 2.403, damageEffectiveness = 2.403, levelRequirement = 64, cost = { Mana = 6, }, },
		[18] = { attackSpeedMultiplier = 60, baseMultiplier = 2.48, damageEffectiveness = 2.48, levelRequirement = 66, cost = { Mana = 6, }, },
		[19] = { attackSpeedMultiplier = 60, baseMultiplier = 2.559, damageEffectiveness = 2.559, levelRequirement = 68, cost = { Mana = 6, }, },
		[20] = { attackSpeedMultiplier = 60, baseMultiplier = 2.641, damageEffectiveness = 2.641, levelRequirement = 70, cost = { Mana = 6, }, },
		[21] = { attackSpeedMultiplier = 60, baseMultiplier = 2.725, damageEffectiveness = 2.725, levelRequirement = 72, cost = { Mana = 6, }, },
		[22] = { attackSpeedMultiplier = 60, baseMultiplier = 2.813, damageEffectiveness = 2.813, levelRequirement = 74, cost = { Mana = 6, }, },
		[23] = { attackSpeedMultiplier = 60, baseMultiplier = 2.903, damageEffectiveness = 2.903, levelRequirement = 76, cost = { Mana = 7, }, },
		[24] = { attackSpeedMultiplier = 60, baseMultiplier = 2.996, damageEffectiveness = 2.996, levelRequirement = 78, cost = { Mana = 7, }, },
		[25] = { attackSpeedMultiplier = 60, baseMultiplier = 3.092, damageEffectiveness = 3.092, levelRequirement = 80, cost = { Mana = 7, }, },
		[26] = { attackSpeedMultiplier = 60, baseMultiplier = 3.191, damageEffectiveness = 3.191, levelRequirement = 82, cost = { Mana = 7, }, },
		[27] = { attackSpeedMultiplier = 60, baseMultiplier = 3.292, damageEffectiveness = 3.292, levelRequirement = 84, cost = { Mana = 7, }, },
		[28] = { attackSpeedMultiplier = 60, baseMultiplier = 3.398, damageEffectiveness = 3.398, levelRequirement = 86, cost = { Mana = 7, }, },
		[29] = { attackSpeedMultiplier = 60, baseMultiplier = 3.506, damageEffectiveness = 3.506, levelRequirement = 88, cost = { Mana = 7, }, },
		[30] = { attackSpeedMultiplier = 60, baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 90, cost = { Mana = 7, }, },
		[31] = { attackSpeedMultiplier = 60, baseMultiplier = 3.782, damageEffectiveness = 3.782, levelRequirement = 91, cost = { Mana = 7, }, },
		[32] = { attackSpeedMultiplier = 60, baseMultiplier = 3.842, damageEffectiveness = 3.842, levelRequirement = 92, cost = { Mana = 7, }, },
		[33] = { attackSpeedMultiplier = 60, baseMultiplier = 3.903, damageEffectiveness = 3.903, levelRequirement = 93, cost = { Mana = 7, }, },
		[34] = { attackSpeedMultiplier = 60, baseMultiplier = 3.965, damageEffectiveness = 3.965, levelRequirement = 94, cost = { Mana = 7, }, },
		[35] = { attackSpeedMultiplier = 60, baseMultiplier = 4.028, damageEffectiveness = 4.028, levelRequirement = 95, cost = { Mana = 7, }, },
		[36] = { attackSpeedMultiplier = 60, baseMultiplier = 4.093, damageEffectiveness = 4.093, levelRequirement = 96, cost = { Mana = 7, }, },
		[37] = { attackSpeedMultiplier = 60, baseMultiplier = 4.157, damageEffectiveness = 4.157, levelRequirement = 97, cost = { Mana = 7, }, },
		[38] = { attackSpeedMultiplier = 60, baseMultiplier = 4.224, damageEffectiveness = 4.224, levelRequirement = 98, cost = { Mana = 7, }, },
		[39] = { attackSpeedMultiplier = 60, baseMultiplier = 4.29, damageEffectiveness = 4.29, levelRequirement = 99, cost = { Mana = 7, }, },
		[40] = { attackSpeedMultiplier = 60, baseMultiplier = 4.359, damageEffectiveness = 4.359, levelRequirement = 100, cost = { Mana = 8, }, },
	},
}
skills["CobraLash"] = {
	name = "Cobra Lash",
	baseTypeName = "Cobra Lash",
	color = 2,
	description = "Fires a poisonous projectile based on your weapon that will chain between enemies. Requires a Dagger or Claw.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Chaos] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cobra_lash_hit_and_ailment_damage_+%_final_for_each_remaining_chain"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "PerStat", stat = "ChainRemaining" }, { type = "SkillType", skillType = SkillType.Projectile })
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "number_of_chains", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "projectile_speed_variation_+%", 15 },
		{ "projectile_angle_variance", 8 },
		{ "base_chance_to_poison_on_hit_%", 40 },
		{ "cobra_lash_hit_and_ailment_damage_+%_final_for_each_remaining_chain", 8 },
	},
	stats = {
		"number_of_chains",
		"base_is_projectile",
		"console_skill_dont_chase",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.25, damageEffectiveness = 1.25, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[2] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.292, damageEffectiveness = 1.292, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[3] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.334, damageEffectiveness = 1.334, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[4] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.376, damageEffectiveness = 1.376, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[5] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.418, damageEffectiveness = 1.418, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[6] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.461, damageEffectiveness = 1.461, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 5, }, },
		[7] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.503, damageEffectiveness = 1.503, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[8] = { 3, attackSpeedMultiplier = 20, baseMultiplier = 1.545, damageEffectiveness = 1.545, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[9] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.587, damageEffectiveness = 1.587, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[10] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.629, damageEffectiveness = 1.629, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[11] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.671, damageEffectiveness = 1.671, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[12] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.713, damageEffectiveness = 1.713, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[13] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.755, damageEffectiveness = 1.755, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[14] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.797, damageEffectiveness = 1.797, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[15] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.839, damageEffectiveness = 1.839, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[16] = { 4, attackSpeedMultiplier = 20, baseMultiplier = 1.882, damageEffectiveness = 1.882, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[17] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 1.924, damageEffectiveness = 1.924, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[18] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 1.966, damageEffectiveness = 1.966, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[19] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.008, damageEffectiveness = 2.008, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[20] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.05, damageEffectiveness = 2.05, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[21] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[22] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.134, damageEffectiveness = 2.134, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[23] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.176, damageEffectiveness = 2.176, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[24] = { 5, attackSpeedMultiplier = 20, baseMultiplier = 2.218, damageEffectiveness = 2.218, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[25] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.261, damageEffectiveness = 2.261, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[26] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.303, damageEffectiveness = 2.303, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[27] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.345, damageEffectiveness = 2.345, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[28] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.387, damageEffectiveness = 2.387, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[29] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.429, damageEffectiveness = 2.429, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[30] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.471, damageEffectiveness = 2.471, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[31] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.492, damageEffectiveness = 2.492, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[32] = { 6, attackSpeedMultiplier = 20, baseMultiplier = 2.513, damageEffectiveness = 2.513, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[33] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.534, damageEffectiveness = 2.534, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[34] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.555, damageEffectiveness = 2.555, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[35] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.576, damageEffectiveness = 2.576, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[36] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.597, damageEffectiveness = 2.597, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[37] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.618, damageEffectiveness = 2.618, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[38] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.639, damageEffectiveness = 2.639, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[39] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.661, damageEffectiveness = 2.661, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[40] = { 7, attackSpeedMultiplier = 20, baseMultiplier = 2.682, damageEffectiveness = 2.682, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 10, }, },
	},
}
skills["Conflagration"] = {
	name = "Conflagration",
	baseTypeName = "Conflagration",
	color = 2,
	baseEffectiveness = 3.3840000629425,
	incrementalEffectiveness = 0.054000001400709,
	description = "Fire arrows into the air that rain down around the targeted area, dealing area damage on impact and leaving the arrows stuck in the ground for a duration. If you move close to a stuck arrow, it will explode, dealing area damage and applying a fire damage over time debuff, as well as causing other stuck arrows in range to also explode.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Fire] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "secondary_debuff_skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Projectile",
		},
		{
			name = "Explosion",
		},
	},
	statMap = {
		["napalm_arrow_detonation_hit_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "SkillPart", skillPart = 2 } )
		},
		["base_fire_damage_to_deal_per_minute"] = {
			skill("FireDot", nil, { type = "SkillPart", skillPart = 2 }),
			div = 60,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "napalm_arrow_detonation_hit_damage_+%_final", 1.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "active_skill_area_of_effect_description_mode", 7 },
		{ "active_skill_base_area_of_effect_radius", 30 },
		{ "active_skill_secondary_area_of_effect_description_mode", 7 },
		{ "active_skill_base_secondary_area_of_effect_radius", 10 },
		{ "active_skill_tertiary_area_of_effect_description_mode", 1 },
		{ "napalm_arrow_detonation_hit_damage_+%_final", 50 },
		{ "napalm_arrow_maximum_number_of_unprimed_arrows_allowed", 20 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
		{ "base_secondary_skill_effect_duration", 4000 },
		{ "blast_rain_arrow_delay_ms", 90 },
		{ "base_number_of_projectiles", 3 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"active_skill_base_tertiary_area_of_effect_radius",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"base_skill_show_average_damage_instead_of_dps",
		"quality_display_base_number_of_projectiles_is_gem",
		"projectile_damage_modifiers_apply_to_skill_dot",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 49.500001583248, 15, baseMultiplier = 0.3, damageEffectiveness = 0.3, levelRequirement = 28, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[2] = { 49.500001583248, 15, baseMultiplier = 0.303, damageEffectiveness = 0.3, levelRequirement = 31, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 49.500001583248, 16, baseMultiplier = 0.306, damageEffectiveness = 0.31, levelRequirement = 34, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[4] = { 49.500001583248, 16, baseMultiplier = 0.309, damageEffectiveness = 0.31, levelRequirement = 37, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[5] = { 49.500001583248, 16, baseMultiplier = 0.312, damageEffectiveness = 0.31, levelRequirement = 40, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[6] = { 49.500001583248, 16, baseMultiplier = 0.315, damageEffectiveness = 0.31, levelRequirement = 42, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[7] = { 49.500001583248, 17, baseMultiplier = 0.318, damageEffectiveness = 0.32, levelRequirement = 44, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[8] = { 49.500001583248, 17, baseMultiplier = 0.321, damageEffectiveness = 0.32, levelRequirement = 46, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[9] = { 49.500001583248, 17, baseMultiplier = 0.324, damageEffectiveness = 0.32, levelRequirement = 48, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[10] = { 49.500001583248, 17, baseMultiplier = 0.327, damageEffectiveness = 0.33, levelRequirement = 50, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[11] = { 49.500001583248, 18, baseMultiplier = 0.329, damageEffectiveness = 0.33, levelRequirement = 52, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[12] = { 49.500001583248, 18, baseMultiplier = 0.332, damageEffectiveness = 0.33, levelRequirement = 54, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[13] = { 49.500001583248, 18, baseMultiplier = 0.335, damageEffectiveness = 0.34, levelRequirement = 56, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[14] = { 49.500001583248, 18, baseMultiplier = 0.338, damageEffectiveness = 0.34, levelRequirement = 58, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[15] = { 49.500001583248, 19, baseMultiplier = 0.341, damageEffectiveness = 0.34, levelRequirement = 60, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[16] = { 49.500001583248, 19, baseMultiplier = 0.344, damageEffectiveness = 0.34, levelRequirement = 62, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[17] = { 49.500001583248, 19, baseMultiplier = 0.347, damageEffectiveness = 0.35, levelRequirement = 64, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[18] = { 49.500001583248, 19, baseMultiplier = 0.35, damageEffectiveness = 0.35, levelRequirement = 66, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[19] = { 49.500001583248, 20, baseMultiplier = 0.353, damageEffectiveness = 0.35, levelRequirement = 68, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[20] = { 49.500001583248, 20, baseMultiplier = 0.356, damageEffectiveness = 0.36, levelRequirement = 70, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[21] = { 49.500001583248, 20, baseMultiplier = 0.359, damageEffectiveness = 0.36, levelRequirement = 72, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[22] = { 49.500001583248, 20, baseMultiplier = 0.362, damageEffectiveness = 0.36, levelRequirement = 74, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[23] = { 49.500001583248, 21, baseMultiplier = 0.365, damageEffectiveness = 0.36, levelRequirement = 76, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[24] = { 49.500001583248, 21, baseMultiplier = 0.368, damageEffectiveness = 0.37, levelRequirement = 78, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[25] = { 49.500001583248, 21, baseMultiplier = 0.371, damageEffectiveness = 0.37, levelRequirement = 80, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[26] = { 49.500001583248, 21, baseMultiplier = 0.374, damageEffectiveness = 0.37, levelRequirement = 82, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[27] = { 49.500001583248, 22, baseMultiplier = 0.377, damageEffectiveness = 0.38, levelRequirement = 84, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[28] = { 49.500001583248, 22, baseMultiplier = 0.38, damageEffectiveness = 0.38, levelRequirement = 86, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[29] = { 49.500001583248, 22, baseMultiplier = 0.383, damageEffectiveness = 0.38, levelRequirement = 88, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[30] = { 49.500001583248, 22, baseMultiplier = 0.385, damageEffectiveness = 0.39, levelRequirement = 90, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[31] = { 49.500001583248, 23, baseMultiplier = 0.387, damageEffectiveness = 0.39, levelRequirement = 91, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[32] = { 49.500001583248, 23, baseMultiplier = 0.388, damageEffectiveness = 0.39, levelRequirement = 92, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[33] = { 49.500001583248, 23, baseMultiplier = 0.39, damageEffectiveness = 0.39, levelRequirement = 93, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[34] = { 49.500001583248, 23, baseMultiplier = 0.391, damageEffectiveness = 0.39, levelRequirement = 94, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[35] = { 49.500001583248, 24, baseMultiplier = 0.393, damageEffectiveness = 0.39, levelRequirement = 95, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[36] = { 49.500001583248, 24, baseMultiplier = 0.394, damageEffectiveness = 0.39, levelRequirement = 96, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[37] = { 49.500001583248, 24, baseMultiplier = 0.396, damageEffectiveness = 0.4, levelRequirement = 97, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[38] = { 49.500001583248, 24, baseMultiplier = 0.397, damageEffectiveness = 0.4, levelRequirement = 98, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[39] = { 49.500001583248, 25, baseMultiplier = 0.399, damageEffectiveness = 0.4, levelRequirement = 99, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[40] = { 49.500001583248, 25, baseMultiplier = 0.4, damageEffectiveness = 0.4, levelRequirement = 100, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
	},
}
skills["Cremation"] = {
	name = "Cremation",
	baseTypeName = "Cremation",
	color = 2,
	baseEffectiveness = 1.8178999423981,
	incrementalEffectiveness = 0.034499999135733,
	description = "A targeted corpse explodes, dealing area damage and turning into a volcanic geyser, which will repeatedly unleash projectiles sequentially over the surrounding area for a duration. The explosion of the corpse is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Cascadable] = true, [SkillType.Projectile] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Orb] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 1 then
			activeSkill.skillData.hitTimeOverride = activeSkill.skillData.cremationFireRate / (1 + (activeSkill.skillData.cremationFireRateIncrease or 0))
		end
	end,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
			projectile = false,
		},
	},
	statMap = {
		["cremation_base_fires_projectile_every_x_ms"] = {
			skill("cremationFireRate", nil),
			div = 1000
		},
		["cremation_fires_projectiles_faster_+%_final"] = {
			skill("cremationFireRateIncrease", nil),
			div = 100
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		}
	},
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "cremation_fires_projectiles_faster_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
		{ "corpse_erruption_base_maximum_number_of_geyers", 3 },
		{ "base_number_of_projectiles", 4 },
		{ "cremation_base_fires_projectile_every_x_ms", 1000 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
		"corpse_explosion_monster_life_permillage_fire",
		"is_area_damage",
		"show_number_of_projectiles",
		"base_skill_show_average_damage_instead_of_dps",
		"base_is_projectile",
		"projectile_behaviour_only_explode",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, 40, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 41, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 0, 41, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 34, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, 42, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 37, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 0, 42, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 43, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 42, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 1, 43, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, 44, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 46, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, 44, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 1, 45, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 45, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 46, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 54, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 46, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 47, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 2, 47, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 48, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 48, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 49, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 49, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 3, 50, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 4, 50, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 4, 51, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, 51, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 4, 52, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 4, 52, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 53, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 53, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 54, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 54, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 5, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 5, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 6, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 6, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 6, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 6, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 6, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 6, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 6, 57, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 6, 57, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 6, 57, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
	},
}
skills["CremationAltX"] = {
	name = "Cremation of Exhuming",
	baseTypeName = "Cremation of Exhuming",
	color = 2,
	baseEffectiveness = 1.8178999423981,
	incrementalEffectiveness = 0.034499999135733,
	description = "A targeted corpse explodes, dealing area damage and turning into a volcanic geyser, which will repeatedly unleash projectiles sequentially over the surrounding area and detonate nearby corpses for a duration. Corpse explosions are not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Cascadable] = true, [SkillType.Projectile] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Orb] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 1 then
			activeSkill.skillData.hitTimeOverride = activeSkill.skillData.cremationFireRate / (1 + (activeSkill.skillData.cremationFireRateIncrease or 0))
		end
	end,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
			projectile = false,
		},
	},
	statMap = {
		["cremation_base_fires_projectile_every_x_ms"] = {
			skill("cremationFireRate", nil),
			div = 1000
		},
		["cremation_fires_projectiles_faster_+%_final"] = {
			skill("cremationFireRateIncrease", nil),
			div = 100
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		}
	},
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "cremation_fires_projectiles_faster_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
		{ "corpse_erruption_base_maximum_number_of_geyers", 1 },
		{ "base_number_of_projectiles", 4 },
		{ "cremation_base_fires_projectile_every_x_ms", 1000 },
		{ "cremation_chance_to_explode_nearby_corpse_when_firing_projectiles", 100 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
		"corpse_explosion_monster_life_permillage_fire",
		"is_area_damage",
		"show_number_of_projectiles",
		"base_skill_show_average_damage_instead_of_dps",
		"base_is_projectile",
		"projectile_behaviour_only_explode",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, 50, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 51, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 0, 51, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 34, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, 52, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 37, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 0, 52, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 53, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 42, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 1, 53, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, 54, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 46, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, 54, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 1, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 55, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 54, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 56, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 57, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 2, 57, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 58, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 58, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 59, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 59, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 3, 60, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 4, 60, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 4, 61, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, 61, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 28, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 4, 62, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 4, 62, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 63, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 63, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 64, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 31, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 64, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 5, 65, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 5, 65, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 6, 65, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 6, 65, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 6, 66, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 6, 66, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 6, 66, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 6, 66, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 6, 67, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 6, 67, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 6, 67, PvPDamageMultiplier = -40, critChance = 5, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
	},
}
skills["CremationAltY"] = {
	name = "Cremation of the Volcano",
	baseTypeName = "Cremation of the Volcano",
	color = 2,
	baseEffectiveness = 1.2669999599457,
	incrementalEffectiveness = 0.034499999135733,
	description = "Creates a volcanic geyser at a location, which will repeatedly unleash projectiles sequentially over the surrounding area for a duration.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Cascadable] = true, [SkillType.Projectile] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Orb] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = activeSkill.skillData.cremationFireRate / (1 + (activeSkill.skillData.cremationFireRateIncrease or 0))
	end,
	statMap = {
		["cremation_base_fires_projectile_every_x_ms"] = {
			skill("cremationFireRate", nil),
			div = 1000
		},
		["cremation_fires_projectiles_faster_+%_final"] = {
			skill("cremationFireRateIncrease", nil),
			div = 100
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		}
	},
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		Default = {
			{ "cremation_fires_projectiles_faster_+%_final", 0.5 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 2500 },
		{ "corpse_erruption_base_maximum_number_of_geyers", 6 },
		{ "base_number_of_projectiles", 4 },
		{ "cremation_base_fires_projectile_every_x_ms", 1000 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"show_number_of_projectiles",
		"base_skill_show_average_damage_instead_of_dps",
		"base_is_projectile",
		"projectile_behaviour_only_explode",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[2] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[3] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[4] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[5] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[6] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[7] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[8] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[9] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[10] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[11] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[12] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[13] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[14] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[15] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[16] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[17] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[21] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[22] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[23] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[24] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[25] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[26] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[29] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[30] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[31] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[32] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[33] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[34] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[35] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[36] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[37] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[38] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[39] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 35, }, },
		[40] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -40, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 35, }, },
	},
}
skills["Cyclone"] = {
	name = "Cyclone",
	baseTypeName = "Cyclone",
	color = 2,
	description = "Channel this skill to move towards a targeted location while spinning constantly attacking enemies in an area around you. While channelling this skill, you cannot be knocked back.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Channel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	initialFunc = function(activeSkill, output)
		local range = 0
		if activeSkill.skillFlags.weapon1Attack and activeSkill.actor.weaponData1.range then
			local weapon1RangeBonus = activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData1.rangeBonus
			if activeSkill.skillFlags.weapon2Attack and activeSkill.actor.weaponData2.range then -- dual wield average
				range = (weapon1RangeBonus + activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData2.rangeBonus) / 2
			else -- primary hand attack
				range = weapon1RangeBonus
			end
		else -- unarmed
			range = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRangeMetre")
		end
		activeSkill.skillModList:NewMod("Multiplier:AdditionalMeleeRange", "BASE", range, "Skill:Cyclone")
	end,
	statMap = {
		["cyclone_area_of_effect_+%_per_additional_melee_range"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "Multiplier", var = "AdditionalMeleeRange"}),
		},
		["cyclone_movement_speed_+%_final"] = {
			mod("MovementSpeed", "MORE", nil, 0, 0, { type = "Condition", var = "ChannellingCyclone"}, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 16),
	},
	qualityStats = {
		Default = {
			{ "cyclone_area_of_effect_+%_per_additional_melee_range", 0.25 },
		},
	},
	constantStats = {
		{ "cyclone_area_of_effect_+%_per_additional_melee_range", 15 },
	},
	stats = {
		"cyclone_movement_speed_+%_final",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { -30, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.816, damageEffectiveness = 0.816, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 2, }, },
		[2] = { -29, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.852, damageEffectiveness = 0.852, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[3] = { -29, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.888, damageEffectiveness = 0.888, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[4] = { -28, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.924, damageEffectiveness = 0.924, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[5] = { -28, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.96, damageEffectiveness = 0.96, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[6] = { -27, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 0.996, damageEffectiveness = 0.996, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[7] = { -27, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.032, damageEffectiveness = 1.032, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[8] = { -26, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.068, damageEffectiveness = 1.068, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[9] = { -26, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.104, damageEffectiveness = 1.104, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[10] = { -25, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.14, damageEffectiveness = 1.14, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[11] = { -25, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.176, damageEffectiveness = 1.176, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[12] = { -24, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.212, damageEffectiveness = 1.212, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[13] = { -24, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.248, damageEffectiveness = 1.248, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[14] = { -23, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.284, damageEffectiveness = 1.284, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[15] = { -23, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.32, damageEffectiveness = 1.32, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[16] = { -22, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.356, damageEffectiveness = 1.356, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[17] = { -22, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.392, damageEffectiveness = 1.392, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[18] = { -21, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.428, damageEffectiveness = 1.428, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[19] = { -21, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.464, damageEffectiveness = 1.464, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[20] = { -20, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[21] = { -20, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.536, damageEffectiveness = 1.536, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[22] = { -19, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.572, damageEffectiveness = 1.572, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[23] = { -19, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.608, damageEffectiveness = 1.608, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 3, }, },
		[24] = { -18, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.644, damageEffectiveness = 1.644, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[25] = { -18, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.68, damageEffectiveness = 1.68, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[26] = { -17, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[27] = { -17, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.752, damageEffectiveness = 1.752, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[28] = { -16, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[29] = { -16, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.824, damageEffectiveness = 1.824, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[30] = { -15, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.86, damageEffectiveness = 1.86, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[31] = { -15, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.878, damageEffectiveness = 1.878, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[32] = { -14, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.896, damageEffectiveness = 1.896, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[33] = { -14, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.914, damageEffectiveness = 1.914, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[34] = { -13, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.932, damageEffectiveness = 1.932, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[35] = { -13, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.95, damageEffectiveness = 1.95, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[36] = { -12, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[37] = { -12, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 1.986, damageEffectiveness = 1.986, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[38] = { -11, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 2.004, damageEffectiveness = 2.004, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[39] = { -11, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 2.022, damageEffectiveness = 2.022, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 4, }, },
		[40] = { -10, PvPDamageMultiplier = -30, attackSpeedMultiplier = 200, baseMultiplier = 2.04, damageEffectiveness = 2.04, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 4, }, },
	},
}
skills["CycloneAltX"] = {
	name = "Cyclone of Tumult",
	baseTypeName = "Cyclone of Tumult",
	color = 2,
	description = "Channel this skill to move towards a targeted location while spinning constantly attacking enemies in an area around you. While channelling this skill, you cannot be knocked back.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Channel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	initialFunc = function(activeSkill, output)
		local range = 0
		if activeSkill.skillFlags.weapon1Attack and activeSkill.actor.weaponData1.range then
			local weapon1RangeBonus = activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData1.rangeBonus
			if activeSkill.skillFlags.weapon2Attack and activeSkill.actor.weaponData2.range then -- dual wield average
				range = (weapon1RangeBonus + activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData2.rangeBonus) / 2
			else -- primary hand attack
				range = weapon1RangeBonus
			end
		else -- unarmed
			range = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRangeMetre")
		end
		activeSkill.skillModList:NewMod("Multiplier:AdditionalMeleeRange", "BASE", range, "Skill:CycloneAltX")
	end,
	statMap = {
		["cyclone_max_number_of_stages"] = {
			mod("Multiplier:CycloneofTumultMaxStages", "BASE", nil),
		},
		["cyclone_area_of_effect_+%_per_additional_melee_range"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "Multiplier", var = "AdditionalMeleeRange"}),
		},
		--["cyclone_movement_speed_+%_final_per_stage"] = {
			--mod("MovementSpeed", "MORE", nil, 0, 0, { type = "Multiplier", var = "CycloneofTumultStage" }, { type = "Condition", var = "ChannellingCyclone" }, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		--},
		["cyclone_attack_speed_+%_final_per_stage"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "CycloneofTumultStage" }),
		},
		["cyclone_melee_weapon_range_+_per_stage"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "CycloneofTumultStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 11),
	},
	qualityStats = {
		Default = {
			{ "cyclone_attack_speed_+%_final_per_stage", 0.25 },
		},
	},
	constantStats = {
		{ "cyclone_area_of_effect_+%_per_additional_melee_range", 15 },
		{ "cyclone_stage_decay_time_ms", 400 },
		{ "cyclone_melee_weapon_range_+_per_stage", 1 },
		{ "cyclone_movement_speed_+%_final_per_stage", -10 },
		{ "cyclone_attack_speed_+%_final_per_stage", 25 },
	},
	stats = {
		"cyclone_gain_stage_every_x_ms_while_channelling",
		"cyclone_max_number_of_stages",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.816, damageEffectiveness = 0.816, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[2] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.852, damageEffectiveness = 0.852, levelRequirement = 31, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[3] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.888, damageEffectiveness = 0.888, levelRequirement = 34, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[4] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.924, damageEffectiveness = 0.924, levelRequirement = 37, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[5] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.96, damageEffectiveness = 0.96, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[6] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 0.996, damageEffectiveness = 0.996, levelRequirement = 42, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[7] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.032, damageEffectiveness = 1.032, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[8] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.068, damageEffectiveness = 1.068, levelRequirement = 46, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[9] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.104, damageEffectiveness = 1.104, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[10] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.14, damageEffectiveness = 1.14, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[11] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.176, damageEffectiveness = 1.176, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[12] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.212, damageEffectiveness = 1.212, levelRequirement = 54, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[13] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.248, damageEffectiveness = 1.248, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[14] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.284, damageEffectiveness = 1.284, levelRequirement = 58, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[15] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.32, damageEffectiveness = 1.32, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[16] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.356, damageEffectiveness = 1.356, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[17] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.392, damageEffectiveness = 1.392, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[18] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.428, damageEffectiveness = 1.428, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[19] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.464, damageEffectiveness = 1.464, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[20] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[21] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.536, damageEffectiveness = 1.536, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[22] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.572, damageEffectiveness = 1.572, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[23] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.608, damageEffectiveness = 1.608, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[24] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.644, damageEffectiveness = 1.644, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[25] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.68, damageEffectiveness = 1.68, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[26] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[27] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.752, damageEffectiveness = 1.752, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[28] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[29] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.824, damageEffectiveness = 1.824, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[30] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.86, damageEffectiveness = 1.86, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[31] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.878, damageEffectiveness = 1.878, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[32] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.896, damageEffectiveness = 1.896, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[33] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.914, damageEffectiveness = 1.914, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[34] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.932, damageEffectiveness = 1.932, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[35] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.95, damageEffectiveness = 1.95, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[36] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[37] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 1.986, damageEffectiveness = 1.986, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[38] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 2.004, damageEffectiveness = 2.004, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[39] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 2.022, damageEffectiveness = 2.022, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[40] = { 400, 5, PvPDamageMultiplier = -30, attackSpeedMultiplier = 80, baseMultiplier = 2.04, damageEffectiveness = 2.04, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
	},
}
skills["VaalCyclone"] = {
	name = "Vaal Cyclone",
	baseTypeName = "Vaal Cyclone",
	color = 2,
	description = "Spin and attack in place, damaging nearby enemies and pulling others towards you. While using this skill, you cannot be stunned or knocked back. Cannot be supported by Ruthless.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cyclone_area_of_effect_+%_per_additional_melee_range"] = {
			mod("AreaOfEffect", "INC", nil, 0, 0, { type = "Multiplier", var = "AdditionalMeleeRange"}),
		},
	},
	initialFunc = function(activeSkill, output)
		local range = 0
		if activeSkill.skillFlags.weapon1Attack and activeSkill.actor.weaponData1.range then
			local weapon1RangeBonus = activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon1Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData1.rangeBonus
			if activeSkill.skillFlags.weapon2Attack and activeSkill.actor.weaponData2.range then -- dual wield average
				range = (weapon1RangeBonus + activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.weapon2Cfg, "MeleeWeaponRangeMetre") + activeSkill.actor.weaponData2.rangeBonus) / 2
			else -- primary hand attack
				range = weapon1RangeBonus
			end
		else -- unarmed
			range = activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRange") + 10 * activeSkill.skillModList:Sum("BASE", activeSkill.skillCfg, "UnarmedRangeMetre")
		end
		activeSkill.skillModList:NewMod("Multiplier:AdditionalMeleeRange", "BASE", range, "Skill:Cyclone")
	end,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		Default = {
			{ "cyclone_area_of_effect_+%_per_additional_melee_range", 0.25 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "cyclone_area_of_effect_+%_per_additional_melee_range", 15 },
	},
	stats = {
		"is_area_damage",
		"global_always_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_can_add_multiple_charges_per_action",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 200, baseMultiplier = 1.296, damageEffectiveness = 1.296, levelRequirement = 28, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[2] = { attackSpeedMultiplier = 200, baseMultiplier = 1.344, damageEffectiveness = 1.344, levelRequirement = 31, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[3] = { attackSpeedMultiplier = 200, baseMultiplier = 1.392, damageEffectiveness = 1.392, levelRequirement = 34, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[4] = { attackSpeedMultiplier = 200, baseMultiplier = 1.44, damageEffectiveness = 1.44, levelRequirement = 37, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[5] = { attackSpeedMultiplier = 200, baseMultiplier = 1.488, damageEffectiveness = 1.488, levelRequirement = 40, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[6] = { attackSpeedMultiplier = 200, baseMultiplier = 1.536, damageEffectiveness = 1.536, levelRequirement = 42, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[7] = { attackSpeedMultiplier = 200, baseMultiplier = 1.584, damageEffectiveness = 1.584, levelRequirement = 44, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[8] = { attackSpeedMultiplier = 200, baseMultiplier = 1.632, damageEffectiveness = 1.632, levelRequirement = 46, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[9] = { attackSpeedMultiplier = 200, baseMultiplier = 1.68, damageEffectiveness = 1.68, levelRequirement = 48, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[10] = { attackSpeedMultiplier = 200, baseMultiplier = 1.728, damageEffectiveness = 1.728, levelRequirement = 50, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[11] = { attackSpeedMultiplier = 200, baseMultiplier = 1.776, damageEffectiveness = 1.776, levelRequirement = 52, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[12] = { attackSpeedMultiplier = 200, baseMultiplier = 1.824, damageEffectiveness = 1.824, levelRequirement = 54, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[13] = { attackSpeedMultiplier = 200, baseMultiplier = 1.872, damageEffectiveness = 1.872, levelRequirement = 56, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[14] = { attackSpeedMultiplier = 200, baseMultiplier = 1.92, damageEffectiveness = 1.92, levelRequirement = 58, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[15] = { attackSpeedMultiplier = 200, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 60, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[16] = { attackSpeedMultiplier = 200, baseMultiplier = 2.016, damageEffectiveness = 2.016, levelRequirement = 62, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[17] = { attackSpeedMultiplier = 200, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 64, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[18] = { attackSpeedMultiplier = 200, baseMultiplier = 2.112, damageEffectiveness = 2.112, levelRequirement = 66, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[19] = { attackSpeedMultiplier = 200, baseMultiplier = 2.16, damageEffectiveness = 2.16, levelRequirement = 68, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[20] = { attackSpeedMultiplier = 200, baseMultiplier = 2.208, damageEffectiveness = 2.208, levelRequirement = 70, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[21] = { attackSpeedMultiplier = 200, baseMultiplier = 2.256, damageEffectiveness = 2.256, levelRequirement = 72, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[22] = { attackSpeedMultiplier = 200, baseMultiplier = 2.304, damageEffectiveness = 2.304, levelRequirement = 74, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[23] = { attackSpeedMultiplier = 200, baseMultiplier = 2.352, damageEffectiveness = 2.352, levelRequirement = 76, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[24] = { attackSpeedMultiplier = 200, baseMultiplier = 2.4, damageEffectiveness = 2.4, levelRequirement = 78, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[25] = { attackSpeedMultiplier = 200, baseMultiplier = 2.448, damageEffectiveness = 2.448, levelRequirement = 80, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[26] = { attackSpeedMultiplier = 200, baseMultiplier = 2.496, damageEffectiveness = 2.496, levelRequirement = 82, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[27] = { attackSpeedMultiplier = 200, baseMultiplier = 2.544, damageEffectiveness = 2.544, levelRequirement = 84, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[28] = { attackSpeedMultiplier = 200, baseMultiplier = 2.592, damageEffectiveness = 2.592, levelRequirement = 86, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[29] = { attackSpeedMultiplier = 200, baseMultiplier = 2.64, damageEffectiveness = 2.64, levelRequirement = 88, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[30] = { attackSpeedMultiplier = 200, baseMultiplier = 2.688, damageEffectiveness = 2.688, levelRequirement = 90, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[31] = { attackSpeedMultiplier = 200, baseMultiplier = 2.712, damageEffectiveness = 2.712, levelRequirement = 91, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[32] = { attackSpeedMultiplier = 200, baseMultiplier = 2.736, damageEffectiveness = 2.736, levelRequirement = 92, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[33] = { attackSpeedMultiplier = 200, baseMultiplier = 2.76, damageEffectiveness = 2.76, levelRequirement = 93, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[34] = { attackSpeedMultiplier = 200, baseMultiplier = 2.784, damageEffectiveness = 2.784, levelRequirement = 94, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[35] = { attackSpeedMultiplier = 200, baseMultiplier = 2.808, damageEffectiveness = 2.808, levelRequirement = 95, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[36] = { attackSpeedMultiplier = 200, baseMultiplier = 2.832, damageEffectiveness = 2.832, levelRequirement = 96, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[37] = { attackSpeedMultiplier = 200, baseMultiplier = 2.856, damageEffectiveness = 2.856, levelRequirement = 97, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[38] = { attackSpeedMultiplier = 200, baseMultiplier = 2.88, damageEffectiveness = 2.88, levelRequirement = 98, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[39] = { attackSpeedMultiplier = 200, baseMultiplier = 2.904, damageEffectiveness = 2.904, levelRequirement = 99, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
		[40] = { attackSpeedMultiplier = 200, baseMultiplier = 2.928, damageEffectiveness = 2.928, levelRequirement = 100, soulPreventionDuration = 5, vaalStoredUses = 1, cost = { Soul = 25, }, },
	},
}
skills["Dash"] = {
	name = "Dash",
	baseTypeName = "Dash",
	color = 2,
	description = "Performs a series of quick teleports towards a targeted location. If using the \"Attack in Place\" option, the direction is reversed. Shares a cooldown with other Blink skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Blink] = true, [SkillType.Cooldown] = true, [SkillType.FixedCastTime] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.15,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 0.5 },
		},
	},
	stats = {
		"base_cooldown_speed_+%",
		"skill_travel_distance_+%",
		"base_deal_no_damage",
		"skill_cannot_be_interrupted",
		"skill_cannot_be_knocked_back",
		"skill_cannot_be_stunned",
		"spell_cast_time_cannot_be_modified",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
	},
	levels = {
		[1] = { 0, 0, cooldown = 2.5, levelRequirement = 4, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 4, }, },
		[2] = { 1, 3, cooldown = 2.5, levelRequirement = 6, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[3] = { 2, 6, cooldown = 2.5, levelRequirement = 9, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[4] = { 3, 9, cooldown = 2.5, levelRequirement = 12, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 4, 12, cooldown = 2.5, levelRequirement = 16, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[6] = { 5, 15, cooldown = 2.5, levelRequirement = 20, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 6, 18, cooldown = 2.5, levelRequirement = 24, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 7, 21, cooldown = 2.5, levelRequirement = 28, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[9] = { 8, 24, cooldown = 2.5, levelRequirement = 32, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[10] = { 9, 27, cooldown = 2.5, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[11] = { 10, 30, cooldown = 2.5, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[12] = { 11, 33, cooldown = 2.5, levelRequirement = 44, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[13] = { 12, 36, cooldown = 2.5, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[14] = { 13, 39, cooldown = 2.5, levelRequirement = 52, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[15] = { 14, 42, cooldown = 2.5, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[16] = { 15, 45, cooldown = 2.5, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[17] = { 16, 48, cooldown = 2.5, levelRequirement = 61, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[18] = { 17, 51, cooldown = 2.5, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[19] = { 18, 54, cooldown = 2.5, levelRequirement = 67, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[20] = { 19, 57, cooldown = 2.5, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[21] = { 20, 60, cooldown = 2.5, levelRequirement = 72, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[22] = { 21, 63, cooldown = 2.5, levelRequirement = 74, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[23] = { 22, 66, cooldown = 2.5, levelRequirement = 76, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[24] = { 23, 69, cooldown = 2.5, levelRequirement = 78, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[25] = { 24, 72, cooldown = 2.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[26] = { 25, 75, cooldown = 2.5, levelRequirement = 82, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[27] = { 26, 78, cooldown = 2.5, levelRequirement = 84, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[28] = { 27, 81, cooldown = 2.5, levelRequirement = 86, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[29] = { 28, 84, cooldown = 2.5, levelRequirement = 88, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[30] = { 29, 87, cooldown = 2.5, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[31] = { 29, 88, cooldown = 2.5, levelRequirement = 91, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[32] = { 30, 90, cooldown = 2.5, levelRequirement = 92, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[33] = { 30, 91, cooldown = 2.5, levelRequirement = 93, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[34] = { 31, 93, cooldown = 2.5, levelRequirement = 94, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[35] = { 31, 94, cooldown = 2.5, levelRequirement = 95, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[36] = { 32, 96, cooldown = 2.5, levelRequirement = 96, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[37] = { 32, 97, cooldown = 2.5, levelRequirement = 97, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[38] = { 33, 99, cooldown = 2.5, levelRequirement = 98, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[39] = { 33, 100, cooldown = 2.5, levelRequirement = 99, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[40] = { 34, 102, cooldown = 2.5, levelRequirement = 100, storedUses = 1, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
	},
}
skills["Desecrate"] = {
	name = "Desecrate",
	baseTypeName = "Desecrate",
	color = 2,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.046500001102686,
	description = "Desecrates the ground, spawning corpses based on monsters in the current area and dealing chaos damage over time to enemies. If you are using the Raise Spectre skill there is a chance to spawn spectral corpses matching your most recently raised Spectres. Spectral corpses cannot be interacted with except by Minion skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.DamageOverTime] = true, [SkillType.Multicastable] = true, [SkillType.Chaos] = true, [SkillType.Cascadable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		skill("radius", 12),
	},
	qualityStats = {
		Default = {
			{ "base_cast_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "desecrate_number_of_corpses_to_create", 5 },
		{ "desecrate_maximum_number_of_corpses", 10 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"desecrate_corpse_level",
		"is_area_damage",
	},
	levels = {
		[1] = { 16.666667039196, 20, levelRequirement = 16, statInterpolation = { 3, 1, }, cost = { Mana = 11, }, },
		[2] = { 16.666667039196, 24, levelRequirement = 20, statInterpolation = { 3, 1, }, cost = { Mana = 12, }, },
		[3] = { 16.666667039196, 28, levelRequirement = 24, statInterpolation = { 3, 1, }, cost = { Mana = 13, }, },
		[4] = { 16.666667039196, 32, levelRequirement = 28, statInterpolation = { 3, 1, }, cost = { Mana = 14, }, },
		[5] = { 16.666667039196, 35, levelRequirement = 31, statInterpolation = { 3, 1, }, cost = { Mana = 15, }, },
		[6] = { 16.666667039196, 38, levelRequirement = 34, statInterpolation = { 3, 1, }, cost = { Mana = 16, }, },
		[7] = { 16.666667039196, 41, levelRequirement = 37, statInterpolation = { 3, 1, }, cost = { Mana = 17, }, },
		[8] = { 16.666667039196, 44, levelRequirement = 40, statInterpolation = { 3, 1, }, cost = { Mana = 18, }, },
		[9] = { 16.666667039196, 47, levelRequirement = 43, statInterpolation = { 3, 1, }, cost = { Mana = 18, }, },
		[10] = { 16.666667039196, 50, levelRequirement = 46, statInterpolation = { 3, 1, }, cost = { Mana = 19, }, },
		[11] = { 16.666667039196, 53, levelRequirement = 49, statInterpolation = { 3, 1, }, cost = { Mana = 20, }, },
		[12] = { 16.666667039196, 56, levelRequirement = 52, statInterpolation = { 3, 1, }, cost = { Mana = 21, }, },
		[13] = { 16.666667039196, 59, levelRequirement = 55, statInterpolation = { 3, 1, }, cost = { Mana = 22, }, },
		[14] = { 16.666667039196, 62, levelRequirement = 58, statInterpolation = { 3, 1, }, cost = { Mana = 23, }, },
		[15] = { 16.666667039196, 65, levelRequirement = 60, statInterpolation = { 3, 1, }, cost = { Mana = 23, }, },
		[16] = { 16.666667039196, 68, levelRequirement = 62, statInterpolation = { 3, 1, }, cost = { Mana = 24, }, },
		[17] = { 16.666667039196, 71, levelRequirement = 64, statInterpolation = { 3, 1, }, cost = { Mana = 25, }, },
		[18] = { 16.666667039196, 74, levelRequirement = 66, statInterpolation = { 3, 1, }, cost = { Mana = 25, }, },
		[19] = { 16.666667039196, 77, levelRequirement = 68, statInterpolation = { 3, 1, }, cost = { Mana = 26, }, },
		[20] = { 16.666667039196, 80, levelRequirement = 70, statInterpolation = { 3, 1, }, cost = { Mana = 26, }, },
		[21] = { 16.666667039196, 81, levelRequirement = 72, statInterpolation = { 3, 1, }, cost = { Mana = 27, }, },
		[22] = { 16.666667039196, 82, levelRequirement = 74, statInterpolation = { 3, 1, }, cost = { Mana = 27, }, },
		[23] = { 16.666667039196, 83, levelRequirement = 76, statInterpolation = { 3, 1, }, cost = { Mana = 28, }, },
		[24] = { 16.666667039196, 84, levelRequirement = 78, statInterpolation = { 3, 1, }, cost = { Mana = 29, }, },
		[25] = { 16.666667039196, 85, levelRequirement = 80, statInterpolation = { 3, 1, }, cost = { Mana = 29, }, },
		[26] = { 16.666667039196, 86, levelRequirement = 82, statInterpolation = { 3, 1, }, cost = { Mana = 30, }, },
		[27] = { 16.666667039196, 87, levelRequirement = 84, statInterpolation = { 3, 1, }, cost = { Mana = 30, }, },
		[28] = { 16.666667039196, 88, levelRequirement = 86, statInterpolation = { 3, 1, }, cost = { Mana = 31, }, },
		[29] = { 16.666667039196, 89, levelRequirement = 88, statInterpolation = { 3, 1, }, cost = { Mana = 32, }, },
		[30] = { 16.666667039196, 90, levelRequirement = 90, statInterpolation = { 3, 1, }, cost = { Mana = 32, }, },
		[31] = { 16.666667039196, 91, levelRequirement = 91, statInterpolation = { 3, 1, }, cost = { Mana = 32, }, },
		[32] = { 16.666667039196, 92, levelRequirement = 92, statInterpolation = { 3, 1, }, cost = { Mana = 33, }, },
		[33] = { 16.666667039196, 93, levelRequirement = 93, statInterpolation = { 3, 1, }, cost = { Mana = 33, }, },
		[34] = { 16.666667039196, 94, levelRequirement = 94, statInterpolation = { 3, 1, }, cost = { Mana = 33, }, },
		[35] = { 16.666667039196, 95, levelRequirement = 95, statInterpolation = { 3, 1, }, cost = { Mana = 34, }, },
		[36] = { 16.666667039196, 96, levelRequirement = 96, statInterpolation = { 3, 1, }, cost = { Mana = 34, }, },
		[37] = { 16.666667039196, 97, levelRequirement = 97, statInterpolation = { 3, 1, }, cost = { Mana = 34, }, },
		[38] = { 16.666667039196, 98, levelRequirement = 98, statInterpolation = { 3, 1, }, cost = { Mana = 34, }, },
		[39] = { 16.666667039196, 99, levelRequirement = 99, statInterpolation = { 3, 1, }, cost = { Mana = 35, }, },
		[40] = { 16.666667039196, 100, levelRequirement = 100, statInterpolation = { 3, 1, }, cost = { Mana = 35, }, },
	},
}
skills["DetonateDead"] = {
	name = "Detonate Dead",
	baseTypeName = "Detonate Dead",
	color = 2,
	baseEffectiveness = 4.0300002098083,
	incrementalEffectiveness = 0.031700000166893,
	description = "Targets a corpse, and deals spell damage to enemies around the corpse, as well as causing the corpse to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.DestroysCorpse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	statMap = {
		["spell_minimum_base_fire_damage"] = {
			skill("FireMin", nil, { type = "SkillPart", skillPart = 1 }),
		},
		["spell_maximum_base_fire_damage"] = {
			skill("FireMax", nil, { type = "SkillPart", skillPart = 1 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "detonate_dead_%_chance_to_detonate_additional_corpse", 0.75 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 22 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_area_of_effect_radius",
		"corpse_explosion_monster_life_permillage_fire",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1, 0, 60, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 5, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 61, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 6, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.89999997615814, 1.2000000476837, 0, 62, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, 63, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 1, 64, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 65, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 1, 66, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, 67, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, 68, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 2, 69, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 70, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 71, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 72, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 73, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 3, 74, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 55, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 75, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 17, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 76, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 77, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 78, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 4, 79, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 4, 80, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 4, 81, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, 82, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 4, 83, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 5, 84, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 85, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 86, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 87, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 88, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 6, 89, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 6, 89, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 6, 90, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 6, 90, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 6, 91, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 7, 91, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 7, 92, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 7, 92, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 7, 93, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 7, 93, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 8, 94, critChance = 6, damageEffectiveness = 1.6, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
	},
}
skills["DetonateDeadAltX"] = {
	name = "Detonate Dead of Scavenging",
	baseTypeName = "Detonate Dead of Scavenging",
	color = 2,
	baseEffectiveness = 4.0300002098083,
	incrementalEffectiveness = 0.031700000166893,
	description = "Targets a corpse, causing it to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected. Cannot target corpses that have been created by skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.DestroysCorpse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true),
	},
	qualityStats = {
		Default = {
			{ "corpse_explosion_monster_life_permillage_fire", 2.5 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 28 },
		{ "active_skill_ailment_damage_+%_final", -60 },
	},
	stats = {
		"active_skill_base_area_of_effect_radius",
		"corpse_explosion_monster_life_permillage_fire",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, 200, critChance = 6, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 5, }, },
		[2] = { 0, 205, critChance = 6, levelRequirement = 6, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0, 210, critChance = 6, levelRequirement = 9, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 0, 215, critChance = 6, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[5] = { 1, 220, critChance = 6, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 1, 225, critChance = 6, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[7] = { 1, 230, critChance = 6, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[8] = { 1, 235, critChance = 6, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[9] = { 1, 240, critChance = 6, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[10] = { 2, 245, critChance = 6, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[11] = { 2, 250, critChance = 6, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[12] = { 2, 255, critChance = 6, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[13] = { 2, 260, critChance = 6, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[14] = { 2, 265, critChance = 6, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[15] = { 3, 270, critChance = 6, levelRequirement = 55, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[16] = { 3, 275, critChance = 6, levelRequirement = 58, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[17] = { 3, 280, critChance = 6, levelRequirement = 61, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 3, 285, critChance = 6, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[19] = { 3, 290, critChance = 6, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 4, 295, critChance = 6, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 4, 300, critChance = 6, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 4, 305, critChance = 6, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 4, 310, critChance = 6, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 4, 315, critChance = 6, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 5, 320, critChance = 6, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 5, 325, critChance = 6, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 22, }, },
		[27] = { 5, 330, critChance = 6, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 5, 335, critChance = 6, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 5, 340, critChance = 6, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 6, 345, critChance = 6, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 6, 347, critChance = 6, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 24, }, },
		[32] = { 6, 350, critChance = 6, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 6, 352, critChance = 6, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 6, 355, critChance = 6, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[35] = { 7, 357, critChance = 6, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[36] = { 7, 360, critChance = 6, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 25, }, },
		[37] = { 7, 362, critChance = 6, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[38] = { 7, 365, critChance = 6, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[39] = { 7, 367, critChance = 6, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
		[40] = { 8, 370, critChance = 6, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 26, }, },
	},
}
skills["DetonateDeadAltY"] = {
	name = "Detonate Dead of Chain Reaction",
	baseTypeName = "Detonate Dead of Chain Reaction",
	color = 2,
	baseEffectiveness = 1.4500000476837,
	incrementalEffectiveness = 0.031700000166893,
	description = "Targets a corpse, and deals spell damage to enemies around the corpse, as well as causing the corpse to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected. This will continue to target other corpses in the area, with a shorter delay between each one, until it runs out of corpses or has destroyed 8 corpses. Cannot be supported by Spell Cascade.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.DestroysCorpse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	statMap = {
		["spell_minimum_base_fire_damage"] = {
			skill("FireMin", nil, { type = "SkillPart", skillPart = 1 }),
		},
		["spell_maximum_base_fire_damage"] = {
			skill("FireMax", nil, { type = "SkillPart", skillPart = 1 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.1 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 20 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_area_of_effect_radius",
		"corpse_explosion_monster_life_permillage_fire",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1, 0, 40, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 41, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 6, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[3] = { 0.89999997615814, 1.2000000476837, 0, 41, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, 42, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 1, 42, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 43, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 1, 43, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, 44, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 14, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, 44, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 15, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 2, 45, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 16, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 45, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 46, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 19, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 46, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 47, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 21, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 3, 47, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 55, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 22, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 48, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 23, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 48, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 24, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 49, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 25, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 49, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 26, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 4, 50, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 27, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 4, 50, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 28, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 4, 51, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 29, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, 51, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 30, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 4, 52, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 31, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 5, 52, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 32, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 53, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 33, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 53, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 34, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 54, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 35, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 54, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 36, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 6, 55, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 38, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 6, 55, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 38, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 6, 55, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 39, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 6, 55, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 39, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 6, 56, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 40, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 7, 56, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 40, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 7, 56, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 41, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 7, 56, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 41, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 7, 57, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 42, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 7, 57, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 42, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 8, 57, critChance = 6, damageEffectiveness = 0.65, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 43, }, },
	},
}
skills["VaalDetonateDead"] = {
	name = "Vaal Detonate Dead",
	baseTypeName = "Vaal Detonate Dead",
	color = 2,
	baseEffectiveness = 6.039999961853,
	incrementalEffectiveness = 0.034000001847744,
	description = "Targets a corpse, and deals spell damage to enemies around the corpse, as well as causing the corpse to explode, dealing fire damage. The explosion is not affected by modifiers to spell damage and cannot be reflected. This will continue to target other corpses in the area, with an increasing delay between each one, until it runs out of corpses or has destroyed 22 corpses.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Vaal] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	parts = {
		{
			name = "Spell",
			spell = true,
			cast = false,
		},
		{
			name = "Corpse Explosion",
			spell = false,
			cast =  true,
		},
	},
	statMap = {
		["spell_minimum_base_fire_damage"] = {
			skill("FireMin", nil, { type = "SkillPart", skillPart = 1 }),
		},
		["spell_maximum_base_fire_damage"] = {
			skill("FireMax", nil, { type = "SkillPart", skillPart = 1 }),
		},
	},
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "detonate_dead_%_chance_to_detonate_additional_corpse", 1.5 },
		},
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_area_of_effect_radius",
		"corpse_explosion_monster_life_permillage_fire",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1, 0, 60, critChance = 5, damageEffectiveness = 2, levelRequirement = 4, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 61, critChance = 5, damageEffectiveness = 2, levelRequirement = 6, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[3] = { 0.89999997615814, 1.2000000476837, 0, 62, critChance = 5, damageEffectiveness = 2, levelRequirement = 9, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 0, 63, critChance = 5, damageEffectiveness = 2, levelRequirement = 12, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 1, 64, critChance = 5, damageEffectiveness = 2, levelRequirement = 16, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 65, critChance = 5, damageEffectiveness = 2, levelRequirement = 20, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 1, 66, critChance = 5, damageEffectiveness = 2, levelRequirement = 24, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 1, 67, critChance = 5, damageEffectiveness = 2, levelRequirement = 28, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 1, 68, critChance = 5, damageEffectiveness = 2, levelRequirement = 32, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 2, 69, critChance = 5, damageEffectiveness = 2, levelRequirement = 36, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 2, 70, critChance = 5, damageEffectiveness = 2, levelRequirement = 40, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 2, 71, critChance = 5, damageEffectiveness = 2, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 2, 72, critChance = 5, damageEffectiveness = 2, levelRequirement = 48, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 2, 73, critChance = 5, damageEffectiveness = 2, levelRequirement = 52, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 3, 74, critChance = 5, damageEffectiveness = 2, levelRequirement = 55, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 3, 75, critChance = 5, damageEffectiveness = 2, levelRequirement = 58, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 3, 76, critChance = 5, damageEffectiveness = 2, levelRequirement = 61, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 3, 77, critChance = 5, damageEffectiveness = 2, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 3, 78, critChance = 5, damageEffectiveness = 2, levelRequirement = 67, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 4, 79, critChance = 5, damageEffectiveness = 2, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 4, 80, critChance = 5, damageEffectiveness = 2, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 4, 81, critChance = 5, damageEffectiveness = 2, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, 82, critChance = 5, damageEffectiveness = 2, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 4, 83, critChance = 5, damageEffectiveness = 2, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 5, 84, critChance = 5, damageEffectiveness = 2, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 85, critChance = 5, damageEffectiveness = 2, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 86, critChance = 5, damageEffectiveness = 2, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 87, critChance = 5, damageEffectiveness = 2, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 88, critChance = 5, damageEffectiveness = 2, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 6, 89, critChance = 5, damageEffectiveness = 2, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 6, 89, critChance = 5, damageEffectiveness = 2, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 6, 90, critChance = 5, damageEffectiveness = 2, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 6, 90, critChance = 5, damageEffectiveness = 2, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 6, 91, critChance = 5, damageEffectiveness = 2, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 6, 91, critChance = 5, damageEffectiveness = 2, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 6, 92, critChance = 5, damageEffectiveness = 2, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 6, 92, critChance = 5, damageEffectiveness = 2, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 6, 93, critChance = 5, damageEffectiveness = 2, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 6, 93, critChance = 5, damageEffectiveness = 2, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 7, 94, critChance = 5, damageEffectiveness = 2, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Soul = 30, }, },
	},
}
skills["DoubleStrike"] = {
	name = "Double Strike",
	baseTypeName = "Double Strike",
	color = 2,
	description = "Performs two fast strikes with a melee weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
		mod("PvpTvalueMultiplier", "MORE", -50),
	},
	qualityStats = {
		Default = {
			{ "chance_to_deal_double_damage_%_vs_bleeding_enemies", 1 },
		},
	},
	constantStats = {
		{ "base_skill_number_of_additional_hits", 1 },
		{ "bleed_on_hit_with_attacks_%", 25 },
	},
	stats = {
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 1.438, damageEffectiveness = 1.438, levelRequirement = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 1.512, damageEffectiveness = 1.512, levelRequirement = 2, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 1.594, damageEffectiveness = 1.594, levelRequirement = 4, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 1.682, damageEffectiveness = 1.682, levelRequirement = 7, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 1.779, damageEffectiveness = 1.779, levelRequirement = 11, cost = { Mana = 8, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 1.886, damageEffectiveness = 1.886, levelRequirement = 16, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 1.994, damageEffectiveness = 1.994, levelRequirement = 20, cost = { Mana = 9, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 2.109, damageEffectiveness = 2.109, levelRequirement = 24, cost = { Mana = 9, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 2.23, damageEffectiveness = 2.23, levelRequirement = 28, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 2.358, damageEffectiveness = 2.358, levelRequirement = 32, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 2.494, damageEffectiveness = 2.494, levelRequirement = 36, cost = { Mana = 10, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 2.636, damageEffectiveness = 2.636, levelRequirement = 40, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 2.787, damageEffectiveness = 2.787, levelRequirement = 44, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 48, cost = { Mana = 11, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 3.115, damageEffectiveness = 3.115, levelRequirement = 52, cost = { Mana = 11, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 3.292, damageEffectiveness = 3.292, levelRequirement = 56, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 3.481, damageEffectiveness = 3.481, levelRequirement = 60, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 3.679, damageEffectiveness = 3.679, levelRequirement = 64, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 3.882, damageEffectiveness = 3.882, levelRequirement = 67, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 4.096, damageEffectiveness = 4.096, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 4.315, damageEffectiveness = 4.315, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 4.546, damageEffectiveness = 4.546, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 4.788, damageEffectiveness = 4.788, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 5.044, damageEffectiveness = 5.044, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 5.314, damageEffectiveness = 5.314, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 5.597, damageEffectiveness = 5.597, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 5.896, damageEffectiveness = 5.896, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 6.211, damageEffectiveness = 6.211, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 6.542, damageEffectiveness = 6.542, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 6.891, damageEffectiveness = 6.891, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 7.428, damageEffectiveness = 7.428, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 7.626, damageEffectiveness = 7.626, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 7.829, damageEffectiveness = 7.829, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 8.038, damageEffectiveness = 8.038, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 8.251, damageEffectiveness = 8.251, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 8.471, damageEffectiveness = 8.471, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 8.697, damageEffectiveness = 8.697, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 8.928, damageEffectiveness = 8.928, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 9.166, damageEffectiveness = 9.166, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 9.41, damageEffectiveness = 9.41, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["DoubleStrikeAltX"] = {
	name = "Double Strike of Impaling",
	baseTypeName = "Double Strike of Impaling",
	color = 2,
	description = "Performs two fast strikes with a melee weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
		mod("PvpTvalueMultiplier", "MORE", -50),
	},
	qualityStats = {
		Default = {
			{ "impale_debuff_effect_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_number_of_additional_hits", 1 },
		{ "attacks_impale_on_hit_%_chance", 40 },
		{ "apply_enemy_impale_damage_to_nearby_enemies_on_killing_blow_%_chance", 100 },
	},
	stats = {
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 1.047, damageEffectiveness = 1.047, levelRequirement = 1, cost = { Mana = 7, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 1.101, damageEffectiveness = 1.101, levelRequirement = 2, cost = { Mana = 7, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 1.16, damageEffectiveness = 1.16, levelRequirement = 4, cost = { Mana = 7, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 1.224, damageEffectiveness = 1.224, levelRequirement = 7, cost = { Mana = 7, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 1.296, damageEffectiveness = 1.296, levelRequirement = 11, cost = { Mana = 8, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 1.373, damageEffectiveness = 1.373, levelRequirement = 16, cost = { Mana = 8, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 1.451, damageEffectiveness = 1.451, levelRequirement = 20, cost = { Mana = 9, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 1.536, damageEffectiveness = 1.536, levelRequirement = 24, cost = { Mana = 9, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 1.623, damageEffectiveness = 1.623, levelRequirement = 28, cost = { Mana = 9, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 32, cost = { Mana = 9, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 1.815, damageEffectiveness = 1.815, levelRequirement = 36, cost = { Mana = 10, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 1.919, damageEffectiveness = 1.919, levelRequirement = 40, cost = { Mana = 10, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 2.028, damageEffectiveness = 2.028, levelRequirement = 44, cost = { Mana = 10, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 2.145, damageEffectiveness = 2.145, levelRequirement = 48, cost = { Mana = 11, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 2.267, damageEffectiveness = 2.267, levelRequirement = 52, cost = { Mana = 11, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 2.397, damageEffectiveness = 2.397, levelRequirement = 56, cost = { Mana = 11, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 2.533, damageEffectiveness = 2.533, levelRequirement = 60, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 2.679, damageEffectiveness = 2.679, levelRequirement = 64, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 2.827, damageEffectiveness = 2.827, levelRequirement = 67, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 2.982, damageEffectiveness = 2.982, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 3.142, damageEffectiveness = 3.142, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 3.31, damageEffectiveness = 3.31, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 3.486, damageEffectiveness = 3.486, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 3.672, damageEffectiveness = 3.672, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 3.868, damageEffectiveness = 3.868, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 4.075, damageEffectiveness = 4.075, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 4.292, damageEffectiveness = 4.292, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 4.521, damageEffectiveness = 4.521, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 4.762, damageEffectiveness = 4.762, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 5.017, damageEffectiveness = 5.017, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 5.408, damageEffectiveness = 5.408, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 5.552, damageEffectiveness = 5.552, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 5.7, damageEffectiveness = 5.7, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 5.851, damageEffectiveness = 5.851, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 6.007, damageEffectiveness = 6.007, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 6.167, damageEffectiveness = 6.167, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 6.331, damageEffectiveness = 6.331, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 6.5, damageEffectiveness = 6.5, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 6.672, damageEffectiveness = 6.672, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 6.85, damageEffectiveness = 6.85, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["DoubleStrikeAltY"] = {
	name = "Double Strike of Momentum",
	baseTypeName = "Double Strike of Momentum",
	color = 2,
	description = "Performs two fast strikes with a melee weapon, gaining stages which cause this skill to attack faster. All stages are lost when you move.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["double_strike_max_stages"] = {
			mod("Multiplier:DoubleStrikeofMomentumMaxStages", "BASE", nil),
		},
		["double_strike_attack_speed_+%_final_per_stage"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "DoubleStrikeofMomentumStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
		mod("PvpTvalueMultiplier", "MORE", -50),
	},
	qualityStats = {
		Default = {
			{ "double_strike_attack_speed_+%_final_per_stage", 0.2 },
		},
	},
	constantStats = {
		{ "base_skill_number_of_additional_hits", 1 },
		{ "double_strike_max_stages", 10 },
	},
	stats = {
		"double_strike_attack_speed_+%_final_per_stage",
	},
	levels = {
		[1] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.69, damageEffectiveness = 0.69, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.726, damageEffectiveness = 0.726, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.765, damageEffectiveness = 0.765, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.808, damageEffectiveness = 0.808, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.855, damageEffectiveness = 0.855, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.905, damageEffectiveness = 0.905, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 0.958, damageEffectiveness = 0.958, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[8] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.012, damageEffectiveness = 1.012, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[9] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.07, damageEffectiveness = 1.07, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[10] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.131, damageEffectiveness = 1.131, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[11] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.197, damageEffectiveness = 1.197, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[12] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[13] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.338, damageEffectiveness = 1.338, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[14] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.414, damageEffectiveness = 1.414, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.495, damageEffectiveness = 1.495, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[16] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.58, damageEffectiveness = 1.58, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[17] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.67, damageEffectiveness = 1.67, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.765, damageEffectiveness = 1.765, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.864, damageEffectiveness = 1.864, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 1.967, damageEffectiveness = 1.967, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.072, damageEffectiveness = 2.072, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.182, damageEffectiveness = 2.182, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.298, damageEffectiveness = 2.298, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.421, damageEffectiveness = 2.421, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.55, damageEffectiveness = 2.55, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.687, damageEffectiveness = 2.687, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.83, damageEffectiveness = 2.83, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 2.981, damageEffectiveness = 2.981, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.14, damageEffectiveness = 3.14, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.308, damageEffectiveness = 3.308, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.566, damageEffectiveness = 3.566, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.66, damageEffectiveness = 3.66, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.758, damageEffectiveness = 3.758, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.858, damageEffectiveness = 3.858, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 3.961, damageEffectiveness = 3.961, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.066, damageEffectiveness = 4.066, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.175, damageEffectiveness = 4.175, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.285, damageEffectiveness = 4.285, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.399, damageEffectiveness = 4.399, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.516, damageEffectiveness = 4.516, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["VaalDoubleStrike"] = {
	name = "Vaal Double Strike",
	baseTypeName = "Vaal Double Strike",
	color = 2,
	description = "Performs two fast strikes with a melee weapon, each of which summons a double of you for a duration to continuously attack monsters in this fashion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Physical] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		vaal = true,
	},
	qualityStats = {
		Default = {
			{ "chance_to_deal_double_damage_%_vs_bleeding_enemies", 1 },
		},
	},
	constantStats = {
		{ "base_skill_number_of_additional_hits", 1 },
		{ "base_skill_effect_duration", 6000 },
		{ "number_of_monsters_to_summon", 1 },
		{ "bleed_on_hit_with_attacks_%", 25 },
		{ "maximum_number_of_summoned_doubles", 8 },
	},
	stats = {
		"doubles_have_movement_speed_+%",
		"global_always_hit",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 0, baseMultiplier = 0.403, damageEffectiveness = 0.403, levelRequirement = 1, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[2] = { 3, baseMultiplier = 0.423, damageEffectiveness = 0.423, levelRequirement = 2, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[3] = { 6, baseMultiplier = 0.444, damageEffectiveness = 0.444, levelRequirement = 4, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[4] = { 9, baseMultiplier = 0.466, damageEffectiveness = 0.466, levelRequirement = 7, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[5] = { 12, baseMultiplier = 0.489, damageEffectiveness = 0.489, levelRequirement = 11, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[6] = { 15, baseMultiplier = 0.514, damageEffectiveness = 0.514, levelRequirement = 16, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[7] = { 18, baseMultiplier = 0.539, damageEffectiveness = 0.539, levelRequirement = 20, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[8] = { 21, baseMultiplier = 0.566, damageEffectiveness = 0.566, levelRequirement = 24, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[9] = { 24, baseMultiplier = 0.595, damageEffectiveness = 0.595, levelRequirement = 28, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[10] = { 27, baseMultiplier = 0.624, damageEffectiveness = 0.624, levelRequirement = 32, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[11] = { 30, baseMultiplier = 0.656, damageEffectiveness = 0.656, levelRequirement = 36, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[12] = { 33, baseMultiplier = 0.688, damageEffectiveness = 0.688, levelRequirement = 40, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[13] = { 36, baseMultiplier = 0.723, damageEffectiveness = 0.723, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[14] = { 39, baseMultiplier = 0.759, damageEffectiveness = 0.759, levelRequirement = 48, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[15] = { 42, baseMultiplier = 0.797, damageEffectiveness = 0.797, levelRequirement = 52, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[16] = { 45, baseMultiplier = 0.837, damageEffectiveness = 0.837, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[17] = { 48, baseMultiplier = 0.879, damageEffectiveness = 0.879, levelRequirement = 60, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[18] = { 51, baseMultiplier = 0.923, damageEffectiveness = 0.923, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[19] = { 54, baseMultiplier = 0.969, damageEffectiveness = 0.969, levelRequirement = 67, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[20] = { 57, baseMultiplier = 1.017, damageEffectiveness = 1.017, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[21] = { 60, baseMultiplier = 1.068, damageEffectiveness = 1.068, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[22] = { 63, baseMultiplier = 1.121, damageEffectiveness = 1.121, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[23] = { 66, baseMultiplier = 1.177, damageEffectiveness = 1.177, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[24] = { 69, baseMultiplier = 1.236, damageEffectiveness = 1.236, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[25] = { 72, baseMultiplier = 1.298, damageEffectiveness = 1.298, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[26] = { 75, baseMultiplier = 1.363, damageEffectiveness = 1.363, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[27] = { 78, baseMultiplier = 1.431, damageEffectiveness = 1.431, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[28] = { 81, baseMultiplier = 1.503, damageEffectiveness = 1.503, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[29] = { 84, baseMultiplier = 1.578, damageEffectiveness = 1.578, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[30] = { 87, baseMultiplier = 1.657, damageEffectiveness = 1.657, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[31] = { 89, baseMultiplier = 1.783, damageEffectiveness = 1.783, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[32] = { 90, baseMultiplier = 1.828, damageEffectiveness = 1.828, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[33] = { 92, baseMultiplier = 1.873, damageEffectiveness = 1.873, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[34] = { 93, baseMultiplier = 1.92, damageEffectiveness = 1.92, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[35] = { 95, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[36] = { 96, baseMultiplier = 2.017, damageEffectiveness = 2.017, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[37] = { 98, baseMultiplier = 2.068, damageEffectiveness = 2.068, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[38] = { 99, baseMultiplier = 2.12, damageEffectiveness = 2.12, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[39] = { 101, baseMultiplier = 2.172, damageEffectiveness = 2.172, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
		[40] = { 102, baseMultiplier = 2.227, damageEffectiveness = 2.227, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 30, }, },
	},
}
skills["DualStrike"] = {
	name = "Dual Strike",
	baseTypeName = "Dual Strike",
	color = 2,
	baseEffectiveness = 0,
	description = "Attacks with both weapons, dealing the damage of both in one strike. Dual wield only. Does not work with wands.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.DualWieldOnly] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["dual_strike_critical_strike_chance_+%_final_against_enemies_on_full_life"] = {
			mod("CritChance", "MORE", nil, 0, 0, { type = "ActorCondition", actor = "enemy", var = "FullLife" })
		},
		["dual_strike_damage_+%_final_against_enemies_on_full_life"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "ActorCondition", actor = "enemy", var = "FullLife" })
		},
		["quality_display_dual_strike_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "dual_strike_damage_+%_final_against_enemies_on_full_life", 1.5 },
		},
	},
	constantStats = {
		{ "dual_strike_critical_strike_chance_+%_final_against_enemies_on_full_life", 100 },
		{ "dual_strike_damage_+%_final_against_enemies_on_full_life", 60 },
	},
	stats = {
		"skill_double_hits_when_dual_wielding",
		"quality_display_dual_strike_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 1.553, damageEffectiveness = 1.553, levelRequirement = 1, cost = { Mana = 8, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 1.633, damageEffectiveness = 1.633, levelRequirement = 2, cost = { Mana = 8, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 1.722, damageEffectiveness = 1.722, levelRequirement = 4, cost = { Mana = 8, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 1.817, damageEffectiveness = 1.817, levelRequirement = 7, cost = { Mana = 9, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 1.922, damageEffectiveness = 1.922, levelRequirement = 11, cost = { Mana = 9, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 2.036, damageEffectiveness = 2.036, levelRequirement = 16, cost = { Mana = 9, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 2.153, damageEffectiveness = 2.153, levelRequirement = 20, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 2.278, damageEffectiveness = 2.278, levelRequirement = 24, cost = { Mana = 10, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 2.409, damageEffectiveness = 2.409, levelRequirement = 28, cost = { Mana = 10, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 2.546, damageEffectiveness = 2.546, levelRequirement = 32, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 2.693, damageEffectiveness = 2.693, levelRequirement = 36, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 2.847, damageEffectiveness = 2.847, levelRequirement = 40, cost = { Mana = 12, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 3.01, damageEffectiveness = 3.01, levelRequirement = 44, cost = { Mana = 12, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 3.182, damageEffectiveness = 3.182, levelRequirement = 48, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 3.364, damageEffectiveness = 3.364, levelRequirement = 52, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 3.556, damageEffectiveness = 3.556, levelRequirement = 56, cost = { Mana = 13, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 3.759, damageEffectiveness = 3.759, levelRequirement = 60, cost = { Mana = 13, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 3.973, damageEffectiveness = 3.973, levelRequirement = 64, cost = { Mana = 14, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 4.192, damageEffectiveness = 4.192, levelRequirement = 67, cost = { Mana = 14, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 4.424, damageEffectiveness = 4.424, levelRequirement = 70, cost = { Mana = 14, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 4.66, damageEffectiveness = 4.66, levelRequirement = 72, cost = { Mana = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 4.909, damageEffectiveness = 4.909, levelRequirement = 74, cost = { Mana = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 5.171, damageEffectiveness = 5.171, levelRequirement = 76, cost = { Mana = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 5.448, damageEffectiveness = 5.448, levelRequirement = 78, cost = { Mana = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 5.739, damageEffectiveness = 5.739, levelRequirement = 80, cost = { Mana = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 6.045, damageEffectiveness = 6.045, levelRequirement = 82, cost = { Mana = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 6.368, damageEffectiveness = 6.368, levelRequirement = 84, cost = { Mana = 16, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 6.707, damageEffectiveness = 6.707, levelRequirement = 86, cost = { Mana = 16, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 7.066, damageEffectiveness = 7.066, levelRequirement = 88, cost = { Mana = 16, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 7.442, damageEffectiveness = 7.442, levelRequirement = 90, cost = { Mana = 16, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 8.023, damageEffectiveness = 8.023, levelRequirement = 91, cost = { Mana = 16, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 8.236, damageEffectiveness = 8.236, levelRequirement = 92, cost = { Mana = 16, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 8.456, damageEffectiveness = 8.456, levelRequirement = 93, cost = { Mana = 16, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 8.68, damageEffectiveness = 8.68, levelRequirement = 94, cost = { Mana = 17, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 8.912, damageEffectiveness = 8.912, levelRequirement = 95, cost = { Mana = 17, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 9.149, damageEffectiveness = 9.149, levelRequirement = 96, cost = { Mana = 17, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 9.393, damageEffectiveness = 9.393, levelRequirement = 97, cost = { Mana = 17, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 9.642, damageEffectiveness = 9.642, levelRequirement = 98, cost = { Mana = 17, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 9.899, damageEffectiveness = 9.899, levelRequirement = 99, cost = { Mana = 17, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 10.162, damageEffectiveness = 10.162, levelRequirement = 100, cost = { Mana = 17, }, },
	},
}
skills["DualStrikeAltX"] = {
	name = "Dual Strike of Ambidexterity",
	baseTypeName = "Dual Strike of Ambidexterity",
	color = 2,
	baseEffectiveness = 0,
	description = "Attacks with both weapons, dealing the damage of both in one strike. Requires dual-wielding two different melee weapon types to use.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.DualWieldOnly] = true, [SkillType.DualWieldRequiresDifferentTypes] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["dual_strike_off_hand_weapon_determines_attack_time"] = {
			flag("UseOffhandAttackSpeed"),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_main_hand_weapon_damage_+%_final", 1 },
		},
	},
	constantStats = {
		{ "active_skill_main_hand_weapon_damage_+%_final", 50 },
	},
	stats = {
		"skill_double_hits_when_dual_wielding",
		"dual_strike_off_hand_weapon_determines_attack_time",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 1, cost = { Mana = 8, }, },
		[2] = { attackSpeedMultiplier = -30, baseMultiplier = 1.33, damageEffectiveness = 1.33, levelRequirement = 2, cost = { Mana = 8, }, },
		[3] = { attackSpeedMultiplier = -30, baseMultiplier = 1.403, damageEffectiveness = 1.403, levelRequirement = 4, cost = { Mana = 8, }, },
		[4] = { attackSpeedMultiplier = -30, baseMultiplier = 1.48, damageEffectiveness = 1.48, levelRequirement = 7, cost = { Mana = 9, }, },
		[5] = { attackSpeedMultiplier = -30, baseMultiplier = 1.566, damageEffectiveness = 1.566, levelRequirement = 11, cost = { Mana = 9, }, },
		[6] = { attackSpeedMultiplier = -30, baseMultiplier = 1.659, damageEffectiveness = 1.659, levelRequirement = 16, cost = { Mana = 9, }, },
		[7] = { attackSpeedMultiplier = -30, baseMultiplier = 1.755, damageEffectiveness = 1.755, levelRequirement = 20, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -30, baseMultiplier = 1.856, damageEffectiveness = 1.856, levelRequirement = 24, cost = { Mana = 10, }, },
		[9] = { attackSpeedMultiplier = -30, baseMultiplier = 1.962, damageEffectiveness = 1.962, levelRequirement = 28, cost = { Mana = 10, }, },
		[10] = { attackSpeedMultiplier = -30, baseMultiplier = 2.075, damageEffectiveness = 2.075, levelRequirement = 32, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -30, baseMultiplier = 2.194, damageEffectiveness = 2.194, levelRequirement = 36, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -30, baseMultiplier = 2.32, damageEffectiveness = 2.32, levelRequirement = 40, cost = { Mana = 12, }, },
		[13] = { attackSpeedMultiplier = -30, baseMultiplier = 2.453, damageEffectiveness = 2.453, levelRequirement = 44, cost = { Mana = 12, }, },
		[14] = { attackSpeedMultiplier = -30, baseMultiplier = 2.592, damageEffectiveness = 2.592, levelRequirement = 48, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -30, baseMultiplier = 2.741, damageEffectiveness = 2.741, levelRequirement = 52, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -30, baseMultiplier = 2.898, damageEffectiveness = 2.898, levelRequirement = 56, cost = { Mana = 13, }, },
		[17] = { attackSpeedMultiplier = -30, baseMultiplier = 3.062, damageEffectiveness = 3.062, levelRequirement = 60, cost = { Mana = 13, }, },
		[18] = { attackSpeedMultiplier = -30, baseMultiplier = 3.237, damageEffectiveness = 3.237, levelRequirement = 64, cost = { Mana = 14, }, },
		[19] = { attackSpeedMultiplier = -30, baseMultiplier = 3.416, damageEffectiveness = 3.416, levelRequirement = 67, cost = { Mana = 14, }, },
		[20] = { attackSpeedMultiplier = -30, baseMultiplier = 3.605, damageEffectiveness = 3.605, levelRequirement = 70, cost = { Mana = 14, }, },
		[21] = { attackSpeedMultiplier = -30, baseMultiplier = 3.797, damageEffectiveness = 3.797, levelRequirement = 72, cost = { Mana = 15, }, },
		[22] = { attackSpeedMultiplier = -30, baseMultiplier = 4, damageEffectiveness = 4, levelRequirement = 74, cost = { Mana = 15, }, },
		[23] = { attackSpeedMultiplier = -30, baseMultiplier = 4.213, damageEffectiveness = 4.213, levelRequirement = 76, cost = { Mana = 15, }, },
		[24] = { attackSpeedMultiplier = -30, baseMultiplier = 4.438, damageEffectiveness = 4.438, levelRequirement = 78, cost = { Mana = 15, }, },
		[25] = { attackSpeedMultiplier = -30, baseMultiplier = 4.676, damageEffectiveness = 4.676, levelRequirement = 80, cost = { Mana = 15, }, },
		[26] = { attackSpeedMultiplier = -30, baseMultiplier = 4.926, damageEffectiveness = 4.926, levelRequirement = 82, cost = { Mana = 15, }, },
		[27] = { attackSpeedMultiplier = -30, baseMultiplier = 5.189, damageEffectiveness = 5.189, levelRequirement = 84, cost = { Mana = 16, }, },
		[28] = { attackSpeedMultiplier = -30, baseMultiplier = 5.466, damageEffectiveness = 5.466, levelRequirement = 86, cost = { Mana = 16, }, },
		[29] = { attackSpeedMultiplier = -30, baseMultiplier = 5.757, damageEffectiveness = 5.757, levelRequirement = 88, cost = { Mana = 16, }, },
		[30] = { attackSpeedMultiplier = -30, baseMultiplier = 6.064, damageEffectiveness = 6.064, levelRequirement = 90, cost = { Mana = 16, }, },
		[31] = { attackSpeedMultiplier = -30, baseMultiplier = 6.537, damageEffectiveness = 6.537, levelRequirement = 91, cost = { Mana = 16, }, },
		[32] = { attackSpeedMultiplier = -30, baseMultiplier = 6.711, damageEffectiveness = 6.711, levelRequirement = 92, cost = { Mana = 16, }, },
		[33] = { attackSpeedMultiplier = -30, baseMultiplier = 6.89, damageEffectiveness = 6.89, levelRequirement = 93, cost = { Mana = 16, }, },
		[34] = { attackSpeedMultiplier = -30, baseMultiplier = 7.073, damageEffectiveness = 7.073, levelRequirement = 94, cost = { Mana = 17, }, },
		[35] = { attackSpeedMultiplier = -30, baseMultiplier = 7.262, damageEffectiveness = 7.262, levelRequirement = 95, cost = { Mana = 17, }, },
		[36] = { attackSpeedMultiplier = -30, baseMultiplier = 7.454, damageEffectiveness = 7.454, levelRequirement = 96, cost = { Mana = 17, }, },
		[37] = { attackSpeedMultiplier = -30, baseMultiplier = 7.653, damageEffectiveness = 7.653, levelRequirement = 97, cost = { Mana = 17, }, },
		[38] = { attackSpeedMultiplier = -30, baseMultiplier = 7.856, damageEffectiveness = 7.856, levelRequirement = 98, cost = { Mana = 17, }, },
		[39] = { attackSpeedMultiplier = -30, baseMultiplier = 8.066, damageEffectiveness = 8.066, levelRequirement = 99, cost = { Mana = 17, }, },
		[40] = { attackSpeedMultiplier = -30, baseMultiplier = 8.281, damageEffectiveness = 8.281, levelRequirement = 100, cost = { Mana = 17, }, },
	},
}
skills["ElementalHit"] = {
	name = "Elemental Hit",
	baseTypeName = "Elemental Hit",
	color = 2,
	baseEffectiveness = 3.2400000095367,
	incrementalEffectiveness = 0.035999998450279,
	description = "Each attack with a melee weapon will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Area] = true, [SkillType.RandomElement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Fire Attack",
			area = false,
		},
		{
			name = "Fire AoE",
			area = true,
		},
		{
			name = "Cold Attack",
			area = false,
		},
		{
			name = "Cold AoE",
			area = true,
		},
		{
			name = "Lightning Attack",
			area = false,
		},
		{
			name = "Lightning AoE",
			area = true,
		},
	},
	statMap = {
		["elemental_hit_damage_+%_final_per_enemy_elemental_ailment"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "ElementalHitAilmentOnEnemy" }),
		},
		["elemental_hit_area_of_effect_+100%_final_vs_enemy_with_associated_ailment"] = {
		},
		["elemental_hit_no_physical_chaos_damage"] = {
			flag("DealNoPhysical"),
			flag("DealNoChaos"),
			flag("DealNoFire", { type = "SkillPart", skillPartList = { 3, 4 } }),
			flag("DealNoFire", { type = "SkillPart", skillPartList = { 5, 6 } }),
			flag("DealNoCold", { type = "SkillPart", skillPartList = { 1, 2 } }),
			flag("DealNoCold", { type = "SkillPart", skillPartList = { 5, 6 } }),
			flag("DealNoLightning", { type = "SkillPart", skillPartList = { 1, 2 } }),
			flag("DealNoLightning", { type = "SkillPart", skillPartList = { 3, 4 } }),
		},
		["active_skill_base_area_of_effect_radius"] = {
			skill("radius", nil, { type = "SkillPart", skillPartList = { 2, 4, 6 } }),
		},
		["deal_no_non_elemental_damage"] = {
			-- Display only
		},
		["elemental_hit_no_damage_of_unchosen_elemental_type"] = {
			-- Display only
		},
		["quality_display_elemental_hit_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Scorched" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Brittle" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Sapped" }),
	},
	qualityStats = {
		Default = {
			{ "elemental_hit_damage_+%_final_per_enemy_elemental_ailment", 0.25 },
		},
	},
	constantStats = {
		{ "elemental_hit_damage_+%_final_per_enemy_elemental_ailment", 10 },
		{ "active_skill_base_area_of_effect_radius", 14 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"chance_to_freeze_shock_ignite_%",
		"elemental_hit_area_of_effect_+100%_final_vs_enemy_with_associated_ailment",
		"elemental_hit_no_physical_chaos_damage",
		"elemental_hit_no_damage_of_unchosen_elemental_type",
		"quality_display_elemental_hit_is_gem",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 30, attackSpeedMultiplier = 20, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 5, }, },
		[2] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 31, attackSpeedMultiplier = 20, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 5, }, },
		[3] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 32, attackSpeedMultiplier = 20, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 5, }, },
		[4] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 33, attackSpeedMultiplier = 20, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 5, }, },
		[5] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 34, attackSpeedMultiplier = 20, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[6] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 35, attackSpeedMultiplier = 20, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[7] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 36, attackSpeedMultiplier = 20, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[8] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 37, attackSpeedMultiplier = 20, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[9] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 38, attackSpeedMultiplier = 20, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[10] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 39, attackSpeedMultiplier = 20, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[11] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 40, attackSpeedMultiplier = 20, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[12] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 41, attackSpeedMultiplier = 20, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[13] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 42, attackSpeedMultiplier = 20, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[14] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 43, attackSpeedMultiplier = 20, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[15] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 44, attackSpeedMultiplier = 20, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[16] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 45, attackSpeedMultiplier = 20, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[17] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 46, attackSpeedMultiplier = 20, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[18] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 47, attackSpeedMultiplier = 20, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[19] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 48, attackSpeedMultiplier = 20, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[20] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 49, attackSpeedMultiplier = 20, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[21] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 50, attackSpeedMultiplier = 20, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[22] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 51, attackSpeedMultiplier = 20, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[23] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 52, attackSpeedMultiplier = 20, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[24] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 53, attackSpeedMultiplier = 20, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[25] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 54, attackSpeedMultiplier = 20, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[26] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 55, attackSpeedMultiplier = 20, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[27] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 56, attackSpeedMultiplier = 20, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[28] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 57, attackSpeedMultiplier = 20, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[29] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 58, attackSpeedMultiplier = 20, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[30] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 59, attackSpeedMultiplier = 20, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[31] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 59, attackSpeedMultiplier = 20, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[32] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 60, attackSpeedMultiplier = 20, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[33] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 60, attackSpeedMultiplier = 20, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[34] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 61, attackSpeedMultiplier = 20, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[35] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 61, attackSpeedMultiplier = 20, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[36] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 62, attackSpeedMultiplier = 20, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[37] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 62, attackSpeedMultiplier = 20, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[38] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 63, attackSpeedMultiplier = 20, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[39] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 63, attackSpeedMultiplier = 20, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[40] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 64, attackSpeedMultiplier = 20, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
	},
}
skills["ElementalHitAltX"] = {
	name = "Elemental Hit of the Spectrum",
	baseTypeName = "Elemental Hit of the Spectrum",
	color = 2,
	baseEffectiveness = 0.98000001907349,
	incrementalEffectiveness = 0.032699998468161,
	description = "Fires a projectile with a wand or bow that deals fire, cold and lightning damage. If the projectile hits an enemy, it will deal damage in an area around them.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.WandAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Wand"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Attack",
			area = false,
		},
		{
			name = "AoE Explosion",
			area = true,
		},
	},
	statMap = {
		["elemental_hit_damage_+%_final_per_enemy_elemental_ailment"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "ElementalHitAilmentOnEnemy" }),
		},
		["elemental_hit_no_physical_chaos_damage"] = {
			flag("DealNoPhysical"),
			flag("DealNoChaos"),
		},
		["active_skill_base_area_of_effect_radius"] = {
			skill("radius", nil, { type = "SkillPart", skillPart = 2 }),
		},
		["deal_no_non_elemental_damage"] = {
			-- Display only
		},
		["quality_display_elemental_hit_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Scorched" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Brittle" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Sapped" }),
	},
	qualityStats = {
		Default = {
			{ "elemental_hit_damage_+%_final_per_enemy_elemental_ailment", 0.25 },
		},
	},
	constantStats = {
		{ "elemental_hit_damage_+%_final_per_enemy_elemental_ailment", 10 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"chance_to_freeze_shock_ignite_%",
		"elemental_hit_no_physical_chaos_damage",
		"quality_display_elemental_hit_is_gem",
		"deal_no_non_elemental_damage",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 30, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 31, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 32, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[4] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 33, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 34, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 35, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[7] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 36, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[8] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 37, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[9] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 38, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[10] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 39, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[11] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 40, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[12] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 41, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[13] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 42, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[14] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 43, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[15] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 44, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[16] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 45, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[17] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 46, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[18] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 47, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[19] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 48, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[20] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 49, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[21] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 50, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[22] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 51, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[23] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 52, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[24] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 53, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[25] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 54, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[26] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 55, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[27] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 56, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[28] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 57, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[29] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 58, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[30] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 59, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[31] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 59, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[32] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 60, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[33] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 60, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[34] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 61, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[35] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 61, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[36] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 62, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[37] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 62, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[38] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 63, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[39] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 63, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[40] = { 0.69999998807907, 1.2999999523163, 0.56999999284744, 1.0599999427795, 0.10999999940395, 2.1400001049042, 64, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
	},
}
skills["EnsnaringArrow"] = {
	name = "Ensnaring Arrow",
	baseTypeName = "Ensnaring Arrow",
	color = 2,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.052000001072884,
	description = "Fires an arrow that remains in the ground behind its final target, tethering that enemy to it. Ensnared enemies have less movement speed while trying to break the snare. The snare will break if they leave the area of effect.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["tethered_enemies_take_attack_projectile_damage_taken_+%"] = {
			mod("ProjectileAttackDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Ensnared", effectStackVar = "EnsnareStackCount", effectStackLimit = 1 }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "skill_buff_effect_+%", 1 },
		},
	},
	constantStats = {
		{ "tethered_movement_speed_+%_final_per_rope", -40 },
		{ "tethered_movement_speed_+%_final_per_rope_vs_rare", -30 },
		{ "tethered_movement_speed_+%_final_per_rope_vs_unique", -25 },
		{ "tethering_arrow_display_rope_limit", 3 },
	},
	stats = {
		"tethered_enemies_take_attack_projectile_damage_taken_+%",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 15, baseMultiplier = 1.4, damageEffectiveness = 1.4, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[2] = { 15, baseMultiplier = 1.418, damageEffectiveness = 1.42, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[3] = { 16, baseMultiplier = 1.437, damageEffectiveness = 1.44, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 16, baseMultiplier = 1.455, damageEffectiveness = 1.46, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 16, baseMultiplier = 1.474, damageEffectiveness = 1.47, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[6] = { 16, baseMultiplier = 1.492, damageEffectiveness = 1.49, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 17, baseMultiplier = 1.511, damageEffectiveness = 1.51, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 17, baseMultiplier = 1.529, damageEffectiveness = 1.53, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 17, baseMultiplier = 1.547, damageEffectiveness = 1.55, levelRequirement = 43, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 17, baseMultiplier = 1.566, damageEffectiveness = 1.57, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 18, baseMultiplier = 1.584, damageEffectiveness = 1.58, levelRequirement = 49, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 18, baseMultiplier = 1.603, damageEffectiveness = 1.6, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 18, baseMultiplier = 1.621, damageEffectiveness = 1.62, levelRequirement = 55, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 18, baseMultiplier = 1.639, damageEffectiveness = 1.64, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 19, baseMultiplier = 1.658, damageEffectiveness = 1.66, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 19, baseMultiplier = 1.676, damageEffectiveness = 1.68, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 19, baseMultiplier = 1.695, damageEffectiveness = 1.69, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 19, baseMultiplier = 1.713, damageEffectiveness = 1.71, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 20, baseMultiplier = 1.732, damageEffectiveness = 1.73, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 20, baseMultiplier = 1.75, damageEffectiveness = 1.75, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 20, baseMultiplier = 1.768, damageEffectiveness = 1.77, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 21, baseMultiplier = 1.787, damageEffectiveness = 1.79, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 21, baseMultiplier = 1.805, damageEffectiveness = 1.81, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 21, baseMultiplier = 1.824, damageEffectiveness = 1.82, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 21, baseMultiplier = 1.842, damageEffectiveness = 1.84, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 22, baseMultiplier = 1.861, damageEffectiveness = 1.86, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 22, baseMultiplier = 1.879, damageEffectiveness = 1.88, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 22, baseMultiplier = 1.897, damageEffectiveness = 1.9, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 22, baseMultiplier = 1.916, damageEffectiveness = 1.92, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 23, baseMultiplier = 1.934, damageEffectiveness = 1.93, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 23, baseMultiplier = 1.943, damageEffectiveness = 1.94, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 23, baseMultiplier = 1.953, damageEffectiveness = 1.95, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 23, baseMultiplier = 1.962, damageEffectiveness = 1.96, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 23, baseMultiplier = 1.971, damageEffectiveness = 1.97, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 23, baseMultiplier = 1.98, damageEffectiveness = 1.98, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 23, baseMultiplier = 1.989, damageEffectiveness = 1.99, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 24, baseMultiplier = 1.999, damageEffectiveness = 2, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 24, baseMultiplier = 2.008, damageEffectiveness = 2.01, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 24, baseMultiplier = 2.017, damageEffectiveness = 2.02, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 24, baseMultiplier = 2.026, damageEffectiveness = 2.03, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["EtherealKnives"] = {
	name = "Ethereal Knives",
	baseTypeName = "Ethereal Knives",
	color = 2,
	baseEffectiveness = 2.1717000007629,
	incrementalEffectiveness = 0.043600000441074,
	description = "Fires an arc of knives outwards in front of the caster which deal physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.1 },
		},
	},
	constantStats = {
		{ "active_skill_projectile_speed_+%_variation_final", 50 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_number_of_projectiles",
		"base_is_projectile",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[2] = { 0.89999997615814, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 2, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
	},
}
skills["EtherealKnivesAltX"] = {
	name = "Ethereal Knives of Lingering Blades",
	baseTypeName = "Ethereal Knives of Lingering Blades",
	color = 2,
	baseEffectiveness = 2.1717000007629,
	incrementalEffectiveness = 0.043600000441074,
	description = "Fires an arc of knives down into the ground in front of the caster which deal physical damage.\nCannot be supported by Volley.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, [SkillType.Duration] = true, [SkillType.NoVolley] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.1 },
		},
	},
	constantStats = {
		{ "active_skill_projectile_speed_+%_variation_final", 50 },
		{ "maximum_number_of_blades_left_in_ground", 40 },
		{ "ethereal_knives_blade_left_in_ground_for_every_X_projectiles", 1 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_number_of_projectiles",
		"base_is_projectile",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[2] = { 0.89999997615814, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { Mana = 5, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 2, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
	},
}
skills["EtherealKnivesAltY"] = {
	name = "Ethereal Knives of the Massacre",
	baseTypeName = "Ethereal Knives of the Massacre",
	color = 2,
	baseEffectiveness = 2.1717000007629,
	incrementalEffectiveness = 0.043600000441074,
	description = "Fires a circle of knives outwards around the caster which deal physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.15 },
		},
	},
	constantStats = {
		{ "active_skill_projectile_speed_+%_variation_final", 50 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_number_of_projectiles",
		"base_is_projectile",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
		"projectiles_nova",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.89999997615814, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 12, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { Mana = 6, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 1.9, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 13, critChance = 6, damageEffectiveness = 2, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 14, critChance = 6, damageEffectiveness = 2, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 18, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 15, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.1, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 16, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 17, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 18, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 19, critChance = 6, damageEffectiveness = 2.2, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
	},
}
skills["ExplosiveArrow"] = {
	name = "Explosive Arrow",
	baseTypeName = "Explosive Arrow",
	color = 2,
	baseEffectiveness = 1.4859000444412,
	incrementalEffectiveness = 0.040300000458956,
	description = "Fires an arrow which will stick into an enemy or wall, and then explode, dealing area damage around it, either after a duration or when the maximum number of arrows stuck to that target is reached. If an enemy has multiple Explosive Arrows stuck in them, the first one to explode will consume the others, adding their damage to its explosion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Explosion (# of fuses)",
			area = true,
			stages = true,
		},
		{
			name = "Explosion (Maximum Sustainable Fuses)",
			area = true,
		},
		{
			name = "Arrow",
			area = false,
		},
	},
	explosiveArrowFunc = function(activeSkill, output, globalOutput, globalBreakdown, env)
		local t_insert = table.insert
		local s_format = string.format

		if activeSkill.skillPart ~= 1 and activeSkill.skillPart ~= 2 then
			-- This doesn't apply to the "Arrow" skill part. That works like a normal skill.
			return
		end

		local modDB = env.modDB
		local enemyDB = activeSkill.actor.enemy.modDB
		local skillModList = activeSkill.skillModList
		local duration = calcSkillDuration(skillModList, activeSkill.skillCfg, activeSkill.skillData, env, enemyDB)
		local fuseLimit = skillModList:Sum("BASE", activeSkill.skillCfg, "ExplosiveArrowMaxFuseCount")
		local activeTotems
		if activeSkill.skillFlags.totem then
			activeTotems = modDB:Override(nil, "TotemsSummoned") or skillModList:Sum("BASE", activeSkill.skillCfg, "ActiveTotemLimit", "ActiveBallistaLimit")
		end

		local barrageProjectiles = nil
		if skillModList:Flag(nil, "SequentialProjectiles") and not skillModList:Flag(nil, "OneShotProj") and not skillModList:Flag(nil,"NoAdditionalProjectiles") and not skillModList:Flag(nil, "TriggeredBySnipe") then
			barrageProjectiles = skillModList:Sum("BASE", activeSkill.skillCfg, "ProjectileCount")
			activeSkill.skillData.dpsMultiplier = activeSkill.skillData.dpsMultiplier / barrageProjectiles  -- cancel out the normal dps multiplier from barrage that applies to most other skills
		end

		local fuseApplicationRate = (output.HitChance / 100) * globalOutput.Speed * activeSkill.skillData.dpsMultiplier * (barrageProjectiles or 1)
		local initialApplicationRate = fuseApplicationRate
		if activeSkill.skillFlags.totem then
			fuseApplicationRate = fuseApplicationRate * activeTotems
		end

		-- Calculate the max number of fuses you can sustain
		-- Does not take into account mines or traps
		if activeSkill.skillPart == 2 then
			local maximum = math.min(math.floor(fuseApplicationRate * duration) + 1, fuseLimit)
			skillModList:NewMod("Multiplier:ExplosiveArrowStage", "BASE", maximum, "Base")
			skillModList:NewMod("Multiplier:ExplosiveArrowStageAfterFirst", "BASE", maximum - 1, "Base")
			globalOutput.MaxExplosiveArrowFuseCalculated = maximum
		else
			globalOutput.MaxExplosiveArrowFuseCalculated = nil
		end

		-- Calculate explosion rate
		local timeToMaxFuses = fuseLimit / fuseApplicationRate
		if activeSkill.skillPart == 2 or (activeSkill.skillPart == 1 and (activeSkill.activeStageCount or 0) + 1 >= fuseLimit) then
			globalOutput.HitTime = math.min(duration, timeToMaxFuses)
		else
			-- Number of fuses is less than the limit, so the entire fuse duration applies
			globalOutput.HitTime = duration
		end

		globalOutput.HitSpeed = 1 / globalOutput.HitTime

		if globalBreakdown and globalOutput.MaxExplosiveArrowFuseCalculated then
			globalBreakdown.MaxExplosiveArrowFuseCalculated = {}
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("%.2f ^8(attack speed)", globalOutput.Speed))
			if output.HitChance < 100 then
				t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("x %.2f ^8(hit chance)", output.HitChance / 100))
			end
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("x %.2f ^8(projectiles)", barrageProjectiles or 1))
			if activeSkill.skillFlags.totem then
				t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("= %.2f ^8(fuse rate)", initialApplicationRate))
				t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("x %d ^8(active totems)", activeTotems))
				t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("= %.2f ^8(fuse rate)", fuseApplicationRate))
			else
				t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("= %.2f ^8(fuse rate)", fuseApplicationRate))
			end
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("x %.2f ^8(duration)", duration))
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("+ 1 ^8(initial hit)"))
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("= %.2f", (fuseApplicationRate * duration) + 1))
			t_insert(globalBreakdown.MaxExplosiveArrowFuseCalculated, s_format("= %d ^8(rounded down, capped at max)", globalOutput.MaxExplosiveArrowFuseCalculated))

			globalBreakdown.ExplosionsPerSecond = {}
			t_insert(globalBreakdown.ExplosionsPerSecond, s_format("1 ^8(second)"))
			t_insert(globalBreakdown.ExplosionsPerSecond, s_format(" / %d ^8(max fuses)", globalOutput.MaxExplosiveArrowFuseCalculated))
			t_insert(globalBreakdown.ExplosionsPerSecond, s_format(" / %.2f ^8(fuse rate)", fuseApplicationRate))
			t_insert(globalBreakdown.ExplosionsPerSecond, s_format("= %.2f ^8(explosions/s)", globalOutput.HitSpeed))

		end
	end,
	statMap = {
		["explosive_arrow_explosion_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 1, 2 } }),
		},
		["explosive_arrow_explosion_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 1, 2 } }),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowStage", limitVar = "ExplosiveArrowMaxBonusRadius", limitTotal = true }),
		},
		["explosive_arrow_explosion_base_damage_+permyriad"] = {
			skill("baseMultiplier", nil, { type = "SkillPart", skillPartList = { 1, 2 } }),
			div = -10000,
		},
		["explosive_arrow_hit_damage_+%_final_per_stack"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Hit, { type = "SkillPart", skillPartList = { 1, 2 } }, { type = "Multiplier", var = "ExplosiveArrowStage" }),
		},
		["explosive_arrow_ailment_damage_+%_final_per_stack"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Ailment, { type = "SkillPart", skillPartList = { 1, 2 } }, { type = "Multiplier", var = "ExplosiveArrowStage" }),
		},
		["explosive_arrow_maximum_bonus_explosion_radius"] = {
			mod("Multiplier:ExplosiveArrowMaxBonusRadius", "BASE", nil),
		},
		["explosive_arrow_stack_limit"] = {
			mod("Multiplier:ExplosiveArrowMaxStages", "BASE", nil, 0, 0, { type = "SkillPart", skillPart = 1 }),
			mod("ExplosiveArrowMaxFuseCount", "BASE", nil),
		},
		["quality_display_explosive_arrow_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true, { type = "SkillPart", skillPartList = { 1, 2 } }),
		mod("Damage", "MORE", 100, 0, 0, { type = "SkillPart", skillPartList = { 1, 2 } }, { type = "Multiplier", var = "ExplosiveArrowStageAfterFirst" }),
	},
	qualityStats = {
		Default = {
			{ "explosive_arrow_stack_limit", 0.1 },
		},
	},
	constantStats = {
		{ "fuse_arrow_explosion_radius_+_per_fuse_arrow_orb", 2 },
		{ "explosive_arrow_explosion_base_damage_+permyriad", -5000 },
		{ "explosive_arrow_maximum_bonus_explosion_radius", 12 },
		{ "explosive_arrow_hit_damage_+%_final_per_stack", 6 },
		{ "explosive_arrow_ailment_damage_+%_final_per_stack", 3 },
		{ "explosive_arrow_stack_limit", 20 },
		{ "base_skill_effect_duration", 1000 },
	},
	stats = {
		"explosive_arrow_explosion_minimum_added_fire_damage",
		"explosive_arrow_explosion_maximum_added_fire_damage",
		"skill_can_fire_arrows",
		"base_is_projectile",
		"quality_display_explosive_arrow_is_gem",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 7, }, },
		[2] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[3] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[4] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[6] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[8] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 8, }, },
		[9] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[10] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[11] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[12] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[13] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[14] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[15] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 9, }, },
		[16] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[17] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[18] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[19] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[21] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[22] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[23] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 10, }, },
		[24] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[25] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[26] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[27] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[28] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[29] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[30] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[31] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[32] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 11, }, },
		[33] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[34] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[35] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[36] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[37] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[38] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[39] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
		[40] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -50, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 12, }, },
	},
}
skills["ExplosiveConcoction"] = {
	name = "Explosive Concoction",
	baseTypeName = "Explosive Concoction",
	color = 2,
	baseEffectiveness = 4.8000001907349,
	incrementalEffectiveness = 0.043000001460314,
	description = "Throws a bottle that explodes to deal unarmed attack damage in an area. Can consume charges from your Ruby, Sapphire, and Topaz flasks to add further damage. Requires an empty main hand, and no off-hand weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.RequiresOffHandNotWeapon] = true, },
	weaponTypes = {
		["None"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No Flasks",
		},
		{
			name = "Sapphire",
		},
		{
			name = "Topaz",
		},
		{
			name = "Ruby",
		},
		{
			name = "Sapphire + Topaz",
		},
		{
			name = "Sapphire + Ruby",
		},
		{
			name = "Topaz + Ruby",
		},
		{
			name = "All Flasks",
		},
	},
	statMap = {
		["flask_throw_minimum_cold_damage_if_used_sapphire_flask"] = {
			mod("ColdMin", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 2, 5, 6, 8 } }),
		},
		["flask_throw_maximum_cold_damage_if_used_sapphire_flask"] = {
			mod("ColdMax", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 2, 5, 6, 8 } }),
		},
		["flask_throw_minimum_lightning_damage_if_used_topaz_flask"] = {
			mod("LightningMin", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 3, 5, 7, 8 } }),
		},
		["flask_throw_maximum_lightning_damage_if_used_topaz_flask"] = {
			mod("LightningMax", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 3, 5, 7, 8 } }),
		},
		["flask_throw_ruby_flask_ignite_dot_multiplier_+"] = {
			mod("FireDotMultiplier", "BASE", nil, 0, KeywordFlag.Ignite, { type = "SkillPart", skillPartList = { 4, 6, 7, 8 } }),
		},
	},
	baseFlags = {
		attack = true,
		area = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "flask_charges_used_+%", -0.75 },
		},
	},
	constantStats = {
		{ "additional_base_critical_strike_chance", 600 },
		{ "flask_throw_charges_used_per_projectile", 1 },
		{ "active_skill_base_area_of_effect_radius", 18 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"flask_throw_minimum_cold_damage_if_used_sapphire_flask",
		"flask_throw_maximum_cold_damage_if_used_sapphire_flask",
		"flask_throw_minimum_lightning_damage_if_used_topaz_flask",
		"flask_throw_maximum_lightning_damage_if_used_topaz_flask",
		"flask_throw_ruby_flask_ignite_dot_multiplier_+",
		"base_is_projectile",
		"is_area_damage",
		"console_skill_dont_chase",
		"projectile_behaviour_only_explode",
		"explosive_concoction_attach_flask_visual_buff",
	},
	levels = {
		[1] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 120, attackSpeedMultiplier = 15, levelRequirement = 28, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 124, attackSpeedMultiplier = 15, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 128, attackSpeedMultiplier = 15, levelRequirement = 34, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 132, attackSpeedMultiplier = 15, levelRequirement = 37, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 136, attackSpeedMultiplier = 15, levelRequirement = 40, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 140, attackSpeedMultiplier = 15, levelRequirement = 42, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[7] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 144, attackSpeedMultiplier = 15, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[8] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 148, attackSpeedMultiplier = 15, levelRequirement = 46, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[9] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 152, attackSpeedMultiplier = 15, levelRequirement = 48, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[10] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 156, attackSpeedMultiplier = 15, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[11] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 160, attackSpeedMultiplier = 15, levelRequirement = 52, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[12] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 164, attackSpeedMultiplier = 15, levelRequirement = 54, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[13] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 168, attackSpeedMultiplier = 15, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[14] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 172, attackSpeedMultiplier = 15, levelRequirement = 58, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[15] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 176, attackSpeedMultiplier = 15, levelRequirement = 60, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[16] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 180, attackSpeedMultiplier = 15, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[17] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 184, attackSpeedMultiplier = 15, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[18] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 188, attackSpeedMultiplier = 15, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[19] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 192, attackSpeedMultiplier = 15, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[20] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 196, attackSpeedMultiplier = 15, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[21] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 200, attackSpeedMultiplier = 15, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[22] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 204, attackSpeedMultiplier = 15, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[23] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 208, attackSpeedMultiplier = 15, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[24] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 212, attackSpeedMultiplier = 15, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[25] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 216, attackSpeedMultiplier = 15, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[26] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 220, attackSpeedMultiplier = 15, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[27] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 224, attackSpeedMultiplier = 15, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[28] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 228, attackSpeedMultiplier = 15, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[29] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 232, attackSpeedMultiplier = 15, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[30] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 236, attackSpeedMultiplier = 15, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[31] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 240, attackSpeedMultiplier = 15, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[32] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 244, attackSpeedMultiplier = 15, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[33] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 248, attackSpeedMultiplier = 15, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[34] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 252, attackSpeedMultiplier = 15, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[35] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 256, attackSpeedMultiplier = 15, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[36] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 260, attackSpeedMultiplier = 15, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[37] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 264, attackSpeedMultiplier = 15, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[38] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 268, attackSpeedMultiplier = 15, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[39] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 272, attackSpeedMultiplier = 15, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[40] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 276, attackSpeedMultiplier = 15, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
	},
}
skills["ExplosiveConcoctionAltX"] = {
	name = "Explosive Concoction of Destruction",
	baseTypeName = "Explosive Concoction of Destruction",
	color = 2,
	baseEffectiveness = 4.25,
	incrementalEffectiveness = 0.043000001460314,
	description = "Throws a bottle that explodes to deal unarmed attack damage in an area. Can consume charges from your Ruby, Sapphire, and Topaz flasks to add further damage. Requires an empty main hand, and no off-hand weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.RequiresOffHandNotWeapon] = true, },
	weaponTypes = {
		["None"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "No Flasks",
		},
		{
			name = "Sapphire",
		},
		{
			name = "Topaz",
		},
		{
			name = "Ruby",
		},
		{
			name = "Sapphire + Topaz",
		},
		{
			name = "Sapphire + Ruby",
		},
		{
			name = "Topaz + Ruby",
		},
		{
			name = "All Flasks",
		},
	},
	statMap = {
		["flask_throw_minimum_cold_damage_if_used_sapphire_flask"] = {
			mod("ColdMin", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 2, 5, 6, 8 } }),
		},
		["flask_throw_maximum_cold_damage_if_used_sapphire_flask"] = {
			mod("ColdMax", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 2, 5, 6, 8 } }),
		},
		["flask_throw_minimum_lightning_damage_if_used_topaz_flask"] = {
			mod("LightningMin", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 3, 5, 7, 8 } }),
		},
		["flask_throw_maximum_lightning_damage_if_used_topaz_flask"] = {
			mod("LightningMax", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 3, 5, 7, 8 } }),
		},
		["flask_throw_ruby_flask_critical_strike_multiplier_+"] = {
			mod("CritMultiplier", "BASE", nil, 0, 0, { type = "SkillPart", skillPartList = { 4, 6, 7, 8 } }),
		},
	},
	baseFlags = {
		attack = true,
		area = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "flask_charges_used_+%", -0.75 },
		},
	},
	constantStats = {
		{ "additional_base_critical_strike_chance", 1000 },
		{ "flask_throw_charges_used_per_projectile", 1 },
		{ "active_skill_base_area_of_effect_radius", 18 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"flask_throw_minimum_cold_damage_if_used_sapphire_flask",
		"flask_throw_maximum_cold_damage_if_used_sapphire_flask",
		"flask_throw_minimum_lightning_damage_if_used_topaz_flask",
		"flask_throw_maximum_lightning_damage_if_used_topaz_flask",
		"flask_throw_ruby_flask_critical_strike_multiplier_+",
		"base_is_projectile",
		"is_area_damage",
		"console_skill_dont_chase",
		"projectile_behaviour_only_explode",
		"explosive_concoction_attach_flask_visual_buff",
	},
	levels = {
		[1] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 120, attackSpeedMultiplier = 15, levelRequirement = 28, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 124, attackSpeedMultiplier = 15, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 128, attackSpeedMultiplier = 15, levelRequirement = 34, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 132, attackSpeedMultiplier = 15, levelRequirement = 37, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[5] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 136, attackSpeedMultiplier = 15, levelRequirement = 40, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[6] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 140, attackSpeedMultiplier = 15, levelRequirement = 42, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[7] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 144, attackSpeedMultiplier = 15, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[8] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 148, attackSpeedMultiplier = 15, levelRequirement = 46, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[9] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 152, attackSpeedMultiplier = 15, levelRequirement = 48, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 7, }, },
		[10] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 156, attackSpeedMultiplier = 15, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[11] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 160, attackSpeedMultiplier = 15, levelRequirement = 52, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[12] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 164, attackSpeedMultiplier = 15, levelRequirement = 54, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[13] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 168, attackSpeedMultiplier = 15, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[14] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 172, attackSpeedMultiplier = 15, levelRequirement = 58, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[15] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 176, attackSpeedMultiplier = 15, levelRequirement = 60, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[16] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 180, attackSpeedMultiplier = 15, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[17] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 184, attackSpeedMultiplier = 15, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[18] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 188, attackSpeedMultiplier = 15, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[19] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 192, attackSpeedMultiplier = 15, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[20] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 196, attackSpeedMultiplier = 15, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[21] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 200, attackSpeedMultiplier = 15, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[22] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 204, attackSpeedMultiplier = 15, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[23] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 208, attackSpeedMultiplier = 15, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[24] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 212, attackSpeedMultiplier = 15, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[25] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 216, attackSpeedMultiplier = 15, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[26] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 220, attackSpeedMultiplier = 15, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[27] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 224, attackSpeedMultiplier = 15, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[28] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 228, attackSpeedMultiplier = 15, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[29] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 232, attackSpeedMultiplier = 15, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[30] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 236, attackSpeedMultiplier = 15, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[31] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 240, attackSpeedMultiplier = 15, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[32] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 244, attackSpeedMultiplier = 15, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[33] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 248, attackSpeedMultiplier = 15, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[34] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 252, attackSpeedMultiplier = 15, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[35] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 256, attackSpeedMultiplier = 15, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[36] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 260, attackSpeedMultiplier = 15, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[37] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 264, attackSpeedMultiplier = 15, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[38] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 268, attackSpeedMultiplier = 15, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[39] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 272, attackSpeedMultiplier = 15, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[40] = { 0.31999999284744, 0.47999998927116, 0.28000000119209, 0.41999998688698, 0.059999998658895, 0.69999998807907, 276, attackSpeedMultiplier = 15, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
	},
}
skills["ExplosiveTrap"] = {
	name = "Explosive Trap",
	baseTypeName = "Explosive Trap",
	color = 2,
	baseEffectiveness = 1.6990000009537,
	incrementalEffectiveness = 0.035599999129772,
	description = "Throws a trap that creates an explosion when triggered, dealing spell damage in an area around it. A number of smaller explosions occur within a secondary area around the trap in quick succession after the first.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One explosion hitting",
		},
		{
			name = "Average explosions hitting",
		},
		{
			name = "All explosions hitting",
		},
	},
	preDamageFunc = function(activeSkill, output, breakdown)
		local skillCfg = activeSkill.skillCfg
		local skillData = activeSkill.skillData
		local skillPart = activeSkill.skillPart
		local skillModList = activeSkill.skillModList
		local t_insert = table.insert
		local s_format = string.format

		local function hitChance(enemyRadius, areaDamageRadius, areaSpreadRadius) -- not to be confused with attack hit chance
			local damagingAreaRadius = areaDamageRadius + enemyRadius - 1	-- radius where area damage can land to hit the enemy;
			-- -1 because of two assumptions: PoE coordinates are integers and damage is not registered if the two areas only share a point or vertex. If either is not correct, then -1 is not needed.
			return math.min(damagingAreaRadius * damagingAreaRadius / (areaSpreadRadius * areaSpreadRadius), 1)
		end
		local enemyRadius = skillModList:Override(skillCfg, "EnemyRadius") or skillModList:Sum("BASE", skillCfg, "EnemyRadius")
		local fullRadius = output.AreaOfEffectRadiusSecondary
		local overlapChance = 0
		local marginWidth = skillData.radiusTertiaryBaseMargin * 2 + 1
		for smallRadius, occurrenceCount in pairs(output.AreaOfEffectRadiusTertiaryOccurrences) do
			overlapChance = overlapChance + hitChance(enemyRadius, smallRadius, fullRadius) * occurrenceCount / marginWidth
		end
		output.OverlapChance = overlapChance * 100
		local smallExplosionsPerTrap = skillModList:Sum("BASE", skillCfg, "SmallExplosions")
		output.SmallExplosionsPerTrap = smallExplosionsPerTrap
		if breakdown then
			breakdown.OverlapChance = { }
			t_insert(breakdown.OverlapChance, "Chance for individual small explosion to land within range to damage enemy:")
			t_insert(breakdown.OverlapChance, "^8= (area where a small explosion can spawn to damage enemy) / (total area)")
			t_insert(breakdown.OverlapChance, "^8= (^7tertiary radius^8 + ^7enemy radius^8 - 1) ^ 2 / ^7secondary radius^8 ^ 2")
			t_insert(breakdown.OverlapChance, "^8Result is the weighted sum of overlap chances for each possible tertiary radius")
			local radii = {}
			local numRadii = 0
			for radius in pairs(output.AreaOfEffectRadiusTertiaryOccurrences) do
				t_insert(radii, radius)
				numRadii = numRadii + 1
			end
			table.sort(radii)
			for i, smallRadius in ipairs(radii) do
				t_insert(breakdown.OverlapChance, s_format("^8(^7%d^8 +^7 %d^8 - 1) ^ 2 /^7 %d^8 ^ 2 *^7 %d/%d%s",
					smallRadius, enemyRadius, fullRadius, output.AreaOfEffectRadiusTertiaryOccurrences[smallRadius],
					marginWidth, i == numRadii and "" or " ^8+"))
			end
			t_insert(breakdown.OverlapChance, s_format("^8=^7 %.3f^8%%", output.OverlapChance))
		end
		local dpsMultiplier = 1
		if skillPart == 2 then
			dpsMultiplier = 1 + smallExplosionsPerTrap * overlapChance
			if breakdown then
				breakdown.SkillDPSMultiplier = {}
				t_insert(breakdown.SkillDPSMultiplier, "DPS multiplier")
				t_insert(breakdown.SkillDPSMultiplier, "^8= 1 + ^7small explosions^8 * ^7overlap chance^8")
				t_insert(breakdown.SkillDPSMultiplier, s_format("^8= 1 +^7 %d^8 *^7 %.2f^8", smallExplosionsPerTrap, overlapChance))
				t_insert(breakdown.SkillDPSMultiplier, s_format("^8=^7 %.3f", dpsMultiplier))
			end
		elseif skillPart == 3 then
			dpsMultiplier = 1 + smallExplosionsPerTrap
			if breakdown then
				breakdown.SkillDPSMultiplier = {}
				t_insert(breakdown.SkillDPSMultiplier, "DPS multiplier")
				t_insert(breakdown.SkillDPSMultiplier, s_format("^8= 1 +^7 %d (small explosions)", dpsMultiplier))
			end
		end
		if dpsMultiplier ~= 1 then
			skillData.dpsMultiplier = (skillData.dpsMultiplier or 1) * dpsMultiplier
			output.SkillDPSMultiplier = (output.SkillDPSMultiplier or 1) * dpsMultiplier
		end
	end,
	statMap = {
		["shrapnel_trap_number_of_secondary_explosions"] = {
			mod("SmallExplosions", "BASE", nil),
		},
		["quality_display_explosive_trap_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "Primary Explosion:"),
		skill("radiusSecondaryLabel", "Secondary Area:"),
		skill("radiusTertiaryLabel", "Secondary Explosion:"),
		skill("radiusTertiaryBaseMargin", 30),
	},
	qualityStats = {
		Default = {
			{ "shrapnel_trap_number_of_secondary_explosions", 0.1 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "active_skill_base_area_of_effect_radius", 12 },
		{ "active_skill_base_secondary_area_of_effect_radius", 12 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 7 },
		{ "active_skill_area_of_effect_description_mode", 1 },
		{ "active_skill_tertiary_area_of_effect_description_mode", 3 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"shrapnel_trap_number_of_secondary_explosions",
		"active_skill_base_area_of_effect_radius",
		"active_skill_base_secondary_area_of_effect_radius",
		"active_skill_base_tertiary_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
		"quality_display_explosive_trap_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.56999999284744, 0.86000001430511, 3, 0, 0, 0, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.64999997615814, 0.97000002861023, 3, 0, 0, 0, critChance = 6, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.72000002861023, 1.0800000429153, 3, 1, 1, 1, critChance = 6, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 3, 1, 1, 1, critChance = 6, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 4, 1, 1, 1, critChance = 6, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 5, 4, 4, 4, critChance = 6, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 6, 4, 4, 4, critChance = 6, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 6, 4, 4, 4, critChance = 6, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 6, 5, 5, 5, critChance = 6, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 6, 5, 5, 5, critChance = 6, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 7, 5, 5, 5, critChance = 6, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 8, 8, 8, 8, critChance = 6, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 8, 8, 8, 8, critChance = 6, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 9, 8, 8, 8, critChance = 6, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 9, 10, 10, 10, critChance = 6, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 9, 10, 10, 10, critChance = 6, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 29, }, },
	},
}
skills["ExplosiveTrapAltX"] = {
	name = "Explosive Trap of Shrapnel",
	baseTypeName = "Explosive Trap of Shrapnel",
	color = 2,
	baseEffectiveness = 2.4700000286102,
	incrementalEffectiveness = 0.035599999129772,
	description = "Throws a trap that creates an explosion when triggered, dealing spell damage in an area around it. A number of smaller explosions occur within a secondary area around the trap in quick succession after the first.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = skills.ExplosiveTrap.parts,
	preDamageFunc = skills.ExplosiveTrap.preDamageFunc,
	statMap = skills.ExplosiveTrap.statMap,
	baseMods = skills.ExplosiveTrap.baseMods,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "shrapnel_trap_number_of_secondary_explosions", 0.1 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "active_skill_base_area_of_effect_radius", 12 },
		{ "active_skill_base_secondary_area_of_effect_radius", 24 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 7 },
		{ "active_skill_area_of_effect_description_mode", 1 },
		{ "active_skill_tertiary_area_of_effect_description_mode", 3 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"shrapnel_trap_number_of_secondary_explosions",
		"active_skill_base_area_of_effect_radius",
		"active_skill_base_secondary_area_of_effect_radius",
		"active_skill_base_tertiary_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
		"quality_display_explosive_trap_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.56999999284744, 0.86000001430511, 3, 0, 0, 0, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 0.64999997615814, 0.97000002861023, 3, 0, 0, 0, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 0.72000002861023, 1.0800000429153, 3, 1, 1, 1, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 3, 1, 1, 1, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 7, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 4, 1, 1, 1, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 16, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 11, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 4, 2, 2, 2, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 24, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 12, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 13, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 5, 3, 3, 3, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 14, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 5, 4, 4, 4, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 15, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 6, 4, 4, 4, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 6, 4, 4, 4, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 16, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 6, 5, 5, 5, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 17, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 6, 5, 5, 5, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 7, 5, 5, 5, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 7, 6, 6, 6, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 8, 7, 7, 7, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 8, 8, 8, 8, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 8, 8, 8, 8, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 9, 8, 8, 8, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 9, 9, 9, 9, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 9, 10, 10, 10, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 9, 10, 10, 10, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 91, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 92, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 93, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 25, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 10, 10, 10, 10, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 94, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 26, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 95, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 96, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 97, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 27, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 98, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 99, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 28, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 10, 11, 11, 11, critChance = 6, damageEffectiveness = 1.4, levelRequirement = 100, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 29, }, },
	},
}
skills["ExplosiveTrapAltY"] = {
	name = "Explosive Trap of Magnitude",
	baseTypeName = "Explosive Trap of Magnitude",
	color = 2,
	baseEffectiveness = 5.75,
	incrementalEffectiveness = 0.035599999129772,
	description = "Throws a trap that creates a large explosion when triggered, dealing spell damage in an area around it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_area_of_effect_radius", 0.15 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "active_skill_base_area_of_effect_radius", 18 },
		{ "active_skill_area_of_effect_description_mode", 1 },
		{ "active_skill_trap_throwing_speed_+%_final", -30 },
		{ "base_stun_duration_+%", 50 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_base_area_of_effect_radius",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.56999999284744, 0.86000001430511, 0, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { Mana = 8, }, },
		[2] = { 0.64999997615814, 0.97000002861023, 0, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 0.72000002861023, 1.0800000429153, 1, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { Mana = 10, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { Mana = 11, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 1, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { Mana = 12, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { Mana = 13, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { Mana = 14, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 2, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { Mana = 15, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { Mana = 16, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { Mana = 17, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 3, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { Mana = 19, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { Mana = 20, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { Mana = 21, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 4, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { Mana = 22, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 5, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { Mana = 23, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 5, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { Mana = 24, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 5, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { Mana = 25, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { Mana = 26, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { Mana = 27, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 6, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { Mana = 28, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { Mana = 29, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { Mana = 30, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 7, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { Mana = 31, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { Mana = 32, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { Mana = 33, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 8, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { Mana = 34, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { Mana = 35, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { Mana = 36, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 9, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { Mana = 37, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { Mana = 39, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 91, statInterpolation = { 3, 3, 1, }, cost = { Mana = 39, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 92, statInterpolation = { 3, 3, 1, }, cost = { Mana = 40, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 93, statInterpolation = { 3, 3, 1, }, cost = { Mana = 40, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 10, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 94, statInterpolation = { 3, 3, 1, }, cost = { Mana = 41, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 95, statInterpolation = { 3, 3, 1, }, cost = { Mana = 41, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 96, statInterpolation = { 3, 3, 1, }, cost = { Mana = 42, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 97, statInterpolation = { 3, 3, 1, }, cost = { Mana = 42, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 98, statInterpolation = { 3, 3, 1, }, cost = { Mana = 43, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 99, statInterpolation = { 3, 3, 1, }, cost = { Mana = 43, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 11, critChance = 6, damageEffectiveness = 3.3, levelRequirement = 100, statInterpolation = { 3, 3, 1, }, cost = { Mana = 44, }, },
	},
}
skills["FireTrap"] = {
	name = "Fire Trap",
	baseTypeName = "Fire Trap",
	color = 2,
	baseEffectiveness = 2.1289000511169,
	incrementalEffectiveness = 0.057300001382828,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies and leaving an area of burning ground that damages enemies who walk through it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		flag("dotIsBurningGround"),
		skill("radius", 15),
	},
	qualityStats = {
		Default = {
			{ "trap_trigger_radius_+%", 4 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "base_skill_effect_duration", 1750 },
		{ "trap_variation", 22 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"global_minimum_added_fire_damage_vs_burning_enemies",
		"global_maximum_added_fire_damage_vs_burning_enemies",
		"active_skill_base_radius_+",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_damage_modifiers_apply_to_skill_dot",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 0, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[2] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 0, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[3] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 1, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[4] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 1, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[5] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 2, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[6] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 2, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[7] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 3, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[8] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 3, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[9] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[10] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[12] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 5, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 15, }, },
		[13] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 5, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 16, }, },
		[14] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 6, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 16, }, },
		[15] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 6, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 17, }, },
		[16] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 7, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 7, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 19, }, },
		[19] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 10, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 10, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[27] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 12, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 12, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 26, }, },
		[32] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 26, }, },
		[33] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 27, }, },
		[34] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 27, }, },
		[35] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 28, }, },
		[36] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 29, }, },
		[37] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 29, }, },
		[38] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 30, }, },
		[39] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 30, }, },
		[40] = { 0.31999999284744, 0.47999998927116, 53.833334854494, 0.10000000149012, 0.15000000596046, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 3, 1, }, cost = { Mana = 31, }, },
	},
}
skills["FireTrapAltX"] = {
	name = "Fire Trap of Blasting",
	baseTypeName = "Fire Trap of Blasting",
	color = 2,
	baseEffectiveness = 0.85159999132156,
	incrementalEffectiveness = 0.057300001382828,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		Default = {
			{ "trap_trigger_radius_+%", 4 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "trap_variation", 22 },
		{ "trap_%_chance_to_trigger_twice", 50 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"global_minimum_added_fire_damage_vs_burning_enemies",
		"global_maximum_added_fire_damage_vs_burning_enemies",
		"active_skill_base_radius_+",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 0, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 12, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[2] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 0, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 15, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 8, }, },
		[3] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 1, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 19, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 9, }, },
		[4] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 1, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 23, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[5] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 2, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 27, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 10, }, },
		[6] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 2, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 31, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[7] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 3, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 35, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 11, }, },
		[8] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 3, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 38, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 12, }, },
		[9] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 41, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 13, }, },
		[10] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 44, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[11] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 4, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 47, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 14, }, },
		[12] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 5, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 50, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 15, }, },
		[13] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 5, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 53, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 16, }, },
		[14] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 6, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 56, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 16, }, },
		[15] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 6, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 59, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 17, }, },
		[16] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 7, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 62, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 18, }, },
		[17] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 7, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 64, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 18, }, },
		[18] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 66, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 19, }, },
		[19] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 19, }, },
		[20] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 8, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 70, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 20, }, },
		[21] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 72, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 20, }, },
		[22] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 9, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 74, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[23] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 10, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 76, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[24] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 10, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 78, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 21, }, },
		[25] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 80, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 22, }, },
		[26] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 82, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[27] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 11, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 84, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[28] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 12, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 86, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 23, }, },
		[29] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 12, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 88, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 24, }, },
		[30] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 90, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 24, }, },
		[31] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 91, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 26, }, },
		[32] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 92, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 26, }, },
		[33] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 13, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 93, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 27, }, },
		[34] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 94, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 27, }, },
		[35] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 95, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 28, }, },
		[36] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 96, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 29, }, },
		[37] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 14, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 97, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 29, }, },
		[38] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 98, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 30, }, },
		[39] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 99, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 30, }, },
		[40] = { 0.31999999284744, 0.47999998927116, 0.76999998092651, 1.1499999761581, 15, critChance = 6, damageEffectiveness = 2.6, levelRequirement = 100, statInterpolation = { 3, 3, 3, 3, 1, }, cost = { Mana = 31, }, },
	},
}
skills["FlamethrowerTrap"] = {
	name = "Flamethrower Trap",
	baseTypeName = "Flamethrower Trap",
	color = 2,
	baseEffectiveness = 0.11810000240803,
	incrementalEffectiveness = 0.058899998664856,
	description = "Throws a trap that releases a number of flames in different directions around it when triggered. The flames last for a duration, rotating around the trap and repeatedly dealing damage. Burning enemies are dealt more damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One trap (good placement)",
		},
		{
			name = "One trap (bad placement)",
		},
		{
			name = "Average # traps (good placement)",
		},
		{
			name = "Average # traps (bad placement)",
		},
	},
	preDamageFunc = function(activeSkill, output, breakdown)
		-- Unknown stats provided by asking GGG
		local t_insert = table.insert
		local s_format = string.format

		local duration = output.Duration
		local cooldown = output.TrapCooldown
		local averageActiveTraps = duration / cooldown
		output.AverageActiveTraps = averageActiveTraps
		if activeSkill.skillPart == 2 or activeSkill.skillPart == 4 then
			activeSkill.skillData.hitTimeOverride = 0.3
		else
			activeSkill.skillData.hitTimeOverride = 0.1
		end

		if activeSkill.skillPart == 3 or activeSkill.skillPart == 4 then
			activeSkill.skillData.dpsMultiplier = (activeSkill.skillData.dpsMultiplier or 1) * averageActiveTraps
		end

		if breakdown then
			breakdown.AverageActiveTraps = { }
			t_insert(breakdown.AverageActiveTraps, "Average active traps, not considering stored cooldown uses:")
			t_insert(breakdown.AverageActiveTraps, s_format("%.2f^8 (skill duration)", duration))
			t_insert(breakdown.AverageActiveTraps, s_format("/ %.2f^8 (cooldown)", cooldown))
			t_insert(breakdown.AverageActiveTraps, s_format("= %.2f traps", averageActiveTraps))
		end
	end,
	statMap = {
		["flamethrower_trap_damage_+%_final_vs_burning_enemies"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "ActorCondition", actor = "enemy", var = "Burning" }),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 32),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "base_skill_effect_duration", 3500 },
		{ "flamethrower_trap_damage_+%_final_vs_burning_enemies", 25 },
		{ "flamethrower_tower_trap_number_of_flamethrowers", 4 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, critChance = 5, damageEffectiveness = 0.15, levelRequirement = 28, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[2] = { 0.8299999833107, 1.25, cooldown = 8, critChance = 5, damageEffectiveness = 0.15, levelRequirement = 31, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[3] = { 0.86000001430511, 1.289999961853, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 34, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[4] = { 0.88999998569489, 1.3400000333786, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 37, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[5] = { 0.9200000166893, 1.3899999856949, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 40, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[6] = { 0.94999998807907, 1.4299999475479, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 42, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[7] = { 0.98000001907349, 1.4800000190735, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 44, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[8] = { 1.0099999904633, 1.5199999809265, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 46, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[9] = { 1.039999961853, 1.5700000524521, cooldown = 8, critChance = 5, damageEffectiveness = 0.2, levelRequirement = 48, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[10] = { 1.0700000524521, 1.6200000047684, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 50, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[11] = { 1.1100000143051, 1.6599999666214, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 52, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[12] = { 1.1399999856949, 1.710000038147, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 54, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[13] = { 1.1699999570847, 1.7599999904633, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 56, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[14] = { 1.2000000476837, 1.7999999523163, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 58, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[15] = { 1.2300000190735, 1.8500000238419, cooldown = 8, critChance = 5, damageEffectiveness = 0.25, levelRequirement = 60, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[16] = { 1.2599999904633, 1.8899999856949, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 62, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[17] = { 1.289999961853, 1.9400000572205, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 64, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[18] = { 1.3200000524521, 1.9900000095367, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 66, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[19] = { 1.3500000238419, 2.0299999713898, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 68, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[20] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 70, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[21] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 72, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[22] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 74, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[23] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 76, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[24] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 78, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[25] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 80, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[26] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 82, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[27] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 84, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[28] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 86, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[29] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 88, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[30] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 90, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[31] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 91, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[32] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 92, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[33] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 93, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[34] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 94, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 33, }, },
		[35] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 95, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 34, }, },
		[36] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 96, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 35, }, },
		[37] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 97, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 35, }, },
		[38] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 98, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 36, }, },
		[39] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 99, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 36, }, },
		[40] = { 1.3799999952316, 2.0799999237061, cooldown = 8, critChance = 5, damageEffectiveness = 0.3, levelRequirement = 100, storedUses = 3, statInterpolation = { 3, 3, }, cost = { Mana = 37, }, },
	},
}
skills["FlickerStrike"] = {
	name = "Flicker Strike",
	baseTypeName = "Flicker Strike",
	color = 2,
	baseEffectiveness = 0,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["flicker_strike_buff_movement_speed_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "add_frenzy_charge_on_skill_hit_%", 0.5 },
		},
	},
	constantStats = {
		{ "base_attack_speed_+%_per_frenzy_charge", 10 },
		{ "add_frenzy_charge_on_skill_hit_%", 15 },
		{ "flicker_strike_buff_movement_speed_+%", 20 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"melee_defer_damage_prediction",
	},
	levels = {
		[1] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.773, cooldown = 2, damageEffectiveness = 1.773, levelRequirement = 10, storedUses = 1, cost = { Mana = 5, }, },
		[2] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.853, cooldown = 2, damageEffectiveness = 1.853, levelRequirement = 13, storedUses = 1, cost = { Mana = 5, }, },
		[3] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.94, cooldown = 2, damageEffectiveness = 1.94, levelRequirement = 17, storedUses = 1, cost = { Mana = 6, }, },
		[4] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.03, cooldown = 2, damageEffectiveness = 2.03, levelRequirement = 21, storedUses = 1, cost = { Mana = 6, }, },
		[5] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.125, cooldown = 2, damageEffectiveness = 2.125, levelRequirement = 25, storedUses = 1, cost = { Mana = 6, }, },
		[6] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.224, cooldown = 2, damageEffectiveness = 2.224, levelRequirement = 29, storedUses = 1, cost = { Mana = 6, }, },
		[7] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.327, cooldown = 2, damageEffectiveness = 2.327, levelRequirement = 33, storedUses = 1, cost = { Mana = 6, }, },
		[8] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.432, cooldown = 2, damageEffectiveness = 2.432, levelRequirement = 36, storedUses = 1, cost = { Mana = 7, }, },
		[9] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.54, cooldown = 2, damageEffectiveness = 2.54, levelRequirement = 39, storedUses = 1, cost = { Mana = 7, }, },
		[10] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.654, cooldown = 2, damageEffectiveness = 2.654, levelRequirement = 42, storedUses = 1, cost = { Mana = 7, }, },
		[11] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.773, cooldown = 2, damageEffectiveness = 2.773, levelRequirement = 45, storedUses = 1, cost = { Mana = 7, }, },
		[12] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.896, cooldown = 2, damageEffectiveness = 2.896, levelRequirement = 48, storedUses = 1, cost = { Mana = 7, }, },
		[13] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.025, cooldown = 2, damageEffectiveness = 3.025, levelRequirement = 51, storedUses = 1, cost = { Mana = 7, }, },
		[14] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.16, cooldown = 2, damageEffectiveness = 3.16, levelRequirement = 54, storedUses = 1, cost = { Mana = 8, }, },
		[15] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.301, cooldown = 2, damageEffectiveness = 3.301, levelRequirement = 57, storedUses = 1, cost = { Mana = 8, }, },
		[16] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.447, cooldown = 2, damageEffectiveness = 3.447, levelRequirement = 60, storedUses = 1, cost = { Mana = 8, }, },
		[17] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.6, cooldown = 2, damageEffectiveness = 3.6, levelRequirement = 63, storedUses = 1, cost = { Mana = 8, }, },
		[18] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.761, cooldown = 2, damageEffectiveness = 3.761, levelRequirement = 66, storedUses = 1, cost = { Mana = 8, }, },
		[19] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.921, cooldown = 2, damageEffectiveness = 3.921, levelRequirement = 68, storedUses = 1, cost = { Mana = 8, }, },
		[20] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.089, cooldown = 2, damageEffectiveness = 4.089, levelRequirement = 70, storedUses = 1, cost = { Mana = 8, }, },
		[21] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.263, cooldown = 2, damageEffectiveness = 4.263, levelRequirement = 72, storedUses = 1, cost = { Mana = 8, }, },
		[22] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.445, cooldown = 2, damageEffectiveness = 4.445, levelRequirement = 74, storedUses = 1, cost = { Mana = 9, }, },
		[23] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.635, cooldown = 2, damageEffectiveness = 4.635, levelRequirement = 76, storedUses = 1, cost = { Mana = 9, }, },
		[24] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.833, cooldown = 2, damageEffectiveness = 4.833, levelRequirement = 78, storedUses = 1, cost = { Mana = 9, }, },
		[25] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.038, cooldown = 2, damageEffectiveness = 5.038, levelRequirement = 80, storedUses = 1, cost = { Mana = 9, }, },
		[26] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.253, cooldown = 2, damageEffectiveness = 5.253, levelRequirement = 82, storedUses = 1, cost = { Mana = 9, }, },
		[27] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.477, cooldown = 2, damageEffectiveness = 5.477, levelRequirement = 84, storedUses = 1, cost = { Mana = 9, }, },
		[28] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.71, cooldown = 2, damageEffectiveness = 5.71, levelRequirement = 86, storedUses = 1, cost = { Mana = 9, }, },
		[29] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.953, cooldown = 2, damageEffectiveness = 5.953, levelRequirement = 88, storedUses = 1, cost = { Mana = 9, }, },
		[30] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.206, cooldown = 2, damageEffectiveness = 6.206, levelRequirement = 90, storedUses = 1, cost = { Mana = 9, }, },
		[31] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.587, cooldown = 2, damageEffectiveness = 6.587, levelRequirement = 91, storedUses = 1, cost = { Mana = 10, }, },
		[32] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.727, cooldown = 2, damageEffectiveness = 6.727, levelRequirement = 92, storedUses = 1, cost = { Mana = 10, }, },
		[33] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.87, cooldown = 2, damageEffectiveness = 6.87, levelRequirement = 93, storedUses = 1, cost = { Mana = 10, }, },
		[34] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.017, cooldown = 2, damageEffectiveness = 7.017, levelRequirement = 94, storedUses = 1, cost = { Mana = 10, }, },
		[35] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.165, cooldown = 2, damageEffectiveness = 7.165, levelRequirement = 95, storedUses = 1, cost = { Mana = 10, }, },
		[36] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.318, cooldown = 2, damageEffectiveness = 7.318, levelRequirement = 96, storedUses = 1, cost = { Mana = 10, }, },
		[37] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.473, cooldown = 2, damageEffectiveness = 7.473, levelRequirement = 97, storedUses = 1, cost = { Mana = 10, }, },
		[38] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.632, cooldown = 2, damageEffectiveness = 7.632, levelRequirement = 98, storedUses = 1, cost = { Mana = 10, }, },
		[39] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.794, cooldown = 2, damageEffectiveness = 7.794, levelRequirement = 99, storedUses = 1, cost = { Mana = 10, }, },
		[40] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.96, cooldown = 2, damageEffectiveness = 7.96, levelRequirement = 100, storedUses = 1, cost = { Mana = 10, }, },
	},
}
skills["FlickerStrikeAltX"] = {
	name = "Flicker Strike of Power",
	baseTypeName = "Flicker Strike of Power",
	color = 2,
	baseEffectiveness = 0,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Power Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["flicker_strike_buff_movement_speed_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "add_power_charge_on_critical_strike_%", 1 },
		},
	},
	constantStats = {
		{ "flicker_strike_buff_movement_speed_+%", 20 },
		{ "base_skill_effect_duration", 3000 },
		{ "critical_strike_chance_+%_per_power_charge", 50 },
		{ "add_power_charge_on_critical_strike_%", 30 },
	},
	stats = {
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"melee_defer_damage_prediction",
		"active_skill_cooldown_bypass_type_override_to_power_charge",
	},
	levels = {
		[1] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.773, cooldown = 2, damageEffectiveness = 1.773, levelRequirement = 10, storedUses = 1, cost = { Mana = 5, }, },
		[2] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.853, cooldown = 2, damageEffectiveness = 1.853, levelRequirement = 13, storedUses = 1, cost = { Mana = 5, }, },
		[3] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 1.94, cooldown = 2, damageEffectiveness = 1.94, levelRequirement = 17, storedUses = 1, cost = { Mana = 6, }, },
		[4] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.03, cooldown = 2, damageEffectiveness = 2.03, levelRequirement = 21, storedUses = 1, cost = { Mana = 6, }, },
		[5] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.125, cooldown = 2, damageEffectiveness = 2.125, levelRequirement = 25, storedUses = 1, cost = { Mana = 6, }, },
		[6] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.224, cooldown = 2, damageEffectiveness = 2.224, levelRequirement = 29, storedUses = 1, cost = { Mana = 6, }, },
		[7] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.327, cooldown = 2, damageEffectiveness = 2.327, levelRequirement = 33, storedUses = 1, cost = { Mana = 6, }, },
		[8] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.432, cooldown = 2, damageEffectiveness = 2.432, levelRequirement = 36, storedUses = 1, cost = { Mana = 7, }, },
		[9] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.54, cooldown = 2, damageEffectiveness = 2.54, levelRequirement = 39, storedUses = 1, cost = { Mana = 7, }, },
		[10] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.654, cooldown = 2, damageEffectiveness = 2.654, levelRequirement = 42, storedUses = 1, cost = { Mana = 7, }, },
		[11] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.773, cooldown = 2, damageEffectiveness = 2.773, levelRequirement = 45, storedUses = 1, cost = { Mana = 7, }, },
		[12] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 2.896, cooldown = 2, damageEffectiveness = 2.896, levelRequirement = 48, storedUses = 1, cost = { Mana = 7, }, },
		[13] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.025, cooldown = 2, damageEffectiveness = 3.025, levelRequirement = 51, storedUses = 1, cost = { Mana = 7, }, },
		[14] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.16, cooldown = 2, damageEffectiveness = 3.16, levelRequirement = 54, storedUses = 1, cost = { Mana = 8, }, },
		[15] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.301, cooldown = 2, damageEffectiveness = 3.301, levelRequirement = 57, storedUses = 1, cost = { Mana = 8, }, },
		[16] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.447, cooldown = 2, damageEffectiveness = 3.447, levelRequirement = 60, storedUses = 1, cost = { Mana = 8, }, },
		[17] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.6, cooldown = 2, damageEffectiveness = 3.6, levelRequirement = 63, storedUses = 1, cost = { Mana = 8, }, },
		[18] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.761, cooldown = 2, damageEffectiveness = 3.761, levelRequirement = 66, storedUses = 1, cost = { Mana = 8, }, },
		[19] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 3.921, cooldown = 2, damageEffectiveness = 3.921, levelRequirement = 68, storedUses = 1, cost = { Mana = 8, }, },
		[20] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.089, cooldown = 2, damageEffectiveness = 4.089, levelRequirement = 70, storedUses = 1, cost = { Mana = 8, }, },
		[21] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.263, cooldown = 2, damageEffectiveness = 4.263, levelRequirement = 72, storedUses = 1, cost = { Mana = 8, }, },
		[22] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.445, cooldown = 2, damageEffectiveness = 4.445, levelRequirement = 74, storedUses = 1, cost = { Mana = 9, }, },
		[23] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.635, cooldown = 2, damageEffectiveness = 4.635, levelRequirement = 76, storedUses = 1, cost = { Mana = 9, }, },
		[24] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 4.833, cooldown = 2, damageEffectiveness = 4.833, levelRequirement = 78, storedUses = 1, cost = { Mana = 9, }, },
		[25] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.038, cooldown = 2, damageEffectiveness = 5.038, levelRequirement = 80, storedUses = 1, cost = { Mana = 9, }, },
		[26] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.253, cooldown = 2, damageEffectiveness = 5.253, levelRequirement = 82, storedUses = 1, cost = { Mana = 9, }, },
		[27] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.477, cooldown = 2, damageEffectiveness = 5.477, levelRequirement = 84, storedUses = 1, cost = { Mana = 9, }, },
		[28] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.71, cooldown = 2, damageEffectiveness = 5.71, levelRequirement = 86, storedUses = 1, cost = { Mana = 9, }, },
		[29] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 5.953, cooldown = 2, damageEffectiveness = 5.953, levelRequirement = 88, storedUses = 1, cost = { Mana = 9, }, },
		[30] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.206, cooldown = 2, damageEffectiveness = 6.206, levelRequirement = 90, storedUses = 1, cost = { Mana = 9, }, },
		[31] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.587, cooldown = 2, damageEffectiveness = 6.587, levelRequirement = 91, storedUses = 1, cost = { Mana = 10, }, },
		[32] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.727, cooldown = 2, damageEffectiveness = 6.727, levelRequirement = 92, storedUses = 1, cost = { Mana = 10, }, },
		[33] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 6.87, cooldown = 2, damageEffectiveness = 6.87, levelRequirement = 93, storedUses = 1, cost = { Mana = 10, }, },
		[34] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.017, cooldown = 2, damageEffectiveness = 7.017, levelRequirement = 94, storedUses = 1, cost = { Mana = 10, }, },
		[35] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.165, cooldown = 2, damageEffectiveness = 7.165, levelRequirement = 95, storedUses = 1, cost = { Mana = 10, }, },
		[36] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.318, cooldown = 2, damageEffectiveness = 7.318, levelRequirement = 96, storedUses = 1, cost = { Mana = 10, }, },
		[37] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.473, cooldown = 2, damageEffectiveness = 7.473, levelRequirement = 97, storedUses = 1, cost = { Mana = 10, }, },
		[38] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.632, cooldown = 2, damageEffectiveness = 7.632, levelRequirement = 98, storedUses = 1, cost = { Mana = 10, }, },
		[39] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.794, cooldown = 2, damageEffectiveness = 7.794, levelRequirement = 99, storedUses = 1, cost = { Mana = 10, }, },
		[40] = { PvPDamageMultiplier = -30, attackSpeedMultiplier = 20, baseMultiplier = 7.96, cooldown = 2, damageEffectiveness = 7.96, levelRequirement = 100, storedUses = 1, cost = { Mana = 10, }, },
	},
}
skills["VaalFlickerStrike"] = {
	name = "Vaal Flicker Strike",
	baseTypeName = "Vaal Flicker Strike",
	color = 2,
	description = "Repeatedly teleports to enemies and hits them, inflicting a wound but dealing no damage. After the repeating finishes, each enemy is hit by the total damage of their wounds, which are removed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, [SkillType.Vaal] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["active_skill_ailment_damage_+%_final"] = {
			mod("Damage", "MORE", nil, bit.bor(ModFlag.MeleeHit, ModFlag.Ailment)),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["base_melee_attack_repeat_count"] = {
			mod("RepeatCount", "BASE", nil)
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
		flag("OnlyFinalRepeat"),
		flag("FinalRepeatSumsDamage"),
	},
	qualityStats = {
		Default = {
			{ "add_frenzy_charge_on_skill_hit_%", 0.5 },
		},
	},
	constantStats = {
		{ "base_attack_speed_+%_per_frenzy_charge", 10 },
		{ "add_frenzy_charge_on_skill_hit_%", 30 },
		{ "base_melee_attack_repeat_count", 25 },
		{ "active_skill_ailment_damage_+%_final", -70 },
	},
	stats = {
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"melee_defer_damage_prediction",
		"apply_cut_debuff_on_hit",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 200, baseMultiplier = 1.744, damageEffectiveness = 1.744, levelRequirement = 10, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[2] = { attackSpeedMultiplier = 200, baseMultiplier = 1.813, damageEffectiveness = 1.813, levelRequirement = 13, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[3] = { attackSpeedMultiplier = 200, baseMultiplier = 1.884, damageEffectiveness = 1.884, levelRequirement = 17, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[4] = { attackSpeedMultiplier = 200, baseMultiplier = 1.958, damageEffectiveness = 1.958, levelRequirement = 21, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[5] = { attackSpeedMultiplier = 200, baseMultiplier = 2.035, damageEffectiveness = 2.035, levelRequirement = 25, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[6] = { attackSpeedMultiplier = 200, baseMultiplier = 2.114, damageEffectiveness = 2.114, levelRequirement = 29, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[7] = { attackSpeedMultiplier = 200, baseMultiplier = 2.197, damageEffectiveness = 2.197, levelRequirement = 33, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[8] = { attackSpeedMultiplier = 200, baseMultiplier = 2.284, damageEffectiveness = 2.284, levelRequirement = 36, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[9] = { attackSpeedMultiplier = 200, baseMultiplier = 2.373, damageEffectiveness = 2.373, levelRequirement = 39, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[10] = { attackSpeedMultiplier = 200, baseMultiplier = 2.467, damageEffectiveness = 2.467, levelRequirement = 42, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[11] = { attackSpeedMultiplier = 200, baseMultiplier = 2.564, damageEffectiveness = 2.564, levelRequirement = 45, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[12] = { attackSpeedMultiplier = 200, baseMultiplier = 2.664, damageEffectiveness = 2.664, levelRequirement = 48, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[13] = { attackSpeedMultiplier = 200, baseMultiplier = 2.769, damageEffectiveness = 2.769, levelRequirement = 51, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[14] = { attackSpeedMultiplier = 200, baseMultiplier = 2.878, damageEffectiveness = 2.878, levelRequirement = 54, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[15] = { attackSpeedMultiplier = 200, baseMultiplier = 2.991, damageEffectiveness = 2.991, levelRequirement = 57, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[16] = { attackSpeedMultiplier = 200, baseMultiplier = 3.108, damageEffectiveness = 3.108, levelRequirement = 60, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[17] = { attackSpeedMultiplier = 200, baseMultiplier = 3.23, damageEffectiveness = 3.23, levelRequirement = 63, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[18] = { attackSpeedMultiplier = 200, baseMultiplier = 3.357, damageEffectiveness = 3.357, levelRequirement = 66, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[19] = { attackSpeedMultiplier = 200, baseMultiplier = 3.489, damageEffectiveness = 3.489, levelRequirement = 68, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[20] = { attackSpeedMultiplier = 200, baseMultiplier = 3.626, damageEffectiveness = 3.626, levelRequirement = 70, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[21] = { attackSpeedMultiplier = 200, baseMultiplier = 3.768, damageEffectiveness = 3.768, levelRequirement = 72, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[22] = { attackSpeedMultiplier = 200, baseMultiplier = 3.916, damageEffectiveness = 3.916, levelRequirement = 74, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[23] = { attackSpeedMultiplier = 200, baseMultiplier = 4.07, damageEffectiveness = 4.07, levelRequirement = 76, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[24] = { attackSpeedMultiplier = 200, baseMultiplier = 4.23, damageEffectiveness = 4.23, levelRequirement = 78, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[25] = { attackSpeedMultiplier = 200, baseMultiplier = 4.396, damageEffectiveness = 4.396, levelRequirement = 80, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[26] = { attackSpeedMultiplier = 200, baseMultiplier = 4.568, damageEffectiveness = 4.568, levelRequirement = 82, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[27] = { attackSpeedMultiplier = 200, baseMultiplier = 4.748, damageEffectiveness = 4.748, levelRequirement = 84, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[28] = { attackSpeedMultiplier = 200, baseMultiplier = 4.934, damageEffectiveness = 4.934, levelRequirement = 86, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[29] = { attackSpeedMultiplier = 200, baseMultiplier = 5.128, damageEffectiveness = 5.128, levelRequirement = 88, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[30] = { attackSpeedMultiplier = 200, baseMultiplier = 5.329, damageEffectiveness = 5.329, levelRequirement = 90, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[31] = { attackSpeedMultiplier = 200, baseMultiplier = 5.647, damageEffectiveness = 5.647, levelRequirement = 91, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[32] = { attackSpeedMultiplier = 200, baseMultiplier = 5.758, damageEffectiveness = 5.758, levelRequirement = 92, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[33] = { attackSpeedMultiplier = 200, baseMultiplier = 5.871, damageEffectiveness = 5.871, levelRequirement = 93, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[34] = { attackSpeedMultiplier = 200, baseMultiplier = 5.987, damageEffectiveness = 5.987, levelRequirement = 94, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[35] = { attackSpeedMultiplier = 200, baseMultiplier = 6.104, damageEffectiveness = 6.104, levelRequirement = 95, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[36] = { attackSpeedMultiplier = 200, baseMultiplier = 6.224, damageEffectiveness = 6.224, levelRequirement = 96, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[37] = { attackSpeedMultiplier = 200, baseMultiplier = 6.346, damageEffectiveness = 6.346, levelRequirement = 97, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[38] = { attackSpeedMultiplier = 200, baseMultiplier = 6.471, damageEffectiveness = 6.471, levelRequirement = 98, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[39] = { attackSpeedMultiplier = 200, baseMultiplier = 6.598, damageEffectiveness = 6.598, levelRequirement = 99, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
		[40] = { attackSpeedMultiplier = 200, baseMultiplier = 6.728, damageEffectiveness = 6.728, levelRequirement = 100, soulPreventionDuration = 6, vaalStoredUses = 1, cost = { Soul = 30, }, },
	},
}
skills["Frenzy"] = {
	name = "Frenzy",
	baseTypeName = "Frenzy",
	color = 2,
	baseEffectiveness = 0,
	description = "Performs an attack with a ranged weapon that gives the character a frenzy charge if it hits. Frenzy charges increase your attack speed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.WandAttack] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Wand"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["frenzy_skill_attack_damage_+%_final_per_frenzy_charge"] = {
			mod("Damage", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
		["frenzy_skill_attack_speed_+%_final_per_frenzy_charge"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
		["quality_display_frenzy_is_gem"] = {
			-- Display only
		},
		["quality_display_active_skill_attack_speed_per_frenzy_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "frenzy_skill_attack_damage_+%_final_per_frenzy_charge", 0.1 },
			{ "frenzy_skill_attack_speed_+%_final_per_frenzy_charge", 0.1 },
		},
	},
	constantStats = {
		{ "frenzy_skill_attack_damage_+%_final_per_frenzy_charge", 5 },
		{ "frenzy_skill_attack_speed_+%_final_per_frenzy_charge", 5 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"quality_display_frenzy_is_gem",
		"quality_display_active_skill_attack_speed_per_frenzy_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 1.15, damageEffectiveness = 1.15, levelRequirement = 16, cost = { Mana = 7, }, },
		[2] = { baseMultiplier = 1.161, damageEffectiveness = 1.16, levelRequirement = 20, cost = { Mana = 7, }, },
		[3] = { baseMultiplier = 1.171, damageEffectiveness = 1.17, levelRequirement = 24, cost = { Mana = 7, }, },
		[4] = { baseMultiplier = 1.182, damageEffectiveness = 1.18, levelRequirement = 28, cost = { Mana = 7, }, },
		[5] = { baseMultiplier = 1.192, damageEffectiveness = 1.19, levelRequirement = 31, cost = { Mana = 8, }, },
		[6] = { baseMultiplier = 1.203, damageEffectiveness = 1.2, levelRequirement = 34, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 1.213, damageEffectiveness = 1.21, levelRequirement = 37, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 1.224, damageEffectiveness = 1.22, levelRequirement = 40, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 1.234, damageEffectiveness = 1.23, levelRequirement = 43, cost = { Mana = 8, }, },
		[10] = { baseMultiplier = 1.245, damageEffectiveness = 1.24, levelRequirement = 46, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 1.255, damageEffectiveness = 1.26, levelRequirement = 49, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 1.266, damageEffectiveness = 1.27, levelRequirement = 52, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 1.276, damageEffectiveness = 1.28, levelRequirement = 55, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 1.287, damageEffectiveness = 1.29, levelRequirement = 58, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 1.297, damageEffectiveness = 1.3, levelRequirement = 60, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 1.308, damageEffectiveness = 1.31, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 1.318, damageEffectiveness = 1.32, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 1.329, damageEffectiveness = 1.33, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 1.339, damageEffectiveness = 1.34, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 1.35, damageEffectiveness = 1.35, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 1.361, damageEffectiveness = 1.36, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 1.371, damageEffectiveness = 1.37, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 1.382, damageEffectiveness = 1.38, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 1.392, damageEffectiveness = 1.39, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 1.403, damageEffectiveness = 1.4, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 1.413, damageEffectiveness = 1.41, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 1.424, damageEffectiveness = 1.42, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 1.434, damageEffectiveness = 1.43, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 1.445, damageEffectiveness = 1.44, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 1.455, damageEffectiveness = 1.46, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 1.461, damageEffectiveness = 1.46, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 1.466, damageEffectiveness = 1.47, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 1.471, damageEffectiveness = 1.47, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 1.476, damageEffectiveness = 1.48, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 1.482, damageEffectiveness = 1.48, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 1.487, damageEffectiveness = 1.49, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 1.492, damageEffectiveness = 1.49, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 1.497, damageEffectiveness = 1.5, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 1.503, damageEffectiveness = 1.5, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 1.508, damageEffectiveness = 1.51, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["FrenzyAltX"] = {
	name = "Frenzy of Onslaught",
	baseTypeName = "Frenzy of Onslaught",
	color = 2,
	baseEffectiveness = 0,
	description = "Perform a strike with a melee weapon that gives the character a frenzy charge if it hits. Frenzy charges increase your attack speed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["frenzy_skill_attack_damage_+%_final_per_frenzy_charge"] = {
			mod("Damage", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
		["frenzy_skill_attack_speed_+%_final_per_frenzy_charge"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "FrenzyCharge" }),
		},
		["quality_display_frenzy_is_gem"] = {
			-- Display only
		},
		["quality_display_active_skill_attack_speed_per_frenzy_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "frenzy_skill_attack_damage_+%_final_per_frenzy_charge", 0.1 },
			{ "frenzy_skill_attack_speed_+%_final_per_frenzy_charge", 0.1 },
		},
	},
	constantStats = {
		{ "frenzy_skill_attack_damage_+%_final_per_frenzy_charge", 5 },
		{ "frenzy_skill_attack_speed_+%_final_per_frenzy_charge", 5 },
		{ "frenzy_consume_charges_to_onslaught_for_ms_per_charge", 1000 },
	},
	stats = {
		"quality_display_frenzy_is_gem",
		"quality_display_active_skill_attack_speed_per_frenzy_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 1.627, damageEffectiveness = 1.627, levelRequirement = 16, cost = { Mana = 7, }, },
		[2] = { baseMultiplier = 1.699, damageEffectiveness = 1.699, levelRequirement = 20, cost = { Mana = 7, }, },
		[3] = { baseMultiplier = 1.773, damageEffectiveness = 1.773, levelRequirement = 24, cost = { Mana = 7, }, },
		[4] = { baseMultiplier = 1.851, damageEffectiveness = 1.851, levelRequirement = 28, cost = { Mana = 7, }, },
		[5] = { baseMultiplier = 1.929, damageEffectiveness = 1.929, levelRequirement = 31, cost = { Mana = 8, }, },
		[6] = { baseMultiplier = 2.011, damageEffectiveness = 2.011, levelRequirement = 34, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 2.095, damageEffectiveness = 2.095, levelRequirement = 37, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 2.183, damageEffectiveness = 2.183, levelRequirement = 40, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 2.274, damageEffectiveness = 2.274, levelRequirement = 43, cost = { Mana = 8, }, },
		[10] = { baseMultiplier = 2.37, damageEffectiveness = 2.37, levelRequirement = 46, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 2.469, damageEffectiveness = 2.469, levelRequirement = 49, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 2.573, damageEffectiveness = 2.573, levelRequirement = 52, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 2.68, damageEffectiveness = 2.68, levelRequirement = 55, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 2.792, damageEffectiveness = 2.792, levelRequirement = 58, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 2.904, damageEffectiveness = 2.904, levelRequirement = 60, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 3.02, damageEffectiveness = 3.02, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 3.142, damageEffectiveness = 3.142, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 3.268, damageEffectiveness = 3.268, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 3.398, damageEffectiveness = 3.398, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 3.534, damageEffectiveness = 3.534, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 3.676, damageEffectiveness = 3.676, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 3.823, damageEffectiveness = 3.823, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 3.975, damageEffectiveness = 3.975, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 4.135, damageEffectiveness = 4.135, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 4.299, damageEffectiveness = 4.299, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 4.472, damageEffectiveness = 4.472, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 4.65, damageEffectiveness = 4.65, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 4.835, damageEffectiveness = 4.835, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 5.028, damageEffectiveness = 5.028, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 5.229, damageEffectiveness = 5.229, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 5.529, damageEffectiveness = 5.529, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 5.638, damageEffectiveness = 5.638, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 5.752, damageEffectiveness = 5.752, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 5.866, damageEffectiveness = 5.866, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 5.982, damageEffectiveness = 5.982, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 6.101, damageEffectiveness = 6.101, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 6.222, damageEffectiveness = 6.222, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 6.347, damageEffectiveness = 6.347, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 6.474, damageEffectiveness = 6.474, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 6.602, damageEffectiveness = 6.602, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["FrostBlades"] = {
	name = "Frost Blades",
	baseTypeName = "Frost Blades",
	color = 2,
	description = "Attack enemies with increased range, releasing icy blades from the first enemy hit which fly at other enemies. Requires a Melee Weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Icy blades",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 60 },
		{ "total_projectile_spread_angle_override", 110 },
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -30 },
	},
	stats = {
		"base_number_of_projectiles",
		"melee_weapon_range_+",
		"show_number_of_projectiles",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { 5, 18, baseMultiplier = 1.438, damageEffectiveness = 1.438, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 5, 18, baseMultiplier = 1.512, damageEffectiveness = 1.512, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 5, 18, baseMultiplier = 1.594, damageEffectiveness = 1.594, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 5, 18, baseMultiplier = 1.682, damageEffectiveness = 1.682, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 5, 18, baseMultiplier = 1.779, damageEffectiveness = 1.779, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { Mana = 6, }, },
		[6] = { 6, 19, baseMultiplier = 1.886, damageEffectiveness = 1.886, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 6, 19, baseMultiplier = 1.994, damageEffectiveness = 1.994, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[8] = { 6, 19, baseMultiplier = 2.109, damageEffectiveness = 2.109, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[9] = { 6, 19, baseMultiplier = 2.23, damageEffectiveness = 2.23, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[10] = { 6, 19, baseMultiplier = 2.358, damageEffectiveness = 2.358, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 7, 20, baseMultiplier = 2.494, damageEffectiveness = 2.494, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[12] = { 7, 20, baseMultiplier = 2.636, damageEffectiveness = 2.636, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[13] = { 7, 20, baseMultiplier = 2.787, damageEffectiveness = 2.787, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[14] = { 7, 20, baseMultiplier = 2.947, damageEffectiveness = 2.947, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[15] = { 7, 20, baseMultiplier = 3.115, damageEffectiveness = 3.115, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[16] = { 8, 21, baseMultiplier = 3.292, damageEffectiveness = 3.292, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[17] = { 8, 21, baseMultiplier = 3.481, damageEffectiveness = 3.481, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[18] = { 8, 21, baseMultiplier = 3.679, damageEffectiveness = 3.679, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[19] = { 8, 21, baseMultiplier = 3.882, damageEffectiveness = 3.882, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[20] = { 8, 21, baseMultiplier = 4.096, damageEffectiveness = 4.096, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[21] = { 9, 22, baseMultiplier = 4.315, damageEffectiveness = 4.315, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[22] = { 9, 22, baseMultiplier = 4.546, damageEffectiveness = 4.546, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[23] = { 9, 22, baseMultiplier = 4.788, damageEffectiveness = 4.788, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[24] = { 9, 22, baseMultiplier = 5.044, damageEffectiveness = 5.044, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 9, 22, baseMultiplier = 5.314, damageEffectiveness = 5.314, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[26] = { 10, 23, baseMultiplier = 5.597, damageEffectiveness = 5.597, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[27] = { 10, 23, baseMultiplier = 5.896, damageEffectiveness = 5.896, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[28] = { 10, 23, baseMultiplier = 6.211, damageEffectiveness = 6.211, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[29] = { 10, 23, baseMultiplier = 6.542, damageEffectiveness = 6.542, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[30] = { 10, 23, baseMultiplier = 6.891, damageEffectiveness = 6.891, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[31] = { 10, 23, baseMultiplier = 7.428, damageEffectiveness = 7.428, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[32] = { 11, 24, baseMultiplier = 7.626, damageEffectiveness = 7.626, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[33] = { 11, 24, baseMultiplier = 7.829, damageEffectiveness = 7.829, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[34] = { 11, 24, baseMultiplier = 8.038, damageEffectiveness = 8.038, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[35] = { 11, 24, baseMultiplier = 8.251, damageEffectiveness = 8.251, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[36] = { 11, 24, baseMultiplier = 8.471, damageEffectiveness = 8.471, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[37] = { 11, 24, baseMultiplier = 8.697, damageEffectiveness = 8.697, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[38] = { 11, 24, baseMultiplier = 8.928, damageEffectiveness = 8.928, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[39] = { 11, 24, baseMultiplier = 9.166, damageEffectiveness = 9.166, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[40] = { 11, 24, baseMultiplier = 9.41, damageEffectiveness = 9.41, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
	},
}
skills["FrostBladesAltX"] = {
	name = "Frost Blades of Katabasis",
	baseTypeName = "Frost Blades of Katabasis",
	color = 2,
	baseEffectiveness = 2.2339000701904,
	incrementalEffectiveness = 0.057500001043081,
	description = "Attack enemies with greatly increased range, creating a chilling area that deals cold damage over time if it hits. Requires a Melee Weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.ChillingArea] = true, [SkillType.Duration] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			attack = true,
			melee = true,
			projectile = true,
			area = false,
		},
		{
			name = "Ground DoT",
			attack = false,
			hit = false,
			melee = false,
			projectile = false,
			area = true,
		},
	},
	statMap = {
		["base_cold_damage_to_deal_per_minute"] = {
			skill("ColdDot", nil, { type = "SkillPart", skillPart = 2 }),
			div = 60,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		area = true,
		dotFromAttack = true,
	},
	baseMods = {
		skill("dotIsArea", true, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "melee_weapon_range_+", 0.5 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 60 },
		{ "total_projectile_spread_angle_override", 110 },
		{ "base_skill_effect_duration", 3000 },
		{ "ground_ice_art_variation", 7 },
	},
	stats = {
		"base_cold_damage_to_deal_per_minute",
		"base_number_of_projectiles",
		"melee_weapon_range_+",
		"show_number_of_projectiles",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
		"display_fixed_area",
	},
	levels = {
		[1] = { 66.000002110998, 0, 50, baseMultiplier = 0.86, damageEffectiveness = 0.86, levelRequirement = 1, statInterpolation = { 3, 1, 1, }, cost = { Mana = 6, }, },
		[2] = { 66.000002110998, 0, 50, baseMultiplier = 0.941, damageEffectiveness = 0.941, levelRequirement = 2, statInterpolation = { 3, 1, 1, }, cost = { Mana = 6, }, },
		[3] = { 66.000002110998, 0, 50, baseMultiplier = 1.022, damageEffectiveness = 1.022, levelRequirement = 4, statInterpolation = { 3, 1, 1, }, cost = { Mana = 6, }, },
		[4] = { 66.000002110998, 0, 50, baseMultiplier = 1.103, damageEffectiveness = 1.103, levelRequirement = 7, statInterpolation = { 3, 1, 1, }, cost = { Mana = 6, }, },
		[5] = { 66.000002110998, 0, 50, baseMultiplier = 1.184, damageEffectiveness = 1.184, levelRequirement = 11, statInterpolation = { 3, 1, 1, }, cost = { Mana = 6, }, },
		[6] = { 66.000002110998, 0, 50, baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 16, statInterpolation = { 3, 1, 1, }, cost = { Mana = 7, }, },
		[7] = { 66.000002110998, 0, 50, baseMultiplier = 1.346, damageEffectiveness = 1.346, levelRequirement = 20, statInterpolation = { 3, 1, 1, }, cost = { Mana = 7, }, },
		[8] = { 66.000002110998, 0, 50, baseMultiplier = 1.427, damageEffectiveness = 1.427, levelRequirement = 24, statInterpolation = { 3, 1, 1, }, cost = { Mana = 7, }, },
		[9] = { 66.000002110998, 0, 50, baseMultiplier = 1.508, damageEffectiveness = 1.508, levelRequirement = 28, statInterpolation = { 3, 1, 1, }, cost = { Mana = 7, }, },
		[10] = { 66.000002110998, 0, 50, baseMultiplier = 1.589, damageEffectiveness = 1.589, levelRequirement = 32, statInterpolation = { 3, 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 66.000002110998, 0, 50, baseMultiplier = 1.671, damageEffectiveness = 1.671, levelRequirement = 36, statInterpolation = { 3, 1, 1, }, cost = { Mana = 8, }, },
		[12] = { 66.000002110998, 0, 50, baseMultiplier = 1.752, damageEffectiveness = 1.752, levelRequirement = 40, statInterpolation = { 3, 1, 1, }, cost = { Mana = 8, }, },
		[13] = { 66.000002110998, 0, 50, baseMultiplier = 1.833, damageEffectiveness = 1.833, levelRequirement = 44, statInterpolation = { 3, 1, 1, }, cost = { Mana = 8, }, },
		[14] = { 66.000002110998, 0, 50, baseMultiplier = 1.914, damageEffectiveness = 1.914, levelRequirement = 48, statInterpolation = { 3, 1, 1, }, cost = { Mana = 9, }, },
		[15] = { 66.000002110998, 0, 50, baseMultiplier = 1.995, damageEffectiveness = 1.995, levelRequirement = 52, statInterpolation = { 3, 1, 1, }, cost = { Mana = 9, }, },
		[16] = { 66.000002110998, 0, 50, baseMultiplier = 2.076, damageEffectiveness = 2.076, levelRequirement = 56, statInterpolation = { 3, 1, 1, }, cost = { Mana = 9, }, },
		[17] = { 66.000002110998, 0, 50, baseMultiplier = 2.157, damageEffectiveness = 2.157, levelRequirement = 60, statInterpolation = { 3, 1, 1, }, cost = { Mana = 9, }, },
		[18] = { 66.000002110998, 0, 50, baseMultiplier = 2.238, damageEffectiveness = 2.238, levelRequirement = 64, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[19] = { 66.000002110998, 0, 50, baseMultiplier = 2.319, damageEffectiveness = 2.319, levelRequirement = 67, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[20] = { 66.000002110998, 0, 50, baseMultiplier = 2.4, damageEffectiveness = 2.4, levelRequirement = 70, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[21] = { 66.000002110998, 0, 50, baseMultiplier = 2.481, damageEffectiveness = 2.481, levelRequirement = 72, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[22] = { 66.000002110998, 0, 50, baseMultiplier = 2.562, damageEffectiveness = 2.562, levelRequirement = 74, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[23] = { 66.000002110998, 0, 50, baseMultiplier = 2.643, damageEffectiveness = 2.643, levelRequirement = 76, statInterpolation = { 3, 1, 1, }, cost = { Mana = 10, }, },
		[24] = { 66.000002110998, 0, 50, baseMultiplier = 2.724, damageEffectiveness = 2.724, levelRequirement = 78, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 66.000002110998, 0, 50, baseMultiplier = 2.805, damageEffectiveness = 2.805, levelRequirement = 80, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[26] = { 66.000002110998, 0, 50, baseMultiplier = 2.886, damageEffectiveness = 2.886, levelRequirement = 82, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[27] = { 66.000002110998, 0, 50, baseMultiplier = 2.967, damageEffectiveness = 2.967, levelRequirement = 84, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[28] = { 66.000002110998, 0, 50, baseMultiplier = 3.048, damageEffectiveness = 3.048, levelRequirement = 86, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[29] = { 66.000002110998, 0, 50, baseMultiplier = 3.129, damageEffectiveness = 3.129, levelRequirement = 88, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[30] = { 66.000002110998, 0, 50, baseMultiplier = 3.211, damageEffectiveness = 3.211, levelRequirement = 90, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[31] = { 66.000002110998, 0, 50, baseMultiplier = 3.251, damageEffectiveness = 3.251, levelRequirement = 91, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[32] = { 66.000002110998, 0, 50, baseMultiplier = 3.292, damageEffectiveness = 3.292, levelRequirement = 92, statInterpolation = { 3, 1, 1, }, cost = { Mana = 11, }, },
		[33] = { 66.000002110998, 0, 50, baseMultiplier = 3.332, damageEffectiveness = 3.332, levelRequirement = 93, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[34] = { 66.000002110998, 0, 50, baseMultiplier = 3.373, damageEffectiveness = 3.373, levelRequirement = 94, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[35] = { 66.000002110998, 0, 50, baseMultiplier = 3.413, damageEffectiveness = 3.413, levelRequirement = 95, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[36] = { 66.000002110998, 0, 50, baseMultiplier = 3.454, damageEffectiveness = 3.454, levelRequirement = 96, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[37] = { 66.000002110998, 0, 50, baseMultiplier = 3.494, damageEffectiveness = 3.494, levelRequirement = 97, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[38] = { 66.000002110998, 0, 50, baseMultiplier = 3.535, damageEffectiveness = 3.535, levelRequirement = 98, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[39] = { 66.000002110998, 0, 50, baseMultiplier = 3.575, damageEffectiveness = 3.575, levelRequirement = 99, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
		[40] = { 66.000002110998, 0, 50, baseMultiplier = 3.616, damageEffectiveness = 3.616, levelRequirement = 100, statInterpolation = { 3, 1, 1, }, cost = { Mana = 12, }, },
	},
}
skills["GalvanicArrow"] = {
	name = "Galvanic Arrow",
	baseTypeName = "Galvanic Arrow",
	color = 2,
	description = "Fire a trio of electrical arrows that quickly dissipate, vanishing shortly after being loosed. The arrows are fired with such force that they create a burst of lightning, damaging enemies in a cone in front of you.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 28),
	},
	qualityStats = {
		Default = {
			{ "base_projectile_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_number_of_arrows", 3 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_is_projectile",
		"skill_can_fire_arrows",
		"additive_arrow_speed_modifiers_apply_to_area_of_effect",
		"quality_display_base_additional_arrows_is_gem",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 0, baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 1, baseMultiplier = 0.943, damageEffectiveness = 0.943, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[4] = { 1, baseMultiplier = 0.954, damageEffectiveness = 0.954, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[5] = { 1, baseMultiplier = 0.966, damageEffectiveness = 0.966, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[6] = { 1, baseMultiplier = 0.977, damageEffectiveness = 0.977, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[7] = { 2, baseMultiplier = 0.989, damageEffectiveness = 0.989, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[8] = { 2, baseMultiplier = 1.001, damageEffectiveness = 1.001, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[9] = { 2, baseMultiplier = 1.012, damageEffectiveness = 1.012, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[10] = { 3, baseMultiplier = 1.024, damageEffectiveness = 1.024, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 3, baseMultiplier = 1.035, damageEffectiveness = 1.035, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[12] = { 3, baseMultiplier = 1.047, damageEffectiveness = 1.047, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[13] = { 3, baseMultiplier = 1.058, damageEffectiveness = 1.058, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[14] = { 4, baseMultiplier = 1.07, damageEffectiveness = 1.07, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 4, baseMultiplier = 1.081, damageEffectiveness = 1.081, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 4, baseMultiplier = 1.093, damageEffectiveness = 1.093, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[17] = { 5, baseMultiplier = 1.104, damageEffectiveness = 1.104, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[18] = { 5, baseMultiplier = 1.116, damageEffectiveness = 1.116, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 5, baseMultiplier = 1.127, damageEffectiveness = 1.127, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 5, baseMultiplier = 1.139, damageEffectiveness = 1.139, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 6, baseMultiplier = 1.15, damageEffectiveness = 1.15, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 6, baseMultiplier = 1.162, damageEffectiveness = 1.162, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 6, baseMultiplier = 1.173, damageEffectiveness = 1.173, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 7, baseMultiplier = 1.185, damageEffectiveness = 1.185, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 7, baseMultiplier = 1.196, damageEffectiveness = 1.196, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 7, baseMultiplier = 1.208, damageEffectiveness = 1.208, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 7, baseMultiplier = 1.219, damageEffectiveness = 1.219, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 8, baseMultiplier = 1.231, damageEffectiveness = 1.231, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 8, baseMultiplier = 1.242, damageEffectiveness = 1.242, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 8, baseMultiplier = 1.254, damageEffectiveness = 1.254, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 8, baseMultiplier = 1.259, damageEffectiveness = 1.259, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 9, baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 9, baseMultiplier = 1.271, damageEffectiveness = 1.271, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 9, baseMultiplier = 1.277, damageEffectiveness = 1.277, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 9, baseMultiplier = 1.282, damageEffectiveness = 1.282, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 9, baseMultiplier = 1.288, damageEffectiveness = 1.288, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 9, baseMultiplier = 1.294, damageEffectiveness = 1.294, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 9, baseMultiplier = 1.3, damageEffectiveness = 1.3, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 10, baseMultiplier = 1.305, damageEffectiveness = 1.305, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 10, baseMultiplier = 1.311, damageEffectiveness = 1.311, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["GalvanicArrowAltX"] = {
	name = "Galvanic Arrow of Energy",
	baseTypeName = "Galvanic Arrow of Energy",
	color = 2,
	description = "Create a burst of lightning from your Bow, firing no arrows but damaging enemies in a cone in front of you.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	baseMods = {
		skill("radius", 28),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "active_skill_base_radius_+", 8 },
	},
	stats = {
		"active_skill_base_radius_+",
		"quality_display_base_additional_arrows_is_gem",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, baseMultiplier = 2.013, damageEffectiveness = 2.013, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 0, baseMultiplier = 2.033, damageEffectiveness = 2.033, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 1, baseMultiplier = 2.055, damageEffectiveness = 2.055, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[4] = { 1, baseMultiplier = 2.076, damageEffectiveness = 2.076, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[5] = { 1, baseMultiplier = 2.098, damageEffectiveness = 2.098, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[6] = { 1, baseMultiplier = 2.118, damageEffectiveness = 2.118, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[7] = { 2, baseMultiplier = 2.14, damageEffectiveness = 2.14, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[8] = { 2, baseMultiplier = 2.161, damageEffectiveness = 2.161, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[9] = { 2, baseMultiplier = 2.182, damageEffectiveness = 2.182, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[10] = { 3, baseMultiplier = 2.203, damageEffectiveness = 2.203, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 3, baseMultiplier = 2.224, damageEffectiveness = 2.224, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[12] = { 3, baseMultiplier = 2.246, damageEffectiveness = 2.246, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[13] = { 3, baseMultiplier = 2.267, damageEffectiveness = 2.267, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[14] = { 4, baseMultiplier = 2.287, damageEffectiveness = 2.287, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 4, baseMultiplier = 2.309, damageEffectiveness = 2.309, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 4, baseMultiplier = 2.33, damageEffectiveness = 2.33, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[17] = { 5, baseMultiplier = 2.352, damageEffectiveness = 2.352, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[18] = { 5, baseMultiplier = 2.372, damageEffectiveness = 2.372, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 5, baseMultiplier = 2.394, damageEffectiveness = 2.394, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 5, baseMultiplier = 2.415, damageEffectiveness = 2.415, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 6, baseMultiplier = 2.436, damageEffectiveness = 2.436, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 6, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 6, baseMultiplier = 2.478, damageEffectiveness = 2.478, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 7, baseMultiplier = 2.5, damageEffectiveness = 2.5, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 7, baseMultiplier = 2.521, damageEffectiveness = 2.521, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 7, baseMultiplier = 2.543, damageEffectiveness = 2.543, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 7, baseMultiplier = 2.563, damageEffectiveness = 2.563, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 8, baseMultiplier = 2.584, damageEffectiveness = 2.584, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 8, baseMultiplier = 2.606, damageEffectiveness = 2.606, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 8, baseMultiplier = 2.627, damageEffectiveness = 2.627, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 8, baseMultiplier = 2.637, damageEffectiveness = 2.637, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 9, baseMultiplier = 2.648, damageEffectiveness = 2.648, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 9, baseMultiplier = 2.659, damageEffectiveness = 2.659, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 9, baseMultiplier = 2.669, damageEffectiveness = 2.669, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 9, baseMultiplier = 2.68, damageEffectiveness = 2.68, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 9, baseMultiplier = 2.69, damageEffectiveness = 2.69, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 9, baseMultiplier = 2.701, damageEffectiveness = 2.701, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 9, baseMultiplier = 2.712, damageEffectiveness = 2.712, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 10, baseMultiplier = 2.722, damageEffectiveness = 2.722, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 10, baseMultiplier = 2.732, damageEffectiveness = 2.732, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["GalvanicArrowAltY"] = {
	name = "Galvanic Arrow of Surging",
	baseTypeName = "Galvanic Arrow of Surging",
	color = 2,
	description = "Fire a trio of electrical arrows that quickly dissipate, vanishing shortly after being loosed. If the arrows' flight is stopped by colliding with a target, they create a burst of lightning, damaging enemies in a cone behind the target",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 28),
	},
	qualityStats = {
		Default = {
			{ "base_projectile_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_number_of_arrows", 3 },
	},
	stats = {
		"base_is_projectile",
		"skill_can_fire_arrows",
		"quality_display_base_additional_arrows_is_gem",
	},
	levels = {
		[1] = { baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 1, cost = { Mana = 6, }, },
		[2] = { baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 2, cost = { Mana = 6, }, },
		[3] = { baseMultiplier = 0.943, damageEffectiveness = 0.943, levelRequirement = 4, cost = { Mana = 6, }, },
		[4] = { baseMultiplier = 0.954, damageEffectiveness = 0.954, levelRequirement = 7, cost = { Mana = 6, }, },
		[5] = { baseMultiplier = 0.966, damageEffectiveness = 0.966, levelRequirement = 11, cost = { Mana = 6, }, },
		[6] = { baseMultiplier = 0.977, damageEffectiveness = 0.977, levelRequirement = 16, cost = { Mana = 7, }, },
		[7] = { baseMultiplier = 0.989, damageEffectiveness = 0.989, levelRequirement = 20, cost = { Mana = 7, }, },
		[8] = { baseMultiplier = 1.001, damageEffectiveness = 1.001, levelRequirement = 24, cost = { Mana = 7, }, },
		[9] = { baseMultiplier = 1.012, damageEffectiveness = 1.012, levelRequirement = 28, cost = { Mana = 7, }, },
		[10] = { baseMultiplier = 1.024, damageEffectiveness = 1.024, levelRequirement = 32, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 1.035, damageEffectiveness = 1.035, levelRequirement = 36, cost = { Mana = 8, }, },
		[12] = { baseMultiplier = 1.047, damageEffectiveness = 1.047, levelRequirement = 40, cost = { Mana = 8, }, },
		[13] = { baseMultiplier = 1.058, damageEffectiveness = 1.058, levelRequirement = 44, cost = { Mana = 8, }, },
		[14] = { baseMultiplier = 1.07, damageEffectiveness = 1.07, levelRequirement = 48, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 1.081, damageEffectiveness = 1.081, levelRequirement = 52, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 1.093, damageEffectiveness = 1.093, levelRequirement = 56, cost = { Mana = 9, }, },
		[17] = { baseMultiplier = 1.104, damageEffectiveness = 1.104, levelRequirement = 60, cost = { Mana = 9, }, },
		[18] = { baseMultiplier = 1.116, damageEffectiveness = 1.116, levelRequirement = 64, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 1.127, damageEffectiveness = 1.127, levelRequirement = 67, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 1.139, damageEffectiveness = 1.139, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 1.15, damageEffectiveness = 1.15, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 1.162, damageEffectiveness = 1.162, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 1.173, damageEffectiveness = 1.173, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 1.185, damageEffectiveness = 1.185, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 1.196, damageEffectiveness = 1.196, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 1.208, damageEffectiveness = 1.208, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 1.219, damageEffectiveness = 1.219, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 1.231, damageEffectiveness = 1.231, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 1.242, damageEffectiveness = 1.242, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 1.254, damageEffectiveness = 1.254, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 1.259, damageEffectiveness = 1.259, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 1.265, damageEffectiveness = 1.265, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 1.271, damageEffectiveness = 1.271, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 1.277, damageEffectiveness = 1.277, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 1.282, damageEffectiveness = 1.282, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 1.288, damageEffectiveness = 1.288, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 1.294, damageEffectiveness = 1.294, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 1.3, damageEffectiveness = 1.3, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 1.305, damageEffectiveness = 1.305, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 1.311, damageEffectiveness = 1.311, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["GlacialShieldSwipe"] = {
	name = "Glacial Shield Swipe",
	baseTypeName = "Glacial Shield Swipe",
	color = 2,
	baseEffectiveness = 8.0900001525879,
	incrementalEffectiveness = 0.017300000414252,
	description = "Retaliate against a blocked hit with a sweep of your Shield, unleashing a wave of ice in a cone in front of you.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cold] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, [SkillType.Retaliation] = true, [SkillType.RequiresShield] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		shieldAttack = true,
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "retaliation_base_use_window_duration_ms", 2000 },
		{ "active_skill_base_area_of_effect_radius", 80 },
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "active_skill_ailment_damage_+%_final", -50 },
	},
	stats = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
		"off_hand_minimum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"off_hand_maximum_added_physical_damage_per_15_shield_armour_and_evasion_rating",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
		"global_always_hit",
		"skill_cannot_be_exerted",
		"is_area_damage",
		"always_freeze",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"off_hand_local_minimum_added_physical_damage",
		"off_hand_local_maximum_added_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 17, 25, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 18, 26, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 7, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 18, 28, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 18, 28, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 19, 29, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 31, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 20, 30, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 21, 31, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 37, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 22, 32, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 22, 32, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 43, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 22, 34, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 23, 35, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 49, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 9, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 24, 36, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 24, 36, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 55, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 25, 37, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 26, 38, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 26, 40, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 10, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 27, 41, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 27, 41, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 28, 42, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 29, 43, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 30, 44, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 30, 46, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 30, 46, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 31, 47, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 11, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 32, 48, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 33, 49, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 34, 50, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 34, 50, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 34, 52, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 35, 53, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 35, 53, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 36, 54, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 12, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 36, 54, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 36, 54, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 37, 55, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 37, 55, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 38, 56, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 38, 56, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 38, 56, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 38, 58, attackTime = 700, cooldown = 3.5, critChance = 5, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 13, }, },
	},
}
skills["Grace"] = {
	name = "Grace",
	baseTypeName = "Grace",
	color = 2,
	description = "Casts an aura that grants evasion to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["grace_aura_evasion_rating_+%_final"] = {
			mod("Evasion", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_evasion_rating"] = {
			mod("Evasion", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"grace_aura_evasion_rating_+%_final",
		"base_evasion_rating",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 20, 136, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[2] = { 20, 163, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[3] = { 21, 193, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[4] = { 21, 227, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[5] = { 22, 266, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[6] = { 22, 317, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[7] = { 23, 373, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[8] = { 23, 433, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[9] = { 24, 507, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[10] = { 24, 564, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[11] = { 25, 626, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[12] = { 25, 693, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[13] = { 26, 770, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[14] = { 26, 848, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[15] = { 27, 940, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[16] = { 27, 1039, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[17] = { 28, 1148, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[18] = { 28, 1269, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[19] = { 29, 1401, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 29, 1545, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[21] = { 30, 1620, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[22] = { 30, 1701, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[23] = { 31, 1787, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[24] = { 31, 1874, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[25] = { 32, 1967, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[26] = { 32, 2066, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[27] = { 33, 2167, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[28] = { 33, 2277, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[29] = { 34, 2389, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[30] = { 34, 2507, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[31] = { 35, 2570, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[32] = { 35, 2632, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[33] = { 35, 2697, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[34] = { 35, 2762, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[35] = { 36, 2830, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[36] = { 36, 2898, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[37] = { 36, 2969, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[38] = { 36, 3040, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[39] = { 37, 3115, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
		[40] = { 37, 3188, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["VaalGrace"] = {
	name = "Vaal Grace",
	baseTypeName = "Vaal Grace",
	color = 2,
	description = "Casts a temporary aura that grants you and your allies additional chance to evade attacks, and makes suppressed spell damage unlucky against you.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["chance_to_evade_attacks_%"] = {
			mod("EvadeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	constantStats = {
		{ "chance_to_evade_attacks_%", 15 },
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_deal_no_damage",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
		"damage_taken_from_suppressed_hits_is_unlucky",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, cooldown = 0.5, levelRequirement = 24, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[2] = { 1, cooldown = 0.5, levelRequirement = 27, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[3] = { 2, cooldown = 0.5, levelRequirement = 30, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[4] = { 3, cooldown = 0.5, levelRequirement = 33, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[5] = { 4, cooldown = 0.5, levelRequirement = 36, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[6] = { 5, cooldown = 0.5, levelRequirement = 39, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[7] = { 6, cooldown = 0.5, levelRequirement = 42, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[8] = { 7, cooldown = 0.5, levelRequirement = 45, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[9] = { 8, cooldown = 0.5, levelRequirement = 48, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[10] = { 9, cooldown = 0.5, levelRequirement = 50, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[11] = { 10, cooldown = 0.5, levelRequirement = 52, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[12] = { 11, cooldown = 0.5, levelRequirement = 54, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[13] = { 12, cooldown = 0.5, levelRequirement = 56, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[14] = { 13, cooldown = 0.5, levelRequirement = 58, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[15] = { 14, cooldown = 0.5, levelRequirement = 60, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[16] = { 15, cooldown = 0.5, levelRequirement = 62, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[17] = { 16, cooldown = 0.5, levelRequirement = 64, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[18] = { 17, cooldown = 0.5, levelRequirement = 66, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[19] = { 18, cooldown = 0.5, levelRequirement = 68, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[20] = { 19, cooldown = 0.5, levelRequirement = 70, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[21] = { 20, cooldown = 0.5, levelRequirement = 72, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[22] = { 21, cooldown = 0.5, levelRequirement = 74, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[23] = { 22, cooldown = 0.5, levelRequirement = 76, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[24] = { 23, cooldown = 0.5, levelRequirement = 78, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[25] = { 24, cooldown = 0.5, levelRequirement = 80, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[26] = { 25, cooldown = 0.5, levelRequirement = 82, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[27] = { 26, cooldown = 0.5, levelRequirement = 84, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[28] = { 27, cooldown = 0.5, levelRequirement = 86, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[29] = { 28, cooldown = 0.5, levelRequirement = 88, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[30] = { 29, cooldown = 0.5, levelRequirement = 90, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[31] = { 29, cooldown = 0.5, levelRequirement = 91, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[32] = { 30, cooldown = 0.5, levelRequirement = 92, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[33] = { 30, cooldown = 0.5, levelRequirement = 93, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[34] = { 31, cooldown = 0.5, levelRequirement = 94, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[35] = { 31, cooldown = 0.5, levelRequirement = 95, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[36] = { 32, cooldown = 0.5, levelRequirement = 96, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[37] = { 32, cooldown = 0.5, levelRequirement = 97, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[38] = { 33, cooldown = 0.5, levelRequirement = 98, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[39] = { 33, cooldown = 0.5, levelRequirement = 99, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
		[40] = { 34, cooldown = 0.5, levelRequirement = 100, soulPreventionDuration = 9, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, }, cost = { Soul = 50, }, },
	},
}
skills["Haste"] = {
	name = "Haste",
	baseTypeName = "Haste",
	color = 2,
	description = "Casts an aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 15, 15, 10, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[2] = { 15, 15, 10, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[3] = { 16, 16, 10, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[4] = { 16, 16, 11, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[5] = { 17, 17, 11, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[6] = { 17, 17, 11, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[7] = { 18, 18, 12, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[8] = { 18, 18, 12, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[9] = { 19, 19, 12, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[10] = { 19, 19, 13, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[11] = { 20, 20, 13, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[12] = { 20, 20, 13, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[13] = { 21, 21, 14, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[14] = { 21, 21, 14, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[15] = { 22, 22, 14, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[16] = { 22, 22, 15, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[17] = { 23, 23, 15, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[18] = { 23, 23, 15, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[19] = { 24, 24, 16, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 24, 24, 16, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[21] = { 25, 25, 16, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[22] = { 25, 25, 17, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[23] = { 26, 26, 17, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[24] = { 26, 26, 17, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[25] = { 27, 27, 18, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[26] = { 27, 27, 18, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[27] = { 28, 28, 18, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[28] = { 28, 28, 19, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[29] = { 29, 29, 19, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 29, 29, 19, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[31] = { 29, 29, 19, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[32] = { 30, 30, 20, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[33] = { 30, 30, 20, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[34] = { 30, 30, 20, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[35] = { 30, 30, 20, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[36] = { 31, 31, 20, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[37] = { 31, 31, 20, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[38] = { 31, 31, 21, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[39] = { 31, 31, 21, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[40] = { 32, 32, 21, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["VaalHaste"] = {
	name = "Vaal Haste",
	baseTypeName = "Vaal Haste",
	color = 2,
	description = "Casts a temporary aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
		vaal = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 25, 24, 16, 0, cooldown = 0.5, levelRequirement = 24, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[2] = { 25, 25, 16, 1, cooldown = 0.5, levelRequirement = 27, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[3] = { 25, 25, 16, 2, cooldown = 0.5, levelRequirement = 30, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[4] = { 26, 25, 16, 3, cooldown = 0.5, levelRequirement = 33, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[5] = { 26, 26, 17, 4, cooldown = 0.5, levelRequirement = 36, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[6] = { 26, 26, 17, 5, cooldown = 0.5, levelRequirement = 39, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[7] = { 27, 26, 17, 6, cooldown = 0.5, levelRequirement = 42, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[8] = { 27, 27, 17, 7, cooldown = 0.5, levelRequirement = 45, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[9] = { 27, 27, 18, 8, cooldown = 0.5, levelRequirement = 48, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[10] = { 28, 27, 18, 9, cooldown = 0.5, levelRequirement = 50, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[11] = { 28, 28, 18, 10, cooldown = 0.5, levelRequirement = 52, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[12] = { 28, 28, 18, 11, cooldown = 0.5, levelRequirement = 54, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[13] = { 29, 28, 19, 12, cooldown = 0.5, levelRequirement = 56, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[14] = { 29, 29, 19, 13, cooldown = 0.5, levelRequirement = 58, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[15] = { 29, 29, 19, 14, cooldown = 0.5, levelRequirement = 60, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[16] = { 30, 29, 19, 15, cooldown = 0.5, levelRequirement = 62, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[17] = { 30, 30, 20, 16, cooldown = 0.5, levelRequirement = 64, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[18] = { 30, 30, 20, 17, cooldown = 0.5, levelRequirement = 66, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[19] = { 31, 30, 20, 18, cooldown = 0.5, levelRequirement = 68, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[20] = { 31, 31, 20, 19, cooldown = 0.5, levelRequirement = 70, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[21] = { 31, 31, 21, 20, cooldown = 0.5, levelRequirement = 72, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[22] = { 32, 31, 21, 21, cooldown = 0.5, levelRequirement = 74, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[23] = { 32, 32, 21, 22, cooldown = 0.5, levelRequirement = 76, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[24] = { 32, 32, 21, 23, cooldown = 0.5, levelRequirement = 78, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[25] = { 33, 32, 22, 24, cooldown = 0.5, levelRequirement = 80, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[26] = { 33, 33, 22, 25, cooldown = 0.5, levelRequirement = 82, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[27] = { 33, 33, 22, 26, cooldown = 0.5, levelRequirement = 84, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[28] = { 34, 33, 22, 27, cooldown = 0.5, levelRequirement = 86, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[29] = { 34, 34, 23, 28, cooldown = 0.5, levelRequirement = 88, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[30] = { 34, 34, 23, 29, cooldown = 0.5, levelRequirement = 90, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[31] = { 34, 34, 23, 29, cooldown = 0.5, levelRequirement = 91, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[32] = { 35, 34, 23, 30, cooldown = 0.5, levelRequirement = 92, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[33] = { 35, 34, 23, 30, cooldown = 0.5, levelRequirement = 93, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[34] = { 35, 35, 23, 31, cooldown = 0.5, levelRequirement = 94, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[35] = { 35, 35, 23, 31, cooldown = 0.5, levelRequirement = 95, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[36] = { 35, 35, 24, 32, cooldown = 0.5, levelRequirement = 96, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[37] = { 35, 35, 24, 32, cooldown = 0.5, levelRequirement = 97, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[38] = { 36, 35, 24, 33, cooldown = 0.5, levelRequirement = 98, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[39] = { 36, 35, 24, 33, cooldown = 0.5, levelRequirement = 99, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
		[40] = { 36, 36, 24, 34, cooldown = 0.5, levelRequirement = 100, soulPreventionDuration = 6, storedUses = 1, vaalStoredUses = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { Soul = 50, }, },
	},
}
skills["Hatred"] = {
	name = "Hatred",
	baseTypeName = "Hatred",
	color = 2,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.025000000372529,
	description = "Casts an aura that grants extra cold damage based on physical damage to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Cold] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["physical_damage_%_to_add_as_cold"] = {
			mod("PhysicalDamageGainAsCold", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
		Default = {
			{ "base_skill_area_of_effect_+%", 2 },
		},
	},
	stats = {
		"physical_damage_%_to_add_as_cold",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 30, 0, cooldown = 1.2, levelRequirement = 24, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[2] = { 30, 1, cooldown = 1.2, levelRequirement = 27, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[3] = { 31, 2, cooldown = 1.2, levelRequirement = 30, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[4] = { 31, 3, cooldown = 1.2, levelRequirement = 33, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[5] = { 32, 4, cooldown = 1.2, levelRequirement = 36, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[6] = { 32, 5, cooldown = 1.2, levelRequirement = 39, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[7] = { 33, 6, cooldown = 1.2, levelRequirement = 42, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[8] = { 33, 7, cooldown = 1.2, levelRequirement = 45, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[9] = { 34, 8, cooldown = 1.2, levelRequirement = 48, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[10] = { 34, 9, cooldown = 1.2, levelRequirement = 50, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[11] = { 35, 10, cooldown = 1.2, levelRequirement = 52, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[12] = { 35, 11, cooldown = 1.2, levelRequirement = 54, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[13] = { 36, 12, cooldown = 1.2, levelRequirement = 56, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[14] = { 36, 13, cooldown = 1.2, levelRequirement = 58, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[15] = { 37, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[16] = { 37, 15, cooldown = 1.2, levelRequirement = 62, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[17] = { 38, 16, cooldown = 1.2, levelRequirement = 64, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[18] = { 38, 17, cooldown = 1.2, levelRequirement = 66, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[19] = { 39, 18, cooldown = 1.2, levelRequirement = 68, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[20] = { 39, 19, cooldown = 1.2, levelRequirement = 70, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[21] = { 40, 20, cooldown = 1.2, levelRequirement = 72, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[22] = { 40, 21, cooldown = 1.2, levelRequirement = 74, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[23] = { 41, 22, cooldown = 1.2, levelRequirement = 76, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[24] = { 41, 23, cooldown = 1.2, levelRequirement = 78, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[25] = { 42, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[26] = { 42, 25, cooldown = 1.2, levelRequirement = 82, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[27] = { 43, 26, cooldown = 1.2, levelRequirement = 84, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[28] = { 43, 27, cooldown = 1.2, levelRequirement = 86, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[29] = { 44, 28, cooldown = 1.2, levelRequirement = 88, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[30] = { 44, 29, cooldown = 1.2, levelRequirement = 90, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[31] = { 44, 29, cooldown = 1.2, levelRequirement = 91, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[32] = { 45, 30, cooldown = 1.2, levelRequirement = 92, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[33] = { 45, 30, cooldown = 1.2, levelRequirement = 93, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[34] = { 45, 31, cooldown = 1.2, levelRequirement = 94, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[35] = { 45, 31, cooldown = 1.2, levelRequirement = 95, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[36] = { 46, 32, cooldown = 1.2, levelRequirement = 96, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[37] = { 46, 32, cooldown = 1.2, levelRequirement = 97, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[38] = { 46, 33, cooldown = 1.2, levelRequirement = 98, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[39] = { 46, 33, cooldown = 1.2, levelRequirement = 99, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
		[40] = { 47, 34, cooldown = 1.2, levelRequirement = 100, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["HeraldOfAgony"] = {
	name = "Herald of Agony",
	baseTypeName = "Herald of Agony",
	color = 2,
	baseEffectiveness = 0.10999999940395,
	incrementalEffectiveness = 0.044700000435114,
	description = "Grants a buff giving more poison damage and a chance to inflict poison. When you poison an enemy while you have this buff, you gain Virulence, and summon an Agony Crawler minion that uses projectile and area attacks. You will lose Virulence over time, at a rate which increases the more Virulence you have. The minion will die when you have no Virulence.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.Herald] = true, [SkillType.Minion] = true, [SkillType.Instant] = true, [SkillType.Chaos] = true, [SkillType.Physical] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Attack] = true, [SkillType.Chaos] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, },
	statDescriptionScope = "minion_skill_stat_descriptions",
	castTime = 0,
	minionList = {
		"HeraldOfAgonySpiderPlated",
	},
	statMap = {
		["skill_buff_grants_chance_to_poison_%"] = {
			mod("PoisonChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["herald_of_agony_poison_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Poison, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["scorpion_minion_physical_damage_+%"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalDamage", "INC", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack", limitVar = "VirulenceStacksMax", limitActor = "parent"  })})
		},
		["scorpion_minion_attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("Speed", "INC", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack", limitVar = "VirulenceStacksMax", limitActor = "parent" })})
		},
		["scorpion_minion_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalMin", "BASE", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack", limitVar = "VirulenceStacksMax", limitActor = "parent" })})
		},
		["scorpion_minion_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { type = "HeraldOfAgonySpiderPlated", mod = mod("PhysicalMax", "BASE", nil, 0, 0, { type = "Multiplier", actor = "parent", var = "VirulenceStack", limitVar = "VirulenceStacksMax", limitActor = "parent" })})
		},
		["maximum_virulence_stacks"] = {
			mod("Multiplier:VirulenceStacksMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura", effectName = "Virulence Stack Limit", unscalable = true }),
		},
		["quality_display_herald_of_agony_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		cast = true,
		minion = true,
		permanentMinion = true,
	},
	qualityStats = {
		Default = {
			{ "maximum_virulence_stacks", 0.25 },
		},
	},
	constantStats = {
		{ "skill_buff_grants_chance_to_poison_%", 20 },
		{ "herald_of_agony_poison_damage_+%_final", 10 },
		{ "base_number_of_herald_scorpions_allowed", 1 },
		{ "maximum_virulence_stacks", 40 },
	},
	stats = {
		"scorpion_minion_minimum_added_physical_damage",
		"scorpion_minion_maximum_added_physical_damage",
		"scorpion_minion_physical_damage_+%",
		"scorpion_minion_attack_speed_+%",
		"herald_of_agony_add_stack_on_poison",
		"minions_cannot_taunt_enemies",
		"infinite_minion_duration",
		"quality_display_herald_of_agony_is_gem",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 5, 2, cooldown = 1, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[2] = { 0.69999998807907, 1.2999999523163, 5, 2, cooldown = 1, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[3] = { 0.69999998807907, 1.2999999523163, 5, 2, cooldown = 1, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[4] = { 0.69999998807907, 1.2999999523163, 6, 2, cooldown = 1, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[5] = { 0.69999998807907, 1.2999999523163, 6, 3, cooldown = 1, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[6] = { 0.69999998807907, 1.2999999523163, 6, 3, cooldown = 1, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[7] = { 0.69999998807907, 1.2999999523163, 6, 3, cooldown = 1, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[8] = { 0.69999998807907, 1.2999999523163, 6, 3, cooldown = 1, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[9] = { 0.69999998807907, 1.2999999523163, 7, 3, cooldown = 1, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[10] = { 0.69999998807907, 1.2999999523163, 7, 3, cooldown = 1, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[11] = { 0.69999998807907, 1.2999999523163, 7, 3, cooldown = 1, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[12] = { 0.69999998807907, 1.2999999523163, 7, 3, cooldown = 1, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[13] = { 0.69999998807907, 1.2999999523163, 8, 4, cooldown = 1, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[14] = { 0.69999998807907, 1.2999999523163, 8, 4, cooldown = 1, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[15] = { 0.69999998807907, 1.2999999523163, 8, 4, cooldown = 1, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[16] = { 0.69999998807907, 1.2999999523163, 8, 4, cooldown = 1, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[17] = { 0.69999998807907, 1.2999999523163, 8, 4, cooldown = 1, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[18] = { 0.69999998807907, 1.2999999523163, 9, 4, cooldown = 1, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[19] = { 0.69999998807907, 1.2999999523163, 9, 4, cooldown = 1, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[20] = { 0.69999998807907, 1.2999999523163, 9, 4, cooldown = 1, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[21] = { 0.69999998807907, 1.2999999523163, 9, 5, cooldown = 1, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[22] = { 0.69999998807907, 1.2999999523163, 9, 5, cooldown = 1, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[23] = { 0.69999998807907, 1.2999999523163, 10, 5, cooldown = 1, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[24] = { 0.69999998807907, 1.2999999523163, 10, 5, cooldown = 1, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[25] = { 0.69999998807907, 1.2999999523163, 10, 5, cooldown = 1, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[26] = { 0.69999998807907, 1.2999999523163, 10, 5, cooldown = 1, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[27] = { 0.69999998807907, 1.2999999523163, 10, 5, cooldown = 1, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[28] = { 0.69999998807907, 1.2999999523163, 11, 5, cooldown = 1, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[29] = { 0.69999998807907, 1.2999999523163, 11, 6, cooldown = 1, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[30] = { 0.69999998807907, 1.2999999523163, 11, 6, cooldown = 1, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[31] = { 0.69999998807907, 1.2999999523163, 11, 6, cooldown = 1, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[32] = { 0.69999998807907, 1.2999999523163, 11, 6, cooldown = 1, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[33] = { 0.69999998807907, 1.2999999523163, 11, 6, cooldown = 1, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[34] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[35] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[36] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[37] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[38] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[39] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[40] = { 0.69999998807907, 1.2999999523163, 12, 6, cooldown = 1, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
	},
}
skills["HeraldOfIce"] = {
	name = "Herald of Ice",
	baseTypeName = "Herald of Ice",
	color = 2,
	baseEffectiveness = 1.3636000156403,
	incrementalEffectiveness = 0.023000000044703,
	description = "Grants a buff adding cold damage to spells and attacks. If you shatter an enemy, this skill will cause them to explode and deal AoE cold damage to enemies near them. This damage is not affected by modifiers to spell damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Herald] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["spell_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["spell_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		cast = true,
		area = true,
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.1 },
		},
	},
	constantStats = {
		{ "skill_override_pvp_scaling_time_ms", 1000 },
		{ "active_skill_base_area_of_effect_radius", 12 },
	},
	stats = {
		"spell_minimum_added_cold_damage",
		"spell_maximum_added_cold_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"secondary_minimum_base_cold_damage",
		"secondary_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"damage_cannot_be_reflected",
		"skill_can_add_multiple_charges_per_action",
	},
	notMinionStat = {
		"secondary_minimum_base_cold_damage",
		"secondary_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 18, 26, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 16, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[2] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 23, 35, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 20, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[3] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 30, 45, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 24, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[4] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 38, 57, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 28, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[5] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 45, 67, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 31, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[6] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 53, 80, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 34, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[7] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 62, 94, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 37, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[8] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 73, 110, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 40, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[9] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 85, 128, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 43, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[10] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 99, 149, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 46, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[11] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 115, 173, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 49, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[12] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 134, 200, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 52, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[13] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 154, 232, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 55, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[14] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 178, 267, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 58, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[15] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 195, 293, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 60, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[16] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 214, 321, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 62, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[17] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 235, 352, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 64, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[18] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 257, 386, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 66, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[19] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 282, 422, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 68, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[20] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 308, 462, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 70, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[21] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 337, 505, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 72, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[22] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 368, 552, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 74, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[23] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 402, 603, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 76, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[24] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 438, 658, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 78, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[25] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 478, 717, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 80, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[26] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 521, 782, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 82, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[27] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 568, 852, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 84, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[28] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 619, 928, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 86, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[29] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 674, 1010, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 88, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[30] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 733, 1100, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 90, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[31] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 765, 1149, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 91, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[32] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 796, 1198, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 92, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[33] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 830, 1251, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 93, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[34] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 863, 1304, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 94, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[35] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 899, 1361, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 95, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[36] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 934, 1418, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 96, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[37] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 971, 1479, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 97, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[38] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1008, 1540, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 98, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[39] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1047, 1605, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 99, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
		[40] = { 0.20000000298023, 0.30000001192093, 0.20000000298023, 0.30000001192093, 1085, 1670, cooldown = 1, damageEffectiveness = 0.8, levelRequirement = 100, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, 1, }, },
	},
}
skills["IceShot"] = {
	name = "Ice Shot",
	baseTypeName = "Ice Shot",
	color = 2,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToCold", "BASE", 40, 0, 0, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "skill_area_angle_+%", 4 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 60 },
		{ "active_skill_base_area_of_effect_radius", 24 },
	},
	stats = {
		"active_skill_chill_as_though_damage_+%_final",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 100, baseMultiplier = 1.495, damageEffectiveness = 1.495, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 105, baseMultiplier = 1.521, damageEffectiveness = 1.521, levelRequirement = 2, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 110, baseMultiplier = 1.548, damageEffectiveness = 1.548, levelRequirement = 4, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[4] = { 115, baseMultiplier = 1.574, damageEffectiveness = 1.574, levelRequirement = 7, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[5] = { 120, baseMultiplier = 1.602, damageEffectiveness = 1.602, levelRequirement = 11, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[6] = { 125, baseMultiplier = 1.628, damageEffectiveness = 1.628, levelRequirement = 16, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[7] = { 130, baseMultiplier = 1.655, damageEffectiveness = 1.655, levelRequirement = 20, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[8] = { 135, baseMultiplier = 1.681, damageEffectiveness = 1.681, levelRequirement = 24, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[9] = { 140, baseMultiplier = 1.708, damageEffectiveness = 1.708, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[10] = { 145, baseMultiplier = 1.734, damageEffectiveness = 1.734, levelRequirement = 32, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 150, baseMultiplier = 1.762, damageEffectiveness = 1.762, levelRequirement = 36, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[12] = { 155, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[13] = { 160, baseMultiplier = 1.815, damageEffectiveness = 1.815, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[14] = { 165, baseMultiplier = 1.841, damageEffectiveness = 1.841, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 170, baseMultiplier = 1.868, damageEffectiveness = 1.868, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 175, baseMultiplier = 1.894, damageEffectiveness = 1.894, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[17] = { 180, baseMultiplier = 1.922, damageEffectiveness = 1.922, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[18] = { 185, baseMultiplier = 1.948, damageEffectiveness = 1.948, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 190, baseMultiplier = 1.975, damageEffectiveness = 1.975, levelRequirement = 67, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 195, baseMultiplier = 2.001, damageEffectiveness = 2.001, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 200, baseMultiplier = 2.027, damageEffectiveness = 2.027, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 205, baseMultiplier = 2.054, damageEffectiveness = 2.054, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 210, baseMultiplier = 2.08, damageEffectiveness = 2.08, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 215, baseMultiplier = 2.108, damageEffectiveness = 2.108, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 220, baseMultiplier = 2.134, damageEffectiveness = 2.134, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 225, baseMultiplier = 2.161, damageEffectiveness = 2.161, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 230, baseMultiplier = 2.187, damageEffectiveness = 2.187, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 235, baseMultiplier = 2.214, damageEffectiveness = 2.214, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 240, baseMultiplier = 2.24, damageEffectiveness = 2.24, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 245, baseMultiplier = 2.268, damageEffectiveness = 2.268, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 247, baseMultiplier = 2.28, damageEffectiveness = 2.28, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 250, baseMultiplier = 2.294, damageEffectiveness = 2.294, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 252, baseMultiplier = 2.307, damageEffectiveness = 2.307, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 255, baseMultiplier = 2.321, damageEffectiveness = 2.321, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 257, baseMultiplier = 2.333, damageEffectiveness = 2.333, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 260, baseMultiplier = 2.347, damageEffectiveness = 2.347, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 262, baseMultiplier = 2.361, damageEffectiveness = 2.361, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 265, baseMultiplier = 2.374, damageEffectiveness = 2.374, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 267, baseMultiplier = 2.387, damageEffectiveness = 2.387, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 270, baseMultiplier = 2.4, damageEffectiveness = 2.4, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["IceShotAltX"] = {
	name = "Ice Shot of Penetration",
	baseTypeName = "Ice Shot of Penetration",
	color = 2,
	description = "Fires a piercing arrow that converts some physical damage to cold on its target and converts all physical damage to cold in two cones perpendicular to the target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToCold", "BASE", 40, 0, 0, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "skill_area_angle_+%", 4 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 60 },
		{ "active_skill_base_area_of_effect_radius", 26 },
		{ "projectile_base_number_of_targets_to_pierce", 3 },
	},
	stats = {
		"active_skill_chill_as_though_damage_+%_final",
		"active_skill_base_area_of_effect_radius",
		"skill_can_fire_arrows",
		"modifiers_to_projectile_count_do_not_apply",
	},
	levels = {
		[1] = { 100, 0, attackSpeedMultiplier = -25, baseMultiplier = 1.8, damageEffectiveness = 1.8, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 7, }, },
		[2] = { 105, 0, attackSpeedMultiplier = -25, baseMultiplier = 1.853, damageEffectiveness = 1.853, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[3] = { 110, 1, attackSpeedMultiplier = -25, baseMultiplier = 1.905, damageEffectiveness = 1.905, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[4] = { 115, 1, attackSpeedMultiplier = -25, baseMultiplier = 1.958, damageEffectiveness = 1.958, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 120, 1, attackSpeedMultiplier = -25, baseMultiplier = 2.011, damageEffectiveness = 2.011, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 125, 1, attackSpeedMultiplier = -25, baseMultiplier = 2.063, damageEffectiveness = 2.063, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[7] = { 130, 2, attackSpeedMultiplier = -25, baseMultiplier = 2.116, damageEffectiveness = 2.116, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[8] = { 135, 2, attackSpeedMultiplier = -25, baseMultiplier = 2.168, damageEffectiveness = 2.168, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { Mana = 9, }, },
		[9] = { 140, 2, attackSpeedMultiplier = -25, baseMultiplier = 2.221, damageEffectiveness = 2.221, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[10] = { 145, 3, attackSpeedMultiplier = -25, baseMultiplier = 2.274, damageEffectiveness = 2.274, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[11] = { 150, 3, attackSpeedMultiplier = -25, baseMultiplier = 2.326, damageEffectiveness = 2.326, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[12] = { 155, 3, attackSpeedMultiplier = -25, baseMultiplier = 2.379, damageEffectiveness = 2.379, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[13] = { 160, 3, attackSpeedMultiplier = -25, baseMultiplier = 2.432, damageEffectiveness = 2.432, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[14] = { 165, 4, attackSpeedMultiplier = -25, baseMultiplier = 2.484, damageEffectiveness = 2.484, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[15] = { 170, 4, attackSpeedMultiplier = -25, baseMultiplier = 2.537, damageEffectiveness = 2.537, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[16] = { 175, 4, attackSpeedMultiplier = -25, baseMultiplier = 2.589, damageEffectiveness = 2.589, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[17] = { 180, 5, attackSpeedMultiplier = -25, baseMultiplier = 2.642, damageEffectiveness = 2.642, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[18] = { 185, 5, attackSpeedMultiplier = -25, baseMultiplier = 2.695, damageEffectiveness = 2.695, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[19] = { 190, 5, attackSpeedMultiplier = -25, baseMultiplier = 2.747, damageEffectiveness = 2.747, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[20] = { 195, 5, attackSpeedMultiplier = -25, baseMultiplier = 2.8, damageEffectiveness = 2.8, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[21] = { 200, 6, attackSpeedMultiplier = -25, baseMultiplier = 2.853, damageEffectiveness = 2.853, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[22] = { 205, 6, attackSpeedMultiplier = -25, baseMultiplier = 2.905, damageEffectiveness = 2.905, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[23] = { 210, 6, attackSpeedMultiplier = -25, baseMultiplier = 2.958, damageEffectiveness = 2.958, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[24] = { 215, 7, attackSpeedMultiplier = -25, baseMultiplier = 3.011, damageEffectiveness = 3.011, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[25] = { 220, 7, attackSpeedMultiplier = -25, baseMultiplier = 3.063, damageEffectiveness = 3.063, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[26] = { 225, 7, attackSpeedMultiplier = -25, baseMultiplier = 3.116, damageEffectiveness = 3.116, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[27] = { 230, 7, attackSpeedMultiplier = -25, baseMultiplier = 3.168, damageEffectiveness = 3.168, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[28] = { 235, 8, attackSpeedMultiplier = -25, baseMultiplier = 3.221, damageEffectiveness = 3.221, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[29] = { 240, 8, attackSpeedMultiplier = -25, baseMultiplier = 3.274, damageEffectiveness = 3.274, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[30] = { 245, 8, attackSpeedMultiplier = -25, baseMultiplier = 3.326, damageEffectiveness = 3.326, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[31] = { 247, 8, attackSpeedMultiplier = -25, baseMultiplier = 3.353, damageEffectiveness = 3.353, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[32] = { 250, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.379, damageEffectiveness = 3.379, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[33] = { 252, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.405, damageEffectiveness = 3.405, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[34] = { 255, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.432, damageEffectiveness = 3.432, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[35] = { 257, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.458, damageEffectiveness = 3.458, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[36] = { 260, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.484, damageEffectiveness = 3.484, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[37] = { 262, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.511, damageEffectiveness = 3.511, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[38] = { 265, 9, attackSpeedMultiplier = -25, baseMultiplier = 3.537, damageEffectiveness = 3.537, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[39] = { 267, 10, attackSpeedMultiplier = -25, baseMultiplier = 3.563, damageEffectiveness = 3.563, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[40] = { 270, 10, attackSpeedMultiplier = -25, baseMultiplier = 3.589, damageEffectiveness = 3.589, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
	},
}
skills["VaalIceShot"] = {
	name = "Vaal Ice Shot",
	baseTypeName = "Vaal Ice Shot",
	color = 2,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target. When you use this skill, it summons a squad of Mirage Sharpshooters for a duration. Cannot be used by Totems, Traps, or Mines.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.Vaal] = true, [SkillType.Duration] = true, [SkillType.ProjectilesNotFired] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	qualityStats = {
		Default = {
			{ "skill_area_angle_+%", 4 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 60 },
		{ "base_skill_effect_duration", 6000 },
		{ "maximum_number_of_vaal_ice_shot_mirages", 6 },
	},
	stats = {
		"skill_can_fire_arrows",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"vaal_ice_shot_modifiers_to_projectile_count_do_not_apply_to_mirages",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { baseMultiplier = 0.747, damageEffectiveness = 0.747, levelRequirement = 1, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[2] = { baseMultiplier = 0.76, damageEffectiveness = 0.76, levelRequirement = 2, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[3] = { baseMultiplier = 0.774, damageEffectiveness = 0.774, levelRequirement = 4, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[4] = { baseMultiplier = 0.787, damageEffectiveness = 0.787, levelRequirement = 7, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[5] = { baseMultiplier = 0.8, damageEffectiveness = 0.8, levelRequirement = 11, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[6] = { baseMultiplier = 0.814, damageEffectiveness = 0.814, levelRequirement = 16, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[7] = { baseMultiplier = 0.827, damageEffectiveness = 0.827, levelRequirement = 20, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[8] = { baseMultiplier = 0.841, damageEffectiveness = 0.841, levelRequirement = 24, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[9] = { baseMultiplier = 0.853, damageEffectiveness = 0.853, levelRequirement = 28, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[10] = { baseMultiplier = 0.867, damageEffectiveness = 0.867, levelRequirement = 32, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[11] = { baseMultiplier = 0.881, damageEffectiveness = 0.881, levelRequirement = 36, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[12] = { baseMultiplier = 0.894, damageEffectiveness = 0.894, levelRequirement = 40, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[13] = { baseMultiplier = 0.907, damageEffectiveness = 0.907, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[14] = { baseMultiplier = 0.92, damageEffectiveness = 0.92, levelRequirement = 48, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[15] = { baseMultiplier = 0.934, damageEffectiveness = 0.934, levelRequirement = 52, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[16] = { baseMultiplier = 0.946, damageEffectiveness = 0.946, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[17] = { baseMultiplier = 0.96, damageEffectiveness = 0.96, levelRequirement = 60, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[18] = { baseMultiplier = 0.974, damageEffectiveness = 0.974, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[19] = { baseMultiplier = 0.987, damageEffectiveness = 0.987, levelRequirement = 67, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[20] = { baseMultiplier = 1.001, damageEffectiveness = 1.001, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[21] = { baseMultiplier = 1.013, damageEffectiveness = 1.013, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[22] = { baseMultiplier = 1.027, damageEffectiveness = 1.027, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[23] = { baseMultiplier = 1.04, damageEffectiveness = 1.04, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[24] = { baseMultiplier = 1.053, damageEffectiveness = 1.053, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[25] = { baseMultiplier = 1.067, damageEffectiveness = 1.067, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[26] = { baseMultiplier = 1.08, damageEffectiveness = 1.08, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[27] = { baseMultiplier = 1.094, damageEffectiveness = 1.094, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[28] = { baseMultiplier = 1.106, damageEffectiveness = 1.106, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[29] = { baseMultiplier = 1.12, damageEffectiveness = 1.12, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[30] = { baseMultiplier = 1.134, damageEffectiveness = 1.134, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[31] = { baseMultiplier = 1.14, damageEffectiveness = 1.14, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[32] = { baseMultiplier = 1.147, damageEffectiveness = 1.147, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[33] = { baseMultiplier = 1.153, damageEffectiveness = 1.153, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[34] = { baseMultiplier = 1.16, damageEffectiveness = 1.16, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[35] = { baseMultiplier = 1.167, damageEffectiveness = 1.167, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[36] = { baseMultiplier = 1.174, damageEffectiveness = 1.174, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[37] = { baseMultiplier = 1.181, damageEffectiveness = 1.181, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[38] = { baseMultiplier = 1.187, damageEffectiveness = 1.187, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[39] = { baseMultiplier = 1.194, damageEffectiveness = 1.194, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
		[40] = { baseMultiplier = 1.201, damageEffectiveness = 1.201, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 1, cost = { Soul = 40, }, },
	},
}
skills["IceTrap"] = {
	name = "Ice Trap",
	baseTypeName = "Ice Trap",
	color = 2,
	baseEffectiveness = 2.3310000896454,
	incrementalEffectiveness = 0.046999998390675,
	description = "Throws a trap that creates a series of icy runic explosions when triggered, dealing cold damage to all enemies caught in the blasts.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Cold] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "First Explosion:"),
		skill("radiusSecondaryLabel", "Second Explosion:"),
		skill("radiusTertiaryLabel", "Third Explosion:"),
	},
	qualityStats = {
		Default = {
			{ "trap_%_chance_to_trigger_twice", 0.75 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 4000 },
		{ "active_skill_base_area_of_effect_radius", 18 },
		{ "active_skill_base_secondary_area_of_effect_radius", 9 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 6 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.3, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.4, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.4, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.4, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.6, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.6, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.6, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.6, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.7, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.7, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.7, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.8, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.8, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.8, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.8, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
	},
}
skills["IceTrapAltX"] = {
	name = "Ice Trap of Hollowness",
	baseTypeName = "Ice Trap of Hollowness",
	color = 2,
	baseEffectiveness = 2.7999999523163,
	incrementalEffectiveness = 0.046999998390675,
	description = "Throws a trap that creates a series of icy runic explosions in a circle around itself when triggered, dealing cold damage to all enemies caught in the blasts.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.Cold] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "First Explosion:"),
		skill("radiusSecondaryLabel", "Second Explosion:"),
	},
	qualityStats = {
		Default = {
			{ "trap_%_chance_to_trigger_twice", 0.75 },
		},
	},
	constantStats = {
		{ "base_trap_duration", 2000 },
		{ "active_skill_base_area_of_effect_radius", 18 },
		{ "active_skill_base_secondary_area_of_effect_radius", 12 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
		"quality_display_trap_duration_is_gem",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.8, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 31, statInterpolation = { 3, 3, }, cost = { Mana = 13, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 34, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 2.9, levelRequirement = 37, statInterpolation = { 3, 3, }, cost = { Mana = 14, }, },
		[5] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3, levelRequirement = 40, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[6] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3, levelRequirement = 42, statInterpolation = { 3, 3, }, cost = { Mana = 15, }, },
		[7] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3, levelRequirement = 44, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[8] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.1, levelRequirement = 46, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[9] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.1, levelRequirement = 48, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[10] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.1, levelRequirement = 50, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[11] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.2, levelRequirement = 52, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[12] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.2, levelRequirement = 54, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[13] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.2, levelRequirement = 56, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[14] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.2, levelRequirement = 58, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[15] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.3, levelRequirement = 60, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[16] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.3, levelRequirement = 62, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[17] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.3, levelRequirement = 64, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[18] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 66, statInterpolation = { 3, 3, }, cost = { Mana = 21, }, },
		[19] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 22, }, },
		[21] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 72, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[22] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 74, statInterpolation = { 3, 3, }, cost = { Mana = 23, }, },
		[23] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 76, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[24] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 78, statInterpolation = { 3, 3, }, cost = { Mana = 24, }, },
		[25] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 80, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[26] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { Mana = 25, }, },
		[27] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 84, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[28] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 86, statInterpolation = { 3, 3, }, cost = { Mana = 26, }, },
		[29] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 88, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[30] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 90, statInterpolation = { 3, 3, }, cost = { Mana = 27, }, },
		[31] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 91, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[32] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 92, statInterpolation = { 3, 3, }, cost = { Mana = 28, }, },
		[33] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 93, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[34] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 94, statInterpolation = { 3, 3, }, cost = { Mana = 29, }, },
		[35] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 95, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[36] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 96, statInterpolation = { 3, 3, }, cost = { Mana = 30, }, },
		[37] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 97, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[38] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 98, statInterpolation = { 3, 3, }, cost = { Mana = 31, }, },
		[39] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 99, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
		[40] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 3.4, levelRequirement = 100, statInterpolation = { 3, 3, }, cost = { Mana = 32, }, },
	},
}
skills["Lacerate"] = {
	name = "Lacerate",
	baseTypeName = "Lacerate",
	color = 2,
	description = "Slashes twice, releasing waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. The slashes will have a chance to inflict bleeding in Blood Stance, or have a wider angle in Sand Stance. Can be used with Axes and Swords. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One slash",
		},
		{
			name = "Both slashes",
		},
	},
	statMap = {
		["attack_speed_+%_if_changed_stance_recently"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "Condition", var = "ChangedStanceRecently" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 38),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "attack_speed_+%_if_changed_stance_recently", 1 },
		},
	},
	constantStats = {
		{ "chance_to_bleed_on_hit_%_chance_in_blood_stance", 25 },
		{ "skill_angle_+%_in_sand_stance", 50 },
	},
	stats = {
		"active_skill_base_radius_+",
		"active_skill_bleeding_damage_+%_final_in_blood_stance",
		"is_area_damage",
		"console_skill_dont_chase",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0, 50, attackSpeedMultiplier = -40, baseMultiplier = 1.711, damageEffectiveness = 1.711, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 10, }, },
		[2] = { 0, 52, attackSpeedMultiplier = -40, baseMultiplier = 1.788, damageEffectiveness = 1.788, levelRequirement = 15, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[3] = { 1, 54, attackSpeedMultiplier = -40, baseMultiplier = 1.871, damageEffectiveness = 1.871, levelRequirement = 19, statInterpolation = { 1, 1, }, cost = { Mana = 11, }, },
		[4] = { 1, 56, attackSpeedMultiplier = -40, baseMultiplier = 1.959, damageEffectiveness = 1.959, levelRequirement = 23, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[5] = { 2, 58, attackSpeedMultiplier = -40, baseMultiplier = 2.05, damageEffectiveness = 2.05, levelRequirement = 27, statInterpolation = { 1, 1, }, cost = { Mana = 12, }, },
		[6] = { 2, 60, attackSpeedMultiplier = -40, baseMultiplier = 2.146, damageEffectiveness = 2.146, levelRequirement = 31, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[7] = { 3, 62, attackSpeedMultiplier = -40, baseMultiplier = 2.246, damageEffectiveness = 2.246, levelRequirement = 35, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[8] = { 3, 64, attackSpeedMultiplier = -40, baseMultiplier = 2.346, damageEffectiveness = 2.346, levelRequirement = 38, statInterpolation = { 1, 1, }, cost = { Mana = 13, }, },
		[9] = { 4, 66, attackSpeedMultiplier = -40, baseMultiplier = 2.451, damageEffectiveness = 2.451, levelRequirement = 41, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[10] = { 4, 68, attackSpeedMultiplier = -40, baseMultiplier = 2.561, damageEffectiveness = 2.561, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[11] = { 5, 70, attackSpeedMultiplier = -40, baseMultiplier = 2.675, damageEffectiveness = 2.675, levelRequirement = 47, statInterpolation = { 1, 1, }, cost = { Mana = 14, }, },
		[12] = { 5, 72, attackSpeedMultiplier = -40, baseMultiplier = 2.794, damageEffectiveness = 2.794, levelRequirement = 50, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[13] = { 6, 74, attackSpeedMultiplier = -40, baseMultiplier = 2.918, damageEffectiveness = 2.918, levelRequirement = 53, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[14] = { 6, 76, attackSpeedMultiplier = -40, baseMultiplier = 3.049, damageEffectiveness = 3.049, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { Mana = 15, }, },
		[15] = { 7, 78, attackSpeedMultiplier = -40, baseMultiplier = 3.185, damageEffectiveness = 3.185, levelRequirement = 59, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[16] = { 7, 80, attackSpeedMultiplier = -40, baseMultiplier = 3.325, damageEffectiveness = 3.325, levelRequirement = 62, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[17] = { 8, 82, attackSpeedMultiplier = -40, baseMultiplier = 3.468, damageEffectiveness = 3.468, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[18] = { 8, 84, attackSpeedMultiplier = -40, baseMultiplier = 3.616, damageEffectiveness = 3.616, levelRequirement = 66, statInterpolation = { 1, 1, }, cost = { Mana = 16, }, },
		[19] = { 9, 86, attackSpeedMultiplier = -40, baseMultiplier = 3.771, damageEffectiveness = 3.771, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[20] = { 9, 88, attackSpeedMultiplier = -40, baseMultiplier = 3.931, damageEffectiveness = 3.931, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[21] = { 10, 90, attackSpeedMultiplier = -40, baseMultiplier = 4.099, damageEffectiveness = 4.099, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[22] = { 10, 92, attackSpeedMultiplier = -40, baseMultiplier = 4.273, damageEffectiveness = 4.273, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[23] = { 11, 94, attackSpeedMultiplier = -40, baseMultiplier = 4.456, damageEffectiveness = 4.456, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { Mana = 17, }, },
		[24] = { 11, 96, attackSpeedMultiplier = -40, baseMultiplier = 4.646, damageEffectiveness = 4.646, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[25] = { 12, 98, attackSpeedMultiplier = -40, baseMultiplier = 4.845, damageEffectiveness = 4.845, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[26] = { 12, 100, attackSpeedMultiplier = -40, baseMultiplier = 5.051, damageEffectiveness = 5.051, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[27] = { 13, 102, attackSpeedMultiplier = -40, baseMultiplier = 5.266, damageEffectiveness = 5.266, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[28] = { 13, 104, attackSpeedMultiplier = -40, baseMultiplier = 5.49, damageEffectiveness = 5.49, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { Mana = 18, }, },
		[29] = { 14, 106, attackSpeedMultiplier = -40, baseMultiplier = 5.725, damageEffectiveness = 5.725, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[30] = { 14, 108, attackSpeedMultiplier = -40, baseMultiplier = 5.968, damageEffectiveness = 5.968, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[31] = { 14, 109, attackSpeedMultiplier = -40, baseMultiplier = 6.334, damageEffectiveness = 6.334, levelRequirement = 91, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[32] = { 15, 110, attackSpeedMultiplier = -40, baseMultiplier = 6.469, damageEffectiveness = 6.469, levelRequirement = 92, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[33] = { 15, 111, attackSpeedMultiplier = -40, baseMultiplier = 6.607, damageEffectiveness = 6.607, levelRequirement = 93, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[34] = { 15, 112, attackSpeedMultiplier = -40, baseMultiplier = 6.746, damageEffectiveness = 6.746, levelRequirement = 94, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[35] = { 15, 113, attackSpeedMultiplier = -40, baseMultiplier = 6.89, damageEffectiveness = 6.89, levelRequirement = 95, statInterpolation = { 1, 1, }, cost = { Mana = 19, }, },
		[36] = { 16, 114, attackSpeedMultiplier = -40, baseMultiplier = 7.037, damageEffectiveness = 7.037, levelRequirement = 96, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[37] = { 16, 115, attackSpeedMultiplier = -40, baseMultiplier = 7.186, damageEffectiveness = 7.186, levelRequirement = 97, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[38] = { 16, 116, attackSpeedMultiplier = -40, baseMultiplier = 7.339, damageEffectiveness = 7.339, levelRequirement = 98, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[39] = { 16, 117, attackSpeedMultiplier = -40, baseMultiplier = 7.494, damageEffectiveness = 7.494, levelRequirement = 99, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
		[40] = { 17, 118, attackSpeedMultiplier = -40, baseMultiplier = 7.654, damageEffectiveness = 7.654, levelRequirement = 100, statInterpolation = { 1, 1, }, cost = { Mana = 20, }, },
	},
}
skills["LacerateAltX"] = {
	name = "Lacerate of Butchering",
	baseTypeName = "Lacerate of Butchering",
	color = 2,
	description = "Slashes twice, releasing wide waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. Requires a Two Handed Axe or Two Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One slash",
		},
		{
			name = "Both slashes",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 38),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "active_skill_base_radius_+", 0.25 },
		},
	},
	constantStats = {
		{ "skill_angle_+%_in_sand_stance", 50 },
	},
	stats = {
		"active_skill_base_radius_+",
		"is_area_damage",
		"console_skill_dont_chase",
		"display_active_skill_forced_stance",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 4, attackSpeedMultiplier = -60, baseMultiplier = 2.738, damageEffectiveness = 2.738, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[2] = { 5, attackSpeedMultiplier = -60, baseMultiplier = 2.86, damageEffectiveness = 2.86, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 16, }, },
		[3] = { 6, attackSpeedMultiplier = -60, baseMultiplier = 2.995, damageEffectiveness = 2.995, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[4] = { 7, attackSpeedMultiplier = -60, baseMultiplier = 3.135, damageEffectiveness = 3.135, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 17, }, },
		[5] = { 8, attackSpeedMultiplier = -60, baseMultiplier = 3.281, damageEffectiveness = 3.281, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 18, }, },
		[6] = { 9, attackSpeedMultiplier = -60, baseMultiplier = 3.434, damageEffectiveness = 3.434, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[7] = { 10, attackSpeedMultiplier = -60, baseMultiplier = 3.594, damageEffectiveness = 3.594, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 19, }, },
		[8] = { 11, attackSpeedMultiplier = -60, baseMultiplier = 3.755, damageEffectiveness = 3.755, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[9] = { 12, attackSpeedMultiplier = -60, baseMultiplier = 3.921, damageEffectiveness = 3.921, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 20, }, },
		[10] = { 13, attackSpeedMultiplier = -60, baseMultiplier = 4.097, damageEffectiveness = 4.097, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[11] = { 14, attackSpeedMultiplier = -60, baseMultiplier = 4.28, damageEffectiveness = 4.28, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 21, }, },
		[12] = { 15, attackSpeedMultiplier = -60, baseMultiplier = 4.471, damageEffectiveness = 4.471, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[13] = { 16, attackSpeedMultiplier = -60, baseMultiplier = 4.67, damageEffectiveness = 4.67, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 22, }, },
		[14] = { 17, attackSpeedMultiplier = -60, baseMultiplier = 4.877, damageEffectiveness = 4.877, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[15] = { 18, attackSpeedMultiplier = -60, baseMultiplier = 5.095, damageEffectiveness = 5.095, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 23, }, },
		[16] = { 19, attackSpeedMultiplier = -60, baseMultiplier = 5.322, damageEffectiveness = 5.322, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[17] = { 20, attackSpeedMultiplier = -60, baseMultiplier = 5.548, damageEffectiveness = 5.548, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[18] = { 21, attackSpeedMultiplier = -60, baseMultiplier = 5.785, damageEffectiveness = 5.785, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 24, }, },
		[19] = { 22, attackSpeedMultiplier = -60, baseMultiplier = 6.032, damageEffectiveness = 6.032, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[20] = { 23, attackSpeedMultiplier = -60, baseMultiplier = 6.29, damageEffectiveness = 6.29, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[21] = { 24, attackSpeedMultiplier = -60, baseMultiplier = 6.558, damageEffectiveness = 6.558, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 25, }, },
		[22] = { 25, attackSpeedMultiplier = -60, baseMultiplier = 6.839, damageEffectiveness = 6.839, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[23] = { 26, attackSpeedMultiplier = -60, baseMultiplier = 7.13, damageEffectiveness = 7.13, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[24] = { 27, attackSpeedMultiplier = -60, baseMultiplier = 7.434, damageEffectiveness = 7.434, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 26, }, },
		[25] = { 28, attackSpeedMultiplier = -60, baseMultiplier = 7.751, damageEffectiveness = 7.751, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[26] = { 29, attackSpeedMultiplier = -60, baseMultiplier = 8.081, damageEffectiveness = 8.081, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[27] = { 30, attackSpeedMultiplier = -60, baseMultiplier = 8.426, damageEffectiveness = 8.426, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 27, }, },
		[28] = { 31, attackSpeedMultiplier = -60, baseMultiplier = 8.785, damageEffectiveness = 8.785, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[29] = { 32, attackSpeedMultiplier = -60, baseMultiplier = 9.159, damageEffectiveness = 9.159, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[30] = { 33, attackSpeedMultiplier = -60, baseMultiplier = 9.549, damageEffectiveness = 9.549, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 28, }, },
		[31] = { 34, attackSpeedMultiplier = -60, baseMultiplier = 10.135, damageEffectiveness = 10.135, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[32] = { 34, attackSpeedMultiplier = -60, baseMultiplier = 10.35, damageEffectiveness = 10.35, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[33] = { 35, attackSpeedMultiplier = -60, baseMultiplier = 10.57, damageEffectiveness = 10.57, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[34] = { 35, attackSpeedMultiplier = -60, baseMultiplier = 10.795, damageEffectiveness = 10.795, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[35] = { 36, attackSpeedMultiplier = -60, baseMultiplier = 11.024, damageEffectiveness = 11.024, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[36] = { 36, attackSpeedMultiplier = -60, baseMultiplier = 11.259, damageEffectiveness = 11.259, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 29, }, },
		[37] = { 37, attackSpeedMultiplier = -60, baseMultiplier = 11.498, damageEffectiveness = 11.498, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[38] = { 37, attackSpeedMultiplier = -60, baseMultiplier = 11.741, damageEffectiveness = 11.741, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[39] = { 38, attackSpeedMultiplier = -60, baseMultiplier = 11.991, damageEffectiveness = 11.991, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 30, }, },
		[40] = { 38, attackSpeedMultiplier = -60, baseMultiplier = 12.246, damageEffectiveness = 12.246, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 30, }, },
	},
}
skills["LacerateAltY"] = {
	name = "Lacerate of Haemorrhage",
	baseTypeName = "Lacerate of Haemorrhage",
	color = 2,
	description = "Slashes twice, releasing waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. Requires a One Handed Axe or One Handed Sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "One slash",
		},
		{
			name = "Both slashes",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 38),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		Default = {
			{ "active_skill_bleeding_damage_+%_final", 2 },
		},
	},
	constantStats = {
		{ "bleed_on_hit_with_attacks_%", 25 },
	},
	stats = {
		"active_skill_bleeding_damage_+%_final",
		"is_area_damage",
		"console_skill_dont_chase",
		"quality_display_active_skill_bleed_damage_final_is_gem",
	},
	notMinionStat = {
		"active_skill_bleeding_damage_+%_final",
	},
	levels = {
		[1] = { 75, attackSpeedMultiplier = -20, baseMultiplier = 1.506, damageEffectiveness = 1.506, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[2] = { 78, attackSpeedMultiplier = -20, baseMultiplier = 1.574, damageEffectiveness = 1.574, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[3] = { 81, attackSpeedMultiplier = -20, baseMultiplier = 1.647, damageEffectiveness = 1.647, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[4] = { 84, attackSpeedMultiplier = -20, baseMultiplier = 1.723, damageEffectiveness = 1.723, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[5] = { 87, attackSpeedMultiplier = -20, baseMultiplier = 1.805, damageEffectiveness = 1.805, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[6] = { 90, attackSpeedMultiplier = -20, baseMultiplier = 1.888, damageEffectiveness = 1.888, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[7] = { 93, attackSpeedMultiplier = -20, baseMultiplier = 1.976, damageEffectiveness = 1.976, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 96, attackSpeedMultiplier = -20, baseMultiplier = 2.064, damageEffectiveness = 2.064, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[9] = { 99, attackSpeedMultiplier = -20, baseMultiplier = 2.157, damageEffectiveness = 2.157, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[10] = { 102, attackSpeedMultiplier = -20, baseMultiplier = 2.253, damageEffectiveness = 2.253, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[11] = { 105, attackSpeedMultiplier = -20, baseMultiplier = 2.354, damageEffectiveness = 2.354, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 108, attackSpeedMultiplier = -20, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 111, attackSpeedMultiplier = -20, baseMultiplier = 2.568, damageEffectiveness = 2.568, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 114, attackSpeedMultiplier = -20, baseMultiplier = 2.683, damageEffectiveness = 2.683, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[15] = { 117, attackSpeedMultiplier = -20, baseMultiplier = 2.801, damageEffectiveness = 2.801, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 120, attackSpeedMultiplier = -20, baseMultiplier = 2.927, damageEffectiveness = 2.927, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 123, attackSpeedMultiplier = -20, baseMultiplier = 3.052, damageEffectiveness = 3.052, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 126, attackSpeedMultiplier = -20, baseMultiplier = 3.182, damageEffectiveness = 3.182, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 129, attackSpeedMultiplier = -20, baseMultiplier = 3.318, damageEffectiveness = 3.318, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 132, attackSpeedMultiplier = -20, baseMultiplier = 3.46, damageEffectiveness = 3.46, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 135, attackSpeedMultiplier = -20, baseMultiplier = 3.607, damageEffectiveness = 3.607, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 138, attackSpeedMultiplier = -20, baseMultiplier = 3.762, damageEffectiveness = 3.762, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 141, attackSpeedMultiplier = -20, baseMultiplier = 3.922, damageEffectiveness = 3.922, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 144, attackSpeedMultiplier = -20, baseMultiplier = 4.089, damageEffectiveness = 4.089, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 147, attackSpeedMultiplier = -20, baseMultiplier = 4.264, damageEffectiveness = 4.264, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 150, attackSpeedMultiplier = -20, baseMultiplier = 4.445, damageEffectiveness = 4.445, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 153, attackSpeedMultiplier = -20, baseMultiplier = 4.634, damageEffectiveness = 4.634, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 156, attackSpeedMultiplier = -20, baseMultiplier = 4.832, damageEffectiveness = 4.832, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 159, attackSpeedMultiplier = -20, baseMultiplier = 5.037, damageEffectiveness = 5.037, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 162, attackSpeedMultiplier = -20, baseMultiplier = 5.251, damageEffectiveness = 5.251, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 164, attackSpeedMultiplier = -20, baseMultiplier = 5.575, damageEffectiveness = 5.575, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 165, attackSpeedMultiplier = -20, baseMultiplier = 5.692, damageEffectiveness = 5.692, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 167, attackSpeedMultiplier = -20, baseMultiplier = 5.814, damageEffectiveness = 5.814, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 168, attackSpeedMultiplier = -20, baseMultiplier = 5.938, damageEffectiveness = 5.938, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 170, attackSpeedMultiplier = -20, baseMultiplier = 6.063, damageEffectiveness = 6.063, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 171, attackSpeedMultiplier = -20, baseMultiplier = 6.193, damageEffectiveness = 6.193, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 173, attackSpeedMultiplier = -20, baseMultiplier = 6.324, damageEffectiveness = 6.324, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 174, attackSpeedMultiplier = -20, baseMultiplier = 6.457, damageEffectiveness = 6.457, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 176, attackSpeedMultiplier = -20, baseMultiplier = 6.595, damageEffectiveness = 6.595, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 177, attackSpeedMultiplier = -20, baseMultiplier = 6.736, damageEffectiveness = 6.736, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["LancingSteel"] = {
	name = "Lancing Steel",
	baseTypeName = "Lancing Steel",
	color = 2,
	description = "Thrust an Axe or Sword forward, consuming your Steel Shards to form a cluster of shards in front of you. The cluster will fire a number of projectiles in sequence, aiming at enemies in front of or close to it. Steel Shards are gained with the Call of Steel Skill.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, [SkillType.ProjectileSpeed] = true, [SkillType.RangedAttack] = true, [SkillType.Physical] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Steel] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			local percentReducedProjectiles = (output.ProjectileCount - 1) / output.ProjectileCount
			local mult = (activeSkill.skillModList:More(activeSkill.skillCfg, "LancingSteelSubsequentDamage") - 1) * 100 * percentReducedProjectiles
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
			activeSkill.skillModList:NewMod("Damage", "MORE", mult, "Skill:LancingSteel")
		end
	end,
	parts = {
		{
			name = "Single Projectile Hit",
		},
		{
			name = "All Projectiles Hit",
		},
	},
	statMap = {
		["number_of_projectiles_to_fire_+%_final_per_steel_ammo_consumed"] = {
			mod("ProjectileCount", "MORE", nil, 0, 0, { type = "Multiplier", var = "SteelShardConsumed", limit = 4 } )
		},
		["lancing_steel_damage_+%_at_close_range"] = {
			mod("Damage", "INC", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "DistanceRamp", ramp = {{10,1},{70,0}} }),
		},
		["lancing_steel_damage_+%_final_after_first_hit_on_target"] = {
			mod("LancingSteelSubsequentDamage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 } ),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.05 },
		},
	},
	constantStats = {
		{ "base_number_of_projectiles", 4 },
		{ "attacks_impale_on_hit_%_chance", 20 },
		{ "steel_ammo_consumed_per_use", 4 },
		{ "number_of_projectiles_to_fire_+%_final_per_steel_ammo_consumed", 50 },
		{ "lancing_steel_damage_+%_final_after_first_hit_on_target", -60 },
	},
	stats = {
		"base_is_projectile",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -20, baseMultiplier = 1.1, damageEffectiveness = 1.1, levelRequirement = 28, cost = { Mana = 9, }, },
		[2] = { attackSpeedMultiplier = -20, baseMultiplier = 1.134, damageEffectiveness = 1.134, levelRequirement = 31, cost = { Mana = 9, }, },
		[3] = { attackSpeedMultiplier = -20, baseMultiplier = 1.168, damageEffectiveness = 1.168, levelRequirement = 34, cost = { Mana = 10, }, },
		[4] = { attackSpeedMultiplier = -20, baseMultiplier = 1.203, damageEffectiveness = 1.203, levelRequirement = 37, cost = { Mana = 10, }, },
		[5] = { attackSpeedMultiplier = -20, baseMultiplier = 1.237, damageEffectiveness = 1.237, levelRequirement = 40, cost = { Mana = 10, }, },
		[6] = { attackSpeedMultiplier = -20, baseMultiplier = 1.271, damageEffectiveness = 1.271, levelRequirement = 42, cost = { Mana = 10, }, },
		[7] = { attackSpeedMultiplier = -20, baseMultiplier = 1.305, damageEffectiveness = 1.305, levelRequirement = 44, cost = { Mana = 10, }, },
		[8] = { attackSpeedMultiplier = -20, baseMultiplier = 1.339, damageEffectiveness = 1.339, levelRequirement = 46, cost = { Mana = 11, }, },
		[9] = { attackSpeedMultiplier = -20, baseMultiplier = 1.374, damageEffectiveness = 1.374, levelRequirement = 48, cost = { Mana = 11, }, },
		[10] = { attackSpeedMultiplier = -20, baseMultiplier = 1.408, damageEffectiveness = 1.408, levelRequirement = 50, cost = { Mana = 11, }, },
		[11] = { attackSpeedMultiplier = -20, baseMultiplier = 1.442, damageEffectiveness = 1.442, levelRequirement = 52, cost = { Mana = 11, }, },
		[12] = { attackSpeedMultiplier = -20, baseMultiplier = 1.476, damageEffectiveness = 1.476, levelRequirement = 54, cost = { Mana = 11, }, },
		[13] = { attackSpeedMultiplier = -20, baseMultiplier = 1.511, damageEffectiveness = 1.511, levelRequirement = 56, cost = { Mana = 11, }, },
		[14] = { attackSpeedMultiplier = -20, baseMultiplier = 1.545, damageEffectiveness = 1.545, levelRequirement = 58, cost = { Mana = 12, }, },
		[15] = { attackSpeedMultiplier = -20, baseMultiplier = 1.579, damageEffectiveness = 1.579, levelRequirement = 60, cost = { Mana = 12, }, },
		[16] = { attackSpeedMultiplier = -20, baseMultiplier = 1.613, damageEffectiveness = 1.613, levelRequirement = 62, cost = { Mana = 12, }, },
		[17] = { attackSpeedMultiplier = -20, baseMultiplier = 1.647, damageEffectiveness = 1.647, levelRequirement = 64, cost = { Mana = 12, }, },
		[18] = { attackSpeedMultiplier = -20, baseMultiplier = 1.682, damageEffectiveness = 1.682, levelRequirement = 66, cost = { Mana = 12, }, },
		[19] = { attackSpeedMultiplier = -20, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 68, cost = { Mana = 12, }, },
		[20] = { attackSpeedMultiplier = -20, baseMultiplier = 1.75, damageEffectiveness = 1.75, levelRequirement = 70, cost = { Mana = 13, }, },
		[21] = { attackSpeedMultiplier = -20, baseMultiplier = 1.784, damageEffectiveness = 1.784, levelRequirement = 72, cost = { Mana = 13, }, },
		[22] = { attackSpeedMultiplier = -20, baseMultiplier = 1.818, damageEffectiveness = 1.818, levelRequirement = 74, cost = { Mana = 13, }, },
		[23] = { attackSpeedMultiplier = -20, baseMultiplier = 1.853, damageEffectiveness = 1.853, levelRequirement = 76, cost = { Mana = 13, }, },
		[24] = { attackSpeedMultiplier = -20, baseMultiplier = 1.887, damageEffectiveness = 1.887, levelRequirement = 78, cost = { Mana = 13, }, },
		[25] = { attackSpeedMultiplier = -20, baseMultiplier = 1.921, damageEffectiveness = 1.921, levelRequirement = 80, cost = { Mana = 13, }, },
		[26] = { attackSpeedMultiplier = -20, baseMultiplier = 1.955, damageEffectiveness = 1.955, levelRequirement = 82, cost = { Mana = 14, }, },
		[27] = { attackSpeedMultiplier = -20, baseMultiplier = 1.989, damageEffectiveness = 1.989, levelRequirement = 84, cost = { Mana = 14, }, },
		[28] = { attackSpeedMultiplier = -20, baseMultiplier = 2.024, damageEffectiveness = 2.024, levelRequirement = 86, cost = { Mana = 14, }, },
		[29] = { attackSpeedMultiplier = -20, baseMultiplier = 2.058, damageEffectiveness = 2.058, levelRequirement = 88, cost = { Mana = 14, }, },
		[30] = { attackSpeedMultiplier = -20, baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 90, cost = { Mana = 14, }, },
		[31] = { attackSpeedMultiplier = -20, baseMultiplier = 2.109, damageEffectiveness = 2.109, levelRequirement = 91, cost = { Mana = 14, }, },
		[32] = { attackSpeedMultiplier = -20, baseMultiplier = 2.126, damageEffectiveness = 2.126, levelRequirement = 92, cost = { Mana = 14, }, },
		[33] = { attackSpeedMultiplier = -20, baseMultiplier = 2.143, damageEffectiveness = 2.143, levelRequirement = 93, cost = { Mana = 14, }, },
		[34] = { attackSpeedMultiplier = -20, baseMultiplier = 2.161, damageEffectiveness = 2.161, levelRequirement = 94, cost = { Mana = 15, }, },
		[35] = { attackSpeedMultiplier = -20, baseMultiplier = 2.178, damageEffectiveness = 2.178, levelRequirement = 95, cost = { Mana = 15, }, },
		[36] = { attackSpeedMultiplier = -20, baseMultiplier = 2.195, damageEffectiveness = 2.195, levelRequirement = 96, cost = { Mana = 15, }, },
		[37] = { attackSpeedMultiplier = -20, baseMultiplier = 2.212, damageEffectiveness = 2.212, levelRequirement = 97, cost = { Mana = 15, }, },
		[38] = { attackSpeedMultiplier = -20, baseMultiplier = 2.229, damageEffectiveness = 2.229, levelRequirement = 98, cost = { Mana = 15, }, },
		[39] = { attackSpeedMultiplier = -20, baseMultiplier = 2.246, damageEffectiveness = 2.246, levelRequirement = 99, cost = { Mana = 15, }, },
		[40] = { attackSpeedMultiplier = -20, baseMultiplier = 2.263, damageEffectiveness = 2.263, levelRequirement = 100, cost = { Mana = 15, }, },
	},
}
skills["LancingSteelAltX"] = {
	name = "Lancing Steel of Spraying",
	baseTypeName = "Lancing Steel of Spraying",
	color = 2,
	description = "Thrust an Axe or Sword forward to form a cluster of shards in front of you. The cluster will fire a number of projectiles in sequence, aiming at enemies in front of or close to it.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, [SkillType.ProjectileSpeed] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			local percentReducedProjectiles = (output.ProjectileCount - 1) / output.ProjectileCount
			local mult = (activeSkill.skillModList:More(activeSkill.skillCfg, "LancingSteelSubsequentDamage") - 1) * 100 * percentReducedProjectiles
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
			activeSkill.skillModList:NewMod("Damage", "MORE", mult, "Skill:LancingSteelAltX")
		end
	end,
	parts = {
		{
			name = "Single Projectile Hit",
		},
		{
			name = "All Projectiles Hit",
		},
	},
	statMap = {
		["lancing_steel_damage_+%_final_after_first_hit_on_target"] = {
			mod("LancingSteelSubsequentDamage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 } ),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.1 },
		},
	},
	constantStats = {
		{ "lancing_steel_damage_+%_final_after_first_hit_on_target", -90 },
	},
	stats = {
		"base_number_of_projectiles",
		"base_is_projectile",
		"quality_display_base_number_of_projectiles_is_gem",
		"always_pierce",
	},
	levels = {
		[1] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 2.6, damageEffectiveness = 2.6, levelRequirement = 28, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[2] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 2.653, damageEffectiveness = 2.653, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[3] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 2.705, damageEffectiveness = 2.705, levelRequirement = 34, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[4] = { 6, attackSpeedMultiplier = -20, baseMultiplier = 2.758, damageEffectiveness = 2.758, levelRequirement = 37, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[5] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 2.811, damageEffectiveness = 2.811, levelRequirement = 40, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[6] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 2.863, damageEffectiveness = 2.863, levelRequirement = 42, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[7] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 2.916, damageEffectiveness = 2.916, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[8] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 2.968, damageEffectiveness = 2.968, levelRequirement = 46, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[9] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.021, damageEffectiveness = 3.021, levelRequirement = 48, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[10] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.074, damageEffectiveness = 3.074, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[11] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.126, damageEffectiveness = 3.126, levelRequirement = 52, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[12] = { 7, attackSpeedMultiplier = -20, baseMultiplier = 3.179, damageEffectiveness = 3.179, levelRequirement = 54, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[13] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.232, damageEffectiveness = 3.232, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[14] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.284, damageEffectiveness = 3.284, levelRequirement = 58, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[15] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.337, damageEffectiveness = 3.337, levelRequirement = 60, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[16] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.389, damageEffectiveness = 3.389, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[17] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.442, damageEffectiveness = 3.442, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[18] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.495, damageEffectiveness = 3.495, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[19] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.547, damageEffectiveness = 3.547, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[20] = { 8, attackSpeedMultiplier = -20, baseMultiplier = 3.6, damageEffectiveness = 3.6, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[21] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.653, damageEffectiveness = 3.653, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[22] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.705, damageEffectiveness = 3.705, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[23] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.758, damageEffectiveness = 3.758, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[24] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.811, damageEffectiveness = 3.811, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[25] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.863, damageEffectiveness = 3.863, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 13, }, },
		[26] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.916, damageEffectiveness = 3.916, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[27] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 3.968, damageEffectiveness = 3.968, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[28] = { 9, attackSpeedMultiplier = -20, baseMultiplier = 4.021, damageEffectiveness = 4.021, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[29] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.074, damageEffectiveness = 4.074, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[30] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.126, damageEffectiveness = 4.126, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[31] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.153, damageEffectiveness = 4.153, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[32] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.179, damageEffectiveness = 4.179, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[33] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.205, damageEffectiveness = 4.205, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 14, }, },
		[34] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.232, damageEffectiveness = 4.232, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[35] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.258, damageEffectiveness = 4.258, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[36] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.284, damageEffectiveness = 4.284, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[37] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.311, damageEffectiveness = 4.311, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[38] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.337, damageEffectiveness = 4.337, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[39] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.363, damageEffectiveness = 4.363, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 15, }, },
		[40] = { 10, attackSpeedMultiplier = -20, baseMultiplier = 4.389, damageEffectiveness = 4.389, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 15, }, },
	},
}
skills["LightningArrow"] = {
	name = "Lightning Arrow",
	baseTypeName = "Lightning Arrow",
	color = 2,
	description = "Fires a charged arrow which damages enemies by causing them to be struck by a bolt of lightning, which also damages a number of surrounding enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		skill("radius", 18),
	},
	qualityStats = {
		Default = {
			{ "lightning_arrow_maximum_number_of_extra_targets", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "lightning_arrow_maximum_number_of_extra_targets", 3 },
	},
	stats = {
		"active_skill_shock_as_though_damage_+%_final",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 100, baseMultiplier = 1.495, damageEffectiveness = 1.495, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 110, baseMultiplier = 1.51, damageEffectiveness = 1.51, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 120, baseMultiplier = 1.524, damageEffectiveness = 1.524, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 130, baseMultiplier = 1.539, damageEffectiveness = 1.539, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 140, baseMultiplier = 1.554, damageEffectiveness = 1.554, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 150, baseMultiplier = 1.567, damageEffectiveness = 1.567, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 160, baseMultiplier = 1.582, damageEffectiveness = 1.582, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 170, baseMultiplier = 1.596, damageEffectiveness = 1.596, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 180, baseMultiplier = 1.611, damageEffectiveness = 1.611, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 190, baseMultiplier = 1.626, damageEffectiveness = 1.626, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 200, baseMultiplier = 1.64, damageEffectiveness = 1.64, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 210, baseMultiplier = 1.655, damageEffectiveness = 1.655, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 220, baseMultiplier = 1.67, damageEffectiveness = 1.67, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 230, baseMultiplier = 1.684, damageEffectiveness = 1.684, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 240, baseMultiplier = 1.699, damageEffectiveness = 1.699, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 250, baseMultiplier = 1.712, damageEffectiveness = 1.712, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 260, baseMultiplier = 1.727, damageEffectiveness = 1.727, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 270, baseMultiplier = 1.742, damageEffectiveness = 1.742, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 280, baseMultiplier = 1.756, damageEffectiveness = 1.756, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 290, baseMultiplier = 1.771, damageEffectiveness = 1.771, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 300, baseMultiplier = 1.786, damageEffectiveness = 1.786, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 310, baseMultiplier = 1.8, damageEffectiveness = 1.8, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 320, baseMultiplier = 1.815, damageEffectiveness = 1.815, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 330, baseMultiplier = 1.83, damageEffectiveness = 1.83, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 340, baseMultiplier = 1.843, damageEffectiveness = 1.843, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 350, baseMultiplier = 1.858, damageEffectiveness = 1.858, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 360, baseMultiplier = 1.872, damageEffectiveness = 1.872, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 370, baseMultiplier = 1.887, damageEffectiveness = 1.887, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 380, baseMultiplier = 1.902, damageEffectiveness = 1.902, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 390, baseMultiplier = 1.916, damageEffectiveness = 1.916, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 400, baseMultiplier = 1.924, damageEffectiveness = 1.924, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 410, baseMultiplier = 1.931, damageEffectiveness = 1.931, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 420, baseMultiplier = 1.938, damageEffectiveness = 1.938, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 430, baseMultiplier = 1.946, damageEffectiveness = 1.946, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 440, baseMultiplier = 1.953, damageEffectiveness = 1.953, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 450, baseMultiplier = 1.96, damageEffectiveness = 1.96, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 460, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 470, baseMultiplier = 1.975, damageEffectiveness = 1.975, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 480, baseMultiplier = 1.981, damageEffectiveness = 1.981, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 490, baseMultiplier = 1.988, damageEffectiveness = 1.988, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["LightningArrowAltX"] = {
	name = "Lightning Arrow of Electrocution",
	baseTypeName = "Lightning Arrow of Electrocution",
	color = 2,
	description = "Fires a charged arrow which damages enemies by causing them to be struck by a bolt of lightning. It sticks into the final target, causing them to be struck and damaged multiple times.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["lightning_arrow_stack_limit"] = {
			mod("Multiplier:LightningArrowofElectrocutionMaxStages", "BASE", nil)
		},
		["lightning_arrow_alt_strike_frequency_ms"] = {
			skill("hitFrequency", nil),
			div = 1000,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		skill("dpsMultiplier", 1, { type = "Multiplier", var = "LightningArrowofElectrocutionStage" }),
	},
	qualityStats = {
		Default = {
			{ "lightning_arrow_alt_additional_strikes", 0.05 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "lightning_arrow_stack_limit", 10 },
		{ "lightning_arrow_alt_additional_strikes", 4 },
		{ "lightning_arrow_alt_strike_frequency_ms", 500 },
	},
	stats = {
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { baseMultiplier = 0.747, damageEffectiveness = 0.747, levelRequirement = 12, cost = { Mana = 6, }, },
		[2] = { baseMultiplier = 0.753, damageEffectiveness = 0.753, levelRequirement = 15, cost = { Mana = 6, }, },
		[3] = { baseMultiplier = 0.76, damageEffectiveness = 0.76, levelRequirement = 19, cost = { Mana = 7, }, },
		[4] = { baseMultiplier = 0.766, damageEffectiveness = 0.766, levelRequirement = 23, cost = { Mana = 7, }, },
		[5] = { baseMultiplier = 0.772, damageEffectiveness = 0.772, levelRequirement = 27, cost = { Mana = 7, }, },
		[6] = { baseMultiplier = 0.777, damageEffectiveness = 0.777, levelRequirement = 31, cost = { Mana = 8, }, },
		[7] = { baseMultiplier = 0.784, damageEffectiveness = 0.784, levelRequirement = 35, cost = { Mana = 8, }, },
		[8] = { baseMultiplier = 0.79, damageEffectiveness = 0.79, levelRequirement = 38, cost = { Mana = 8, }, },
		[9] = { baseMultiplier = 0.796, damageEffectiveness = 0.796, levelRequirement = 41, cost = { Mana = 8, }, },
		[10] = { baseMultiplier = 0.802, damageEffectiveness = 0.802, levelRequirement = 44, cost = { Mana = 8, }, },
		[11] = { baseMultiplier = 0.808, damageEffectiveness = 0.808, levelRequirement = 47, cost = { Mana = 9, }, },
		[12] = { baseMultiplier = 0.814, damageEffectiveness = 0.814, levelRequirement = 50, cost = { Mana = 9, }, },
		[13] = { baseMultiplier = 0.82, damageEffectiveness = 0.82, levelRequirement = 53, cost = { Mana = 9, }, },
		[14] = { baseMultiplier = 0.826, damageEffectiveness = 0.826, levelRequirement = 56, cost = { Mana = 9, }, },
		[15] = { baseMultiplier = 0.833, damageEffectiveness = 0.833, levelRequirement = 59, cost = { Mana = 9, }, },
		[16] = { baseMultiplier = 0.838, damageEffectiveness = 0.838, levelRequirement = 62, cost = { Mana = 10, }, },
		[17] = { baseMultiplier = 0.844, damageEffectiveness = 0.844, levelRequirement = 64, cost = { Mana = 10, }, },
		[18] = { baseMultiplier = 0.85, damageEffectiveness = 0.85, levelRequirement = 66, cost = { Mana = 10, }, },
		[19] = { baseMultiplier = 0.857, damageEffectiveness = 0.857, levelRequirement = 68, cost = { Mana = 10, }, },
		[20] = { baseMultiplier = 0.862, damageEffectiveness = 0.862, levelRequirement = 70, cost = { Mana = 10, }, },
		[21] = { baseMultiplier = 0.868, damageEffectiveness = 0.868, levelRequirement = 72, cost = { Mana = 10, }, },
		[22] = { baseMultiplier = 0.875, damageEffectiveness = 0.875, levelRequirement = 74, cost = { Mana = 10, }, },
		[23] = { baseMultiplier = 0.881, damageEffectiveness = 0.881, levelRequirement = 76, cost = { Mana = 10, }, },
		[24] = { baseMultiplier = 0.887, damageEffectiveness = 0.887, levelRequirement = 78, cost = { Mana = 11, }, },
		[25] = { baseMultiplier = 0.892, damageEffectiveness = 0.892, levelRequirement = 80, cost = { Mana = 11, }, },
		[26] = { baseMultiplier = 0.899, damageEffectiveness = 0.899, levelRequirement = 82, cost = { Mana = 11, }, },
		[27] = { baseMultiplier = 0.905, damageEffectiveness = 0.905, levelRequirement = 84, cost = { Mana = 11, }, },
		[28] = { baseMultiplier = 0.911, damageEffectiveness = 0.911, levelRequirement = 86, cost = { Mana = 11, }, },
		[29] = { baseMultiplier = 0.917, damageEffectiveness = 0.917, levelRequirement = 88, cost = { Mana = 11, }, },
		[30] = { baseMultiplier = 0.923, damageEffectiveness = 0.923, levelRequirement = 90, cost = { Mana = 11, }, },
		[31] = { baseMultiplier = 0.926, damageEffectiveness = 0.926, levelRequirement = 91, cost = { Mana = 11, }, },
		[32] = { baseMultiplier = 0.929, damageEffectiveness = 0.929, levelRequirement = 92, cost = { Mana = 11, }, },
		[33] = { baseMultiplier = 0.933, damageEffectiveness = 0.933, levelRequirement = 93, cost = { Mana = 12, }, },
		[34] = { baseMultiplier = 0.935, damageEffectiveness = 0.935, levelRequirement = 94, cost = { Mana = 12, }, },
		[35] = { baseMultiplier = 0.938, damageEffectiveness = 0.938, levelRequirement = 95, cost = { Mana = 12, }, },
		[36] = { baseMultiplier = 0.941, damageEffectiveness = 0.941, levelRequirement = 96, cost = { Mana = 12, }, },
		[37] = { baseMultiplier = 0.944, damageEffectiveness = 0.944, levelRequirement = 97, cost = { Mana = 12, }, },
		[38] = { baseMultiplier = 0.948, damageEffectiveness = 0.948, levelRequirement = 98, cost = { Mana = 12, }, },
		[39] = { baseMultiplier = 0.95, damageEffectiveness = 0.95, levelRequirement = 99, cost = { Mana = 12, }, },
		[40] = { baseMultiplier = 0.953, damageEffectiveness = 0.953, levelRequirement = 100, cost = { Mana = 12, }, },
	},
}
skills["VaalLightningArrow"] = {
	name = "Vaal Lightning Arrow",
	baseTypeName = "Vaal Lightning Arrow",
	color = 2,
	description = "Fires charged arrows, which repeatedly travel for a short time before changing direction. When they hit enemies, they are struck by a bolt of lightning which damages a number of surrounding enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Vaal] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	statMap = {
		["projectiles_barrage"] = {
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
		["quality_display_base_additional_arrows_is_gem"] = {
			-- Display only
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		skill("radius", 18),
	},
	qualityStats = {
		Default = {
			{ "lightning_arrow_maximum_number_of_extra_targets", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "lightning_arrow_maximum_number_of_extra_targets", 3 },
		{ "base_number_of_arrows", 5 },
		{ "projectile_random_angle_based_on_distance_to_target_location_%", 35 },
		{ "vaal_lightning_arrow_number_of_redirects", 9 },
	},
	stats = {
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_fire_arrows",
		"always_pierce",
		"vaal_lightning_arrow_fork_and_chain_modifiers_apply_to_number_of_redirects",
		"projectiles_cannot_split",
		"projectiles_barrage",
		"cannot_cancel_skill_before_contact_point",
		"skill_can_add_multiple_charges_per_action",
		"quality_display_base_additional_arrows_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { baseMultiplier = 0.713, damageEffectiveness = 0.713, levelRequirement = 12, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[2] = { baseMultiplier = 0.726, damageEffectiveness = 0.726, levelRequirement = 15, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[3] = { baseMultiplier = 0.737, damageEffectiveness = 0.737, levelRequirement = 19, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[4] = { baseMultiplier = 0.749, damageEffectiveness = 0.749, levelRequirement = 23, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[5] = { baseMultiplier = 0.76, damageEffectiveness = 0.76, levelRequirement = 27, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[6] = { baseMultiplier = 0.772, damageEffectiveness = 0.772, levelRequirement = 31, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[7] = { baseMultiplier = 0.782, damageEffectiveness = 0.782, levelRequirement = 35, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[8] = { baseMultiplier = 0.792, damageEffectiveness = 0.792, levelRequirement = 38, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[9] = { baseMultiplier = 0.803, damageEffectiveness = 0.803, levelRequirement = 41, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[10] = { baseMultiplier = 0.813, damageEffectiveness = 0.813, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[11] = { baseMultiplier = 0.822, damageEffectiveness = 0.822, levelRequirement = 47, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[12] = { baseMultiplier = 0.831, damageEffectiveness = 0.831, levelRequirement = 50, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[13] = { baseMultiplier = 0.841, damageEffectiveness = 0.841, levelRequirement = 53, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[14] = { baseMultiplier = 0.85, damageEffectiveness = 0.85, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[15] = { baseMultiplier = 0.858, damageEffectiveness = 0.858, levelRequirement = 59, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[16] = { baseMultiplier = 0.866, damageEffectiveness = 0.866, levelRequirement = 62, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[17] = { baseMultiplier = 0.874, damageEffectiveness = 0.874, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[18] = { baseMultiplier = 0.882, damageEffectiveness = 0.882, levelRequirement = 66, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[19] = { baseMultiplier = 0.89, damageEffectiveness = 0.89, levelRequirement = 68, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[20] = { baseMultiplier = 0.897, damageEffectiveness = 0.897, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[21] = { baseMultiplier = 0.904, damageEffectiveness = 0.904, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[22] = { baseMultiplier = 0.911, damageEffectiveness = 0.911, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[23] = { baseMultiplier = 0.918, damageEffectiveness = 0.918, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[24] = { baseMultiplier = 0.925, damageEffectiveness = 0.925, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[25] = { baseMultiplier = 0.931, damageEffectiveness = 0.931, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[26] = { baseMultiplier = 0.937, damageEffectiveness = 0.937, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[27] = { baseMultiplier = 0.943, damageEffectiveness = 0.943, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[28] = { baseMultiplier = 0.949, damageEffectiveness = 0.949, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[29] = { baseMultiplier = 0.954, damageEffectiveness = 0.954, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[30] = { baseMultiplier = 0.96, damageEffectiveness = 0.96, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[31] = { baseMultiplier = 0.963, damageEffectiveness = 0.963, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[32] = { baseMultiplier = 0.965, damageEffectiveness = 0.965, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[33] = { baseMultiplier = 0.967, damageEffectiveness = 0.967, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[34] = { baseMultiplier = 0.969, damageEffectiveness = 0.969, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[35] = { baseMultiplier = 0.972, damageEffectiveness = 0.972, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[36] = { baseMultiplier = 0.974, damageEffectiveness = 0.974, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[37] = { baseMultiplier = 0.976, damageEffectiveness = 0.976, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[38] = { baseMultiplier = 0.979, damageEffectiveness = 0.979, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[39] = { baseMultiplier = 0.981, damageEffectiveness = 0.981, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
		[40] = { baseMultiplier = 0.983, damageEffectiveness = 0.983, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 2, cost = { Soul = 20, }, },
	},
}
skills["LightningStrike"] = {
	name = "Lightning Strike",
	baseTypeName = "Lightning Strike",
	color = 2,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy is released from the weapon as projectiles as you strike, flying out to hit farther-away enemies. The projectiles cannot miss if the melee attack hit a target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Lightning] = true, [SkillType.ProjectilesNotFromUser] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Projectiles",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.05 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "total_projectile_spread_angle_override", 70 },
		{ "active_skill_projectile_speed_+%_variation_final", 30 },
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -50 },
	},
	stats = {
		"base_number_of_projectiles",
		"show_number_of_projectiles",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { 3, baseMultiplier = 1.985, damageEffectiveness = 1.985, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 3, baseMultiplier = 2.074, damageEffectiveness = 2.074, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 3, baseMultiplier = 2.171, damageEffectiveness = 2.171, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 3, baseMultiplier = 2.273, damageEffectiveness = 2.273, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 3, baseMultiplier = 2.378, damageEffectiveness = 2.378, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 3, baseMultiplier = 2.489, damageEffectiveness = 2.489, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 3, baseMultiplier = 2.605, damageEffectiveness = 2.605, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 3, baseMultiplier = 2.721, damageEffectiveness = 2.721, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 3, baseMultiplier = 2.843, damageEffectiveness = 2.843, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 3, baseMultiplier = 2.97, damageEffectiveness = 2.97, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 3, baseMultiplier = 3.102, damageEffectiveness = 3.102, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 3, baseMultiplier = 3.241, damageEffectiveness = 3.241, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 3, baseMultiplier = 3.385, damageEffectiveness = 3.385, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 3, baseMultiplier = 3.537, damageEffectiveness = 3.537, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 3, baseMultiplier = 3.694, damageEffectiveness = 3.694, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 3, baseMultiplier = 3.858, damageEffectiveness = 3.858, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 3, baseMultiplier = 4.023, damageEffectiveness = 4.023, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 3, baseMultiplier = 4.194, damageEffectiveness = 4.194, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 3, baseMultiplier = 4.373, damageEffectiveness = 4.373, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 3, baseMultiplier = 4.56, damageEffectiveness = 4.56, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 3, baseMultiplier = 4.755, damageEffectiveness = 4.755, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 3, baseMultiplier = 4.958, damageEffectiveness = 4.958, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 3, baseMultiplier = 5.169, damageEffectiveness = 5.169, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 3, baseMultiplier = 5.39, damageEffectiveness = 5.39, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 3, baseMultiplier = 5.62, damageEffectiveness = 5.62, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 3, baseMultiplier = 5.86, damageEffectiveness = 5.86, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 3, baseMultiplier = 6.109, damageEffectiveness = 6.109, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 3, baseMultiplier = 6.37, damageEffectiveness = 6.37, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 3, baseMultiplier = 6.641, damageEffectiveness = 6.641, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 3, baseMultiplier = 6.923, damageEffectiveness = 6.923, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 3, baseMultiplier = 7.348, damageEffectiveness = 7.348, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 3, baseMultiplier = 7.504, damageEffectiveness = 7.504, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 3, baseMultiplier = 7.664, damageEffectiveness = 7.664, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 3, baseMultiplier = 7.826, damageEffectiveness = 7.826, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 3, baseMultiplier = 7.993, damageEffectiveness = 7.993, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 3, baseMultiplier = 8.162, damageEffectiveness = 8.162, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 3, baseMultiplier = 8.336, damageEffectiveness = 8.336, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 3, baseMultiplier = 8.513, damageEffectiveness = 8.513, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 3, baseMultiplier = 8.693, damageEffectiveness = 8.693, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 3, baseMultiplier = 8.878, damageEffectiveness = 8.878, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["LightningStrikeAltX"] = {
	name = "Lightning Strike of Arcing",
	baseTypeName = "Lightning Strike of Arcing",
	color = 2,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy is released from the weapon as a projectile as you strike, flying out to hit farther-away enemies and chain between them. The projectile cannot miss if the melee attack hit a target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Lightning] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Chains] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Projectiles",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["skill_damage_+%_final_per_chain_from_skill_specific_stat"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "PerStat", stat = "Chain" }),
		},
		["active_skill_hit_ailment_damage_with_projectile_+%_final"] = {
			mod("Damage", "MORE", nil, bit.band(ModFlag.Hit, ModFlag.Ailment), 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	qualityStats = {
		Default = {
			{ "number_of_chains", 0.1 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "active_skill_hit_ailment_damage_with_projectile_+%_final", -50 },
		{ "skill_damage_+%_final_per_chain_from_skill_specific_stat", 10 },
	},
	stats = {
		"number_of_chains",
		"show_number_of_projectiles",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
	},
	levels = {
		[1] = { 4, baseMultiplier = 1.643, damageEffectiveness = 1.643, levelRequirement = 12, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[2] = { 4, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 15, statInterpolation = { 1, }, cost = { Mana = 6, }, },
		[3] = { 4, baseMultiplier = 1.797, damageEffectiveness = 1.797, levelRequirement = 19, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[4] = { 4, baseMultiplier = 1.881, damageEffectiveness = 1.881, levelRequirement = 23, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[5] = { 4, baseMultiplier = 1.968, damageEffectiveness = 1.968, levelRequirement = 27, statInterpolation = { 1, }, cost = { Mana = 7, }, },
		[6] = { 5, baseMultiplier = 2.06, damageEffectiveness = 2.06, levelRequirement = 31, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[7] = { 5, baseMultiplier = 2.156, damageEffectiveness = 2.156, levelRequirement = 35, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[8] = { 5, baseMultiplier = 2.252, damageEffectiveness = 2.252, levelRequirement = 38, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[9] = { 5, baseMultiplier = 2.353, damageEffectiveness = 2.353, levelRequirement = 41, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[10] = { 5, baseMultiplier = 2.458, damageEffectiveness = 2.458, levelRequirement = 44, statInterpolation = { 1, }, cost = { Mana = 8, }, },
		[11] = { 6, baseMultiplier = 2.567, damageEffectiveness = 2.567, levelRequirement = 47, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[12] = { 6, baseMultiplier = 2.682, damageEffectiveness = 2.682, levelRequirement = 50, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[13] = { 6, baseMultiplier = 2.802, damageEffectiveness = 2.802, levelRequirement = 53, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[14] = { 6, baseMultiplier = 2.926, damageEffectiveness = 2.926, levelRequirement = 56, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[15] = { 6, baseMultiplier = 3.057, damageEffectiveness = 3.057, levelRequirement = 59, statInterpolation = { 1, }, cost = { Mana = 9, }, },
		[16] = { 7, baseMultiplier = 3.193, damageEffectiveness = 3.193, levelRequirement = 62, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[17] = { 7, baseMultiplier = 3.33, damageEffectiveness = 3.33, levelRequirement = 64, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[18] = { 7, baseMultiplier = 3.472, damageEffectiveness = 3.472, levelRequirement = 66, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[19] = { 7, baseMultiplier = 3.619, damageEffectiveness = 3.619, levelRequirement = 68, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[20] = { 7, baseMultiplier = 3.774, damageEffectiveness = 3.774, levelRequirement = 70, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[21] = { 8, baseMultiplier = 3.935, damageEffectiveness = 3.935, levelRequirement = 72, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[22] = { 8, baseMultiplier = 4.103, damageEffectiveness = 4.103, levelRequirement = 74, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[23] = { 8, baseMultiplier = 4.278, damageEffectiveness = 4.278, levelRequirement = 76, statInterpolation = { 1, }, cost = { Mana = 10, }, },
		[24] = { 8, baseMultiplier = 4.46, damageEffectiveness = 4.46, levelRequirement = 78, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[25] = { 8, baseMultiplier = 4.651, damageEffectiveness = 4.651, levelRequirement = 80, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[26] = { 9, baseMultiplier = 4.849, damageEffectiveness = 4.849, levelRequirement = 82, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[27] = { 9, baseMultiplier = 5.056, damageEffectiveness = 5.056, levelRequirement = 84, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[28] = { 9, baseMultiplier = 5.271, damageEffectiveness = 5.271, levelRequirement = 86, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[29] = { 9, baseMultiplier = 5.496, damageEffectiveness = 5.496, levelRequirement = 88, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[30] = { 9, baseMultiplier = 5.729, damageEffectiveness = 5.729, levelRequirement = 90, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[31] = { 10, baseMultiplier = 6.081, damageEffectiveness = 6.081, levelRequirement = 91, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[32] = { 10, baseMultiplier = 6.21, damageEffectiveness = 6.21, levelRequirement = 92, statInterpolation = { 1, }, cost = { Mana = 11, }, },
		[33] = { 10, baseMultiplier = 6.342, damageEffectiveness = 6.342, levelRequirement = 93, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[34] = { 10, baseMultiplier = 6.477, damageEffectiveness = 6.477, levelRequirement = 94, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[35] = { 10, baseMultiplier = 6.615, damageEffectiveness = 6.615, levelRequirement = 95, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[36] = { 11, baseMultiplier = 6.755, damageEffectiveness = 6.755, levelRequirement = 96, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[37] = { 11, baseMultiplier = 6.898, damageEffectiveness = 6.898, levelRequirement = 97, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[38] = { 11, baseMultiplier = 7.045, damageEffectiveness = 7.045, levelRequirement = 98, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[39] = { 11, baseMultiplier = 7.194, damageEffectiveness = 7.194, levelRequirement = 99, statInterpolation = { 1, }, cost = { Mana = 12, }, },
		[40] = { 11, baseMultiplier = 7.347, damageEffectiveness = 7.347, levelRequirement = 100, statInterpolation = { 1, }, cost = { Mana = 12, }, },
	},
}
skills["VaalLightningStrike"] = {
	name = "Vaal Lightning Strike",
	baseTypeName = "Vaal Lightning Strike",
	color = 2,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy becomes an orb attached to the enemy you hit, or the ground if you don't hit an enemy. The orb will periodically fire projectiles at other nearby enemies for a duration, which will also damage the enemy the orb is attached to.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Melee] = true, [SkillType.Duration] = true, [SkillType.Vaal] = true, [SkillType.Lightning] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.NeverExertable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Projectiles",
			melee = false,
			projectile = true,
		},
	},
	statMap = {
		["vaal_lightning_strike_beam_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		vaal = true,
	},
	qualityStats = {
		Default = {
			{ "base_number_of_projectiles", 0.05 },
		},
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_skill_effect_duration", 6000 },
		{ "total_projectile_spread_angle_override", 180 },
	},
	stats = {
		"base_number_of_projectiles",
		"global_always_hit",
		"show_number_of_projectiles",
		"modifiers_to_skill_effect_duration_also_affect_soul_prevention_duration",
		"cannot_cancel_skill_before_contact_point",
		"console_skill_dont_chase",
		"quality_display_base_number_of_projectiles_is_gem",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { 5, baseMultiplier = 0.75, damageEffectiveness = 0.75, levelRequirement = 12, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[2] = { 5, baseMultiplier = 0.804, damageEffectiveness = 0.804, levelRequirement = 15, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[3] = { 5, baseMultiplier = 0.857, damageEffectiveness = 0.857, levelRequirement = 19, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[4] = { 5, baseMultiplier = 0.911, damageEffectiveness = 0.911, levelRequirement = 23, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[5] = { 5, baseMultiplier = 0.965, damageEffectiveness = 0.965, levelRequirement = 27, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[6] = { 7, baseMultiplier = 1.018, damageEffectiveness = 1.018, levelRequirement = 31, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[7] = { 7, baseMultiplier = 1.072, damageEffectiveness = 1.072, levelRequirement = 35, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[8] = { 7, baseMultiplier = 1.126, damageEffectiveness = 1.126, levelRequirement = 38, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[9] = { 7, baseMultiplier = 1.179, damageEffectiveness = 1.179, levelRequirement = 41, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[10] = { 7, baseMultiplier = 1.233, damageEffectiveness = 1.233, levelRequirement = 44, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[11] = { 7, baseMultiplier = 1.287, damageEffectiveness = 1.287, levelRequirement = 47, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[12] = { 7, baseMultiplier = 1.341, damageEffectiveness = 1.341, levelRequirement = 50, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[13] = { 7, baseMultiplier = 1.394, damageEffectiveness = 1.394, levelRequirement = 53, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[14] = { 7, baseMultiplier = 1.448, damageEffectiveness = 1.448, levelRequirement = 56, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[15] = { 7, baseMultiplier = 1.502, damageEffectiveness = 1.502, levelRequirement = 59, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[16] = { 9, baseMultiplier = 1.555, damageEffectiveness = 1.555, levelRequirement = 62, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[17] = { 9, baseMultiplier = 1.609, damageEffectiveness = 1.609, levelRequirement = 64, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[18] = { 9, baseMultiplier = 1.663, damageEffectiveness = 1.663, levelRequirement = 66, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[19] = { 9, baseMultiplier = 1.716, damageEffectiveness = 1.716, levelRequirement = 68, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[20] = { 9, baseMultiplier = 1.77, damageEffectiveness = 1.77, levelRequirement = 70, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[21] = { 9, baseMultiplier = 1.824, damageEffectiveness = 1.824, levelRequirement = 72, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[22] = { 9, baseMultiplier = 1.877, damageEffectiveness = 1.877, levelRequirement = 74, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[23] = { 9, baseMultiplier = 1.931, damageEffectiveness = 1.931, levelRequirement = 76, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[24] = { 9, baseMultiplier = 1.985, damageEffectiveness = 1.985, levelRequirement = 78, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[25] = { 9, baseMultiplier = 2.038, damageEffectiveness = 2.038, levelRequirement = 80, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[26] = { 11, baseMultiplier = 2.092, damageEffectiveness = 2.092, levelRequirement = 82, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[27] = { 11, baseMultiplier = 2.146, damageEffectiveness = 2.146, levelRequirement = 84, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[28] = { 11, baseMultiplier = 2.199, damageEffectiveness = 2.199, levelRequirement = 86, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[29] = { 11, baseMultiplier = 2.253, damageEffectiveness = 2.253, levelRequirement = 88, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[30] = { 11, baseMultiplier = 2.307, damageEffectiveness = 2.307, levelRequirement = 90, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[31] = { 11, baseMultiplier = 2.334, damageEffectiveness = 2.334, levelRequirement = 91, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[32] = { 11, baseMultiplier = 2.361, damageEffectiveness = 2.361, levelRequirement = 92, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[33] = { 11, baseMultiplier = 2.387, damageEffectiveness = 2.387, levelRequirement = 93, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[34] = { 11, baseMultiplier = 2.414, damageEffectiveness = 2.414, levelRequirement = 94, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[35] = { 11, baseMultiplier = 2.441, damageEffectiveness = 2.441, levelRequirement = 95, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[36] = { 11, baseMultiplier = 2.468, damageEffectiveness = 2.468, levelRequirement = 96, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[37] = { 11, baseMultiplier = 2.495, damageEffectiveness = 2.495, levelRequirement = 97, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[38] = { 11, baseMultiplier = 2.522, damageEffectiveness = 2.522, levelRequirement = 98, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[39] = { 11, baseMultiplier = 2.548, damageEffectiveness = 2.548, levelRequirement = 99, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
		[40] = { 11, baseMultiplier = 2.575, damageEffectiveness = 2.575, levelRequirement = 100, soulPreventionDuration = 8, vaalStoredUses = 2, statInterpolation = { 1, }, cost = { Soul = 20, }, },
	},
}
skills["MirrorArrow"] = {
	name = "Mirror Arrow",
	baseTypeName = "Mirror Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, a clone is summoned. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [SkillType.ProjectileSpeed] = true, [SkillType.Attack] = true, [SkillType.Minion] = true, [SkillType.RangedAttack] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Movement] = true, [SkillType.Triggerable] = true, [SkillType.CreatesMinion] = true, [SkillType.Travel] = true, [SkillType.Cooldown] = true, [SkillType.Rain] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesFromUser] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "minion_attack_skill_stat_descriptions",
	castTime = 1,
	minionList = {
		"ArrowClone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		Default = {
			{ "base_cooldown_speed_+%", 2 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "number_of_monsters_to_summon", 1 },
		{ "display_minion_monster_type", 25 },
	},
	stats = {
		"base_display_minion_actor_level",
		"base_cooldown_speed_+%",
		"active_skill_minion_damage_+%_final",
		"base_is_projectile",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"base_cooldown_speed_+%",
		"active_skill_minion_damage_+%_final",
	},
	levels = {
		[1] = { 10, 0, 0, cooldown = 3, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[2] = { 13, 2, 3, cooldown = 3, levelRequirement = 13, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 14, }, },
		[3] = { 17, 5, 6, cooldown = 3, levelRequirement = 17, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[4] = { 21, 7, 9, cooldown = 3, levelRequirement = 21, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[5] = { 25, 10, 12, cooldown = 3, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 15, }, },
		[6] = { 29, 12, 15, cooldown = 3, levelRequirement = 29, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[7] = { 33, 15, 18, cooldown = 3, levelRequirement = 33, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[8] = { 36, 17, 21, cooldown = 3, levelRequirement = 36, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 16, }, },
		[9] = { 39, 20, 24, cooldown = 3, levelRequirement = 39, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[10] = { 42, 22, 27, cooldown = 3, levelRequirement = 42, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[11] = { 45, 25, 30, cooldown = 3, levelRequirement = 45, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[12] = { 48, 27, 33, cooldown = 3, levelRequirement = 48, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 17, }, },
		[13] = { 51, 30, 36, cooldown = 3, levelRequirement = 51, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[14] = { 54, 32, 39, cooldown = 3, levelRequirement = 54, storedUses = 1, statInterpolation = { 1, 1, 1, }, cost = { Mana = 18, }, },
		[15] = { 57, 35, 42, cooldown = 3,