/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;

public class WriteStats {
    private int numTables;
    private int numViews;
    private final Set<TableColumn> excludedColumns;

    public WriteStats(Collection<Table> tables) {
        this.excludedColumns = new HashSet();
        for (Table table : tables) {
            for (TableColumn column : table.getColumns()) {
                if (!column.isExcluded()) continue;
                this.excludedColumns.add(column);
            }
        }
    }

    public WriteStats(WriteStats stats) {
        this.excludedColumns = stats.excludedColumns;
    }

    public void wroteTable(Table table) {
        if (table.isView()) {
            ++this.numViews;
        } else {
            ++this.numTables;
        }
    }

    public int getNumTablesWritten() {
        return this.numTables;
    }

    public int getNumViewsWritten() {
        return this.numViews;
    }

    public Set<TableColumn> getExcludedColumns() {
        return this.excludedColumns;
    }
}

