/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.schemaspy.model.Table;
import org.schemaspy.model.View;
import org.schemaspy.util.CaseInsensitiveMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class SqlAnalyzer {
    private Set<String> keywords;
    private Map<String, Table> tablesByPossibleNames;
    private static final String TOKENS = " \t\n\r\f()<>|,";

    public SqlAnalyzer(Set<String> keywords, Collection<Table> tables, Collection<View> views) {
        this.keywords = keywords;
        this.tablesByPossibleNames = new CaseInsensitiveMap();
        this.tablesByPossibleNames.putAll(SqlAnalyzer.getTableMap(tables));
        this.tablesByPossibleNames.putAll(SqlAnalyzer.getTableMap(views));
    }

    public Set<Table> getReferencedTables(String sql) {
        LinkedHashSet<Table> referenced = new LinkedHashSet<Table>();
        StringTokenizer tokenizer = new StringTokenizer(sql, " \t\n\r\f()<>|,", true);
        while (tokenizer.hasMoreTokens()) {
            int lastDot;
            String token = tokenizer.nextToken();
            if (this.keywords.contains(token.toUpperCase())) continue;
            Table t = (Table)this.tablesByPossibleNames.get(token);
            if (t == null && (lastDot = token.lastIndexOf(46)) != -1) {
                t = (Table)this.tablesByPossibleNames.get(token.substring(0, lastDot));
            }
            if (t == null) continue;
            referenced.add(t);
        }
        return referenced;
    }

    private static Map<String, Table> getTableMap(Collection<? extends Table> tables) {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        for (Table table : tables) {
            String name = table.getName();
            String container = table.getContainer();
            map.put(name, table);
            map.put("`" + name + "`", table);
            map.put("'" + name + "'", table);
            map.put("\"" + name + "\"", table);
            map.put(container + "." + name, table);
            map.put("`" + container + "`.`" + name + "`", table);
            map.put("'" + container + "'.'" + name + "'", table);
            map.put("\"" + container + "\".\"" + name + "\"", table);
            map.put("`" + container + '.' + name + "`", table);
            map.put("'" + container + '.' + name + "'", table);
            map.put("\"" + container + '.' + name + "\"", table);
        }
        return map;
    }
}

