/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.schemaspy.view.HtmlConfig;
import org.schemaspy.view.MustacheCustomResolver;
import org.schemaspy.view.PageData;

public class MustacheCompiler {
    private final String databaseName;
    private final HtmlConfig htmlConfig;
    private final MustacheFactory mustacheFactory;

    public MustacheCompiler(String databaseName, HtmlConfig htmlConfig) {
        this.databaseName = databaseName;
        this.htmlConfig = htmlConfig;
        this.mustacheFactory = new DefaultMustacheFactory((MustacheResolver)new MustacheCustomResolver(htmlConfig.getTemplateDirectory()));
    }

    public void write(PageData pageData, Writer writer) throws IOException {
        StringWriter result = new StringWriter();
        HashMap<String, Object> pageScope = new HashMap<String, Object>();
        pageScope.put("databaseName", this.databaseName);
        pageScope.put("paginationEnabled", this.htmlConfig.isPaginationEnabled());
        pageScope.put("displayNumRows", this.htmlConfig.isNumRowsEnabled());
        pageScope.putAll(pageData.getScope());
        Mustache mustachePage = this.mustacheFactory.compile(pageData.getTemplateName());
        mustachePage.execute((Writer)result, pageScope).flush();
        HashMap<String, Object> containerScope = new HashMap<String, Object>();
        containerScope.put("content", result);
        containerScope.put("pageScript", pageData.getScriptName());
        containerScope.put("rootPath", this.getRootPath(pageData.getDepth()));
        containerScope.put("rootPathtoHome", this.getRootPathToHome(pageData.getDepth()));
        containerScope.putAll(pageScope);
        Mustache mustacheContainer = this.mustacheFactory.compile("container.html");
        mustacheContainer.execute(writer, containerScope).flush();
    }

    public String getRootPath(int depth) {
        return IntStream.range(0, depth).mapToObj(i -> "../").collect(Collectors.joining("", "", ""));
    }

    private String getRootPathToHome(int depth) {
        String path = this.getRootPath(depth);
        if (this.htmlConfig.isOneOfMultipleSchemas()) {
            path = path + "../";
        }
        return path;
    }
}

