/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.util.Markdown;
import org.schemaspy.view.MustacheCheckConstraint;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.MustacheTableColumn;
import org.schemaspy.view.MustacheTableDiagram;
import org.schemaspy.view.MustacheTableIndex;
import org.schemaspy.view.PageData;
import org.schemaspy.view.SqlAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlTablePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;
    private final SqlAnalyzer sqlAnalyzer;

    public HtmlTablePage(MustacheCompiler mustacheCompiler, SqlAnalyzer sqlAnalyzer) {
        this.mustacheCompiler = mustacheCompiler;
        this.sqlAnalyzer = sqlAnalyzer;
    }

    public void write(Table table, List<MustacheTableDiagram> diagrams, Writer writer) {
        HashSet primaries = new HashSet(table.getPrimaryColumns());
        HashSet indexes = new HashSet();
        LinkedHashSet<MustacheTableColumn> tableColumns = new LinkedHashSet<MustacheTableColumn>();
        LinkedHashSet<MustacheTableIndex> indexedColumns = new LinkedHashSet<MustacheTableIndex>();
        Set checkConstraints = table.getCheckConstraints().entrySet().stream().map(entry -> new MustacheCheckConstraint(table.getName(), (String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
        TreeSet sortIndexes = new TreeSet(table.getIndexes());
        for (TableIndex index : sortIndexes) {
            indexes.addAll(index.getColumns());
            indexedColumns.add(new MustacheTableIndex(index));
        }
        for (TableColumn column : table.getColumns()) {
            tableColumns.add(new MustacheTableColumn(column, indexes.contains(column), this.mustacheCompiler.getRootPath(1)));
        }
        LOGGER.debug("Writing table page -> {}", (Object)table.getName());
        PageData pageData = new PageData.Builder().templateName("tables/table.html").scriptName("table.js").addToScope("table", (Object)table).addToScope("comments", (Object)Markdown.toHtml((String)table.getComments(), (String)this.mustacheCompiler.getRootPath(1))).addToScope("primaries", primaries).addToScope("columns", tableColumns).addToScope("indexes", indexedColumns).addToScope("checkConstraints", checkConstraints).addToScope("diagrams", diagrams).addToScope("sqlCode", (Object)HtmlTablePage.sqlCode((Table)table)).addToScope("references", (Object)this.sqlReferences(table)).depth(1).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write table page for '{}'", (Object)table.getName(), (Object)e);
        }
    }

    private Set<Table> sqlReferences(Table table) {
        LinkedHashSet<Table> references = new LinkedHashSet<Table>();
        if (table.isView() && table.getViewDefinition() != null) {
            references.addAll(this.sqlAnalyzer.getReferencedTables(table.getViewDefinition()));
        }
        return references;
    }

    private static String sqlCode(Table table) {
        return table.getViewDefinition() != null ? table.getViewDefinition().trim() : "";
    }
}

