/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.schemaspy.model.Routine;
import org.schemaspy.util.Markdown;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlRoutinesPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;

    public HtmlRoutinesPage(MustacheCompiler mustacheCompiler) {
        this.mustacheCompiler = mustacheCompiler;
    }

    public void write(Collection<Routine> routines, Writer writer) {
        PageData pageData = new PageData.Builder().templateName("routines.html").scriptName("routines.js").addToScope("routines", routines).addToScope("md2html", md -> Markdown.toHtml((String)md, (String)this.mustacheCompiler.getRootPath(0))).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write routines page", (Throwable)e);
        }
    }
}

