/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.validator;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameValidator {
    private final String clazz;
    private final Pattern include;
    private final Pattern exclude;
    private final Set<String> validTypes;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NameValidator(String clazz, Pattern include, Pattern exclude, String[] validTypes) {
        this.clazz = clazz;
        this.include = include;
        this.exclude = exclude;
        this.validTypes = new HashSet();
        for (String type : validTypes) {
            this.validTypes.add(type.toUpperCase());
        }
    }

    public boolean isValid(String name, String type) {
        if (!this.validTypes.contains(type.toUpperCase())) {
            return false;
        }
        if (this.exclude.matcher(name).matches()) {
            LOGGER.debug("Excluding {} {}: matches exclusion pattern '{}'", new Object[]{this.clazz, name, this.exclude});
            return false;
        }
        boolean valid = this.include.matcher(name).matches();
        if (valid) {
            LOGGER.debug("Including {} {}: matches inclusion pattern '{}'", new Object[]{this.clazz, name, this.include});
        } else {
            LOGGER.debug("Excluding {} {}: doesn't match inclusion pattern '{}'", new Object[]{this.clazz, name, this.include});
        }
        return valid;
    }
}

