/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ResourceWriter() {
    }

    public static void copyResources(URL resourceUrl, File targetPath, FileFilter filter) throws IOException {
        if (resourceUrl == null) {
            return;
        }
        URLConnection urlConnection = resourceUrl.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            ResourceWriter.copyJarResourceToPath((JarURLConnection)((JarURLConnection)urlConnection), (File)targetPath, (FileFilter)filter);
        } else {
            File file = new File(resourceUrl.getPath());
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)targetPath, (FileFilter)filter);
            } else {
                FileUtils.copyFile((File)file, (File)targetPath);
            }
        }
    }

    private static void copyJarResourceToPath(JarURLConnection jarConnection, File destPath, FileFilter filter) {
        try {
            JarFile jarFile = jarConnection.getJarFile();
            String jarConnectionEntryName = jarConnection.getEntryName();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName + "/")) continue;
                String filename = jarEntryName.substring(jarConnectionEntryName.length());
                File currentFile = new File(destPath, filename);
                if (jarEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)currentFile);
                    continue;
                }
                if (filter != null && !filter.accept(currentFile)) continue;
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }
}

