/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.schemaspy.util.DbSpecificOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbSpecificConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern OPTION_PATTER = Pattern.compile("<([a-zA-Z0-9.\\-_]+)>");
    private static final String DUMP_FORMAT = "   -%s   \t\t%s";
    private String dbType;
    private String description;
    private final List<DbSpecificOption> options = new ArrayList();

    public DbSpecificConfig(String dbType, Properties props) {
        this.dbType = dbType;
        this.description = props.getProperty("description");
        this.loadOptions(props);
    }

    private void loadOptions(Properties properties) {
        Set optionsFound = DbSpecificConfig.findOptions((String)properties.getProperty("connectionSpec"));
        optionsFound.stream().forEachOrdered(optionName -> {
            String desc = properties.getProperty((String)optionName);
            this.options.add(new DbSpecificOption(optionName, desc));
        });
    }

    private static Set<String> findOptions(String connectionSpec) {
        LinkedHashSet<String> optionsFound = new LinkedHashSet<String>();
        Matcher matcher = OPTION_PATTER.matcher(connectionSpec);
        while (matcher.find()) {
            optionsFound.add(matcher.group(1));
        }
        return optionsFound;
    }

    public List<DbSpecificOption> getOptions() {
        return this.options;
    }

    public void dumpUsage() {
        LOGGER.info("{} (-t {})", (Object)this.description, (Object)this.dbType);
        this.getOptions().stream().flatMap(option -> {
            if ("hostOptionalPort".equals(option.getName())) {
                return Stream.of(String.format("   -%s   \t\t%s", "host", "host of database, may contain port"), String.format("   -%s   \t\t%s", "port", "optional port if not default"));
            }
            return Stream.of(String.format("   -%s   \t\t%s", option.getName(), DbSpecificConfig.getDescription((DbSpecificOption)option)));
        }).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    private static String getDescription(DbSpecificOption option) {
        return Objects.isNull(option.getDescription()) ? "" : option.getDescription();
    }

    public String toString() {
        return this.description;
    }
}

