/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.xml.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.schemaspy.model.Routine;
import org.schemaspy.output.xml.dom.DOMUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlRoutineFormatter {
    public void appendRoutines(Element schemaNode, Collection<Routine> routines) {
        LinkedList<Routine> routinesList = new LinkedList<Routine>(routines);
        Collections.sort(routinesList, Comparator.comparing(Routine::getName));
        if (!routinesList.isEmpty()) {
            Element routinesElement = schemaNode.getOwnerDocument().createElement("routines");
            schemaNode.appendChild(routinesElement);
            for (Routine routine : routinesList) {
                XmlRoutineFormatter.appendRoutine((Element)routinesElement, (Routine)routine);
            }
        }
    }

    private static void appendRoutine(Element routinesElement, Routine routine) {
        Element routineElement = routinesElement.getOwnerDocument().createElement("routine");
        routinesElement.appendChild(routineElement);
        DOMUtil.appendAttribute((Node)routineElement, (String)"name", (String)routine.getName());
        DOMUtil.appendAttribute((Node)routineElement, (String)"type", (String)routine.getType());
        DOMUtil.appendAttribute((Node)routineElement, (String)"returnType", (String)routine.getReturnType());
        DOMUtil.appendAttribute((Node)routineElement, (String)"dataAccess", (String)routine.getDataAccess());
        DOMUtil.appendAttribute((Node)routineElement, (String)"securityType", (String)routine.getSecurityType());
        DOMUtil.appendAttribute((Node)routineElement, (String)"deterministic", (String)Boolean.toString(routine.isDeterministic()));
        Element commentElement = routinesElement.getOwnerDocument().createElement("comment");
        routineElement.appendChild(commentElement);
        if (XmlRoutineFormatter.notNullOrEmpty((String)routine.getComment())) {
            CDATASection commentCDATA = routinesElement.getOwnerDocument().createCDATASection(routine.getComment());
            commentElement.appendChild(commentCDATA);
        }
        Element definitionElement = routinesElement.getOwnerDocument().createElement("definition");
        routineElement.appendChild(definitionElement);
        if (XmlRoutineFormatter.notNullOrEmpty((String)routine.getDefinitionLanguage())) {
            DOMUtil.appendAttribute((Node)definitionElement, (String)"language", (String)routine.getDefinitionLanguage());
        }
        if (XmlRoutineFormatter.notNullOrEmpty((String)routine.getDefinition())) {
            CDATASection definitionCDATA = routinesElement.getOwnerDocument().createCDATASection(routine.getDefinition());
            definitionElement.appendChild(definitionCDATA);
        }
    }

    private static boolean notNullOrEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

