/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.html.mustache.diagrams.MustacheDiagramFactory;
import org.schemaspy.util.Writers;
import org.schemaspy.view.MustacheTableDiagram;
import org.schemaspy.view.WriteStats;

/*
 * Exception performing whole class analysis ignored.
 */
public class MustacheTableDiagramFactory {
    private final DotFormatter dotProducer;
    private final MustacheDiagramFactory mustacheDiagramFactory;
    private final File tableDir;
    private final int degreeOfSeparation;

    public MustacheTableDiagramFactory(DotFormatter dotProducer, MustacheDiagramFactory mustacheDiagramFactory, File outputDir, int degreeOfSeparation) {
        this.dotProducer = dotProducer;
        this.mustacheDiagramFactory = mustacheDiagramFactory;
        this.tableDir = outputDir.toPath().resolve("diagrams").resolve("tables").toFile();
        this.tableDir.mkdirs();
        this.degreeOfSeparation = degreeOfSeparation;
    }

    public List<MustacheTableDiagram> generateTableDiagrams(Table table, WriteStats stats) throws IOException {
        Throwable throwable;
        PrintWriter dotOut;
        Set impliedConstraints;
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        File oneDegreeDotFile = new File(this.tableDir, table.getName() + ".1degree.dot");
        File twoDegreesDotFile = new File(this.tableDir, table.getName() + ".2degrees.dot");
        File oneImpliedDotFile = new File(this.tableDir, table.getName() + ".implied1degrees.dot");
        File twoImpliedDotFile = new File(this.tableDir, table.getName() + ".implied2degrees.dot");
        Files.deleteIfExists(oneDegreeDotFile.toPath());
        Files.deleteIfExists(twoDegreesDotFile.toPath());
        Files.deleteIfExists(oneImpliedDotFile.toPath());
        Files.deleteIfExists(twoImpliedDotFile.toPath());
        if (MustacheTableDiagramFactory.hasNoRelationships((Table)table)) {
            return diagrams;
        }
        WriteStats oneStats = new WriteStats(stats);
        try (PrintWriter dotOut2 = Writers.newPrintWriter((File)oneDegreeDotFile);){
            impliedConstraints = this.dotProducer.writeRealRelationships(table, false, oneStats, dotOut2);
        }
        MustacheTableDiagram oneDiagram = this.mustacheDiagramFactory.generateTableDiagram("One", oneDegreeDotFile, table.getName() + ".1degree");
        oneDiagram.setActive(true);
        diagrams.add(oneDiagram);
        if (this.degreeOfSeparation == 2) {
            WriteStats twoStats = new WriteStats(stats);
            dotOut = Writers.newPrintWriter((File)twoDegreesDotFile);
            throwable = null;
            try {
                impliedConstraints = this.dotProducer.writeRealRelationships(table, true, twoStats, dotOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dotOut != null) {
                    if (throwable != null) {
                        try {
                            dotOut.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dotOut.close();
                    }
                }
            }
            if (MustacheTableDiagramFactory.sameWritten((WriteStats)oneStats, (WriteStats)twoStats)) {
                Files.deleteIfExists(twoDegreesDotFile.toPath());
            } else {
                diagrams.add(this.mustacheDiagramFactory.generateTableDiagram("Two degrees", twoDegreesDotFile, table.getName() + ".2degrees"));
            }
        }
        if (MustacheTableDiagramFactory.notEmpty((Collection)impliedConstraints)) {
            WriteStats oneImplied = new WriteStats(stats);
            dotOut = Writers.newPrintWriter((File)oneImpliedDotFile);
            throwable = null;
            try {
                this.dotProducer.writeAllRelationships(table, false, oneImplied, dotOut);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dotOut != null) {
                    if (throwable != null) {
                        try {
                            dotOut.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dotOut.close();
                    }
                }
            }
            MustacheTableDiagram oneImpliedDiagram = this.mustacheDiagramFactory.generateTableDiagram("One implied", oneImpliedDotFile, table.getName() + ".implied1degrees");
            oneImpliedDiagram.setIsImplied(true);
            diagrams.add(oneImpliedDiagram);
            if (this.degreeOfSeparation == 2) {
                WriteStats twoImplied = new WriteStats(stats);
                try (PrintWriter dotOut3 = Writers.newPrintWriter((File)twoImpliedDotFile);){
                    this.dotProducer.writeAllRelationships(table, true, twoImplied, dotOut3);
                }
                if (MustacheTableDiagramFactory.sameWritten((WriteStats)oneImplied, (WriteStats)twoImplied)) {
                    Files.deleteIfExists(twoImpliedDotFile.toPath());
                } else {
                    MustacheTableDiagram twoImpliedDiagram = this.mustacheDiagramFactory.generateTableDiagram("Two implied", twoImpliedDotFile, table.getName() + ".implied2degrees");
                    twoImpliedDiagram.setIsImplied(true);
                    diagrams.add(twoImpliedDiagram);
                }
            }
        }
        return diagrams;
    }

    private static boolean hasNoRelationships(Table table) {
        return table.getMaxChildren() + table.getMaxParents() < 1;
    }

    private static boolean notEmpty(Collection<?> collection) {
        return !collection.isEmpty();
    }

    private static boolean sameWritten(WriteStats first, WriteStats second) {
        return first.getNumTablesWritten() + first.getNumViewsWritten() == second.getNumTablesWritten() + second.getNumViewsWritten();
    }
}

