/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.schemaspy.analyzer.ImpliedConstraintsFinder;
import org.schemaspy.model.Database;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;
import org.schemaspy.output.OutputException;
import org.schemaspy.output.diagram.DiagramException;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.html.mustache.diagrams.MustacheDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramResults;
import org.schemaspy.util.Writers;
import org.schemaspy.view.MustacheTableDiagram;
import org.schemaspy.view.WriteStats;

public class MustacheSummaryDiagramFactory {
    private static final String FILE_PREFIX = "relationships";
    private static final String FAILED_DOT = "Failed to produce dot: ";
    private static final String FAILED_DIAGRAM = "Failed to produce diagram for: ";
    private final DotFormatter dotProducer;
    private final MustacheDiagramFactory mustacheDiagramFactory;
    private final ImpliedConstraintsFinder impliedConstraintsFinder;
    private final Path summaryDir;

    public MustacheSummaryDiagramFactory(DotFormatter dotProducer, MustacheDiagramFactory mustacheDiagramFactory, ImpliedConstraintsFinder impliedConstraintsFinder, File outputDir) {
        this.dotProducer = dotProducer;
        this.mustacheDiagramFactory = mustacheDiagramFactory;
        this.impliedConstraintsFinder = impliedConstraintsFinder;
        this.summaryDir = outputDir.toPath().resolve("diagrams").resolve("summary");
    }

    public MustacheSummaryDiagramResults generateSummaryDiagrams(Database database, Collection<Table> tables, boolean includeImpliedConstraints, boolean showDetailedTables, ProgressListener progressListener) throws IOException {
        boolean hasRealRelationships;
        Files.createDirectories(this.summaryDir, new FileAttribute[0]);
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        ArrayList<OutputException> outputExceptions = new ArrayList<OutputException>();
        WriteStats stats = new WriteStats(tables);
        File realCompactDot = this.summaryDir.resolve("relationships.real.compact.dot").toFile();
        try (PrintWriter out = Writers.newPrintWriter((File)realCompactDot);){
            this.dotProducer.writeRealRelationships(database, tables, true, showDetailedTables, stats, out);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + realCompactDot.toString(), (Throwable)ioexception));
        }
        boolean bl = hasRealRelationships = stats.getNumTablesWritten() > 0 || stats.getNumViewsWritten() > 0;
        if (hasRealRelationships) {
            try {
                MustacheTableDiagram realCompactDiagram = this.mustacheDiagramFactory.generateSummaryDiagram("Compact", realCompactDot, "relationships.real.compact");
                realCompactDiagram.setActive(true);
                diagrams.add(realCompactDiagram);
            }
            catch (DiagramException diagramException) {
                outputExceptions.add(new OutputException(FAILED_DIAGRAM + realCompactDot.toString(), (Throwable)diagramException));
            }
            this.generateRealLarge(database, tables, showDetailedTables, diagrams, outputExceptions, stats);
        } else {
            Files.deleteIfExists(realCompactDot.toPath());
        }
        ArrayList impliedConstraints = new ArrayList();
        if (includeImpliedConstraints) {
            impliedConstraints.addAll(this.impliedConstraintsFinder.find(tables));
        }
        progressListener.graphingSummaryProgressed();
        if (!impliedConstraints.isEmpty()) {
            this.generateImpliedCompact(database, tables, showDetailedTables, diagrams, outputExceptions, stats);
            this.generateImpliedLarge(database, tables, showDetailedTables, diagrams, outputExceptions, stats);
        }
        if (!diagrams.isEmpty()) {
            ((MustacheTableDiagram)diagrams.get(0)).setActive(true);
        }
        return new MustacheSummaryDiagramResults(diagrams, stats, hasRealRelationships, impliedConstraints, outputExceptions);
    }

    private void generateRealLarge(Database database, Collection<Table> tables, boolean showDetailedTables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions, WriteStats stats) {
        File realLargeDot = this.summaryDir.resolve("relationships.real.large.dot").toFile();
        try (PrintWriter out = Writers.newPrintWriter((File)realLargeDot);){
            this.dotProducer.writeRealRelationships(database, tables, false, showDetailedTables, stats, out);
            MustacheTableDiagram realLargeDiagram = this.mustacheDiagramFactory.generateSummaryDiagram("Large", realLargeDot, "relationships.real.large");
            diagrams.add(realLargeDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + realLargeDot.toString(), (Throwable)ioexception));
        }
        catch (DiagramException diagramException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + realLargeDot.toString(), (Throwable)diagramException));
        }
    }

    private void generateImpliedCompact(Database database, Collection<Table> tables, boolean showDetailedTables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions, WriteStats stats) {
        File impliedCompactDot = this.summaryDir.resolve("relationships.implied.compact.dot").toFile();
        try (PrintWriter out = Writers.newPrintWriter((File)impliedCompactDot);){
            this.dotProducer.writeAllRelationships(database, tables, true, showDetailedTables, stats, out);
            MustacheTableDiagram impliedCompactDiagram = this.mustacheDiagramFactory.generateSummaryDiagram("Compact Implied", impliedCompactDot, "relationships.implied.compact");
            impliedCompactDiagram.setIsImplied(true);
            diagrams.add(impliedCompactDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + impliedCompactDot.toString(), (Throwable)ioexception));
        }
        catch (DiagramException diagramException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + impliedCompactDot.toString(), (Throwable)diagramException));
        }
    }

    private void generateImpliedLarge(Database database, Collection<Table> tables, boolean showDetailedTables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions, WriteStats stats) {
        File impliedLargeDot = this.summaryDir.resolve("relationships.implied.large.dot").toFile();
        try (PrintWriter out = Writers.newPrintWriter((File)impliedLargeDot);){
            this.dotProducer.writeAllRelationships(database, tables, false, showDetailedTables, stats, out);
            MustacheTableDiagram impliedLargeDiagram = this.mustacheDiagramFactory.generateSummaryDiagram("Large Implied", impliedLargeDot, "relationships.implied.large");
            impliedLargeDiagram.setIsImplied(true);
            diagrams.add(impliedLargeDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + impliedLargeDot.toString(), (Throwable)ioexception));
        }
        catch (DiagramException diagramException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + impliedLargeDot.toString(), (Throwable)diagramException));
        }
    }
}

