/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.schemaspy.model.Table;
import org.schemaspy.output.diagram.DiagramException;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.html.mustache.diagrams.MustacheDiagramFactory;
import org.schemaspy.util.Writers;
import org.schemaspy.view.MustacheTableDiagram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MustacheOrphanDiagramFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DotFormatter dotProducer;
    private final MustacheDiagramFactory mustacheDiagramFactory;
    private final Path orphanDir;

    public MustacheOrphanDiagramFactory(DotFormatter dotProducer, MustacheDiagramFactory mustacheDiagramFactory, File outputDir) {
        this.dotProducer = dotProducer;
        this.mustacheDiagramFactory = mustacheDiagramFactory;
        this.orphanDir = outputDir.toPath().resolve("diagrams").resolve("orphans");
    }

    public List<MustacheTableDiagram> generateOrphanDiagrams(List<Table> orphanTables) {
        Collections.sort(orphanTables, (t1, t2) -> {
            Integer size2;
            Integer size1 = ((Table)t1).getColumns().size();
            int sizeComp = size1.compareTo(size2 = Integer.valueOf(((Table)t2).getColumns().size()));
            if (sizeComp != 0) {
                return sizeComp;
            }
            String name1 = ((Table)t1).getName();
            String name2 = ((Table)t1).getName();
            return name1.compareTo(name2);
        });
        ArrayList<MustacheTableDiagram> mustacheTableDiagrams = new ArrayList<MustacheTableDiagram>();
        for (Table table : orphanTables) {
            String dotBaseFilespec = table.getName();
            File dotFile = this.orphanDir.resolve(dotBaseFilespec + ".1degree.dot").toFile();
            try {
                PrintWriter dotOut = Writers.newPrintWriter((File)dotFile);
                Throwable throwable = null;
                try {
                    this.dotProducer.writeOrphan(table, dotOut);
                    mustacheTableDiagrams.add(this.mustacheDiagramFactory.generateOrphanDiagram(dotBaseFilespec, dotFile, dotBaseFilespec + ".1degree"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dotOut == null) continue;
                    if (throwable != null) {
                        try {
                            dotOut.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dotOut.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to produce dot: {}", (Object)dotFile, (Object)e);
            }
            catch (DiagramException e) {
                LOGGER.error("Failed to produce diagram for: {}", (Object)dotFile, (Object)e);
            }
        }
        return mustacheTableDiagrams;
    }
}

