/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.output.dot.DotConfig;
import org.schemaspy.output.dot.schemaspy.DotNode;
import org.schemaspy.output.dot.schemaspy.Html;
import org.schemaspy.output.dot.schemaspy.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DotNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Html html = new Html();
    private static final StyleSheet CSS = StyleSheet.getInstance();
    private static final String INDENT_6 = "      ";
    private final Table table;
    private final String path;
    private final DotNodeConfig config;
    private final DotConfig dotConfig;
    private final Set<TableColumn> excludedColumns = new HashSet();
    private final String lineSeparator = System.getProperty("line.separator");
    private final String columnSpan;
    private boolean showImpliedRelationships;

    public DotNode(Table table, String path, DotNodeConfig config, DotConfig dotConfig) {
        this.table = table;
        this.config = config;
        this.dotConfig = dotConfig;
        this.path = this.createPath(path);
        this.columnSpan = DotNodeConfig.access$000((DotNodeConfig)config) ? "COLSPAN=\"2\" " : "COLSPAN=\"3\" ";
    }

    private String createPath(String path) {
        if (this.dotConfig.useRelativeLinks()) {
            return (this.table.isRemote() ? "../../../" + this.table.getContainer() : "../..") + "/tables/";
        }
        return this.table.isRemote() ? "../" + this.table.getContainer() + "/tables/" : path;
    }

    public void setShowImplied(boolean showImplied) {
        this.showImpliedRelationships = showImplied;
    }

    public Table getTable() {
        return this.table;
    }

    public void excludeColumn(TableColumn column) {
        this.excludedColumns.add(column);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String tableName = this.table.getName();
        String fqTableName = (this.table.isRemote() ? this.table.getContainer() + "." : "") + tableName;
        String colspanHeader = DotNodeConfig.access$000((DotNodeConfig)this.config) ? "COLSPAN=\"4\" " : "COLSPAN=\"3\" ";
        String tableOrView = this.table.isView() ? "view" : "table";
        buf.append("  \"" + fqTableName + "\" [" + this.lineSeparator);
        buf.append("   label=<" + this.lineSeparator);
        buf.append("    <TABLE BORDER=\"" + (DotNodeConfig.access$000((DotNodeConfig)this.config) ? "2" : "0") + "\" CELLBORDER=\"1\" CELLSPACING=\"0\" BGCOLOR=\"" + CSS.getTableBackground() + "\">" + this.lineSeparator);
        buf.append("      <TR>");
        buf.append("<TD " + colspanHeader + " BGCOLOR=\"" + CSS.getTableHeadBackground() + "\">");
        buf.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\">");
        buf.append("<TR>");
        buf.append("<TD ALIGN=\"LEFT\"><B>" + DotNode.escapeHtml((String)fqTableName) + "</B>" + "</TD>");
        buf.append("<TD ALIGN=\"RIGHT\">[" + tableOrView + "]" + "</TD>");
        buf.append("</TR>");
        buf.append("</TABLE>");
        buf.append("</TD>");
        buf.append("</TR>" + this.lineSeparator);
        buf.append(this.columnsToString());
        if (!this.table.isView()) {
            buf.append(this.tableToString());
        }
        buf.append("    </TABLE>>" + this.lineSeparator);
        if (!this.table.isRemote() || this.dotConfig.isOneOfMultipleSchemas()) {
            buf.append("    URL=\"" + this.path + DotNode.urlEncodeLink((String)tableName) + ".html\"" + this.lineSeparator);
            buf.append("    target=\"_top\"" + this.lineSeparator);
        }
        buf.append("    tooltip=\"" + DotNode.escapeHtml((String)fqTableName) + "\"" + this.lineSeparator);
        buf.append("  ];");
        return buf.toString();
    }

    private String columnsToString() {
        StringBuilder buf = new StringBuilder();
        boolean skippedTrivial = false;
        if (DotNodeConfig.access$100((DotNodeConfig)this.config)) {
            Set indexColumns = this.getIndexColumns();
            int maxWidth = this.getColumnMaxWidth();
            for (TableColumn column : this.table.getColumns()) {
                if (DotNodeConfig.access$200((DotNodeConfig)this.config) || DotNodeConfig.access$000((DotNodeConfig)this.config) || column.isPrimary() || column.isForeignKey() || indexColumns.contains(column)) {
                    buf.append(this.columnToString(column, indexColumns, maxWidth));
                    continue;
                }
                skippedTrivial = true;
            }
        }
        if (skippedTrivial || !DotNodeConfig.access$100((DotNodeConfig)this.config)) {
            buf.append("      <TR><TD PORT=\"elipses\" COLSPAN=\"3\" ALIGN=\"LEFT\">...</TD></TR>" + this.lineSeparator);
        }
        return buf.toString();
    }

    private Set<TableColumn> getIndexColumns() {
        LinkedHashSet<TableColumn> indexColumns = new LinkedHashSet<TableColumn>();
        for (TableIndex index : this.table.getIndexes()) {
            indexColumns.addAll(index.getColumns());
        }
        indexColumns.removeAll(this.table.getPrimaryColumns());
        return indexColumns;
    }

    private int getColumnMaxWidth() {
        int maxWidth = this.getTextWidth(this.table.getName());
        for (TableColumn column : this.table.getColumns()) {
            int size = this.getTextWidth(column.getName());
            if (maxWidth >= size) continue;
            maxWidth = size;
        }
        return maxWidth;
    }

    private int getTextWidth(String text) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        int fontSize = this.dotConfig.getFontSize() + 1;
        Font font = new Font(this.dotConfig.getFont(), 1, fontSize);
        return (int)font.getStringBounds(text, frc).getWidth();
    }

    private String columnToString(TableColumn column, Set<TableColumn> indexColumns, int maxWidth) {
        StringBuilder buf = new StringBuilder();
        buf.append("      <TR>");
        buf.append("<TD PORT=\"" + DotNode.escapeHtml((String)column.getName()) + "\" " + this.columnSpan);
        if (this.excludedColumns.contains(column)) {
            buf.append("BGCOLOR=\"" + CSS.getExcludedColumnBackgroundColor() + "\" ");
        } else if (indexColumns.contains(column)) {
            buf.append("BGCOLOR=\"" + CSS.getIndexedColumnBackground() + "\" ");
        }
        buf.append("ALIGN=\"LEFT\">");
        buf.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" ALIGN=\"LEFT\">");
        buf.append("<TR ALIGN=\"LEFT\">");
        buf.append("<TD ALIGN=\"LEFT\" FIXEDSIZE=\"TRUE\" WIDTH=\"15\" HEIGHT=\"16\">");
        if (column.isPrimary()) {
            buf.append("<IMG SRC=\"../../images/primaryKeys.png\"/>");
        } else if (column.isForeignKey()) {
            buf.append("<IMG SRC=\"../../images/foreignKeys.png\"/>");
        }
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"LEFT\" FIXEDSIZE=\"TRUE\" WIDTH=\"" + maxWidth + "\" HEIGHT=\"16\">");
        buf.append(DotNode.escapeHtml((String)column.getName()));
        buf.append("</TD>");
        buf.append("</TR>");
        buf.append("</TABLE>");
        buf.append("</TD>");
        if (DotNodeConfig.access$000((DotNodeConfig)this.config)) {
            buf.append("<TD PORT=\"");
            buf.append(DotNode.escapeHtml((String)column.getName()));
            buf.append(".type\" ALIGN=\"LEFT\">");
            buf.append(column.getShortTypeName().toLowerCase());
            buf.append("[");
            buf.append(column.getDetailedSize());
            buf.append("]</TD>");
        }
        buf.append("</TR>" + this.lineSeparator);
        return buf.toString();
    }

    private String tableToString() {
        int numChildren;
        int numParents;
        StringBuilder buf = new StringBuilder();
        buf.append("      <TR>");
        buf.append("<TD ALIGN=\"LEFT\" BGCOLOR=\"" + CSS.getBodyBackground() + "\">");
        int n = numParents = this.showImpliedRelationships ? this.table.getNumParents() : this.table.getNumNonImpliedParents();
        if (numParents > 0 || DotNodeConfig.access$000((DotNodeConfig)this.config)) {
            buf.append("&lt; " + numParents);
        } else {
            buf.append("  ");
        }
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + CSS.getBodyBackground() + "\">");
        long numRows = this.table.getNumRows();
        if (this.dotConfig.isNumRowsEnabled() && numRows >= 0L) {
            buf.append(NumberFormat.getInstance().format(numRows));
            buf.append(" row");
            if (numRows != 1L) {
                buf.append('s');
            }
        } else {
            buf.append("  ");
        }
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"RIGHT\" BGCOLOR=\"" + CSS.getBodyBackground() + "\">");
        int n2 = numChildren = this.showImpliedRelationships ? this.table.getNumChildren() : this.table.getNumNonImpliedChildren();
        if (numChildren > 0 || DotNodeConfig.access$000((DotNodeConfig)this.config)) {
            buf.append(numChildren + " &gt;");
        } else {
            buf.append("  ");
        }
        buf.append("</TD></TR>" + this.lineSeparator);
        return buf.toString();
    }

    private static String escapeHtml(String string) {
        return html.escape(string);
    }

    private static String urlEncodeLink(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error trying to urlEncode string [{}] with encoding [{}]", new Object[]{string, StandardCharsets.UTF_8.name(), e});
            return string;
        }
    }
}

