/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.schemaspy.model.Database;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.dot.DotConfig;
import org.schemaspy.output.dot.schemaspy.DotConnector;
import org.schemaspy.output.dot.schemaspy.DotConnectorFinder;
import org.schemaspy.output.dot.schemaspy.DotNode;
import org.schemaspy.output.dot.schemaspy.StyleSheet;
import org.schemaspy.view.WriteStats;

/*
 * Exception performing whole class analysis ignored.
 */
public class DotFormatter {
    private final DotConfig dotConfig;

    public DotFormatter(DotConfig dotConfig) {
        this.dotConfig = dotConfig;
    }

    public Set<ForeignKeyConstraint> writeRealRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, PrintWriter dot) {
        return this.writeRelationships(table, twoDegreesOfSeparation, stats, false, dot);
    }

    public void writeAllRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, PrintWriter dot) {
        this.writeRelationships(table, twoDegreesOfSeparation, stats, true, dot);
    }

    private Set<ForeignKeyConstraint> writeRelationships(Table table, boolean twoDegreesOfSeparation, WriteStats stats, boolean includeImplied, PrintWriter dot) {
        HashSet<Table> tablesWritten = new HashSet<Table>();
        HashSet<ForeignKeyConstraint> skippedImpliedConstraints = new HashSet<ForeignKeyConstraint>();
        DotConnectorFinder finder = DotConnectorFinder.getInstance();
        String diagramName = (twoDegreesOfSeparation ? "twoDegreesRelationshipsDiagram" : "oneDegreeRelationshipsDiagram") + (includeImplied ? "Implied" : "");
        this.writeHeader(diagramName, true, dot);
        Set relatedTables = DotFormatter.getImmediateRelatives((Table)table, (boolean)true, (boolean)includeImplied, skippedImpliedConstraints);
        TreeSet<Object> connectors = new TreeSet<Object>(finder.getRelatedConnectors(table, includeImplied));
        tablesWritten.add(table);
        TreeMap<Table, DotNode> nodes = new TreeMap<Table, DotNode>();
        for (Table table2 : relatedTables) {
            if (!tablesWritten.add(table2)) continue;
            nodes.put(table2, new DotNode(table2, "", new DotNode.DotNodeConfig(false, false), this.dotConfig));
            connectors.addAll(finder.getRelatedConnectors(table2, table, true, includeImplied));
        }
        for (DotConnector dotConnector : connectors) {
            if (!dotConnector.pointsTo(table)) continue;
            dotConnector.connectToParentDetails();
        }
        HashSet allCousins = new HashSet();
        TreeSet<DotConnector> treeSet = new TreeSet<DotConnector>();
        if (twoDegreesOfSeparation) {
            for (Table relatedTable : relatedTables) {
                Set cousins = DotFormatter.getImmediateRelatives((Table)relatedTable, (boolean)false, (boolean)includeImplied, skippedImpliedConstraints);
                for (Table cousin : cousins) {
                    if (!tablesWritten.add(cousin)) continue;
                    treeSet.addAll(finder.getRelatedConnectors(cousin, relatedTable, false, includeImplied));
                    nodes.put(cousin, new DotNode(cousin, "", new DotNode.DotNodeConfig(), this.dotConfig));
                }
                allCousins.addAll(cousins);
            }
        }
        ArrayList participants = new ArrayList(nodes.keySet());
        Iterator iter = participants.iterator();
        while (iter.hasNext()) {
            Table participantA = (Table)iter.next();
            iter.remove();
            for (Table participantB : participants) {
                for (DotConnector connector : finder.getRelatedConnectors(participantA, participantB, false, includeImplied)) {
                    if (twoDegreesOfSeparation && (allCousins.contains(participantA) || allCousins.contains(participantB))) {
                        treeSet.add(connector);
                        continue;
                    }
                    connectors.add(connector);
                }
            }
        }
        DotFormatter.markExcludedColumns(nodes, (Set)stats.getExcludedColumns());
        for (DotConnector dotConnector : treeSet) {
            if (allCousins.contains(dotConnector.getParentTable()) && !relatedTables.contains(dotConnector.getParentTable())) {
                dotConnector.connectToParentTitle();
            }
            if (!allCousins.contains(dotConnector.getChildTable()) || relatedTables.contains(dotConnector.getChildTable())) continue;
            dotConnector.connectToChildTitle();
        }
        nodes.put(table, new DotNode(table, "", new DotNode.DotNodeConfig(true, true), this.dotConfig));
        connectors.addAll(treeSet);
        for (DotConnector dotConnector : connectors) {
            if (dotConnector.isImplied()) {
                DotNode node = (DotNode)nodes.get(dotConnector.getParentTable());
                if (node != null) {
                    node.setShowImplied(true);
                }
                if ((node = (DotNode)nodes.get(dotConnector.getChildTable())) != null) {
                    node.setShowImplied(true);
                }
            }
            dot.println(dotConnector.toString());
        }
        for (DotNode dotNode : nodes.values()) {
            dot.println(dotNode.toString());
            stats.wroteTable(dotNode.getTable());
        }
        dot.println("}");
        return skippedImpliedConstraints;
    }

    private static Set<Table> getImmediateRelatives(Table table, boolean includeExcluded, boolean includeImplied, Set<ForeignKeyConstraint> skippedImpliedConstraints) {
        HashSet<TableColumn> relatedColumns = new HashSet<TableColumn>();
        for (TableColumn column : table.getColumns()) {
            ForeignKeyConstraint constraint;
            if (column.isAllExcluded() || !includeExcluded && column.isExcluded()) continue;
            for (TableColumn childColumn : column.getChildren()) {
                if (childColumn.isAllExcluded() || !includeExcluded && childColumn.isExcluded()) continue;
                constraint = column.getChildConstraint(childColumn);
                if (includeImplied || !constraint.isImplied()) {
                    relatedColumns.add(childColumn);
                    continue;
                }
                skippedImpliedConstraints.add(constraint);
            }
            for (TableColumn parentColumn : column.getParents()) {
                if (parentColumn.isAllExcluded() || !includeExcluded && parentColumn.isExcluded()) continue;
                constraint = column.getParentConstraint(parentColumn);
                if (includeImplied || !constraint.isImplied()) {
                    relatedColumns.add(parentColumn);
                    continue;
                }
                skippedImpliedConstraints.add(constraint);
            }
        }
        HashSet<Table> relatedTables = new HashSet<Table>();
        for (TableColumn column : relatedColumns) {
            relatedTables.add(column.getTable());
        }
        relatedTables.remove(table);
        return relatedTables;
    }

    private void writeHeader(String diagramName, boolean showLabel, PrintWriter dot) {
        dot.println("digraph \"" + diagramName + "\" {");
        dot.println("  graph [");
        boolean rankdirbug = this.dotConfig.isRankDirBugEnabled();
        if (!rankdirbug) {
            dot.println("    rankdir=\"RL\"");
        }
        dot.println("    bgcolor=\"" + StyleSheet.getInstance().getBodyBackground() + "\"");
        if (showLabel) {
            if (rankdirbug) {
                dot.println("    label=\"\\nLayout is significantly better without '-rankdirbug' option\"");
            } else {
                dot.println("    label=\"\\nGenerated by SchemaSpy\"");
            }
            dot.println("    labeljust=\"l\"");
        }
        dot.println("    nodesep=\"0.18\"");
        dot.println("    ranksep=\"0.46\"");
        dot.println("    fontname=\"" + this.dotConfig.getFont() + "\"");
        dot.println("    fontsize=\"" + this.dotConfig.getFontSize() + "\"");
        dot.println("    ration=\"compress\"");
        dot.println("  ];");
        dot.println("  node [");
        dot.println("    fontname=\"" + this.dotConfig.getFont() + "\"");
        dot.println("    fontsize=\"" + this.dotConfig.getFontSize() + "\"");
        dot.println("    shape=\"plaintext\"");
        dot.println("  ];");
        dot.println("  edge [");
        dot.println("    arrowsize=\"0.8\"");
        dot.println("  ];");
    }

    public void writeRealRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, WriteStats stats, PrintWriter dot) {
        this.writeRelationships(db, tables, compact, showColumns, false, stats, dot);
    }

    public boolean writeAllRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, WriteStats stats, PrintWriter dot) {
        return this.writeRelationships(db, tables, compact, showColumns, true, stats, dot);
    }

    private boolean writeRelationships(Database db, Collection<Table> tables, boolean compact, boolean showColumns, boolean includeImplied, WriteStats stats, PrintWriter dot) {
        DotConnectorFinder finder = DotConnectorFinder.getInstance();
        DotNode.DotNodeConfig nodeConfig = showColumns ? new DotNode.DotNodeConfig(!compact, false) : new DotNode.DotNodeConfig();
        boolean wroteImplied = false;
        String diagramName = includeImplied ? (compact ? "compactImpliedRelationshipsDiagram" : "largeImpliedRelationshipsDiagram") : (compact ? "compactRelationshipsDiagram" : "largeRelationshipsDiagram");
        this.writeHeader(diagramName, true, dot);
        TreeMap<Table, DotNode> nodes = new TreeMap<Table, DotNode>();
        for (Table table : tables) {
            if (table.isOrphan(includeImplied)) continue;
            nodes.put(table, new DotNode(table, "tables/", nodeConfig, this.dotConfig));
        }
        for (Table table : db.getRemoteTables()) {
            nodes.put(table, new DotNode(table, "tables/", nodeConfig, this.dotConfig));
        }
        TreeSet connectors = new TreeSet();
        for (DotNode node : nodes.values()) {
            connectors.addAll(finder.getRelatedConnectors(node.getTable(), includeImplied));
        }
        DotFormatter.markExcludedColumns(nodes, (Set)stats.getExcludedColumns());
        for (DotNode node : nodes.values()) {
            Table table = node.getTable();
            dot.println(node.toString());
            stats.wroteTable(table);
            wroteImplied = wroteImplied || includeImplied && table.isOrphan(false);
        }
        for (DotConnector connector : connectors) {
            dot.println(connector.toString());
        }
        dot.println("}");
        dot.flush();
        return wroteImplied;
    }

    private static void markExcludedColumns(Map<Table, DotNode> nodes, Set<TableColumn> excludedColumns) {
        for (TableColumn column : excludedColumns) {
            DotNode node = nodes.get(column.getTable());
            if (node == null) continue;
            node.excludeColumn(column);
        }
    }

    public void writeOrphan(Table table, PrintWriter dot) {
        this.writeHeader(table.getName(), false, dot);
        DotNode.DotNodeConfig nodeConfig = new DotNode.DotNodeConfig(true, true);
        dot.println(new DotNode(table, "tables/", nodeConfig, this.dotConfig).toString());
        dot.println("}");
        dot.flush();
    }
}

