/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.util.HashSet;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.dot.schemaspy.DotConnector;

public class DotConnectorFinder {
    private static DotConnectorFinder instance = new DotConnectorFinder();

    private DotConnectorFinder() {
    }

    public static DotConnectorFinder getInstance() {
        return instance;
    }

    public Set<DotConnector> getRelatedConnectors(Table table, boolean includeImplied) {
        HashSet<DotConnector> relationships = new HashSet<DotConnector>();
        for (TableColumn column : table.getColumns()) {
            relationships.addAll(this.getRelatedConnectors(column, null, false, includeImplied));
        }
        return relationships;
    }

    public Set<DotConnector> getRelatedConnectors(Table table1, Table table2, boolean includeExcluded, boolean includeImplied) {
        HashSet<DotConnector> relationships = new HashSet<DotConnector>();
        for (TableColumn column : table1.getColumns()) {
            relationships.addAll(this.getRelatedConnectors(column, table2, includeExcluded, includeImplied));
        }
        for (TableColumn column : table2.getColumns()) {
            relationships.addAll(this.getRelatedConnectors(column, table1, includeExcluded, includeImplied));
        }
        return relationships;
    }

    private Set<DotConnector> getRelatedConnectors(TableColumn column, Table targetTable, boolean includeExcluded, boolean includeImplied) {
        boolean implied;
        HashSet<DotConnector> relatedConnectors = new HashSet<DotConnector>();
        if (!includeExcluded && column.isExcluded()) {
            return relatedConnectors;
        }
        for (TableColumn parentColumn : column.getParents()) {
            Table parentTable = parentColumn.getTable();
            if (targetTable != null && parentTable != targetTable || targetTable == null && !includeExcluded && parentColumn.isExcluded() || (implied = column.getParentConstraint(parentColumn).isImplied()) && !includeImplied) continue;
            relatedConnectors.add(new DotConnector(parentColumn, column, implied));
        }
        for (TableColumn childColumn : column.getChildren()) {
            Table childTable = childColumn.getTable();
            if (targetTable != null && childTable != targetTable || targetTable == null && !includeExcluded && childColumn.isExcluded() || (implied = column.getChildConstraint(childColumn).isImplied()) && !includeImplied) continue;
            relatedConnectors.add(new DotConnector(column, childColumn, implied));
        }
        return relatedConnectors;
    }
}

