/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram.vizjs;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.schemaspy.output.diagram.DiagramException;
import org.schemaspy.output.diagram.DiagramProducer;

public class VizJSDot
implements DiagramProducer {
    private static final String ICON_SIZE = " , width: \"261px\" , height: \"261px\"";
    private static final int MB_64 = 0x4000000;
    protected ScriptEngine scriptEngine;

    public VizJSDot() {
        try {
            InputStream vizJs = VizJSDot.class.getResourceAsStream("/viz.js");
            if (vizJs == null) {
                throw new IllegalArgumentException("viz.js not found");
            }
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
            this.scriptEngine.eval(IOUtils.toString((InputStream)vizJs, (String)"UTF-8"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("viz.js", e);
        }
    }

    public String getImplementationDetails() {
        return "Viz.js 1.7.1 (Graphviz 2.40.1, Expat 2.1.0, Emscripten 1.37.9)";
    }

    public String getDiagramFormat() {
        return "svg";
    }

    public String generateDiagram(File dotFile, File diagramFile) {
        try {
            String dotSource = IOUtils.toString((URL)dotFile.toURI().toURL(), (String)"UTF-8");
            String svg = this.toSvg(dotSource, 0x4000000);
            try (FileWriter diagramWriter = new FileWriter(diagramFile);){
                IOUtils.write((String)svg, (Writer)diagramWriter);
            }
            return "";
        }
        catch (Exception e) {
            throw new DiagramException(e.getMessage());
        }
    }

    protected String toSvg(String dotSource, int jsEngineMemorySize) {
        try {
            this.scriptEngine.getBindings(100).put("dotSource", (Object)dotSource);
            return (String)this.scriptEngine.eval("Viz(dotSource,options = { totalMemory: " + jsEngineMemorySize + " , images: [{ path: \"../../images/foreignKeys.png\"" + ICON_SIZE + " },{ path: \"../../images/primaryKeys.png\"" + ICON_SIZE + " }]})");
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

