/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram.graphviz;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schemaspy.output.diagram.DiagramException;
import org.schemaspy.output.diagram.DiagramProducer;
import org.schemaspy.output.diagram.graphviz.GraphvizConfig;
import org.schemaspy.output.diagram.graphviz.GraphvizDot;
import org.schemaspy.output.diagram.graphviz.GraphvizVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphvizDot
implements DiagramProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GraphvizConfig graphvizConfig;
    private final GraphvizVersion graphvizVersion;
    private final GraphvizVersion supportedGraphvizVersion = new GraphvizVersion("2.26");
    private final GraphvizVersion badGraphvizVersion = new GraphvizVersion("2.31");
    private final String lineSeparator = System.getProperty("line.separator");
    private String dotExe;
    private final Set<String> validRenders = new HashSet();
    private final String effectiveRenderer;
    private static final String CAIRO_RENDERER = ":cairo";
    private static final String GD_RENDERER = ":gd";
    private static final String EMPTY_RENDERER = "";

    public GraphvizDot(GraphvizConfig graphvizConfig) {
        this.graphvizConfig = graphvizConfig;
        this.graphvizVersion = this.initVersion();
        this.initValidRenders();
        this.effectiveRenderer = this.initRenderer();
    }

    private GraphvizVersion initVersion() {
        String versionText = null;
        String[] dotCommand = new String[]{this.getExe(), "-V"};
        try {
            Process process = Runtime.getRuntime().exec(dotCommand);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String versionLine = reader.readLine();
            LOGGER.trace("GraphvizVersion: \"{}\"", (Object)versionLine);
            Matcher matcher = Pattern.compile("[0-9]+\\.[0-9]+[^\\.]").matcher(versionLine);
            if (matcher.find()) {
                versionText = matcher.group();
            } else {
                LOGGER.warn("Invalid dot configuration detected. '{}' returned: '{}'", (Object)GraphvizDot.getDisplayableCommand((String[])dotCommand), (Object)versionLine);
            }
        }
        catch (Exception validDotDoesntExist) {
            LOGGER.warn("Failed to query Graphviz version using '{}'", (Object)GraphvizDot.getDisplayableCommand((String[])dotCommand), (Object)validDotDoesntExist);
        }
        return new GraphvizVersion(versionText);
    }

    private void initValidRenders() {
        if (!this.isValid()) {
            return;
        }
        this.validRenders.add("");
        Pattern rendererPattern = Pattern.compile(this.getDiagramFormat() + "(:[^\"][a-zA-Z]*)");
        try {
            String[] dotCommand = new String[]{this.getExe(), "-T" + this.getDiagramFormat() + ':'};
            Process process = Runtime.getRuntime().exec(dotCommand);
            try (Scanner scanner = new Scanner(new InputStreamReader(process.getErrorStream()));){
                while (scanner.hasNext(rendererPattern)) {
                    this.validRenders.add(scanner.next(rendererPattern));
                }
            }
            process.waitFor();
        }
        catch (Exception exc) {
            LOGGER.error("Error determining if a renderer is supported", (Throwable)exc);
        }
    }

    public boolean isValid() {
        return this.exists() && (this.getGraphvizVersion().equals((Object)this.supportedGraphvizVersion) || this.getGraphvizVersion().compareTo(this.badGraphvizVersion) > 0);
    }

    public boolean exists() {
        return this.graphvizVersion.toString() != null;
    }

    private String initRenderer() {
        String possibleRenderer = this.graphvizConfig.getRenderer();
        if (Objects.isNull(possibleRenderer) || !this.validRenders.contains(possibleRenderer)) {
            possibleRenderer = this.validRenders.contains(":cairo") ? ":cairo" : (this.validRenders.contains(":gd") ? ":gd" : "");
        }
        LOGGER.info("Graphviz rendered set to '{}'", (Object)possibleRenderer);
        return possibleRenderer;
    }

    public String getImplementationDetails() {
        return "Graphviz dot " + this.getGraphvizVersion().toString();
    }

    public GraphvizVersion getGraphvizVersion() {
        return this.graphvizVersion;
    }

    public String getDiagramFormat() {
        return Objects.isNull(this.graphvizConfig.getImageFormat()) ? "png" : this.graphvizConfig.getImageFormat();
    }

    private String getExe() {
        if (this.dotExe == null) {
            if (Objects.isNull(this.graphvizConfig.getGraphvizDir())) {
                this.dotExe = "dot";
            } else {
                File gv = new File(this.graphvizConfig.getGraphvizDir());
                this.dotExe = new File(new File(gv, "bin"), "dot").toString();
            }
        }
        return this.dotExe;
    }

    public String generateDiagram(File dotFile, File diagramFile) {
        if (!this.isValid()) {
            throw new DiagramException("Dot missing or invalid version");
        }
        StringBuilder mapBuffer = new StringBuilder(1024);
        String[] dotCommand = new String[]{this.getExe(), "-T" + this.getDiagramFormat() + this.effectiveRenderer, dotFile.getName(), "-o" + diagramFile.getName(), "-Tcmapx"};
        String commandLine = GraphvizDot.getDisplayableCommand((String[])dotCommand);
        LOGGER.debug(commandLine);
        try {
            Process process = Runtime.getRuntime().exec(dotCommand, null, dotFile.getParentFile());
            new ProcessOutputReader(commandLine, process.getErrorStream()).start();
            try (BufferedReader mapReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = mapReader.readLine()) != null) {
                    mapBuffer.append(line);
                    mapBuffer.append(this.lineSeparator);
                }
            }
            int rc = process.waitFor();
            if (rc != 0) {
                throw new DiagramException("'" + commandLine + "' failed with return code " + rc);
            }
            if (!diagramFile.exists()) {
                throw new DiagramException("'" + commandLine + "' failed to create output file");
            }
            return mapBuffer.toString().replace("/>", ">");
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new DiagramException("Interrupted during execution", (Throwable)interrupted);
        }
        catch (IOException | DiagramException exception) {
            try {
                Files.deleteIfExists(diagramFile.toPath());
            }
            catch (IOException ioexception) {
                LOGGER.debug("Failed to delete '{}'", (Object)diagramFile, (Object)ioexception);
            }
            throw new DiagramException("'" + commandLine + "' failed with exception " + exception);
        }
    }

    private static String getDisplayableCommand(String[] command) {
        StringBuilder displayable = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            displayable.append(command[i]);
            if (i + 1 >= command.length) continue;
            displayable.append(' ');
        }
        return displayable.toString();
    }
}

