/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram;

import java.io.File;
import org.schemaspy.output.diagram.DiagramException;
import org.schemaspy.output.diagram.DiagramProducer;
import org.schemaspy.output.diagram.DiagramResults;

public class DiagramFactory {
    private final DiagramProducer diagramProducer;
    private final File diagramDir;
    private final File tablesDir;
    private final File summaryDir;
    private final File orphansDir;

    public DiagramFactory(DiagramProducer diagramProducer, File outputDir) {
        this.diagramProducer = diagramProducer;
        this.diagramDir = new File(outputDir, "diagrams");
        this.tablesDir = new File(this.diagramDir, "tables");
        this.summaryDir = new File(this.diagramDir, "summary");
        this.orphansDir = new File(this.diagramDir, "orphans");
        this.createDirs();
    }

    private void createDirs() {
        this.diagramDir.mkdirs();
        this.tablesDir.mkdirs();
        this.summaryDir.mkdirs();
        this.orphansDir.mkdirs();
    }

    public String getImplementationDetails() {
        return this.diagramProducer.getImplementationDetails();
    }

    public String getDiagramFormat() {
        return this.diagramProducer.getDiagramFormat();
    }

    public DiagramResults generateOrphanDiagram(File dotFile, String diagramName) {
        try {
            File diagramFile = new File(this.orphansDir, diagramName + "." + this.diagramProducer.getDiagramFormat());
            String diagramMap = this.diagramProducer.generateDiagram(dotFile, diagramFile);
            return new DiagramResults(diagramFile, diagramMap, this.diagramProducer.getDiagramFormat());
        }
        catch (DiagramException diagramException) {
            throw new DiagramException("Failed to generate Orphan diagram", (Throwable)diagramException);
        }
    }

    public DiagramResults generateTableDiagram(File dotFile, String diagramName) {
        try {
            File diagramFile = new File(this.tablesDir, diagramName + "." + this.diagramProducer.getDiagramFormat());
            String diagramMap = this.diagramProducer.generateDiagram(dotFile, diagramFile);
            return new DiagramResults(diagramFile, diagramMap, this.diagramProducer.getDiagramFormat());
        }
        catch (DiagramException diagramException) {
            throw new DiagramException("Failed to generate Table diagram", (Throwable)diagramException);
        }
    }

    public DiagramResults generateSummaryDiagram(File dotFile, String diagramName) {
        try {
            File diagramFile = new File(this.summaryDir, diagramName + "." + this.diagramProducer.getDiagramFormat());
            String diagramMap = this.diagramProducer.generateDiagram(dotFile, diagramFile);
            return new DiagramResults(diagramFile, diagramMap, this.diagramProducer.getDiagramFormat());
        }
        catch (DiagramException diagramException) {
            throw new DiagramException("Failed to generate summary diagram", (Throwable)diagramException);
        }
    }
}

