/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.schemaspy.input.dbms.xml.TableColumnMeta;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;

public class TableColumn {
    private final Table table;
    private String name;
    private Object id;
    private String typeName;
    private String shortTypeName;
    private Integer type;
    private int length;
    private int decimalDigits;
    private String detailedSize;
    private boolean isNullable;
    private boolean isAutoUpdated;
    private Boolean isUnique;
    private Object defaultValue;
    private String comments;
    private final Map<TableColumn, ForeignKeyConstraint> parents = new HashMap();
    private final Map<TableColumn, ForeignKeyConstraint> children = new TreeMap(new ColumnComparator(this, null));
    private boolean allowImpliedParents = true;
    private boolean allowImpliedChildren = true;
    private boolean isExcluded = false;
    private boolean isAllExcluded = false;

    public TableColumn(Table table) {
        this.table = table;
    }

    public TableColumn(Table table, TableColumnMeta colMeta) {
        this.table = table;
        this.name = colMeta.getName();
        this.id = colMeta.getId();
        this.typeName = colMeta.getType();
        this.length = colMeta.getSize();
        this.decimalDigits = colMeta.getDigits();
        StringBuilder buf = new StringBuilder();
        buf.append(this.length);
        if (this.decimalDigits > 0) {
            buf.append(',');
            buf.append(this.decimalDigits);
        }
        this.detailedSize = buf.toString();
        this.isNullable = colMeta.isNullable();
        this.isAutoUpdated = colMeta.isAutoUpdated();
        this.defaultValue = colMeta.getDefaultValue();
        this.comments = colMeta.getComments();
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public String getShortTypeName() {
        return this.shortTypeName == null ? this.typeName : this.shortTypeName;
    }

    public void setShortType(String shortType) {
        this.shortTypeName = shortType;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public String getDetailedSize() {
        return this.detailedSize;
    }

    public void setDetailedSize(String detailedSize) {
        this.detailedSize = detailedSize;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public boolean isAutoUpdated() {
        return this.isAutoUpdated;
    }

    public void setIsAutoUpdated(boolean isAutoUpdated) {
        this.isAutoUpdated = isAutoUpdated;
    }

    public boolean isUnique() {
        if (this.isUnique == null) {
            for (TableIndex index : this.table.getIndexes()) {
                List indexColumns;
                if (!index.isUnique() || (indexColumns = index.getColumns()).size() != 1 || !indexColumns.contains(this)) continue;
                this.isUnique = true;
                break;
            }
            if (this.isUnique == null) {
                this.isUnique = this.table.getPrimaryColumns().size() == 1 && this.isPrimary();
            }
        }
        return this.isUnique;
    }

    public boolean isPrimary() {
        if (this.table.getPrimaryColumns() != null) {
            return this.table.getPrimaryColumns().contains(this);
        }
        return false;
    }

    public boolean isForeignKey() {
        return !this.parents.isEmpty();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments == null || comments.trim().length() == 0 ? null : comments.trim();
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.isExcluded = excluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public void setAllExcluded(boolean allExcluded) {
        this.isAllExcluded = allExcluded;
    }

    public void addParent(TableColumn parent, ForeignKeyConstraint constraint) {
        this.parents.put(parent, constraint);
        this.table.addedParent();
    }

    public void removeParent(TableColumn parent) {
        this.parents.remove(parent);
    }

    public void unlinkParents() {
        for (TableColumn parent : this.parents.keySet()) {
            parent.removeChild(this);
        }
        this.parents.clear();
    }

    public Set<TableColumn> getParents() {
        return this.parents.keySet();
    }

    public ForeignKeyConstraint getParentConstraint(TableColumn parent) {
        return (ForeignKeyConstraint)this.parents.get(parent);
    }

    public ForeignKeyConstraint removeAParentFKConstraint() {
        Iterator iterator = this.parents.keySet().iterator();
        if (iterator.hasNext()) {
            TableColumn relatedColumn = (TableColumn)iterator.next();
            ForeignKeyConstraint constraint = (ForeignKeyConstraint)this.parents.remove(relatedColumn);
            relatedColumn.removeChild(this);
            return constraint;
        }
        return null;
    }

    public ForeignKeyConstraint removeAChildFKConstraint() {
        Iterator iterator = this.children.keySet().iterator();
        if (iterator.hasNext()) {
            TableColumn relatedColumn = (TableColumn)iterator.next();
            ForeignKeyConstraint constraint = (ForeignKeyConstraint)this.children.remove(relatedColumn);
            relatedColumn.removeParent(this);
            return constraint;
        }
        return null;
    }

    public void addChild(TableColumn child, ForeignKeyConstraint constraint) {
        this.children.put(child, constraint);
        this.table.addedChild();
    }

    public void removeChild(TableColumn child) {
        this.children.remove(child);
    }

    public void unlinkChildren() {
        for (TableColumn child : this.children.keySet()) {
            child.removeParent(this);
        }
        this.children.clear();
    }

    public Set<TableColumn> getChildren() {
        return this.children.keySet();
    }

    public ForeignKeyConstraint getChildConstraint(TableColumn child) {
        return (ForeignKeyConstraint)this.children.get(child);
    }

    public boolean matches(Pattern regex) {
        return regex.matcher(this.getTable().getName() + '.' + this.getName()).matches();
    }

    public void update(TableColumnMeta colMeta) {
        String newComments = colMeta.getComments();
        if (newComments != null) {
            this.setComments(newComments);
        }
        if (!this.isPrimary() && colMeta.isPrimary()) {
            this.table.setPrimaryColumn(this);
        }
        this.allowImpliedParents = !colMeta.isImpliedParentsDisabled();
        this.allowImpliedChildren = !colMeta.isImpliedChildrenDisabled();
        this.isExcluded |= colMeta.isExcluded();
        this.isAllExcluded |= colMeta.isAllExcluded();
    }

    public String toString() {
        return this.getName();
    }

    public boolean allowsImpliedParents() {
        return this.allowImpliedParents;
    }

    public boolean allowsImpliedChildren() {
        return this.allowImpliedChildren;
    }
}

