/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ForeignKeyConstraint
implements Comparable<ForeignKeyConstraint> {
    private final String name;
    private Table parentTable;
    private final List<TableColumn> parentColumns = new ArrayList();
    private final Table childTable;
    private final List<TableColumn> childColumns = new ArrayList();
    private final int deleteRule;
    private final int updateRule;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ForeignKeyConstraint(Table child, String name, int updateRule, int deleteRule) {
        this.name = name;
        LOGGER.debug("Adding foreign key constraint '{}' to {}", (Object)this.getName(), (Object)child.getFullName());
        this.childTable = child;
        this.deleteRule = deleteRule;
        this.updateRule = updateRule;
    }

    public ForeignKeyConstraint(TableColumn parentColumn, TableColumn childColumn, int updateRule, int deleteRule) {
        this(childColumn.getTable(), null, updateRule, deleteRule);
        this.addChildColumn(childColumn);
        this.addParentColumn(parentColumn);
        childColumn.addParent(parentColumn, this);
        parentColumn.addChild(childColumn, this);
    }

    public ForeignKeyConstraint(TableColumn parentColumn, TableColumn childColumn) {
        this(parentColumn, childColumn, 3, 3);
    }

    public void addParentColumn(TableColumn column) {
        if (column != null) {
            this.parentColumns.add(column);
            this.parentTable = column.getTable();
        }
    }

    public void addChildColumn(TableColumn column) {
        if (column != null) {
            this.childColumns.add(column);
        }
    }

    public String getName() {
        return this.name;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public List<TableColumn> getParentColumns() {
        return Collections.unmodifiableList(this.parentColumns);
    }

    public Table getChildTable() {
        return this.childTable;
    }

    public List<TableColumn> getChildColumns() {
        return Collections.unmodifiableList(this.childColumns);
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public boolean isCascadeOnDelete() {
        return this.getDeleteRule() == 0;
    }

    public boolean isRestrictDelete() {
        return this.getDeleteRule() == 3 || this.getDeleteRule() == 1;
    }

    public boolean isNullOnDelete() {
        return this.getDeleteRule() == 2;
    }

    public String getDeleteRuleName() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete";
            }
            case 1: 
            case 3: {
                return "Restrict delete";
            }
            case 2: {
                return "Null on delete";
            }
        }
        return "";
    }

    public String getDeleteRuleDescription() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "Cascade on delete:\nDeletion of parent deletes child";
            }
            case 1: 
            case 3: {
                return "Restrict delete:\nParent cannot be deleted if children exist";
            }
            case 2: {
                return "Null on delete:\nForeign key to parent set to NULL when parent deleted";
            }
        }
        return "";
    }

    public String getDeleteRuleAlias() {
        switch (this.getDeleteRule()) {
            case 0: {
                return "C";
            }
            case 1: 
            case 3: {
                return "R";
            }
            case 2: {
                return "N";
            }
        }
        return "";
    }

    public int getUpdateRule() {
        return this.updateRule;
    }

    public boolean isImplied() {
        return false;
    }

    public boolean isReal() {
        return this.getClass() == ForeignKeyConstraint.class;
    }

    @Override
    public int compareTo(ForeignKeyConstraint other) {
        if (other == this) {
            return 0;
        }
        int rc = this.getName().compareToIgnoreCase(other.getName());
        if (rc == 0) {
            String ours = ((TableColumn)this.getChildColumns().get(0)).getTable().getContainer();
            String theirs = ((TableColumn)other.getChildColumns().get(0)).getTable().getContainer();
            rc = ours != null && theirs != null ? ours.compareToIgnoreCase(theirs) : (ours == null ? -1 : 1);
        }
        return rc;
    }

    public static String toString(List<TableColumn> columns) {
        if (columns.size() == 1) {
            return columns.iterator().next().toString();
        }
        return columns.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.childTable.getName());
        buf.append('.');
        buf.append(ForeignKeyConstraint.toString((List)this.childColumns));
        buf.append(" references ");
        if (this.parentTable.isRemote()) {
            buf.append(this.parentTable.getContainer());
            buf.append('.');
        }
        buf.append(this.parentTable.getName());
        buf.append('.');
        buf.append(ForeignKeyConstraint.toString((List)this.parentColumns));
        if (this.name != null) {
            buf.append(" via ");
            buf.append(this.name);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.childTable != ((ForeignKeyConstraint)obj).childTable) {
            return false;
        }
        return this.parentTable == ((ForeignKeyConstraint)obj).parentTable;
    }

    public int hashCode() {
        int result = this.parentTable != null ? this.parentTable.hashCode() : 0;
        result = 31 * result + (this.childTable != null ? this.childTable.hashCode() : 0);
        return result;
    }
}

