/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.io.File;
import java.util.Collection;
import org.schemaspy.Config;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;

public class ConsoleProgressListener
implements ProgressListener {
    private final CommandLineArguments commandLineArguments;
    private final boolean render;
    private long startedAt;
    private long startedGatheringAt;
    private long startedConnectingAt;
    private long startedGraphingSummariesAt;
    private long startedGraphingDetailsAt;
    private long finishedAt;

    public ConsoleProgressListener(boolean render, CommandLineArguments commandLineArguments) {
        this.render = render;
        this.commandLineArguments = commandLineArguments;
        this.startedAt = System.currentTimeMillis();
    }

    public long startedGatheringDetails() {
        this.startedGatheringAt = System.currentTimeMillis();
        long duration = this.startedAt - this.startedGatheringAt;
        if (this.render) {
            System.out.print("Gathering schema details...");
        }
        return duration;
    }

    public void gatheringDetailsProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    public long startedConnectingTables() {
        this.startedConnectingAt = System.currentTimeMillis();
        long duration = this.startedConnectingAt - this.startedGatheringAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + duration / 1000L + "sec)");
            System.out.print("Connecting relationships...");
        }
        return duration;
    }

    public void connectingTablesProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    public long startedGraphingSummaries() {
        this.startedGraphingSummariesAt = System.currentTimeMillis();
        long duration = this.startedGraphingSummariesAt - this.startedConnectingAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + duration / 1000L + "sec)");
            System.out.print("Writing/graphing summary");
            System.out.print('.');
        }
        return duration;
    }

    public void graphingSummaryProgressed() {
        if (this.render) {
            System.out.print('.');
        }
    }

    public long startedGraphingDetails() {
        this.startedGraphingDetailsAt = System.currentTimeMillis();
        long duration = this.startedGraphingDetailsAt - this.startedGraphingSummariesAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + duration / 1000L + "sec)");
            System.out.print("Writing/diagramming details");
        }
        return duration;
    }

    public void graphingDetailsProgressed(Table table) {
        if (this.render) {
            System.out.print('.');
        }
    }

    public long finishedGatheringDetails() {
        this.finishedAt = System.currentTimeMillis();
        long duration = this.finishedAt - this.startedGraphingDetailsAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("(" + duration / 1000L + "sec)");
        }
        return duration;
    }

    public long finished(Collection<Table> tables, Config config) {
        this.finishedAt = System.currentTimeMillis();
        long duration = this.finishedAt - this.startedAt;
        if (this.render) {
            System.err.flush();
            System.out.flush();
            System.out.println("Wrote relationship details of " + tables.size() + " tables/views to directory '" + this.commandLineArguments.getOutputDirectory() + "' in " + duration / 1000L + " seconds.");
            System.out.println("View the results by opening " + new File(this.commandLineArguments.getOutputDirectory(), "index.html"));
        }
        return duration;
    }

    public String recoverableExceptionEncountered(String msg, Exception exc, String sql) {
        System.out.println();
        System.out.flush();
        String text = msg + ": " + exc;
        if (sql != null) {
            text = text + ": " + sql;
        }
        return text;
    }
}

