/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.xml.TableMeta;
import org.schemaspy.model.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchemaMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<TableMeta> tables = new ArrayList();
    private final String comments;
    private final File metaFile;

    public SchemaMeta(String xmlMeta, String dbName, String schema) {
        File meta = new File(xmlMeta);
        if (meta.isDirectory()) {
            String filename = (schema == null ? dbName : schema) + ".meta.xml";
            if (!(meta = new File(meta, filename)).exists()) {
                if (Config.getInstance().isOneOfMultipleSchemas()) {
                    LOGGER.info("Meta directory \"{}\" should contain a file named \"{}\"", (Object)xmlMeta, (Object)filename);
                    this.comments = null;
                    this.metaFile = null;
                    return;
                }
                throw new InvalidConfigurationException("Meta directory \"" + xmlMeta + "\" must contain a file named \"" + filename + '\"');
            }
        } else if (!meta.exists()) {
            throw new InvalidConfigurationException("Specified meta file \"" + xmlMeta + "\" does not exist");
        }
        this.metaFile = meta;
        Document doc = this.parse(this.metaFile);
        NodeList commentsNodes = doc.getElementsByTagName("comments");
        this.comments = commentsNodes != null && commentsNodes.getLength() > 0 && commentsNodes.item(0).hasChildNodes() ? commentsNodes.item(0).getTextContent() : null;
        NodeList tablesNodes = doc.getElementsByTagName("tables");
        if (tablesNodes != null) {
            NodeList tableNodes = ((Element)tablesNodes.item(0)).getElementsByTagName("table");
            for (int i = 0; i < tableNodes.getLength(); ++i) {
                Node tableNode = tableNodes.item(i);
                TableMeta tableMeta = new TableMeta(tableNode);
                this.tables.add(tableMeta);
            }
        }
    }

    public String getComments() {
        return this.comments;
    }

    public File getFile() {
        return this.metaFile;
    }

    public List<TableMeta> getTables() {
        return this.tables;
    }

    private void validate(Document document) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream xsl = this.getClass().getResourceAsStream("/schemaspy.meta.xsd");
        Schema schema = factory.newSchema(new StreamSource(xsl));
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        validator.validate(new DOMSource(document));
    }

    private Document parse(File file) {
        Document doc;
        DocumentBuilder docBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn("Failed to enable secure processing for DocumentBuilderFactory", (Throwable)e);
        }
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new InvalidConfigurationException("Invalid XML parser configuration", (Throwable)exc);
        }
        try {
            LOGGER.info("Parsing {}", (Object)file);
            doc = docBuilder.parse(file);
        }
        catch (SAXException exc) {
            throw new InvalidConfigurationException("Failed to parse " + file, (Throwable)exc);
        }
        catch (IOException exc) {
            throw new InvalidConfigurationException("Could not read " + file + ":", (Throwable)exc);
        }
        try {
            this.validate(doc);
        }
        catch (IOException | SAXException exc) {
            LOGGER.warn("Failed to validate {}: {}", (Object)file, (Object)exc);
        }
        return doc;
    }
}

