/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.DbDriverLoader;
import org.schemaspy.input.dbms.service.DbmsService;
import org.schemaspy.model.Database;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DbmsService dbmsService = new DbmsService();
    private Connection connection;
    private DatabaseMetaData databaseMetaData;
    private DbmsMeta dbmsMeta;
    private Pattern invalidIdentifierPattern;
    private Set<String> allKeywords;

    public DatabaseMetaData connect(Config config) throws IOException, SQLException {
        DbDriverLoader driverLoader = new DbDriverLoader();
        this.connection = driverLoader.getConnection(config);
        this.databaseMetaData = this.connection.getMetaData();
        this.dbmsMeta = this.dbmsService.fetchDbmsMeta(this.databaseMetaData);
        this.invalidIdentifierPattern = SqlService.createInvalidIdentifierPattern((DatabaseMetaData)this.databaseMetaData);
        this.allKeywords = this.dbmsMeta.getAllKeywords();
        if (config.isEvaluateAllEnabled()) {
            return null;
        }
        return this.databaseMetaData;
    }

    private static Pattern createInvalidIdentifierPattern(DatabaseMetaData databaseMetaData) throws SQLException {
        StringBuilder validChars = new StringBuilder("a-zA-Z0-9_");
        String reservedRegexChars = "-&^";
        String extraValidChars = databaseMetaData.getExtraNameCharacters();
        for (int i = 0; i < extraValidChars.length(); ++i) {
            char ch = extraValidChars.charAt(i);
            if (reservedRegexChars.indexOf(ch) >= 0) {
                validChars.append("\\");
            }
            validChars.append(ch);
        }
        return Pattern.compile("[^" + validChars + "]");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData;
    }

    public DbmsMeta getDbmsMeta() {
        return this.dbmsMeta;
    }

    public PreparedStatement prepareStatement(String sql, Database db, String tableName) throws SQLException {
        StringBuilder sqlBuf = new StringBuilder(sql);
        List sqlParams = SqlService.getSqlParams((StringBuilder)sqlBuf, (String)db.getName(), (String)db.getCatalog().getName(), (String)db.getSchema().getName(), (String)tableName);
        LOGGER.debug("{} {}", (Object)sqlBuf, (Object)sqlParams);
        PreparedStatement stmt = this.connection.prepareStatement(sqlBuf.toString());
        try {
            for (int i = 0; i < sqlParams.size(); ++i) {
                stmt.setString(i + 1, (String)sqlParams.get(i));
            }
        }
        catch (SQLException exc) {
            stmt.close();
            throw exc;
        }
        return stmt;
    }

    private static List<String> getSqlParams(StringBuilder sql, String dbName, String catalog, String schema, String tableName) {
        HashMap<String, String> namedParams = new HashMap<String, String>();
        if (Objects.isNull(schema)) {
            schema = dbName;
        }
        namedParams.put(":dbname", dbName);
        namedParams.put(":schema", schema);
        namedParams.put(":owner", schema);
        if (Objects.nonNull(tableName)) {
            namedParams.put(":table", tableName);
            namedParams.put(":view", tableName);
        }
        if (Objects.nonNull(catalog)) {
            namedParams.put(":catalog", catalog);
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        int nextColon = sql.indexOf(":");
        while (nextColon != -1) {
            String paramName = new StringTokenizer(sql.substring(nextColon), " ,\"')").nextToken();
            String paramValue = (String)namedParams.get(paramName);
            if (Objects.isNull(paramValue)) {
                throw new InvalidConfigurationException("Unexpected named parameter '" + paramName + "' found in SQL '" + sql + "'");
            }
            sqlParams.add(paramValue);
            sql.replace(nextColon, nextColon + paramName.length(), "?");
            nextColon = sql.indexOf(":", nextColon);
        }
        return sqlParams;
    }

    public PreparedStatement prepareStatement(String sqlQuery) throws SQLException {
        return this.connection.prepareStatement(sqlQuery);
    }

    public String getQualifiedTableName(String catalog, String schema, String tableName, boolean forceQuotes) {
        String schemaOrCatalog = this.getSchemaOrCatalog(Optional.ofNullable(schema).orElse(catalog), forceQuotes);
        if (forceQuotes) {
            return schemaOrCatalog + this.quoteIdentifier(tableName);
        }
        return schemaOrCatalog + this.getQuotedIdentifier(tableName);
    }

    private String getSchemaOrCatalog(String schemaOrCatalog, boolean forceQuotes) {
        if (Objects.isNull(schemaOrCatalog)) {
            return "";
        }
        if (forceQuotes) {
            return this.quoteIdentifier(schemaOrCatalog) + ".";
        }
        return this.getQuotedIdentifier(schemaOrCatalog) + ".";
    }

    public String getQuotedIdentifier(String id) {
        boolean quotesRequired;
        Matcher matcher = this.invalidIdentifierPattern.matcher(id);
        boolean bl = quotesRequired = matcher.find() || this.allKeywords.contains(id);
        if (quotesRequired) {
            return this.quoteIdentifier(id);
        }
        return id;
    }

    public String quoteIdentifier(String id) {
        String quote = this.dbmsMeta.getIdentifierQuoteString();
        return quote + id + quote;
    }
}

